 	.TITLE	SCSI.ASD
iofnorm	=	TRUE

	.REF	SMAKY
	.REF	MON
	.REF	BIOSDRIV
	.REF	BIOS

	.REF	WD33C93
	.REF	SCSI
	.BASE	10'10
	.LAYOUT	LENGTH	0


Implemented	= false
Debug		= false
Affiche 	= false
RejectRMB	= false
WithTrap	= false
WithMsgErr	= false
WithMsgControl	= false

MajRev		= 9		; rvision majeure
MinRev		= 4		; rvision mineure
DvRv		= 0		; rvision de dveloppement

Rev09_01	= (09*16'100)+01
Rev09_02	= (09*16'100)+02
CurRev		= (MajRev*16'100)+MinRev

; MW  12.08.97  Version 9.4
; Le Reset sur un driver dont le disque n'est pas prsent faisait
; un ?UNLOCK sur un smaphore dtruit, ce qui faisait planter
; la version debug du NTR.
;
; DM  09.04.95	Version 9.3
; Rcriture de la routine xferdata dans SCSIFILS.ASI
; Gain de vitesse d'environ 40% sur les disques "rapides"
; (Quantum 270MB passe de ~394 KB/s  ~550 KB/s, SyQuest de ~372  ~515)
;
; JFG 04.11.94	Version 9.2
; Correction de la version prcdente. On utilisait Extended dans tous les cas
; Correction du problme de timeout NULL
;
; JFG 19.10.94	Version 9.1
; Suppression de l'utilisation de ReadExtended et de WriteExtended



	.ins	testmachine.asi
	TESTmachine		; initialise les variables machine-dpendantes
.IF	.NOT.SM100
	.PROC	M68020
.ELSE
	.PROC	M68000
.ENDIF	SM100
	.REV	MajRev, MinRev


	.IF		sm300
	.IDENT	"Driver asynchrone WD33C93A pour Smaky 300, (C) Jean-Franois Gruet & EPSITEC System SA"
	.ENDIF		sm300

	.IF		sm324
	.IDENT	"Driver asynchrone WD33C93/A pour Smaky 324, (C) Jean-Franois Gruet & EPSITEC System SA"
	.ENDIF		sm324

	.IF		sm100
	.IDENT	"Driver asynchrone WD33C93/A pour Smaky 100, (C) Jean-Franois Gruet & EPSITEC System SA"
	.ENDIF		sm100

	.IF		sm130
	.IDENT	"Driver asynchrone WD33C93/A pour Smaky 130, (C) Jean-Franois Gruet & EPSITEC System SA"
	.ENDIF		sm130

	.IF		sm196
	.IDENT	"Driver asynchrone WD33C93/A pour Smaky 196, (C) Jean-Franois Gruet & EPSITEC System SA"
	.ENDIF		sm196

	.IF		CO2
	.IDENT	"Driver asynchrone WD33C93/A pour COSTRONIC, (C) Jean-Franois Gruet & EPSITEC System SA"
	.ENDIF		CO2




; Dfinition des divers APC
; -------------------------

pcCode	=	0	; APC pour le code du driver
pcOffset=	1	; APC pour les dfinitions
PCVar	=	2	; APC pour les variables


	.APC	pcCode
	.LOC	0
	.APC	pcVar
	.LOC	0
	.APC	pcOffset
	.LOC	0

	.if	Sm300
	.REF	SM300HARD
VectSCSI	=	AdVectScsi/4
AA		=	AdScsiControl
AD		=	AdScsiData
	.ref	shidriv300
noDisconnect = true
	.ENDIF	Sm300

	.IF	sm130
	.REF	SM130HARD
VectSCSI	=	AdVectScsi/4
AA		=	AdScsiControl
AD		=	AdScsiData
	.ref	shidriv130
noDisconnect = true	; supprime toute dconnection intermdiaire si true
	.endif	sm130

	.if	Sm324
	.ref	sm324hard
	.ref	shidriv324
VectScsi	=	16'70;	AdVectScsi/4
AdVectScsi	=	4*VectScsi
AdScsiControl	=	AdScsi
AdScsiData	=	AdScsi+1
noDisconnect = true
	.endif

	.IF	Sm100
AdVectSCSIOld	=	(2**7+2**6+2**1)*4	; 
AdVectSCSIMid 	=	(2**6+2**1)*4		; ancienne adresse du vecteur SCSI
AdVectSCSI 	=	(2**5+2**4+2**3+2**2+2**1)*4
AdScsiControl	=	16'FFE000+1
AdScsiData	=	AdScsiControl+2
noDisconnect = true
	.REF	SHIDRIV100
	.ENDIF	Sm100

.if	CO2
ADPER		=	16'FFFFF000
ADSCC		=	ADPER+16'1	; interfaces srie
  OSCCINTACK	=	1*(2**2)+1*(2**0) ; A2=1 A0=0 !!! MOVE.16 !!!
					  ; Lecture vecteur interrupt SCC
ADVECTSCC	=	ADSCC+OSCCINTACK
PIC2		=	ADPER+16'140
PIC2_IER	=	PIC2+2
PIC2_ISR	=	PIC2+3
PIC2_IVR	=	PIC2_ISR
PIC2_IMR	=	PIC2+1
 PIC2_vector	=	16'100/4+8
PIC2_vZNET	=	(108+7)/4
bPIC2_SCSI	=	3
ADSCSI		=	ADPER
 PIC2_vSCSI	=	PIC2_vector+3

VSCSI	=	PIC2_vSCSI*4
AdScsiControl	=	ADSCSI		; adresse du registre d'adresse du WD33C93
AdScsiData	=	ADSCSI+2	; adresse du registre de data du WD33C93
.ENDIF	CO2



	.ins	scsiMacro.asi
	.ins	scsiConst.asi
	.ins	scsiStruct.asi
	.ins	scsiVar.asi
;	.ins	scsifils.asi
	.ins	scsiHead.asi
	.ins	scsiCall.asi
	.ins	scsiUtil.asi
	.ins	scsiBarDbg.asi
	.if	Debug
	.ins	scsiDebug.asi
	.endif	Debug
	.ins	scsiInit.asi
	.ins	scsiInt.asi
	.ins	scsiExec.asi
;	.ins	#mm0:cdrom:scsiFils.asi
	.ins	scsiFils.asi
	.ins	scsiWinch.asi
	.ins	scsiCom.asi
;	.ins	scsiFils.asi
	.APC	pcVar
	.EVEN
LgGlobVar:
	.END
