	.TITLE	SYNT.ASD

;	--------------------------------------
;		(C) 1990 - Daniel Roux
;	--------------------------------------

;	Source des pilotes 300_SYNT.DRIV et 130_SYNT.DRIV
;	Installe et utilise le pilote $AUDIO !


	.PROC	M68020

	.REF	SMAKY
	.REF	MODULES
	.REF	BIOSDRIV

	.BASE	10'10
	.LAYOUT	HEX


;	Date		Amliorations
; ------------------------------------------------------------------------
; 0.9	10.05.95	PA: Rduit les textes de debug.
;			PA: Dans AUDIOREAD, rend la mmoire si erreur.
; 0.8	29.07.94	DM: Traduction en CALM.
;			DM: Supression des 10'000 points d'entre.
;			DM: Ajout qq pilotes pour Smaky 130 couleur.
; 0.7	02.07.93	130: si K1 et AUDIO absent -> mode simple
; 0.6	07.07.92	130: correction blocage
; 0.5	22.06.92	130: choix du volume
; 0.4	10.06.92	130: version sans K1 (donc sans AUDIO)
; 0.3	09.04.92	130: premire version
; 0.2	15.10.91	BIPFAT et BIP ERR ok
; ------------------------------------------------------------------------



MAJREV	=	0			; rvision
MINREV	=	9			; version

	.REV	MAJREV,MINREV




TOTO	=	0			; 1 => pilote de test (300_TOTO.DRIV)

SM300	=	0			; 1 => 300_SYNT.DRIV
SM130	=	1			; 1 => 130_SYNT.DRIV


	.IF	SM130
; Dfinitions du hardware SMAKY130
; --------------------------------

_SETFREQSON=	16'28
_INITINTSON=	16'24
_INITINT256HZ=	16'54
_GETCONFIGHARD=	16'50

ClaK1	=	1			; clavier avec K1
ClaBal	=	0			; calvier balay par Smaky

ADSON	=	16'FFFF8380
ADMODEHP=	16'FFFF9FF0
ADMODESONMOYEN=	16'FFFF9FE0
ADMODESONFORT=	16'FFFF9FE8
ADRZNMI	=	16'FFFF9FD8

; Variables absolues
; ------------------

SoundData=	16'10A6			; data pour signal carr
	.ENDIF



; Constantes
; ----------

MAXPIL	=	18			; nb max de pilotes $SYNT
MAXNIV	=	256			; niveau maximum
MAXSON	=	5			; 5 secondes au maximum !
MAXFIFO	=	100			; nb max de bytes dans fifo

	.IF	TOTO
NOBASE	=	16'E0			; numro de base
	.ELSE
NOBASE	=	16'40			; numro de base
	.ENDIF

BIPAUDIO=	16'FE			; son audio
BIPCLOSE=	16'FF			; ferme le pilote AUDIO

	.IF	SM300
FREQ	=	ADFREQ
	.ENDIF
	.IF	SM130
FREQ	=	ADFREQ/2
	.ENDIF



; Dfinition de l'entte d'un FIFO
; --------------------------------

	.LOC	0
OFIHEAD:.BLK.8	4			; ^tte
OFITAIL:.BLK.8	4			; ^queue
OFIBEG:	.BLK.8	4			; adresse absolue dbut buffer
OFIEND:	.BLK.8	4			; adresse absolue fin buffer
LGFIFO:


;	{A0}------|
;	   |--->|-------|
;   OFIHEAD	|	|	^tte
;		|-------|
;   OFITAIL	|	|	^queue
;		|-------|
;   OFIBEG	|	|-------|
;		|-------|	|
;   OFIEND	|	|-------+-------|
;		|-------|	|	|
;		|	|<------|	|
;		|	|		|
;		|   F	|		|
;		|   I	|		|
;		|   F	|		|
;		|   O	|		|
;		|	|		|
;		|	|		|
;		|-------|		|
;			 <--------------|




; Dfinition des variables globales
; ---------------------------------

	.LOC	0
OFIFO:	.BLK.8	LGFIFO+MAXFIFO		; fifo pour les commandes
OPSEM0:	.BLK.8	4			; ^smaphore d'exclusion
OPSEM1:	.BLK.8	4			; ^smaphore pour write fifo
OPSEM2:	.BLK.8	4			; ^smaphore synhro avec fils

OLEVEL:	.BLK.8	1			; niveau du volume (0..4)
	.EVEN
	.IF	SM130
OSIMPL:	.BLK.8	1			; 1 => simple (sans AUDIO)
OK1:	.BLK.8	1			; 1 => co-processeur K1 prsent
OSDATA:	.BLK.8	1			; data pour signal carr
	.EVEN
	.ENDIF
OVLOC:	.BLK.8	4*MAXPIL		; ^variables locales des pilotes $SYNT_n
OCHA:	.BLK.8	2			; canal #AUDIO:
OAUDPF:	.BLK.8	4			; audio: ^fichier
OAUDLF:	.BLK.8	4			; audio: lg fichier
	.BLK.8	LADH			; buffer pour en-tte (juste avant OBBUFF)
OBBUFF:	.BLK.8	FREQ*MAXSON		; big buffer pour sons
LGGLOB:



; Dfinition des variables locales
; --------------------------------

	.LOC	0
OLEVHP:	.BLK.8	1			; "niveau" du haut-parleur
OFLAG0:	.BLK.8	1			; flags divers
ONWAIT:	.BLK.8	2			; nb de bytes attendus
LGVAR:


;@DM 29/7/94
; Macro pour gnrer un en-tte de driver
; ---------------------------------------

   .MACRO _Header
   .LOCALMACRO Start, Name

Start:
	.16	SnOPEN-S%1BASE
	.16	SnCOMMAND-S%1BASE
	.16	SnRSTATUS-S%1BASE
	.16	-1			; S0READ-S0BASE
	.16	SnWRITE-S%1BASE
	.16	SnCLOSE-S%1BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1			; S0AUX1-S0BASE
	.16	-1			; S0AUX2-S0BASE
      .IF %1.EQ.0
	.16	S0RESET-S0BASE
	.16	S0KILL-S0BASE
      .ELSE
	.16	SnRESET-S%1BASE
	.16	SnKILL-S%1BASE
      .ENDIF
	.16	-1			; S0STRT-S0BASE
	.16	-1			; S0TSTRT-S0BASE
	.16	-1			; S0START-S0BASE

      .IF	TOTO
Name:	.ASCII	"TOTO_%1"		; Nom driver
      .ELSE
Name:	.ASCII	"SYNT_%1"		; Nom driver
      .ENDIF
	.FILL.8	LGDNAM-(APC-Name),0

	.8	%2			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	0,0			; Rvision - version -
	.16	0			; - Variante

	.8	0			; Attribut 1
	.8	2**BDWROK.OR.2**BDNORT	; Attribut 0

	.FILL.8	LGDDESC-(APC-Start),0	; Le reste.
S%1BASE:
	.16	%1			; numro logique
LASTDRIV == %1
   .ENDMACRO
;@DM 29/7/94


	.LOC	0
DEBUT:
	.16	0,S0BASE
	.16	1,S1BASE
	.16	2,S2BASE
	.16	3,S3BASE
	.16	4,S4BASE
	.16	5,S5BASE
	.16	6,S6BASE
	.16	7,S7BASE
	.16	8,S8BASE
	.16	9,S9BASE
	.16	10,S10BASE
	.16	11,S11BASE
	.16	12,S12BASE
	.16	13,S13BASE
;@DM 29/7/94
	.16	14,S14BASE
	.16	15,S15BASE
	.16	16,S16BASE
	.16	17,S17BASE
;@DM 29/7/94
	.16	2**7

	_Header 0,NOBASE
	_Header 1,NOBASE+1
	_Header 2,NOBASE+2
	_Header 3,NOBASE+3
	_Header 4,NOBASE+4
	_Header 5,NOBASE+5
	_Header 6,NOBASE+6
	_Header 7,NOBASE+7
	_Header 8,NOBASE+8
	_Header 9,NOBASE+9
	_Header 10,NOBASE+10
	_Header 11,NOBASE+11
	_Header 12,NOBASE+12
	_Header 13,NOBASE+13
;@DM 29/7/94
	_Header 14,NOBASE+14
	_Header 15,NOBASE+15
	_Header	16,16'98
	_Header	17,16'9A
; @DM : la tranche 16'98  16'9f est disponible pour le SYNT ...

	.IF	(LastDriv+1).NE.MAXPIL
	.ERROR	"Nombre max de pilotes (MAXPIL) faux !!!"
	.ENDIF
;@DM 29/7/94


;----------\\
;  SnRESET  >
;==========/

; in	A0.32	^base du driver
;	A2.32	^paramtres
; out	A6.32	^variables globales
;	D7.16	erreur
; mod	D0..A1, D7.16, A6.32

S0RESET:
	PUSHM.32 D3..D6|A2..A5

	MOVE.32	#R16^DEBUT,A4
	MOVE.32	#LGGLOB,D4
	FOS	?GETCOMMEM		; demande mmoire globale
	JUMP,NE	EXIT$
	MOVE.32	A4,A6			; A6 <-- ^variables globales

	MOVE.32	#LGVAR,D4
	MOVE.32	#MTYPBD,D1
	MOVE.32	#R16^S0BASE,A1
	GESMEM	?GETMEM
	JUMP,NE	EXIT$
	GESMEM	?CLEARMEM
	MOVE.32	A4,A0			; A0 <-- ^variables locales
	MOVE.32	A0,{A6}+OVLOC+(4*0)

	MOVE.8	#SGLEV2,{A0}+OLEVHP	; init par dfaut
	MOVE.32	A2,D0			; A2 = zro ?
	JUMP,EQ	R8^LEVEL$		; oui => LEVEL$
	MOVE.8	{A2}+1,{A0}+OLEVHP	; non => init selon user
LEVEL$:
	MOVE.32	#4,D3
	CALL	COMVOLUME		; met le volume maximum

	.IF	SM130
	MOVE.32	#16'1000000*"C"+16'10000*"L"+16'100*"A"+16'1*SPACE,D4
	MOVE.32	_INDSHI,A4
	CALL	{A4}+_GETCONFIGHARD
	COMP.32	#CLAK1,D4		; y a-t-il un co-processeur K1 ?
	JUMP,NE	R8^SIMPL$		; non => SIMPL$
	SET.8	{A6}+OK1		; indique K1 prsent

	MOVE.32	#R16^NMLO,A3		; A3 <-- ^nom logique
	MOVE.32	#R16^NMPH,A4		; A4 <-- ^nom physique
	MOVE.32	#R16^NIL$,A2		; A2 <-- ^paramtres (rien)
	CLR.16	D3			; D3 <-- pour tout le monde
	FOS	?INSTALL		; installe $AUDIO:
	JUMP,EQ	R8^FIFO$

	SET.8	ADRZNMI			; enable NMI
SIMPL$:
	SET.8	{A6}+OSIMPL		; n'utilise pas le pilote AUDIO !
	.ENDIF

	.IF	SM300
	MOVE.32	#R16^NMLO,A3		; A3 <-- ^nom logique
	MOVE.32	#R16^NMPH,A4		; A4 <-- ^nom physique
	MOVE.32	#R16^NIL$,A2		; A2 <-- ^paramtres (rien)
	CLR.16	D3			; D3 <-- pour tout le monde
	FOS	?INSTALL		; installe $AUDIO:
	JUMP,NE	R8^EXIT$
	.ENDIF
FIFO$:
	CALL	INIFIFO			; init et vide le fifo

	MOVE.32	#1,D4			; D4 <-- valeur "e" initiale
	NTREL	?CRESEM			; cre un smaphore
	JUMP,NE	R8^EXIT$
	MOVE.32	A5,{A6}+OPSEM0		; init ^au smaphore

	MOVE.32	#MAXFIFO-2,D4		; D4 <-- valeur "e" initiale
	NTREL	?CRESEM			; cre un smaphore
	JUMP,NE	R8^EXIT$
	MOVE.32	A5,{A6}+OPSEM1		; init ^au smaphore

	MOVE.32	#0,D4			; D4 <-- valeur "e" initiale
	NTREL	?CRESEM			; cre un smaphore
	JUMP,NE	R8^EXIT$
	MOVE.32	A5,{A6}+OPSEM2		; init ^au smaphore

	MOVE.32	#R16^PROCFILS,A5
	MOVE.32	#R16^NAMEFILS,A3
	MOVE.32	#3.OR.2**BTDRIV,D4	; D4 <-- priorit + mode superviseur
	MOVE.32	#100,D5			; D5 <-- lg stack
	NTREL	?CRETASK		; cre le processus fils
EXIT$:
	POPM.32	D3..D6|A2..A5
	RET

NIL$:	.8	0
	.EVEN


SnRESET:
;@DM 29/7/94
	MOVE.16	{A0},D0			; D0 <- no logique du driver
	MOVE.32	A0,A1			; A1 <- ^base du driver
;@DM 29/7/94

	PUSHM.32 D4|A4

	MOVE.32	#R16^DEBUT,A4
	MOVE.32	#LGGLOB,D4
	FOS	?GETCOMMEM		; demande mmoire globale
	JUMP,NE	R8^EXIT$
	MOVE.32	A4,A6			; A6 <-- ^variables globales

	MOVE.32	#LGVAR,D4
	MOVE.32	#MTYPBD,D1
	GESMEM	?GETMEM
	JUMP,NE	R8^EXIT$
	GESMEM	?CLEARMEM
;@DM 29/07/93
;#####	MOVE.32	A4,{A6}+A16^{D0}	; OVLOC <-- mm ^variables locales
	MOVE.32	A4,{A6}+A16^{D0}*4+OVLOC ; OVLOC <-- mm ^variables locales
;@DM 29/7/94
	MOVE.32	A4,A0			; A0 <-- ^variables locales

	MOVE.8	#SGLEV2,{A0}+OLEVHP	; init par dfaut
	MOVE.32	A2,D0			; A2 = zro ?
	JUMP,EQ	R8^LEVEL$		; oui => LEVEL$
	MOVE.8	{A2}+1,{A0}+OLEVHP	; non => init selon user
LEVEL$:
;	CLR.8	{A0}+OFLAG0
;	CLR.16	{A0}+ONWAIT
	CLR.16	D7			; D7 <-- ok
EXIT$:
	POPM.32	D4|A4
	TEST.16	D7			; retour EQ/NE
	RET



;---------\\
;  SnKILL  >
;=========/

; in	A0.32	^base du driver
;	A6.32	^variables
; out	D7.16	erreur
; mod	D0..A1, D7.16

S0KILL:
	MOVE.16	#ERILLO,D7		; KILL $SYNT_0 impossible !!!
	RET


SnKILL:
;@DM 29/7/94
	MOVE.32	A0,A1			; A1 <- ^base du driver
	MOVE.16	{A0},D0			; D0 <- no logique du pilote
	MOVE.32	{A6}+A16^{D0}*4+OVLOC,A0; A0 <- ^vars locales
;@DM 29/7/94

	PUSH.32 A4

	TEST.16	{A0}+ONWAIT		; ordre multiple attendu ?
	JUMP,NE	R8^FATKIL		; oui => c'est grve ...

	MOVE.32	A0,A4
	MOVE.32	#MTYPBD,D1
	GESMEM	?GIVMEM			; libre les variables locales

	POP.32	A4
	CLR.16	D7			; D7 <-- ok
	RET

FATKIL:
	.16	16'A042
	.ASCIZ	"$SYNT:KILL<CR>"
	.EVEN
	TRAP	#0




;------------\\
;  SnCOMMAND  >
;============/

; Excute une liste de commandes.
;
;	0,1,2,3	-->	niveau des bips systmes
;	 +	-->	bips systmes selon 300_SYNT.AUDIO
;	 -	-->	bits systmes tous simples

; in	A0.32	^base du driver
;	A6.32	^variables
;	A4.32	^table des commandes termine par zro
; out	D7.16	erreur
; mod	D0..A1, D7.16


SnCOMMAND:
;@DM 29/7/94
	MOVE.16	{A0},D0			; D0 <- no logique du pilote
	MOVE.32	{A6}+A16^{D0}*4+OVLOC,A0; A0 <- ^vars locales
;@DM 29/7/94

	PUSHM.32 D3|A4
LOOP$:
	MOVE.8	{A4+},D3		; D3 <-- une commande
	JUMP,EQ	R8^EXIT$
	CALL	WRONEC			; excute une commande
	JUMP,EQ	LOOP$
EXIT$:
	POPM.32	D3|A4
	RET



;---------\\
;  SnOPEN  >
;=========/

; in	A0.32	^base du driver
;	A6.32	^variables
; out	D7.16	erreur
; mod	D0..A1, D7.16


SnOPEN:
;@DM 29/7/94
.IF FALSE ; (sert  rien puisqu'on fait RET)
	MOVE.16	{A0},D0			; D0 <- no logique du pilote
	MOVE.32	{A6}+A16^{D0}*4+OVLOC,A0; A0 <- ^vars locales
.ENDIF FALSE
;@DM 29/7/94
	RET



;----------\\
;  SnCLOSE  >
;==========/

; in	A0.32	^base du driver
;	A6.32	^variables
; out	D7.16	erreur
; mod	D0..A1, D7.16


SnCLOSE:
;@DM 29/7/94
	MOVE.16	{A0},D0			; D0 <- no logique du pilote
	MOVE.32	{A6}+A16^{D0}*4+OVLOC,A0; A0 <- ^vars locales
;@DM 29/7/94
	CALL	D0LOCK			; dbut zone critique !

	MOVE.16	#BIPCLOSE,D0
	CALL	WRFIFO			; met byte dans le fifo
	CALL	D2SIGNAL		; signal nouvel ordre l

	CALL	D0UNLOCK		; fin zone critique !
	CLR.16	D7			; D7 <-- ok
	RET



;------------\\
;  SnRSTATUS  >
;============/

; in	A0.32	^base du driver
;	A6.32	^variables
;	A4.32	^buffer
;	D4.32	longueur buffer
; out	D4.32	longueur rendue effectivement
;	D7.16	erreur
; mod	D0..A1, D7.16

SnRSTATUS:
	MOVE.16	#ERILLO,D7		; D7 <-- "commande illgale"
	RET



;----------\\
;  SnWRITE  >
;==========/

; in	A0.32	^base du driver
;	A6.32	^variables
;	A4.32	^buffer
;	A1.32	^liste de terminateurs
;	D5.32	nombre de bytes  crire
; out	D5.32	nombre de bytes crits
;	D7.16	erreur
; mod	D0..A1, D7.16, D5.32


SnWRITE:
;@DM 29/7/94
	MOVE.16	{A0},D0			; D0 <- no logique du pilote
	MOVE.32	{A6}+A16^{D0}*4+OVLOC,A0; A0 <- ^vars locales
;@DM 29/7/94
	PUSHM.32 D3|D4|A4

	MOVE.32	D5,D4
	JUMP,EQ	R8^EXIT$
LOOP$:
	CLR.16	D3
	MOVE.8	{A4+},D3		; D3 <-- un caractre
	CALL	WRONEB			; crit un byte

	DEC.32	D4
	JUMP,NE	LOOP$
EXIT$:
	SUB.32	D4,D5			; D5 <-- nb caractres crits

	POPM.32	D3|D4|A4
	CLR.16	D7			; D7 <-- retour EQ
	RET




;--------\\
; WRONEC  >
;========/

; in	D3.8	commande  effectuer
;	A4.32	^commandes
; out	A4.32	^plus loin
;	D7.16	erreur
; mod	D3.8, D7.16, A4.32

WRONEC:
	PUSHM.32 D1|D4|A1|A2..A4

	MOVE.32	A4,A2			; A2 <-- ^commandes
	MOVE.16	#ERILLO,D7		; D7 <-- commande incorrecte

	COMP.8	#"A",D3
	JUMP,LO	R8^NOVOL$
	COMP.8	#"E",D3
	JUMP,LS	R8^VOLUME$
NOVOL$:
	COMP.8	#"F",D3
	JUMP,EQ	R8^FILE$

	COMP.8	#SGLEV3,D3
	JUMP,LS	R8^LEVEL$

	SUB.8	#"0",D3
	JUMP,LO	R8^EXIT$

	COMP.8	#SGLEV3,D3
	JUMP,HI	R8^EXIT$
LEVEL$:
	MOVE.8	D3,{A0}+OLEVHP
	JUMP	R8^OK$

VOLUME$:
	SUB.8	#"A",D3			; D3 <-- 0..4
	CALL	COMVOLUME		; modifie le volume
	JUMP	R8^OK$

FILE$:
	TEST.32	{A6}+OAUDPF
	JUMP,EQ	R8^FREAD$
	MOVE.32	{A6}+OAUDPF,A4
	MOVE.32	#R16^S0BASE,A1
	MOVE.32	#MTYPBD,D1
	GESMEM	?GIVMEM			; libre le fichier prcdent
	CLR.32	{A6}+OAUDPF
FREAD$:
	COMP.8	#"+",{A2+}
	JUMP,NE	R8^OK$
	.IF	SM130
	TEST.8	{A6}+OSIMPL		; utilise le pilote AUDIO ?
	JUMP,T	R8^OK$			; non => OK$
	.ENDIF
	MOVE.32	#R16^NMAUDIO,A3
	CALL	AUDIOREAD		; lit le fichier 300_SYNT.AUDIO
	JUMP,NE	R8^EXIT$
	MOVE.32	A4,{A6}+OAUDPF
	MOVE.32	D4,{A6}+OAUDLF
OK$:
	CLR.16	D7			; D7 <-- ok
EXIT$:
	MOVE.32	A2,A4			; A4 <-- ^commandes

	POPM.32	D1|D4|A1|A2..A4
	TEST.16	D7			; retour EQ/NE
	RET

;----------\\
; COMVOLUME >
;----------/

; Modifie le niveau gnral.

; in	D3.8	niveau (0..4)
; out	-
; mod	D7.16

COMVOLUME:
	MOVE.8	D3,{A6}+OLEVEL

	.IF	SM130
	COMP.8	#1,D3
	JUMP,NE	R8^V1$
	CLR.8	ADMODESONFORT
	CLR.8	ADMODESONMOYEN
	JUMP	R8^EXIT$

V1$:
	COMP.8	#2,D3
	JUMP,NE	R8^V2$
	CLR.8	ADMODESONFORT
	SET.8	ADMODESONMOYEN
	JUMP	R8^EXIT$

V2$:
	COMP.8	#3,D3
	JUMP,NE	R8^V3$
	SET.8	ADMODESONFORT
	CLR.8	ADMODESONMOYEN
	JUMP	R8^EXIT$

V3$:
;	COMP.8	#4,D3
;	JUMP,NE	R8^EXIT$
	SET.8	ADMODESONFORT
	SET.8	ADMODESONMOYEN
;	JUMP	R8^EXIT$
	.ENDIF

EXIT$:
	RET


;--------\\
; WRONEB  >
;========/

; in	D3.16	byte  crire
;	A0.32	^variables
; out	-
; mod	D0,D1,A1.32, D7.16

WRONEB:
	PUSH.32	A3

	CLR.16	D7			; D7 <-- ok

	TEST.8	{A6}+OLEVEL		; silence total ?
	JUMP,EQ	EXIT$			; oui => EXIT$

	TEST.16	{A0}+ONWAIT		; ordre multiple attendu ?
	JUMP,NE	MULTI$			; oui => MULTI$

	TEST.8	D3			; ordre zro ?
	JUMP,EQ	EXIT$			; oui => EXIT$

	MOVE.32	#2+1+1,D0
	COMP.8	#BIPNOTE,D3
	JUMP,EQ	WNOTE$

	MOVE.32	#2+2+2+1+1,D0
	COMP.8	#BIPACCORD,D3
	JUMP,EQ	WNOTE$

	MOVE.32	#R16^TBIPLIT,A1
	COMP.8	#BIPLIT,D3
	JUMP,EQ	WBIP$

	MOVE.32	#R16^TBIPEND,A1
	COMP.8	#BIPEND,D3
	JUMP,EQ	WBIP$

	MOVE.32	#R16^TBIPYES,A1
	COMP.8	#BIPYES,D3
	JUMP,EQ	WBIP$

	MOVE.32	#R16^TBIPBIG,A1
	COMP.8	#BIPBIG,D3
	JUMP,EQ	WBIP$

	MOVE.32	#R16^TBIPERR,A1
	COMP.8	#BIPERR,D3
	JUMP,EQ	WBIP$

	MOVE.32	#R16^TBIPFAT,A1
	COMP.8	#BIPFAT,D3
	JUMP,EQ	WBIP$

	MOVE.32	#R16^TBIPDONE,A1
	COMP.8	#BIPDONE,D3
	JUMP,EQ	WBIP$

	MOVE.32	#R16^TBIPNIL,A1
	COMP.8	#99,D3
	JUMP,LS	WBIP$

;;	LOAD.W	D7,#ER...
	JUMP	EXIT$

WNOTE$:
	CALL	D0LOCK			; dbut zone critique !
	MOVE.16	D0,{A0}+ONWAIT		; init nb de bytes attendus

	MOVE.8	D3,D0			; D0 <-- commande
	CALL	WRFIFO			; envoie une commande
	JUMP	EXIT$

MULTI$:
	MOVE.8	D3,D0
	CALL	WRFIFO			; met byte dans le fifo
	DEC.16	{A0}+ONWAIT		; encore qq chose attendu ?
	JUMP,NE	EXIT$			; oui => EXIT$
				; non =>
	CALL	D2SIGNAL		; signal nouvel ordre l
	CALL	D0UNLOCK		; fin zone critique !
	JUMP	EXIT$

WBIP$:
	CALL	AUDIOSEARCH		; A3 <-- ^son dans 300_SYNT.AUDIO
	JUMP,EQ	R8^WAUDIO$

	COMP.8	#SGLEV1,{A0}+OLEVHP
	JUMP,EQ	R8^WBLOOP$
	CALL	NXTPT			; A1 <-- ^2me lment
	COMP.8	#SGLEV2,{A0}+OLEVHP
	JUMP,EQ	R8^WBLOOP$
	CALL	NXTPT			; A1 <-- ^3me lment
	COMP.8	#SGLEV3,{A0}+OLEVHP
	JUMP,NE	EXIT$
WBLOOP$:
	TEST.16	{A1}			; fin de la table ?
	JUMP,EQ	R8^EXIT$		; oui => EXIT$
				; non =>
	CALL	D0LOCK			; dbut zone critique !
	MOVE.8	#BIPACCORD,D0
	CALL	WRFIFO			; fifo <-- BIPACCORD
	MOVE.32	#2+2+2+1+1,D1
WBXFER$:
	MOVE.8	{A1+},D0
	CALL	WRFIFO			; fifo <-- nn nn nn e t
	DEC.16	D1
	JUMP,NE	WBXFER$
	CALL	D2SIGNAL		; signal nouvel ordre l
	CALL	D0UNLOCK		; fin zone critique !
	JUMP	WBLOOP$

WAUDIO$:
	CALL	D0LOCK			; dbut zone critique !
	MOVE.8	#BIPAUDIO,D0
	CALL	WRFIFO			; fifo <-- BIPAUDIO
	MOVE.32	A3,D0
	MOVE.32	#4-1,D1
WAXFER$:
	RL.32	#8,D0
	CALL	WRFIFO			; fifo <-- pppp
	DJ.16,NMO D1,WAXFER$
	CALL	D2SIGNAL		; signal nouvel ordre l
	CALL	D0UNLOCK		; fin zone critique !
EXIT$:
	POP.32	A3
	RET

;--------\\
; NXTPT   >
;--------/

; in	A1.32	^dans TBIPxxx
; out	A1.32	^suivant
; mod	A1.32

NXTPT:
	TEST.16	{A1+}			; A1 <-- saute .16
	JUMP,EQ	R8^EXIT$
	ADD.32	#2+2+1+1,A1		; A1 <-- saute .WWBB
	JUMP	NXTPT
EXIT$:
	RET


TBIPLIT:
	.16	0
	.16	NOTE+OCTAVE*7+SGDO,SILENCE,SILENCE,16'100*1+1
	.16	0
	.16	NOTE+OCTAVE*7+SGDO,NOTE+OCTAVE*8+SGDO,SILENCE,16'100*2+2
	.16	0

TBIPEND:
	.16	NOTE+OCTAVE*4+SGDO,SILENCE,SILENCE,16'100*1+1
	.16	0
	.16	NOTE+OCTAVE*5+SGDO,SILENCE,SILENCE,16'100*4+4
	.16	0
	.16	NOTE+OCTAVE*5+SGDO,NOTE+OCTAVE*6+SGDO,SILENCE,16'100*4+4
	.16	0

TBIPYES:
	.16	NOTE+OCTAVE*6+SGDO,SILENCE,SILENCE,16'100*1+1
	.16	0
	.16	NOTE+OCTAVE*6+SGDO,SILENCE,SILENCE,16'100*2+2
	.16	NOTE+OCTAVE*5+SGDO,SILENCE,SILENCE,16'100*2+2
	.16	0
	.16	NOTE+OCTAVE*4+SGDO,NOTE+OCTAVE*5+SGDO,NOTE+OCTAVE*6+SGDO,16'100*3+3
	.16	NOTE+OCTAVE*2+SGDO,NOTE+OCTAVE*3+SGDO,NOTE+OCTAVE*4+SGDO,16'100*3+3
	.16	0

TBIPBIG:
	.16	NOTE+OCTAVE*4+SGDO,SILENCE,SILENCE,16'100*5+5
	.16	0
	.16	PERIODE+150,PERIODE+152,SILENCE,16'100*15+15
	.16	0
	.16	PERIODE+150,PERIODE+152,SILENCE,16'100*25+25
	.16	0

TBIPERR:
	.16	NOTE+OCTAVE*2+SGDO,SILENCE,SILENCE,16'100*13+13
	.16	0
	.16	NOTE+OCTAVE*2+SGDO,SILENCE,SILENCE,16'100*20+20
	.16	0
	.16	NOTE+OCTAVE*2+SGDO,SILENCE,SILENCE,16'100*20+20
	.16	0

TBIPFAT:
	.16	NOTE+OCTAVE*2+SGDO,SILENCE,SILENCE,16'100*50+15
	.16	NOTE+OCTAVE*2+SGDO-1,SILENCE,SILENCE,16'100*50+15
	.16	NOTE+OCTAVE*2+SGDO-2,SILENCE,SILENCE,16'100*50+15
	.16	NOTE+OCTAVE*2+SGDO-3,SILENCE,SILENCE,16'100*50+50
	.16	0
	.16	NOTE+OCTAVE*2+SGDO,SILENCE,SILENCE,16'100*50+15
	.16	NOTE+OCTAVE*2+SGDO-1,SILENCE,SILENCE,16'100*50+15
	.16	NOTE+OCTAVE*2+SGDO-2,SILENCE,SILENCE,16'100*50+15
	.16	NOTE+OCTAVE*2+SGDO-3,SILENCE,SILENCE,16'100*50+50
	.16	0
	.16	NOTE+OCTAVE*2+SGDO,SILENCE,SILENCE,16'100*50+15
	.16	NOTE+OCTAVE*2+SGDO-1,SILENCE,SILENCE,16'100*50+15
	.16	NOTE+OCTAVE*2+SGDO-2,SILENCE,SILENCE,16'100*50+15
	.16	NOTE+OCTAVE*2+SGDO-3,SILENCE,SILENCE,16'100*50+50
	.16	0

TBIPDONE:
	.16	NOTE+OCTAVE*4+SGDO,SILENCE,SILENCE,16'100*2+1
	.16	NOTE+OCTAVE*5+SGDO,SILENCE,SILENCE,16'100*2+10
	.16	0
	.16	NOTE+OCTAVE*4+SGDO,SILENCE,SILENCE,16'100*2+1
	.16	NOTE+OCTAVE*4+SGMI,SILENCE,SILENCE,16'100*2+1
	.16	NOTE+OCTAVE*4+SGSOL,SILENCE,SILENCE,16'100*2+1
	.16	NOTE+OCTAVE*5+SGDO,SILENCE,SILENCE,16'100*2+10
	.16	0
	.16	NOTE+OCTAVE*4+SGDO,SILENCE,SILENCE,16'100*6+2
	.16	NOTE+OCTAVE*4+SGRE,SILENCE,SILENCE,16'100*6+2
	.16	NOTE+OCTAVE*4+SGMI,SILENCE,SILENCE,16'100*6+2
	.16	NOTE+OCTAVE*4+SGFA,SILENCE,SILENCE,16'100*6+2
	.16	NOTE+OCTAVE*4+SGSOL,SILENCE,SILENCE,16'100*6+2
	.16	NOTE+OCTAVE*4+SGLA,SILENCE,SILENCE,16'100*6+2
	.16	NOTE+OCTAVE*4+SGSI,SILENCE,SILENCE,16'100*6+2
	.16	NOTE+OCTAVE*5+SGDO,SILENCE,SILENCE,16'100*6+20
	.16	0

TBIPNIL:
	.16	0
	.16	0
	.16	0





;	*********************************
;	*				*
;	*	 PROCESSUS FILS 	*
;	*				*
;	*********************************

NAMEFILS:
	.ASCIZ	"SYNT_CONTROL"
	.EVEN

PROCFILS:
LOOP$:
	CALL	D2WAIT			; attend un ordre

	CALL	RDFIFO			; lit un byte dans le fifo
	MOVE.16	D0,D3			; D3 <-- byte lu

	MOVE.32	#R16^TACOMM,A1
SEARCH$:
	ADD.32	#2+2,A1			; A1 <-- ^suivant dans TACOMM
	TEST.16	{A1}-4			; fin de la table ?
	JUMP,EQ	LOOP$			; oui => LOOP$
	COMP.16	{A1}-4,D3		; ordre trouv ?
	JUMP,NE	SEARCH$			; non => SEARCH$
				; oui =>
	CLR.32	D1
	MOVE.16	{A1}-2,D1		; D1 <-- adr relative routine
	MOVE.32	#R16^DEBUT,A1		; A1 <-- adr absolue du driver
	ADD.32	D1,A1			; A1 <-- adr absolue routine
	CALL	{A1}			; excute un bip quelconque ...
	JUMP	LOOP$


TACOMM:
	.16	BIPNOTE,DONOTE
	.16	BIPACCORD,DOACCORD
	.16	BIPAUDIO,DOAUDIO
	.16	BIPCLOSE,DOCLOSE
	.16	0



; ----	BIPNOTE  ----

DONOTE:
	CALL	RDFIFO			; D0 <-- note (high)
	MOVE.8	D0,D1
	SL.16	#8,D1
	CALL	RDFIFO			; D0 <-- note (low)
	MOVE.8	D0,D1

	MOVE.16	#SILENCE,D2
	MOVE.16	#SILENCE,D3

	CALL	RDFIFO			; D0 <-- enveloppe
	MOVE.16	D0,D4
	CALL	RDFIFO			; D0 <-- dure
	MOVE.16	D0,D5

	JUMP	ACCORD			; fait entendre la note


; ----	BIPACCORD  ----

DOACCORD:
	CALL	RDFIFO			; D0 <-- note (high)
	MOVE.8	D0,D1
	SL.16	#8,D1
	CALL	RDFIFO			; D0 <-- note (low)
	MOVE.8	D0,D1

	CALL	RDFIFO			; D0 <-- note (high)
	MOVE.8	D0,D2
	SL.16	#8,D2
	CALL	RDFIFO			; D0 <-- note (low)
	MOVE.8	D0,D2

	CALL	RDFIFO			; D0 <-- note (high)
	MOVE.8	D0,D3
	SL.16	#8,D3
	CALL	RDFIFO			; D0 <-- note (low)
	MOVE.8	D0,D3

	CALL	RDFIFO			; D0 <-- enveloppe
	MOVE.16	D0,D4
	CALL	RDFIFO			; D0 <-- dure
	MOVE.16	D0,D5

	JUMP	ACCORD			; fait entendre l'accord


; ----	BIPAUDIO  ----

DOAUDIO:
	CLR.32	D1
	MOVE.32	#4-1,D2
LOOP$:
	RL.32	#8,D1
	CALL	RDFIFO			; D0 <-- pppp
	MOVE.8	D0,D1
	DJ.16,NMO D2,LOOP$
	MOVE.32	D1,A4			; A4 <-- ^en-tte + son

	TEST.16	{A6}+OCHA		; dj ouvert ?
	JUMP,NE	R8^WRITE$		; oui => WRITE$
	MOVE.32	#R16^NMLO,A3
	MOVE.32	#2**BOPWR,D3
	FOS	?OPEN			; ouvre #AUDIO:
	JUMP,NE	R8^EXIT$
	MOVE.16	D6,{A6}+OCHA
WRITE$:
	MOVE.32	{A4}+OADHLG,D4
	ADD.32	#LADH,D4
	MOVE.16	{A6}+OCHA,D6
	FOS	?WRBYTE			; joue le son audio

	FOS	?CLOSE			; ferme #AUDIO:
	CLR.16	{A6}+OCHA
EXIT$:
	RET


; ----	BIPCLOSE  ----

DOCLOSE:
	MOVE.16	{A6}+OCHA,D6
	JUMP,EQ	R8^EXIT$
	FOS	?CLOSE			; ferme #AUDIO:
	CLR.16	{A6}+OCHA
EXIT$:
	RET


;--------\\
; ACCORD  >
;========/

; Fait entendre un accord de trois notes au maximum.
; Exemples de notes:
;	RE			r de la premire octave
;	OCTAVE*4+SOL		sol de la 4me octave
;	OCTAVE*3+SI+BEMOL	si bmol de la 3me octave
;	PERIODE+2500.		priode de 2500.
;	BRUIT+12.		bruit de "frquence" 12.
;	SILENCE			gnrateur inutilis

; in	D1.16	premire note
;	D2.16	deuxime note
;	D3.16	troisime note
;	D4.16	enveloppe (en ms)
;	D5.16	dure (en ms)
; out	-
; mod	tout

ACCORD:
	MOVE.32	#R16^TABLE$,A2

	MOVE.16	#SILENCE,D0
	TEST.32	D1:#15			; bruit ou silence ?
	JUMP,BS	R8^NOTE0$		; oui => NOTE0$
	MOVE.16	D1,D0
	TCLR.32	D0:#14			; priode ?
	JUMP,BS	R8^NOTE0$		; oui => NOTE0$
	SL.16	#1,D0
	MOVE.16	{A2}+A16^{D0},D0
NOTE0$:
	MOVE.16	#SILENCE,D1
	TEST.32	D2:#15			; bruit ou silence ?
	JUMP,BS	R8^NOTE1$		; oui => NOTE1$
	MOVE.16	D2,D1
	TCLR.32	D1:#14			; priode ?
	JUMP,BS	R8^NOTE1$		; oui => NOTE1$
	SL.16	#1,D1
	MOVE.16	{A2}+A16^{D1},D1
NOTE1$:
	MOVE.16	#SILENCE,D2
	TEST.32	D3:#15			; bruit ou silence ?
	JUMP,BS	R8^NOTE2$		; oui => NOTE2$
	MOVE.16	D3,D2
	TCLR.32	D2:#14			; priode ?
	JUMP,BS	R8^NOTE2$		; oui => NOTE2$
	SL.16	#1,D2
	MOVE.16	{A2}+A16^{D2},D2
NOTE2$:
	TEST.16	D5			; dure nulle ?
	JUMP,NE	R8^PLAY$		; non => PLAY$
	MOVE.16	D5,D4			; D4 <-- enveloppe !
PLAY$:
	MOVE.16	D0,D3
	OR.16	D1,D3
	OR.16	D2,D3			; trois silences ?
	JUMP,EQ	R8^WAIT$		; oui => WAIT$

	TEST.16	D4
	JUMP,EQ	R8^WAIT$
	SWAP.32	D4
	MOVE.16	D5,D4			; D4 <-- enveloppe/dure
	JUMP,EQ	R8^WAIT$

	.IF	SM130
	TEST.8	{A6}+OSIMPL		; utilise le pilote AUDIO ?
	JUMP,T	ACCORD130		; non => ACCORD130
	.ENDIF

	COMP.16	#MAXSON*50,D4
	JUMP,LO	R8^ACCORD$
	MOVE.16	#MAXSON*50,D4		; D4 <-- dure maximale possible !
ACCORD$:
	MOVE.32	#{A6}+OBBUFF,A4		; A4 <-- ^big buffer
	CALL	CALCACCORD		; calcule l'accord
	TEST.32	D4
	JUMP,EQ	R8^EXIT$

	TEST.16	{A6}+OCHA		; dj ouvert ?
	JUMP,NE	R8^WRITE$		; oui => WRITE$
	MOVE.32	#R16^NMLO,A3
	MOVE.32	#2**BOPWR,D3
	FOS	?OPEN			; ouvre #AUDIO:
	JUMP,NE	R8^EXIT$
	MOVE.16	D6,{A6}+OCHA
WRITE$:
	MOVE.32	#{A4}-LADH,A4		; A4 <-- ^en-tte
	MOVE.8	#ADHTYPE,{A4}+OADHTYP
	MOVE.32	D4,{A4}+OADHLG
	MOVE.16	#FREQ,{A4}+OADHFREQ
;	CLR.16	{A4}+OADHCOD
	ADD.32	#LADH,D4
	MOVE.16	{A6}+OCHA,D6
	FOS	?WRBYTE			; joue le son
	JUMP	R8^EXIT$

WAIT$:
	TEST.16	D4
	JUMP,EQ	R8^EXIT$
	NTREL	?DELMS			; attend ...
EXIT$:
	RET


; Table des priodes pour les notes de la gamme tempre :

TABLE$:
	.16	10'3822,10'3608,10'3405,10'3214,10'3034,10'2864
	.16	10'2703,10'2551,10'2408,10'2273,10'2145,10'2025

	.16	10'1911,10'1804,10'1703,10'1607,10'1517,10'1432
	.16	10'1351,10'1276,10'1204,10'1136,10'1073,10'1012

	.16	10'956,10'902,10'851,10'804,10'758,10'716
	.16	10'676,10'638,10'602,10'568,10'536,10'506

	.16	10'478,10'451,10'426,10'402,10'379,10'358
	.16	10'338,10'319,10'301,10'284,10'268,10'253

	.16	10'239,10'225,10'213,10'201,10'190,10'179
	.16	10'169,10'159,10'150,10'142,10'134,10'127

	.16	10'119,10'113,10'106,10'100,10'95,10'89
	.16	10'84,10'80,10'75,10'71,10'67,10'63

	.16	10'60,10'56,10'53,10'50,10'47,10'45
	.16	10'42,10'40,10'38,10'36,10'34,10'32

	.16	10'30,10'28,10'27,10'25,10'24,10'22
	.16	10'21,10'20,10'19,10'18,10'17,10'16

	.16	10'15,10'14,10'13,10'13,10'12,10'11
	.16	10'11,10'10,10'9,10'9,10'8,10'8

	.16	10'7,10'7,10'7,10'6,10'6,10'6
	.16	10'5,10'5,10'5,10'4,10'4,10'4

	.16	10'4,10'4,10'3,10'3,10'3,10'3
	.16	10'3,10'2,10'2,10'2,10'2,10'2

	.16	10'2,10'2,10'2,10'2,10'1,10'1
	.16	10'1,10'1,10'1,10'1,10'1,10'1

	.16	10'1,10'1,10'1,10'1,10'1,10'1
	.16	10'1,10'1,10'1,10'1,10'1,10'1


	.IF	SM130
;----------\\
; ACCORD130 >
;----------/

; Joue une note de faon simple, c'est--dire sans utiliser le pilote AUDIO.

; in	D0.16	premire note
;	D1.16	seconde note
;	D2.16	troisime note
;	D4.16	dure en [20ms]
;	D4.32H	enveloppe en [20ms]
; out	-
; mod	tout

ACCORD130:
	MOVE.16	D4,D3			; D3 <-- dure
	JUMP,EQ	R8^EXIT$

	MOVE.16	D0,D4
	COMP.16	#SILENCE,D4
	JUMP,NE	R8^FREQ$
	MOVE.16	D1,D4
	COMP.16	#SILENCE,D4
	JUMP,NE	R8^FREQ$
	MOVE.16	D2,D4
FREQ$:
	MUL.16	#10,D4			; D4 <-- priode [0.5us]
	COMP.16	#100,D4			; frquence > 20 KHz ?
	JUMP,LO	R8^EXIT$		; oui => EXIT$
	MOVE.32	_INDSHI,A4
	CALL	{A4}+_SETFREQSON

	MOVE.32	#R16^INT130K1,A1
	TEST.8	{A6}+OK1		; K1 prsent ?
	JUMP,T	R8^INIT$		; oui => INIT$
	MOVE.32	#R16^INT130,A1
INIT$:
	MOVE.32	_INDSHI,A4
	CALL	{A4}+_INITINTSON

	MOVE.16	D3,D4			; D4 <-- dure
	NTREL	?DELMS			; attend ...

	SUB.32	A1,A1
	MOVE.32	_INDSHI,A4
	CALL	{A4}+_INITINTSON	; stoppe l'interruption
EXIT$:
	RET

;--------\\
; INT130  >
;--------/

; Routine d'interruption simple lorsque le K1 est absent.

; in	A0.32	^variables
; out	-
; mod	D0.32, D1.32, A0.32, A1.32

INT130:
;;?	LOAD.8	ADMODEHP,(A0)+OSDATA
	MOVE.8	{A0}+OSDATA,ADSON
	NOT.8	{A0}+OSDATA
	RET

;---------\\
; INT130K1 >
;---------/

; Routine d'interruption NMI lorsque le K1 est prsent.

; in	-
; out	-
; mod	-

INT130K1:
	MOVE.8	SoundData,ADSON
	NOT.8	SoundData

	MOVE.16	#16'00FF,ADRZNMI	; pulse le reset de la bascule NMI
	NOP
	RETSF
	.ENDIF


;-----------\\
; CALCACCORD >
;===========/

; Calcule le signal carr d'un accord de trois notes au maximum.

; in	D0.16	premire note
;	D1.16	seconde note
;	D2.16	troisime note
;	D4.16	dure en [20ms]
;	D4.32H	enveloppe en [20ms]
;	A4.32	destination
; out	D4.32	longueur
; mod	D4.32, D7.16

CALCACCORD:
	PUSHM.32 D0..D3|D5|D6|A4

	MOVE.32	D4,D7
	SWAP.32	D7			; D7 <-- enveloppe
	MUL.16	#FREQ/50,D7
	DIV.16	#MAXNIV/6,D7
	MOVE.16	D7,D6
	SWAP.32	D7
	MOVE.16	D6,D7			; D7 <-- copie dans high word

	MUL.16	#FREQ/50,D4		; D4 <-- longueur
	PUSH.32	D4

	MOVE.32	#MAXNIV/6,D5		; D5 <-- coefficient
	CLR.32	D6			; D6 <-- clear flags

	TEST.16	D0
	JUMP,EQ	R8^S1$
	AND.32	#16'FFFF,D0
	DIV.16	#3,D0
	TSET.32	D6:#19			; D6 <-- la note 0 existe
S1$:
	SWAP.32	D0			; D0 <-- mmorise dans le high word
	MOVE.16	#1,D0			; D0 <-- rechargement au coup suivant

	TEST.16	D1
	JUMP,EQ	R8^S2$
	AND.32	#16'FFFF,D1
	DIV.16	#3,D1
	TSET.32	D6:#20			; D6 <-- la note 1 existe
S2$:
	SWAP.32	D1			; D1 <-- mmorise dans le high word
	MOVE.16	#1,D1			; D1 <-- rechargement au coup suivant

	TEST.16	D2
	JUMP,EQ	R8^S3$
	AND.32	#16'FFFF,D2
	DIV.16	#3,D2
	TSET.32	D6:#21			; D6 <-- la note 2 existe
S3$:
	SWAP.32	D2			; D2 <-- mmorise dans le high word
	MOVE.16	#1,D2			; D2 <-- rechargement au coup suivant
LOOP$:
	DEC.16	D0
	JUMP,NE	R8^E1$
	TNOT.32	D6:#16
	SWAP.32	D0
	MOVE.16	D0,D6
	SWAP.32	D0
	MOVE.16	D6,D0			; D0 <-- recharge le low word
E1$:
	DEC.16	D1
	JUMP,NE	R8^E2$
	TNOT.32	D6:#17
	SWAP.32	D1
	MOVE.16	D1,D6
	SWAP.32	D1
	MOVE.16	D6,D1			; D1 <-- recharge le low word
E2$:
	DEC.16	D2
	JUMP,NE	R8^E3$
	TNOT.32	D6:#18
	SWAP.32	D2
	MOVE.16	D2,D6
	SWAP.32	D2
	MOVE.16	D6,D2			; D2 <-- recharge le low word
E3$:
	DEC.16	D7
	JUMP,NE	R8^VAL$

	TEST.16	D5
	JUMP,EQ	R8^VAL$
	DEC.16	D5			; D5 <-- coefficient diminue

	SWAP.32	D7
	MOVE.16	D7,D6
	SWAP.32	D7
	MOVE.16	D6,D7			; D7 <-- recharge le low word
VAL$:
	MOVE.16	#MAXNIV/2,D3		; D3 <-- niveau "zro"

	TEST.32	D6:#19			; note 0 existe ?
	JUMP,BC	R8^B1$
	SUB.16	D5,D3
	TEST.32	D6:#16
	JUMP,BC	R8^B1$
	ADD.16	D5,D3
	ADD.16	D5,D3
B1$:
	TEST.32	D6:#20			; note 1 existe ?
	JUMP,BC	R8^B2$
	SUB.16	D5,D3
	TEST.32	D6:#17
	JUMP,BC	R8^B2$
	ADD.16	D5,D3
	ADD.16	D5,D3
B2$:
	TEST.32	D6:#21			; note 2 existe ?
	JUMP,BC	R8^B3$
	SUB.16	D5,D3
	TEST.32	D6:#18
	JUMP,BC	R8^B3$
	ADD.16	D5,D3
	ADD.16	D5,D3
B3$:
	MOVE.8	D3,{A4+}		; buffer <-- crit l'chantillon

	DEC.32	D4			; D4 <-- compteur de dure
	JUMP,NE	LOOP$

	POP.32	D4

	POPM.32	D0..D3|D5|D6|A4
	RET






; Gestion du fifo
; ---------------


;--------\\
; INIFIFO >
;========/

; Initialise un nouveau fifo vide.

; in	-
; out	-
; mod	-

INIFIFO:
	PUSHM.32 A1|A4

	MOVE.32	#{A6}+OFIFO,A1		; A1 <-- ^fifo

	MOVE.32	#{A1}+LGFIFO,A4		; A4 <-- ^dbut data dans fifo
	MOVE.32	A4,{A1}+OFIHEAD		; init ^tte
	MOVE.32	A4,{A1}+OFITAIL		; init ^queue (= ^tte)
	MOVE.32	A4,{A1}+OFIBEG		; init ^dbut fifo

	MOVE.32	#{A4}+MAXFIFO,A4
	MOVE.32	A4,{A1}+OFIEND		; init ^fin fifo

	POPM.32	A1|A4
	RET

;--------\\
; RDFIFO  >
;========/

; Lit un lment dans un fifo quelconque.
;	TAIL = HEAD ?		oui => fifo vide
;	D0.8 <-- (TAIL)		lit le data
;	TAIL <-- TAIL+1		avance le ^de queue

; in	-
; out	D0.8	data lu
; mod	D0.32

RDFIFO:
	PUSHM.32 A1|A2

	MOVE.32	#{A6}+OFIFO,A1		; A1 <-- ^fifo

	MOVE.32	{A1}+OFITAIL,A2
	COMP.32	{A1}+OFIHEAD,A2		; TAIL = HEAD  ?
	JUMP,EQ	R8^FATAL$		; oui => fifo vide

	CLR.32	D0
	MOVE.8	{A2+},D0		; lit un byte

	COMP.32	{A1}+OFIEND,A2
	JUMP,NE	R8^TAIL$
	MOVE.32	{A1}+OFIBEG,A2
TAIL$:
	MOVE.32	A2,{A1}+OFITAIL		; mj TAIL

	CALL	D1UNLOCK		; un lment lu

	POPM.32	A1|A2
	RET

FATAL$:
	.16	16'A042
	.ASCIZ	"$SYNT:vide<CR>"
	.EVEN
	TRAP	#0

;--------\\
; WRFIFO  >
;========/

; Ajoute un lment dans un fifo quelconque.
;	HEAD <-- HEAD+1		avance le ^de tte
;	HEAD = TAIL ?		oui => fifo plein
;	(HEAD) <-- D0.8		crit le data

; in	D0.8	lment  crire
; out	-
; mod	-

WRFIFO:
	PUSHM.32 A0..A2

	CALL	D1LOCK			; attend si fifo plein ...

	MOVE.32	#{A6}+OFIFO,A1		; A1 <-- ^fifo

	MOVE.32	{A1}+OFIHEAD,A2
	MOVE.32	A2,A0
	INC.32	A2			; avance HEAD
	COMP.32	{A1}+OFIEND,A2
	JUMP,NE	R8^HEAD$
	MOVE.32	{A1}+OFIBEG,A2
HEAD$:
	COMP.32	{A1}+OFITAIL,A2		; HEAD = TAIL  ?
	JUMP,EQ	R8^FATAL$		; oui => fifo plein
	MOVE.32	A2,{A1}+OFIHEAD		; mj HEAD

	MOVE.8	D0,{A0}			; crit un byte

	POPM.32	A0..A2
	RET

FATAL$:
	.16	16'A042
	.ASCIZ	"$SYNT:plein<CR>"
	.EVEN
	TRAP	#0




; Le smaphore zro permet de faire de l'exclusion mutuelle
; lors de l'envoi d'une commande de plusieurs bytes (BIPNOTE
; ou BIPACCORD) pour que personne ne puisse intercaler une
; autre commande.

;--------\\
; D0LOCK  >
;========/

; in	-
; out	-
; mod	-

D0LOCK:
	PUSHM.32 D7|A5

	MOVE.32	{A6}+OPSEM0,A5		; A5 <-- ^smaphore
	NTREL	?LOCK			; attend ...

	POPM.32	D7|A5
	RET

;---------\\
; D0UNLOCK >
;=========/

; in	-
; out	-
; mod	-

D0UNLOCK:
	PUSHM.32 D7|A5

	MOVE.32	{A6}+OPSEM0,A5		; A5 <-- ^smaphore
	NTREL	?UNLOCK			; signal fin zone critique

	POPM.32	D7|A5
	RET



; Le smaphore un est initialis avec e=maxfifo. Il permet
; de suspendre le processus appelant le driver lorsque le
; fifo est plein.

;--------\\
; D1LOCK  >
;========/

; in	-
; out	-
; mod	-

D1LOCK:
	PUSHM.32 D7|A5

	MOVE.32	{A6}+OPSEM1,A5		; A5 <-- ^smaphore
	NTREL	?LOCK			; attend si fifo plein ...

	POPM.32	D7|A5
	RET

;---------\\
; D1UNLOCK >
;=========/

; in	-
; out	-
; mod	-

D1UNLOCK:
	PUSHM.32 D7|A5

	MOVE.32	{A6}+OPSEM1,A5		; A5 <-- ^smaphore
	NTREL	?UNLOCK			; signal fifo pas plein

	POPM.32	D7|A5
	RET



; Le smaphore deux permet la communication entre le processus
; appelant le driver et le processus fils du driver.
; Lorsqu'une commande est dans le fifo, le processus appelant
; fait un SIGNAL. Le fils attend sur un WAIT, excute une
; commande (un son), fait ventuellement un dlai, puis
; recommence.

;--------\\
; D2WAIT  >
;========/

; in	-
; out	-
; mod	-

D2WAIT:
	PUSHM.32 D7|A5

	MOVE.32	{A6}+OPSEM2,A5		; A5 <-- ^smaphore
	NTREL	?WAITEV			; attend une commande ...

	POPM.32	D7|A5
	RET

;---------\\
; D2SIGNAL >
;=========/

; in	-
; out	-
; mod	-

D2SIGNAL:
	PUSHM.32 D7|A5

	MOVE.32	{A6}+OPSEM2,A5		; A5 <-- ^smaphore
	NTREL	?SIGNEV			; signal commande dans fifo

	POPM.32	D7|A5
	RET




;----------\\
; AUDIOREAD >
;==========/

; Lit un fichier *.AUDIO en mmoire.

; in	A3.32	^nom
; out	A4.32	^data
;	D4.32	lg data
;	D7.16	erreur
; mod	D4.32, D7.16, A4.32

AUDIOREAD:
	PUSHM.32 D1|D3|D6|A1

	MOVE.16	#2**BOPRD.OR.2**BOPSYS,D3
	FOS	?OPEN
	JUMP,NE	R8^EXIT$

	MOVE.32	#-1,D3
	MOVE.32	D3,D4
	FOS	?SPOS			; D4 <-- longueur
	PUSH.32	D4
	CLR.32	D3
	CLR.32	D4
	FOS	?SPOS
	POP.32	D4

	MOVE.32	#R16^S0BASE,A1
	MOVE.32	#MTYPBD,D1
	GESMEM	?GETMEM
	JUMP,NE	R8^CLOSE$

	FOS	?RDBYTE			; lit le fichier .AUDIO
	JUMP,EQ	R8^CLOSE$

	PUSH.16	D7
	GESMEM	?GIVMEM			; rend la mmoire en cas d'erreur
	POP.16	D7

CLOSE$:	PUSH.16	D7
	FOS	?CLOSE
	POP.16	D7
EXIT$:
	POPM.32	D1|D3|D6|A1
	TEST.16	D7			; retour EQ/NE
	RET

;------------\\
; AUDIOSEARCH >
;============/

; Cherche un son audio dans 300_SYNT.AUDIO

; in	D3.8	BIP* cherch
; out	A3.32	^son
;	D7.16	erreur
; mod	D7.16, A3.32

AUDIOSEARCH:
	PUSHM.32 D1..D4

	.IF	SM130
	TEST.8	{A6}+OSIMPL		; utilise le pilote AUDIO ?
	JUMP,T	R8^ERROR$		; non => ERROR$
	.ENDIF
	TEST.32	{A6}+OAUDPF		; fichier 300_SYNT.AUDIO charg ?
	JUMP,EQ	R8^ERROR$

	COMP.8	#99,D3
	JUMP,HI	R8^ERROR$

	MOVE.32	{A6}+OAUDPF,A3		; A3 <-- ^fichier
	MOVE.32	{A6}+OAUDLF,D4		; D4 <-- lg totale
LOOP$:
	TEST.32	D4			; reste qq chose ?
	JUMP,LE	R8^ERROR$		; non => ERROR$

	CLR.16	D2
	MOVE.8	{A3}+OADHNAME+0,D2
	SUB.8	#"0",D2
	JUMP,LO	R8^NEXT$
	COMP.8	#9,D2
	JUMP,HI	R8^NEXT$

	MOVE.8	{A3}+OADHNAME+1,D1
	SUB.8	#"0",D1
	JUMP,LO	R8^M10$
	COMP.8	#9,D1
	JUMP,HI	R8^M10$

	MUL.16	#10,D2
	ADD.8	D1,D2
M10$:
	COMP.8	D3,D2
	JUMP,EQ	R8^FOUND$
NEXT$:
	MOVE.32	{A3}+OADHLG,D2
	ADD.32	#LADH,D2		; D2 <-- lg avec en-tte

	SUB.32	D2,D4			; D4 <-- lg restante
	ADD.32	D2,A3			; A3 <-- ^son suivant
	JUMP	LOOP$

FOUND$:
	CLR.16	D7			; D7 <-- ok
	JUMP	R8^EXIT$

ERROR$:
	MOVE.16	#1,D7			; D7 <-- pas trouv
EXIT$:
	POPM.32	D1..D4
	TEST.16	D7			; retour EQ/NE
	RET






; Textes
; ------

NMAUDIO:.ASCIZ	"#:%M_SYNT.AUDIO"

NMLO:	.ASCIZ	"#AUDIO"
NMPH:	.ASCIZ	"$AUDIO_0"

	.EVEN






	.END

