; RB:
; Rajouter un mode Handschake Hard RTS ou DTR dsactiv lors de XOFF ok 8-7
; activ lors de XON
; Commande MHRE/MHRD et MHTE/MHTD > ok
;
; Commande MBH -> quartz 16MHz
; A rajouter bit rate sur 32 bits, et commandes 14400 et 115k
; commande supplmentaire 

	.TITLE		324_USART.ASD	; Drivers d'USART Z-8530 des SMAKY-130-196-300-324.
					; Rev: 8-10 

;24 nov   1997   8-10	PA: Nouvel assemblage
;23 dc   1994   8-9    RB+AD: Bug sur la command du DTR qui tait transmise (parfois) sur RTS !!
;26 oct   1994   8-8    RB: Mode 16 MHz par dfaut sur S196
;21 sept  1994   8-7    RB: Adjonction handshake Hard par RTS ou DTR pour rgulation du flux
; Nouveaux modes pour handshake hard
; MHE, MHD, MHRE, MHRD, MHTE, MHTD (RB 94/09/21)
; et bits de status correspondant dans OSTAXRW
;31 mars  1992	 8-6	Corrections pour SMAKY 130: Bdrate 16Mhz, comm: ODX,ORX (RB).	04:00
;30 mars  1992	 8-5	Modifications pour SMAKY 130.					04:00
; 8  oct  1990	 8-4	Correction SMAKY_196.						01:00
;27  sept 1990	 8-3	Correction SMAKY_196.						01:00
;16  mai  1990	 8-3	Correction criture lente car par car.				04:00
;14  mai  1990	 8-1	Correction bug criture (cractres loupps)			04:00
;25 avril 1990	 8-0	Essai de correction bug criture: call intwrite (procsendxf)	01:00
;24 avril 1990	 7-F	Corrections pour SKAKY_196 et SMAKY_300				03:00
;11 avril 1990	 7-E	Adaptation pour SKAKY_196 et SMAKY_300				06:00
;24  sept 1989	 7-D	Modifications commandes pour SMACK: XX,XC,PR[pp.W]		03:00
;19  sept 1989		Modifications commandes pour SMACK: XS,XG,ODX,ODC,ORX,ORC,?.	04:30
;18  sept 1989	 7-C	Modifications plaques sries D:clk.				02:30
;02  avri 1989	 7-B	Modification des cte de division: :1, :16, :32, :64		01:30
;13  fevr 1989		Correction des dviation des routines d'interruptions.		03:00
;12  fevr 1989		Dviation des routines d'interruptions du drivers: R,W,S.	04:00
;22  janv 1989	 7-A	Routines d'interruptions auxiliaires.				01:00
;25  aot 1988	 7-9	Organigramme et liste des commandes, nouvelles plaques,corr.	10:00
;17  juil 1988		Smaphore erreur + com, flags xon-xoff send et rcv.		01:00
;29  mai  1988		Corrections call intwrite. 					01:00
;28  mai  1988		Corrections baud-rate.						02:00
;25  mai  1988		Corrections.							01:00
;24  mai  1988		Corrections.							02:00
;21  mai  1988		Romabilit.							08:00
;20  mai  1988		Bug send abort write, erreurs exactes, dbut romabilit.	04:30
;15  mai  1988		Brate 8Mhz, break, autoecho, local loop.			04:00
;13  mai  1988		Debug plus rapide.						01:00
;12  mai  1988		No de rvision, debug plus rapide.				01:30
;11  mai  1988		Bug comm_N, comm_MB, IOF5, big bug xon-xof !!!			08:30
; 8  mai  1988		Bug install.							01:00
; 7  mai  1988		Comm_OC,status B-V, int DCD-CTS.				06:00
; 4  mai  1988		DIV.A16 --> DIV.16.						05:00
; 1  mai  1988		Debug comm_B,F,L,O, bug read DTR,com_N, RDstatus.		14:00
;30 avril 1988		Croise les prise, debug off.					02:00
;22 avril 1988		COMMAND N.							00:30
;21 avril 1988		COMMAND M,P,S,B,V,R,D,C.					04:30
;20 avril 1988		COMMAND Y,W,T.							02:00
;19 avril 1988		COMMAND X.							01:30
;17 avril 1988		Divers dbug,structure COMMAND.					06:00
;14 avril 1988		Debug XON-XOFF.							03:00
;13 avril 1988		Debug SIMSER read, commutation rs232-simser.			06:00
;10 avril 1988		READ.								07:30
; 9 avril 1988		Debug OPEN READ.						03:00
; 8 avril 1988		OPEN READ.							02:00
; 6 avril 1988		Debug WRITE.							01:00
; 5 avril 1988		Debug WRITE,PROCSEND.						03:00
; 3 avril 1988		test WRITE ok, PROCSENDXF.					06:00
; 2 avril 1988		SENDREG,WRITE.							02:00
; 1 avril 1988		OPEN_WRITE.							01:00
; 31 mars 1988		AVORT,RESET,KILL.						10:30
; 30 mars 1988		Rout d'interr de lecture, INITSOFT, INITHARD.			11:00
; 29 mars 1988		Ecriture de la routine d'interruption d'criture.		07:00
; 28 mars 1988		Ecriture des dfinitions des variables & entte du driver.	05:00
; 27 mars 1988		Ecriture des constantes du driver.				03:00


	.PROC		M68000
	.BASE		10'16

NREV		=	10'8			; Numro de rvision.
NVER		=	10'10			; Numro de version.

;========================================================================================
;	ASSEMBLAGE CONDITIONNELS:							=
;	=========================							=
DEBUG		=	TRUE			; Assemblage avec structure de debug.	=
ROMABLE		=	TRUE			; Pour un systme romable.		=
OLDPLAQUE	=	TRUE			; MB4, MB3 old plaques SM324, new: MB8.	=
;											=
;;SM324		=	FALSE			; Assemblage pour le SMAKY_324.		=
;;SM196		=	FALSE			; Assemblage pour le SMAKY_196.		=
;;SM300		=	FALSE			; Assemblage pour le SMAKY_300.		=
;;SM130		=	TRUE			; Assemblage pour le SMAKY_130.		=
;========================================================================================

	.ins	testmachine.asi

.IF	(SM324.AND.SM196).OR.(SM324.AND.SM300).OR.(SM196.AND.SM300).OR.(SM130.AND.SM324).OR.(SM130.AND.SM196).OR.(SM130.AND.SM300)
ASSEMBLAGE CONDITIONNEL IMPOSSIBLE !!!
.ENDIF
.IF	SM324
;****************************************************************
;*                                                              *
;*                                                              *
;*    SSSSSS    M        M     333333      222222         44    *
;*   S      S   MM      MM    3      3    2      2       4 4    *
;*   S          M M    M M           3           2      4  4    *
;*    S         M  M  M  M           3           2     4   4    *
;*     SSSS     M   MM   M       3333          22     4    4    *
;*         S    M        M           3       22      44444444   *
;*          S   M        M           3     22              4    *
;*   S      S   M        M    3      3    2                4    *
;*    SSSSSS    M        M     333333     2222222          4    *
;*                                                              *
;*                                                              *
;****************************************************************
.ENDIF
.IF	SM196
;****************************************************************
;*                                                              *
;*                                                              *
;*    SSSSSS    M        M        1        999999     666666    *
;*   S      S   MM      MM       11       9      9   6      6   *
;*   S          M M    M M      1 1       9      9   6          *
;*    S         M  M  M  M     1  1       9      9   6          *
;*     SSSS     M   MM   M    1   1        9999999   6666666    *
;*         S    M        M        1              9   6      6   *
;*          S   M        M        1              9   6      6   *
;*   S      S   M        M        1       9      9   6      6   *
;*    SSSSSS    M        M    11111111     999999     666666    *
;*                                                              *
;*                                                              *
;****************************************************************
.ENDIF
.IF	SM300
;****************************************************************
;*                                                              *
;*                                                              *
;*    SSSSSS    M        M     333333      000000     000000    *
;*   S      S   MM      MM    3      3    0     00   0     00   *
;*   S          M M    M M           3    0    0 0   0    0 0   *
;*    S         M  M  M  M           3    0   0  0   0   0  0   *
;*     SSSS     M   MM   M       3333     0  0   0   0  0   0   *
;*         S    M        M           3    0 0    0   0 0    0   *
;*          S   M        M           3    00     0   00     0   *
;*   S      S   M        M    3      3    0      0   0      0   *
;*    SSSSSS    M        M     333333      000000     000000    *
;*                                                              *
;*                                                              *
;****************************************************************
.ENDIF
.IF	SM130
;****************************************************************
;*                                                              *
;*                                                              *
;*    SSSSSS    M        M        1        333333     000000    *
;*   S      S   MM      MM       11       3      3   0     00   *
;*   S          M M    M M      1 1              3   0    0 0   *
;*    S         M  M  M  M     1  1              3   0   0  0   *
;*     SSSS     M   MM   M    1   1          3333    0  0   0   *
;*         S    M        M        1              3   0 0    0   *
;*          S   M        M        1              3   00     0   *
;*   S      S   M        M        1       3      3   0      0   *
;*    SSSSSS    M        M    11111111     333333     000000    *
;*                                                              *
;*                                                              *
;****************************************************************
.ENDIF
.IF	DEBUG



;****************************************************************
;*                                                              *
;*                                                              *
;*    DDDDDDD    EEEEEEE   BBBBBB    U      U     GGGGGGG       *
;*    D      D   E         B     B   U      U    G              *
;*    D      D   E         B     B   U      U    G              *
;*    D      D   E         B     B   U      U    G              *
;*    D      D   EEEEE     BBBBBB    U      U    G   GGGG       *
;*    D      D   E         B     B   U      U    G       G      *
;*    D      D   E         B     B   U      U    G       G      *
;*    D      D   E         B     B   U      U    G       G      *
;*    DDDDDDD    EEEEEEE   BBBBBB     UUUUUU      GGGGGGG       *
;*                                                              *
;*                                                              *
;****************************************************************
.ENDIF
.IF	ROMABLE



;****************************************************************
;*                                                              *
;*                                                              *
;*   SSSSS   Y     Y   SSSSS       RRRRRR    OOOOO   M       M  *
;*  S     S  Y     Y  S     S      R     R  O     O  MM     MM  *
;*  S         Y   Y   S            R     R  O     O  M M   M M  *
;*   S        Y   Y    S           R     R  O     O  M  M M  M  *
;*    SSS      Y Y      SSS   ---  RRRRRR   O     O  M   M   M  *
;*       S      Y          S       R  R     O     O  M       M  *
;*        S     Y           S      R   R    O     O  M       M  *
;*  S     S     Y     S     S      R    R   O     O  M       M  *
;*   SSSSS      Y      SSSSS       R     R   OOOOO   M       M  *
;*                                                              *
;*                                                              *
;****************************************************************
.ENDIF



;==============================
;=== QUELQUES EXPLICATIONS: ===
;==============================
;
;Liste des commandes du drivers d'usart du SMAKY 324. (* = mode par dfaut)
;===========================================================================
;
;? :  ?    Affiche avec les appels du moniteur un micro-help.
;
;A :  AE    Affichage actif (Enable) sur leds, accepte par compatibilit du SMAKY 8.
;     AD    Affichage inactif (Disable) sur leds, accepte par compatibilit du SMAKY 8.
;
;B :  Bnnn  Baud-rate clock-generator en bauds (nnn: chiffre ascii).
;	   valeurs: 57600,38400 (SMAKY 324), 19200 (SMAKY 100 & 324),9600,7200,
;		    4800,3600,2400,2000,1800,1200,600,300,150,134,110,75 et 50.
;*	   Exemple B9600 (mode par dfaut).
;	   Utiliser plutt la commande V (B va disparatre).
;	   NOTE: sur SMAKY 324, des baud-rates quelconques peuvent tre envoys
;		 au drivers; la valeur relle est arrondie  la vitesse suprieure.
;		 celle-ci peut-tre connue avec l'appel read-status.
;     BE    envoie un BREAK sur la ligne TxDATA
;
;C :  C     Clear les erreurs sur les leds SM8 uniquement, (indpendant
;		des erreurs rendues aux appels), accepte par compatibilit du SMAKY 8.
;
;D :  D	   Dbloque xon-xoff en mission.
;     Dd   Facteur de division pour la PLL de l'usart: d = 1 ,16(*), 32 ou 64 en binaire (SM324 seul).
;
;F :  FE    Fifo actif (Enable). Indispensable pour xon-xoff en mission.
;*    FD    Fifo inactif (Disable).
;
;H :  HE    Haut-parleur actif (Enable); (read et write), accepte par compatibilit du SMAKY 8.
;     HD	   Haut-parleur inactif (Disable), accepte par compatibilit du SMAKY 8.
;
;L :  Ln    Longueur du mot en bits (n: chiffre ascii).
;	   valeurs: SMAKY 8 et 324: 5,6,7,8.	SMAKY 100: 7,8 uniquement.
;	   Attention sur SMAKY 324, les longueurs peuvent tre diffrentes
;		en entre et en sortie; il faut donc les spcifier deux fois: in et out.
;*	   Exemple L8 (mode par dfaut).
;
;M : sur SMAKY 324 uniquement: (* = mode par dfaut)
;*    MR	   Mode RS232: clock interne donn par le gnrateur de baud-rate.
;     MS	   Mode SIMSER: clock externe donn par la ligne TxCK de la prise S+.
;*    MHD   Mode HANDSHAKE disable: les lignes CTS et DCD sont inactive:
;		elle n'ont pas d'influence sur la rgulation de flux des caractres.
;     MHE   Mode HANDSHAKE enable: les lignes CTS et DCD sont active:
;		elle rgulent le flux des caractres, CTS en mission DCD en rception.
;     MHRE  Mode Handshake RTS Enable (RTS dsactiv pour XOFF, activ pour XON)  (RB)
;     MHRD  Mode Handshake RTS Disable
;     MHTE  Mode Handshake DTR Enable (DTR dsactiv pour XOFF, activ pour XON)
;     MHTD  Mode Handshake DTR Disable
;*    MED   Mode ERREUR anciennes: on gnre les anciens numros d'erreurs par compatibilit.
;     MEE   Mode ERREUR EXACTES: on gnre des numros d'erreurs un peu plus prcises.
;*    MP=   Mode Prise directe: sans croisement cd le mode normal.
;     MPX   Mode Prise croise: on croise les prises 1 et 3 en vue de transmission 1200/75.
;*    MAD   Mode AUTOECHO disable: mode normal.
;     MAE   Mode AUTOECHO enable: on renvoye tout ce qu'on recoi, mais on ne peut plus envoyer.
;*    MLD   Mode LOCAL_LOOP_BACK disable: mode normal.
;     MLE   Mode LOCAL_LOOP_BACK enable: on se renvoye tout ce qu'on envoye, mais plus de rception.
;*    MB7   Quartz du gnrateur de baud-rate  7.3728Mhz plaques D.
;     MB3   Quartz du gnrateur de baud-rate  3.6864Mhz plaques C.
;     MB4   Quartz du gnrateur de baud-rate  4Mhz.
;     MB8   Quartz du gnrateur de baud-rate  8Mhz.
;     MBH   Quartz du gnrateur de baud-rate  16MHz.
;     MBQqqqq Change la valeur du quartz du gnrateur de baud-rate: calcul des facteurs de division.
;     MIRaaaapppp Change l'adresse de la routine d'interruption en lecture du drivers.
;     MIWaaaapppp Change l'adresse de la routine d'interruption en criture du drivers.
;     MISaaaapppp Change l'adresse de la routine d'interruption spciale (DCD,BREAK,ERROR,CTS).
;		   Ces trois routines d'interruptions doivent se terminer par un RET. (pas de RETSF !!!)
;	   	   A2.32 contient l'adresse du priphrique DATA du Z8530.
;		   A3.32 contient l'adresse du priphrique COMMAND-STATUS du Z8530.
;		   A6.32 contient le pointeur donn lors du command. (par ex: pointeurs aux vars)
;	    	   D0.32 contient l'adresse de la routine d'interruption excute dans le drivers.
;		         pour excuter celle-ci normalement, faire: add.32 #4,sp ;jump {d0}.
;			 dans ce cas il ne faut modifier absolument AUCUN registres.
;		   dans le cas contraire, D0,D1,D7,A0,A1,A2 et A6 peuvent tre modifi  volont.
;     MDT   Active tous les dbugs du drivers.
;*    MDO   Enlve tous les dbugs du drivers.
;     MD0   Active le dbug d'entre des APPELs.
;     MD1   Active le dbug d'entre des ROUTines.
;     MD2   Active le dbug des ERReurs de lecture.
;     MD3   Active le dbug des XONxoff envoys et reus.
;     MD4   Active le dbug du processus PROCX de gestion des xon-xoff.
;     MD5   Active le dbug de l'activit SIMser.
;     MD6   Active le dbug des INTerruptions.
;     MD7   Active le dbug des SIGNals envoys aux smaphores.
;     MD8   Active le dbug des lignes CTS et DCD.
;     MD9   Active le dbug des COMMandes envoyes.
;
;N :  N	   Mode standard hardware, corr.  la chaine: L8S2PDW[9600.W]
;	   C'est  dire: 8 bits, 2 stop-bits, pas de parit, 9600 bds.
;	   Les variables softwares ne sont pas modifies !
;	   La commande: "NN", force un reset software qu'il faut cependant viter.
;		ATTENTION: cette commande modifie les paramtres internes des
;		DEUX CANAUX (in et out) du circuit usart; il faut donc
;		l'utiliser q'UNE SEULE FOIS lors de la premire commande;
;		en effet avec une deuxime commande N on dtruirait
;		les commande spcifie prcdament, y compris sur le premier canal !!!
;
;O :  ODE   Ligne en sortie DTR (data terminal ready) active (Enable).
;     ODD   Ligne en sortie DTR (data terminal ready) inactive (Disable).
;     ODX   Ligne en sortie DTR (data terminal ready) inchange au close read ni par read.
;*    ODC   Ligne en sortie DTR (data terminal ready) dsactive au close read.
;     ORE   Ligne en sortie RTS (request to send) active (Enable).
;     ORD   Ligne en sortie RTS (request to send) inactive (Disable).
;     ORX   Ligne en sortie RTS (request to send) inchange au close write ni par write.
;*    ORC   Ligne en sortie RTS (request to send) dsactive au close write.
;*	    Ces lignes sont actives automatiquement  chaque open,
;	     et dsactives  chaque close (read: DTR, write: RTS).
;in   OCaaaa Adresse du smaphore sur lequel le drivers effectue un ?SIGNAL lors d'une
;		variation de la ligne DCD, sur smaky 324 seulement.
;in   OBaaaa Adresse du smaphore sur lequel le drivers effectue un ?SIGNAL lors d'une
;		variation de la ligne RxDATA (BREAK), sur smaky 324 seulement.
;in   OEaaaa Adresse du smaphore sur lequel le drivers effectue un ?SIGNAL lors d'une
;		erreur dtecte sur la ligne RxDATA (parit,framming,overrun) sur sm324 seulement.
;out  OCaaaa Adresse du smaphore sur lequel le drivers effectue un ?SIGNAL lors d'une
;		variation de la ligne CTS, sur smaky 324 seulement.
;
;P :  PE    Parit paire (even).
;     PO    Parit impaire (odd).
;*    PD    Parit inactive (Disable).
;     PRpp  Caractres de remplacement en cas d'erreur de parit.(0==>pas de remplacement)
;
;R :  RE    Reptition xon-xoff en criture active (Enable).
;*    RD    Reptition xon-xoff en criture inactive (Disable).
;
;S :  S1    1 Stop bit.
;     S1.5  1 Stop bit et demi. Sur SMAKY 8 et SMAKY 324 seulement.
;*    S2    2 Stop bits.
;
;T :  Tnnn   Time-out par commande: aprs la commande YE seulement.
;	   nnn: chiffre ascii. (les units sont de 20 ms).
;	   Exemple T200 (valeur recommands de 4 secondes).
;	   Utiliser plutt la commande W (T va disparatre).
;
;V :  Vbb   Baud-rate clock-generator en bauds (bb: 2 bytes en binaire).
;	   idem  la commande B, mais avec la syntaxe standard: [xx.W].
;	   valeurs bb: 57600,38400 (SMAKY 324), 19200 (SMAKY 100 & 324),9600,7200,
;		    4800,3600,2400,2000,1800,1200,600,300,150,134,110,75 et 50.
;		    seuls les baud-rates de cette liste sont permis.
;*	   Exemple depuis le filer: V[9600.W] (mode par dfaut).
;
;W :  Wtt   Time-out par commande: aprs la commande YE seulement.
;	   tt: 2 bytes en binaire; idem  la commande B, mais avec
;	     la syntaxe standard: [xx.W].	xx: nombre de bauds.
;	   Exemple depuis le filer: W[200.W] (Time-out de 4 secondes).
;
;X :  XE    Mode xon-xoff activ (Enable); read et write spar.
;*    XD    Mode xon-xoff dsactiv (Disable); read et write spar.
;     XS    Equivaut  un XOFF recu en entre ==> bloque mission; commande read seulement.
;     XG    Equivaut  un XON recu en entre ==> redmarre mission; commande read seulement.
;     XX    Ne filtre pas les XON-XOFF en sortie donns par l'utilisateur; write seulement.
;*    XC    Filtre les XON-XOFF en sortie (conflit avec usart), si mode XE; write seulement.
;*    XNb   Code du caractre XON (b: byte en binaire), par dfaut D'17 (ctrl-Q)
;*    XFb   Code du caractre XOFF (b: byte en binaire), par dfaut D'19 (ctrl-S)
;	   En lecture n'est possible que si la comm. FE a dja t faite
;	   Le close supprime les modes xon-xoff; il faudra donc refaire
;	     ces commandes  chaques utilisation du driver aprs le OPEN
;	   Ces commandes ne peuvent donc pas tre utilises dans
;	     la macro  de dmarrage.
;
;Y :  YE    Met le mode: Time-out par commandes. (utiliser Wbb ou Bnnn).
;*    YD    Met le mode: Time-out donn par le processus courant:
;	     utiliser l'appel NTREL,?SETTIM pour dfinir le time-out.
;
;
; Activation du mode XON-XOFF:
;-------------------------------
;Pour mettre le mode xon-xoff, il faut respecter l'ordre qui suit:
;	-- open #MI
;	-- create #MO
;	-- open #MO
;	-- command #MI FEXE
;	-- command #MO XE
;travail  effectuer ...
;	-- close #mo	(le close supprime le mode xon-xoff !)
;	-- close #mi	(il faudra refaire la commande
;			  pour l'utiliser  nouveau).
;
;
; Macro de dmarrage conseille:
;--------------------------------
;	-- install #pr $usart_0
;	-- install #pp $usart_1
;	-- install #mi $usart_2
;	-- install #mo $usart_3
;	-- install #rsin $usart_4
;	-- install #rsout $usart_5
;	-- assign #load #pr
;	-- assign #punch #pp
;	-- assign #ttyin #mi
;	-- assign #ttyout #mo
;	-- command #load NYEW[200.W]FE
;	-- command #punch YEW[200.W]
;	-- command #mi NYEW[200.W]FE
;	-- command #mo YEW[200.W]
;	-- command #rsin NYEW[200.W]FE
;	-- command #rsout YEW[200.W]
;
;NB: Il est possible de dfinir la longueur du FIFO lors de l'INSTALL:
;
;	-- install #pr $usart_0 [100000.L]     (FIFO de 100000 caractres).
;
;    Une longueur minimale de 10'64 bytes est cependant impose par le driver.
;    La longueur par dfaut est de 10'512 bytes.
;
;
;
;
;Lien entre les fonctions du driver,les pins du Z8530, et les prise S+ et RS232.
;===============================================================================
;
;      fonction        pins Z8530     prise S+	   S+ et RS 232     prise S+	 pins Z8530	fonction
;----------------------------------					       --------------------------------
;				  i					       i
;			      	  i					       i   
;			      I	  i S+: VCC: 14			 S+: VCC: 14   i   I
;		 	      ---------------------	       ---------------------
;				  i RS: x			 RS: x	       i
;				  i					       i
;				  i					       i
;		       --------	  i S+: SYNC: 3			 S+: SYNC: 3   i   --------
;   ------------------>I TxCK I->------------------	       ------------------<-I TxCK I<-------------------
;   I		       --------	  i RS: x	  I            I RS: x	       i   --------                   I
;   I				  i		  I	       I	       i  			      I
;   I stop BRG (simser seulement) i  liaison dans I	       I liaison dans  i  (simser seulement) stop BRG I
;   I    ------ 		  i  la prise S+  I	       I la prise S+   i                   ------     I
;   I	/     I 		  i		  I	       I	       i		   I	 \    I
;-------V   --------		  i S+: RxCK: 4   I	       I S+: RxCK: 4   i	       --------   V-------
;I BRG I--->I READ I		  i --------------- --\    /-- --------------- i	       I READ I<---I BRG I
;-------    --------		  i RS: x	       \  /	 RS: x	       i	       --------	   -------
;   I				  i	                \/		       i			      I
;   V rs232			  i	          	/\		       i			rs232 V
;   I__O    ---------  --------	  i S+: TxCK: 11       /  \	 S+: TxCK: 11  i   --------   ---------    O__I
;        \->I WRITE I  I RxCK I-<------------------ --/	   \-- ------------------>-I RxCK I   I WRITE I<-/
;   ___O    ---------  --------	  i RS: x			 RS: x	       i   --------   ---------    O___
;   I simser	          I	  i					       i       I	       simser I
;   		          V	  i					       i       V		      
;   ----------<------------	  i					       i       ---------->-------------
;				  i					       i
;		    	-------	  i S+: TxD: 9			 S+: TxD: 9    i   -------
;			I TxD I->------------------ --\    /-- ------------------<-I TxD I
;			-------   i RS: TxD: 2	       \  /	 RS: TxD: 2    i   -------
;				  i			\/		       i
;				  i			/\		       i
;			-------	  i S+: RxD: 6	       /  \	 S+: RxD: 6    i   -------
;			I RxD I->------------------ --/    \-- ------------------<-I RxD I
;			-------   i RS: RxD: 3			 RS: RxD: 3    i   -------
;				  i					       i
;				  i					       i
;			-------	  i S+: DTR: 13			 S+: DTR: 13   i   -------
;			I DTR I->------------------ --\    /-- ------------------<-I DTR I
;			-------   i RS: DTR: 20	       \  /	 RS: DTR: 20   i   -------
;				  i			\/		       i
;				  i			/\		       i
;			-------	  i S+: CTS: 8	       /  \	 S+: CTS: 8    i   -------
;			I CTS I->------------------ --/    \-- ------------------<-I CTS I
;			-------   i RS: CTS: 5			 RS: CTS: 5    i   -------
;				  i					       i
;				  i					       i
;			-------	  i S+: RTS: 7			 S+: RTS: 7    i   -------
;			I RTS I->------------------ --\    /-- ------------------<-I RTS I
;			-------   i RS: RTS: 4	       \  /	 RS: RTS: 4    i   -------
;				  i			\/		       i
;				  i			/\		       i
;			-------	  i S+: DCD: 2	       /  \	 S+: DCD: 2    i   -------
;			I DCD I->------------------ --/    \-- ------------------<-I DCD I
;			-------   i RS: DCD: 8			 RS: DCD: 8    i   -------
;				  i					       i
;				  i					       i
;				  i S+: GND: 5,10		 S+: GND: 5,10 i
;		 	      ---------------------	       ---------------------
;			      I	  i RS: GND: 1,7		 RS: GND: 1,7  i   I
;			      /	  i					       i   /
;				  i					       i
;----------------------------------					       --------------------------------
;
;
;
;
;Organigrammes du drivers:
;==========================
;
;			     INTWRITE (routine d'interruption d'criture)
;			     ========
;				I
;			/---------------
;	---------------<    SENDXF>0 ? I
;	I		\---------------
;	I			O
; ----------------	---------------\
; I    wr car    I	I    WENABLE ?	>O-------------------------------------------------------
; ----------------	---------------/							I
;	I			I								I
; ----------------	---------------\							I
; I OLDXF=SENDXF I	I WRLONG = 0 ?  >----------------------------------------		I
; ----------------	---------------/					I		I
;	I			O						I		I
; ----------------	---------------\				----------------	I
; I   SENDXF=0   I	I XOUT+xf-car ? >----------------		I signal wr -> I	I
; ----------------	---------------/		I		----------------	I
;	I			O			I			I		I
;	I		---------------\		/			I		I
;	I		I    WSTOP ?    >---------------------------------------*----------------
;	I		---------------/		\			I
;	I			O			I			I
;	I		----------------	----------------		I
;	I		I     wr car   I	I     USERXF   I		I
;	I		----------------	----------------		I
;	I			I			I			I
;	I		----------------	----------------		I
;	I		I WRLONG-1,pts I	I signal xf -> I		I
;	I		----------------	----------------		I
;	I			I			I			I
;	I			I		----------------		I
;	I			I		I   (intsoft)  I		I
;	I			I		----------------		I
;	I			I			I			I
;	------------------------*------------------------			I
;				I						I
;			    ---------					    ---------
;			    I  ion  I					    I (iof) I
;			    ---------					    ---------
;								      (clear IP write Z8530)
;								    (toujours ION write sinon
;								  l'interrupt ne redmarre pas).
;
;
;		     INTREAD (routine d'interruption de lecture)
;		     =======
;			I
;		-----------------
;		I     rd car	I
;		-----------------
;			I
;		/----------------
;	-------< XIN + xf-car ?	I
;	I	\----------------
;	I		O
;	I	----------------\
;	I	I    DIRECT ?	 >O------------------------------
;	I	----------------/				I
;	I		I					I
;	I	-----------------			----------------\
;	I	I  put car dir	I			I   LGFIFO=0 ?	 >O--------------
;	I	-----------------			----------------/		I
;	I		I					I			I
;	I	-----------------			-----------------	-----------------
;	I	I RDLONG-1 +pts	I			I    poubelle	I	I  put car fifo	I
;	I	-----------------			-----------------	-----------------
;	I		I					I			I
;	I	----------------\				I		-----------------
;	I	I   RDLONG=0 ?	 >---------------		I		I LGFIFO-1 +pts	I
;	I	----------------/		I		I		-----------------
;	I		O			I		I			I
;----------------	I		-----------------	I		----------------\
;I  -> WSTOP	I	I		I   DIRECT=0	I	I		I LGFIFO >MAX ?	 >-------
;----------------	I		-----------------	I		----------------/	I
;	I		I			I		I			O		I
;----------------	I		-----------------	I			I	-----------------
;I signal xf ->	I	I		I signal rd ->	I	I			I	I    USA XOFF	I
;----------------	I		-----------------	I			I	-----------------
;	I		I			I		I			I		I
;	I		I			I		I			I	-----------------
;	I		I			I		I			I	I signal rd ->	I
;	I		I			I		I			I	-----------------
;	I		I			I		I			I		I
;	----------------*-----------------------*---------------*-----------------------*----------------
;								I
;							    ---------
;							    I  ion  I
;							    ---------
;
;
;		      SENDXF (processus de tratement des xon-xoff en mission)
;		      ======
;			I
;	----------------*   (1 processus par paire de canaux)
;	I		I
;	I	-----------------
;	I	I  wait xf <--	I
;	I	-----------------
;	I		I
;	I	----------------\
;	I	I    USA XF ?	 >---------------
;	I	----------------/		I
;	I		O			I
;	I	----------------\		I
;	I	I   USER XF ?	 >--------------*
;	I	----------------/		I
;	I		O			I
;	I	-----------------	-----------------
;	I	I   type XON	I	I   type XOFF	I
;	I	-----------------	-----------------
;	I		I			I
;	I		*------------------------
;	I		I
;	I	----------------\
;	I	I OLDXF=TYPEXF ? >O--------------
;	I	----------------/		I
;	I		I	     (OSXREPEAT <- #NBREPEAT)
;	I	----------------\		I
;	I	I REPEAT et	I		I
;	I	I OSXREPEAT>0 ?	 >--------------*
;	I	----------------/		I
;	I		O		   (OSXREPEAT-1)
;	I		I			I
;	I		I		-----------------
;	I		I		I   si XOUT:	I
;	I		I		I SENDXF=TYPEXF	I
;	I		I		-----------------
;	I		I			I
;	I		------------------------*
;	I					I
;	I				-----------------
;	I				I    memo clk	I (si xoff et mode RS232 on ne fait rien !)
;	I				I simser on/off	I (pas de stop BRG en mode RS232)
;	I				-----------------
;	I					I
;	I				-----------------
;	I				I  (ion write)	I (call INTWRITE, car on ne peut
;	I				-----------------	ractiver IP du Z8530)
;	O					I
;  -------------	-----------------	I
;  I  avort    I<-------I   envoi clk	I--------
;  I process ? I	I    simser 	I
;  -------------	-----------------
;	I
;	I
;    -------
;    I end I
;    -------
;
;
;
;      READ (routine de lecture du driver)			      WRITE (routine d'criture du driver)
;      ====							      =====
;	I								I
;---------------\						-----------------
;I    > fifo ?	 >O------					I wr long +pts	I
;---------------/	I					-----------------
;	I		I						I
;-----------------	I					-----------------
;I rd long + pts I	I					I    WENABLE	I
;-----------------	I					-----------------
;	I		I						I
;-----------------	I					-----------------
;I DIRECT + WAIT I	I					I signal xf -->	I --> ion write
;-----------------	I					-----------------
;	I		I						I
;	*----------------					-----------------
;	I							I  wait wr <--	I
;-----------------						-----------------
;I     copie	 I							I
;-----------------						-----------------
;	I							I  WENABLE = 0	I
;----------------\  (transition)				-----------------
;I LGFIFO < MIN ? >--------------					I
;----------------/		I				     -------
;	O		-----------------			     I ret I
;	I		I    USA XON	I			     -------
;	I		-----------------
;	I			I
;	I		-----------------
;	I		I SIGNAL XF -->	I
;	I		-----------------
;	I			I
;	*------------------------
;	I
;---------------\
;I     WAIT ?	 >---------------
;---------------/		I
;	O		-----------------
;	I		I    WAIT = 0	I
;	I		-----------------
;	I			I
;	I		-----------------
;	I		I  wait rd <--	I
;	I		-----------------
;	I			I
;	*------------------------
;	I
;    -------
;    I ret I
;    -------



;=======================
; Dfinitions HARDWARE =
;=======================

.IF	SM324
	.REF		SM324HARD
	.REF		SHIDRIV324
.ENDIF
.IF	SM196
	.REF		SM196HARD
.ENDIF
.IF	SM300
	.REF		SM300HARD
.ENDIF
.IF	SM130
	.REF		SM130HARD
.ENDIF
	.REF		M8SYS
	.REF		SMAKY
	.REF		BIOSDRIV
	.REF		DEFZ8530

BDRDOK		=	0			; SMAKY !!!
BDWROK		=	1			; SMAKY !!!

.IF	SM324
IPRPPVECT	=	0		; Numro de vecteur fourni par le SCC, BIDON.
IMIMOVECT	=	0		; Numro de vecteur fourni par le SCC, BIDON.
IRS232VECT	=	0		; Numro de vecteur fourni par le SCC, BIDON.
.ENDIF
.IF	SM196.OR.SM300.OR.SM130
ADPRPP		=	AdPP		; accs PP
ADSPRPP		=	AdStatPP	; accs status PP
IPRPPTRE	=	AdVectSccBTBE	; ch B Transmit Buffer Empty
IPRPPXST	=	AdVectSccBESC	; ch B External Status Change
IPRPPRCV	=	AdVectSccBRCA	; ch B Receive Character Available
IPRPPSRC	=	AdVectSccBSRC	; ch B Special Receive Condition
IPRPPVECT	=	AdVectScc/4	; Numro de vecteur fourni par le SCC.
.IF	SM196
ADRS232		=	AdRS		; accs au port RS 232
ADSRS232	=	AdStatRS	; accs au status du port RS 232
IRS232TRE	=	AdVectScc2BTBE	; ch B Transmit Buffer Empty
IRS232XST	=	AdVectScc2BESC	; ch B External Status Change
IRS232RCV	=	AdVectScc2BRCA	; ch B Receive Character Available
IRS232SRC	=	AdVectScc2BSRC	; ch B Special Receive Condition
IRS232VECT	=	AdVectScc2/4	; Numro de vecteur fourni par le SCC2.
.ENDIF
.IF	SM130
ADCLAV		=	Ad68705		; accs au port 68705K1
ADSCLAV		=	AdStat68705	; accs au status du port 68705K1
ICLAVTRE	=	AdVectScc2ATBE	; ch A Transmit Buffer Empty
ICLAVXST	=	AdVectScc2AESC	; ch A External Status Change
ICLAVRCV	=	AdVectScc2ARCA	; ch A Receive Character Available
ICLAVSRC	=	AdVectScc2ASRC	; ch A Special Receive Condition
ICLAVVECT	=	AdVectScc2/4	; Numro de vecteur fourni par le SCC2.

ADMIMO		=	AdMO		; accs au port MO
ADSMIMO		=	AdStatMO	; accs au status du port MO
IMIMOTRE	=	AdVectScc2BTBE	; ch B Transmit Buffer Empty
IMIMOXST	=	AdVectScc2BESC	; ch B External Status Change
IMIMORCV	=	AdVectScc2BRCA	; ch B Receive Character Available
IMIMOSRC	=	AdVectScc2BSRC	; ch B Special Receive Condition
IMIMOVECT	=	AdVectScc2/4	; Numro de vecteur fourni par le SCC2.
.ENDIF
.ENDIF



.IF	SM324.AND.OLDPLAQUE
NUM4OLDPLAC	=	10'4096+10'26-1	 ; Numro maximum des anciennes plaques SM324 B.
NUM3OLDPLAC	=	10'4096+10'126-1 ; Numro maximum des anciennes plaques SM324 C.
NUM_MAX324	=	10'4096+10'1024-1; Numro maximum des SM324 plaques D.
NUM_MAX196	=	10'4096+10'2048-1; Numro maximum des SM196.
NUM_MAX300	=	10'4096+10'4096-1; Numro maximum des SM300.
NUM_MAX130	=	16'0FFFF	 ; Numro maximum des SM130.
.ENDIF

; Dfinitions supplmentaires du Z8530:
;========================================

TYPEUSA		=	10'4		; Type d'usart du SM324: Z8530.

CKBDRATE	=	10'4000000	; Horloge du circuit Z8530 B.
NCCKBDRATE	=	10'3686400	; Nouvelle horloge du circuit Z8530 C.
NDCKBDRATE	=	10'7372800	; Nouvelle horloge du circuit Z8530 D.

NBREGZ8530	=	10'16		; Nombre des registres internes du Z8530: 0  15.

BRTSENA		=	1		; REG05	  Activation de la ligne RTS.
BDTRENA		=	7		; REG05	  Activation de la ligne DTR.
BTXIENA		=	1		; REG01	  Activation de l'interruption write.
BRIACSC		=	4		; REG01	  Activation de l'interruption read.
BEXIENA		=	0		; REG01	  Activation de l'interruption externe.
BBRGENA		=	0		; REG14	  Activation du clock simser (BRG on/off).
BTCKBRG		=	4		; REG11	  Activation du mode RS232. (write=BRG et pas RxCK).
BAUTOEN		=	5		; REG03	  Activation HANDSHAKE CTS & DCD autoenable.
BPARENA		=	0		; REG04	  Activation de la parit enable.
BPAREVE		=	1		; REG04	  Activation de la parit even.
BSTOB12		=	2		; REG02	  Activation de 1 ou 2 stops bits.
BSTOB152	=	3		; REG02	  Activation de 1,5 ou 2stops bits.
BT68BITS	=	6		; REG05	  Activation de 6 ou 8 bits de longueur en mission.
BT78BITS	=	5		; REG05	  Activation de 7 ou 8 bits de longueur en mission.
BR68BCAR	=	7		; REG03	  Activation de 6 ou 8 bits de longueur en rception.
BR78BCAR	=	6		; REG03	  Activation de 7 ou 8 bits de longueur en rception.
BSENDBR		=	4		; REG05	  Activation du send break.
BLOLOBA		=	4		; REG14	  Activation du local loop back.
BAUTECH		=	3		; REG14	  Activation du auto echo.



; Numros d'erreurs du drivers d'usart:
;=======================================

ERBASE		=	16'0700			; Erreur de base du drivers d'usart.
EROV		=	ERBASE+0+0+1		; Erreur d'overrun.
ERFR		=	ERBASE+0+2+0		; Erreur de framming.
EROVFR		=	ERBASE+0+2+1		; Erreur d'overrun et de framming.
ERPA		=	ERBASE+4+0+0		; Erreur de parit.
EROVPA		=	ERBASE+4+0+1		; Erreur d'overrun et de parit.
ERFRPA		=	ERBASE+4+2+0		; Erreur de framming et de parit.
EROVFRPA	=	ERBASE+4+2+1		; Erreur d'overrun, de framming et de parit.

ERFIFO		=	ERBASE+16'10		; Erreur fifo dborde (caractre dans la poubelle).



;=======================
; Dfinitions SOFTWARE =
;=======================

.IF	SM196
MASKUSART	=	16'600			; Masque d'interruption niveau USART.
.ELSE
MASKUSART	=	16'500			; Masque d'interruption niveau USART.
.ENDIF
SMIOF		=	16'700			; Masque d'interruption de niveau max.
ANDMASK		=	-1-SMIOF+MASKUSART	; Masque pour effectuer le AND.16 avec SF.



; Dfinitions du protocole XON-XOFF:
;====================================

CHARXON		=	8'21			; Valeur du caractre XON.
CHARXOFF	=	8'23			; Valeur du caractre XOFF.

DIMFIFO		=	10'1024			; Longueur en bytes du FIFO par defaut.
DIMMINFIFO	=	10'64			; Longueur minimale pour un FIFO.

MAXFIFO		=	DIMFIFO*3/4		; Limite pour l'envoi d'un XOFF.
MINFIFO		=	DIMFIFO*1/4		; Limite pour l'envoi d'un XON.

;;;NREPEATXON	=	10'10			; Nombre de rptition des XON-XOFF.



; FLAGS internes au driver:
;===========================

; GENERAL au driver: ODRIVFLAG0
BCROISE13	=	0			; Croise les prises de l'usart 1 et 3.



; GENERAL au driver: ODEBUG.16
VDEBUG		=	-1			; Debug GENeral.
BAPPELDEBUG	=	10'0			; Dbug d'entre des APPELs.
BROUTDEBUG	=	10'1			; Dbug d'entre des ROUTines.
BERRORDEBUG	=	10'2			; Dbug des ERReurs de lecture.
BXONXOFFDEBUG	=	10'3			; Dbug des XONxoff envoys et reus.
BPROCXDEBUG	=	10'4			; Dbug du processus PROCX de gestion des xon-xoff.
BSIMDEBUG	=	10'5			; Dbug de l'activit SIMser.
BINTDEBUG	=	10'6			; Dbug  des INTerruptions.
BSIGNALDEBUG	=	10'7			; Dbug des SIGNals envoys aux smaphores.
BEXTDEBUG	=	10'8			; Dbug des lignes CTS et DCD.
BCOMMDEBUG	=	10'9			; Dbug des COMMandes envoyes.



; READ: OSRFLG0
BR0ENABLE	=	0			; Lecture active: paramtres ok.
BR0AVORT	=	1			; Avorte la lecture.
BR0DIRECT	=	2			; Mode direct ou fifo.
BR0USECAR	=	3			; Au moins un caractre lu.
BR0ERROR	=	4			; Erreur dtecte.
BR0POUBELLE	=	5			; Caractres mis  la poubelle.
BR0OLDDTR	=	6			; Etat de la ligne DTR avant l'appel du read.
BR0WAIT		=	7			; Il faut attendre la fin du mode direct.

; READ: OSRFLG1
BR1HRTSEnable	=	0			; Handshake rception par RTS (XOFF -> RTS disable)
BR1HDTREnable	=	1			; Handshake rception par DTR (XOFF -> DTR disable)

; WRITE: OSWFLG0
BW0ENABLE	=	0			; Ecriture active: paramtres ok.
BW0AVORT	=	1			; Avorte l'criture.
BW0STOP		=	2			; Emission stoppe: XOFF reu.
BW0USECAR	=	3			; Au moins un caractre crit.
BW0OLDRTS	=	4			; Etat de la ligne RTS avant l'appel du write.
BW0OLDBRK	=	5			; Etat du send break avant l'appel du write.
BW0PROCSXF	=	6			; Call effectu depuis le processus PROCSENDXF.

; WRITE: OSWFLG1

; MODE read & write: OSMFLG0
BM0XIN		=	0			; Les caractres XON-XOFF lus sont interprts.
BM0XOUT		=	1			; Les caractres XON-XOFF  crire sont interprts.
BM0NOFIFO	=	2			; Pas de FIFO pour la rception des caractres.
BM0RTIMO	=	3			; Time out en rception donn par commande, sinon par processus courant.
BM0WTIMO	=	4			; Time out en mission donn par commande, sinon par processus courant.
BM0REPEATXON	=	5			; Rptition des caractres XON-XOFF.
BM0BDEXACT	=	6			; Time-out exact donn par la commande B[xxx.W]
BM0ERRPR	=	7			; Erreurs usart prcises: overrun, framming, parit.

; MODE read & write: OSMFLG1
BM1NCDTR	=	0			; Empche le changement du DTR au close read.
BM1NCRTS	=	1			; Empche le changement du RTS au close write.
BM1NFX		=	2			; Ne filtre pas les xon-xoff user en sortie.

; Gestion XON-XOFF: OSXFLG0
BX0USERXOFF	=	0			; XOFF envoy de l'utilisateur.
BX0USARTXOFF	=	1			; XOFF dcid par le driver.
BX0TYPEXOFF	=	2			; Type de XON-XOFF  envoyer.
BX0OLDXOFF	=	3			; Dernier XON-XOFF envoy.
BX0AVORTPROC	=	4			; Avorte le processus de traitement des xon-xoff.



;===========================================
; Dfinitions pour l'utilisateur: RDSTATUS =
;===========================================

BSPERR		=	0			; P	Parity error.
BSOERR		=	1			; O	Overrun error.
BSFERR		=	2			; F	Framming error.
BSPEN		=	3			; E	Parity enable.
BSEVP		=	4			; P	Even parity.
BSFIFO		=	5			; B	Mode avec fifo.
BSXIN		=	6			; I	Mode xon-xoff en entre.
BSXOUT		=	7			; O	Mode xon-xoff en sortie.


BSL1		=	0			; Length car 1.
BSL2		=	1			; Length car 2.
; BSL1	BSL2
;  0	 0		==> 5 bits.
;  1	 0		==> 6 bits.
;  0	 1		==> 7 bits.
;  1	 1		==> 8 bits.

BSB1		=	2			; Stop bit 1.
BSB2		=	3			; Stop bit 2.
; BSB1	BSB2
;  0	 0		==> invalid
;  1	 0		==> 1 bit.
;  0	 1		==> 1.5 bits.
;  1	 1		==> 2 bits.

BSDSR		=	4			; D	Ligne DSR (SM100: DCD).
BSLED		=	5			; L	Affichage sur leds.
BSHP		=	6			; H	Activation haut-parleur.
BSXREPE		=	7			; R	Rptition envoi xon-xoff user.


BSDTR		=	0			; D	Etat ligne en sortie DTR.
BSRTS		=	1			; R	Etat ligne en sortie RTS.
BSCTS		=	2			; C	Etat ligne en entre CTS.
BSBRK		=	3			; B	Etat ligne en entre RxCK, break.

BS8251		=	4			; 8	Type de circuit usart: 8251.
BS6850		=	5			; 1	Type de circuit usart: 6850.
BS8530		=	6			; 1	Type de circuit usart: 8530.

BSXRCV		=	0			; R	Xon ou xoff recu (flow out), xoff=1.
BSXSEND		=	1			; W	Xon ou xoff envoy (flow in), xoff=1.
BSHRTS		=	2			; HR	Handshake par RTS en rception buffer plein
BSHDTR		=	3			; HD	Idem
BSHCTSDCD	 =	4			; HCD	Handshake CTS coupe mission, DCD coupe la rception


; rsum des flags:
;
;	---------------------------------
;	I O . I . B . P . E . F . O . P I
;	---------------------------------
;	I R . H	. L . D I s-bit	I l-car	I
;	---------------------------------
;	I				I
;	I-- -- -- -- bit rate - -- -- --I
;	I				I
;	---------------------------------
;	I				I
;	I-- -- -- length fifo - -- -- --I
;	I				I
;	---------------------------------
;	I				I
;	I-- -- -- time-out read -- -- --I
;	I				I
;	---------------------------------
;	I				I
;	I-- -- - time-out write -- -- --I
;	I				I
;	---------------------------------
;	I				I
;	I-- -- -- -- -- -- -- -- -- -- -I
;	I				I
;	I-- --  Longueur du fifo -- -- -I
;	I				I
;	I-- -- -- -- -- -- -- -- -- -- -I
;	I				I
;	---------------------------------
;	I   . 3 . 1 . 8 I B . C . R . D I
;	---------------------------------
;	I  code ASCII du caractre XON	I
;	---------------------------------
;	I  code ASCII du caractre XOFF	I
;	---------------------------------
;	I   .   .   .HCD.HD .HR . W . R I
;	---------------------------------


; Dfinitions des variables rstatus:
;====================================

	.LOC	0
; Buffer read_status: OSTATUT
OSTAFLG:	.BLK.16		1		; Flags, errors , lenght car.
OSTABR:		.BLK.16		1		; Bit-rate.
OSTALENG:	.BLK.16		1		; Nb de caractres dans le fifo.
OSTARTIM:	.BLK.16		1		; Time-out read.
OSTAWTIM:	.BLK.16		1		; Time-out write.
OSTAFIFO:	.BLK.32		1		; Longueur du fifo.
OSTATYPE:	.BLK.8		1		; Type de circuit usart, flags.
OSTAXON:	.BLK.8		1		; Valeur du caractre xon.
OSTAXOFF:	.BLK.8		1		; Valeur du caractre xoff.
OSTAXRW:	.BLK.8		1		; Flags xon-xoff rcv-send.
.EVEN
LSTATUT:



;======================================
; Dfinitions des VARIABLES du driver =
;======================================

		.LOC	0
; Paramtres du fichier driver:
;===============================
ODRIVFLAG0:	.BLK.8		1		; Flags 0 du fichier drivers.
ODRIVFLAG1:	.BLK.8		1		; Flags 1 du fichier drivers.
.EVEN
ODEBUG:		.BLK.16		1		; Flags de dbug.
.EVEN
LPARAM:



		.LOC	0
; Ressources SOFTWARES indissociables: OSOFTn
;=============================================
; Read:
;=======
OSRFLG0:	.BLK.8		1		; Flags 0 des routines de lecture.
OSRFLG1:	.BLK.8		1		; Flags 1 des routines de lecture.
.EVEN
OSRERROR:	.BLK.8		1		; Erreur dtecte: tat masqu du REG01 du Z8530.
OSRERREAD:	.BLK.8		1		; Erreur dtecte lors du READ.
OSRPOUBELLE:	.BLK.8		1		; Code du dernier caractre mis  la boubelle.
OSRPARIT:	.BLK.8		2		; Caractres de remplacement en cas d'erreur de parit.
.EVEN
OSRCOUNT:	.BLK.32		1		; Compteur TOTAL des datas  lire.
OSRDIMFIFO:	.BLK.32		1		; Longueur du FIFO en bytes.
OSRMAXFIFO:	.BLK.32		1		; Limite pour l'envoi d'un XOFF.
OSRMINFIFO:	.BLK.32		1		; Limite pour l'envoi d'un XON.
OSRLONGFIFO:	.BLK.32		1		; NOMBRE de caractres dans le FIFO
OSRADBEGINFIFO:	.BLK.32		1		; Adresse de DEBUT du FIFO.
OSRADENDFIFO:	.BLK.32		1		; Adresse de FIN du FIFO.
OSRADREADFIFO:	.BLK.32		1		; Adresse de LECTURE du FIFO.
OSRADWRITEFIFO:	.BLK.32		1		; Adresse d'ECRITURE du FIFO.
OSRADDIRECT:	.BLK.32		1		; Adresse de lecture DIRECTE en mmoire.
OSRLONGDIRECT:	.BLK.32		1		; Nombre de caractres  lire DIRECTEMENT dans la mmoire.
OSRADTERMIN:	.BLK.32		1		; Pointeur aux TERMINATEURS.
OSRADSEMAREAD:	.BLK.32		1		; Pointeur au SEMAPHORE de lecture.
OSRADSEMADCD:	.BLK.32		1		; Pointeur au SEMAPHORE DCD.
OSRADSEMABRK:	.BLK.32		1		; Pointeur au SEMAPHORE BREAK.
OSRADSEMAERR:	.BLK.32		1		; Pointeur au SEMAPHORE ERROR.
OSRTIMEOUT:	.BLK.16		1		; Valeur du TIME-OUT de rception par commande.
OSRCOUNTOPEN:	.BLK.8		1		; Compte les OPENs read effectus.
.EVEN

; Write:
;========
OSWFLG0:	.BLK.8		1		; Flags 0 des routines d'criture.
OSWFLG1:	.BLK.8		1		; Flags 1 des routines d'criture.
.EVEN
OSWCOUNT:	.BLK.32		1		; Compteur TOTAL des datas  crire.
OSWADDATA:	.BLK.32		1		; ADRESSE des caractres  envoyer.
OSWLONGDATA:	.BLK.32		1		; NOMBRE de caractres  envoyer.
OSWADTERMIN:	.BLK.32		1		; Pointeur aux TERMINATEURS.
OSWADSEMAWRITE:	.BLK.32		1		; Pointeur au SEMAPHORE d'criture.
OSWADSEMACTS:	.BLK.32		1		; Pointeur au SEMAPHORE CTS.
OSWTIMEOUT:	.BLK.16		1		; Valeur du TIME-OUT d'mission par commande.
OSWCOUNTOPEN:	.BLK.8		1		; Compte les OPENs write effectus.
.EVEN

; MODE read & write INDISSOCIABLE, gestion XON-XOFF en commun:
;==============================================================
OSMFLG0:	.BLK.8		1		; Flags 0 du mode read & write.
OSMFLG1:	.BLK.8		1		; Flags 1 du mode read & write.
OSXFLG0:	.BLK.8		1		; Flags 0 de la gestion XON-XOFF.
OSXFLG1:	.BLK.8		1		; Flags 1 de la gestion XON-XOFF.
.EVEN
OSXSENDXOFF:	.BLK.8		1		; Caractre XON-XOFF  envoyer.
OSXON:		.BLK.8		1		; Valeur du caractre XON.
OSXOFF:		.BLK.8		1		; Valeur du caractre XOFF.
.EVEN
OSXREPEAT:	.BLK.8		1		; Nombre de rptition des XON-XOFF.
.EVEN
OSXADSEMAXOFF:	.BLK.32		1		; Pointeur au SEMAPHORE de xon-xoff.
OSXADKILLPROC:	.BLK.32		1		; Pointeur au SEMAPHORE d'avort du processus.
LVARSOFT:



		.LOC	0
; Ressources HARDWARES indissociables: OHARDn
;=============================================

OHPOINTAUX:	.BLK.32		1		; Pt aux vars user dans les int aux. (donn par comm:MI)
OHADINTRDAUX:	.BLK.32		1		; Adresse d'interruption read auxiliaire. (comm:MI)
OHADINTWRAUX:	.BLK.32		1		; Adresse d'interruption write auxiliaire. (comm:MI)
OHADINTSPAUX:	.BLK.32		1		; Adresse d'interruption spciale auxiliaire.  (comm:MI)
OHUSART:	.BLK.32		1		; Adresse de lecture-criture des DATA de l'USART.
OHSUSART:	.BLK.32		1		; Adresse de l'accs aux registres int de l'USART.
OHADINTREAD:	.BLK.32		1		; Ad de la rout d'interruption de LECTURE.
OHADINTERROR:	.BLK.32		1		; Ad de la rout d'interruption d'ERREUR de lecture.
OHADINTWRITE:	.BLK.32		1		; Ad de la rout d'interruption d'ECRITURE.
OHADINTSPEC:	.BLK.32		1		; Ad de la rout d'interr des CONDITIONS SPECIALES.
OHREGMODIF:	.BLK.16		1		; Bits pour signaler la modif d'un registre du Z8530.
OHCOUNTRESET:	.BLK.8		1		; Compte les INSTALL (RESET) effectu.
OHSTATUS:	.BLK.8		1		; Status dja mmoris du Z8530 REG00.
OHCMBDRATE:	.BLK.32		1		; Constante de division pour le baud-rate.
OHREGISTRES:	.BLK.8		NBREGZ8530	; Copie des registres internes du Z8530.
.EVEN
LVARHARD:



; Somme des variables du fichier driver usart:
;==============================================

	.LOC	0
OPARAM:		.BLK.8		LPARAM		; Paramtrisation du FICHIER DRIVERS: debug...
OSTATUT:	.BLK.8		LSTATUT		; Buffer du READ-STATUS.
OSOFTA:		.BLK.8		LVARSOFT	; Longueur des variables SOFT A: read & write, xon xoff.
OSOFTB:		.BLK.8		LVARSOFT	; Longueur des variables SOFT B: read & write, xon xoff.
OSOFTC:		.BLK.8		LVARSOFT	; Longueur des variables SOFT C: read & write, xon xoff.
OHARDA:		.BLK.8		LVARHARD	; Longueur des variables HARD A: ressources communes du Z8530.
OHARDB:		.BLK.8		LVARHARD	; Longueur des variables HARD B: ressources communes du Z8530.
OHARDC:		.BLK.8		LVARHARD	; Longueur des variables HARD C: ressources communes du Z8530.
LONGVAR:



;=================================================================
; Lien priphrique - canal/circuit:				;=
;===================================				;=
;								;=
;	$RSIN - $RSOUT	=	SCC_0 + OSCCCAN_A   (RS232)	;=
;	$PR - $PP	=	SCC_0 + OSCCCAN_B		;=
;								;=
;	$ZNET		=	SCC_1 + OSCCCAN_A		;=
;	$MI - $MO	=	SCC_1 + OSCCCAN_B		;=
;								;=
;								;=
;								;=
;=================================================================
; Dfinitions des liens CANAUX_DRIVER avec CANAUX Z8530		;=
;========================================================	;=
;								;=
; USART_n:	    periph	OHARDn		OSOFTn		;=
;								;=
; USART_0 (in)	    $PR		OHARDA		OSOFTA		;=
; USART_1 (out)	    $PP		OHARDA		OSOFTA		;=
; USART_2 (in)	    $MI		OHARDB		OSOFTB		;=
; USART_3 (out)	    $MO		OHARDB		OSOFTB		;=
; USART_4 (in)	    $RSIN	OHARDC		OSOFTC		;=
; USART_5 (out)	    $RSOUT	OHARDC		OSOFTC		;=
;								;=
; Explications:							;=
;	Par exemple le drivers 0 (USART_0), correspondant	;=
;	 au priphrique $PR, utilise les priphriques		;=
;	 en communs du groupe A (OHARDA), ainsi que		;=
;	 le protocole xon-xoff/simser A (OSOFTA);		;=
;	Dans la table TABPTDIRECT cela correspond  la ligne:	;=
;	  .32 ADPRPP,ADSPRPP,OHARDA,OSOFTA  ; USART_0		;=
;	Les six lignes ci-dessus configurent le smaky en	;=
;	 MODE NORMAL c. d. sans croisement de lignes usart	;=
;	Elles correspondent aux six lignes de la table		;=
;	 TABPTDIRECT (GETPOINT, GETPT)				;=
;								;=
; Autre EXEMPLE:						;=
;	Il est possible de permutter les sorties au niveau	;=
;	 des prises afin d'avoir des modes diffrents en	;=
;	 entre et en sortie (liaisons MODEM 1200/75 Bds).	;=
;	Autrement dit de crer une prise RS232 avec les		;=
;	 circuits $PR et $MO, (et une autre avec $MI et $PP).	;=
;	Pour cela il suffit de faire le protocole xon-xoff	;=
;	 entre l'entre du premier circuit usart $PR et la	;=
;	 sortie du second circuit $MO, (idem pour $MI et $PP).	;=
;	ATTENTION: cela implique une DEPENDANCE HARDWARE	;=
;	 entre l'entre de la premire prise $PR et la sortie	;=
;	 de la seconde prise $PP, puisqu'elles proviennent	;=
;	 du mme canal du mme circuit Z8530 !!! ==> OHARDA	;=
;								;=
;	Croisons par exemple, les sorties $PP et $MO		;=
;								;=
; USART_n:	    periph	OHARDn		OSOFTn		;=
;								;=
; USART_0 (in)	    $PR		OHARDA		OSOFTA		;=
; USART_1 (out)	    $PP		OAHRDA		OSOFTB	!!!	;=
; USART_2 (in)	    $MI		OHARDB		OSOFTB		;=
; USART_3 (out)	    $MO		OHARDB		OSOFTA	!!!	;=
;								;=
; USART_4 (in)	    $RSIN	OHARDC		OSOFTC		;=
; USART_5 (out)	    $RSOUT	OHARDC		OSOFTC		;=
;								;=
;=================================================================



;=========================
; Dfinition des  MACROS =
;=========================

.MACRO	WAIT1_5US
.IF	SM300
	TEST.16		ADRET700		; 2*700ns = 1400
.ELSE
.IF	SM130
	TEST.32		ADRET350		; 4*350ns = 1400
.ELSE
	RR.8		#8,D0			; macro WAIT1_5US.
	RR.8		#8,D0
	RR.8		#8,D0
	RR.8		#8,D0
.ENDIF
.ENDIF
.ENDMACRO

.MACRO	WAIT1_7US
.IF	SM300
	TEST.16		ADRET700		; 2*700ns
	TEST.8		ADRET350		;         +350ns = 1750
.ELSE
.IF	SM130
	TEST.16		ADRET500		; 2*500ns
	TEST.16		ADRET350		; 	  +2*350ns = 1700
.ELSE
	RR.8		#8,D0			; macro WAIT1_7US.
	RR.8		#8,D0
	RR.8		#8,D0
	RR.8		#8,D0
	RR.8		#8,D0
.ENDIF
.ENDIF
.ENDMACRO

.MACRO	LOCK
	PUSH.16		SF
	OR.16		#SMIOF,SF		; On bloque tout...
	AND.16		#ANDMASK,SF		; On remet au dessus de l'usart.
	WAIT1_5US
.ENDMACRO

.MACRO	UNLOCK
	POP.16		SF			; On dbloque tout...
.ENDMACRO

.MACRO	SETREG		; numro_du_registre,numro_du_bit
	OR.16		#2**%1,{A1}+OHREGMODIF	; Met un bit pour signaler la modif d'un registre.
	TSET.8		{A1}+OHREGISTRES+%1:#%2	; Met  1 le bit %2 du registre %1.
.ENDMACRO

.MACRO	CLRREG		; numro_du_registre,numro_du_bit
	OR.16		#2**%1,{A1}+OHREGMODIF	; Met un bit pour signaler la modif d'un registre.
	TCLR.8		{A1}+OHREGISTRES+%1:#%2	; Met  1 le bit %2 du registre %1.
.ENDMACRO

.MACRO		TEXTDEBUG ; Type de dbug,symbole_d'un_caractre_(space,cr...),texte_sans_guillemets.
.LOCALMACRO	NOTEXT
.IF		DEBUG
	PUSH.16		D0
	MOVE.16		{A6}+OPARAM+ODEBUG,D0
	JUMP,EQ		NOTEXT
	TEST.32		D0:#B%1DEBUG
	JUMP,BC		NOTEXT
	PUSH.16		D7
	.16		?AFTIM
	.ASCIZE		"<%2>%3"
	POP.16		D7
NOTEXT:	POP.16		D0
.ENDIF
.ENDMACRO

.MACRO		INTTXDEB ; Type de dbug,symbole_d'un_caractre_(space,cr...),texte_sans_guillemets.
.LOCALMACRO	NOTEXT
.IF		DEBUG
	MOVE.16		{A6}+OPARAM+ODEBUG,D0
	JUMP,EQ		NOTEXT
	TEST.32		D0:#B%1DEBUG
	JUMP,BC		NOTEXT
	PUSH.16		D7
	.16		?AFTIM
	.ASCIZE		"<%2>%3"
	POP.16		D7
NOTEXT:
.ENDIF
.ENDMACRO

.MACRO		LODA6APPEL			; Charge A6  l'entre des appels du drivers.
.IF		ROMABLE
.ELSE
	PUSH.32		A6
	MOVE.32		R16^PTVARS,A6
.ENDIF
.ENDMACRO

.MACRO			LODA0INT		; Charge A0  l'entre des routines d'interruption.
.IF		ROMABLE
.ELSE
	MOVE.32		R16^PTVARS,A0
.ENDIF
.ENDMACRO

.MACRO		POPA6APPEL			; Charge A6  l'entre des appels du drivers.
.IF		ROMABLE
.ELSE
	POP.32		A6
.ENDIF
.ENDMACRO

.MACRO		PUTA6VAR			; Charge le pointeur aux variables donn dans A6.
.IF		ROMABLE
.ELSE
	PUSH.32		A0
	MOVE.32		#R16^PTVARS,A0
	MOVE.32		A6,{A0}
	POP.32		A0
.ENDIF
.ENDMACRO



;===========================
; Dbut du CODE  du driver =
;===========================

	.REV		NREV,NVER
.IF	SM324
	.IDENT		"DRIVER d'USART Z8530 du SMAKY 324 rev: 8-6, 1 avril 1992 14:00 resp: GvR."
.ENDIF
.IF	SM196
	.IDENT		"DRIVER d'USART Z8530 du SMAKY 196 rev: 8-6, 1 avril 1992 14:00 resp: GvR."
.ENDIF
.IF	SM300
	.IDENT		"DRIVER d'USART Z8530 du SMAKY 300 rev: 8-6, 1 avril 1992 14:00 resp: GvR."
.ENDIF
.IF	SM130
	.IDENT		"(C) 1988-1994 Gilles van Ruymbeke, (C) 1997 EPSITEC SA"
.ENDIF
	.LOC		0



DRIVERS:					; Dbut du code: adresse 0 RELATIVE.
	.16	0,R0BASE
	.16	1,W1BASE
.IF	SM324.OR.SM196.OR.SM130
.IF	SM324.OR.SM130
	.16	2,R2BASE
	.16	3,W3BASE
.ENDIF
	.16	4,R4BASE
	.16	5,W5BASE
.ENDIF
	.16	2**7



;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;	(read)		DRIVER $USART_0		No 16'80	#pr	+=
;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
R0ID$:
	.16	ROPEN-R0BASE		; Adresse routines
	.16	RCOMMAND-R0BASE
	.16	RSTATUS-R0BASE
	.16	READ-R0BASE
	.16	-1
	.16	RCLOSE-R0BASE
	.16	-1			; STOPTR-R0BASE
	.16	-1			; STARTR-R0BASE
	.16	RAVORT-R0BASE
	.16	-1			; RAUX1-R0BASE
	.16	-1			; RAUX2-R0BASE
	.16	RRESET-R0BASE
	.16	RKILL-R0BASE
	.16	-1			; RSTRT-R0BASE
	.16	-1			; RTSTRT-R0BASE
	.16	-1			; RSTART-R0BASE
R0NAB$:
	.ASCII	"USART_0"		; Nom driver
R0NAF$:	.FILL.8	LGDNAM-(R0NAF$-R0NAB$),0

	.8	16'80			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	NREV,NVER		; Rvision - version
	.8	2,0			; Priorit.

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDNORT	; Attribut 0

	.FILL.8	LGDDESC-(APC-R0ID$),0	; Le reste.
R0BASE:



;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;	(write)		DRIVER $USART_1		No 16'81	#pp	+=
;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
W1ID$:
	.16	WOPEN-W1BASE		; Adresse routines
	.16	WCOMMAND-W1BASE
	.16	WSTATUS-W1BASE
	.16	-1
	.16	WRITE-W1BASE
	.16	WCLOSE-W1BASE
	.16	-1			; STOPTR-W1BASE
	.16	-1			; STARTR-W1BASE
	.16	WAVORT-W1BASE
	.16	-1			; WAUX1-W1BASE
	.16	-1			; WAUX2-W1BASE
	.16	WRESET-W1BASE
	.16	WKILL-W1BASE
	.16	-1			; WSTRT-W1BASE
	.16	-1			; WTSTRT-W1BASE
	.16	-1			; WSTART-W1BASE
W1NAB$:
	.ASCII	"USART_1"		; Nom driver
W1NAF$:	.FILL.8	LGDNAM-(W1NAF$-W1NAB$),0

	.8	16'81			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	NREV,NVER		; Rvision - version
	.8	2,0			; Priorit.

	.8	0			; Attribut 1
	.8	2**BDWROK.OR.2**BDNORT	; Attribut 0

	.FILL.8	LGDDESC-(APC-W1ID$),0	; Le reste.
W1BASE:



.IF	SM324.OR.SM196.OR.SM130
.IF	SM324.OR.SM130
;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;	(read)		DRIVER $USART_2		No 16'82	#mi	+=
;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
R2ID$:
	.16	ROPEN-R2BASE		; Adresse routines
	.16	RCOMMAND-R2BASE
	.16	RSTATUS-R2BASE
	.16	READ-R2BASE
	.16	-1
	.16	RCLOSE-R2BASE
	.16	-1			; STOPTR-R2BASE
	.16	-1			; STARTR-R2BASE
	.16	RAVORT-R2BASE
	.16	-1			; RAUX1-R2BASE
	.16	-1			; RAUX2-R2BASE
	.16	RRESET-R2BASE
	.16	RKILL-R2BASE
	.16	-1			; RSTRT-R2BASE
	.16	-1			; RTSTRT-R2BASE
	.16	-1			; RSTART-R2BASE
R2NAB$:
	.ASCII	"USART_2"		; Nom driver
R2NAF$:	.FILL.8	LGDNAM-(R2NAF$-R2NAB$),0

	.8	16'82			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	NREV,NVER		; Rvision - version
	.8	2,0			; Priorit.

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDNORT	; Attribut 0

	.FILL.8	LGDDESC-(APC-R2ID$),0	; Le reste.
R2BASE:



;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;	(write)		DRIVER $USART_3		No 16'83	#mo	+=
;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
W3ID$:
	.16	WOPEN-W3BASE		; Adresse routines
	.16	WCOMMAND-W3BASE
	.16	WSTATUS-W3BASE
	.16	-1
	.16	WRITE-W3BASE
	.16	WCLOSE-W3BASE
	.16	-1			; STOPTR-W3BASE
	.16	-1			; STARTR-W3BASE
	.16	WAVORT-W3BASE
	.16	-1			; WAUX1-W3BASE
	.16	-1			; WAUX2-W3BASE
	.16	WRESET-W3BASE
	.16	WKILL-W3BASE
	.16	-1			; WSTRT-W3BASE
	.16	-1			; WTSTRT-W3BASE
	.16	-1			; WSTART-W3BASE
W3NAB$:
	.ASCII	"USART_3"		; Nom driver
W3NAF$:	.FILL.8	LGDNAM-(W3NAF$-W3NAB$),0

	.8	16'83			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	NREV,NVER		; Rvision - version
	.8	2,0			; Priorit.

	.8	0			; Attribut 1
	.8	2**BDWROK.OR.2**BDNORT	; Attribut 0

	.FILL.8	LGDDESC-(APC-W3ID$),0	; Le reste.
W3BASE:



.ENDIF
;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;	(read)		DRIVER $USART_4		No 16'84	#rsin	+=
;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
R4ID$:
	.16	ROPEN-R4BASE		; Adresse routines
	.16	RCOMMAND-R4BASE
	.16	RSTATUS-R4BASE
	.16	READ-R4BASE
	.16	-1
	.16	RCLOSE-R4BASE
	.16	-1			; STOPTR-R4BASE
	.16	-1			; STARTR-R4BASE
	.16	RAVORT-R4BASE
	.16	-1			; RAUX1-R4BASE
	.16	-1			; RAUX2-R4BASE
	.16	RRESET-R4BASE
	.16	RKILL-R4BASE
	.16	-1			; RSTRT-R4BASE
	.16	-1			; RTSTRT-R4BASE
	.16	-1			; RSTART-R4BASE
R4NAB$:
	.ASCII	"USART_4"		; Nom driver
R4NAF$:	.FILL.8	LGDNAM-(R4NAF$-R4NAB$),0

	.8	16'84			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	NREV,NVER		; Rvision - version
	.8	2,0			; Priorit.

	.8	0			; Attribut 1
	.8	2**BDRDOK.OR.2**BDNORT	; Attribut 0

	.FILL.8	LGDDESC-(APC-R4ID$),0	; Le reste.
R4BASE:



;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;	(write)		DRIVER $USART_5		No 16'85	#rsout	+=
;=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
W5ID$:
	.16	WOPEN-W5BASE		; Adresse routines
	.16	WCOMMAND-W5BASE
	.16	WSTATUS-W5BASE
	.16	-1
	.16	WRITE-W5BASE
	.16	WCLOSE-W5BASE
	.16	-1			; STOPTR-W5BASE
	.16	-1			; STARTR-W5BASE
	.16	WAVORT-W5BASE
	.16	-1			; WAUX1-W5BASE
	.16	-1			; WAUX2-W5BASE
	.16	WRESET-W5BASE
	.16	WKILL-W5BASE
	.16	-1			; WSTRT-W5BASE
	.16	-1			; WTSTRT-W5BASE
	.16	-1			; WSTART-W5BASE
W5NAB$:
	.ASCII	"USART_5"		; Nom driver
W5NAF$:	.FILL.8	LGDNAM-(W5NAF$-W5NAB$),0

	.8	16'85			; Numro driver
	.8	TYPIO			; Type: Streamer

	.8	NREV,NVER		; Rvision - version
	.8	2,0			; Priorit.

	.8	0			; Attribut 1
	.8	2**BDWROK.OR.2**BDNORT	; Attribut 0

	.FILL.8	LGDDESC-(APC-W5ID$),0	; Le reste.
W5BASE:
.ENDIF



;================================================================
; PARTIE SPECIFIQUE AU SMAKY !!! RESSOURCES HARDWARES COMMUNES:	=
;     ADRESSES, MODES, COMMANDES USART ET BIT-RATE COMMUNS.	=
;================================================================



;----------\
; INITSOFT  >
;==========/

; Attribue  tous les drivers: USART_0, USART_2, USART_4 (USART_1,3,5 pas besoin)
; leur ressources hardwares indissociables: OHARDA, OHARDB, OHARDC
; et y met les adresses de priphriques et des routines d'interruption correspondantes.
; in	--
; out	--
; mod:	--

INITSOFT:
	TEXTDEBUG	ROUT,SPACE,INITSOFT
	PUSHM.32	D0|D1|A0|A1

	MOVE.32		#0,D0			; Numro du driver 0 & 1.
	CALL		GETPT			; Va chercher les pointeurs aux variables.
	MOVE.32		D0,{A1}+OHUSART		; Adresse du priphrique DATA du Z8530.
	MOVE.32		D1,{A1}+OHSUSART	; Adresse du priphrique COMMAND-STATUS du Z8530.
	MOVE.32		#R16^INTR_0,A0
	MOVE.32		A0,{A1}+OHADINTREAD	; Interruption de LECTURE.
	MOVE.32		#R16^INTR_0,A0
	MOVE.32		A0,{A1}+OHADINTERROR	; Interruption d'ERREUR de lecture.
	MOVE.32		#R16^INTW_1,A0
	MOVE.32		A0,{A1}+OHADINTWRITE	; Interruption d'ECRITURE.
	MOVE.32		#R16^INTS_0,A0
	MOVE.32		A0,{A1}+OHADINTSPEC	; Interr des CONDITIONS SPECIALES.

.IF	SM324.OR.SM196.OR.SM130
.IF	SM324.OR.SM130
	MOVE.32		#2,D0			; Numro du driver 2 & 3.
	CALL		GETPT			; Va chercher les pointeurs aux variables.
	MOVE.32		D0,{A1}+OHUSART		; Adresse du priphrique DATA du Z8530.
	MOVE.32		D1,{A1}+OHSUSART	; Adresse du priphrique COMMAND-STATUS du Z8530.
	MOVE.32		#R16^INTR_2,A0
	MOVE.32		A0,{A1}+OHADINTREAD	; Interruption de LECTURE.
	MOVE.32		#R16^INTR_2,A0
	MOVE.32		A0,{A1}+OHADINTERROR	; Interruption d'ERREUR de lecture.
	MOVE.32		#R16^INTW_3,A0
	MOVE.32		A0,{A1}+OHADINTWRITE	; Interruption d'ECRITURE.
	MOVE.32		#R16^INTS_2,A0
	MOVE.32		A0,{A1}+OHADINTSPEC	; Interr des CONDITIONS SPECIALES.

.ENDIF
	MOVE.32		#4,D0			; Numro du driver 4 & 5.
	CALL		GETPT			; Va chercher les pointeurs aux variables.
	MOVE.32		D0,{A1}+OHUSART		; Adresse du priphrique DATA du Z8530.
	MOVE.32		D1,{A1}+OHSUSART	; Adresse du priphrique COMMAND-STATUS du Z8530.
	MOVE.32		#R16^INTR_4,A0
	MOVE.32		A0,{A1}+OHADINTREAD	; Interruption de LECTURE.
	MOVE.32		#R16^INTR_4,A0
	MOVE.32		A0,{A1}+OHADINTERROR	; Interruption d'ERREUR de lecture.
	MOVE.32		#R16^INTW_5,A0
	MOVE.32		A0,{A1}+OHADINTWRITE	; Interruption d'ECRITURE.
	MOVE.32		#R16^INTS_4,A0
	MOVE.32		A0,{A1}+OHADINTSPEC	; Interr des CONDITIONS SPECIALES.

.ENDIF
	POPM.32		D0|D1|A0|A1
	RET



;------------\
; KILLVECT    >
;============/

; Supprime les vecteurs d'interruptions.
; in;	A1.32	^variables HARD du driver.
; out	--
; mod	--

KILLVECT:
	TEXTDEBUG	ROUT,SPACE,KILLVECT
	CLR.32		{A1}+OHADINTREAD	; Interruption de LECTURE.
	CLR.32		{A1}+OHADINTERROR	; Interruption d'ERREUR de lecture.
	CLR.32		{A1}+OHADINTWRITE	; Interruption d'ECRITURE.
	CLR.32		{A1}+OHADINTSPEC	; Interr des CONDITIONS SPECIALES.
	RET



;----------\
; INITHARD  >
;==========/

; INITIALISE les vecteurs d'INTERRUPTIONS et le canal correspondant du CIRCUIT Z8530.
; in;	A1.32	^variables HARD du driver: OHUSART ==> canal.
; out	--
; mod	--

INITHARD:
	TEXTDEBUG	ROUT,SPACE,INITHARD
	PUSHM.32	D0|D1|A0|A1|A2|A3
 	MOVE.32		#R16^TABVECTEUR,A2	; Table des autovecteurs des nouvelles plaques D.
.IF	SM324.AND.OLDPLAQUE
	PUSHM.32	D4|D7
	NTREL		?GETMACHINE
	COMP.16		#NUM3OLDPLAC,D4		; Numro maximum des anciennes plaques C.
	JUMP,HI		NEW$
	MOVE.32		#R16^TAB3VECTEUR,A2	; Table des autovecteurs des anciennes plaques C.
	COMP.16		#NUM4OLDPLAC,D4		; Numro maximum des anciennes plaques B.
	JUMP,HI		NEW$
	MOVE.32		#R16^TAB4VECTEUR,A2	; Table des autovecteurs des anciennes plaques B.
NEW$:	POPM.32		D4|D7
.ENDIF
	MOVE.32		{A1}+OHUSART,D0		; Adresse du priphrique DATA du Z8530.
LOOP$:	COMP.32		{A2+},D0
	JUMP,EQ		FINDVECT$
	ADD.32		#5*2+2*4,A2
	COMP.32		#2**7,{A2}
	JUMP,NE		LOOP$
	.16		?AFTIM
	.ASCIZE		"<CR>init vecteur int usart, AD$ incorrecte.<CR>"
	TRAP #10'10
	JUMP		FIN$
FINDVECT$:
.IF	SM324
	MOVE.32		32^_INDSHI,A0
	MOVE.32		A1,A3
	MOVE.16		{A2+},D1		; Routine d'interruption de LECTURE.
	MOVE.32		{A3}+OHADINTREAD,A1
	CALL		{A0}+_INIADRINT
	MOVE.16		{A2+},D1		; Routine d'interruption d'ERREUR de lecture.
	MOVE.32		{A3}+OHADINTERROR,A1
	CALL		{A0}+_INIADRINT
	MOVE.16		{A2+},D1		; Routine d'interruption d'ECRITURE.
	MOVE.32		{A3}+OHADINTWRITE,A1
	CALL		{A0}+_INIADRINT
	MOVE.16		{A2+},D1		; Routine d'interruption de CONDITION SPECIALE.
	MOVE.32		{A3}+OHADINTSPEC,A1
	CALL		{A0}+_INIADRINT
.ENDIF
.IF	SM196.OR.SM300.OR.SM130
	PUSH.32	A4
	MOVE.32		32^_INDNTR,A4
	MOVE.32		A1,A3
	CLR.32		D1
	MOVE.16		{A2+},D1		; Routine d'interruption de LECTURE.
	MOVE.32		D1,A0
	MOVE.32		{A3}+OHADINTREAD,A1
	CALL		{A4}+OIN_INITVECTOR
	MOVE.16		{A2+},D1		; Routine d'interruption d'ERREUR de lecture.
	MOVE.32		D1,A0
	MOVE.32		{A3}+OHADINTERROR,A1
	CALL		{A4}+OIN_INITVECTOR
	MOVE.16		{A2+},D1		; Routine d'interruption d'ECRITURE.
	MOVE.32		D1,A0
	MOVE.32		{A3}+OHADINTWRITE,A1
	CALL		{A4}+OIN_INITVECTOR
	MOVE.16		{A2+},D1		; Routine d'interruption de CONDITION SPECIALE.
	MOVE.32		D1,A0
	MOVE.32		{A3}+OHADINTSPEC,A1
	CALL		{A4}+OIN_INITVECTOR
	POP.32	A4
.ENDIF
	MOVE.32		{A2+},{A3}+OHCMBDRATE	; Constante de division du bdrate.
	CLR.16		{A3}+OHREGMODIF		; Tous les registres vont tre mis  jour.
	MOVE.32		{A3}+OHSUSART,A0	; A0: Pt au priphrique COMMAND-STATUS du Z8530.
	MOVE.32		#{A3}+OHREGISTRES,A1	; A1: Pt  la copie des registres internes du Z8530.
	MOVE.32		#R16^DRIVERS,A3
	ADD.32		{A2+},A3		; A3: Pointeur  la table d'initialisation du Z8530.
	LOCK
	TEST.8		{A0}			; Met le Z8530 dans un tat connu: tout accs termin
	WAIT1_7US
	TEST.8		{A0}			; Met le Z8530 dans un tat connu: tout accs termin
	UNLOCK
INITREG$:					; Initialise le canal du SCC Z8530.
	COMP.8		#2**7,{A3}
	JUMP,EQ		FIN$
	LOCK
	MOVE.8		{A3},{A0}		; Envoie le numro du registre.
	MOVE.8		{A3+},D0
	AND.16		#16'F,D0		; D0: numro du registre pour la copie en mmoire.
	MOVE.8		{A3},{A1}+A16^{D0}	; Initialise la pos mm correspondant au registre.
	WAIT1_7US
	MOVE.8		{A3+},{A0}		; Envoie le contenu du registre.
	UNLOCK
	JUMP		INITREG$
FIN$:
.IF	SM196.OR.SM300.OR.SM130
	MOVE.16		#16'2,D0		; Vecteur d'interruption dans le registre 2.
	LOCK
	MOVE.8		D0,{A0}			; Envoie le numro du registre.
	MOVE.16		{A2},D1
	MOVE.8		D1,{A1}+A16^{D0}	; Initialise la pos mm correspondant au registre.
	WAIT1_7US
	MOVE.8		D1,{A0}			; Envoie le contenu du registre.
	UNLOCK
.ENDIF
	POPM.32		D0|D1|A0|A1|A2|A3
	RET


.IF	SM130
TABVECTEUR:			;$per,  read,    error,   write,   special, quartz,   tabinit,  vectint.
	.32.16.16.16.16.32.32.16 ADPRPP,IPRPPRCV,IPRPPSRC,IPRPPTRE,IPRPPXST,CMBDRATE16,TINIT16,IPRPPVECT
	.32.16.16.16.16.32.32.16 ADMIMO,IMIMORCV,IMIMOSRC,IMIMOTRE,IMIMOXST,CMBDRATE8,TINIT8,IMIMOVECT
	.32.16.16.16.16.32.32.16 ADCLAV,ICLAVRCV,ICLAVSRC,ICLAVTRE,ICLAVXST,CMBDRATE8,TINIT8,ICLAVVECT
	.32			2**7		; Fin de la table.
.ENDIF
.IF	SM196.OR.SM300
TABVECTEUR:			;$per,  read,    error,   write,   special, quartz,   tabinit,  vectint.
;;	.32.16.16.16.16.32.32.16 ADPRPP,IPRPPRCV,IPRPPSRC,IPRPPTRE,IPRPPXST,CMBDRATE8,TINIT8,IPRPPVECT
	.32.16.16.16.16.32.32.16 ADPRPP,IPRPPRCV,IPRPPSRC,IPRPPTRE,IPRPPXST,CMBDRATE16,TINIT16,IPRPPVECT
.IF	SM196
	.32.16.16.16.16.32.32.16 ADRS232,IRS232RCV,IRS232SRC,IRS232TRE,IRS232XST,CMBDRATE7,TINIT7,IRS232VECT
.ENDIF
	.32			2**7		; Fin de la table.
.ENDIF
.IF	SM324
TABVECTEUR:			;$per,  read,    error,   write,   special, quartz,   tabinit,  vectint.
	.32.16.16.16.16.32.32.16 ADPRPP,IPRPPRCV,IPRPPSRC,IPRPPTRE,IPRPPXST,CMBDRATE7,TINIT7,IPRPPVECT
	.32.16.16.16.16.32.32.16 ADMIMO,IMIMORCV,IMIMOSRC,IMIMOTRE,IMIMOXST,CMBDRATE8,TINIT8,IMIMOVECT
	.32.16.16.16.16.32.32.16 ADRS232,IRS232RCV,IRS232SRC,IRS232TRE,IRS232XST,CMBDRATE7,TINIT7,IRS232VECT
	.32			2**7		; Fin de la table.

TAB3VECTEUR:			;$per,  read,    error,   write,   special, quartz,   tabinit,  vectint.
	.32.16.16.16.16.32.32.16 ADPRPP,IPRPPRCV,IPRPPSRC,IPRPPTRE,IPRPPXST,CMBDRATE3,TINIT3,IPRPPVECT
	.32.16.16.16.16.32.32.16 ADMIMO,IMIMORCV,IMIMOSRC,IMIMOTRE,IMIMOXST,CMBDRATE8,TINIT8,IMIMOVECT
	.32.16.16.16.16.32.32.16 ADRS232,IRS232RCV,IRS232SRC,IRS232TRE,IRS232XST,CMBDRATE3,TINIT3,IRS232VECT
	.32			2**7		; Fin de la table.

TAB4VECTEUR:			;$per,  read,    error,   write,   special, quartz,   tabinit,  vectint.
	.32.16.16.16.16.32.32.16 ADPRPP,IPRPPRCV,IPRPPSRC,IPRPPTRE,IPRPPXST,CMBDRATE4,TINIT4,IPRPPVECT
	.32.16.16.16.16.32.32.16 ADMIMO,IMIMORCV,IMIMOSRC,IMIMOTRE,IMIMOXST,CMBDRATE4,TINIT4,IMIMOVECT
	.32.16.16.16.16.32.32.16 ADRS232,IRS232RCV,IRS232SRC,IRS232TRE,IRS232XST,CMBDRATE4,TINIT4,IRS232VECT
	.32			2**7		; Fin de la table.
.ENDIF



TINIT7:						; RS232 (write=BRG), et BRG on avec MB3:
	.8	REG04.OR.RESESI			; Clock x 16, 2 stop-bits, pas de parit.
	.8	CLKX16.OR.STOB02.OR.PARDIS.OR.PAREVE
	.8	REG12				; 9600 Bds, avec MB7. 
	.8	16'16
	.8	REG13				; 9600 Bds, avec MB7.
	.8	16'0
	.8	REG11				; Pas de quartz, read=BRG, write=BRG, TxCK out=BRG.
	.8	NOXTAL.OR.RCKBRG.OR.TCKBRG.OR.TRCOUT.OR.BRGOUT	;    RS232
	.8	REG10				; Codage NRZ.
	.8	CODNRZ
	.8	REG14				; Codage criture NRZ, DTR actif, BRG actif de pin pCLK.
	.8	SENRZI.OR.DTRFUN.OR.BRGSCK.OR.BRGENA
	.8	REG03				; 8 bits par car lu, DCD et CTS sans fonction, READ actif.
	.8	R8BCAR.OR.RCVENA
	.8	REG05				; 8 bits par car mis, DTR inactif, RTS inactif, WRITE actif.
	.8	T8BITS.OR.DTRDIS.OR.RTSDIS.OR.TRXDEN
	.8	REG15				; interrupt pour CTS, DCD et BREAK.
	.8	CTSSIE.OR.DCDSIE.OR.BRABIE
	.8	REG01				; interrupt READ, ERROR, WRITE, et STATUS sont inactifs, la parit est une erreur.
	.8	RIDISA.OR.PARISC.OR.TXIDIS.OR.EXIDIS
.IF	SM196.OR.SM300.OR.SM130
	.8	REG09
	.8	NORESE.OR.MOD321.OR.MASTIE.OR.VECTIS ; Vecteurs status poids faibles.
.ENDIF
	.8	2**7				; Fin de la table
	.EVEN



TINIT3:						; RS232 (write=BRG), et BRG on avec MB3:
	.8	REG04.OR.RESESI			; Clock x 16, 2 stop-bits, pas de parit.
	.8	CLKX16.OR.STOB02.OR.PARDIS.OR.PAREVE
	.8	REG12				; 9600 Bds, avec MB3. 
	.8	16'A
	.8	REG13				; 9600 Bds, avec MB3.
	.8	16'0
	.8	REG11				; Pas de quartz, read=BRG, write=BRG, TxCK out=BRG.
	.8	NOXTAL.OR.RCKBRG.OR.TCKBRG.OR.TRCOUT.OR.BRGOUT	;    RS232
	.8	REG10				; Codage NRZ.
	.8	CODNRZ
	.8	REG14				; Codage criture NRZ, DTR actif, BRG actif de pin pCLK.
	.8	SENRZI.OR.DTRFUN.OR.BRGSCK.OR.BRGENA
	.8	REG03				; 8 bits par car lu, DCD et CTS sans fonction, READ actif.
	.8	R8BCAR.OR.RCVENA
	.8	REG05				; 8 bits par car mis, DTR inactif, RTS inactif, WRITE actif.
	.8	T8BITS.OR.DTRDIS.OR.RTSDIS.OR.TRXDEN
	.8	REG15				; interrupt pour CTS, DCD et BREAK.
	.8	CTSSIE.OR.DCDSIE.OR.BRABIE
	.8	REG01				; interrupt READ, ERROR, WRITE, et STATUS sont inactifs, la parit est une erreur.
	.8	RIDISA.OR.PARISC.OR.TXIDIS.OR.EXIDIS
.IF	SM196.OR.SM300.OR.SM130
	.8	REG09
	.8	NORESE.OR.MOD321.OR.MASTIE.OR.VECTIS ; Vecteurs status poids faibles.
.ENDIF
	.8	2**7				; Fin de la table
	.EVEN



TINIT8:						; RS232 (write=BRG), et BRG on avec MB8:
	.8	REG04.OR.RESESI			; Clock x 16, 2 stop-bits, pas de parit.
	.8	CLKX16.OR.STOB02.OR.PARDIS.OR.PAREVE
	.8	REG12				; 9600 Bds, avec MB8. 
	.8	16'18
	.8	REG13				; 9600 Bds, avec MB8.
	.8	16'0
	.8	REG11				; Pas de quartz, read=BRG, write=BRG, TxCK out=BRG.
	.8	NOXTAL.OR.RCKBRG.OR.TCKBRG.OR.TRCOUT.OR.BRGOUT	;    RS232
	.8	REG10				; Codage NRZ.
	.8	CODNRZ
	.8	REG14				; Codage criture NRZ, DTR actif, BRG actif de pin pCLK.
	.8	SENRZI.OR.DTRFUN.OR.BRGSCK.OR.BRGENA
	.8	REG03				; 8 bits par car lu, DCD et CTS sans fonction, READ actif.
	.8	R8BCAR.OR.RCVENA
	.8	REG05				; 8 bits par car mis, DTR inactif, RTS inactif, WRITE actif.
	.8	T8BITS.OR.DTRDIS.OR.RTSDIS.OR.TRXDEN
	.8	REG15				; interrupt pour CTS, DCD et BREAK.
	.8	CTSSIE.OR.DCDSIE.OR.BRABIE
	.8	REG01				; interrupt READ, ERROR, WRITE, et STATUS sont inactifs, la parit est une erreur.
	.8	RIDISA.OR.PARISC.OR.TXIDIS.OR.EXIDIS
.IF	SM196.OR.SM300.OR.SM130
	.8	REG09
	.8	NORESE.OR.MOD321.OR.MASTIE.OR.VECTIS ; Vecteurs status poids faibles.
.ENDIF
	.8	2**7				; Fin de la table
	.EVEN



TINIT4:						; RS232 (write=BRG), et BRG on avec MB4:
	.8	REG04.OR.RESESI			; Clock x 16, 2 stop-bits, pas de parit.
	.8	CLKX16.OR.STOB02.OR.PARDIS.OR.PAREVE
	.8	REG12				; 9600 Bds, avec MB4. 
	.8	16'B
	.8	REG13				; 9600 Bds, avec MB4.
	.8	16'0
	.8	REG11				; Pas de quartz, read=BRG, write=BRG, TxCK out=BRG.
	.8	NOXTAL.OR.RCKBRG.OR.TCKBRG.OR.TRCOUT.OR.BRGOUT	;    RS232
	.8	REG10				; Codage NRZ.
	.8	CODNRZ
	.8	REG14				; Codage criture NRZ, DTR actif, BRG actif de pin pCLK.
	.8	SENRZI.OR.DTRFUN.OR.BRGSCK.OR.BRGENA
	.8	REG03				; 8 bits par car lu, DCD et CTS sans fonction, READ actif.
	.8	R8BCAR.OR.RCVENA
	.8	REG05				; 8 bits par car mis, DTR inactif, RTS inactif, WRITE actif.
	.8	T8BITS.OR.DTRDIS.OR.RTSDIS.OR.TRXDEN
	.8	REG15				; interrupt pour CTS, DCD et BREAK.
	.8	CTSSIE.OR.DCDSIE.OR.BRABIE
	.8	REG01				; interrupt READ, ERROR, WRITE, et STATUS sont inactifs, la parit est une erreur.
	.8	RIDISA.OR.PARISC.OR.TXIDIS.OR.EXIDIS
.IF	SM196.OR.SM300.OR.SM130
	.8	REG09
	.8	NORESE.OR.MOD321.OR.MASTIE.OR.VECTIS ; Vecteurs status poids faibles.
.ENDIF
	.8	2**7				; Fin de la table
	.EVEN



TINIT16:					; RS232 (write=BRG), et BRG on avec MB4:
	.8	REG04.OR.RESESI			; Clock x 16, 2 stop-bits, pas de parit.
	.8	CLKX16.OR.STOB02.OR.PARDIS.OR.PAREVE
	.8	REG12				; 9600 Bds, avec MBH. 
	.8	16'32
	.8	REG13				; 9600 Bds, avec MBH.
	.8	16'0
	.8	REG11				; Pas de quartz, read=BRG, write=BRG, TxCK out=BRG.
	.8	NOXTAL.OR.RCKBRG.OR.TCKBRG.OR.TRCOUT.OR.BRGOUT	;    RS232
	.8	REG10				; Codage NRZ.
	.8	CODNRZ
	.8	REG14				; Codage criture NRZ, DTR actif, BRG actif de pin pCLK.
	.8	SENRZI.OR.DTRFUN.OR.BRGSCK.OR.BRGENA
	.8	REG03				; 8 bits par car lu, DCD et CTS sans fonction, READ actif.
	.8	R8BCAR.OR.RCVENA
	.8	REG05				; 8 bits par car mis, DTR inactif, RTS inactif, WRITE actif.
	.8	T8BITS.OR.DTRDIS.OR.RTSDIS.OR.TRXDEN
	.8	REG15				; interrupt pour CTS, DCD et BREAK.
	.8	CTSSIE.OR.DCDSIE.OR.BRABIE
	.8	REG01				; interrupt READ, ERROR, WRITE, et STATUS sont inactifs, la parit est une erreur.
	.8	RIDISA.OR.PARISC.OR.TXIDIS.OR.EXIDIS
.IF	SM196.OR.SM300.OR.SM130
	.8	REG09
	.8	NORESE.OR.MOD321.OR.MASTIE.OR.VECTIS ; Vecteurs status poids faibles.
.ENDIF
	.8	2**7				; Fin de la table
	.EVEN



;---------\
; SENDREG  >
;=========/

; Met  jour les registres internes du Z8530 qui doivent tre modifis.
; in	A0.32	^variables SOFT du driver.
;	A1.32	^variables HARD du driver.
; out	--
; mod:	--

SENDREG:
	TEXTDEBUG	ROUT,SPACE,SENDREG
	PUSHM.32	D0|D1|A0|A1

	MOVE.16		{A1}+OHREGMODIF,D1	; 1 bit par registre  modifier.
	CLR.16		{A1}+OHREGMODIF
	MOVE.32		{A1}+OHSUSART,A0	; Adresse du priphrique COMMAND-STATUS du Z8530.
	MOVE.32		#{A1}+OHREGISTRES,A1	; Adresses de la copie des registres du Z8530.
	CLR.16		D0

	TCLR.32		D1:#REG04		; Faut-il envoyer le registre 4 en premier?
	JUMP,BC		LOOP$			; non ==> on envoye les autres registres.
	LOCK
	MOVE.8		#REG04,{A0}		; On envoye le registre 4.
	WAIT1_7US
	MOVE.8		{A1}+REG04,{A0}		; On envoye le contenu.
	UNLOCK

LOOP$:	TEST.32		D1:D0			; On envoye les autres registres.
	JUMP,BC		NOMOD$
	LOCK
	MOVE.8		D0,{A0}			; Numro du registre.
	WAIT1_7US
	MOVE.8		{A1}+A16^{D0},{A0}	; Contenu du registre.
	UNLOCK
NOMOD$:	INC.16		D0
	COMP.16		#NBREGZ8530,D0		; On a fini ?
	JUMP,NE		LOOP$			; non ==> on continue.
	POPM.32		D0|D1|A0|A1
	RET



;====================================================================
; Routine donnant les pointeur correspondants  chacuns des appels. =
;====================================================================

;---------\
; INITVAR  >
;=========/

; Va chercher la mmoire pour le FICHIER DRIVER.
; in	--
; out	A6.32	^aux variables du fichier driver.
; mod:	A6.32

INITVAR:
.IF	ROMABLE
	PUSHM.32	D4|A0|A4
	MOVE.32		#R16^DRIVERS,A4		; A4: base du drivers en ABSOLU.
	MOVE.32		#LONGVAR,D4		; D4: longueur des variables.
	PUSH.32		A3			; bug fos...
	FOS		?GETCOMMEM   ;?GETABMEM	; Demande mmoire au FOS pour driver romable.
	POP.32		A3			; bug fos...
	MOVE.32		A4,A6			; A6: pointeur aux variables.
	POPM.32		D4|A0|A4
	TEST.16		D7
	RET
.ELSE
	PUSHM.32	D4|A0|A4
	MOVE.32		A6,D0			; Variables dj initialises ?
	JUMP,NE		OK$			; oui ==> on en fait rien
	MOVE.32		#LONGVAR,D4		; D4: longueur des variables.
	MOVE.32		#R16^VARIABLES,A4	; A4: pointeur aux variables 
;;;	MOVE.32		A0,A1			; A1: base du drivers.
;;;	MOVE.16		#MTYPBD,D1		; D1: Type de compte gesmem.
;;;	GESMEM		?GETMEM
;;;	JUMP,NE		OK$			; Erreur ==> on saute tout.
	MOVE.32		A4,A6			; A6: pointeur aux variables.
	PUTA6VAR				; Mmorise l'adresse des variables.
LOOP$:	TEST.32		D4			; Met  zro les variables.
	JUMP,EQ		OK$
	CLR.8		{A4+}			; On efface.
	DEC.32		D4			; Travail fini ?
	JUMP,NE		LOOP$			; non ==> on continue
OK$:	POPM.32		D4|A0|A4
	TEST.16		D7
	RET
.ENDIF



;----------\
; GETPOINT  >
;==========/

; Donne les pointeurs aux variables du driver en fonction du pointeur  leur base.
; in	A0.32	^base du drivers
;	A6.32	^aux variables globales du fichier driver.
; out	D0.32	^Priphrique DATA.
;	D1.32	^Priphrique COMMAND/STATUS.
;	A0.32	^variables du driver SOFT.
;	A1.32	^variables du driver HARD.
; mod:	D0,D1,A0,A1.32

GETPOINT:
	TEXTDEBUG	ROUT,SPACE,GETPOINT
	MOVE.32		#R16^DRIVERS,A1		; Cherche le numro du driver ==> D0.32
	SUB.32		A1,A0
	MOVE.32		A0,D0			; D0: adresse relative de la base du driver.
LOOP$:	COMP.16		{A1}+2,D0		; Numro trouv ?
	JUMP,EQ		OK$			; oui ==> ok trouv
	ADD.32		#4,A1
	COMP.16		#2**7,{A1}		; Fin de la table ?
	JUMP,NE		LOOP$			; non ==> tout va bien, on continue.
	.16		?AFTIM
	.ASCIZE		"<CR>POINTEUR VARIABLES USART FAUX<CR>"
	TRAP #10'10
	CLR.32		D0			; On rcupre les pots casss...
	JUMP		GETPT
OK$:
	CLR.32		D0
	MOVE.16		{A1},D0
GETPT:						; Donne les pointeurs aux variables.
	TEXTDEBUG	ROUT,SPACE,GETPT
	TEST.8		{A6}+OPARAM+ODRIVFLAG0:#BCROISE13 ; Croise les prises de l'usart ?
	JUMP,BS		CROIS$
	MOVE.32		#R16^TABPTDIRECT,A0
	JUMP		SUITE$
CROIS$:	MOVE.32		#R16^TABPTCROISE13,A0
SUITE$:	SL.32		#4,D0
	ADD.32		D0,A0
	MOVE.32		{A0+},D0		; Data.
	MOVE.32		{A0+},D1		; Status.
	MOVE.32		{A0+},A1		; Hard.
	MOVE.32		{A0},A0			; Soft.
	ADD.32		A6,A0			; Adresse relative ==> adresse absolue.
	ADD.32		A6,A1			; Adresse relative ==> adresse absolue.
	RET

TABPTDIRECT:					; Canaux DIRECTES: c. d. sans croisements.
	.32	ADPRPP,ADSPRPP,OHARDA,OSOFTA	; USART_0
	.32	ADPRPP,ADSPRPP,OHARDA,OSOFTA	; USART_1
.IF	SM324.OR.SM130
	.32	ADMIMO,ADSMIMO,OHARDB,OSOFTB	; USART_2
	.32	ADMIMO,ADSMIMO,OHARDB,OSOFTB	; USART_3
.ELSE
	.32	0,0,0,0				; Conserve l'ordre, place vide.
	.32	0,0,0,0				; Conserve l'ordre, place vide.
.ENDIF
.IF	SM324.OR.SM196
	.32	ADRS232,ADSRS232,OHARDC,OSOFTC	; USART_4
	.32	ADRS232,ADSRS232,OHARDC,OSOFTC	; USART_5
.ENDIF
.IF	SM130
	.32	ADCLAV,ADSCLAV,OHARDC,OSOFTC	; USART_4
	.32	ADCLAV,ADSCLAV,OHARDC,OSOFTC	; USART_5
.ENDIF

TABPTCROISE13:					; Canaux CROISES 1 & 3: c. d. PR-MO et MI-PP.
	.32	ADPRPP,ADSPRPP,OHARDA,OSOFTA	; USART_0
	.32	ADPRPP,ADSPRPP,OHARDA,OSOFTB	; USART_1	;!!!
.IF	SM324.OR.SM130
	.32	ADMIMO,ADSMIMO,OHARDB,OSOFTB	; USART_2
	.32	ADMIMO,ADSMIMO,OHARDB,OSOFTA	; USART_3	;!!!
.ELSE
	.32	0,0,0,0				; Conserve l'ordre, place vide.
	.32	0,0,0,0				; Conserve l'ordre, place vide.
.ENDIF
.IF	SM324.OR.SM196
	.32	ADRS232,ADSRS232,OHARDC,OSOFTC	; USART_4
	.32	ADRS232,ADSRS232,OHARDC,OSOFTC	; USART_5
.ENDIF
.IF	SM130
	.32	ADCLAV,ADSCLAV,OHARDC,OSOFTC	; USART_4
	.32	ADCLAV,ADSCLAV,OHARDC,OSOFTC	; USART_5
.ENDIF



;=====================================
; Routines drivers proprement dites. =
;=====================================
; Il faut commencer par appeler GETPOINT pour avoir les pointeurs aux variables:
;	A0.32	^variables SOFT du driver.
;	A1.32	^variables HARD du driver.

;-------\
; AVORT  >
;=======/

; in	A0.32	^base du drivers.
; out	--
; mod	D0..A1, D7.16

RAVORT:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,RAVORT
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	TSET.8		{A0}+OSRFLG0:#BR0AVORT	; Met le flag d'avort.
	PUSH.32		A5
	MOVE.32		{A0}+OSRADSEMAREAD,A5
	NTREL		?SIGNEV			; Dbloque le smaphore read.
	POP.32		A5
	POPA6APPEL
	RET

WAVORT:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,WAVORT
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	TSET.8		{A0}+OSWFLG0:#BW0AVORT	; Met le flag d'avort.
	PUSH.32		A5
	MOVE.32		{A0}+OSWADSEMAWRITE,A5
	NTREL		?SIGNEV			; Dbloque le smaphore read.
	MOVE.32		{A0}+OSXADSEMAXOFF,A5
	NTREL		?SIGNEV			; Dbloque le smaphore xoff.
	POP.32		A5
	POPA6APPEL
	RET



;--------\
; RESET   >
;========/

; in	A0.32	^base du drivers.
;	A2.32	^<xxxx.32>, longueur du fifo lors de l'install.
; out	--
; mod	D0..A1, D7.16

RRESET:
	LODA6APPEL
	CALL		INITVAR			; Va chercher la mmoire pour le FICHIER DRIVER.
	JUMP,NE		OK$
	TEXTDEBUG	APPEL,CR,RRESET
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	CALL		INITSOFT
	INC.8		{A1}+OHCOUNTRESET
	COMP.8		#1,{A1}+OHCOUNTRESET	; Dja initialis ?
	JUMP,NE		OKINIT$			; oui ==> on saute l'initialisation
	CALL		INITHARD		; Initialisation hardware: vecteurs, Z8530.
	CLR.32		{A1}+OHADINTRDAUX	; Adresse d'interruption de lecture auxiliaire.
	CLR.32		{A1}+OHADINTWRAUX	; Adresse d'interruption d'criture auxiliaire.
	CLR.32		{A1}+OHADINTSPAUX	; Adresse d'interruption spciale auxiliaire.
	SETREG		REG01,BEXIENA		; Active l'interruption externe.
	CALL		SENDREG			; Met  jour les registres internes du Z8530.
	CALL		INITPROC		; Initialise le processus de traitement des xon-xoff.
OKINIT$:
	CLR.8		{A0}+OSRCOUNTOPEN	; Aucun open read effectu
	CLR.8		{A0}+OSRFLG0		; On efface les flags de lecture.
	CLR.8		{A0}+OSRFLG1
	CLR.8		{A0}+OSMFLG0		; On efface les flags de mode.
	CLR.8		{A0}+OSMFLG1
	CLR.8		{A0}+OSRPARIT		; Aucun caractres de remplacement.
	CLR.8		{A0}+OSRPARIT+1

	MOVE.32		#DIMFIFO,{A0}+OSRDIMFIFO ; Initialise la grandeur du fifo.
	MOVE.32		#MINFIFO,{A0}+OSRMINFIFO ; ainsi que ses paramtres.
	MOVE.32		#MAXFIFO,{A0}+OSRMAXFIFO

	MOVE.32		A2,D0			; A2^nil ?
	JUMP,EQ		DIMERROR$		; oui ==> erreur de dimention
	TEST.8		{A2}+4			; Terminateur correct ?
	JUMP,NE		DIMERROR$		; oui ==> erreur de dimention
	TEST.8		{A2}			; Dimention pas trop grande ?
	JUMP,NE		DIMERROR$		; oui ==> erreur de dimention

	MOVE.8		{A2}+0,D0		; Lit le <xxxx.32> pla comme paramtre
	SL.32		#8,D0			; dans A2.32 lors de l'install.
	MOVE.8		{A2}+1,D0
	SL.32		#8,D0
	MOVE.8		{A2}+2,D0
	SL.32		#8,D0
	MOVE.8		{A2}+3,D0
	COMP.32		#DIMMINFIFO,D0		; Fifo trop petit ?
	JUMP,LO		DIMERROR$		; oui ==> erreur de dimention

	MOVE.32		D0,{A0}+OSRDIMFIFO	; Initialise la grandeur du fifo.
	MOVE.32		D0,D1
	SR.32		#2,D1			; 1/4.
	MOVE.32		D1,{A0}+OSRMINFIFO	; Initialise le niveau minimum.
	SUB.32		D1,D0			; 3/4.
	MOVE.32		D0,{A0}+OSRMAXFIFO	; Initialise le niveau maximum.
DIMERROR$:
	TEST.16		D7
	JUMP,EQ		OK$
	DEC.8		{A1}+OHCOUNTRESET	; Erreur ==> RRESET pas fait.
OK$:
	POPA6APPEL
	RET

WRESET:
	LODA6APPEL
	CALL		INITVAR			; Va chercher la mmoire pour le FICHIER DRIVER.
	JUMP,NE		OK$
	TEXTDEBUG	APPEL,CR,WRESET
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	CALL		INITSOFT
	INC.8		{A1}+OHCOUNTRESET
	COMP.8		#1,{A1}+OHCOUNTRESET	; Dja initialis ?
	JUMP,NE		OKINIT$			; oui ==> on saute l'initialisation
	CALL		INITHARD		; Initialisation hardware: vecteurs, Z8530.
	CLR.32		{A1}+OHADINTRDAUX	; Adresse d'interruption de lecture auxiliaire.
	CLR.32		{A1}+OHADINTWRAUX	; Adresse d'interruption d'criture auxiliaire.
	CLR.32		{A1}+OHADINTSPAUX	; Adresse d'interruption spciale auxiliaire.
	SETREG		REG01,BEXIENA		; Active l'interruption externe.
	CALL		SENDREG			; Met  jour les registres internes du Z8530.
	CALL		INITPROC		; Initialise le processus de traitement des xon-xoff.
OKINIT$:
	CLR.8		{A0}+OSWCOUNTOPEN	; Aucun open write effectu
	CLR.8		{A0}+OSWFLG0		; On efface les flags d'criture.
	CLR.8		{A0}+OSWFLG1
	CLR.8		{A0}+OSMFLG0		; On efface les flags de mode.
	CLR.8		{A0}+OSMFLG1

	TEST.16		D7
	JUMP,EQ		OK$
	DEC.8		{A1}+OHCOUNTRESET	; Erreur ==> WRESET pas fait.
OK$:
	POPA6APPEL
	RET



INITPROC:
	TEXTDEBUG	ROUT,SPACE,INITPROC
	PUSHM.32	D4|D5|A2|A3|A4|A5	; Initialise le processus de traitement des xon-xoff.

	CLR.8		{A0}+OSXFLG0		; On efface les flags du protocole xon-xoff.
	CLR.8		{A0}+OSXFLG1
	MOVE.8		#CHARXON,{A0}+OSXON	; Valeur par dfaut du caractre xon.
	MOVE.8		#CHARXOFF,{A0}+OSXOFF	; Valeur par dfaut du caractre xoff.

	CLR.32		{A0}+OSXADSEMAXOFF	; Initialise le smaphore de xon-xoff.
	CLR.16		D4
	NTREL		?CRESEM
	JUMP,NE		ERROR$
	MOVE.32		A5,{A0}+OSXADSEMAXOFF
	CLR.32		{A0}+OSXADKILLPROC	; Initialise le smaphore d'avort du processus.
	CLR.16		D4
	NTREL		?CRESEM
	JUMP,NE		ERROR$
	MOVE.32		A5,{A0}+OSXADKILLPROC

	MOVE.32		A5,A2			; Adresse du smaphore d'avort du processus.
	MOVE.32		#R16^PROCSENDXF,A5	; Adresse du processus.
	MOVE.32		#16'500,D5		; Longueur du stack.
	MOVE.16		#3+2**BTPROG+2**BTNCHD+2**BTSIAB,D4 ; Priorit 3, fils de FIRST & SIGNEV.
	MOVE.32		#R16^NAMPROC,A3		; A6 est transmis au fils dans A6.
	MOVE.32		A0,D1			; D1 est transmis au fils dans D7.
	NTREL		?CRETASK		; A1 est transmis au fils dans A3.
ERROR$:
	POPM.32		D4|D5|A2|A3|A4|A5
	RET



KILLPROC:
	TEXTDEBUG	ROUT,SPACE,KILLPROC
	PUSHM.32	A5			; Supprime le processus de traitement des xon-xoff.

	TSET.8		{A0}+OSXFLG0:#BX0AVORTPROC ; Bit signalant que l'on veut avorter le proc.
	MOVE.32		{A0}+OSXADSEMAXOFF,A5	; Dbloque le smaphore de xon-xoff.
	NTREL		?SIGNEV
	JUMP,NE		ERROR$
	MOVE.32		{A0}+OSXADKILLPROC,A5	; Attend que le processus SENDXF soit stopp.
	NTREL		?WAITEV

	MOVE.32		{A0}+OSXADKILLPROC,A5	; Enlve le smaphore d'avort du processus SENDXF.
	CLR.32		{A0}+OSXADKILLPROC
	NTREL		?KILLSEM
	MOVE.32		{A0}+OSXADSEMAXOFF,A5	; Enlve le smaphore de traitement des xon-xoff.
	CLR.32		{A0}+OSXADSEMAXOFF
	NTREL		?KILLSEM
ERROR$:
	POPM.32		A5
	RET



;--------------\
; PROCSENDXF    >
;==============/

; Processus de rgulation de flux: traitement du xon-xoff et bloquage du clock des lignes simser.
; in	A6.32	copie de A6.32 cad le pointeur aux variables du driver.
;	D7.32	copie de A0.32 cad le pointeur aux variables softwares.
;	A3.32	copie de A1.32 cad le pointeur aux variables hardwares.
; out	--
; mod	tout (sans importance car le processus est avort).

NAMPROC:
	.ASCIZE		"SENDXF_USART"		; Nom du processus.
PROCSENDXF:
	MOVE.32		D7,A0			; On rtablit A0, A1 et A6.
	MOVE.32		A3,A1
	TEXTDEBUG	PROCX,SPACE,STARTSENDXF
	MOVE.32		#-1,D4			; Time-out infini.
	NTREL		?SETTIM
;;;	CALL		PUTSUPERV		; Passse en mode superviseur.
	MOVE.32		#R16^SUPERV$,A5		; Passse en mode superviseur.
	NTREL		?IEP12TRP		; Initialise le trap #12.
	TRAP		#10'12			; Call en mode superviseur.
	SUB.32		A5,A5			; Enlve le trap #12.
	NTREL		?IEP12TRP
WAIT$:
	TEXTDEBUG	PROCX,SPACE,waitsendxf
	MOVE.32		{A0}+OSXADSEMAXOFF,A5	; Attend sur le smaphore xon-xoff.
	NTREL		?WAITEV
	TCLR.8		{A0}+OSXFLG0:#BX0AVORTPROC ; Bit signalant que l'on veut avorter le proc ?
	JUMP,BC		NOAVORT$
	TEXTDEBUG	PROCX,SPACE,avortsendxf
	NTREL		?ABORT			; c'est la fin du proc!
	.16		?AFTIM
	.ASCIZE		"<CR>Le processus SENDXF n'a pas t avort."
	TRAP #10'10
NOAVORT$:
	TEST.8		{A0}+OSXFLG0:#BX0USARTXOFF ; Usart xoff ?
	JUMP,BS		TYPEXOFF$
	TEST.8		{A0}+OSXFLG0:#BX0USERXOFF ; User xoff ?
	JUMP,BS		TYPEXOFF$
	TCLR.8		{A0}+OSXFLG0:#BX0TYPEXOFF ; Type xon.
	TEST.8		{A0}+OSXFLG0:#BX0OLDXOFF ; Old type = type (xon) ?
	JUMP,BS		r8^SENDXON$		; non ==> sendxon
	TEST.8		{A0}+OSMFLG0:#BM0REPEATXON ; Repeat ?
			;;RB	JUMP,BS		SENDXON$		; oui ==> sendxon
			;;RB	JUMP		SIMSERON$		; non ==> simseron
	Jump,BC		r8^SIMSERON$		; non ==> SimserOn
	
SENDXON$:
	TEST.8		{A0}+OSMFLG0:#BM0XOUT	; xon-xoff en sortie ?
	JUMP,BC		r8^SIMSERON$		; non ==> simser on
	MOVE.8		{A0}+OSXON,{A0}+OSXSENDXOFF ; On doit envoyer un xon.
SIMSERON$:
	TEXTDEBUG	SIM,SPACE,simseron
	SETREG		REG14,BBRGENA		; Active le clock simser: BRG on.
;;;	CALL		SENDREG			; Met  jour les registres internes du Z8530.
; RB,Autorise rception RTS/DTR activ
RTSON$:	TEST.8		{A0}+OSRFLG1:#BR1HRTSEnable
	jump,bc		r8^NoRTSE$
	SETREG		REG05,BRTSENA
NoRTSE$:
DTRON$:	TEST.8		{A0}+OSRFLG1:#BR1HDTREnable
	jump,bc		r8^NoDTRE$
	SETREG		REG05,BDTRENA
NoDTRE$:
	JUMP		INTWRITE$

TYPEXOFF$:
	TSET.8		{A0}+OSXFLG0:#BX0TYPEXOFF ; Type xoff.
	TEST.8		{A0}+OSXFLG0:#BX0OLDXOFF ; Old type = type (xoff) ?
	JUMP,BC		r8^SENDXOFF$		; non ==> sendxoff
	TEST.8		{A0}+OSMFLG0:#BM0REPEATXON ; Repeat ?
			;;RB	JUMP,BS		SENDXOFF$		; oui ==> sendxoff
			;;RB	JUMP		SIMSEROFF$		; non ==> simseroff
	Jump,BC		r8^SIMSEROFF$		; non ==> simseroff
SENDXOFF$:
	TEST.8		{A0}+OSMFLG0:#BM0XOUT	; xon-xoff en sortie ?
	JUMP,BC		r8^SIMSEROFF$		; non ==> simser off
	MOVE.8		{A0}+OSXOFF,{A0}+OSXSENDXOFF ; On doit envoyer un xoff.
SIMSEROFF$:
	TEXTDEBUG	SIM,SPACE,simseroff
	TEST.8		{A1}+OHREGISTRES+REG11:#BTCKBRG ; On est en mode RS232 ?
	JUMP,BS		r8^RTSOFF$		; oui ==> pas de stop BRG !!!
	CLRREG		REG14,BBRGENA		; Dsactive le clock simser: BRG off.

; Empche rception Hard RTS/DTR
RTSOFF$:
	TEST.8		{A0}+OSRFLG1:#BR1HRTSEnable
	jump,bc		r8^NoRTSE1$
	CLRREG		REG05,BRTSENA
NoRTSE1$:
DTROFF$:
	TEST.8		{A0}+OSRFLG1:#BR1HDTREnable
	jump,bc		r8^NoDTRE1$
	CLRREG		REG05,BDTRENA
NoDTRE1$:
;;;	CALL		SENDREG			; Met  jour les registres internes du Z8530.
;;;	JUMP		INTWRITE$
INTWRITE$:
	MOVE.32		{A1}+OHADINTWRITE,A2	; Adresse de la routine d'interruption write.
	PUSHM.32	A0|A1
	LOCK
	TSET.8		{A0}+OSWFLG0:#BW0PROCSXF; Call effectu depuis le processus PROCSENDXF.
	MOVE.32		A6,A0			; Pointeur aux variables globales.
	CALL		{A2}			; Et c'est parti mon kiki ...
	UNLOCK
	POPM.32		A0|A1

	CALL		SENDREG			; SIMSER, met  jour les registres internes du Z8530.
	JUMP		WAIT$



;;;PUTSUPERV:
;;;	MOVE.32		#R16^SUPERV$,A5		; Passse en mode superviseur.
;;;	NTREL		?IEP12TRP		; Initialise le trap #12.
;;;	TRAP #10'12				; Call en mode superviseur.
;;;	MOVE.32		#0,A5			; Enlve le trap #12.
;;;	NTREL		?IEP12TRP
;;;	RET
SUPERV$:					; Routine appele par une execption: TRAP #12.
	TSET.8		{SP}+8:#5		; Modifie le STACK pour rester en mode SUPERVISEUR.
	POPM.32		D0|A0			; Vide la pile superviseur.
	RETSF					; Reste en mode superviseur.



;--------\
; KILL    >
;========/

; in	A0.32	^base du drivers.
; out	--
; mod	D0..A1,D7.16

RKILL:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,RKILL
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	DEC.8		{A1}+OHCOUNTRESET	; Un de moins...
	JUMP,NE		NOTLAST$
	CALL		KILLPROC		; Supprime le processus de traitement des xon-xoff.
	CALL		KILLVECT		; Supprime les vecteurs d'interruptions.
	CALL		INITHARD		; Initialisation hardware: vecteurs, Z8530.
NOTLAST$:
	TEST.16		D7
	JUMP,EQ		OK$
	INC.8		{A1}+OHCOUNTRESET	; Erreur ==> RKILL pas fait.
OK$:
	POPA6APPEL
	RET

WKILL:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,WKILL
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	DEC.8		{A1}+OHCOUNTRESET	; Un de moins...
	JUMP,NE		NOTLAST$
	CALL		KILLPROC		; Supprime le processus de traitement des xon-xoff.
	CALL		KILLVECT		; Supprime les vecteurs d'interruptions.
	CALL		INITHARD		; Initialisation hardware: vecteurs, Z8530.
NOTLAST$:
	TEST.16		D7
	JUMP,EQ		OK$
	INC.8		{A1}+OHCOUNTRESET	; Erreur ==> WKILL pas fait.
OK$:
	POPA6APPEL
	RET



;--------\
; OPEN    >
;========/

; in	A0.32	^base du drivers.
; out	--
; mod	D0..A1,D7.16

ROPEN:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,ROPEN
	PUSHM.32	D4|A5

	PUSH.32		A0			; Sauve le pointeur  la base du drivers.
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	POP.32		A5			; Rcupre le pointeur  la base du drivers.
	INC.8		{A0}+OSRCOUNTOPEN
	COMP.8		#1,{A0}+OSRCOUNTOPEN	; Dj un open read effectu ?
	JUMP,NE		OK$			; oui ==> on ne fait rien.

	CLR.32		{A1}+OHADINTRDAUX	; Adresse d'interruption de lecture auxiliaire.
	CLR.32		{A1}+OHADINTSPAUX	; Adresse d'interruption spciale auxiliaire.

	CLR.8		{A0}+OSRFLG0		; On efface les flags de lecture.
;;RB	CLR.8		{A0}+OSRFLG1
	CLR.8		{A0}+OSRERROR		; On efface les erreurs.
	CLR.8		{A0}+OSRPOUBELLE	; On efface le caractre dans la poubelle.
	CLR.32		{A0}+OSRLONGFIFO	; Pas de place dans le fifo.
	CLR.32		{A0}+OSRCOUNT		; Aucun caractre encore compt (accs read).

	TEST.8		{A0}+OSMFLG0:#BM0NOFIFO	; Y a-t-il un FIFO ?
	JUMP,BS		r8^NOFIFO$
	CALL		GETFIFO			; Va chercher un FIFO et l'initialise.
	JUMP,NE		ERROR$
NOFIFO$:
	CLR.32		{A0}+OSRADSEMAREAD	; Initialise le smaphore de lecture.
	CLR.16		D4
	NTREL		?CRESEM
	JUMP,NE		ERROR$
	MOVE.32		A5,{A0}+OSRADSEMAREAD

	MOVE.32		{A1}+OHUSART,A5		; Adresse du priphrique DATA du Z8530.
	MOVE.32		#4,D4
KFIFO8530$:
	LOCK
	TEST.8		{A5}			; Vide le fifo du Z8530.
	UNLOCK
	DJ.16,NMO	D4,KFIFO8530$
	MOVE.32		{A1}+OHSUSART,A5	; Adresse du priphrique de status.
	LOCK
	MOVE.8		#RESERR,{A5}		; Clear les erreurs dans le Z8530.
	WAIT1_7US
	MOVE.8		{A5},D0			; Lit le status de l'usart Z8530 REG00.
	UNLOCK
	TEST.8		{A1}+OHSTATUS		; Status dj lu ?
	JUMP,NE		r8^OKSTA$
	MOVE.8		D0,{A1}+OHSTATUS
OKSTA$:
	TSET.8		{A0}+OSRFLG0:#BR0ENABLE	; Routine d'interruption de lecture active.
	TEST.8		{A0}+OSMFLG1:#BM1NCDTR	; Activation du no_change_DTR_at_close ?
	JUMP,BS		r8^NC$			; Oui ==> ne change pas la ligne DTR.
	TSET.8		{A0}+OSRFLG0:#BR0OLDDTR	; Activation de la ligne DTR en dehors du read.
	SETREG		REG05,BDTRENA		; Active la ligne DTR.
NC$:	SETREG		REG01,BRIACSC		; Active l'interruption read.
	CALL		SENDREG			; Met  jour les registres internes du Z8530.

	CLR.8		{A0}+OSXSENDXOFF
	CLR.8		{A0}+OSXFLG0		; Efface le pass du processus xon-xoff.
	MOVE.32		{A0}+OSXADSEMAXOFF,A5	; Dbloque simser.
	NTREL		?SIGNEV
	JUMP,EQ		r8^OK$
ERROR$:
	DEC.8		{A0}+OSRCOUNTOPEN	; Erreur ==> ROPEN pas fait.
OK$:
	POPM.32		D4|A5
	POPA6APPEL
	RET



WOPEN:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,WOPEN
	PUSHM.32	D4|A5

	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	INC.8		{A0}+OSWCOUNTOPEN
	COMP.8		#1,{A0}+OSWCOUNTOPEN	; Dj un open write effectu ?
	JUMP,NE		OK$			; oui ==> on ne fait rien.

	CLR.32		{A1}+OHADINTWRAUX	; Adresse d'interruption d'criture auxiliaire.
	CLR.32		{A1}+OHADINTSPAUX	; Adresse d'interruption spciale auxiliaire.

	CLR.8		{A0}+OSWFLG0		; On efface les flags d'criture.
	CLR.8		{A0}+OSWFLG1
	CLR.32		{A0}+OSWLONGDATA	; Pas de caractres  transmettre.

	CLR.32		{A0}+OSWADSEMAWRITE	; Initialise le smaphore d'criture.
	CLR.16		D4
	NTREL		?CRESEM
	TEST.16		D7
	JUMP,NE		ERROR$
	MOVE.32		A5,{A0}+OSWADSEMAWRITE

	MOVE.32		{A1}+OHSUSART,A5	; Adresse du priphrique de status.
	LOCK
	MOVE.8		{A5},D0			; Lit le status de l'usart Z8530 REG00.
	UNLOCK
	TEST.8		{A1}+OHSTATUS		; Status dj lu ?
	JUMP,NE		OKSTA$
	MOVE.8		D0,{A1}+OHSTATUS
OKSTA$:
	TEST.8		{A0}+OSMFLG1:#BM1NCRTS	; Activation du no_change_RTS_at_close ?
	JUMP,BS		NC$			; Oui ==> ne change pas la ligne RTS.
	TSET.8		{A0}+OSWFLG0:#BW0OLDRTS	; Activation de la ligne RTS en dehors du write.
	SETREG		REG05,BRTSENA		; Active la ligne RTS.
NC$:
	SETREG		REG01,BTXIENA		; Active l'interruption write.
	CALL		SENDREG			; Met  jour les registres internes du Z8530.
	JUMP,EQ		OK$
ERROR$:
	DEC.8		{A0}+OSWCOUNTOPEN	; Erreur ==> WOPEN pas fait.
OK$:
	POPM.32		D4|A5
	POPA6APPEL
	RET



;----------\
; GETFIFO   >
;==========/

; in	A5.32	^base du drivers.
;	A0.32	^variables softwares.
;	A1.32	^variables hardwares.
; out	-
; mod	D0..A1,D7.16

GETFIFO:					; Va chercher un FIFO et l'initialise.
	TEXTDEBUG	ROUT,SPACE,GETFIFO
	PUSHM.32	A4
	PUSHM.32	A1
	MOVE.32		A5,A1			; ^base du driver.
	MOVE.32		{A0}+OSRDIMFIFO,D4	; Longueur du fifo.
	MOVE.32		#MTYPBD,D1
	GESMEM		?GETMEM			; Demande la mmoire.
	POPM.32		A1
	JUMP,NE		ERROR$
	MOVE.32		A4,{A0}+OSRADBEGINFIFO	; Adresses de DEBUT du fifo.
	MOVE.32		A4,{A0}+OSRADREADFIFO	; Adresse de LECTURE du fifo.
	MOVE.32		A4,{A0}+OSRADWRITEFIFO	; Adresses d'ECRITURE dans le fifo.
	ADD.32		{A0}+OSRDIMFIFO,A4	; Calcule la fin du fifo.
	MOVE.32		A4,{A0}+OSRADENDFIFO	; Index absolu: FIN du fifo.
	MOVE.32		{A0}+OSRDIMFIFO,{A0}+OSRLONGFIFO ; Fifo vide: longueur_disponible=dimention.
ERROR$:
	POPM.32		A4
	TEST.16		D7
	RET



;--------\
; CLOSE   >
;========/

; in	A0.32	^base du drivers.
; out	-
; mod	D0..A1,D7.16

RCLOSE:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,RCLOSE
	PUSHM.32	D4|A5

	PUSH.32		A0			; Sauve le pointeur  la base du drivers.
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	POP.32		A5			; Rcupre le pointeur  la base du drivers.
	DEC.8		{A0}+OSRCOUNTOPEN	; Dernier close read  effectuer ?
	JUMP,NE		OK$			; non ==> on ne fait rien.

	TEST.8		{A0}+OSWCOUNTOPEN	; Dernier close write dja fait ?
	JUMP,NE		r8^NOLAST$			; non ==> on ne fait rien.
	CLR.8		{A1}+OHSTATUS		; Status bloqu.
NOLAST$:
	TEST.8		{A0}+OSMFLG1:#BM1NCDTR	; No_change_DTR_at_close read ?
	JUMP,BS		r8^NODTR$
	CLRREG		REG05,BDTRENA		; Dsactive la ligne DTR.
NODTR$:
	CLRREG		REG14,BBRGENA		; Dsactive le clock simser BRG off.
	CLRREG		REG01,BRIACSC		; Dsactive l'interruption read.
	CALL		SENDREG			; Met  jour les registres internes du Z8530.

	CLR.32		{A1}+OHADINTRDAUX	; Adresse d'interruption de lecture auxiliaire.
	CLR.32		{A1}+OHADINTSPAUX	; Adresse d'interruption spciale auxiliaire.

	CLR.8		{A0}+OSRFLG0		; On efface les flags de lecture.
;;RB	CLR.8		{A0}+OSRFLG1
	CLR.32		{A0}+OSRLONGFIFO	; Plus de caractres dans le fifo.
	TCLR.8		{A0}+OSMFLG0:#BM0XIN	; Supprime le xon-xoff en entre.
	TCLR.8		{A0}+OSMFLG0:#BM0XOUT	; Supprime le xon-xoff en sortie.
	MOVE.8		#CHARXON,{A0}+OSXON	; Valeur par dfaut du caractre xon.
	MOVE.8		#CHARXOFF,{A0}+OSXOFF	; Valeur par dfaut du caractre xoff.
	CLR.32		{A0}+OSRADSEMADCD	; Supprime le pointeur au smaphore SEMADCD.
	CLR.32		{A0}+OSRADSEMABRK	; Supprime le pointeur au smaphore SEMABRK.
	CLR.32		{A0}+OSRADSEMAERR	; Supprime le pointeur au smaphore SEMAERR.

	TEST.8		{A0}+OSMFLG0:#BM0NOFIFO	; Y a-t-il un FIFO ?
	JUMP,BS		r8^NOFIFO$
	CALL		KILLFIFO		; Enlve le fifo.
	JUMP,NE		r8^ERROR$
NOFIFO$:
	MOVE.32		{A0}+OSRADSEMAREAD,A5	; Initialise le smaphore de lecture.
	CLR.32		{A0}+OSRADSEMAREAD
	NTREL		?KILLSEM
	JUMP,EQ		r8^OK$
ERROR$:
	INC.8		{A0}+OSRCOUNTOPEN	; Erreur ==> RCLOSE pas fait.
OK$:
	POPM.32		D4|A5
	POPA6APPEL
	RET



WCLOSE:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,WCLOSE
	PUSH.32		A5
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	DEC.8		{A0}+OSWCOUNTOPEN	; Dernier close write  effectuer ?
	JUMP,NE		OK$			; non ==> on ne fait rien.

	TEST.8		{A0}+OSRCOUNTOPEN	; Dernier close read dja fait ?
	JUMP,NE		r8^NOLAST$			; non ==> on ne fait rien.
	CLR.8		{A1}+OHSTATUS		; Status bloqu.
NOLAST$:
	CLR.32		{A1}+OHADINTWRAUX	; Adresse d'interruption d'criture auxiliaire.
	CLR.32		{A1}+OHADINTSPAUX	; Adresse d'interruption spciale auxiliaire.

	CLR.8		{A0}+OSWFLG0		; On efface les flags d'criture.
	CLR.8		{A0}+OSWFLG1
	CLR.32		{A0}+OSWLONGDATA	; Plus de caractres  transmettre.
	TCLR.8		{A0}+OSMFLG0:#BM0XIN	; Supprime le xon-xoff en entre.
	TCLR.8		{A0}+OSMFLG0:#BM0XOUT	; Supprime le xon-xoff en sortie.
	MOVE.8		#CHARXON,{A0}+OSXON	; Valeur par dfaut du caractre xon.
	MOVE.8		#CHARXOFF,{A0}+OSXOFF	; Valeur par dfaut du caractre xoff.
	CLR.32		{A0}+OSWADSEMACTS	; Supprime le pointeur au smaphore SEMACTS.

	TEST.8		{A0}+OSMFLG1:#BM1NCRTS	; No_change_RTS_at_close write ?
	JUMP,BS		r8^NORTS$
	CLRREG		REG05,BRTSENA		; Dsactive la ligne RTS.
NORTS$:
	CLRREG		REG01,BTXIENA		; Dsactive l'interruption write.
	CALL		SENDREG			; Met  jour les registres internes du Z8530.

	MOVE.32		{A0}+OSWADSEMAWRITE,A5	; Enlve le smaphore d'criture.
	CLR.32		{A0}+OSWADSEMAWRITE
	NTREL		?KILLSEM
	JUMP,EQ		r8^OK$
ERROR$:
	INC.8		{A0}+OSWCOUNTOPEN	; Erreur ==> RCLOSE pas fait.
OK$:
	POPM.32		A5
	POPA6APPEL
	RET



;-----------\
; KILLFIFO   >
;===========/

; in	A5.32	^base du drivers.
;	A0.32	^variables softwares.
;	A1.32	^variables hardwares.
; out	-
; mod	D0..A1,D7.16

KILLFIFO:					; Enlve le fifo.
	TEXTDEBUG	ROUT,SPACE,KILLFIFO
	PUSHM.32	A1|A4
	CLR.32		{A0}+OSRLONGFIFO	; Plus de caractres dans le fifo.
	MOVE.32		A5,A1			; ^base du driver.
	MOVE.32		{A0}+OSRADBEGINFIFO,A4	; Adresses de DEBUT du fifo.
	MOVE.32		#MTYPBD,D1
	GESMEM		?GIVMEM			; Demande la mmoire.
	POPM.32		A1|A4
	RET



;--------\
; COMMAND >
;========/

; in	A0.32	^base du drivers.
;	A4.32	^table des commandes termine par zro
; out	D7.16	erreur
; out   A4.32 	^table si erreur
; mod	D0..A1,A4, D7.16

RCOMMAND:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,RCOMMAND
	PUSHM.32	A2|A5
	PUSH.32		A0			; Sauve le pointeur  la base du drivers.
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	POP.32		A5			; Rcupre le pointeur  la base du drivers.
	DEC.32		A4			; Correction pour le pr-incrment.
	CLR.16		D7			; Pas encore d'erreur.
RCOMM$:
	TEST.16		D7			; Il y a une erreur ?
	JUMP,NE		COMER$			; oui ==> comer
	INC.32		A4
	MOVE.8		{A4},D0			; Lit le caractre de command, fin ?.
	JUMP,EQ		FIN$			; oui ==> fin
	COMP.8		#CR,D0			; Fin de la commande ?
	JUMP,EQ		FIN$			; oui ==> fin

	PUSH.32		A2
	MOVE.32		#R16^TABRCOMM$,A2	; Table avec les commandes possibles.
LOOP$:
	COMP.8		{A2},D0			; Commande trouve ?
	JUMP,EQ		TROUVE$			; oui ==> trouv
	COMP.8		#2**7,{A2}		; Fin de la table ?
	JUMP,EQ		ERROR$			; oui ==> erreur commande illgale.
	ADD.32		#2+4,A2			; Essaye la commande suivante.
	JUMP		LOOP$
ERROR$:
	POP.32		A2
COMER$:	DEC.32		A4			; Correction pour le pr-incrment.
	MOVE.16		#ERILLO,D7		; Erreur commande illgale.
FIN$:
	CALL		SENDREG			; Met  jour les registres du Z8530.
	POPM.32		A2|A5
	POPA6APPEL
	RET
TROUVE$:
	ADD.32		#2,A2			; Met le pointeur sur l'adresse de l'indirection.
	PUSH.32		A0
	MOVE.32		#R16^DRIVERS,A0		; Dbut du code du drivers.
	ADD.32		{A2},A0			; Pointeur relatif ==> pointeur absolu.
	MOVE.32		A0,D0			; Pointeur sur l'indirection dans D0.
	MOVE.32		#R16^RCOMM$,A0
	MOVE.32		A0,D1			; Adresse de retour: D1.
	POP.32		A0
	POP.32		A2
	INC.32		A4			; Pointeur commande --> paramtre, ou comm suivante.

	PUSH.32		D1			; Sauve l'adresse de retour: RCOMM.
	PUSH.32		D0			; Effectue l'indirection: JUMP {D0}.
	RET

TABRCOMM$:					; Table des commandes en lecture.
	.8.8.32		"?",0,RCOM_?		; Micro_help.
	.8.8.32		"A",0,RCOM_A		; (Affichage sur led).
	.8.8.32		"B",0,RCOM_B		; Baud-rate B_ascii.
	.8.8.32		"C",0,RCOM_C		; Clear les erreurs de lecture.
	.8.8.32		"D",0,RCOM_D		; Dbloccage mission.
;	.8.8.32		"E",0,RCOM_E
	.8.8.32		"F",0,RCOM_F		; Fifo.
;	.8.8.32		"G",0,RCOM_G
	.8.8.32		"H",0,RCOM_H		; (Haut-parleur).
	.8.8.32		"I",0,RCOM_I		; (Dbug interupt dcd).
;	.8.8.32		"J",0,RCOM_J
;	.8.8.32		"K",0,RCOM_K
	.8.8.32		"L",0,RCOM_L		; Longueur du caractre.
	.8.8.32		"M",0,RCOM_M		; Modes simser/rs232, debug...
	.8.8.32		"N",0,RCOM_N		; Mode standard.
	.8.8.32		"O",0,RCOM_O		; Lignes en sortie DTR,RTS.
	.8.8.32		"P",0,RCOM_P		; Parit.
;	.8.8.32		"Q",0,RCOM_Q
	.8.8.32		"R",0,RCOM_R		; Repeat xon-xoff.
	.8.8.32		"S",0,RCOM_S		; Stop-bit.
	.8.8.32		"T",0,RCOM_T		; Time-out.
;	.8.8.32		"U",0,RCOM_U
	.8.8.32		"V",0,RCOM_V		; Baud-rate V[xx.W]
	.8.8.32		"W",0,RCOM_W		; Time-out W[xx.W]
	.8.8.32		"X",0,RCOM_X		; Xon-xoff en entre-sortie.
	.8.8.32		"Y",0,RCOM_Y		; Time-out par commande ou processus.
;	.8.8.32		"Z",0,RCOM_Z
	.8		2**7
	.EVEN

WCOMMAND:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,WCOMMAND
	PUSHM.32	A2|A5
	PUSH.32		A0			; Sauve le pointeur  la base du drivers.
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	POP.32		A5			; Rcupre le pointeur  la base du drivers.
	DEC.32		A4			; Correction pour le pr-incrment.
	CLR.16		D7			; Pas encore d'erreur.
WCOMM$:
	TEST.16		D7			; Il y a une erreur ?
	JUMP,NE		COMER$			; oui ==> comer
	INC.32		A4
	MOVE.8		{A4},D0			; Lit le caractre de command, fin ?.
	JUMP,EQ		FIN$			; oui ==> fin
	COMP.8		#CR,D0			; Fin de la commande ?
	JUMP,EQ		FIN$			; oui ==> fin

	PUSH.32		A2
	MOVE.32		#R16^TABWCOMM$,A2	; Table avec les commandes possibles.
LOOP$:
	COMP.8		{A2},D0			; Commande trouve ?
	JUMP,EQ		TROUVE$			; oui ==> trouv
	COMP.8		#2**7,{A2}		; Fin de la table ?
	JUMP,EQ		ERROR$			; oui ==> erreur commande illgale.
	ADD.32		#2+4,A2			; Essaye la commande suivante.
	JUMP		LOOP$
ERROR$:
	POP.32		A2
COMER$:	DEC.32		A4			; Correction pour le pr-incrment.
	MOVE.16		#ERILLO,D7		; Erreur commande illgale.
FIN$:
	CALL		SENDREG			; Met  jour les registres du Z8530.
	POPM.32		A2|A5
	POPA6APPEL
	RET
TROUVE$:
	ADD.32		#2,A2			; Met le pointeur sur l'adresse de l'indirection.
	PUSH.32		A0
	MOVE.32		#R16^DRIVERS,A0		; Dbut du code du drivers.
	ADD.32		{A2},A0			; Pointeur relatif ==> pointeur absolu.
	MOVE.32		A0,D0			; Pointeur sur l'indirection dans D0.
	MOVE.32		#R16^WCOMM$,A0
	MOVE.32		A0,D1			; Adresse de retour: D1.
	POP.32		A0
	POP.32		A2
	INC.32		A4			; Pointeur commande --> paramtre, ou comm suivante.

	PUSH.32		D1			; Sauve l'adresse de retour: WCOMM.
	PUSH.32		D0			; Effectue l'indirection: JUMP {D0}.
	RET

TABWCOMM$:					; Table des commandes en criture.
	.8.8.32		"?",0,WCOM_?		; Micro_help.
	.8.8.32		"A",0,WCOM_A		; (Affichage sur led).
	.8.8.32		"B",0,WCOM_B		; Baud-rate B_ascii.
	.8.8.32		"C",0,WCOM_C		; Clear les erreurs de lecture.
	.8.8.32		"D",0,WCOM_D		; Dbloccage mission.
;	.8.8.32		"E",0,WCOM_E
	.8.8.32		"F",0,WCOM_F		; Fifo.
;	.8.8.32		"G",0,WCOM_G
	.8.8.32		"H",0,WCOM_H		; (Haut-parleur).
	.8.8.32		"I",0,WCOM_I		; (Dbug interupt dcd).
;	.8.8.32		"J",0,WCOM_J
;	.8.8.32		"K",0,WCOM_K
	.8.8.32		"L",0,WCOM_L		; Longueur du caractre.
	.8.8.32		"M",0,WCOM_M		; Modes simser/rs232, debug...
	.8.8.32		"N",0,WCOM_N		; Mode standard.
	.8.8.32		"O",0,WCOM_O		; Lignes en sortie DTR,RTS.
	.8.8.32		"P",0,WCOM_P		; Parit.
;	.8.8.32		"Q",0,WCOM_Q
	.8.8.32		"R",0,WCOM_R		; Repeat xon-xoff.
	.8.8.32		"S",0,WCOM_S		; Stop-bit.
	.8.8.32		"T",0,WCOM_T		; Time-out.
;	.8.8.32		"U",0,WCOM_U
	.8.8.32		"V",0,WCOM_V		; Baud-rate V[xx.W]
	.8.8.32		"W",0,WCOM_W		; Time-out W[xx.W]
	.8.8.32		"X",0,WCOM_X		; Xon-xoff en entre-sortie.
	.8.8.32		"Y",0,WCOM_Y		; Time-out par commande ou processus.
;	.8.8.32		"Z",0,WCOM_Z
	.8		2**7
	.EVEN



RCOM_?:
WCOM_?:						; Micro_help.
	DEC.32		A4			; Correction pointeur commande.
.IF		DEBUG
	.16		?AFTIM
	.ASCII	"<CR>micro-help des drivers usart 130-196-300-324:"
	.ASCII	"<CR>*********************************************<CR>"
	.ASCII	"<CR>MACRO DE DEMARRAGE:"
	.ASCII	"<CR>install #pr $usart_0 [lgfifo.L]"
	.ASCII	"<CR>install #pp $usart_1"
	.ASCII	"<CR>install #mi $usart_2 [lgfifo.L]"
	.ASCII	"<CR>install #mo $usart_3"
	.ASCII	"<CR>install #rsin $usart_4 [lgfifo.L]"
	.ASCII	"<CR>install #rsout $usart_5"
	.ASCII	"<CR>command #pr NFEYEW[200.W]"
	.ASCII	"<CR>command #pp YEW[200.W]"
	.ASCII	"<CR>command #mi NFEYEW[200.W]"
	.ASCII	"<CR>command #mo YEW[200.W]"
	.ASCII	"<CR>command #rsin NFEYEW[200.W]"
	.ASCII	"<CR>command #rsout YEW[200.W]<CR>"
	.ASCII	"<CR>COMMANDE DANS UN PROGRAMME, PAR EX:"
	.ASCII	"<CR>command #pr NS1P_L_S_"
	.ASCII	"<CR>(la commande doit toujours commencer par ""NS1"""
	.ASCII	"<CR>par comptabilit avec le SAMKY 100)"
	.ASCII	"<CR>(_=paramtres:PE,PO,PD; L5,L6,L7,L8; S1,S1.5,S2)<CR>"
	.ASCII	"<CR>MODES DE DEBUG ACTIVABLES, command #pr MD_:"
	.ASCII	"<CR>MDT Active tous les dbugs du drivers."
	.ASCII	"<CR>MDO Enlve tous les dbugs du drivers."
	.ASCII	"<CR>MD0 Dbug d'entre des APPELs."
	.ASCII	"<CR>MD1 Dbug d'entre des ROUTines."
	.ASCII	"<CR>MD2 Dbug des ERReurs de lecture."
	.ASCII	"<CR>MD3 Dbug des XONxoff envoys et reus."
	.ASCII	"<CR>MD4 Dbug du processus PROCX de gestion des xon-xoff."
	.ASCII	"<CR>MD5 Dbug de l'activit SIMser."
	.ASCII	"<CR>MD6 Dbug des INTerruptions."
	.ASCII	"<CR>MD7 Dbug des SIGNals envoys aux smaphores."
	.ASCII	"<CR>MD8 Dbug des lignes CTS et DCD."
	.ASCII	"<CR>MD9 Dbug des COMMandes envoyes."
	.ASCIZE	"<CR>Rev <NREV+"0">-<NVER+"0"><CR>"
.ENDIF
	RET

RCOM_A:
WCOM_A:	RET					; (Affichage sur led).



RCOM_B:
	TEXTDEBUG	COMM,SPACE,rcomm_b	; Baud-rate B_ascii.
	JUMP		COM_B
WCOM_B:
	TEXTDEBUG	COMM,SPACE,wcomm_b	; Baud-rate B_ascii, send break.
	COMP.8		#"E",{A4}		; Send break enable ?
	JUMP,EQ		ENA$			; oui ==> enable
	COMP.8		#"D",{A4}		; Send break disable ?
	JUMP,EQ		DISA$			; oui ==> disable
	JUMP		COM_B
ENA$:
	TSET.8		{A0}+OSWFLG0:#BW0OLDBRK	; Activation du send break en dehors du write.
	SETREG		REG05,BSENDBR		; On passe en mode send break.
	RET
DISA$:
	TCLR.8		{A0}+OSWFLG0:#BW0OLDBRK	; Dsactivation du send break en dehors du write.
	CLRREG		REG05,BSENDBR		; On enlve le mode send break.
	RET
COM_B:
	TSET.8		{A0}+OSMFLG0:#BM0BDEXACT ; Time-out exact donn par la commande Bxxx
	PUSH.32		A4
	CALL		ANALYSE			; Analyse la syntaxe: ?GETHEX.
	CALL		NBRATE			; Calcul le baud-rate exact.
	POP.32		D0
	TEST.16		D7
	JUMP,EQ		OK$
	MOVE.32		D0,A4
OK$:	RET



RCOM_C:
	TEXTDEBUG	COMM,SPACE,rcomm_c	; Clear les erreurs de lecture.
	CLR.8		{A0}+OSRERROR		; Vide les erreurs.
	CLR.8		{A0}+OSRPOUBELLE	; Vide la poubelle.
	DEC.32		A4			; Correction pointeur commande.
	RET
WCOM_C:
	TEXTDEBUG	COMM,SPACE,wcomm_c	; Clear les erreurs de lecture.
	DEC.32		A4			; Correction pointeur commande.
	RET					; Commande incorecte mais autorise.



RCOM_D:
	TEXTDEBUG	COMM,SPACE,rcomm_d	; Dbloccage mission, facteur de division.
;;;	MOVE.16		#ERILLO,D7		; Commande illgale.
;;;	RET
WCOM_D:
	TEXTDEBUG	COMM,SPACE,wcomm_d	; Dbloccage mission, facteur de division.
	COMP.8		#10'1,{A4}		; Division par 1 ?
	JUMP,EQ		DIV01$			; oui ==> DIV01$
	COMP.8		#10'16,{A4}		; Division par 16 ?
	JUMP,EQ		DIV16$			; oui ==> DIV16$
	COMP.8		#10'32,{A4}		; Division par 32 ?
	JUMP,EQ		DIV32$			; oui ==> DIV32$
	COMP.8		#10'64,{A4}		; Division par 64 ?
	JUMP,EQ		DIV64$			; oui ==> DIV64$
	DEC.32		A4			; Correction pointeur commande.
	TCLR.8		{A0}+OSWFLG0:#BW0STOP	; On redmarre l'criture.
	CLR.8		{A0}+OSXSENDXOFF
	CLR.8		{A0}+OSXFLG0		; Effface le pass du processus xon-xoff.
	PUSH.32		A5
	MOVE.32		{A0}+OSXADSEMAXOFF,A5	; Dbloque le smaphore de xon-xoff.
	NTREL		?SIGNEV
	POP.32		A5
	RET
DIV01$:	MOVE.8		#CLKX01,D0		; Division par clk:01.
	JUMP		DIV$
DIV16$:	MOVE.8		#CLKX16,D0		; Division par clk:16.
	JUMP		DIV$
DIV32$:	MOVE.8		#CLKX32,D0		; Division par clk:32.
	JUMP		DIV$
DIV64$:	MOVE.8		#CLKX64,D0		; Division par clk:64.
;;;	JUMP		DIV$
DIV$:	AND.8		#-1-CLKX64,{A1}+OHREGISTRES+REG04
	OR.8		D0,{A1}+OHREGISTRES+REG04
	OR.16		#2**REG04,{A1}+OHREGMODIF
	RET



;RCOM_E:
;WCOM_E:



RCOM_F:
	TEXTDEBUG	COMM,SPACE,rcomm_f	; Fifo.
	COMP.8		#"E",{A4}		; Fifo enable ?
	JUMP,EQ		r8^ENA$			; oui ==> enable
	COMP.8		#"D",{A4}		; Fifo disable ?
	JUMP,EQ		r8^DISA$			; oui ==> disable
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
ENA$:
	TCLR.8		{A0}+OSMFLG0:#BM0NOFIFO	; Y a-t-il un FIFO ?
	JUMP,BC		r8^OK$			; oui ==> on ne fait rien
	CALL		GETFIFO			; Installe le fifo.
OK$:	RET
DISA$:
	TCLR.8		{A0}+OSMFLG0:#BM0XOUT	; Pas de fifo ==> pas de xon-xoff en sortie.
	TSET.8		{A0}+OSMFLG0:#BM0NOFIFO	; Y a-t-il un FIFO ?
	JUMP,BS		r8^OK$			; non ==> on en fait rien
	CLR.32		{A0}+OSRLONGFIFO	; Plus de caractres dans le fifo.
	CALL		KILLFIFO		; Enlve le fifo.
	JUMP		r8^OK$
WCOM_F:
	TEXTDEBUG	COMM,SPACE,wcomm_f	; Fifo.
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET



;RCOM_G:
;WCOM_G:
RCOM_H:
WCOM_H:	RET					; (Haut-parleur).
RCOM_I:
WCOM_I:	RET					; (Dbug interrupt DCD SM100).
;RCOM_J:
;WCOM_J:
;RCOM_K:
;WCOM_K:



RCOM_L:
	TEXTDEBUG	COMM,SPACE,rcomm_l	; Longueur du caractre (R diff de W !!!).
	COMP.8		#"5",{A4}		; 5 bits ?
	JUMP,EQ		CINQ$			; oui ==> cinq
	COMP.8		#"6",{A4}		; 6 bits ?
	JUMP,EQ		SIX$			; oui ==> six
	COMP.8		#"7",{A4}		; 7 bits ?
	JUMP,EQ		SEPT$			; oui ==> sept
	COMP.8		#"8",{A4}		; 8 bits ?
	JUMP,EQ		HUIT$			; oui ==> huit
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
CINQ$:	CLRREG		REG03,BR68BCAR		; 6 ou 8 bits en rception.
	CLRREG		REG03,BR78BCAR		; 7 ou 8 bits en rception.
	RET
SIX$:	SETREG		REG03,BR68BCAR		; 6 ou 8 bits en rception.
	CLRREG		REG03,BR78BCAR		; 7 ou 8 bits en rception.
	RET
SEPT$:	CLRREG		REG03,BR68BCAR		; 6 ou 8 bits en rception.
	SETREG		REG03,BR78BCAR		; 7 ou 8 bits en rception.
	RET
HUIT$:	SETREG		REG03,BR68BCAR		; 6 ou 8 bits en rception.
	SETREG		REG03,BR78BCAR		; 7 ou 8 bits en rception.
	RET
WCOM_L:
	TEXTDEBUG	COMM,SPACE,wcomm_l	; Longueur du caractre (R diff de W !!!).
	COMP.8		#"5",{A4}		; 5 bits ?
	JUMP,EQ		CINQ$			; oui ==> cinq
	COMP.8		#"6",{A4}		; 6 bits ?
	JUMP,EQ		SIX$			; oui ==> six
	COMP.8		#"7",{A4}		; 7 bits ?
	JUMP,EQ		SEPT$			; oui ==> sept
	COMP.8		#"8",{A4}		; 8 bits ?
	JUMP,EQ		HUIT$			; oui ==> huit
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
CINQ$:	CLRREG		REG05,BT68BITS		; 6 ou 8 bits en mission.
	CLRREG		REG05,BT78BITS		; 7 ou 8 bits en mission.
	RET
SIX$:	SETREG		REG05,BT68BITS		; 6 ou 8 bits en mission.
	CLRREG		REG05,BT78BITS		; 7 ou 8 bits en mission.
	RET
SEPT$:	CLRREG		REG05,BT68BITS		; 6 ou 8 bits en mission.
	SETREG		REG05,BT78BITS		; 7 ou 8 bits en mission.
	RET
HUIT$:	SETREG		REG05,BT68BITS		; 6 ou 8 bits en mission.
	SETREG		REG05,BT78BITS		; 7 ou 8 bits en mission.
	RET



RCOM_M:
	TEXTDEBUG	COMM,SPACE,rcomm_m	; Modes simser/rs232, debug...
	JUMP		COM_M
WCOM_M:
	TEXTDEBUG	COMM,SPACE,wcomm_m	; Modes simser/rs232, debug...
;;;	JUMP		COM_M
	NOP
COM_M:
	COMP.8		#"R",{A4}		; RS232 ?
	JUMP,EQ		RS232$			; oui ==> rs232
	COMP.8		#"S",{A4}		; SIMSER ?
	JUMP,EQ		SIM$			; oui ==> simser
	COMP.8		#"D",{A4}		; DEBUG ?
	JUMP,EQ		DEBUG$			; oui ==> debug
	COMP.8		#"P",{A4}		; Croise les prises ?
	JUMP,EQ		PRISE$			; oui ==> prise
	COMP.8		#"H",{A4}		; HANDSHAKE CTS & DCD ?
	JUMP,EQ		HAND$			; oui ==> prise
	COMP.8		#"B",{A4}		; Changement du clock de baud-rate ?
	JUMP,EQ		BDRATE$			; oui ==> bdrate
	COMP.8		#"A",{A4}		; Auto echo ?
	JUMP,EQ		ECHO$			; oui ==> echo
	COMP.8		#"L",{A4}		; Local loop back ?
	JUMP,EQ		LOOP$			; oui ==> loop
	COMP.8		#"E",{A4}		; Erreurs d'usart prcise ?
	JUMP,EQ		ERROR$			; oui ==> error
	COMP.8		#"I",{A4}		; Dbranchement des interruptions ?
	JUMP,EQ		INTAUX$			; oui ==> int aux
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
RS232$:
	SETREG		REG11,BTCKBRG		; On passe en mode RS232.
	RET
SIM$:
	CLRREG		REG11,BTCKBRG		; On passe en mode SIMSER.
	RET
HAND$:
	COMP.8		#"E",{A4}+1		; HANDSHAKE CTS & DCD enable ?
	JUMP,EQ		ENA$			; oui ==> enable
	COMP.8		#"D",{A4}+1		; HANDSHAKE CTS & DCD disable ?
	JUMP,EQ		DISA$			; oui ==> disable
; Ajout RB 94/09/18
	COMP.8		#"R",{A4}+1		; MHR
	jump,eq		r8^HRTS$
	COMP.8		#"T",{A4}+1		; MHT
	jump,eq		r8^HDTR$	
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET

HRTS$:	COMP.8		#"E",{A4}+2		; MHRE
	jump,eq		r8^HRTSE$
	COMP.8		#"D",{A4}+2		; MHRD
	jump,eq		r8^HRTSD$
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
HRTSE$:	TSET.8		{A0}+OSRFLG1:#BR1HRTSEnable
	jump		r8^FH$
HRTSD$:	TCLR.8		{A0}+OSRFLG1:#BR1HRTSEnable
	jump		r8^FH$
	
HDTR$:	COMP.8		#"E",{A4}+2		; MHTE
	jump,eq		r8^HDTRE$
	COMP.8		#"D",{A4}+2		; MHTD
	jump,eq		r8^HDTRD$
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
HDTRE$:	TSET.8		{A0}+OSRFLG1:#BR1HDTREnable
	jump		r8^FH$
HDTRD$:	TCLR.8		{A0}+OSRFLG1:#BR1HDTREnable
;;	jump		r8^FH$
FH$:
	ADD.32		#2,A4
	RET
; Fin des modif RB

ENA$:	INC.32		A4			; Correction du pointeur des commandes.
	SETREG		REG03,BAUTOEN		 ; HANDSHAKE CTS & DCD autoenable activ.
	RET
DISA$:	INC.32		A4			; Correction du pointeur des commandes.
	CLRREG		REG03,BAUTOEN		 ; HANDSHAKE CTS & DCD autoenable dsactiv.
	RET
PRISE$:
	COMP.8		#"X",{A4}+1		; CROISE ?
	JUMP,EQ		CROI$			; oui ==> croise
	COMP.8		#"=",{A4}+1		; direct ?
	JUMP,EQ		DIR$			; oui ==> direct
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
CROI$:	INC.32		A4
	TSET.8		{A6}+OPARAM+ODRIVFLAG0:#BCROISE13 ; Croise les prises de l'usart.
	RET
DIR$:	INC.32		A4
	TCLR.8		{A6}+OPARAM+ODRIVFLAG0:#BCROISE13 ; Direct les prises de l'usart.
	RET
DEBUG$:
	MOVE.8		{A4}+1,D1
	JUMP,EQ		RIEN$
	INC.32		A4
	PUSH.32		A0
	MOVE.32		#{A6}+OPARAM+ODEBUG,A0
	CLR.16		D0
	COMP.8		#"O",D1
	JUMP,EQ		FDEB$
	MOVE.16		#VDEBUG,D0
	COMP.8		#"T",D1
	JUMP,EQ		FDEB$
	SUB.8		#"0",D1
	AND.8		#16'F,D1
	MOVE.16		{A0},D0
	TSET.32		D0:D1
FDEB$:	MOVE.16		D0,{A0}
	POP.32		A0
RIEN$:	RET
BDRATE$:
	COMP.8		#"7",{A4}+1		; 7.3728 Mhz ?
	JUMP,EQ		M7$			; oui ==> m7
	COMP.8		#"3",{A4}+1		; 3.6864 Mhz ?
	JUMP,EQ		M3$			; oui ==> m3
	COMP.8		#"4",{A4}+1		; 4 Mhz ?
	JUMP,EQ		M4$			; oui ==> m4
	COMP.8		#"8",{A4}+1		; 8 Mhz ?
	JUMP,EQ		M8$			; oui ==> m8
	COMP.8		#"H",{A4}+1		; 16 Mhz ?
	JUMP,EQ		M16$			; oui ==> m16
	COMP.8		#"Q",{A4}+1		; Valeur du quartz ?
	JUMP,EQ		MQ$			; oui ==> mq
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
M7$:	INC.32		A4
	MOVE.32		#CMBDRATE7,{A1}+OHCMBDRATE ; Constante de division du bdrate 7.3728 Mhz.
	RET
M3$:	INC.32		A4
	MOVE.32		#CMBDRATE3,{A1}+OHCMBDRATE ; Constante de division du bdrate 3.6864 Mhz.
	RET
M4$:	INC.32		A4
	MOVE.32		#CMBDRATE4,{A1}+OHCMBDRATE ; Constante de division du bdrate 4 Mhz.
	RET
M8$:	INC.32		A4
	MOVE.32		#CMBDRATE8,{A1}+OHCMBDRATE ; Constante de division du bdrate 8 Mhz.
	RET
M16$:	INC.32		A4
	MOVE.32		#CMBDRATE16,{A1}+OHCMBDRATE ; Constante de division du bdrate 16 Mhz.
	RET
MQ$:	INC.32		A4			; Corrige le pointeur.
	INC.32		A4
	MOVE.8		{A4+},D0		; Poids forts valeur du quartz.
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4},D0			; Poids faibles valeur du quartz.
	SR.32		#5,D0			; QUARTZ/(2*clk_mode_16).
	MOVE.32		D0,{A1}+OHCMBDRATE	 ; Constante de division du bdrate 8 Mhz.
	RET
ECHO$:
	COMP.8		#"E",{A4}+1		; Auto echo enable ?
	JUMP,EQ		ECENA$			; oui ==> enable
	COMP.8		#"D",{A4}+1		; Auto echo disable ?
	JUMP,EQ		ECDIS$			; oui ==> disable
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
ECENA$:	INC.32		A4			; Correction du pointeur des commandes.
	SETREG		REG14,BAUTECH		; Auto echo activ.
	RET
ECDIS$:	INC.32		A4			; Correction du pointeur des commandes.
	CLRREG		REG14,BAUTECH		; Auto echo dsactiv.
	RET
LOOP$:
	COMP.8		#"E",{A4}+1		; Local loop back enable ?
	JUMP,EQ		LOENA$			; oui ==> enable
	COMP.8		#"D",{A4}+1		; Local loop back disable ?
	JUMP,EQ		LODIS$			; oui ==> disable
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
LOENA$:	INC.32		A4			; Correction du pointeur des commandes.
	SETREG		REG14,BLOLOBA		; Local loop back activ.
	RET
LODIS$:	INC.32		A4			; Correction du pointeur des commandes.
	CLRREG		REG14,BLOLOBA		; Local loop back dsactiv.
	RET
ERROR$:
	COMP.8		#"E",{A4}+1		; Erreurs d'usart prcise enable ?
	JUMP,EQ		ERENA$			; oui ==> enable
	COMP.8		#"D",{A4}+1		; Erreurs d'usart prcise disable ?
	JUMP,EQ		ERDIS$			; oui ==> disable
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
ERENA$:	INC.32		A4			; Correction du pointeur des commandes.
	TSET.8		{A0}+OSMFLG0:#BM0ERRPR	; Erreurs d'usart prcise activ.
	RET
ERDIS$:	INC.32		A4			; Correction du pointeur des commandes.
	TCLR.8		{A0}+OSMFLG0:#BM0ERRPR	; Erreurs d'usart prcise dsactiv.
	RET
INTAUX$:
	COMP.8		#"R",{A4}+1		; Dbranchement des interruptions read ?
	JUMP,EQ		IAUXR$			; oui ==> int aux read
	COMP.8		#"W",{A4}+1		; Dbranchement des interruptions write ?
	JUMP,EQ		IAUXW$			; oui ==> int aux write
	COMP.8		#"S",{A4}+1		; Dbranchement des interruptions speciale ?
	JUMP,EQ		IAUXS$			; oui ==> int aux spec
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
IAUXR$:						; Dbranchement des interruptions read.
	INC.32		A4			; Corrige le pointeur.
	INC.32		A4
	MOVE.8		{A4+},D0		; Poids forts de l'adresse d'interruption.
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0		; Poids faibles de l'adresse d'interruption.
	MOVE.32		D0,{A1}+OHADINTRDAUX	; Adresse d'interruption de lecture auxiliaire.
	JUMP		IAUXF$
IAUXW$:						; Dbranchement des interruptions write.
	INC.32		A4			; Corrige le pointeur.
	INC.32		A4
	MOVE.8		{A4+},D0		; Poids forts de l'adresse d'interruption.
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0		; Poids faibles de l'adresse d'interruption.
	MOVE.32		D0,{A1}+OHADINTWRAUX	; Adresse d'interruption d'criture auxiliaire.
	JUMP		IAUXF$
IAUXS$:						; Dbranchement des interruptions speciale.
	INC.32		A4			; Corrige le pointeur.
	INC.32		A4
	MOVE.8		{A4+},D0		; Poids forts de l'adresse d'interruption.
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0		; Poids faibles de l'adresse d'interruption.
	MOVE.32		D0,{A1}+OHADINTSPAUX	; Adresse d'interruption spciale auxiliaire.
;;;	JUMP		IAUXF$
IAUXF$:
	MOVE.8		{A4+},D0		; Poids forts du pt aux vars user des int aux.
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4},D0			; Poids faibles du pt aux vars user des int aux.
	MOVE.32		D0,{A1}+OHPOINTAUX	; Pt aux vars user dans les int aux.
	RET



RCOM_N:
	TEXTDEBUG	COMM,SPACE,rcomm_n	; Mode standard.
	JUMP		COM_N
WCOM_N:
	TEXTDEBUG	COMM,SPACE,wcomm_n	; Mode standard.
;;;	JUMP		COM_N
	NOP
COM_N:
	COMP.8		#"N",{A4}
	JUMP,EQ		INITH$
	DEC.32		A4			; Corrige le pointeur des commandes.

	PUSHM.32	A2|A3
	MOVE.32		#R16^TABVECTEUR,A2	; Table des autovecteurs des nouvelles plaques.
.IF	SM324.AND.OLDPLAQUE
	PUSHM.32	D4|D7
	NTREL		?GETMACHINE
	COMP.16		#NUM3OLDPLAC,D4		; Numro maximum des anciennes plaques C.
	JUMP,HI		NEW$
	MOVE.32		#R16^TAB3VECTEUR,A2	; Table des autovecteurs des anciennes plaques C.
	COMP.16		#NUM4OLDPLAC,D4		; Numro maximum des anciennes plaques B.
	JUMP,HI		NEW$
	MOVE.32		#R16^TAB4VECTEUR,A2	; Table des autovecteurs des anciennes plaques B.
NEW$:	POPM.32		D4|D7
.ENDIF
	MOVE.32		{A1}+OHUSART,D0		; Adresse du priphrique DATA du Z8530.
LOOP$:	COMP.32		{A2+},D0
	JUMP,EQ		FINDV$
	ADD.32		#5*2+2*4,A2
	COMP.32		#2**7,{A2}
	JUMP,NE		LOOP$
	.16		?AFTIM
	.ASCIZE		"<CR>init vecteur int usart, AD$ incorrecte.<CR>"
	TRAP #10'10
	JUMP		FIN$
FINDV$:	ADD.32		#4*2+4,A2		; On a trouv la bonne table d'initialisation.
	MOVE.32		#R16^DRIVERS,A3
	ADD.32		{A2},A3			; A3: Pointeur  la table d'initialisation du Z8530.
	MOVE.32		#{A1}+OHREGISTRES,A2	; A2: Pt  la copie des registres internes du Z8530.
INIR$:	COMP.8		#2**7,{A3}		; Initialise les registres du canal du SCC Z8530.
	JUMP,EQ		FIN$
	MOVE.8		{A3+},D0
	AND.16		#16'F,D0		; D0: numro du registre pour la copie en mmoire.
	COMP.8		#REG01,D0		; On saute le registre no 1: MASQUES D'INTERRUPTIONS.
	JUMP,EQ		SUIV$
	MOVE.8		{A3},{A2}+A16^{D0}	; Initialise la pos mm correspondant au registre.
	CLR.16		D1
	TSET.32		D1:D0
	OR.16		D1,{A1}+OHREGMODIF	; Indique que ce registre a t modifi.
SUIV$:	INC.32		A3
	JUMP		INIR$
FIN$:	POPM.32		A2|A3
	JUMP		B9600$
INITH$:
	MOVE.8		{A1}+OHREGISTRES+REG01,D0 ; Sauve le registre 1.
	CALL		INITHARD
	MOVE.8		D0,{A1}+OHREGISTRES+REG01 ; Recharge le registre 1.
	OR.16		#2**REG01,{A1}+OHREGMODIF ; Registre 1  mettre  jour.
B9600$:
	MOVE.32		#10'9600,D0		; Force le baud-rate  9600 bauds.
	CALL		BRATE
	RET



RCOM_O:
	TEXTDEBUG	COMM,SPACE,rcomm_o	; Lignes en sortie DTR et smaphore DCD,BREAK,ERROR.
	COMP.8		#"C",{A4}		; DCD ?
	JUMP,EQ		DCD$			; oui ==> dcd
	COMP.8		#"B",{A4}		; BREAK ?
	JUMP,EQ		BREAK$			; oui ==> break
	COMP.8		#"E",{A4}		; ERROR ?
	JUMP,EQ		ERROR$			; oui ==> error
	COMP.8		#"D",{A4}		; DTR ?
	JUMP,NE		KO$			; non ==> commande illgale.
	COMP.8		#"E",{A4}+1		; DTR enable ?
	JUMP,EQ		ENA$			; oui ==> enable
	COMP.8		#"D",{A4}+1		; DTR disable ?
	JUMP,EQ		DISA$			; oui ==> disable
	COMP.8		#"X",{A4}+1		; do not change DTR at close ?
	JUMP,EQ		NOCHG$			; oui ==> nochg
	COMP.8		#"C",{A4}+1		; change DTR at close ?
	JUMP,EQ		CHANG$			; oui ==> chang
KO$:	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
ENA$:	INC.32		A4			; Correction du pointeur des commandes.
	TSET.8		{A0}+OSRFLG0:#BR0OLDDTR	; Activation de la ligne DTR en dehors du read.
	SETREG		REG05,BDTRENA		; Active la ligne DTR.
	RET
DISA$:	INC.32		A4			; Correction du pointeur des commandes.
	TCLR.8		{A0}+OSRFLG0:#BR0OLDDTR	; Dsactivation de la ligne DTR en dehors du read.
	CLRREG		REG05,BDTRENA		; Dsactive la ligne DTR.
	RET
NOCHG$:	INC.32		A4			; Correction du pointeur des commandes.
	TSET.8		{A0}+OSMFLG1:#BM1NCDTR	; Activation du no_change_DTR_at_close.
	RET
CHANG$:	INC.32		A4			; Correction du pointeur des commandes.
	TCLR.8		{A0}+OSMFLG1:#BM1NCDTR	; Dsactivation du no_change_DTR_at_close.
	RET
DCD$:
	INC.32		A4			; A4 pointe sur le long-word du smaphore DCD.
	MOVE.8		{A4+},D0		; Poids forts smaphore.
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4},D0			; Poids faibles du smaphore.
	MOVE.32		D0,{A0}+OSRADSEMADCD	; Ecrit le pointeur au smaphore SEMADCD.
	RET
BREAK$:
	INC.32		A4			; A4 pointe sur le long-word du smaphore BREAK.
	MOVE.8		{A4+},D0		; Poids forts smaphore.
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4},D0			; Poids faibles du smaphore.
	MOVE.32		D0,{A0}+OSRADSEMABRK	; Ecrit le pointeur au smaphore SEMABRK.
	RET
ERROR$:
	INC.32		A4			; A4 pointe sur le long-word du smaphore ERROR.
	MOVE.8		{A4+},D0		; Poids forts smaphore.
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4},D0			; Poids faibles du smaphore.
	MOVE.32		D0,{A0}+OSRADSEMAERR	; Ecrit le pointeur au smaphore SEMAERR.
	RET
WCOM_O:
	TEXTDEBUG	COMM,SPACE,wcomm_o	; Lignes en sortie RTS et semaphore CTS.
	COMP.8		#"C",{A4}		; CTS ?
	JUMP,EQ		CTS$			; oui ==> cts
	COMP.8		#"R",{A4}		; RTS ?
	JUMP,NE		KO$			; non ==> commande illgale.
	COMP.8		#"E",{A4}+1		; RTS enable ?
	JUMP,EQ		ENA$			; oui ==> enable
	COMP.8		#"D",{A4}+1		; RTS disable ?
	JUMP,EQ		DISA$			; oui ==> disable
	COMP.8		#"X",{A4}+1		; do not change RTS at close ?
	JUMP,EQ		NOCHG$			; oui ==> nochg
	COMP.8		#"C",{A4}+1		; change RTS at close ?
	JUMP,EQ		CHANG$			; oui ==> chang
KO$:	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
ENA$:	INC.32		A4			; Correction du pointeur des commandes.
	TSET.8		{A0}+OSWFLG0:#BW0OLDRTS	; Activation de la ligne RTS en dehors du write.
	SETREG		REG05,BRTSENA		; Active la ligne RTS.
	RET
DISA$:	INC.32		A4			; Correction du pointeur des commandes.
	TCLR.8		{A0}+OSWFLG0:#BW0OLDRTS	; Dsactivation de la ligne RTS en dehors du write.
	CLRREG		REG05,BRTSENA		; Dsactive la ligne RTS.
	RET
NOCHG$:	INC.32		A4			; Correction du pointeur des commandes.
	TSET.8		{A0}+OSMFLG1:#BM1NCRTS	; Activation du no_change_RTS_at_close.
	RET
CHANG$:	INC.32		A4			; Correction du pointeur des commandes.
	TCLR.8		{A0}+OSMFLG1:#BM1NCRTS	; Dsactivation du no_change_RTS_at_close.
	RET
CTS$:
	INC.32		A4			; A4 pointe sur le long-word du smaphore CTS.
	MOVE.8		{A4+},D0		; Poids forts smaphore.
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4+},D0
	RL.32		#10'8,D0
	MOVE.8		{A4},D0			; Poids faibles du smaphore.
	MOVE.32		D0,{A0}+OSWADSEMACTS	; Ecrit le pointeur au smaphore SEMACTS.
	RET



RCOM_P:
	TEXTDEBUG	COMM,SPACE,rcomm_p	; Parit.
	JUMP		COM_P
WCOM_P:
	TEXTDEBUG	COMM,SPACE,wcomm_p	; Parit.
;;;	JUMP		COM_P
	NOP
COM_P:
	COMP.8		#"E",{A4}		; Even ?
	JUMP,EQ		EVEN$			; oui ==> even
	COMP.8		#"O",{A4}		; Odd ?
	JUMP,EQ		ODD$			; oui ==> odd
	COMP.8		#"D",{A4}		; Disable ?
	JUMP,EQ		DISA$			; oui ==> disable
	COMP.8		#"R",{A4}		; Remplacement en cas d'erreur de parit ?
	JUMP,EQ		REMPL$			; oui ==> rempl
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
EVEN$:
	SETREG		REG04,BPARENA		 ; Parit enable.
	SETREG		REG04,BPAREVE		 ; Parit even.
	RET
ODD$:
	SETREG		REG04,BPARENA		 ; Parit enable
	CLRREG		REG04,BPAREVE		 ; Parit odd.
	RET
DISA$:
	CLRREG		REG04,BPARENA		 ; Parit disable.
	RET
REMPL$:
	INC.32		A4
	MOVE.8		{A4},{A0}+OSRPARIT	; Premier caractre de remplacement.
	INC.32		A4
	MOVE.8		{A4},{A0}+OSRPARIT+1	; Segond caractre de remplacement.
	RET



;RCOM_Q:
;WCOM_Q:



RCOM_R:
	TEXTDEBUG	COMM,SPACE,rcomm_r	; Repeat xon-xoff.
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET					; Commande incorecte mais autorise.
WCOM_R:
	TEXTDEBUG	COMM,SPACE,wcomm_r	; Repeat xon-xoff.
	COMP.8		#"E",{A4}		; Actif ?
	JUMP,EQ		ENA$			; oui ==> enable
	COMP.8		#"D",{A4}		; Inactif ?
	JUMP,EQ		DISA$			; oui ==> disable
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
ENA$:	TSET.8		{A0}+OSMFLG0:#BM0REPEATXON ; Time-out en entre donn par commande.
	RET
DISA$:	TCLR.8		{A0}+OSMFLG0:#BM0REPEATXON ; Time-out en entre donn par processus.
	RET



RCOM_S:
	TEXTDEBUG	COMM,SPACE,rcomm_s	; Stop-bit.
	JUMP		COM_S
WCOM_S:
	TEXTDEBUG	COMM,SPACE,wcomm_s	; Stop-bit.
;;;	JUMP		COM_S
	NOP
COM_S:
	COMP.8		#"2",{A4}		; 2 stops-bits ?
	JUMP,EQ		DEUX$			; oui ==> deux
	COMP.8		#"1",{A4}		; 1 stops-bits ?
	JUMP,EQ		UN$			; oui ==> un
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
DEUX$:
	SETREG		REG04,BSTOB12		 ; 1 ou 2 stops bits.
	SETREG		REG04,BSTOB152		 ; 1,5 ou 2stops bits.
	RET
UN$:
	COMP.8		#".",{A4}+1		; 1.5 stops-bits ?
	JUMP,EQ		DEMI$			; oui ==> demi
	SETREG		REG04,BSTOB12		 ; 1 ou 2 stops bits.
	CLRREG		REG04,BSTOB152		 ; 1,5 ou 2stops bits.
	RET
DEMI$:
	COMP.8		#"5",{A4}+2		; 1.5 stops-bits ?
	JUMP,EQ		OK$			; oui ==> ok
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
OK$:	ADD.32		#2,A4			; Correction du pointeur des commandes.
	CLRREG		REG04,BSTOB12		 ; 1 ou 2 stops bits.
	SETREG		REG04,BSTOB152		 ; 1,5 ou 2stops bits.
	RET



RCOM_T:
	TEXTDEBUG	COMM,SPACE,rcomm_t	; Time-out Wascii
	CALL		ANALYSE			; Lecture du nombre et Conversion BCD-BIN.
	TEST.8		{A0}+OSMFLG0:#BM0RTIMO	; Time-out par commandes ?
	JUMP,BC		ERROR$			; non ==> error
	MOVE.16		D0,{A0}+OSRTIMEOUT	; Charge la valeur du time-out.
	RET
ERROR$:	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
WCOM_T:
	TEXTDEBUG	COMM,SPACE,wcomm_t	; Time-out Wascii
	CALL		ANALYSE			; Lecture du nombre et Conversion BCD-BIN.
	TEST.8		{A0}+OSMFLG0:#BM0WTIMO	; Time-out par commandes ?
	JUMP,BC		ERROR$			; non ==> error
	MOVE.16		D0,{A0}+OSWTIMEOUT	; Charge la valeur du time-out.
	RET
ERROR$:	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET



;RCOM_U:
;WCOM_U:



RCOM_V:
	TEXTDEBUG	COMM,SPACE,rcomm_V	; Baud-rate V[xx.W]
	JUMP		COM_V
WCOM_V:
	TEXTDEBUG	COMM,SPACE,wcomm_V	; Baud-rate V[xx.W]
;;;	JUMP		COM_V
	NOP
COM_V:
	TCLR.8		{A0}+OSMFLG0:#BM0BDEXACT ; Pas de time-out exact: commande V[xxx.W]
	CLR.32		D0
	MOVE.8		{A4+},D0		; Poids forts du baud-rate.
	RL.16		#10'8,D0
	MOVE.8		{A4},D0			; Poids faibles du baud-rate.
;;;	JUMP		BRATE
BRATE:
	.IF		DEBUG
	PUSHM.32	D0|D4|D7
	MOVE.16		D0,D4
	MOVE.16		{A6}+OPARAM+ODEBUG,D0
	TEST.32		D0:#BCOMMDEBUG
	JUMP,BC		NOTX$
	.16		?AFX4
NOTX$:	POPM.32		D0|D4|D7
	.ENDIF

	PUSH.32		A2
	MOVE.32		#R16^TABRATE7,A2	; Table avec les baud-rates  7.3728Mhz..
	COMP.32		#CMBDRATE7,{A1}+OHCMBDRATE ; Constante de division du bdrate 7.3728 Mhz ?
	JUMP,EQ		LOOP$			; oui ==> ok
	MOVE.32		#R16^TABRATE3,A2	; Table avec les baud-rates  3.6864Mhz..
	COMP.32		#CMBDRATE3,{A1}+OHCMBDRATE ; Constante de division du bdrate 3.6864 Mhz ?
	JUMP,EQ		LOOP$			; oui ==> ok
	MOVE.32		#R16^TABRATE8,A2	; Table avec les baud-rates  8Mhz..
	COMP.32		#CMBDRATE8,{A1}+OHCMBDRATE ; Constante de division du bdrate 8 Mhz ?
	JUMP,EQ		LOOP$			; oui ==> ok
	MOVE.32		#R16^TABRATE16,A2	; Table avec les baud-rates  16Mhz..
	COMP.32		#CMBDRATE16,{A1}+OHCMBDRATE ; Constante de division du bdrate 16 Mhz ?
	JUMP,EQ		LOOP$			; oui ==> ok
	MOVE.32		#R16^TABRATE4,A2	; Table avec les baud-rates  4Mhz.
LOOP$:
	COMP.16		{A2},D0			; Commande trouve ?
	JUMP,EQ		TROUVE$			; oui ==> trouv
	COMP.16		#2**7,{A2}		; Fin de la table ?
	JUMP,EQ		ERROR$			; oui ==> erreur commande illgale.
	ADD.32		#2+1+1,A2		; Essaye la commande suivante.
	JUMP		LOOP$
TROUVE$:
	ADD.32		#2,A2			; Met le pointeur sur l'adresse de l'indirection.
	MOVE.8		{A2+},{A1}+OHREGISTRES+REG13 ; Baud-rate high.
	OR.16		#2**REG13,{A1}+OHREGMODIF    ; On a modifi le registre 13.
	MOVE.8		{A2},{A1}+OHREGISTRES+REG12  ; Baud-rate low.
	OR.16		#2**REG12,{A1}+OHREGMODIF    ; On a modifi le registre 12.
FIN$:	POP.32		A2
	RET
ERROR$:
	DEC.32		A4			; Correction pointeur commande.
	MOVE.16		#ERILLO,D7		; Erreur commande illgale.
	JUMP		FIN$



;			    (clock_4Mhz)			   CMBDRATE4
; time_cte.16 =	 ------------------------------------ - 2	= ----------- - CSBDRATE
;		  2 x (clock_mode_x16) x (baud_rate)		   baud-rate
;
CMBDRATE7	=	NDCKBDRATE/(2*10'16)	; Constante de division  7.3728Mhz.
CMBDRATE3	=	NCCKBDRATE/(2*10'16)	; Constante de division  3.6864Mhz.
CMBDRATE4	=	CKBDRATE/(2*10'16)	; Constante de division   4Mhz.
CMBDRATE8	=	2*CMBDRATE4		; Constante de division   8Mhz.
CMBDRATE16	=	2*CMBDRATE8		; Constante de division  16Mhz.
CSBDRATE	=	2			; Constante de soustraction.

TABRATE4:					; Table avec les diffrents baud-rate  4Mhz.
	.16.8.8		10'57600,	16'0,	16'0
	.16.8.8		10'38400,	16'0,	16'1
	.16.8.8		10'19200,	16'0,	16'5	;4
	.16.8.8		10'9600,	16'0,	16'B
	.16.8.8		10'7200,	16'0,	16'F
	.16.8.8		10'4800,	16'0,	16'18
	.16.8.8		10'3600,	16'0,	16'21	;20
	.16.8.8		10'2400,	16'0,	16'32
	.16.8.8		10'2000,	16'0,	16'3D	;3C
	.16.8.8		10'1800,	16'0,	16'43
	.16.8.8		10'1200,	16'0,	16'66
	.16.8.8		10'600,		16'0,	16'CE
	.16.8.8		10'300,		16'1,	16'9F	;9E
	.16.8.8		10'150,		16'3,	16'3F
	.16.8.8		10'134,		16'3,	16'A3	;A2
	.16.8.8		10'110,		16'4,	16'6E
	.16.8.8		10'75,		16'6,	16'81	;80
	.16.8.8		10'50,		16'9,	16'C2
	.16		2**7
	.EVEN
TABRATE8:					; Table avec les diffrents baud-rate  8Mhz.
	.16.8.8		10'57600,	16'0,	16'2
	.16.8.8		10'38400,	16'0,	16'5	;4
	.16.8.8		10'19200,	16'0,	16'B
	.16.8.8		10'9600,	16'0,	16'18
	.16.8.8		10'7200,	16'0,	16'21	;20
	.16.8.8		10'4800,	16'0,	16'32
	.16.8.8		10'3600,	16'0,	16'43
	.16.8.8		10'2400,	16'0,	16'66
	.16.8.8		10'2000,	16'0,	16'7B
	.16.8.8		10'1800,	16'0,	16'89	;88
	.16.8.8		10'1200,	16'0,	16'CE
	.16.8.8		10'600,		16'1,	16'9F	;9E
	.16.8.8		10'300,		16'3,	16'3F
	.16.8.8		10'150,		16'6,	16'81	;80
	.16.8.8		10'134,		16'7,	16'48	;47
	.16.8.8		10'110,		16'8,	16'DF	;DE
	.16.8.8		10'75,		16'D,	16'03
	.16.8.8		10'50,		16'13,	16'86
	.16		2**7
	.EVEN
TABRATE3:					; Table avec les diffrents baud-rate  3.6864Mhz.
	.16.8.8		10'57600,	16'0,	16'0
	.16.8.8		10'38400,	16'0,	16'1
	.16.8.8		10'19200,	16'0,	16'4
	.16.8.8		10'9600,	16'0,	16'A
	.16.8.8		10'7200,	16'0,	16'E
	.16.8.8		10'4800,	16'0,	16'16
	.16.8.8		10'3600,	16'0,	16'1E
	.16.8.8		10'2400,	16'0,	16'2E
	.16.8.8		10'2000,	16'0,	16'38	;37
	.16.8.8		10'1800,	16'0,	16'3E
	.16.8.8		10'1200,	16'0,	16'5E
	.16.8.8		10'600,		16'0,	16'BE
	.16.8.8		10'300,		16'1,	16'7E
	.16.8.8		10'150,		16'2,	16'FE
	.16.8.8		10'134,		16'3,	16'5A	;59
	.16.8.8		10'110,		16'4,	16'15
	.16.8.8		10'75,		16'5,	16'FE
	.16.8.8		10'50,		16'8,	16'FE
	.16		2**7
	.EVEN
TABRATE7:					; Table avec les diffrents baud-rate  7.3728Mhz.
;@@@	.16.8.8		10'115200,	16'0,	16'0
	.16.8.8	10'115200.AND.16'0FFFF,	16'0,	16'0
	.16.8.8		10'57600,	16'0,	16'2
	.16.8.8		10'38400,	16'0,	16'4
	.16.8.8		10'19200,	16'0,	16'A
	.16.8.8		10'9600,	16'0,	16'16
	.16.8.8		10'7200,	16'0,	16'1E
	.16.8.8		10'4800,	16'0,	16'2E
	.16.8.8		10'3600,	16'0,	16'3E
	.16.8.8		10'2400,	16'0,	16'5E
	.16.8.8		10'2000,	16'0,	16'71
	.16.8.8		10'1800,	16'0,	16'7E
	.16.8.8		10'1200,	16'0,	16'BE
	.16.8.8		10'600,		16'1,	16'7E
	.16.8.8		10'300,		16'2,	16'FE
	.16.8.8		10'150,		16'5,	16'FE
	.16.8.8		10'134,		16'6,	16'B5
	.16.8.8		10'110,		16'8,	16'2D
	.16.8.8		10'75,		16'B,	16'FE
	.16.8.8		10'50,		16'11,	16'FE
	.16		2**7
	.EVEN
TABRATE16:					; Table avec les diffrents baud-rate  16MHz
;@@@	.16.8.8		10'115200,	16'0,	16'2
	.16.8.8	10'115200.AND.16'0FFFF,	16'0,	16'2
	.16.8.8		10'57600,	16'0,	16'7
	.16.8.8		10'38400,	16'0,	16'B
	.16.8.8		10'19200,	16'0,	16'18
	.16.8.8		10'9600,	16'0,	16'32
	.16.8.8		10'7200,	16'0,	16'43
	.16.8.8		10'4800,	16'0,	16'66
	.16.8.8		10'3600,	16'0,	16'89
	.16.8.8		10'2400,	16'0,	16'CE
	.16.8.8		10'2000,	16'0,	16'F8
	.16.8.8		10'1800,	16'1,	16'14
	.16.8.8		10'1200,	16'1,	16'9F
	.16.8.8		10'600,		16'3,	16'3F
	.16.8.8		10'300,		16'6,	16'81
	.16.8.8		10'150,		16'D,	16'03
	.16.8.8		10'134,		16'E,	16'91
	.16.8.8		10'110,		16'11,	16'BF
	.16.8.8		10'75,		16'1A,	16'09
	.16.8.8		10'50,		16'27,	16'0E
	.16		2**7
	.EVEN



NBRATE:
	TEST.16		D0
	JUMP,EQ		ERROR$

	MOVE.32		{A1}+OHCMBDRATE,D1	; Constante de division.
	DIV.16		D0,D1			; Baud-rate en binaire.
	SUB.16		#CSBDRATE,D1		; Constante de soustraction.

	MOVE.8		D1,{A1}+OHREGISTRES+REG12 ; Baud-rate low.
	OR.16		#2**REG12,{A1}+OHREGMODIF ; On a modifi le registre 12.
	RL.16		#8,D1
	MOVE.8		D1,{A1}+OHREGISTRES+REG13 ; Baud-rate high.
	OR.16		#2**REG13,{A1}+OHREGMODIF ; On a modifi le registre 13.

	.IF		DEBUG
	RL.16		#8,D1
	PUSHM.32	D2|D4|D7
	MOVE.32		D0,D4
	MOVE.16		{A6}+OPARAM+ODEBUG,D0
	TEST.32		D0:#BCOMMDEBUG
	JUMP,BC		NOTXT$
	.16		?AFTIM
	.ASCIZE		"<CR>Bdrate dsir:"
	.16		?AFX4

	MOVE.32		D1,D4
	.16		?AFTIM
	.ASCIZE		", registres Z8530:"
	.16		?AFX4

	ADD.16		#CSBDRATE,D1		; Constante de soustraction.
	MOVE.32		{A1}+OHCMBDRATE,D4	; Constante de division.
	DIV.16		D1,D4			; Baud-rate en binaire.
	AND.32		#16'FFFF,D4		; Masque le reste.

	.16		?AFTIM
	.ASCIZE		", Bdrate rel:"
	.16		?AFX4

	DIV.16		#10'10000,D4
	JUMP,VS		TOBIG$
	COMP.16		#10'10000,D4
	JUMP,HS		TOBIG$
	PUSH.16		D4			; Stack <-- quotient.
	SWAP.32		D4
	PUSH.16		D4			; Stack <-- reste.

	CLR.32		D4
	MOVE.16		#2-1,D2
LOOP1$:
	POP.16		D0			; D0 <-- reste puis quotient.

; Calcul de  4 digits par div succ. de D0 par 1010 et
; copie du reste dans D4 aprs dcalage.

	MOVE.16		#4-1,D7
LOOP2$:
	AND.32		#16'FFFF,D0
	DIV.16		#10'10,D0
	MOVE.32		D0,D1
	SWAP.32		D1
	AND.16		#16'F,D1
	OR.16		D1,D4
	RR.32		#4,D4
	DJ.16,NMO	D7,LOOP2$
	DJ.16,NMO	D2,LOOP1$
TOBIG$:
	.16		?AFTIM
	.ASCIZE		" =10'"
	.16		?AFX8
NOTXT$:	POPM.32		D2|D4|D7
	.ENDIF
	RET
ERROR$:	DEC.32		A4			; Correction pointeur commande.
	MOVE.16		#ERILLO,D7		; Erreur commande illgale.
	RET



RCOM_W:
	TEXTDEBUG	COMM,SPACE,rcomm_w	; Time-out W[xx.W]
	CLR.32		D0
	MOVE.8		{A4+},D0		; Poids forts du time-out.
	RL.16		#10'8,D0
	MOVE.8		{A4},D0			; Poids faibles du time-out.
	TEST.8		{A0}+OSMFLG0:#BM0RTIMO	; Time-out par commandes ?
	JUMP,BC		ERROR$			; non ==> error
	MOVE.16		D0,{A0}+OSRTIMEOUT	; Charge la valeur du time-out.
	RET
ERROR$:	DEC.32		A4			; Correction pointeur commande.
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
WCOM_W:
	TEXTDEBUG	COMM,SPACE,wcomm_w	; Time-out W[xx.W]
	CLR.32		D0
	MOVE.8		{A4+},D0		; Poids forts du time-out.
	RL.16		#10'8,D0
	MOVE.8		{A4},D0			; Poids faibles du time-out.
	TEST.8		{A0}+OSMFLG0:#BM0WTIMO	; Time-out par commandes ?
	JUMP,BC		ERROR$			; non ==> error
	MOVE.16		D0,{A0}+OSWTIMEOUT	; Charge la valeur du time-out.
	RET
ERROR$:	DEC.32		A4			; Correction pointeur commande.
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET



RCOM_X:
	TEXTDEBUG	COMM,SPACE,rcomm_x	; Xon-xoff en entre.
	COMP.8		#"E",{A4}		; Actif ?
	JUMP,EQ		ENA$			; oui ==> enable
	COMP.8		#"D",{A4}		; Inactif ?
	JUMP,EQ		DISA$			; oui ==> disable
	COMP.8		#"S",{A4}		; quivaut  un XOFF reu ?
	JUMP,EQ		STOP$			; oui ==> stop
	COMP.8		#"G",{A4}		; quivaut  un XON reu ?
	JUMP,EQ		GO$			; oui ==> go
	JUMP		CARX			; Dfinition caractre xon -xoff.
ENA$:	TSET.8		{A0}+OSMFLG0:#BM0XIN	; "XE": Xon-xoff en entre activ.
	RET
DISA$:	TCLR.8		{A0}+OSMFLG0:#BM0XIN	; "XD": Xon-xoff en entre dactiv.
	RET
STOP$:	TSET.8		{A0}+OSWFLG0:#BW0STOP	; "XS": Equivaut  un XOFF reu: stop write.
	JUMP		END$
GO$:	TCLR.8		{A0}+OSWFLG0:#BW0STOP	; "XG": Equivaut  un XON reu: redmarre write.
END$:	PUSH.32		A5			; Rveille le processus PROCSENDXF.
	MOVE.32		{A0}+OSXADSEMAXOFF,A5
	NTREL		?SIGNEV
	POP.32		A5
	RET

WCOM_X:
	TEXTDEBUG	COMM,SPACE,wcomm_x	; Xon-xoff en sortie.
	COMP.8		#"E",{A4}		; Actif ?
	JUMP,EQ		r8^ENA$			; oui ==> enable
	COMP.8		#"D",{A4}		; Inactif ?
	JUMP,EQ		r8^DISA$			; oui ==> disable
	COMP.8		#"X",{A4}		; Ne filtre pas les xon-xoff user ?
	JUMP,EQ		r8^NOFIL$			; oui ==> nofil
	COMP.8		#"C",{A4}		; Filtre  nouveau les xon-xoff user ?
	JUMP,EQ		r8^FILTRE$			; oui ==> filtre
	JUMP		r8^CARX			; Dfinition caractre xon -xoff.
ENA$:	TEST.8		{A0}+OSMFLG0:#BM0NOFIFO	; Y-a-t'il un fifo ?
	JUMP,BS		r8^ERROR$
	TSET.8		{A0}+OSMFLG0:#BM0XOUT	; "XE": Xon-xoff en sortie activ.
	RET
DISA$:	TCLR.8		{A0}+OSMFLG0:#BM0XOUT	; "XD": Xon-xoff en sortie dsactiv.
	RET
NOFIL$:	TSET.8		{A0}+OSMFLG1:#BM1NFX	; "XX": Ne filtre pas les xon-xoff user en sortie.
	RET
FILTRE$:TCLR.8		{A0}+OSMFLG1:#BM1NFX	; "XC": Filtre les xon-xoff user en sortie.
	RET
ERROR$:	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
CARX:
	COMP.8		#"N",{A4}		; Caractre xon ?
	JUMP,EQ		r8^XON$			; oui ==> xon
	COMP.8		#"F",{A4}		; Caractre xoff ?
	JUMP,EQ		r8^XOFF$			; oui ==> xoff
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
XON$:	INC.32		A4
	MOVE.8		{A4},{A0}+OSXON		; Mmorise le nouveau caractre xon.
	RET
XOFF$:	INC.32		A4
	MOVE.8		{A4},{A0}+OSXOFF	; Mmorise le nouveau caractre xoff.
	RET



RCOM_Y:
	TEXTDEBUG	COMM,SPACE,rcomm_y	; Time-out par commande ou processus.
	COMP.8		#"E",{A4}		; Actif ?
	JUMP,EQ		ENA$			; oui ==> enable
	COMP.8		#"D",{A4}		; Inactif ?
	JUMP,EQ		DISA$			; oui ==> disable
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
ENA$:	TSET.8		{A0}+OSMFLG0:#BM0RTIMO	; Time-out en entre donn par commande.
	RET
DISA$:	TCLR.8		{A0}+OSMFLG0:#BM0RTIMO	; Time-out en entre donn par processus.
	RET
WCOM_Y:
	TEXTDEBUG	COMM,SPACE,wcomm_y	; Time-out par commande ou processus.
	COMP.8		#"E",{A4}		; Actif ?
	JUMP,EQ		ENA$			; oui ==> enable
	COMP.8		#"D",{A4}		; Inactif ?
	JUMP,EQ		DISA$			; oui ==> disable
	MOVE.16		#ERILLO,D7		; Commande illgale.
	RET
ENA$:	TSET.8		{A0}+OSMFLG0:#BM0WTIMO	; Time-out en sortie donn par commande.
	RET
DISA$:	TCLR.8		{A0}+OSMFLG0:#BM0WTIMO	; Time-out en sortie donn par processus.
	RET



;RCOM_Z:
;WCOM_Z:



;--------\
; ANALYSE >
;========/

; Conv BCD-ASCII ==> binaire.
; in	A4.32	^nombre dans la commande.
; out	D0.32	nombre en binaire.
; mod	D0.32

ANALYSE:
	TEXTDEBUG	ROUT,SPACE,analyse
	PUSHM.32	 D1|D4|D7|A0
	CLR.32		D1
	MOVE.32		D1,D0
LOOP$:	MOVE.8		{A4+},D0		; Prends le digit.
	COMP.8		#"0",D0			; Suprieur  zro.
	JUMP,LO		FIN$			; non ==> fin du nombre.
	COMP.8		#"9",D0			; Infrieur  neuf.
	JUMP,HI		FIN$			; non ==> fin du nombre.
	SUB.8		#"0",D0			; D0: digit en binaire.
	SL.32		#4,D1
	OR.32		D0,D1			; Ajoute le digit au nombre.
	JUMP		LOOP$			; On continue...
FIN$:	DEC.32		A4			; Corrige le pointeur aux commandes.
	DEC.32		A4

	MOVE.32		D1,D4			; Conversion: D1_dcimal ==> D0_binaire.
	CLR.32		D0
	MOVE.16		#8-1,D7			; Compteur.
CONV$:	RL.32		#4,D4
	MOVE.16		D4,D1
	AND.32		#16'0F,D1		; Digit isol.
	SL.32		#1,D0			;\
	MOVE.32		D0,A0			; \ Multiplie par 1010.
	SL.32		#2,D0			; /
	ADD.32		A0,D0			;/
	ADD.32		D1,D0			; Ajoute le digit.
	DJ.16,NMO	D7,CONV$
	POPM.32		D1|D4|D7|A0
	RET



;--------\
; RSTATUS >
;========/
;--------\
; WSTATUS >
;========/

; in	A0.32	^base du drivers.
;	A4.32	^buffer
;	D4.32	longueur buffer
; out	D4.32	longueur rendue effectivement
;	D7.16	erreur
; mod	D0..A1, D4.32, D7.16

RSTATUS:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,RSTATUS
	JUMP		r8^STATUS
WSTATUS:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,WSTATUS
;;;	JUMP		STATUS
	NOP
STATUS:
	PUSHM.32	A2|A3|A4
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	MOVE.32		#{A6}+OSTATUT,A2

	CLR.16		D0
	TEST.8		{A0}+OSRERROR:#BPARER	; Erreur de parity.
	JUMP,BC		r8^NOPAR$
	TSET.32		D0:#BSPERR
NOPAR$:	TEST.8		{A0}+OSRERROR:#BRCVOV	; Erreur d'overrun.
	JUMP,BC		r8^NOVER$
	TSET.32		D0:#BSOERR
NOVER$:	TEST.8		{A0}+OSRERROR:#BCRCFE	; Erreur de framming.
	JUMP,BC		r8^NOFRA$
	TSET.32		D0:#BSFERR
NOFRA$:
	TEST.8		{A1}+OHREGISTRES+REG04:#BPARENA	; Parit enable.
	JUMP,BC		r8^NOPAE$
	TSET.32		D0:#BSPEN
NOPAE$:	TEST.8		{A1}+OHREGISTRES+REG04:#BPAREVE	; Parit even.
	JUMP,BC		r8^NOPEV$
	TSET.32		D0:#BSEVP
NOPEV$:	
	TEST.8		{A0}+OSMFLG0:#BM0NOFIFO	; Mode avec FIFO (read).
	JUMP,BS		r8^NOFIF$
	TSET.32		D0:#BSFIFO
NOFIF$:	TEST.8		{A0}+OSMFLG0:#BM0XIN	; Mode Xon-xoff IN.
	JUMP,BC		r8^NOXIN$
	TSET.32		D0:#BSXIN
NOXIN$:	TEST.8		{A0}+OSMFLG0:#BM0XOUT	; Mode Xon-xoff OUT.
	JUMP,BC		r8^NOXOU$
	TSET.32		D0:#BSXOUT
NOXOU$:
	MOVE.8		D0,{A2}+OSTAFLG		; Copie errors, Flags...

	CLR.16		D0
	TEST.8		{A1}+OHREGISTRES+REG03:#BR68BCAR ; Longueur 68 du caractre.
	JUMP,BC		r8^NOL68$
	TSET.32		D0:#BSL1
NOL68$:	TEST.8		{A1}+OHREGISTRES+REG03:#BR78BCAR ; Longueur 78 du caractre.
	JUMP,BC		r8^NOL78$
	TSET.32		D0:#BSL2
NOL78$:
	TEST.8		{A1}+OHREGISTRES+REG04:#BSTOB12  ; Nombre 12 de stops-bits.
	JUMP,BC		r8^NOS12$
	TSET.32		D0:#BSB1
NOS12$:	TEST.8		{A1}+OHREGISTRES+REG04:#BSTOB152 ; Nombre 152 de stops-bits.
	JUMP,BC		r8^NOS152$
	TSET.32		D0:#BSB2
NOS152$:
	TEST.8		{A1}+OHSTATUS:#BSYGDCD	; Ligne DCD dans le status dja mmoris du Z8530 R0.
	JUMP,BC		r8^NODCD$
	TSET.32		D0:#BSDSR
NODCD$:
;;;	TEST.8		{A0}+OSMFLG0:#BM0HP	; Mode HP. (IN et OUT)
;;;	JUMP,BC		NOHP$
;;;	TSET.32		D0:#BSHP
NOHP$:	TEST.8		{A0}+OSMFLG0:#BM0REPEATXON ; Rptition xon-xoff user.
	JUMP,BC		r8^NOXON$
	TSET.32		D0:#BSXREPE
NOXON$:
	MOVE.8		D0,{A2}+OSTAFLG+1	; Copie longueur car, stop-bits...

	MOVE.8		{A1}+OHREGISTRES+REG13,D1 ; Baud-rate high.
	RL.16		#8,D1
	MOVE.8		{A1}+OHREGISTRES+REG12,D1 ; Baud-rate low.
	TEST.8		{A0}+OSMFLG0:#BM0BDEXACT  ; Time-out exact: commande Bxxx ?
	JUMP,BS		BDEXA$

	MOVE.32		#R16^TABRATE7,A3	; Table avec les baud-rates  7.3728Mhz..
	COMP.32		#CMBDRATE7,{A1}+OHCMBDRATE ; Constante de division du bdrate 7.3728 Mhz ?
	JUMP,EQ		r8^LOOP$			; oui ==> ok
	MOVE.32		#R16^TABRATE3,A3	; Table avec les baud-rates  3.6864Mhz..
	COMP.32		#CMBDRATE3,{A1}+OHCMBDRATE ; Constante de division du bdrate 3.6864 Mhz ?
	JUMP,EQ		r8^LOOP$			; oui ==> ok
	MOVE.32		#R16^TABRATE8,A3	; Table avec les baud-rates  8Mhz..
	COMP.32		#CMBDRATE8,{A1}+OHCMBDRATE ; Constante de division du bdrate 8 Mhz ?
	JUMP,EQ		r8^LOOP$			; oui ==> ok
	MOVE.32		#R16^TABRATE16,A3	; Table avec les baud-rates  16Mhz..
	COMP.32		#CMBDRATE16,{A1}+OHCMBDRATE ; Constante de division du bdrate 16 Mhz ?
	JUMP,EQ		r8^LOOP$			; oui ==> ok
	MOVE.32		#R16^TABRATE4,A3	; Table avec les baud-rates  4Mhz.
LOOP$:	MOVE.16		{A3},D0			; Charge la valeur binaire.
	COMP.16		{A3}+2,D1		; Commande trouve ?
	JUMP,EQ		r8^BDFIN$			; oui ==> trouv
	CLR.16		D0			; Valeur fausse.
	COMP.16		#2**7,{A3}		; Fin de la table ?
	JUMP,EQ		r8^BDEXA$			; oui ==> erreur bdrate illgal ==> bdrate exact.
	ADD.32		#2+1+1,A3		; Essaye la ligne suivante.
	JUMP		r8^LOOP$
BDEXA$:
	ADD.16		#CSBDRATE,D1		; Constante de soustraction.
	MOVE.32		{A1}+OHCMBDRATE,D0	; Constante de division.
	DIV.16		D1,D0			; Baud-rate en binaire.
BDFIN$:	MOVE.16		D0,{A2}+OSTABR		; Copie baud-rate.

	MOVE.32		{A0}+OSRDIMFIFO,D0
	SUB.32		{A0}+OSRLONGFIFO,D0	; D0: longueur du fifo en caractres.
	MOVE.16		D0,{A2}+OSTALENG	; Copie nombre de caractres dans le fifo.
	MOVE.16		{A0}+OSRTIMEOUT,{A2}+OSTARTIM ; Copie time-out read.
	MOVE.16		{A0}+OSWTIMEOUT,{A2}+OSTAWTIM ; Copie time-out write.
	MOVE.32		{A0}+OSRDIMFIFO,{A2}+OSTAFIFO ; Copie longueur maximum du fifo.

	MOVE.8		#TYPEUSA,D0		; Type d'usart SM324: Z8530.
	SL.8		#4,D0
	TEST.8		{A1}+OHREGISTRES+REG05:#BRTSENA ; Ligne RTS.
	JUMP,BC		r8^NORTS$
	TSET.32		D0:#BSRTS
NORTS$:	TEST.8		{A1}+OHREGISTRES+REG05:#BDTRENA ; Ligne DTR.
	JUMP,BC		r8^NODTR$
	TSET.32		D0:#BSDTR
NODTR$:	TEST.8		{A1}+OHSTATUS:#BSIGCTS	; Ligne CTS dans le status dja mmoris du Z8530 R0.
	JUMP,BC		r8^NOCTS$
	TSET.32		D0:#BSCTS
NOCTS$:	TEST.8		{A1}+OHSTATUS:#BBREABO	; Ligne CTS dans le status dja mmoris du Z8530 R0.
	JUMP,BC		r8^NOBRK$
	TSET.32		D0:#BSBRK
NOBRK$:	MOVE.8		D0,{A2}+OSTATYPE	; Copie Type, RTS, DTR, CTS, BRK.

	MOVE.8		{A0}+OSXON,{A2}+OSTAXON   ; Copie valeur du caractre XON.
	MOVE.8		{A0}+OSXOFF,{A2}+OSTAXOFF ; Copie valeur du caractre XOFF.

	CLR.8		{A2}+OSTAXRW		; Efface par dfaut les flags xon-xoff rcv-send.
	TEST.8		{A0}+OSWFLG0:#BW0STOP	; on a stopp ?
	JUMP,BC		r8^XONRCV$			; non ==> on ne fait rien
	TSET.8		{A2}+OSTAXRW:#BSXRCV	; Xoff recu (flow out stop).
XONRCV$:
	TEST.8		{A0}+OSXFLG0:#BX0OLDXOFF ; on a envoy un xoff ?
	JUMP,BC		r8^XONSEND$		; non ==> on ne fait rien
	TSET.8		{A2}+OSTAXRW:#BSXSEND	; Xoff envoy (flow in stop).
XONSEND$:

MODEH$:
	TEST.8		{A1}+OHREGISTRES+REG03:#BAUTOEN ; Mode AutoEnable CTS/DCD
	jump,bc		r8^NOH$
	TSET.8		{A2}+OSTAXRW:#BSHCTSDCD	; Mode Handshake avec CTS/DCD
NOH$:
	TEST.8		{A0}+OSRFLG1:#BR1HRTSEnable
	jump,bc		r8^NOHR$
	TSET.8		{A2}+OSTAXRW:#BSHRTS	; Mode Handshake par RTS
NOHR$:
	TEST.8		{A0}+OSRFLG1:#BR1HDTREnable
	jump,bc		r8^NOHD$
	TSET.8		{A2}+OSTAXRW:#BSHDTR	; Mode Handshake par DTR
NOHD$:
	MOVE.16		#LSTATUT,D0		; Copie la longueur dsire.
	MOVE.16		D4,D1			; Longueur  copier.
	CLR.32		D4			; Compteur des caractres effectivement copis.
COPIE$:	TEST.16		D1			; On en a assez copi ?
	JUMP,EQ		r8^FIN$			; oui ==> fin
	MOVE.8		{A2+},{A4+}		; non ==> on copie...
	DEC.16		D1			; Un de moins  copier.
	INC.16		D4			; Un de plus copi.
	DEC.16		D0			; On peut encore en copier ?
	JUMP,NE		r8^COPIE$			; oui ==> copie
	TEST.16		D1			; On en demande trop ?
	JUMP,EQ		r8^FIN$			; non ==> fin
	MOVE.16		#ERIRLG,D7		; Trop de caractres demands.
FIN$:
	POPM.32		A2|A3|A4
	POPA6APPEL
	RET



;--------\
; READ    >
;========/

; in	A0.32	^base du drivers.
;	A4.32	^buffer texte
;	A1.32	^liste de terminateurs
;	D5.32	lg maximale du texte
; out	D5.32	lg effectivement lue
;	D7.16	erreur
; mod	D7.16, D5.32

READ:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,READ
	PUSHM.32	D4|D6|A2|A3|A4|A5

	TEST.32		D5			; Rien  faire ?
	JUMP,EQ		FIN$			; oui ==> fin
	PUSH.32		A1
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	POP.32		A2			; Pointeur aux terminateurs.
	MOVE.32		A2,{A0}+OSWADTERMIN	; Pointeur aux terminateurs.

	LOCK
	MOVE.32		{A0}+OSRDIMFIFO,D0
	SUB.32		{A0}+OSRLONGFIFO,D0	; D0: longueur du fifo en caractres.
	COMP.32		D5,D0			; Assez de caractres dans le fifo ?
	JUMP,HS		COPYFIFO$		; oui ==> alors on les copie.

	MOVE.16		{A0}+OSRTIMEOUT,D4	; Si time-out nul retour rapide sans mode direct.
	TEST.8		{A0}+OSMFLG0:#BM0RTIMO	; Time-out donn par command ?
	JUMP,BS		NTC$			; OUI ==>  pas de ?GETTIM
	NTREL		?GETTIM
NTC$:	TEST.16		D4			; Time-out nul ?
	JUMP,NE		DIR$			; NON ==> mode direct
	MOVE.32		D0,D5			; OUI ==> on copie tous les caractres
	JUMP		COPYFIFO$		; disponibles dans le fifo.
DIR$:
	MOVE.32		A4,A2			; Initialise le mode DIRECT pour le reste.
	ADD.32		D0,A2			; Index dans buffer user.
	MOVE.32		A2,{A0}+OSRADDIRECT	; Pointeur dans le buffer user pour copie directe.
	SUB.32		D0,D5			; Demande_user - caractres_dans_FIFO.
	MOVE.32		D5,{A0}+OSRLONGDIRECT	; Nonbre de caractres qu'il faut encore lire.
	TSET.8		{A0}+OSRFLG0:#BR0DIRECT	; Accs en mode direct dans le buffer du user.
	TSET.8		{A0}+OSRFLG0:#BR0WAIT	; Il faudra attendre la fin du mode direct.
	MOVE.32		D0,D5			; Il faut encore copier le reste du fifo.
COPYFIFO$:
	UNLOCK
	MOVE.32		{A0}+OSRADREADFIFO,A2	; Pointeur de lecture du fifo.
	MOVE.32		{A0}+OSRADENDFIFO,A3	; Pointeur  la fin du fifo.
LOOPCOPY$:
	TEST.32		D5			; On a tout copi ?
	JUMP,EQ		FINCOPY$		; oui ==> fin de la copie.
	MOVE.8		{A2+},{A4+}		; Copie le caractre.
	INC.32		{A0}+OSRLONGFIFO	; On vient de librer une case du fifo.
	INC.32		{A0}+OSRCOUNT		; Un caractre de plus dans le buffer du user.
	DEC.32		D5			; Un caractre de moins  copier.
	COMP.32		A3,A2			; On est  la fin du fifo ?
	JUMP,LO		LOOPCOPY$		; non ==> loopcopy
	MOVE.32		{A0}+OSRADBEGINFIFO,A2	; Pointeur au dbut du fifo.
	JUMP		LOOPCOPY$
FINCOPY$:
	MOVE.32		A2,{A0}+OSRADREADFIFO	; Pointeur de lecture du fifo.

	MOVE.32		{A0}+OSRDIMFIFO,D0	; Envoi d'un xon si FIFO assez vide.
	SUB.32		{A0}+OSRLONGFIFO,D0	; D0: longueur du fifo en caractres.
	COMP.32		{A0}+OSRMINFIFO,D0	; Longueur du fifo assez petite ?
	JUMP,HS		NOXON$			; non ==> pas d'envoi de xon.

	TEST.8		{A0}+OSMFLG1:#BM1NCDTR	; Activation du no_change_DTR_at_close ?
	JUMP,BS		NC$			; Oui ==> ne change pas la ligne DTR.
	SETREG		REG05,BDTRENA		; Active la ligne DTR.
	CALL		SENDREG			; Met  jour les registres internes du Z8530.
NC$:
	TCLR.8		{A0}+OSXFLG0:#BX0USARTXOFF ; USARTXOFF = xon.
	MOVE.32		{A0}+OSXADSEMAXOFF,A5	; Dbloque le smaphore de xon-xoff.
	NTREL		?SIGNEV
	JUMP,NE		ERROR$
NOXON$:
	TCLR.8		{A0}+OSRFLG0:#BR0WAIT	; Faut-il faudra attendre la fin du mode direct.
	JUMP,BC		ERROR$			; non ==> pas de wait mais fin de l'appel read.
ATTEND$:
	TEST.8		{A0}+OSMFLG0:#BM0RTIMO	; Time-out donn par command ?
	JUMP,BC		NOTIMCOM$		; non ==> wait directement.
	NTREL		?GETTIM
	JUMP,NE		ERROR$
	MOVE.16		D4,D6
	MOVE.16		{A0}+OSRTIMEOUT,D4
	NTREL		?SETTIM
	JUMP,NE		ERROR$
NOTIMCOM$:
	MOVE.32		{A0}+OSRADSEMAREAD,A5	; Attend la fin du mode direct.
	NTREL		?WAITEV

	TEST.8		{A0}+OSMFLG0:#BM0RTIMO	; Time-out donn par command ?
	JUMP,BC		NOOLDTIM$		; non ==> on ne remet pas l'ancien time-out.
	MOVE.16		D6,D4			; Ancien time-out.
	MOVE.16		D7,D6			; Erreur du ?waitev.
	NTREL		?SETTIM
	JUMP,NE		ERROR$
	MOVE.16		D6,D7			; Erreur du ?waitev.
NOOLDTIM$:
	TEST.16		D7			; Tout ok ?
	JUMP,EQ		ERROR$
	COMP.16		#ERTIMO,D7		; Time out ?
	JUMP,NE		ERROR$			; non ==> erreur.
	TCLR.8		{A0}+OSRFLG0:#BR0USECAR	; Time out rel ?
	JUMP,BS		ATTEND$			; non ==> attend encore.
	MOVE.16		#EROUTF,D7		; Erreur out_of_file.
ERROR$:
	CLR.32		{A0}+OSRLONGDIRECT	; Plus de caractres  lire en mode direct.
	TCLR.8		{A0}+OSRFLG0:#BR0DIRECT	; Arrte le mode direct.

	TCLR.8		{A0}+OSRFLG0:#BR0POUBELLE ; Caractre(s) mis  la poubelle ?
	JUMP,BS		POUBELLE$
	TCLR.8		{A0}+OSRFLG0:#BR0ERROR	; Erreur hardware ?
	JUMP,BC		NOHARDERROR$
	MOVE.16		#ERHREAD,D7		; Erreur de lecture hard.
	MOVE.8		{A0}+OSRERREAD,D0	; Erreurs lors del'appel READ.
	CLR.8		{A0}+OSRERREAD		; On efface les erreurs pour l'appel suivant.
	TEST.8		{A0}+OSMFLG0:#BM0ERRPR	; Erreurs usart prcises: overrun, framming, parit.
	JUMP,BC		NOHARDERROR$

	AND.16		#2**BCRCFE+2**BRCVOV+2**BPARER,D0 ; On ne guarde que les erreurs voulues.
	MOVE.32		#R16^TABERROR,A2	; Adresse de la table des erreurs.
LOPER$:	COMP.16		{A2+},D0		; Valeur trouve ?
	JUMP,EQ		FNDER$			; oui ==> finderror
	ADD.32		#2,A2			; Valeur suivante.
	COMP.16		#2**7,{A2}		; Fin de table ?
	JUMP,NE		LOPER$			; non ==> on continue
	.16		?AFTIM			; Erreur pas dans la table.
	.ASCIZE		"<CR>erreur impossible usart.<CR>"
	TRAP #10'10
	JUMP		NOHARDERROR$
FNDER$:	MOVE.16		{A2},D7			; On charge l'erreur correspondante.
	JUMP		NOHARDERROR$
POUBELLE$:
	MOVE.16		#ERHREAD,D7		; Erreur de lecture hard.
	TEST.8		{A0}+OSMFLG0:#BM0ERRPR	; Erreurs usart prcises: overrun, framming, parit.
	JUMP,BC		NOHARDERROR$
	MOVE.16		#ERFIFO,D7		; Erreur de FIFO.
NOHARDERROR$:
	TCLR.8		{A0}+OSRFLG0:#BW0AVORT	; Sortie force ?
	JUMP,BC		NOAVORT$
	MOVE.16		#ERTRAV,D7		; Erreur AVORT.
NOAVORT$:
	MOVE.32		{A0}+OSRCOUNT,D5	; Nb de caractres effectivement lu.
	CLR.32		{A0}+OSRCOUNT		; Tout a t compt.

	TEST.8		{A0}+OSRFLG0:#BR0OLDDTR	; Activation de la ligne DTR en dehors du read ?
	JUMP,BC		NODTR$
	SETREG		REG05,BDTRENA		; Active la ligne DTR.
	JUMP		FDTR$
NODTR$:	CLRREG		REG05,BDTRENA		; Dsactive la ligne DTR.
FDTR$:	CALL		SENDREG			; Met  jour les registres internes du Z8530.
FIN$:
	POPM.32		D4|D6|A2|A3|A4|A5
	POPA6APPEL
	RET

TABERROR:						  ; Table des erreurs.
	.16.16	2**BRCVOV			,EROV	  ; Erreur d'overrun.
	.16.16	2**BCRCFE			,ERFR	  ; Erreur de framming.
	.16.16	2**BRCVOV+2**BCRCFE		,EROVFR	  ; Erreur d'overrun et de framming.
	.16.16	2**BPARER			,ERPA	  ; Erreur de parit.
	.16.16	2**BRCVOV+2**BPARER		,EROVPA	  ; Erreur d'overrun et de parit.
	.16.16	2**BCRCFE+2**BPARER		,ERFRPA	  ; Erreur de framming et de parit.
	.16.16	2**BRCVOV+2**BCRCFE+2**BPARER	,EROVFRPA ; Erreur d'overrun, framming, parit.
	.16	2**7



;--------\
; WRITE   >
;========/

; in	A0.32	^base du drivers.
;	A4.32	^buffer texte
;	A1.32	^liste de terminateurs
;	D5.32	lg maximale du texte
; out	D5.32	lg effectivement crite
;	D7.16	erreur
; mod	D7.16, D5.32

WRITE:
	LODA6APPEL
	TEXTDEBUG	APPEL,CR,WRITE
	PUSHM.32	D4|D6|A2|A5

	TEST.32		D5			; Rien  faire ?
	JUMP,EQ		FIN$			; oui ==> fin
	PUSH.32		A1
	CALL		GETPOINT		; Va chercher les pointeurs aux variables.
	POP.32		A2			; Pointeur aux terminateurs.

	MOVE.32		A2,{A0}+OSWADTERMIN	; Pointeur aux terminateurs.
	MOVE.32		A4,{A0}+OSWADDATA	; Pointeur  la zone mmoire des DATAS.
	MOVE.32		D5,{A0}+OSWLONGDATA	; Nonbre de caractres  envoyer.
	CLR.32		{A0}+OSWCOUNT		; Aucun caractres dj transfrs.
	TSET.8		{A0}+OSWFLG0:#BW0ENABLE	; Routine d'interruption d'criture active.

	TEST.8		{A0}+OSMFLG1:#BM1NCRTS	; Activation du no_change_RTS_at_close ?
	JUMP,BS		NC$			; Oui ==> ne change pas la ligne RTS.
	SETREG		REG05,BRTSENA		; Active la ligne RTS.
NC$:
	CLRREG		REG05,BSENDBR		; On enlve le mode send break.
	CALL		SENDREG			; Met  jour les registres internes du Z8530.

	MOVE.32		{A0}+OSXADSEMAXOFF,A5	; Dbloque le smaphore de xon-xoff.
	NTREL		?SIGNEV
	JUMP,NE		ERROR$
ATTEND$:
	TEST.8		{A0}+OSMFLG0:#BM0WTIMO	; Time-out donn par command ?
	JUMP,BC		NOTIMCOM$		; non ==> wait directement.
	NTREL		?GETTIM
	JUMP,NE		ERROR$
	MOVE.16		D4,D6
	MOVE.16		{A0}+OSWTIMEOUT,D4
	NTREL		?SETTIM
	JUMP,NE		ERROR$
NOTIMCOM$:
	MOVE.32		{A0}+OSWADSEMAWRITE,A5	; Attend la fin de la transmission.
	NTREL		?WAITEV

	TEST.8		{A0}+OSMFLG0:#BM0WTIMO	; Time-out donn par command ?
	JUMP,BC		NOOLDTIM$		; non ==> on ne remet pas l'ancien time-out.
	MOVE.16		D6,D4			; Ancien time-out.
	MOVE.16		D7,D6			; Erreur du ?waitev.
	NTREL		?SETTIM
	JUMP,NE		ERROR$
	MOVE.16		D6,D7			; Erreur du ?waitev.
NOOLDTIM$:
	TEST.16		D7			; Tout ok ?
	JUMP,NE		ERR$			; non ==> analyse
	TEST.32		{A0}+OSWLONGDATA	; SIGNAL erron ?
	JUMP,NE		ATTEND$			; oui ==> on attend encore, (bug criture).
	JUMP		ERROR$
ERR$:	COMP.16		#ERTIMO,D7		; Time out ?
	JUMP,NE		ERROR$			; non ==> erreur.
	TCLR.8		{A0}+OSWFLG0:#BW0USECAR	; Time out rel ?
	JUMP,BS		ATTEND$			; non ==> attend encore.
	MOVE.16		#EROUTF,D7		; Erreur out_of_file.
ERROR$:
	CLR.32		{A0}+OSWLONGDATA	; Plus de caractres  envoyer.
	TCLR.8		{A0}+OSWFLG0:#BW0ENABLE	; Arrte l'criture.
	TCLR.8		{A0}+OSWFLG0:#BW0AVORT	; Sortie force ?
	JUMP,BC		NOAVORT$
	MOVE.16		#ERTRAV,D7		; Erreur AVORT.
NOAVORT$:
	MOVE.32		{A0}+OSWCOUNT,D5	; Nb de caractres effectivement crit.

	TEST.8		{A0}+OSWFLG0:#BW0OLDRTS	; Activation de la ligne RTS en dehors du write ?
	JUMP,BC		NORTS$
	SETREG		REG05,BRTSENA		; Active la ligne RTS.
	JUMP		FRTS$
NORTS$:	CLRREG		REG05,BRTSENA		; Dsactive la ligne RTS.
FRTS$:	;;;TEST.8	{A0}+OSWFLG0:#BW0OLDBRK	; Activation du send break en dehors du write ?
	;;;JUMP,BC	NOBRK$
	;;;SETREG	REG05,BSENDBR		; On active le mode send break.
	;;;JUMP		FBRK$
NOBRK$:	;;;CLRREG	REG05,BSENDBR		; On enlve le mode send break.
FBRK$:	CALL		SENDREG			; Met  jour les registres internes du Z8530.
FIN$:
	POPM.32		D4|D6|A2|A5
	POPA6APPEL
	RET



;===========================
; ROUTINES D'INTERRUPTIONS =
;===========================

;----------\
; INTREAD   >
;==========/

INTR_0:
	OR.16		#SMIOF,SF		; On bloque tout...
	AND.16		#ANDMASK,SF		; On remet au dessus de l'usart.
	LODA0INT
	PUSHM.32	D7|A2|A3|A4|A6
	MOVE.32		A0,A6
	INTTXDEB	INT,SPACE,IR0
	MOVE.32		#0,D0			; Numro du driver 0.
	JUMP		INTREAD			; Suite de la routine de lecture.
INTR_2:
	OR.16		#SMIOF,SF		; On bloque tout...
	AND.16		#ANDMASK,SF		; On remet au dessus de l'usart.
	LODA0INT
	PUSHM.32	D7|A2|A3|A4|A6
	MOVE.32		A0,A6
	INTTXDEB	INT,SPACE,IR2
	MOVE.32		#2,D0			; Numro du driver 2.
	JUMP		INTREAD			; Suite de la routine de lecture.
INTR_4:
	OR.16		#SMIOF,SF		; On bloque tout...
	AND.16		#ANDMASK,SF		; On remet au dessus de l'usart.
	LODA0INT
	PUSHM.32	D7|A2|A3|A4|A6
	MOVE.32		A0,A6
	INTTXDEB	INT,SPACE,IR4
	MOVE.32		#4,D0			; Numro du driver 4.
;;;	JUMP		INTREAD			; Suite de la routine de lecture.
INTREAD:
	CALL		GETPT			; Va chercher les pointeurs aux variables.
	MOVE.32		D0,A2			; Adresse du priphrique DATA du Z8530.
	MOVE.32		D1,A3			; Adresse du priphrique COMMAND-STATUS du Z8530.
	TEST.32		{A1}+OHADINTRDAUX	; Adresse d'interruption de lecture auxiliaire ?
	JUMP,NE		INTAUX$
INTNORM$:
	TEST.8		{A0}+OSRFLG0:#BR0ENABLE	; Routine d'interruption de lecture ok ?
	JUMP,BC		NOINT$			; non ==> erreur pas d'interruption.
	TEST.8		{A3}:#BRCVAVA		; On a reu un caractre ?
	JUMP,BS		READCAR$		; oui ==> readcar
NOINT$:
	.16		?AFTIM
	.ASCIZE		"<CR>Interruption USART en lecture pas justifie"
	TRAP #10'10				; On rcupre comme on peut...
ENDREAD$:
;;;	WAIT1_7US
	MOVE.8		#REHIUS,{A3}		; Reset Highest Interrupt IUS.
	POPM.32		D7|A2|A3|A4|A6
	RET
READCAR$:
;;;	WAIT1_7US
	MOVE.8		#REG01,{A3}		; Lit les ventuelles erreurs.
	WAIT1_7US
	MOVE.8		{A3},D1
	WAIT1_7US
	MOVE.8		{A2},D0			; Lit le caractre.
	AND.8		#2**BCRCFE+2**BRCVOV+2**BPARER,D1
	JUMP,EQ		NOERROR$		; Il y a des erreurs ?
	OR.8		D1,{A0}+OSRERROR	; oui ==> on les mmorise, commande C.
	OR.8		D1,{A0}+OSRERREAD	; oui ==> on les mmorise, appel READ.
	TSET.8		{A0}+OSRFLG0:#BR0ERROR
	WAIT1_7US
	MOVE.8		#RESERR,{A3}		; Clear les erreurs dans le Z8530.

	.IF		DEBUG			; Affiche l'erreur.
	PUSH.16		D0
	MOVE.16		{A6}+OPARAM+ODEBUG,D0
	JUMP,EQ		NOTX$
	TEST.32		D0:#BERRORDEBUG		; Si dbug erreur.
	JUMP,BC		NOTX$
	.16		?AFTIM
	.ASCIZE		" error:"
	PUSH.16		D4
	MOVE.8		D1,D4
	.16		?AFB8			; Affiche l'tat du registre.
	POP.16		D4

;	TEST.32		D1:#BENDFR		; Affiche sa signification.
;	JUMP,BC		NOTX7$
;	.16		?AFTIM
;	.ASCIZE		" end-of-frame"
;NOTX7$:
	TEST.32		D1:#BCRCFE
	JUMP,BC		NOTX6$
	.16		?AFTIM
	.ASCIZE		" framming"
NOTX6$:
	TEST.32		D1:#BRCVOV
	JUMP,BC		NOTX5$
	.16		?AFTIM
	.ASCIZE		" overrun"
NOTX5$:
	TEST.32		D1:#BPARER
	JUMP,BC		NOTX4$
	.16		?AFTIM
	.ASCIZE		" parity"
NOTX4$:
;	TEST.32		D1:#BRESC0
;	JUMP,BC		NOTX3$
;	.16		?AFTIM
;	.ASCIZE		" residu0"
;NOTX3$:
;	TEST.32		D1:#BRESC1
;	JUMP,BC		NOTX2$
;	.16		?AFTIM
;	.ASCIZE		" residu1"
;NOTX2$:
;	TEST.32		D1:#BRESC2
;	JUMP,BC		NOTX1$
;	.16		?AFTIM
;	.ASCIZE		" residu2"
;NOTX1$:
;	TEST.32		D1:#BALLSN
;	JUMP,BC		NOTX$
;	.16		?AFTIM
;	.ASCIZE		" all-send"
NOTX$:
	POP.16		D0
	.ENDIF

	TEST.32		D1:#BPARER
	JUMP,BC		r8^NOREMP$
	TEST.8		{A0}+OSRPARIT
	JUMP,EQ		r8^NOREMP$
	COMP.8		{A0}+OSRPARIT,D0
	JUMP,EQ		r8^R2$
R1$:	MOVE.8		{A0}+OSRPARIT,D0
	JUMP		r8^NOERROR$
R2$:	MOVE.8		{A0}+OSRPARIT+1,D0
;;;	JUMP,EQ		R1$
	JUMP		r8^NOERROR$
NOREMP$:
	MOVE.32		{A0}+OSRADSEMAERR,D0	; Donne le pointeur du smaphore SEMAERR.
;;;	TEST.32		D0			; Pointeur valide ?
	JUMP,EQ		r8^NOERROR$		; non ==> on ne fait rien
	TEXTDEBUG	SIGNAL,SPACE,signalerror
	MOVE.32		D0,A1
	CLR.16		D7
	CALL		32^_ISIGNEV		; On effectue le signal.
	TEST.16		D7
	JUMP,EQ		r8^NOERROR$
	.16		?AFTIM
	.ASCIZE		"<CR>Signal ERROR incorrect ! "
	TRAP		#10'10
NOERROR$:
	TSET.8		{A0}+OSRFLG0:#BR0USECAR	; On a lu au moins un caractre.

	TEST.8		{A0}+OSMFLG0:#BM0XIN	; Traitement des xon-xoff en entre ?
	JUMP,BC		r8^NOXONXOFF$
	COMP.8		{A0}+OSXON,D0		; Caractre xon ?
	JUMP,EQ		RCVXON$			; oui ==> rcvxon
	COMP.8		{A0}+OSXOFF,D0		; Caractre xoff ?
	JUMP,EQ		RCVXOFF$		; oui ==> rcvxoff
NOXONXOFF$:
	TEST.8		{A0}+OSRFLG0:#BR0DIRECT	; On est en mode direct ?
	JUMP,BC		FIFO$			; non ==> fifo

	MOVE.32		{A0}+OSRADDIRECT,A4	; Place le caractre dans le buffer de l'utilisateur.
	MOVE.8		D0,{A4+}
	MOVE.32		A4,{A0}+OSRADDIRECT	; Met  jour le pointeur d'adresses.
	DEC.32		{A0}+OSRLONGDIRECT	; Met  jour le compteur de data  lire encore.
	INC.32		{A0}+OSRCOUNT		; Met  jour le compteur de data dj lu.

	TEST.32		{A0}+OSRLONGDIRECT	; Encore  lire en mode direct ?
	JUMP,NE		ENDREAD$		; oui ==> on a termin la routine d'interruption

	TCLR.8		{A0}+OSRFLG0:#BR0DIRECT	; On enlve le mode direct: mode avec fifo.

	INTTXDEB	SIGNAL,SPACE,signalread
	MOVE.32		{A0}+OSRADSEMAREAD,A1	; Donne le pointeur du smaphore SEMAREAD.
	CLR.16		D7
	CALL		32^_ISIGNEV
	JUMP		ENDREAD$
FIFO$:
	TEST.8		{A0}+OSMFLG0:#BM0NOFIFO	; Y-a-t'il un fifo ?
	JUMP,BS		POUBELLE$		; non ==> poubelle
	TEST.32		{A0}+OSRLONGFIFO	; Encore de la place libre dans le fifo ?
	JUMP,EQ		POUBELLE$		; non ==> poubelle

	MOVE.32		{A0}+OSRADWRITEFIFO,A4	; Met le caractre dans le FIFO.
	MOVE.8		D0,{A4+}
	COMP.32		{A0}+OSRADENDFIFO,A4	; On a fait le tour du FIFO ?
	JUMP,LO		r8^FIFOK$			; non ==> fifook
	MOVE.32		{A0}+OSRADBEGINFIFO,A4	; oui ==> on recommence au dbut du FIFO.
FIFOK$:	MOVE.32		A4,{A0}+OSRADWRITEFIFO	; Met  jour le pointeur d'adresses.
	DEC.32		{A0}+OSRLONGFIFO	; Met  jour le compteur de data libre dans le FIFO.

	MOVE.32		{A0}+OSRDIMFIFO,D1	; Envoi d'un xoff si FIFO trop plein.
	SUB.32		{A0}+OSRLONGFIFO,D1	; D1: longueur du fifo en caractres.
	COMP.32		{A0}+OSRMAXFIFO,D1	; Longueur du fifo trop grande ?
	JUMP,LO		ENDREAD$		; non ==> on a fini la routine d'interruption

	INTTXDEB	SIGNAL,SPACE,signalxoff
	TSET.8		{A0}+OSXFLG0:#BX0USARTXOFF ; USARTXOFF = xoff.
	MOVE.32		{A0}+OSXADSEMAXOFF,A1	; Donne le pointeur du smaphore SEMAXOFF.
	CLR.16		D7
	CALL		32^_ISIGNEV
	JUMP		ENDREAD$
POUBELLE$:
	TSET.8		{A0}+OSRFLG0:#BR0POUBELLE ; On a mis des caractres  la poubelle.
	MOVE.8		D0,{A0}+OSRPOUBELLE	; Mmorise le dernier caractre mis  la boubelle.
	INTTXDEB	ERROR,SPACE,poubelle
	JUMP		ENDREAD$
RCVXON$:
	INTTXDEB	XONXOFF,SPACE,rcvxon-go
	TCLR.8		{A0}+OSWFLG0:#BW0STOP	; On redmarre l'criture.
	JUMP		SIGNALXOFF$
RCVXOFF$:
	INTTXDEB	XONXOFF,SPACE,rcvxoff-stop
	TSET.8		{A0}+OSWFLG0:#BW0STOP	; On stoppe l'criture.
;;;	JUMP		SIGNALXOFF$
SIGNALXOFF$:
	INTTXDEB	SIGNAL,SPACE,signalxoff
	MOVE.32		{A0}+OSXADSEMAXOFF,A1	; Donne le pointeur du smaphore SEMAXOFF.
	CLR.16		D7
	CALL		32^_ISIGNEV
	JUMP		ENDREAD$
INTAUX$:
	MOVE.32		#R16^INTNORM$,A6	; Pt  la routine d'interruption normale.
	MOVE.32		A6,D0
	MOVE.32		{A1}+OHPOINTAUX,A6	; Pt aux vars user dans les int aux.
	CALL		{A1}+OHADINTRDAUX	; Adresse d'interruption de lecture auxiliaire.
	JUMP		ENDREAD$



;-----------\
; INTWRITE   >
;===========/

INTW_1:
	OR.16		#SMIOF,SF		; On bloque tout...
	AND.16		#ANDMASK,SF		; On remet au dessus de l'usart.
	LODA0INT
	PUSHM.32	D7|A2|A3|A4|A6
	MOVE.32		A0,A6
	INTTXDEB	INT,SPACE,IW1
	MOVE.32		#1,D0			; Numro du driver 1.
	JUMP		r8^INTWRITE		; Suite de la routine d'criture.
INTW_3:
	OR.16		#SMIOF,SF		; On bloque tout...
	AND.16		#ANDMASK,SF		; On remet au dessus de l'usart.
	LODA0INT
	PUSHM.32	D7|A2|A3|A4|A6
	MOVE.32		A0,A6
	INTTXDEB	INT,SPACE,IW3
	MOVE.32		#3,D0			; Numro du driver 3.
	JUMP		r8^INTWRITE		; Suite de la routine d'criture.
INTW_5:
	OR.16		#SMIOF,SF		; On bloque tout...
	AND.16		#ANDMASK,SF		; On remet au dessus de l'usart.
	LODA0INT
	PUSHM.32	D7|A2|A3|A4|A6
	MOVE.32		A0,A6
	INTTXDEB	INT,SPACE,IW5
	MOVE.32		#5,D0			; Numro du driver 5.
;;;	JUMP		INTWRITE		; Suite de la routine d'criture.
INTWRITE:
	CALL		GETPT			; Va chercher les pointeurs aux variables.
	MOVE.32		D0,A2			; Adresse du priphrique DATA du Z8530.
	MOVE.32		D1,A3			; Adresse du priphrique COMMAND-STATUS du Z8530.
	TEST.32		{A1}+OHADINTWRAUX	; Adresse d'interruption d'criture auxiliaire ?
	JUMP,NE		INTAUX$
INTNORM$:
	MOVE.8		{A0}+OSXSENDXOFF,D0	; Doit-on envoyer un caractre xon-xoff ?
	JUMP,NE		SENDXOFF$		; oui ==> sendxoff
	TEST.8		{A0}+OSWFLG0:#BW0ENABLE	; Routine d'interruption d'criture ok ?
	JUMP,BC		STOP$			; non ==> stop
	TEST.32		{A0}+OSWLONGDATA	; Tous les datas dj envoys ?
	JUMP,EQ		SIGNALWRITE$		; oui ==> signalwrite

	MOVE.32		{A0}+OSWADDATA,A4	; Prend dans D0 le caractre  envoyer.
	MOVE.8		{A4+},D0
	TEST.8		{A0}+OSMFLG0:#BM0XOUT	; Traitement des xon-xoff en sortie ?
	JUMP,BC		WRITECAR$		; non ==> writecar
	TEST.8		{A0}+OSMFLG1:#BM1NFX	; Ne filtre pas les xon-xoff user en sortie ?
	JUMP,BS		WRITECAR$		; oui ==> writecar
	COMP.8		{A0}+OSXON,D0		; Caractre xon ?
	JUMP,EQ		USERXON$		; oui ==> userxon
	COMP.8		{A0}+OSXOFF,D0		; Caractre xoff ?
	JUMP,EQ		USERXOFF$		; oui ==> userxoff
WRITECAR$:
	TEST.8		{A0}+OSWFLG0:#BW0STOP	; Doit-on stopper l'mission, XOFF reu ?
	JUMP,BS		STOP$			; oui ==> stop
	WAIT1_7US
	TEST.8		{A3}:#BTXBEMP		; On peut envoyer un caractre ?
	JUMP,BC		FAITRIEN$		; non ==> faitrien
	WAIT1_7US
	MOVE.8		D0,{A2}			; Envoye le caractre.
	TSET.8		{A0}+OSWFLG0:#BW0USECAR	; On a crit au moins un caractre.
	MOVE.32		A4,{A0}+OSWADDATA	; Met  jour le pointeur d'adresses.
	DEC.32		{A0}+OSWLONGDATA	; Met  jour le compteur de data.
	INC.32		{A0}+OSWCOUNT		; Met  jour le compteur de data dj crit.
ENDWRITE$:
	TCLR.8		{A0}+OSWFLG0:#BW0PROCSXF; Call effectu depuis le processus PROCSENDXF ?
;@@@	JUMP,BS		END$			; bug criture car par car.
	WAIT1_7US
	MOVE.8		#REHIUS,{A3}		; Reset Highest Interrupt IUS.
END$:	POPM.32		D7|A2|A3|A4|A6
	RET
FAITRIEN$:
	INTTXDEB	ERROR,SPACE,faitrien
	JUMP		ENDWRITE$
SENDXOFF$:
	TEXTDEBUG	XONXOFF,SPACE,sendxonxoff
	WAIT1_7US
	TEST.8		{A3}:#BTXBEMP		; On peut envoyer le xon-xoff ?
	JUMP,BC		FAITRIEN$		; non ==> faitrien
	WAIT1_7US
	MOVE.8		D0,{A2}			; Envoye le xon-xoff.
	TSET.8		{A0}+OSWFLG0:#BW0USECAR	; On a crit au moins un caractre.

	COMP.8		{A0}+OSXON,D0		; Caractre xon ?
	JUMP,EQ		SXON$			; oui ==> userxon
	COMP.8		{A0}+OSXOFF,D0		; Caractre xoff ?
	JUMP,EQ		SXOFF$			; oui ==> userxoff
	.16		?AFTIM
	.ASCIZE		"<CR>Envoi d'un caractre XON-XOFF inconnu"
	TRAP #10'10
SXON$:	TCLR.8		{A0}+OSXFLG0:#BX0OLDXOFF ; OLDXF = SENDXF xon.
	CLR.8		{A0}+OSXSENDXOFF	; SENDXF = 0.
	JUMP		ENDWRITE$
SXOFF$:	TSET.8		{A0}+OSXFLG0:#BX0OLDXOFF ; OLDXF = SENDXF xoff.
	CLR.8		{A0}+OSXSENDXOFF	; SENDXF = 0.
	JUMP		ENDWRITE$
USERXON$:
	TCLR.8		{A0}+OSXFLG0:#BX0USERXOFF ; USERXOFF = xon.
	JUMP		SIGNALXOFF$
USERXOFF$:
	TSET.8		{A0}+OSXFLG0:#BX0USERXOFF ; USERXOFF = xoff.
;;;	JUMP		SIGNALXOFF$
SIGNALXOFF$:
	INTTXDEB	SIGNAL,SPACE,signalxoff
	MOVE.32		A4,{A0}+OSWADDATA	; Met  jour le pointeur d'adresses.
	DEC.32		{A0}+OSWLONGDATA	; Met  jour le compteur de data.
	INC.32		{A0}+OSWCOUNT		; Met  jour le compteur de data dj crit.
	MOVE.32		{A0}+OSXADSEMAXOFF,A1	; Donne le pointeur du smaphore SEMAXOFF.
	CLR.16		D7
	CALL		32^_ISIGNEV
	JUMP		ENDWRITE$
SIGNALWRITE$:
	INTTXDEB	SIGNAL,SPACE,signalwrite
	MOVE.32		{A0}+OSWADSEMAWRITE,A1	; Donne le pointeur du smaphore SEMAWRITE.
	CLR.16		D7
	CALL		32^_ISIGNEV
;;;	JUMP		STOP$
STOP$:
	INTTXDEB	INT,SPACE,stop
	TEST.8		{A0}+OSWFLG0:#BW0PROCSXF; Call effectu depuis le processus PROCSENDXF ?
	JUMP,BS		ENDWRITE$
	WAIT1_7US
	MOVE.8		#RESTIP,{A3}		; Clear l'Interrupt Pending d'mission.
	JUMP		ENDWRITE$
INTAUX$:
	MOVE.32		#R16^INTNORM$,A6	; Pt  la routine d'interruption normale.
	MOVE.32		A6,D0
	MOVE.32		{A1}+OHPOINTAUX,A6	; Pt aux vars user dans les int aux.
	CALL		{A1}+OHADINTWRAUX	; Adresse d'interruption d'criture auxiliaire.
	JUMP		ENDWRITE$



;----------\
; INTSPEC   >
;==========/

INTS_0:
	OR.16		#SMIOF,SF		; On bloque tout...
	AND.16		#ANDMASK,SF		; On remet au dessus de l'usart.
	LODA0INT
	PUSHM.32	D2|D7|A2|A3|A6
	MOVE.32		A0,A6
	INTTXDEB	INT,SPACE,IS1
	MOVE.32		#1,D0			; Numro du driver 1.
	JUMP		INTSPEC			; Suite de la routine d'criture.
INTS_2:
	OR.16		#SMIOF,SF		; On bloque tout...
	AND.16		#ANDMASK,SF		; On remet au dessus de l'usart.
	LODA0INT
	PUSHM.32	D2|D7|A2|A3|A6
	MOVE.32		A0,A6
	INTTXDEB	INT,SPACE,IS3
	MOVE.32		#3,D0			; Numro du driver 3.
	JUMP		INTSPEC			; Suite de la routine d'criture.
INTS_4:
	OR.16		#SMIOF,SF		; On bloque tout...
	AND.16		#ANDMASK,SF		; On remet au dessus de l'usart.
	LODA0INT
	PUSHM.32	D2|D7|A2|A3|A6
	MOVE.32		A0,A6
	INTTXDEB	INT,SPACE,IS5
	MOVE.32		#5,D0			; Numro du driver 5.
;;;	JUMP		INTSPEC			; Suite de la routine d'criture.
INTSPEC:
	CALL		GETPT			; Va chercher les pointeurs aux variables.
	MOVE.32		D0,A2			; Adresse du priphrique DATA du Z8530.
	MOVE.32		D1,A3			; Adresse du priphrique COMMAND-STATUS du Z8530.
	TEST.32		{A1}+OHADINTSPAUX	; Adresse d'interruption spciale auxiliaire ?
	JUMP,NE		INTAUX$
INTNORM$:
	TEST.8		{A1}+OHCOUNTRESET	; Usart install ?
	JUMP,NE		OK$
	.16		?AFTIM
	.ASCIZE		"<CR>Interruption ligne ext Z8530 injustifie ! "
	TRAP		#10'10
OK$:
	WAIT1_7US
	MOVE.8		{A3},D2			; D2: flags du Z8530 REG00.
	MOVE.8		{A1}+OHSTATUS,D1	; Status prcdent du Z8530.
	MOVE.8		D2,{A1}+OHSTATUS	; Nouveau status.
	XOR.8		D2,D1			; D1: bits qui ont changs.

	TEST.32		D1:#BSIGCTS		; Modification du CTS ?
	JUMP,BC		NOCTS$			; non ==> on ne fait rien.
	MOVE.32		{A0}+OSWADSEMACTS,D0	; Donne le pointeur du smaphore SEMACTS.
;;;	TEST.32		D0			; Pointeur valide ?
	JUMP,EQ		NOCTS$			; non ==> on ne fait rien
	TEXTDEBUG	SIGNAL,SPACE,signalcts
	MOVE.32		D0,A1
	CLR.16		D7
	CALL		32^_ISIGNEV		; On effectue le signal.
	TEST.16		D7
	JUMP,EQ		NOCTS$
	.16		?AFTIM
	.ASCIZE		"<CR>Signal CTS incorrect ! "
	TRAP		#10'10
NOCTS$:
	TEST.32		D1:#BSYGDCD		; Modification du DCD ?
	JUMP,BC		NODCD$			; non ==> on ne fait rien.
	MOVE.32		{A0}+OSRADSEMADCD,D0	; Donne le pointeur du smaphore SEMADCD.
;;;	TEST.32		D0			; Pointeur valide ?
	JUMP,EQ		NODCD$			; non ==> on ne fait rien
	TEXTDEBUG	SIGNAL,SPACE,signaldcd
	MOVE.32		D0,A1
	CLR.16		D7
	CALL		32^_ISIGNEV		; On effectue le signal.
	TEST.16		D7
	JUMP,EQ		NODCD$
	.16		?AFTIM
	.ASCIZE		"<CR>Signal DCD incorrect ! "
	TRAP		#10'10
NODCD$:
	TEST.32		D1:#BBREABO		; Break ?
	JUMP,BC		NOBRK$			; non ==> on ne fait rien.
	MOVE.32		{A0}+OSRADSEMABRK,D0	; Donne le pointeur du smaphore SEMABRK.
;;;	TEST.32		D0			; Pointeur valide ?
	JUMP,EQ		NOBRK$			; non ==> on ne fait rien
	TEXTDEBUG	SIGNAL,SPACE,signalbrk
	MOVE.32		D0,A1
	CLR.16		D7
	CALL		32^_ISIGNEV		; On effectue le signal.
	TEST.16		D7
	JUMP,EQ		NOBRK$
	.16		?AFTIM
	.ASCIZE		"<CR>Signal BREAK incorrect ! "
	TRAP		#10'10
NOBRK$:
	.IF		DEBUG
	MOVE.16		{A6}+OPARAM+ODEBUG,D0
	TEST.32		D0:#BEXTDEBUG
	JUMP,BC		NOTXT$

	.16		?AFTIM
	.ASCIZE		"<CR>status: "

	TEST.32		D1:#BBREABO		; Break ?
	JUMP,BC		BRKS$
	TEST.32		D2:#BBREABO
	JUMP,BC		BRKOF$
	.16		?AFTIM
	.ASCIZE		"BREAK-ON."
	JUMP		BRKS$
BRKOF$:	.16		?AFTIM
	.ASCIZE		"BREAK-OFF."
BRKS$:
	TEST.32		D1:#BSIGCTS
	JUMP,BC		CTSS$
	TEST.32		D2:#BSIGCTS
	JUMP,BC		CTSOF$
	.16		?AFTIM
	.ASCIZE		"CTS-ON."
	JUMP		CTSS$
CTSOF$:	.16		?AFTIM
	.ASCIZE		"CTS-OFF."
CTSS$:
	TEST.32		D1:#BSYGDCD
	JUMP,BC		NOTXT$
	TEST.32		D2:#BSYGDCD
	JUMP,BC		DCDOF$
	.16		?AFTIM
	.ASCIZE		"DCD-ON."
	JUMP		NOTXT$
DCDOF$:	.16		?AFTIM
	.ASCIZE		"DCD-OFF."
NOTXT$:
	.ENDIF
ENDSPEC$:
	WAIT1_7US
	MOVE.8		#RESESI,{A3}		; Reset External/Status Interrupt.
	WAIT1_7US
	MOVE.8		#REHIUS,{A3}		; Reset Highest Interrupt IUS.
	POPM.32		D2|D7|A2|A3|A6
	RET
INTAUX$:
	MOVE.32		#R16^INTNORM$,A6	; Pt  la routine d'interruption normale.
	MOVE.32		A6,D0
	MOVE.32		{A1}+OHPOINTAUX,A6	; Pt aux vars user dans les int aux.
	CALL		{A1}+OHADINTSPAUX	; Adresse d'interruption spciale auxiliaire.
	JUMP		ENDSPEC$



;=============
; Variables: =
;=============

.IF	ROMABLE
.ELSE
.IF	DEBUG
.ASCIZE		"*** FIN DU CODE DU DRIVERS USART rev <NREV+"0">-<NVER+"0"> ***"
.ENDIF
PTVARS:		.32		0		; Pointeur aux variables du drivers.
VARIABLES:	.FILL.8		LONGVAR,0	; ^ aux variables globales.
.ENDIF

.IF	DEBUG
.ASCIZE		"*** FIN DES VARIABLES DU DRIVERS USART 324 ***"
.ENDIF



	.END
