/*
 *	efs.cc
 *
 *	La classe EFS utilise par le serveur de fichiers gre la rception
 *	des paquets en provenance du pilote $XDRI et appelle les mthodes
 *	adquates.
 *
 *	Cette classe a t reprise du projet Smart implment en dbut
 *	d'anne. EFS implmente l'accs aux fichiers du PC sur Smaky 400
 *	en passant par l'interface "rseau".
 *
 *	(C) Copyright 1997, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#pragma implementation "efs.h"

#include <c++/portable.h>
#include <c++/mon.h>

#include "efs.h"
#include "pccomm.h"


/*
 *	Convertit une valeur 32-bit en un nombre pseudo-hexa 'A'  'P'.
 *	C'est le format utilis par le pilote $XDRI pour la transmission
 *	messages au moyen du ?REMOTE.
 */

static void
build_hexa (char* buffer, Card32 hexa)
{
	int    i = 8;
	Card32 a = 0;
	
	while (i--) {
		a         = (hexa & 0xF0000000) >> 28;
		hexa      = hexa << 4;
		*buffer++ = (char)(a) + 'A';
	}
	
	buffer[0] = 0;
}


/*
 *	Processus fils excutant la requte FOS ?REMOTE pour que $XDRI
 *	soit mis au courant de l'existance de l'EFS.
 */

void
efs_mount (Card32 param)
{
	const char* dir = (const char*)(param);
	const char* prg = dir; while (*prg++);
	
	asm volatile ( "movel %0,a3\n\t"
				   "movel %1,a4\n\t"
				   ".long 0x4E45004D"
				 :
				 : "g" (dir), "g" (prg)
				 : "d7", "a3", "a4" );
}


/*
 *	Cre le BAR priv utilis pour communiquer avec le pilote
 *	$XDRI. L'initialisation relle se fait par une mthode
 *	spcifique, StartServer...
 */

EFS::EFS () : bar ("EFS-server"), comm_bar ("#:PCCOMMBAR", 1)
{
	Card32 pid;
	Card16 pino;

	this->do_stop = FALSE;
	this->running = FALSE;
	
	Ntr::CreTask (EFS::Thread, 1000, 8, "EFSthread", (Card32)(this), 0, &pid, &pino);
}

/*
 *	La destruction du BAR se fait une fois que l'EFS a t
 *	dmont par XDRI, pas avant !
 */

EFS::~EFS ()
{
	this->do_stop = TRUE;
	this->sync_thread.Signal ();
	this->sync_got.Wait ();
}


/*
 *	Mthode centrale qui fait tout le travail de dialogue avec
 *	le pilote $XDRI :
 *
 *	1. Connecte au pilote $XDRI et demande de monter l'EFS.
 *	2. Attend des requtes depuis le pilote $XDRI.
 *	3. Le pilote $XDRI excute un MOUNT, ce qui provoque un
 *	   appel  la mthode EFS::Mount.
 *	4. Attend encore, jusqu' ce que quelqu'un demande au
 *	   pilote $XDRI de dmonter l'EFS. Ceci gnre un appel
 *	    la mthode EFS::Unmount.
 *	5. Le serveur retourne la main  l'appelant qui dtruit
 *     l'instance.
 */
 
void
EFS::StartServer (const char* xdri)
{
	char        buffer[200];
	char*       line = buffer;
	const char* src;
	char        hexa_bar[12];
	char        hexa_ins[12];
	
	
	//	Signale au pilote $XDRI que notre EFS est prt  l'emploi.
	
	build_hexa (hexa_bar, (Card32)(this->bar.GetBar ()));
	build_hexa (hexa_ins, (Card32)(this));
	
	src = xdri;     while ((*line++ = *src++)); line[-1] = ':';
	src = "MOUNT:"; while ((*line++ = *src++)); line[-1] = 0;
	src = hexa_bar; while ((*line++ = *src++)); line[-1] = ':';
	src = hexa_ins; while ((*line++ = *src++)); line[-1] = 0;
	
	{
		Card32 pid  = 0;
		Card16 pino = 0;
		Ntr::CreTask (efs_mount, 1000, 8, "EFS-mount", (Card32)(buffer), 0, &pid, &pino);
	}
	
	//	Boucle principale d'excution de commandes.
	
	Bool first_time = TRUE;
	this->running   = TRUE;
	
	while (this->running) {
		
		void*   ptr = 0;
		
		if (first_time) Ntr::SetTim (50);
		
		this->bar.Accept (ptr);
		
		if (first_time) {
			first_time = FALSE;
			Ntr::SetTim (0xFFFF);
		}
		
		if (this->bar.GetError ()) break;
		
		this->msg.data        = ((EFSmsg*)(ptr))[0];
		this->msg.bal.num_msg = 0;
		
		this->sync_thread.Signal ();
		this->sync_got.Wait ();
		
		((EFSmsg*)(ptr))[0] = this->msg.data;
		
		struct {
			Card32		num;
			Card8*		bal[2];
		} bal;
		
		bal.num    = this->msg.bal.num_msg;
		bal.bal[0] = this->msg.bal.bal_0;
		bal.bal[1] = this->msg.bal.bal_1;
		
		this->bar.EndAccept (&bal);
	}
}

void
EFS::Thread (Card32 obj)
{
	volatile EFS* that = (EFS*)(obj);
	
	for (;;) {
		
		that->sync_thread.Wait ();
		
		if (that->do_stop) {
			that->sync_got.Signal ();
			break;
		}
		
		PCCommReq  req = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
		PCCommReq* req_ptr = & req;
		
		req.rdata     = (Card8*) & that->msg;
		req.sdata     = (const Card8*) & that->msg;
		req.rdata_len = sizeof (that->msg);
		req.sdata_len = sizeof (that->msg);
		req.pri       = 6;
		req.port_no   = 44;
		req.reply_sem = that->sync_sem.GetSem ();
		
//		AfText ("Request with reply_sem="); AfX8 ((Card32)(req.reply_sem)); AfCR ();
//		AfText ("Size of message is "); AfX8 (req.rdata_len); AfCR ();
		
		that->comm_bar.Offer ();
		that->comm_bar.EndOffer (req_ptr, req_ptr);
		
		that->sync_sem.Wait ();
		that->sync_got.Signal ();
	}
}

