/*
 *	efs.h
 *
 *	La classe EFS utilise par le serveur de fichiers gre la rception
 *	des paquets en provenance du pilote $XDRI et appelle les mthodes
 *	adquates.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */


#ifndef _EFS_H_
#define _EFS_H_

#pragma interface

#include <c++/portable.h>
#include <c++/ntrel.h>


enum EFSop
{
	EFS_MOUNT,			//	0
	EFS_UNMOUNT,
	EFS_OPEN,
	EFS_CREATE,
	EFS_DELETE,
	EFS_RENAME,
	EFS_MOVE,
	EFS_CHATR,
	EFS_IFOPEN,
	EFS_ARGS,
	EFS_CLEAR,			//	10
	EFS_DISK,
	EFS_CDIR,
	EFS_RDBYTE,			//	13
	EFS_WRBYTE,			//	14
	EFS_SETPOS,
	EFS_GETPOS,
	EFS_TRUNC,
	EFS_CLOSE,			//	18
	EFS_ENTER,
	EFS_RELEASE,
	EFS_LISTOPEN,
	EFS_LISTBUF,
	EFS_LISTCLOSE,
	EFS_REQUEST
};


struct EFSmsg
{
	Card32		 	instance;
	EFSop		 	op;
	Card32		 	c32[4];
	Int16		 	i16[4];
	Card16		 	c16[4];
	Card8*		 	p[4];
	const Card8* 	pc[4];
	const char*	 	name[4];
	char		 	errname[200];
};

struct EFSmsgBAL
{
	Card32			num_msg;
	Card8			bal_0[64];
	Card8			bal_1[64];
};

class EFS
{
	
protected:
	NtrBar			bar;						//	bar pour le dialogue avec le pilote $XDRI
	NtrBar			comm_bar;					//	bar pour le dialogue avec le PC
	NtrSync			sync_sem;
	NtrSync			sync_thread;
	NtrSync			sync_got;
	Bool			running;					//	TRUE => serveur en excution
	Bool			do_stop;
	
	struct {
		EFSmsg		data;
		EFSmsgBAL	bal;
	} msg;
	
	static void Thread (Card32 obj);
	
public:
	EFS ();
	virtual ~EFS ();
	
	virtual void StartServer (const char* xdri);
};


#endif

