
#ifndef _BIOS_DRIVER_H_
#define _BIOS_DRIVER_H_

#pragma interface

#include "portable.h"
#include "ntrel.h"

class EFS;

#define	MAXPORT		8
#define	MAXEFS		16

/*
 *	Segment rseau (pour une commande ou une tranche de
 *	donnes).
 */

struct NetSegment
{
	Card8*		address;			//	adresse du segment
	Card32		nanet;				//	rserv pour NANET
	Card16		length;				//	longueur du segment  crire/lu
	Card16		maximum;			//	longueur maximale du segment
};

struct NetBuffer
{
	Card16		count;				//	nombre de segments
	Card16		cmdid;				//	identificateur de commande
	NetSegment	segment[10];		//	segments
	Card8		buffer[1024];		//	tampon pour les donnes
	Bool		write_in_progress;	//	TRUE => write en cours
	Bool		write_has_occurred;	//	TRUE => write a eu lieu
	Card16		write_channel;		//	canal pour le write
	Card32		write_length;		//	taille prvue (total)
	Card8*		write_data;			//	donnes  crire
	EFS*		write_efs;			//	file system qui fait le write
};


/*
 *	Classe "pilote" pour laquelle il faut implmenter toutes les
 *	mthodes et dclarer les variables statiques.
 */

class BIOSBaseDriver
{
public:
	BIOSBaseDriver () {}
	virtual ~BIOSBaseDriver () {}
	virtual Int16 Open (Card16& port) = 0;
	virtual Int16 Command (const char* cmd) = 0;
	virtual Int16 ReadStatus (void* buffer, Card32 length) = 0;
	virtual Int16 ReadData (void* buffer, Card32 pos, Card32 length, Card32 net) = 0;
	virtual Int16 WriteData (const void* buffer, Card32 pos, Card32 length, Card32 net) = 0;
	virtual Int16 Close (Card16 port) = 0;
	virtual Int16 Stop () = 0;
	virtual Int16 Start () = 0;
	virtual Int16 Abort (Card16 port) = 0;
	virtual Int16 Aux1 (const char*, Card32& wr, const void*, Card32& rd, void*) = 0;
	virtual Int16 Aux2 (const char*, Card32& wr, const void*, Card32& rd, void*) = 0;
};

class BIOSDriver : public BIOSBaseDriver
{
	static const char*	driver_name;			//	nom du pilote (majuscules)
	static Card8		driver_attr;			//	attributs
	static Card8		driver_prio;			//	priorit
	static Card8		driver_type;			//	type du pilote
	static Card16		driver_base;			//	numro de base
	
private:
	NtrLock				port_lock;				//	verrou d'accs aux ports
	NetBuffer			command[MAXPORT];		//	commandes en attente
	Bool				is_open[MAXPORT];		//	ports ouverts (port 0 inutilis)
	EFS*				efs[MAXEFS];
	NtrLock				efs_lock[MAXEFS];
	
public:
	BIOSDriver (Int16& error, Card32 num);
	virtual ~ BIOSDriver ();
	
	virtual Int16 Open (Card16& port);
	virtual Int16 Command (const char* cmd);
	virtual Int16 ReadStatus (void* buffer, Card32 length);
	virtual Int16 ReadData (void* buffer, Card32 pos, Card32 length, Card32 net);
	virtual Int16 WriteData (const void* buffer, Card32 pos, Card32 length, Card32 net);
	virtual Int16 Close (Card16 port);
	virtual Int16 Stop ();
	virtual Int16 Start ();
	virtual Int16 Abort (Card16 port);
	virtual Int16 Aux1 (const char*, Card32& wr, const void*, Card32& rd, void*);
	virtual Int16 Aux2 (const char*, Card32& wr, const void*, Card32& rd, void*);
	
	void* operator new (long int size);
	void* operator new (long int size, Card32 type, Card32 desc);
	void  operator delete (void*);
	
	virtual void ParseCommand (const char* cmd, const char* arg, Card16 dest_id, Int16& err);
};


/*
 *	Types possibles pour le driver :
 */

#define	BIOS_TYPE_MM	1
#define	BIOS_TYPE_KEY	2
#define	BIOS_TYPE_DIS	3
#define	BIOS_TYPE_WDO	4
#define	BIOS_TYPE_IO	5
#define	BIOS_TYPE_PRI	6
#define	BIOS_TYPE_NETW	7
#define	BIOS_TYPE_STAT	8


/*
 *	Attributs pour le driver :
 */

#define	BIOS_ATTR_RDOK	0x01
#define	BIOS_ATTR_WROK	0x02
#define	BIOS_ATTR_NORT	0x04
#define	BIOS_ATTR_ALRT	0x08


/*
 *	Fonction utilise pour allouer une instance du pilote, en
 *	utilisant le compte pass en entre.
 */

extern Int16 new_bios_driver (Card32, Card32, BIOSDriver*&, Card32);

#endif

