/*
 *	efs.cc
 *
 *	Implmentation d'une interface de "srialisation" des requtes en
 *	paquets pour l'EFS connect  l'autre bout du BAR.
 *
 *	(C) Copyright 1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#pragma implementation "efs.h"

#include "portable.h"
#include "efs.h"
#include "ntrel.h"
#include "mon.h"

EFS::EFS (Card32 bar, Card32 instance)
{
	this->bar      = bar;
	this->instance = instance;
	
	this->msg.instance = this->instance;
	this->msg.op       = EFS_MOUNT;
	this->Dialog ();
}

EFS::~EFS ()
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_UNMOUNT;
	this->Dialog ();
}

void
EFS::Open (const char* name, Card32 mode, Card32 len, Card16& ch, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_OPEN;
	this->msg.c32[0]   = mode;
	this->msg.c32[1]   = len;
	this->msg.name[0]  = name;
	
	this->Dialog ();
	
	ch  = this->msg.c16[0];
	err = this->msg.i16[0];
}

void
EFS::Create (const char* name, Card32 attr, Card16 type, Card16 cod, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_CREATE;
	this->msg.c32[0]   = attr;
	this->msg.c16[0]   = cod;
	this->msg.name[0]  = name;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::Delete (const char* name, Card32 mode, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_DELETE;
	this->msg.c32[0]   = mode;
	this->msg.name[0]  = name;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::Rename (const char* names, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_RENAME;
	this->msg.name[0]  = names; while (*names++);
	this->msg.name[1]  = names;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::Move (const char* names, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_MOVE;
	this->msg.name[0]  = names; while (*names++);
	this->msg.name[1]  = names;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::Chatr (const char* name, Card32 attr, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_CHATR;
	this->msg.c32[0]   = attr;
	this->msg.name[0]  = name;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::IfOpen (const char* name, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_IFOPEN;
	this->msg.name[0]  = name;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::Args (const char* name, Card16 mode, Card8* args, Card16& count, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_ARGS;
	this->msg.name[0]  = name;
	this->msg.c16[0]   = mode;
	this->msg.p[0]     = args;
	
	this->Dialog ();
	
	count = this->msg.c16[1];
	err   = this->msg.i16[0];
}

void
EFS::Clear (const char* name, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_CLEAR;
	this->msg.name[0]  = name;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::Disk (const char* name, Card32& free, Card32& used, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_DISK;
	this->msg.name[0]  = name;
	
	this->Dialog ();
	
	free = this->msg.c32[0];
	used = this->msg.c32[1];
	err  = this->msg.i16[0];
}

void
EFS::CDir (const char* name, Card32 hash, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_CDIR;
	this->msg.name[0]  = name;
	this->msg.c32[0]   = hash;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::RdByte (Card16 ch, Card32& len, Card8* data, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_RDBYTE;
	this->msg.c16[0]   = ch;
	this->msg.c32[0]   = len;
	this->msg.p[0]     = data;
	
	this->Dialog ();
	
	len = this->msg.c32[0];
	err = this->msg.i16[0];
}

void
EFS::WrByte (Card16 ch, Card32& len, const Card8* data, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_WRBYTE;
	this->msg.c16[0]   = ch;
	this->msg.c32[0]   = len;
	this->msg.pc[0]    = data;
	
	this->Dialog ();
	
	len = this->msg.c32[0];
	err = this->msg.i16[0];
}

void
EFS::SetPos (Card16 ch, Card32& poslow, Card8& poshigh, Card16 mode, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_SETPOS;
	this->msg.c16[0]   = ch;
	this->msg.c16[1]   = mode;
	this->msg.c32[0]   = poslow;
	this->msg.c32[1]   = poshigh;
	
	this->Dialog ();
	
	poslow  = this->msg.c32[0];
	poshigh = this->msg.c32[1];
	err     = this->msg.i16[0];
}

void
EFS::GetPos (Card16 ch, Card32& poslow, Card8& poshigh, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_GETPOS;
	this->msg.c16[0]   = ch;
	
	this->Dialog ();
	
	poslow  = this->msg.c32[0];
	poshigh = this->msg.c32[1];
	err     = this->msg.i16[0];
}

void
EFS::Trunc (Card16 ch, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_TRUNC;
	this->msg.c16[0]   = ch;
	
	this->Dialog ();
	
	err     = this->msg.i16[0];
}

void
EFS::Close (Card16 ch, Card32 h, Card32 d, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_CLOSE;
	this->msg.c16[0]   = ch;
	this->msg.c32[0]   = h;
	this->msg.c32[1]   = d;
	
	this->Dialog ();
	
	err     = this->msg.i16[0];
}

void
EFS::Enter (const char* name, Card16 mode, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_ENTER;
	this->msg.name[0]  = name;
	this->msg.c16[0]   = mode;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::Release (const char* name, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_RELEASE;
	this->msg.name[0]  = name;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::ListOpen (const char* names, Card32 mode, Card32& ch, Card16& num, Card32& id, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_LISTOPEN;
	this->msg.name[0]  = names; while (*names++);
	this->msg.name[1]  = names;
	this->msg.c32[0]   = mode;
	
	this->Dialog ();
	
	ch  = this->msg.c32[1];
	num = this->msg.c32[2];
	id  = this->msg.c32[3];
	err = this->msg.i16[0];
}

void
EFS::ListBuf (Card32 ch, Card32& len, Card8* buf, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_LISTBUF;
	this->msg.c32[0]   = ch;
	this->msg.c32[1]   = len;
	this->msg.p[0]     = buf;
	
	this->Dialog ();
	
	len = this->msg.c32[1];
	err = this->msg.i16[0];
}

void
EFS::ListClose (Card32 ch, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_LISTCLOSE;
	this->msg.c32[0]   = ch;
	
	this->Dialog ();
	
	err = this->msg.i16[0];
}

void
EFS::Mount ()
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_MOUNT;
	this->Dialog ();
}


void
EFS::Unmount ()
{
	this->msg.instance = this->instance;
	this->msg.op       = EFS_UNMOUNT;
	this->Dialog ();
}


void
EFS::Request (const char* arg, Int16& err)
{
	this->msg.instance = this->instance;
	this->msg.name[0]  = arg;
	this->msg.op       = EFS_REQUEST;
	this->Dialog ();
	err = this->msg.i16[0];
}


void
EFS::Dialog ()
{
	NtrBar bar (this->bar);
	Card16 tim = Ntr::GetTim ();
	
	bar.Offer ();
	
	if (bar.GetError ()) {
		this->msg.i16[0] = (Int16)(bar.GetError ());
		return;
	}
	
	Ntr::SetTim (0xFFFF);
	
	void* in  = & this->msg;
	void* out = 0;
	
	bar.EndOffer (in, out);
	
	if (out && (out != in)) {
		Card32* pout = (Card32*)(out);
		Card32  len  = *pout++;
		if (len <= 2) {
			this->num_bal_msg = len;
			if (len >= 1) memcpy (this->buf_bal_msg+0,  (const char*)(*pout++), 64);
			if (len >= 2) memcpy (this->buf_bal_msg+64, (const char*)(*pout++), 64);
		}
	}
	
	Ntr::SetTim (tim);
}


void
EFS::ReportBALMessage (Card8* buf, Card16& length)
{
	length = 64 * this->num_bal_msg;
	
	if (length) {
		memcpy (buf, this->buf_bal_msg, length);
	}
}


