
#ifndef _EFS_H_
#define _EFS_H_

#pragma interface

enum EFSop
{
	EFS_MOUNT,
	EFS_UNMOUNT,
	EFS_OPEN,
	EFS_CREATE,
	EFS_DELETE,
	EFS_RENAME,
	EFS_MOVE,
	EFS_CHATR,
	EFS_IFOPEN,
	EFS_ARGS,
	EFS_CLEAR,
	EFS_DISK,
	EFS_CDIR,
	EFS_RDBYTE,
	EFS_WRBYTE,
	EFS_SETPOS,
	EFS_GETPOS,
	EFS_TRUNC,
	EFS_CLOSE,
	EFS_ENTER,
	EFS_RELEASE,
	EFS_LISTOPEN,
	EFS_LISTBUF,
	EFS_LISTCLOSE,
	EFS_REQUEST
};


struct EFSmsg
{
	Card32		 instance;
	EFSop		 op;
	Card32		 c32[4];
	Int16		 i16[4];
	Card16		 c16[4];
	Card8*		 p[4];
	const Card8* pc[4];
	const char*	 name[4];
	char		 errname[200];
};


class EFS
{
	
protected:
	Card32		bar;
	Card32		instance;
	EFSmsg		msg;
	
	char		buf_bal_msg[64*2];
	int			num_bal_msg;
	
	void Dialog ();
	
public:
	EFS (Card32 bar, Card32 instance);
	~EFS ();
	
	void Open (const char* name, Card32 mode, Card32 len, Card16& ch, Int16& err);
	void Create (const char* name, Card32 attr, Card16 type, Card16 cod, Int16& err);
	void Delete (const char* name, Card32 mode, Int16& err);
	void Rename (const char* names, Int16& err);
	void Move (const char* names, Int16& err);
	void Chatr (const char* name, Card32 attr, Int16& err);
	void IfOpen (const char* name, Int16& err);
	void Args (const char* name, Card16 mode, Card8* args, Card16& count, Int16& err);
	void Clear (const char* name, Int16& err);
	void Disk (const char* name, Card32& free, Card32& used, Int16& err);
	void CDir (const char* name, Card32 hash, Int16& err);
	void RdByte (Card16 ch, Card32& len, Card8* data, Int16& err);
	void WrByte (Card16 ch, Card32& len, const Card8* data, Int16& err);
	void SetPos (Card16 ch, Card32& poslow, Card8& poshigh, Card16 mode, Int16& err);
	void GetPos (Card16 ch, Card32& poslow, Card8& poshigh, Int16& err);
	void Trunc (Card16 ch, Int16& err);
	void Close (Card16 ch, Card32 h, Card32 d, Int16& err);
	
	void Enter (const char* name, Card16 mode, Int16& err);
	void Release (const char* name, Int16& err);
	
	void ListOpen (const char* names, Card32 mode, Card32& ch, Card16& num, Card32& id,
						   Int16& err);
	void ListBuf (Card32 ch, Card32& len, Card8* buf, Int16& err);
	void ListClose (Card32 ch, Int16& err);
	
	void Mount ();
	void Unmount ();
	void Request (const char* arg, Int16& err);
	
	void ClearBALMessage ()		{ this->num_bal_msg = 0; }
	void ReportBALMessage (Card8* buf, Card16& length);
};


#endif

