
#pragma implementation "fatdisk.h"

#include "fatdisk.h"
#include <stdio.h>

FATDisk::FATDisk ()
{
	this->num_clus		= 0;
	this->num_fat		= 0;
	this->clus_size		= 0;
	this->fat_buf		= 0;
	this->fat_start		= 0;
	this->fat_len		= 0;
	this->fat_bits		= 0;
	this->fat_error		= 0;
	this->fat_last		= 0;
	this->fat_end		= 0;
	this->dir_buf		= 0;
	this->dir_start		= 0;
	this->dir_len		= 0;
	this->dir_dirty		= FALSE;
	this->dir_entries	= 0;
	this->disk_buf		= 0;
	this->disk_size		= 0;
	this->disk_offset	= 0;
	this->disk_current	= 0;
	this->disk_dirty	= FALSE;
	this->volname[0]	= 0;
	this->lastpath[0]	= 0;
	this->channel		= 0;
	this->abs_drive		= FALSE;
}


FATDisk::~FATDisk ()
{
	if (this->channel) {
		this->FlushDir ();
		this->FlushDisk ();
		this->CloseDevice ();
	}
}


/*
 *	Get the amount of free space on the media.
 */

Card32
FATDisk::GetFree()
{
	Card32 total = 0;
	Card32 index = 2;
	
	for (; index < this->num_clus + 2; index++) {
		if (this->DecodeFAT (index) == 0) total += this->clus_size;
	}
	
	return total;
}



/*
 *	Convert an MSDOS directory date stamp to some
 *	more intelligible format.
 */

void
FATDisk::ConvDate (Card32 date_high, Card32 date_low, FATDateTime& date)
{
	/*
	 *          hi byte     |    low byte
	 *      |7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|
	 *      | | | | | | | | | | | | | | | | |
	 *      \   7 bits    /\4 bits/\ 5 bits /
	 *         year +80      month     day
	 */
	
	Card8 year      = (date_high >> 1) + 80;
	Card8 month_hi  = (date_high & 0x01) << 3;
	Card8 month_low = date_low >> 5;
	Card8 day       = date_low & 0x1F;
	
	date.year  = year;
	date.month = month_hi + month_low;
	date.day   = day;
}

/*
 *	Convert an MSDOS directory time stamp to some more
 *	intelligible format.
 */

void
FATDisk::ConvTime (Card32 time_high, Card32 time_low, FATDateTime& date)
{
	/*
	 *          hi byte     |    low byte
	 *      |7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|
	 *      | | | | | | | | | | | | | | | | |
	 *      \  5 bits /\  6 bits  /\ 5 bits /
	 *         hour      minutes     sec*2
	 */
	
	Card8 hour    = time_high >> 3;
	Card8 min_hi  = (time_high & 0x7) << 3;
	Card8 min_low = time_low >> 5;
	
	date.hour   = (hour == 0) ? 12 : hour;
	date.minute = min_hi + min_low;
	date.second = 0;
}


void
error (const char* error)
{
	fprintf (stderr, error);
}


