/*
 *	fatbufread.cc
 *
 *	Do full cylinder buffered reads from slow devices.  Uses a simple
 *	buffered read/delayed write algorithm.
 *
 *	(C) Copyright 1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "fatdisk.h"

void
FATDisk::ReadDisk (Card32 start, Card8* buf, Card32 len)
{
	Card32 i;
	Card32 length;
	Card8* buf_ptr;
	Card8* disk_ptr;
	
	Card32 where = 0;
	Card32 tail  = 0;
	
	//	Don't use cache ?
	
	if (this->disk_size == 1) {
		
		where = (start * MSECTOR_SIZE) + this->disk_offset;
		
		this->SeekDevice (where);
		this->ReadDevice (buf, len);
		
		return;
	}
	
	tail = start + (len / MSECTOR_SIZE) - 1;
	
	for (i = start; i <= tail; i++) {
		
		//	A "cache" miss :
		
		if ( (i < this->disk_current)
		  || (i >= (this->disk_current + this->disk_size)) ) {
			
			if (this->disk_dirty) this->FlushDisk ();
			
			this->disk_current = (i / this->disk_size) * this->disk_size;
			
			where  = (this->disk_current * MSECTOR_SIZE) + this->disk_offset;
			length = this->disk_size * MSECTOR_SIZE;
			
			//	Move to next location
			
			this->SeekDevice (where);
			this->ReadDevice (this->disk_buf, length);
		}
		
		//	A cache hit...
		
		buf_ptr  = buf + ((i - start) * MSECTOR_SIZE);
		disk_ptr = this->disk_buf + ((i - this->disk_current) * MSECTOR_SIZE);
		
		memcpy (buf_ptr, disk_ptr, MSECTOR_SIZE);
	}
}


