/*
 *	fatdirread.cc
 *
 *	(C) Copyright 1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "fatdisk.h"

#include <string.h>


/*
 *	Read a directory entry into the temporary directory
 *	structure.
 */

void
FATDisk::ReadDir (Card32 num)
{
	Card8* offset = this->dir_buf + (num * MDIR_SIZE);
	memcpy (& this->dir_temp, offset, MDIR_SIZE);
}


/*
 *	Fill in the global variable dir_chain[].  Argument is
 *	the starting cluster number.
 */

Int16
FATDisk::FillChain (Card32 num)
{
	Card32 length = 0;
	Card32 next   = 0;
	Card8* offset = 0;
	
	for (;;) {
		
		this->dir_chain[length] = (num-2) * this->clus_size + this->dir_start + this->dir_len;
		length++;
		
		//	Sectors, not clusters !
		
		for (int i = 1; i < this->clus_size; i++) {
			this->dir_chain[length] = this->dir_chain[length - 1] + 1;
			length++;
		}
		
		if (length >= MAX_DIR_SECS) {
			
			error ("fill_chain: directory too large\n");
			return -1;
		}
		
		//	Get next cluster number
		
		next = this->DecodeFAT (num);
		
		if (next == 1) {
			
			error ("fill_chain: FAT problem\n");
			this->fat_error++;
			return -1;
		}
		
		//	End of cluster chain
		
		if (next >= this->fat_last) break;
		num = next;
	}
	
	if (this->dir_dirty) this->FlushDir ();
	
	this->ResizeDir (length * MSECTOR_SIZE);

	for (int i = 0; i < length; i++) {
		offset = dir_buf + (i * MSECTOR_SIZE);
		this->ReadDisk (dir_chain[i], offset, MSECTOR_SIZE);
	}

	this->dir_entries = length * 16;
	return 0;
}


void
FATDisk::ResizeDir (Card32 size)
{
	Card8* old_buf = this->dir_buf;
	Card8* new_buf = new Card8[size];
	
	if (new_buf == 0) {
		error ("fill_chain: not enough memory\n");
		exit (1);
	}
	
	if (old_buf) {
		memcpy (new_buf, old_buf, size);
		delete old_buf;
	}
	
	this->dir_buf = new_buf;
}

/*
 *	Reset the global variable dir_chain[] to the root
 *	directory.
 */

void
FATDisk::ResetChain ()
{
	if (this->dir_dirty) this->FlushDir ();
	
	for (int i = 0; i < dir_len; i++) {
		dir_chain[i] = this->dir_start + i;
	}
	
	this->ResizeDir (this->dir_len * MSECTOR_SIZE);
	this->ReadDisk (this->dir_start, this->dir_buf, this->dir_len * MSECTOR_SIZE);
	
	this->dir_entries = this->dir_len * 16;
}


/*
 *	Get rid of spaces in an MSDOS 'raw' name (one that has come from the
 *	directory structure) so that it can be used for regular expression
 *	matching with a unix filename.  Also used to 'unfix' a name that has
 *	been altered by DosName ().
 */

void
FATDisk::UnixName (char* buffer, const char* name, const char* ext)
{
	char* s;
	char  t_name[9];
	char  t_ext[4];
	
	strncpy (t_name, name, 8);
	t_name[8] = '\0';
	
	if (s = strchr (t_name, ' ')) { *s = '\0'; }

	strncpy (t_ext, ext, 3);
	t_ext[3] = '\0';
	
	if (s = strchr (t_ext, ' ')) { *s = '\0'; }
	
	if (t_ext[0]) {
		strcpy (buffer, t_name);
		strcat (buffer, ".");
		strcat (buffer, t_ext);
	} else {
		strcpy (buffer, t_name);
	}
}


