
#ifndef _FATDISK_H_
#define _FATDISK_H_

#pragma interface

#include "portable.h"
#include "msdos.h"

class FatEFS;

struct FATDateTime
{
	Card8	day,  month,  year;
	Card8	hour, minute, second;
};

class FATDisk
{
	friend FatEFS;
	
	Card32			num_clus;					//	total number of cluster
	Card32			num_fat;					//	number of FAT tables
	
	Card32			clus_size;					//	cluster size (in sectors)
	
	Card8*			fat_buf;
	Card32			fat_start;					//	FAT start (in sectors)
	Card32			fat_len;					//	FAT length (in sectors)
	Card32			fat_bits;					//	FAT encoding scheme
	Card32			fat_error;					//	FAT error count
	Card32			fat_last;					//	
	Card32			fat_end;					//	
	
	Card8*			dir_buf;					//
	Card32			dir_start;					//	start of directory (in sectors)
	Card32			dir_len;					//	length of directory (in sectors)
	Bool			dir_dirty;					//	
	Card32			dir_chain[MAX_DIR_SECS];	//	chain of sectors in directory
	Card32			dir_entries;				//	
	FATDirectory	dir_temp;					//	temporary storage for a directory
	
	FATBootSector	boot_sector;				//	boot sector
	
	Card8*			disk_buf;					//	disk read/write buffer
	Card32			disk_size;					//	size of read/write buffer
	Card32			disk_offset;				//	offset from start of disk
	Int32			disk_current;				//	first sector in buffer
	Bool			disk_dirty;					//	
	
	char			volname[16];				//	volume name
	
	char			lastpath[MAX_PATH];			//	last path name
	
	Card16			channel;					//	file descriptor of device
	Bool			abs_drive;					//	TRUE => drive supports absolute addressing
	
protected:
	Int16 ReadBootSector ();

	Int16 OpenDevice (const char* name, const char* cmd);
	Int16 WriteDevice (const void* data, Card32 len);
	Int16 ReadDevice (void* data, Card32 len);
	Int16 SeekDevice (Card32 pos);
	Int16 CloseDevice ();
	
	void FreeBuffers ();
	
public:
	Int16 Init (char drive);
	
	void ReadDir (Card32 num);
	void WriteDir (Card32 num, const FATDirectory* dir);
	void FlushDir ();
	void ResizeDir (Card32 size);
	
	void  ResetChain ();
	Int16 FillChain (Card32 num);
	Int16 SubDir (const char* path);
	Int16 DescendDir (const char* path);
	
	void ReadDisk (Card32 pos, Card8* data, Card32 len);
	void WriteDisk (Card32 pos, const Card8* data, Card32 len);
	void FlushDisk ();
	Bool ReadDiskCyl (Card32 cyl);
	
	Card32 DecodeFAT (Card32 num);
	Int16  EncodeFAT (Card32 num, Card32 code);
	void   ReadFAT ();
	void   WriteFAT ();
	
	Int16 FindFile (const char* name, FATDirectory& dir);
	Int16 ReadFile (Card32 fat, Card32 file_size, Card8* data, Card32 pos, Card32 len);
	
	void UnixName (char* buffer, const char* name, const char* ext);
	Bool MatchName (const char*, const char*);
	void ConvDate (Card32 date_high, Card32 date_low, FATDateTime& date);
	void ConvTime (Card32 time_high, Card32 time_low, FATDateTime& time);
	
public:
	FATDisk ();
	~FATDisk ();
	
	Card32 GetFree ();
};



#endif

