/*
 *	fatefs.h
 *
 *	La classe "FatEFS" correspond  l'implmentation d'un EFS permettant
 *	la lecture de volumes FAT 12 et 16-bit.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#ifndef _FATEFS_H_
#define _FATEFS_H_

#pragma interface

#include "efs.h"
#include "fatdisk.h"

#define	FATMAXELEM	64
#define	FATMAXCHAN	64


class FatEFS : public EFS
{
	
protected:
	
	struct FatElemOne
	{
		char			name[20];			//	nom du fichier
		Card8			date[6];			//	date + heure de cration
		Card8			flags;				//	attributs  la DOS
		Card32			size;				//	taille du fichier
	};
	
	struct FatElemTable
	{
		FatElemTable*	next;				//	pointeur  la table suivante
		Card32			used;				//	nombre d'lments dans la table
		FatElemOne		elem[FATMAXELEM];	//	table d'lments
		
		FatElemTable ()			{ next = 0; used = 0; }
		~FatElemTable ()		{ if (next) delete next; }
	};
	
	struct FatList
	{
		Card32			num;				//	nombre total d'lments
		Card32			index;				//	index pour la lecture
		FatElemTable*	table;				//	liste de tables d'lments
		Bool			b_dossier;			//	transforme "xxx.DIR" en "xxx:"
		
		FatList ()				{ num = 0; index = 0; table = 0; }
		~FatList ()				{ if (table) delete table; }
		FatElemOne* Insert ();
		FatElemOne* GetNext ();
	};
	
	struct FatChannel
	{
		Bool			used;				//	TRUE => canal utilis
		char			name[200];			//	nom du fichier
		Card32			cluster;			//	premier cluster
		Card32			max_pos;			//	position maximale possible
		Card32			cur_pos;			//	position donne avec ?SPOS
	};
	
protected:
	Bool				enter_ok;			//	TRUE => enter effectu au moins une fois
	FatChannel			chan[FATMAXCHAN];	//	canaux
	Card32				open;				//	nombre d'ouvertures
	FATDisk*			media;				//	pointeur  l'interface FAT
	
	virtual Bool JustEnter (Int16& err);
	
public:
	FatEFS ();
	virtual ~FatEFS ();
	
	virtual void Open (const char* name, Card32 mode, Card32 len, Card16& ch, Int16& err);
	virtual void Create (const char* name, Card32 attr, Int16& err);
	virtual void Delete (const char* name, Card32 mode, Int16& err);
	virtual void Rename (const char* name_src, const char* name_dst, Int16& err);
	virtual void Move (const char* name_src, const char* name_dst, Int16& err);
	virtual void Chatr (const char* name, Card32 attr, Int16& err);
	virtual void IfOpen (const char* name, Int16& err);
	virtual void Args (const char* name, Card16 mode, Card8* args, Card16& count, Int16& err);
	virtual void Clear (const char* name, Int16& err);
	virtual void Disk (const char* name, Card32& free, Card32& used, Int16& err);
	virtual void CDir (const char* name, Int16& err);
	virtual void RdByte (Card16 ch, Card32& len, Card8* data, Int16& err);
	virtual void WrByte (Card16 ch, Card32& len, const Card8* data, Int16& err);
	virtual void SetPos (Card16 ch, Card32& poslow, Card32& poshigh, Card16 mode, Int16& err);
	virtual void GetPos (Card16 ch, Card32& poslow, Card32& poshigh, Int16& err);
	virtual void Trunc (Card16 ch, Int16& err);
	virtual void Close (Card16 ch, Card32 h, Card32 d, Int16& err);
	
	virtual void Enter (const char* name, Card16 mode, Int16& err);
	virtual void Release (const char* name, Int16& err);
	
	virtual void ListOpen (const char* dir, const char* crit, Card32 mode, Card32& ch, Card32& num, Card32& id, Int16& err);
	virtual void ListBuf (Card32 ch, Card32& len, Card8* buf, Int16& err);
	virtual void ListClose (Card32 ch, Int16& err);
	
	virtual void Mount ();
	virtual void Unmount ();
	virtual void Request (const char* arg, Int16& err);
};


#endif

