/*
 *	fatfatwrite.cc
 *
 *	(C) Copyright 1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "fatdisk.h"



/*
 *	Puts a code into the FAT table. It is the opposite of DecodeFAT.
 *	No sanity checking is done on the code. Returns a 1 on error.
 */

Int16
FATDisk::EncodeFAT (Card32 num, Card32 code)
{
	Card32 start;

	if (this->fat_bits == 12) {
		
		/*
		 *	|    byte n     |   byte n+1    |   byte n+2    |
		 *	|7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|
		 *	| | | | | | | | | | | | | | | | | | | | | | | | |
		 *	| n+0.0 | n+0.5 | n+1.0 | n+1.5 | n+2.0 | n+2.5 |
		 *	    \_____  \____   \______/________/_____   /
		 *	      ____\______\________/   _____/  ____\_/
		 *	     /     \      \          /       /     \
		 *	| n+1.5 | n+0.0 | n+0.5 | n+2.0 | n+2.5 | n+1.0 |
		 *	|      FAT entry k      |    FAT entry k+1      |
		 */
		
		start = num * 3 / 2;
		
		if ( (start <= 2)
		  || ((start + 1) > (this->fat_len * MSECTOR_SIZE)) ) {
			return 1;
		}

		if (num % 2) {
			*(this->fat_buf + start)     = (*(this->fat_buf + start) & 0x0f) + ((code << 4) & 0xf0);
			*(this->fat_buf + start + 1) = (code >> 4) & 0xff;
		} else {
			*(this->fat_buf + start)     = code & 0xff;
			*(this->fat_buf + start + 1) = (*(this->fat_buf + start + 1) & 0xf0) + ((code >> 8) & 0x0f);
		}
		
	} else {
		
		/*
		 *	|    byte n     |   byte n+1    |
		 *	|7|6|5|4|3|2|1|0|7|6|5|4|3|2|1|0|
		 *	| | | | | | | | | | | | | | | | |
		 *	|         FAT entry k           |
		 */
		
		start = num * 2;

		if ( (start <= 2)
		  || ((start + 1) > (this->fat_len * MSECTOR_SIZE)) ) {
			return 1;
		}
		
		*(this->fat_buf + start + 1) =  code / 0x100;
		*(this->fat_buf + start)     =  code % 0x100;
	}
	
	return 0;
}


/*
 *	Write the FAT table to the disk. Up to now the FAT manipulation has
 *	been done in memory. All errors are fatal. (Might not be too smart
 *	to wait till the end of the program to write the table. Oh well...)
 */

void
FATDisk::WriteFAT ()
{
	Card32 start = this->dir_start - (this->fat_len * this->num_fat);
	Card32 i     = 0;
	
	for (i = start; i < start+this->fat_len; i++) {
		this->WriteDisk (i, this->fat_buf + (i-start)*MSECTOR_SIZE, MSECTOR_SIZE);
	}
	
	//	Only duplicate the FAT table if no errors were detected...
	
	if (this->fat_error == 0) {
		Card32 dups = this->num_fat;
		while (--dups) {
			start += this->fat_len;
			for (i = start; i < start+this->fat_len; i++) {
				this->WriteDisk (i, this->fat_buf + (i-start)*MSECTOR_SIZE, MSECTOR_SIZE);
			}
		}
	}
}


