/*
 *	fatfilefind.cc
 *
 *	Walk through directory structures and find the specified
 *	file.
 *
 *	(C) Copyright 1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "fatdisk.h"


Int16
FATDisk::FindFile (const char* file, FATDirectory& dir)
{
	char  buffer[MAX_PATH];
	char* ptr;
	char* end;
	char* last;
	
	if (file[0] == 0) {
		return 0x8503;				//	"nom de fichier attendu"
	}
	
	strcpy (buffer+1, file);
	ptr = end = last = buffer+1;
	
	//	Find pointer to the last character (just before terminal 0) and the
	//	pointer to the end of the directory name.
	
	while (last[1]) {
		last++;
	}
	
	if (last[0] == ':') {
		return 0x8503;				//	"nom de fichier attendu"
	}
	
	while (*ptr) {
		if (*ptr++ == ':') end = ptr;
	}
	
	end[-1] = 0;					//	produces "dir<0>file"
	
	const char* dir_name  = buffer+1;
	const char* file_name = dir_name; while (*file_name++);
	
	if (file_name[0] == 0) {
		file_name = dir_name;
		dir_name  = "";
	}
	
	Int16 err = this->SubDir (dir_name);
	if (err) return err;
	
	for (Card32 entry = 0; entry < this->dir_entries; entry++) {
		
		this->ReadDir (entry);
		
		if (this->dir_temp.name[0] == 0x00) break;
		if (this->dir_temp.name[0] == 0xE5) continue;
		if (this->dir_temp.name[0] == 0x2E) continue;
		if (this->dir_temp.attr & 0xD0) continue;
		
		char newname[16];
		
		this->UnixName (newname, this->dir_temp.name, this->dir_temp.ext);
		
		if (strcmp (file_name, newname) == 0) {
			dir = this->dir_temp;
			return 0;
		}
	}
	
	return 0x8512;					//	"fichier n'existe pas"
}

