/*
 *	fatfileread.cc
 *
 *	Read data from a file.
 *
 *	(C) Copyright 1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "fatdisk.h"

/*
 *	Read the clusters given the beginning FAT entry. Returns 0
 *	on success.
 */

Int16
FATDisk::ReadFile (Card32 fat, Card32 file_size, Card8* data, Card32 pos, Card32 len)
{
	Card8  buffer[MAX_CLUSTER];
	Card32 current = 0;
	Card32 length  = this->clus_size * MSECTOR_SIZE;
	
	//	Zero length file ?
	
	if (fat == 0) return 0;
	
	for (;;) {
		
		Card32 start    = (fat-2) * this->clus_size + this->dir_start + this->dir_len;
		Card32 real_len = (current + length) > file_size ? (file_size - current) : length;
		
		//	Is the current slice of any interest to the reader ? Is so do the
		//	read operation. Otherwise just look for the next piece of data.
		
		if ((current + real_len) >= pos) {
			
			this->ReadDisk (start, buffer, length);
			
			Card8* src  = (current < pos) ? (buffer + pos - current) : (buffer);
			Card32 num  = (current < pos) ? (real_len - pos + current) : (real_len);
			Card32 copy = (num < len) ? (num) : (len);
			
			len -= copy;
			pos += copy;
			
			while (copy--) *data++ = *src++;
			
			if (len == 0) {
				return 0;
			}
		}
		
		current += length;
		
		if (current >= file_size) break;
		if (current >= pos + len) break;
		
		//	Get next cluster number
		
		fat = this->DecodeFAT (fat);
		
		if (fat == 1) {
			fat_error++;
			return 0x8511;				//	"hors du fichier"
		}
		
		//	End of cluster chain ?
		
		if (fat >= this->fat_last) break;
	}
	
	return 0;
}


