/*
 *	fatio.cc
 *
 *	Low-level read/write on a Smaky computer. Allows direct access
 *	to floppy drive on a block per block basis.
 *
 *	(C) Copyright 1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "fatdisk.h"

#define	FOS_OPEXCL		0x00000001
#define	FOS_OPRD		0x00000002
#define	FOS_OPWR		0x00000004
#define	FOS_OPEXTEND	0x00000008
#define	FOS_OPMMUNIT	0x00100000

Int16
FATDisk::OpenDevice (const char* name, const char* command)
{
	Bool   smart_drive = TRUE;
	Card8  buffer[256];
	Card8* bufptr = buffer;
	
	if (this->channel) {
		return 0x0000;
	}
	
	Card32 mode    = FOS_OPMMUNIT | FOS_OPEXTEND | FOS_OPEXCL | FOS_OPWR | FOS_OPRD;
	Card16 channel = 0x0000;
	Int16  error   = 0x0000;
	
	asm volatile ( "movel %2,d3\n\t"
				   "movel %3,a3\n\t"
				   ".long 0x4E45004A\n\t"			//	FOS ?ARGSOPEN
				   "movew d6,%1\n\t"
				   "movew d7,%0\n\t"
				 : "=g" (error), "=g" (channel)
				 : "g" (mode), "g" (name)
				 : "d3", "d6", "d7", "a3" );
	
	if (error) {
		return error;
	}
	
	asm volatile ( "moveq #0x40,d3\n\t"
				   "moveq #0x00,d4\n\t"
				   "movew %1,d6\n\t"
				   ".long 0x4e450004\n\t"			//	FOS ?SPOS
				   "movew  d7,%0"
				 : "=g" (error)
				 : "g" (channel)
				 : "d3", "d4", "d6", "d7" );
	
	if (error) smart_drive = FALSE;
	
	asm volatile ( "movel #256,d4\n\t"
				   "movel %2,a4\n\t"
				   "movew %1,d6\n\t"
				   ".long 0x4e450001\n\t"			//	FOS ?RDBYTE
				   "movew d7,%0"
				 : "=g" (error)
				 : "g" (channel), "g" (bufptr)
				 : "d4", "d6", "d7", "a4" );
	
	if (error) smart_drive = FALSE;
	
	//	A "smart drive" supports absolute block addressing, which is
	//	quite fun, since it needs no stupid block address translation.
	
	if (command == 0) {
		this->channel   = channel;
		this->abs_drive = smart_drive;
		return 0;
	}
	
	asm volatile ( "movel %1,a4\n\t"
				   "movew %2,d6\n\t"
				   ".long 0x4E45001D\n\t"			//	FOS ?COMMAND
				   "movew d7,%0"
				 : "=g" (error)
				 : "g" (command), "g" (channel)
				 : "d6", "d7", "a4" );
	
	if (error) {
		
		asm volatile ( "movew %0,d6\n\t"
					   ".long 0x4E450005"			//	FOS ?CLOSE
					 :
					 : "g" (channel)
					 : "d6", "d7" );
		
		return error;
	}
	
	this->channel   = channel;
	this->abs_drive = smart_drive;
	
	return 0x0000;
}


Int16
FATDisk::CloseDevice ()
{
	if (this->channel) {
		asm volatile ( "movew %0,d6\n\t"
					   ".long 0x4E450005"			//	FOS ?CLOSE
					 :
					 : "g" (this->channel)
					 : "d6", "d7" );
	}
	
	this->channel = 0;
	
	return 0x0000;
}


Int16
FATDisk::SeekDevice (Card32 pos)
{
	Card32 blockhigh   = 0;
	Card32 blocklow    = pos & 0xffffff00;
	Card32 blockoffset = pos & 0xff;
	Card16 error;
	
	if (blockoffset) {
		return 1;
	}
	
	if (this->abs_drive) {
		blockhigh = 0x40;							//	use physical block addressing !
	} else {
		blockhigh = (blocklow < 16*256) ? 0xff : 0x00;
		blocklow -= 16*256;
	}
	
	asm volatile ( "movel %3,d3\n\t"
				   "movel %2,d4\n\t"
				   "movew %1,d6\n\t"
				   ".long 0x4e450004\n\t"			//	FOS ?SPOS
				   "movew  d7,%0"
				 : "=g" (error)
				 : "g" (this->channel), "g" (blocklow), "g" (blockhigh)
				 : "d3", "d4", "d6", "d7" );
	
	return error;
}


Int16
FATDisk::WriteDevice (const void* data, Card32 length)
{
	Card16 error = 0x0000;
	
	asm volatile ( "movel %3,d4\n\t"
				   "movel %2,a4\n\t"
				   "movew %1,d6\n\t"
				   ".long 0x4e450002\n\t"			//	FOS ?WRBYTE
				   "movew d7,%0"
				 : "=g" (error)
				 : "g" (this->channel), "g" (data), "g" (length)
				 : "d4", "d6", "d7", "a4" );
	
	return error;
}


Int16
FATDisk::ReadDevice (void* data, Card32 length)
{
	Card16 error = 0x0000;
	
	asm volatile ( "movel %3,d4\n\t"
				   "movel %2,a4\n\t"
				   "movew %1,d6\n\t"
				   ".long 0x4e450001\n\t"			//	FOS ?RDBYTE
				   "movew d7,%0"
				 : "=g" (error)
				 : "g" (this->channel), "g" (data), "g" (length)
				 : "d4", "d6", "d7", "a4" );
	
	return error;
}

