
#include "fatdisk.h"

/*
 * Do shell-style pattern matching for '?', '\', '[..]', and '*' wildcards.
 * Returns TRUE if match, FALSE if not.
 */

Bool
FATDisk::MatchName (const char* s, const char* p)
{
	int matched, reverse;
	char first, last;

	for (; *p != '\0'; s++, p++) {
		switch (*p) {
			case '?':	/* match any one character */
				if (*s == '\0')
					return FALSE;
				break;
			case '*':	/* match everything */
				while (*p == '*')
					p++;

					/* if last char in pattern */
				if (*p == '\0')
					return TRUE;

					/* search for next char in pattern */
				matched = 0;
				while (*s != '\0') {
					if (*s == *p) {
						matched = 1;
						break;
					}
					s++;
				}
				if (!matched)
					return FALSE;
				break;
			case '[':	 /* match range of characters */
				first = '\0';
				matched = 0;
				reverse = 0;
				while (*++p != ']') {
					if (*p == '^') {
						reverse = 1;
						p++;
					}
					first = *p;
					if (first == ']' || first == '\0')
						return FALSE;

					/* if 2nd char is '-' */
					if (*(p + 1) == '-') {
						p++;
					/* set last to 3rd char ... */
						last = *++p;
						if (last == ']' || last == '\0')
							return FALSE;
					/* test the range of values */
						if (*s >= first && *s <= last) {
							matched = 1;
							p++;
							break;
						}
						return FALSE;
					}
					if (*s == *p)
						matched = 1;
				}
				if (matched && reverse)
					return FALSE;
				if (!matched)
					return FALSE;
				break;
			case '\\':	/* Literal match with next character */
				p++;
				/* fall thru */
			default:
				if (*s != *p)
					return FALSE;
				break;
		}
	}
					/* string ended prematurely ? */
	
	if (*s != '\0') return FALSE;
	
	return TRUE;
}


