/*
 *	fatsubdir.cc
 *
 *	Walk through directory structures.
 *
 *	(C) Copyright 1995, Pierre ARNAUD, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "fatdisk.h"


/*
 *	Descends the directory tree. Returns 1 on error. Attempts to
 *	optimize by remembering the last path it parsed
 */

Int16
FATDisk::SubDir (const char* pathname)
{
	char  t_buf[MAX_PATH];
	char* s;
	char* tmp;
	char* path;
	
	strcpy (t_buf, pathname);
	
	//	Same as last path ? If yes, easy... do nothing.
	
	if (strcmp (t_buf, this->lastpath) == 0) {
		return 0;
	}
	
	strcpy (t_buf, pathname);
	
	this->ResetChain ();
	if (pathname[0] == 0) return 0;
	
	strcpy (this->lastpath, pathname);
	
	tmp = t_buf;  // + 1;
	
	for (s = tmp; s[0]; ++s) {
		if (s[0] == ':') {
			
			path = tmp;
			s[0] = '\0';
			tmp  = s + 1;
			
			if (this->DescendDir (path)) {
				return 0x851A;				//	"dossier pas trouv"
			}
		}
	}
	
	return this->DescendDir (tmp);
}


/*
 *	Find the directory and load a new dir_chain[]. A null directory
 *	is ok. Returns a 1 on error.
 */

Int16
FATDisk::DescendDir (const char* path)
{
	if (path[0] == '\0') {
		return 0;
	}
	
	for (Card32 entry = 0; entry < this->dir_entries; entry++) {
		
		this->ReadDir (entry);
		
		if (this->dir_temp.name[0] == 0x00) break;
		if (this->dir_temp.name[0] == 0xE5) continue;
		
		if (this->dir_temp.attr & 0x10) {
			
			char newname[16];
			
			this->UnixName (newname, this->dir_temp.name, this->dir_temp.ext);
			
			if ( (newname[0] == '.')
			  && (path[0] != '.') ) {
				continue;
			}
			
			if (this->MatchName (newname, path)) {
				
				Card32 start = this->dir_temp.start[1] * 0x100 + this->dir_temp.start[0];
				
				if ( (start == 0)
				  && (strcmp (path, "..") == 0) ) {
					
					//	If ".." point to the root, just restore the root directory.
					
					this->ResetChain ();
					return 0;
				}
				
				if (this->FillChain (start)) {
					return 0x851A;				//	"dossier pas trouv"
				}
				
				return 0;
			}
		}
	}
	
	//	If path is '.' or '..', but they weren't found, then we must be
	//	at root !
	
	if ( (strcmp (path, ".") == 0)
	  || (strcmp (path, "..") == 0) ) {
		
		this->ResetChain ();
		return 0;
	}
	
	return 0x851A;								//	"dossier pas trouv"
}

