
#include "gesmem.h"
#include "ntrel.h"

MemAccount::MemAccount ()
{
	Ntr::GetTaskPtr (this->desc);	//	id. du processus
	this->type = 1;					//	MTYPOP
}

MemAccount::MemAccount (void* desc, Card32 type)
{
	this->desc = desc;
	this->type = type;
}


MemAccount::MemAccount (Card32 desc, Card32 type)
{
	this->desc = (void*)(desc);
	this->type = type;
}


MemAccount::~MemAccount ()
{
}

void*
MemAccount::Alloc (Card32 size)
{
	short error;
	void* ptr;
	
	asm ( "movel %2,d1\n\t"
		  "movel %3,a1\n\t"
		  "movel %4,d4\n\t"
		  ".long 0x4E440028\n\t"	//	GESMEM ?GETMEM
		  "movel a4,%0\n\t"
		  "movew d7,%1"
		: "=g" (ptr), "=g" (error)
		: "g" (this->type), "g" (this->desc), "g" (size)
		: "d1", "d4", "d7", "a1", "a4" );
	
	if (error) ptr = 0;
	return ptr;
}

void
MemAccount::Free (void* ptr)
{
	asm ( "movel %0,d1\n\t"
		  "movel %1,a1\n\t"
		  "movel %2,a4\n\t"
		  ".long 0x4E44002B"
		:
		: "g" (this->type), "g" (this->desc), "g" (ptr)
		: "d1", "d7", "a1", "a4" );
}

Card32
MemAccount::GetTotalMemory ()
{
	Card32 size = 0;
	
	asm ( ".long 0x4e440030	\n\t"				// GESMEM ?ARGLGM
		  "movel d4,%0"
		: "=g" (size)
		:
		: "d4", "d5", "d7" );
	
	return size;
}


Card32
MemAccount::GetBiggestHole ()
{
	Card32 size = 0;
	
	asm ( ".long 0x4e44002e	\n\t"				// GESMEM ?ARGMEM
		  "movel d5,%0"
		: "=g" (size)
		:
		: "d4", "d5", "d7" );
	
	return size;
}


Card32
MemAccount::GetFreeMemory ()
{
	Card32 size = 0;
	
	asm ( ".long 0x4e44002e	\n\t"				// GESMEM ?ARGMEM
		  "movel d4,%0"
		: "=g" (size)
		:
		: "d4", "d5", "d7" );
	
	return size;
}

