/*
 *	gesmem.h
 *
 *	Access to memory accounts using GESMEM
 *
 *	(C)	1994 Pierre ARNAUD
 *
 *			 Erik BRUCHEZ for "real" accounts, based on Pierre
 *			 ARNAUD's "old" OPaC 4 memory management
 *	
 */

#ifndef	_GESMEM_H_
#define	_GESMEM_H_

#include "portable.h"

class MemAccount
{
	void*		desc;
	Card32		type;
	
public:
	MemAccount ();
	MemAccount (void* desc, Card32 type);
	MemAccount (Card32 desc, Card32 type);
	
	~ MemAccount ();
	
	void* Alloc (Card32 size);
	void  Free (void* ptr);
	
	static Card32 GetTotalMemory ();
	static Card32 GetBiggestHole ();
	static Card32 GetFreeMemory ();
};

#endif /* _GESMEM_H_ */


