/*
 *	Copyright (c) 1992, 1993 William F. Jolitz, TeleMuse
 *	Copyright (c) 1995, Pierre Arnaud, OPaC bright ideas
 *
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions
 *	are met:
 *	1. Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	2. Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in the
 *	   documentation and/or other materials provided with the distribution.
 *	3. All advertising materials mentioning features or use of this software
 *	   must display the following acknowledgement:
 *	This software is a component of "386BSD" developed by 
 *	William F. Jolitz, TeleMuse.
 *	4. Neither the name of the developer nor the name "386BSD"
 *	   may be used to endorse or promote products derived from this software
 *	   without specific prior written permission.
 *
 *	THIS SOFTWARE IS A COMPONENT OF 386BSD DEVELOPED BY WILLIAM F. JOLITZ 
 *	AND IS INTENDED FOR RESEARCH AND EDUCATIONAL PURPOSES ONLY. THIS 
 *	SOFTWARE SHOULD NOT BE CONSIDERED TO BE A COMMERCIAL PRODUCT. 
 *	THE DEVELOPER URGES THAT USERS WHO REQUIRE A COMMERCIAL PRODUCT 
 *	NOT MAKE USE OF THIS WORK.
 *
 *	THIS SOFTWARE IS PROVIDED BY THE DEVELOPER ``AS IS'' AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED.  IN NO EVENT SHALL THE DEVELOPER BE LIABLE
 *	FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *	DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 *	OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *	HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *	SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>

#include "cdromfs.h"
#include "susp.h"
#include "rrip.h"
#include "efs.h"
#include "isoefs.h"
#include "gesmem.h"

unsigned long _stksize = 10*1024;
unsigned long _SMASOVER = 1;
unsigned char _SMAPRIO = 13;
unsigned char _SMAREV = 0;
unsigned char _SMAVER = 4;
unsigned long _SMAUNIT = 0x000000A0;
unsigned short _SMADIS[] = {20, 500, 20, 300};
char _SMAIDE[] = "(C) 1992-1993 W.F.Jolitz, (C) 1995 P.Arnaud";


FS		    cdrom_struct = { 0 /* ... */ };
FS*		    cdrom;
DirEntry    root_struct;
DirEntry*   root;
const char* cdrom_name;

extern char* _commandline;

int
main ()
{
	char* argv[4];
	int   argc = 0;
	
	//	Dcoupe la ligne de commande en arguments spars...
	
	while (argc < 4) {
		
		argv[argc++] = _commandline;
		
		//	Saute l'argument courant : cherche le premier mot aprs le prochain
		//	espace ou termine si l'on trouve la fin de la ligne !
		
		while ( (*_commandline)
		     && (*_commandline != '\r') ) {
			
			if (*_commandline == ' ') {
				*_commandline++ = 0;
				while (*_commandline == ' ') _commandline++;
				break;
			} else {
				_commandline++;
			}
		}
		
		if (*_commandline == 0) break;
		if (*_commandline == '\r') break;
	}
	
	*_commandline = 0;
	
	if (argc != 3) {
		/* fprintf (stderr, "Syntaxe: %s $CDROM_0 @XDRI-1\n", argv[0]); */
		return 1;
	}
	
	cdrom = & cdrom_struct;
	root  = & root_struct;
	
	cdrom_name = argv[1];
	cdrom->fd  = 0;
#if 0
	cdrom->fd  = cd_open (cdrom_name);
	
	if (cdrom->fd & 0xFFFF0000) {
		/* fprintf (stderr, "Pas russi  accder  %s !\n", argv[1]); */
		return 2;
	}
	
	char* buffer = new char[4096];
	
	if (cd_read (cdrom->fd, buffer, 4096) == 0) {
		cd_close (cdrom->fd);
		/* fprintf (stderr, "Pas russi  lire %s !\n", argv[1]); */
		return 3;
	}
	
	delete buffer;
#endif
	Iso9660* efs  = new Iso9660 ();
	char*    xdri = argv[2];
	
	//	Supprime les ":" terminateurs, s'ils existent !
	
	while (*xdri++) ;
	if (xdri[-1] == ':') xdri[-1] = 0;
	
	if (efs) {
		efs->StartServer (argv[2]);
		delete efs;
	}
	
	cd_close (cdrom->fd);
	asm volatile ( "moveq #0,d3\n\t"
				   "movel %0,a3\n\t"
				   ".long 0x4E450019"	//	FOS ?DEINSTALL
				 :
				 : "g" (cdrom_name)
				 : "d3", "d7", "a3" );
	
	return 0;
}


/**********************************************************************************/


/*
 *	Open the CD driver and return the associated (positive) channel
 *	on success, or some negative error.
 */

int
cd_open (const char* name)
{
	Card16 ch   = 0;
	Card32 mode = 0x0010000A;
	Card16 err  = 0;

	asm volatile ( "movel %2,a3\n\t"
			       "movel %3,d3\n\t"
			       ".long 0x4E45004A\n\t"
			       "movew d6,%0\n\t"
		    	   "movew d7,%1"
			     : "=g" (ch), "=g" (err)
			     : "g" (name), "g" (mode)
			     : "d3", "d6", "d7", "a3" );

	return (err) ? (err | 0xFFFF0000) : ch;
}

void
cd_close (int ich)
{
	Card16 ch = ich;
	
	asm volatile ( "movew %0,d6\n\t"
				   ".long 0x4E450005"
				 :
				 : "g" (ch)
				 : "d6", "d7" );
}


static void
cd_auxil (int ich, const char* cmd)
{
	Card16 ch = ich;
	
	asm volatile ( "movew %0,d6\n\t"
				   "movel %1,a3\n\t"
				   "moveq #0,d4\n\t"
				   "moveq #0,d5\n\t"
				   "movel d4,a4\n\t"
				   "movel d5,a5\n\t"
				   ".long 0x4e450068"
				 :
				 : "g" (ch), "g" (cmd)
				 : "d4", "d5", "d6", "d7", "a3", "a4", "a5" );
}


void
cd_eject (int ch)
{
	Card8 cmd[16];
	
	cmd[0] = 0x1E;								//	allow media removal
	cmd[1] = cmd[2] = cmd[3] = cmd[4] = 0x00;
	cmd[5] = cmd[6] = cmd[7] = cmd[8] = 0x00;
	cd_auxil (ch, cmd);
	
	cmd[0] = 0xC0;								//	eject media
	cd_auxil (ch, cmd);
}


void
cd_lseek (int ich, long ipos)
{
	Card16 ch  = ich;
	Card32 pos = ipos;
	
	asm volatile ( "movew %0,d6\n\t"
			       "movel %1,d4\n\t"
			       "moveql #0,d3\n\t"
			       ".long 0x4E450004"
			     : 
			     : "g" (ch), "g" (pos)
			     : "d3", "d4", "d6", "d7" );
}


/*
 *	Read data from the drive. This will at least read 2048 bytes
 *	which is the current CD-ROM physical block size.
 */

int
cd_read (int ich, void* buf, long siz)
{
	static char array[2048];
	
	Card16 err   = 0;
	Card16 ch    = ich;
	Card32 rdsiz = siz;
	void*  rdbuf = buf;
	
	if (siz < 2048) {
		rdsiz = 2048;
		rdbuf = array;
	}
	
	asm volatile ( "movew %1,d6\n\t"
				   "movel %2,d4\n\t"
				   "movel %3,a4\n\t"
				   ".long 0x4E450001\n\t"
				   "movew d7,%0"
				 : "=g" (err)
				 : "g" (ch), "g" (rdsiz), "g" (rdbuf)
				 : "d4", "d6", "d7", "a4" );
#if 0	
	if (err) printf ("Erreur de lecture depuis le CDROM.\n");
	if (siz < 2048) printf ("Taille de lecture trange (%d).\n", siz);
#endif
	//	Si l'appelant a demand moins qu'un bloc, il faut extraire la partie
	//	intressante de celui-ci. C'est trs peu probable !
	
	if (siz < 2048) {
		char* p1 = (char*)(buf);
		char* p2 = (char*)(rdbuf);
		while (siz--) {
			*p1++ = *p2++;
		}
	}
	
	return (err) ? 0 : siz;
}



static MemAccount account;

void*
operator new (long unsigned size)
{
	return account.Alloc (size);
}

void
operator delete (void* ptr)
{
	account.Free (ptr);
}


