/*
 *	efs.h
 *
 *	La classe EFS utilise par le serveur de fichiers gre la rception
 *	des paquets en provenance du pilote $XDRI et appelle les mthodes
 *	adquates.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */


#ifndef _EFS_H_
#define _EFS_H_

#pragma interface

#include "portable.h"
#include "ntrel.h"

enum EFSop
{
	EFS_MOUNT,			//	0
	EFS_UNMOUNT,
	EFS_OPEN,
	EFS_CREATE,
	EFS_DELETE,
	EFS_RENAME,
	EFS_MOVE,
	EFS_CHATR,
	EFS_IFOPEN,
	EFS_ARGS,
	EFS_CLEAR,			//	10
	EFS_DISK,
	EFS_CDIR,
	EFS_RDBYTE,			//	13
	EFS_WRBYTE,			//	14
	EFS_SETPOS,
	EFS_GETPOS,
	EFS_TRUNC,
	EFS_CLOSE,			//	18
	EFS_ENTER,
	EFS_RELEASE,
	EFS_LISTOPEN,
	EFS_LISTBUF,
	EFS_LISTCLOSE,
	EFS_REQUEST
};


struct EFSmsg
{
	Card32		 instance;
	EFSop		 op;
	Card32		 c32[4];
	Int16		 i16[4];
	Card16		 c16[4];
	Card8*		 p[4];
	const Card8* pc[4];
	const char*	 name[4];
	char		 errname[200];
};


class EFS
{
	
protected:
	NtrBar		bar;						//	bar pour le dialogue avec le pilote $XDRI
	Bool		running;					//	TRUE => serveur en excution
	
public:
	EFS ();
	virtual ~EFS ();
	
	virtual void StartServer (const char* xdri);
	
	virtual void Open (const char* name, Card32 mode, Card32 len, Card16& ch, Int16& err);
	virtual void Create (const char* name, Card32 attr, Int16& err);
	virtual void Delete (const char* name, Card32 mode, Int16& err);
	virtual void Rename (const char* name_src, const char* name_dst, Int16& err);
	virtual void Move (const char* name_src, const char* name_dst, Int16& err);
	virtual void Chatr (const char* name, Card32 attr, Int16& err);
	virtual void IfOpen (const char* name, Int16& err);
	virtual void Args (const char* name, Card16 mode, Card8* args, Card16& count, Int16& err);
	virtual void Clear (const char* name, Int16& err);
	virtual void Disk (const char* name, Card32& free, Card32& used, Int16& err);
	virtual void CDir (const char* name, Int16& err);
	virtual void RdByte (Card16 ch, Card32& len, Card8* data, Int16& err);
	virtual void WrByte (Card16 ch, Card32& len, const Card8* data, Int16& err);
	virtual void SetPos (Card16 ch, Card32& poslow, Card32& poshigh, Card16 mode, Int16& err);
	virtual void GetPos (Card16 ch, Card32& poslow, Card32& poshigh, Int16& err);
	virtual void Trunc (Card16 ch, Int16& err);
	virtual void Close (Card16 ch, Card32 h, Card32 d, Int16& err);
	
	virtual void Enter (const char* name, Card16 mode, Int16& err);
	virtual void Release (const char* name, Int16& err);
	
	virtual void ListOpen (const char* dir, const char* crit, Card32 mode, Card32& ch, Card32& num, Card32& id, Int16& err);
	virtual void ListBuf (Card32 ch, Card32& len, Card8* buf, Int16& err);
	virtual void ListClose (Card32 ch, Int16& err);
	
	virtual void Mount ();
	virtual void Unmount ();
	virtual void Request (const char* arg, Int16& err);
};


#endif

