/*
 * Copyright (c) 1992, 1993 William F. Jolitz, TeleMuse
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This software is a component of "386BSD" developed by 
 *	William F. Jolitz, TeleMuse.
 * 4. Neither the name of the developer nor the name "386BSD"
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS A COMPONENT OF 386BSD DEVELOPED BY WILLIAM F. JOLITZ 
 * AND IS INTENDED FOR RESEARCH AND EDUCATIONAL PURPOSES ONLY. THIS 
 * SOFTWARE SHOULD NOT BE CONSIDERED TO BE A COMMERCIAL PRODUCT. 
 * THE DEVELOPER URGES THAT USERS WHO REQUIRE A COMMERCIAL PRODUCT 
 * NOT MAKE USE OF THIS WORK.
 *
 * THIS SOFTWARE IS PROVIDED BY THE DEVELOPER ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE DEVELOPER BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *  Rock Ridge Interchange Protocol
 *  Extensions to provide POSIX file attributes to an ISO-9660 CDROM.
 *  fields, constants, and interface definitions.
 */

#define RRIPID		"RRIP_1991A"
#define	RRIPIDLEN	10

#include <sys/stat.h>

/* RRIP SUSP Records: */

struct RripPX {
	iso711_t sig[2];		//	"PX"
	iso711_t sz;			//	size of entry (including possible pad)
	iso711_t vers;			//	version of entry
	iso733_t mode;			//	POSIX file mode bits (st_mode)
	iso733_t links;			//	POSIX file links (st_nlink)
	iso733_t uid;			//	POSIX User ID (st_uid)
	iso733_t gid;			//	POSIX Group ID (st_gid)
};

struct RripPN {
	iso711_t sig[2];		//	"PN"
	iso711_t sz;			//	size of entry (including possible pad)
	iso711_t vers;			//	version of entry
	iso733_t dev_high;		//	POSIX device high number
	iso733_t dev_low;		//	POSIX device low number
};

struct RripNM {
	iso711_t sig[2];		//	"NM"
	iso711_t sz;			//	size of entry (including possible pad)
	iso711_t vers;			//	version of entry
	iso711_t flags;			//	name flags
#define	NM_CONT	0x01		//	name continuted into another record
#define	NM_CURR	0x02		//	"dot", or current relative location
#define	NM_PAR	0x04		//	"dotdot", or parent directory
#define	NM_HOST	0x20		//	glue system's hostname into name
	char	name[0];		//	variable length name
};

struct Slcomp {
	iso711_t flags;			//	component flags
#define	SLC_CONT	0x01	//	continue this component in another field
#define	SLC_CURR	0x02	//	"dot", or current relative location
#define	SLC_PAR		0x04	//	"dotdot", or parent directory
#define	SLC_ROOT	0x08	//	"slash", or root of filesystem
#define	SLC_VOLROOT	0x10	//	directory this filesystem is mounted on
#define	SLC_HOST	0x20	//	system's hostname
	iso711_t name_sz;		//	size of name
	char name[0];			//	component name
};

struct RripSL {
	iso711_t sig[2];		//	"SL"
	iso711_t sz;			//	size of entry (including possible pad)
	iso711_t vers;			//	version of entry
	iso711_t flags;			//	name flags
#define	SL_CONT	0x01
	Slcomp	 ent[0];		//	variable length name
};

struct RripTF {
	iso711_t sig[2];		//	"TF"
	iso711_t sz;			//	size of entry (including possible pad)
	iso711_t vers;			//	version of entry
	iso711_t flags;			//	time stamp flags
#define	TF_CREATE	 0x01	//	file creation date
#define	TF_MODIFY	 0x02	//	file modification date
#define	TF_ACCESS	 0x04	//	file access date
#define	TF_ATTRIB	 0x08	//	file attributes modification date
#define	TF_BACKUP	 0x10	//	file backup date
#define	TF_EXPIRE	 0x20	//	file expiration date
#define	TF_EFFECTIVE 0x40	//	file effective date
#define	TF_LONG		 0x80	//	time stamp in ascii format
	char	stamps[0];		//	starting here
};

struct DirEntry;
struct FS;

void   rrip_statb (DirEntry* dp, stat* sb, FS* fs, int r);
time_t rrip_time (char** tp, char flg);


