/*
 * Copyright (c) 1992, 1993 William F. Jolitz, TeleMuse
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This software is a component of "386BSD" developed by 
 *	William F. Jolitz, TeleMuse.
 * 4. Neither the name of the developer nor the name "386BSD"
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS A COMPONENT OF 386BSD DEVELOPED BY WILLIAM F. JOLITZ 
 * AND IS INTENDED FOR RESEARCH AND EDUCATIONAL PURPOSES ONLY. THIS 
 * SOFTWARE SHOULD NOT BE CONSIDERED TO BE A COMMERCIAL PRODUCT. 
 * THE DEVELOPER URGES THAT USERS WHO REQUIRE A COMMERCIAL PRODUCT 
 * NOT MAKE USE OF THIS WORK.
 *
 * THIS SOFTWARE IS PROVIDED BY THE DEVELOPER ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE DEVELOPER BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * System Use Sharing Protocol
 */


#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include "cdromfs.h"
#include "susp.h"


/*
 *	Do SUSP protocol as we attempt to locate a given
 *	System Use Field
 */

unsigned char*
handle_susp (DirEntry* dp, SuspCont* scp, char* opt, FS* fs, int inroot)
{
	unsigned int		resid;
	GenericExtension*	ep;
	unsigned char*		cp;
	
	//	Is continuation buffer in need of being initialized ?
	
	if (scp->curr == 0) {
		
		long reclen = FDV (dp, reclen, fs->type);
		long namlen = FDV (dp, namlen, fs->type);
		
		//	Compensate for reserved field used to word align directory entry.
		
		scp->len = sizeof (FSdir) + namlen;
		
		if (scp->len & 1) scp->len++;
		
		scp->curr = (unsigned char*)(dp) + scp->len;
		scp->len  = reclen - scp->len;
		
		//	No continuation to begin with.
		
		scp->cont_cmd = 0;
		scp->cont_buf = 0;
		
		//	If not root directories' '.' pointer, skip over bytes.
		
		if ( (inroot == 0)
		  || (namlen != 1)
		  || ((FDV(dp, name, fs->type))[0] != 0) ) {
			scp->curr += fs->susp_begin;
			scp->len  -= fs->susp_begin;
		}
	}
	
	cp    = scp->curr;
	resid = scp->len;
	
	//	Walk list of options in search of desired one.
	
again:
	while (resid >= sizeof (GenericExtension)) {
		
		//	While there is room enough for an extension, examine for extensions.
		//	Is there a recognizable extension of some sort ?
		
		if ((ep = valid_ext (cp, resid)) == 0) goto leave;
		
		scp->curr = cp + ep->sz;
		scp->len  = resid - ep->sz;
		
		//	Found the option desired ?
		
		if (strncmp(ep->sig, opt, 2) == 0) return cp;
		
		//	If continuation, rememeber...
		
		if (strncmp(ep->sig, "CE", 2) == 0) scp->cont_cmd = cp;
		
		//	If termination, do :
		
		if (strncmp(ep->sig, "ST", 2) == 0) goto leave;
		
		//	Move to the next extension
		
		cp    += ep->sz;
		resid -= ep->sz;
	}
	
	//	Did we find a new continuation ?
	
	if (scp->cont_cmd) {
		
		SuspCE*	ce  = (SuspCE*)(scp->cont_cmd);
		FS		fsd;
		FS*		fs  = & fsd;
		
		int		bn  = ISO_WD (&ce->locn);
		int		off = ISO_WD (&ce->offset);
		
		resid = ISO_WD (&ce->len);
		scp->cont_cmd = 0;
		
		//	Drop old continuation, if any.
		
		if (scp->cont_buf) delete scp->cont_buf;
		
		scp->cont_buf = new unsigned char[fs->lbs];
		
		cd_lseek (fs->fd, lbntob (fs, bn + (off/fs->lbs)));
		cd_read (fs->fd, scp->cont_buf, fs->lbs);
		cp = scp->cont_buf + off % fs->lbs;
		goto again;
	}
	
leave:
	if (scp->cont_buf) {
		delete scp->cont_buf;
		scp->cont_buf = 0;
	}
	
	return 0;
}


