/*
 * Copyright (c) 1992, 1993 William F. Jolitz, TeleMuse
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This software is a component of "386BSD" developed by 
 *	William F. Jolitz, TeleMuse.
 * 4. Neither the name of the developer nor the name "386BSD"
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS A COMPONENT OF 386BSD DEVELOPED BY WILLIAM F. JOLITZ 
 * AND IS INTENDED FOR RESEARCH AND EDUCATIONAL PURPOSES ONLY. THIS 
 * SOFTWARE SHOULD NOT BE CONSIDERED TO BE A COMMERCIAL PRODUCT. 
 * THE DEVELOPER URGES THAT USERS WHO REQUIRE A COMMERCIAL PRODUCT 
 * NOT MAKE USE OF THIS WORK.
 *
 * THIS SOFTWARE IS PROVIDED BY THE DEVELOPER ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE DEVELOPER BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * System Use Sharing Protocol -
 * field format, constants, and interface definitions.
 */

struct SuspCE {
	iso711_t sig[2];			//	"CE"
	iso711_t sz;				//	size of entry (including possible pad)
	iso711_t vers;				//	version of entry
	iso733_t locn;				//	logical block number of first block
	iso733_t offset;			//	octet offset from start of logical block
	iso733_t len;				//	length, in octets of this continutation
};

struct SuspSP {
	iso711_t sig[2];			//	"SP"
	iso711_t sz;				//	size of entry (including possible pad)
	iso711_t vers;				//	version of entry
	iso711_t ck1, ck2;			//	check bytes
#define	SUSP_SPCK1	0xBE		//	"Where's the beef?"
#define	SUSP_SPCK2	0xEF
	iso711_t skplen;			//	skip these octets in System Use Area of each directory..
								//	..entry before starting SUSP
};

struct SuspER {
	iso711_t sig[2];			//	"ER"
	iso711_t sz;				//	size of entry (including possible pad)
	iso711_t vers;				//	version of entry
	iso711_t len_id;			//	length of extension identifier
	iso711_t len_des;			//	length of extension descriptor
	iso711_t len_src;			//	length of extension source
	iso711_t ext_ver;			//	version of this extension used this volume
	char	 ids[0];			//	variable length id's - id, des, src
};


/*
 *	Implementation specific data structure to hold continuation
 *	state
 */

struct SuspCont {
	unsigned char*	curr;		//	current source of SUSP fields
	int				len;		//	current length of SUSP fields
	unsigned char*	cont_cmd;	//	unissued continuation cmd
	unsigned char*	cont_buf;	//	current  continuation buffer
};

struct DirEntry;
struct FS;

unsigned char* handle_susp (DirEntry*, SuspCont*, char*, FS*, int);


