/*
 *	channel.h
 *
 *	Gestion de canaux associs aux noeuds.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */


#ifndef _CHANNEL_H_
#define _CHANNEL_H_

#include "node.h"

/*
 *	Canal dcrivant une transaction avec un fichier quelconque
 *	dcrit par un noeud.
 */

class FileChannel
{
	FileNode*		node_active;				//	noeud dans lequel on lit/crit
	int				node_index;					//	index du canal dans le noeud
	int				ch_count;					//	numro du canal global
	
	Card32			position;					//	position en lecture ou en criture
	
public:
	FileChannel ();
	~FileChannel ();
	
	int  Channel () const   { return this->ch_count; }
	Bool IsOpen () const    { return this->ch_count ? TRUE : FALSE; }
	FileNode* Node () const { return this->node_active; }
	
	Bool Open (FileNode* node, int index);
	Bool Close ();
	
	Bool Read (Card8* data, Card32& len, Int16& err);
	Bool Write (const Card8* data, Card32& len, Int16& err);
	Bool Trunc (Int16& err);
	Bool SetPos (Card32& len, Int16& err);
	Bool GetPos (Card32& len, Int16& err) const { len = position; err = 0x0000; return TRUE; }
	
	static FileChannel* GetChannel (int);
};

#endif

