/*
 *	console.cc
 *
 *	Programme principal de la console.
 *
 *	(C) Copyright 1996, Pierre Arnaud, OPaC bright ideas
 *		CH-1437 SUSCEVAZ
 */

#include <stdio.h>
#include <string.h>

#include <c++/portable.h>
#include <c++/ntrel.h>
#include <c++/fos.h>

#include "spyfile.h"
#include "spytools.h"
#include "../nif.h"

Card32 _stksize  = 10*1024;
Card32 _SMASOVER = 0;					//	pas en overlay par dfaut
Card8  _SMAPRIO  = 6;					//	priorit trs forte
Card8  _SMAREV   = 0;					//	rvision
Card8  _SMAVER   = 1;					//	version
Card32 _SMAUNIT  = 0x00000083;			//	non rentrant, fentre & clavier
Card16 _SMADIS[] = {20, 600, 20, 400};
char   _SMAIDE[] = "(C) Copyright 1996, Pierre ARNAUD, OPaC bright ideas";



static void
dump_file (SpyingFile* spy, Card32 pos, Card32 len)
{
	char   name[200];
	char   buffer[1000+1];
	Card32 size;
	Card16 channel;
	
	strcpy (name, SMART_NAME);
	strcat (name, spy->GetName ());
	
	if (FOS::Open (name, FOS_OPEN_READ, channel) == 0) {
		FOS::SetPos (channel, pos);
		while (len) {
			size = (len > 1000) ? 1000 : len;
			len -= size;
			FOS::Read (channel, size, buffer);
			buffer[size] = 0;
			spy->Output (buffer);
		}
		FOS::Close (channel);
	}
}


static void
remove_spy (SpyingFile* spy)
{
	finish_spy (spy->GetName ());
}

static void
get_event (SpyRecord& spy_event, NtrBAL& spy_bal)
{
	Card32    len  = sizeof (spy_event);
	Card32    num  = 0;
	Card8     mode = 0;
	spy_bal.GetMessage (&spy_event, len, num, mode);
}



int
main (int argc, char* argv[])
{
	NtrBAL      spy_bal;
	NtrSync     spy_sem;
	SpyRecord   spy_event;
	
	Bool        stop  = FALSE;
	int         error = 0;
	Card32      pos   = 0;
	Card32      len   = 0;
	Card32      id    = 0;
	SpyingFile* spy   = 0;
	const char* name  = 0;
	char        file[200];
	
	//	Initialise le systme de fichiers spcial SMART afin de pouvoir crer
	//	un point pour monter le dossier CONSOLE, utilis pour regrouper les
	//	messages des clients.
	
	error = init_smart_efs ();
	error = setup_spy_on_dir (CONSOLE_NAME, id++, spy_bal, spy_sem);
	
	if (error) {
		return error;
	}
	
	//	Boucle sans fin : attendre un message, le traiter, attendre un message,
	//	etc...
	
	while (stop == FALSE) {
		
		spy_sem.Wait (25);
		
		//	Y a-t-il eu un timeout ? Si oui, ne fait rien de particulier et
		//	attend l'vnement suivant.
		
		if (spy_sem.GetError ()) {
			continue;
		}
		
		//	Lit un vnement depuis la bote aux lettres; cet vnement peut
		//	dboucher sur un affichage de donnes dans la fentre de la
		//	console.
		
		get_event (spy_event, spy_bal);
		
		switch (spy_event.event) {
			
			case SPY_CREATE:
				
				if (spy_event.id != 0) break;
				
				name = (const char*)(spy_event.arg_1);
				
				if (strcmp (name, "KILL") == 0) {
					stop = TRUE;
					break;
				}
				
				strcpy (file, CONSOLE_NAME);
				strcat (file, name);
				setup_spy_on_file (file, id, spy_bal, spy_sem);
				setup_sync_file (file);
				spy = new SpyingFile (file, id++);
				break;
			
			
			case SPY_DELETE:
				
				spy  = SpyingFile::Find (spy_event.id);
				name = (const char*)(spy_event.arg_1);
				
				if (spy == 0) break;
				
				remove_spy (spy);
				delete spy;
				break;
			
			
			case SPY_WRITE:
				
				spy = SpyingFile::Find (spy_event.id);
				pos = spy_event.arg_1;
				len = spy_event.arg_2;
				
				if (spy == 0) break;
				
				dump_file (spy, pos, len);
				break;
			
			default:
				break;
		}
	}
	
	finish_spy (CONSOLE_NAME);
	
	SpyingFile::ForAll (remove_spy);
	SpyingFile::Kill ();
	
	return 0;
}


