
#ifndef _SMAKYARGS_H_
#define _SMAKYARGS_H_

#include "portable.h"
#include "efs.h"

struct FileNode;

#define	ATTR_DEFAULT	(0x0000077F)
#define	ATTR_DELETE		(1 << 7)
#define	ATTR_DIR		(1 << 12)
#define	ATTR_LIST		(1 << 13)

#define	LIST_DIR		(1 << 23)

#define	FOS_OPEN_EXCL		0x00000001
#define	FOS_OPEN_READ		0x00000002
#define	FOS_OPEN_WRITE		0x00000004
#define	FOS_OPEN_EXTEND		0x00000008
#define	FOS_OPEN_EXCL_WR	0x00000010
#define	FOS_OPEN_CODE		0x00000020
#define	FOS_OPEN_NDIR		0x00000040
#define	FOS_OPEN_SYS		0x00000080
#define	FOS_OPEN_ARGS		0x00000100
#define	FOS_OPEN_CREATE		0x00000800
#define	FOS_OPEN_OPEN		0x00001000
#define	FOS_OPEN_APPEND		0x00002000
#define	FOS_OPEN_RSTATUS	0x00004000
#define	FOS_OPEN_PRE		0x00008000
#define	FOS_OPEN_NODIR		0x00040000
#define	FOS_OPEN_GENERAL	0x00080000
#define	FOS_OPEN_MMUNIT		0x00100000

struct ListInfo
{
	FileNode*		current;					//	noeud courant
	Bool			b_dossier;					//	TRUE => liste les dossiers avec ":"
};

struct SmakyDate
{
	Card8			day,  month,  year;
	Card8			hour, minute, second;
};

struct SmakyArgs
{
	Card8			type;						//	type de fichier (0)
	Card8			open;						//	compteur d'ouvertures
	Card32			attr;						//	attributs
	Card32			block_num;					//	nombre de blocs
	Card16			block_last;					//	taille dans le dernier bloc
	SmakyDate		d_create;
	SmakyDate		d_modif;
	SmakyDate		d_use;
	Card32			res_1;
	Card32			bd;
	Card32			length;
	Card16			code;
	Card8			res_2[20];
};

struct SmakyNameArgs
{
	char			name[16];					//	nom du fichier
	Card8			type;						//	type de fichier (0)
	Card8			open;						//	compteur d'ouvertures
	Card32			attr;						//	attributs
	Card32			block_num;					//	nombre de blocs
	Card16			block_last;					//	taille dans le dernier bloc
	SmakyDate		d_create;
	SmakyDate		d_modif;
	SmakyDate		d_use;
	Card32			res_1;
	Card32			bd;
	Card32			length;
	Card16			code;
	Card32			rank;
};

#endif

