/*
 *	spyfile.cc
 *
 *	Base de donnes des fichiers en cours d'espionnage.
 *
 *	(C) Copyright 1996, Pierre Arnaud, OPaC bright ideas
 *		CH-1437 SUSCEVAZ
 */

#pragma implementation

#include <stdio.h>
#include <string.h>

#include "spyfile.h"

SpyingFile*	SpyingFile::head = 0;
SpyingFile*	SpyingFile::tail = 0;


/*
 *	Enregistre un nouveau fichier.
 */

SpyingFile::SpyingFile (const char* name, Card32 id)
{
	this->next = 0;
	this->prev = this->tail;
	this->id   = id;
	strcpy (this->name, name);
	
	this->buffer[0] = 0;
	this->buf_ptr   = this->buffer;
	this->buf_len   = sizeof (this->buffer) - 1;
	
	(this->next ? this->next->prev : this->tail) = this;
	(this->prev ? this->prev->next : this->head) = this;
}

SpyingFile::~SpyingFile ()
{
	(this->next ? this->next->prev : this->tail) = this->prev;
	(this->prev ? this->prev->next : this->head) = this->next;
}


void
SpyingFile::OutputCurrentLine ()
{
	printf ("[%02d] %s\n", this->id, this->buffer);
}


void
SpyingFile::Output (const char* text)
{
	char c = *text++;
	
	while (c) {
		if ( (c == '\n')
		  || (c == '\r') ) {
			
			this->buf_ptr[0] = 0;
			this->OutputCurrentLine ();
			this->buf_ptr    = this->buffer;
			this->buf_len    = sizeof (this->buffer) - 1;
			this->buf_ptr[0] = 0;
			
		} else {
			
			if (this->buf_len) {
				this->buf_ptr[0] = c;
				this->buf_ptr++;
				this->buf_len--;
			}
		}
		
		c = *text++;
	}
}


SpyingFile*
SpyingFile::Find (Card32 id)
{
	SpyingFile* spy = SpyingFile::head;
	
	while (spy) {
		if (spy->id == id) {
			break;
		}
		spy = spy->next;
	}
	
	return spy;
}


SpyingFile*
SpyingFile::Find (const char* name)
{
	SpyingFile* spy = SpyingFile::head;
	
	while (spy) {
		if (stricmp (spy->name, name) == 0) {
			break;
		}
		spy = spy->next;
	}
	
	return spy;
}


void
SpyingFile::ForAll (PtrFuncSpy func)
{
	SpyingFile* spy = SpyingFile::head;
	
	while (spy) {
		(*func) (spy);
		spy  = spy->next;
	}
}


void
SpyingFile::Kill ()
{
	while (SpyingFile::head) {
		delete SpyingFile::head;
	}
}


