/*
 *	spyfile.h
 *
 *	Base de donnes des fichiers en cours d'espionnage.
 *
 *	(C) Copyright 1996, Pierre ARNAUD, OPaC bright ideas
 *		CH-1437 Suscvaz
 *
 */

#ifndef	_SPYFILE_H_
#define	_SPYFILE_H_

#pragma interface

#ifndef _PORTABLE_H_
#include <c++/portable.h>
#endif

class SpyingFile;
typedef void (*PtrFuncSpy)(SpyingFile*);

/*
 *	Base de donnes trs simplifie, permettant de chercher
 *	un fichier  partir de son ID ou de son nom.
 */

class SpyingFile
{
	
private:
	static SpyingFile*	head;
	static SpyingFile*	tail;
	
private:
	SpyingFile*			next;			//	fichier suivant
	SpyingFile*			prev;			//	fichier prcdent
	
	Card32				id;				//	identificateur unique
	char				name[200];		//	nom du fichier
	
	char				buffer[200];	//	buffer de construction de lignes
	char*				buf_ptr;		//	pointeur dans le buffer
	int					buf_len;		//	taille restante
	
protected:
	void OutputCurrentLine ();
	
public:
	SpyingFile (const char* name, Card32 id);
	~SpyingFile ();
	
	Card32 GetId () const			{ return this->id; }
	const char* GetName () const	{ return this->name; }
	
	void Output (const char* text);
	
	static SpyingFile* Find (Card32 id);
	static SpyingFile* Find (const char* name);
	
	static void ForAll (PtrFuncSpy func);
	static void Kill ();
};

#endif

