/*
 *	spytools.cc
 *
 *	Outils pour l'espionnage de fichiers dans l'efs SMART.
 *
 *	(C) Copyright 1996, Pierre Arnaud, OPaC bright ideas
 *		CH-1437 SUSCEVAZ
 */

#include <stdlib.h>

#include <c++/portable.h>
#include <c++/ntrel.h>
#include <c++/fos.h>

#include "spytools.h"
#include "../nif.h"


/*
 *	Envoie une commande quelconque au `file system' SMART,
 *	pour autant qu'il ait t install.
 */

static int
send_command (const void* data, Card32 length)
{
	Card16 channel = 0;
	int    error   = FOS::Open (FOS_COMMAND_NAME, FOS_OPEN_WRITE, channel);
	
	if (error) {
		return error;
	}
	
	error = FOS::Write (channel, length, data);
	FOS::Close (channel);
	
	return error;
}



/*
 *	Initialise l'EFS `smart' si ce n'est pas encore fait. On attend un
 *	petit moment aprs l'initialisation pour tre sr que tout a t
 *	proprement mis en place.
 */

int
init_smart_efs ()
{
	if (getenv (SMART_NAME) == 0) {
		
		if ( (FOS::Install ("", "$xdri_0", "") == 0x8512)
		  || (FOS::Execute ("#:efs:sma_smart.efs @xdri-2:", FOS_EX_ONLYONE) == 0x8512) ) {
			return 0x8512;
		}
		
		Ntr::Delms (50);
		FOS::Assign (SMART_NAME, "@xdri-2:");
		FOS::CDir (FOS_CONSOLE_NAME, 1);
		FOS::Assign ("@_CONSOLE_:", FOS_CONSOLE_NAME);
	}
	
	return 0;
}


/*
 *	Espionne un dossier complet.
 */

int
setup_spy_on_dir (const char* dir, Card32 id, NtrBAL& spy_bal, NtrSync& sync)
{
	NifCmdSpy spy_rec;
	
	spy_rec.nif_id				= NIF_SPY;
	spy_rec.name				= dir;
	spy_rec.spy_id				= id;
	spy_rec.spy_bal				= spy_bal.GetBAL ();
	spy_rec.spy_sync			= sync.GetSem ();
	spy_rec.spy_name[0]			= 0;
	spy_rec.do_spy_open_close	= FALSE;
	spy_rec.do_spy_read			= FALSE;
	spy_rec.do_spy_write		= FALSE;
	spy_rec.do_spy_cre_del		= TRUE;
	
	return send_command (& spy_rec, sizeof (spy_rec));
}


/*
 *	Espionne les critures, ouvertures et fermetures de fichiers.
 *	N'espionne pas les lectures, puisqu'elles viennent en principe
 *	de nous.
 */

int
setup_spy_on_file (const char* file, Card32 id, NtrBAL& spy_bal, NtrSync& sync)
{
	NifCmdSpy spy_rec;
	
	spy_rec.nif_id				= NIF_SPY;
	spy_rec.name				= file;
	spy_rec.spy_id				= id;
	spy_rec.spy_bal				= spy_bal.GetBAL ();
	spy_rec.spy_sync			= sync.GetSem ();
	spy_rec.spy_name[0]			= 0;
	spy_rec.do_spy_open_close	= TRUE;
	spy_rec.do_spy_read			= FALSE;
	spy_rec.do_spy_write		= TRUE;
	spy_rec.do_spy_cre_del		= TRUE;
	
	return send_command (& spy_rec, sizeof (spy_rec));
}


/*
 *	Transforme le fichier en buffer circulaire asynchrone, ce qui
 *	nous permet de lire les donnes crites sans gaspiller des
 *	tonnes de RAM prcieuse.
 */

int
setup_sync_file (const char* file)
{
	NifCmdSync sync_rec;
	
	sync_rec.nif_id				= NIF_SYNC;
	sync_rec.name				= file;
	sync_rec.cycle_len			= 1000;
	sync_rec.do_sync			= FALSE;
	sync_rec.do_cycle			= TRUE;
	sync_rec.do_dummy_cre_del	= FALSE;
	
	return send_command (& sync_rec, sizeof (sync_rec));
}


/*
 *	Supprime une activit d'espionnage sur un fichier.
 */

int
finish_spy (const char* name)
{
	NifCmdSpy spy_rec;
	
	spy_rec.nif_id				= NIF_SPY;
	spy_rec.name				= name;
	spy_rec.spy_id				= 0;
	spy_rec.spy_bal				= 0;
	spy_rec.spy_sync			= 0;
	spy_rec.spy_name[0]			= 0;
	spy_rec.do_spy_open_close	= FALSE;
	spy_rec.do_spy_read			= FALSE;
	spy_rec.do_spy_write		= FALSE;
	spy_rec.do_spy_cre_del		= FALSE;
	
	return send_command (& spy_rec, sizeof (spy_rec));
}


