/*
 *	fos.cc
 *	
 *	Interface pour le File Operating System du Smaky.
 *
 *	(C) 1992-1995  Pierre ARNAUD & EPSITEC-system SA
 *
 */

#include "fos.h"

int
FOS::What (const char* name, Card16& type)
{
	Card16 er;
  	
	asm volatile ( "movel %2,a3\n\t"
  				   ".long 0x4e45005e\n\t"
  				   "movew d3,%0\n\t"
  				   "movew d7,%1"
  				 : "=m" (type), "=g" (er)
  				 : "p" (name)
  				 : "a3", "d3", "d7" );
	
	return er;
}



int
FOS::Open (const char* name, Card32 mode, Card16& can)
{
	Card16 er;
	
	asm volatile ( "movel %2,a3\n\t"
				   "movel %3,d3\n\t"
				   ".long 0x4e45004a\n\t"
				   "movew d6,%0\n\t"
				   "movew d7,%1"
				 : "=m" (can), "=g" (er)
				 : "p" (name), "g" (mode)
				 : "a3", "d3", "d6", "d7" );
	
	return er;
}



int
FOS::ArgsOpen (const char* name, Card32 mode, SmakyArgs& args, Card16& can)
{
	Card16 er;
	
	mode |= FOS_OPEN_ARGS;
	
	asm volatile ( "movel %2,a3\n\t"
				   "movel %3,d3\n\t"
				   "movel %4,a4\n\t"
				   ".long 0x4e45004a\n\t"
				   "movew d6,%0\n\t"
				   "movew d7,%1"
				 : "=m" (can), "=g" (er)
				 : "p" (name), "g" (mode), "p" (&args)
				 : "a3", "a4", "d3", "d6", "d7" );
	
	return er;
}


int
FOS::Close (Card16 can)
{
	Card16 er;
	
	asm volatile ( "movew %1,d6\n\t"
				   ".long 0x4e450005\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (can)
				 : "d6", "d7" );
	
	return er;
}


int
FOS::CloseMDC (Card16 can, const SmakyDate& datim)
{
	Card16 er;
	
	Card32 hhmmss = (datim.hour << 16) | (datim.minute << 8) | (datim.second);
	Card32 jjmmaa = (datim.day  << 16) | (datim.month  << 8) | (datim.year);
	
	asm volatile ( "movew %1,d6\n\t"
				   "movel %2,d3\n\t"
				   "movel %3,d4\n\t"
				   ".long 0x4e45002b\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (can), "g" (hhmmss), "g" (jjmmaa)
				 : "d3", "d4", "d6", "d7" );
	
	return er;
}


int
FOS::Read (Card16 can, Card32& size, void* buffer)
{
	Card16 er;
	
	asm volatile ( "movew %2,d6\n\t"
				   "movel %1,d4\n\t"
				   "movel %3,a4\n\t"
				   ".long 0x4e450001\n\t"
				   "movel d4,%1\n\t"
				   "movew d7,%0\n\t"
				 : "=g" (er), "=g" (size)
				 : "g" (can), "g" (buffer)
				 : "d4", "d6", "d7", "a4" );
	
	return er;
}


int
FOS::Write (Card16 can, Card32& size, const void* buffer)
{
	Card16 er;
	
	asm volatile ( "movew %2,d6\n\t"
				   "movel %1,d4\n\t"
				   "movel %3,a4\n\t"
				   ".long 0x4e450002\n\t"
				   "movel d4,%1\n\t"
				   "movew d7,%0\n\t"
				 : "=g" (er), "=g" (size)
				 : "g" (can), "g" (buffer)
				 : "d4", "d6", "d7", "a4" );
	
	return er;
}


int
FOS::SetPos (Card16 can, Card32 pos)
{
	Card8 high = (pos == 0xFFFFFFFF) ? 0xFF : 0x00;
	Card16 er;
	
	asm volatile ( "moveb %1,d3\n\t"
				   "movel %2,d4\n\t"
				   "movew %3,d6\n\t"
				   ".long 0x4e450004\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (high), "g" (pos), "g" (can)
				 : "d3", "d4", "d6", "d7" );
	
	return er;
}


int
FOS::GetPos (Card16 can, Card32& pos)
{
	Card8 high = 0;
	Card16 er;
	
	asm volatile ( "movew %3,d6\n\t"
				   ".long 0x4e450003\n\t"
				   "movew d7,%0\n\t"
				   "moveb d3,%1\n\t"
				   "movel d4,%2"
				 : "=g" (er), "=g" (high), "=g" (pos)
				 : "g" (can)
				 : "d3", "d4", "d6", "d7" );
	
	if (high) pos = 0xFFFFFFFF;
	
	return er;
}


int
FOS::Trunc (Card16 can)
{
	Card16 er;
	
	asm volatile ( "movew %1,d6\n\t"
				   ".long 0x4e450035\n\t"
				   "movew d7,%0"
				 : "=g" (er)
				 : "g" (can)
				 : "d6", "d7" );
	
	return er;
}


int
FOS::Create (const char* name, Card32 attr)
{
	Card16 er;
  	
	asm volatile ( "moveql #0,d4\n\t"
				   "movel %1,d3\n\t"
				   "movel %2,a3\n\t"
  				   ".long 0x4e450006\n\t"
  				   "movew d7,%0"
  				 : "=g" (er)
  				 : "g" (attr), "p" (name)
  				 : "a3", "d3", "d4", "d7" );
	
	return er;
}


int
FOS::Delete (const char* name)
{
	Card16 er;
  	
	asm volatile ( "movel %1,a3\n\t"
  				   ".long 0x4e450007\n\t"
  				   "movew d7,%0"
  				 : "=g" (er)
  				 : "p" (name)
  				 : "a3", "d7" );
	
	return er;
}



