/*
 *
 *	fos.h - Interface pour le File Operating System du Smaky.
 *
 *	(C) 1992-1995  Pierre ARNAUD & EPSITEC-system SA
 *
 */

#ifndef _FOS_H_
#define _FOS_H_

#include "smakyargs.h"

class FOS
{
public:
	static int What (const char* name, Card16& type);
	static int Open (const char* name, Card32 mode, Card16& can);
	static int ArgsOpen (const char* name, Card32 mode, SmakyArgs& args, Card16& can);
	static int Close (Card16 can);
	static int CloseMDC (Card16 can, const SmakyDate& datim);
	static int Read (Card16 can, Card32& size, void* buffer);
	static int Write (Card16 can, Card32& size, const void* buffer);
	static int SetPos (Card16 can, Card32 pos);
	static int GetPos (Card16 can, Card32& pos);
	static int Trunc (Card16 can);
	static int Create (const char* name, Card32 attr);
	static int Delete (const char* name);
};

#endif

