/*
 *	ntrel.h
 *
 *	Interface avec les services du Noyau Temps Rel.
 *
 *	(C) 1994,  Pierre ARNAUD, CH-1437 SUSCEVAZ
 *
 */

/*
 *	DM	25/07/94	BALs
 *	EBK				slections synchrones
 *					gestion du temps
 */

#ifndef _NTREL_H_
#define _NTREL_H_

#include "portable.h"


/*
 *	La classe NtrBar interface l'accs aux botes  rendez-vous
 *	du noyau temps rel.
 */

class NtrBar
{
	void*		bar;
	Card16		error;
	Bool		need_kill;

public:
	NtrBar (const char* name, Card32 mode = 0);
	NtrBar (Card32 bar) { this->bar = (void*)(bar); this->error = 0; this->need_kill = FALSE; }
	~NtrBar ();
	
	void Accept (void*& ptr);
	void EndAccept (void* ptr);
	void Offer ();
	void EndOffer (void* in_ptr, void*& out_ptr);
	
	Card16 GetError () const { return this->error; }
	void* GetBar () const { return this->bar; }
};


#define	BAL_COPY_MESSAGE	(1 << 1)


/*
 *  La classe NtrBAL interface l'accs aux botes aux
 *  lettres.
 */

class NtrBAL
{
	void*	bal;
	Card16	error;
	Bool	kill;
 
 public:
 	NtrBAL (Card16 limit = 0xffff);
 	NtrBAL (void *bal);
 	~NtrBAL ();
 	
 	//	Give number
	
	void GiveMessage (Card32 message);
	void GiveMessage (void *message, Card32 length, Card8 mode);
	
	//	Get message without copy
	
 	void GetMessage (void*& message, Card32& length, Card8& mode);
 	
 	//	Get message with copy
 	
 	void GetMessage (void* message, Card32& length, Card32& number, Card8& mode);
 
 	Card16 GetError () const { return this->error; }
	void* GetBAL () const { return this->bal; }
};


/*
 *	La classe NtrLock interface l'accs aux smaphores
 *	d'exclusion.
 */

class NtrLock
{
	void*		sem;
	short		error;
	
public:
	NtrLock ();
	~NtrLock ();
	
	void Enter ();
	void Release ();
	
	int GetError () const { return this->error; }
	void* GetSem () const { return this->sem; }
};


class AutoLock
{
	NtrLock*	lock;
public:
	AutoLock (NtrLock& lock) { this->lock = & lock; this->lock->Enter (); }
	AutoLock (NtrLock* lock) { this->lock = lock;   this->lock->Enter (); }
	~AutoLock () { this->lock->Release (); }
};


/*
 *	La classe NtrSync interface l'accs aux smaphores
 *	de synchronisation.
 */

class NtrSync
{
	void*		sem;
	Bool		created;
	short		error;
	
public:
	NtrSync ();
	NtrSync (void* s) : sem (s), created (FALSE) { }
	~NtrSync ();
	
	void Wait (Card16 timeout = 0xFFFF);
	void Signal ();
	void SingleSignal ();
	
	int GetError () const { return this->error; }
	void* GetSem () const { return this->sem; }
};


/*
 *	La classe NtrSel interface l'accs aux slections
 *	multiples.
 *	Une instance de NtrSel ne doit tre utilise que
 *	par le processus qui l'a cre !
 */

#define NTR_NB_SELS 10

class NtrSel
{
private:
	enum SyncType
	{
		SYNC_TYPE_OFFER = 0,
		SYNC_TYPE_ACCEPT = 2,
		SYNC_TYPE_SYNC = 4,
		SYNC_TYPE_LOCK = 6
	};
	
	struct SyncItem
	{
		Card32		index;
		Card8		type;
		Card8		reserve1;
		void		*id;
		Card32		aux1;
		Card32		aux2;
	};
	
	struct SyncRecord
	{
		Card16		sel_num;
		Card16		reserve1;
		Card32		timeout;
		Card32		reserve2;
		SyncItem	item[NTR_NB_SELS];
	};
	
	SyncRecord	*sync_rec;
	SyncRecord	local_sync_rec;
	Card16		sel_num;						// VRAI nombre de slections
	
	void ReadSyncRecord ();

public:
	NtrSel ();
	~ NtrSel ();
	
	void AddAcceptBar (NtrBar *bar, Card32 ident);
//	void AddOfferBar (NtrBar *bar, Card32 ident);
	void AddSync (NtrSync *sync, Card32 ident);
//	void AddLock (NtrLock *lock, Card32 ident);
	
	Card16 Sync (Card32& ident, void*& accept_result);
};


/*
 *	Interface aux services globaux du noyau temps rel.
 */

class Ntr
{
public:
	static void GetTimeMS (Card32& time);
	static void GetCPTime (Card32& time);
	static void GetPrTime (Card32& time);
	static void GetSyTime (Card32& proctime, Card32& idletime);
	
	static void SetTim (Card16 timeout);
	static Card16 GetTim ();
	static Card16 ModTim (Card16 timeout);
	
	static void Dels (Card16 n);
	static void Delms (Card16 n);
	
	static void GetTaskPtr (void*& ptr);
	static void GetFatherTaskPtr (void *ptr, void*& father);
	
	static void CreTask (void (*startaddr)(Card32), long stacklength,
						 int prioattr, const char* name, Card32 param,
						 Card32 sema, Card32* pid, Card16* pino);
	static void WFAbDesc ();
};


#endif /* _NTREL_H_ */

