/*
 *	efscreate.cc
 *
 *	Gre la cration, la destruction, le dplacement et le changement de
 *	nom des divers fichiers.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "efs.h"
#include "node.h"
#include "errors.h"
#include "misc.h"
#include "smakyargs.h"

/*
 *	Cre un nouveau fichier.
 */

void
EFS::Create (const char* name, Card32 attr, Int16& err)
{
	FileNode* file = FileNode::Find (this->node, name);
	FileNode* dir  = FileNode::Find (this->node, name, TRUE);
	
	if (dir == 0) {
		err = ERR_INVALID_PATH;
		return;
	}
	
	if (file) {
		
		if (file->IsMirror ()) {
			err = file->ShadowCreate ();
		} else if (file->IsDummyCreDel ()) {
			err = ERR_OK;
		} else {
			err = ERR_FILE_EXISTS;
		}
		
		return;
	}
	
	file = new FileNode (skip_dir (name), dir);
	err  = ERR_OK;
	
	if (file == 0) {
		err = ERR_NO_MEM;
		return;
	}
	
	file->SetDelOk ((attr & ATTR_DELETE) ? TRUE : FALSE);
	file->SetHidden ((attr & ATTR_LIST) ? FALSE : TRUE);
}


/*
 *	Supprime un fichier existant.
 */

void
EFS::Delete (const char* name, Card32 mode, Int16& err)
{
	FileNode* file = FileNode::Find (this->node, name);
	
	if (file == 0) {
		err = ERR_FILE_NOT_FOUND;
		return;
	}
	
	if (file->IsDummyCreDel ()) {
		err = ERR_OK;
		return;
	}
	
	if (file->ChannelCount ()) {
		err = ERR_FILE_IN_USE;
		return;
	}
	
	if (file->IsDelOk () == FALSE) {
		err = ERR_FILE_NO_DEL;
		return;
	}
	
	if (file->IsMirror ()) {
		err = file->ShadowDelete ();
		return;
	}
	
	delete file;
	err = ERR_OK;
}


/*
 *	Renomme un fichier.
 */

void
EFS::Rename (const char* name_src, const char* name_dst, Int16& err)
{
	FileNode*   file = FileNode::Find (this->node, name_src);
	const char* name = skip_dir (name_dst);
	
	if (file == 0) {
		err = ERR_FILE_NOT_FOUND;
		return;
	}
	
	file->SetName (name);
	err = ERR_OK;
}


/*
 *	Dplace un fichier... Ceci n'est pour l'heure pas implment
 *	et retourne une erreur bidon.
 */

void
EFS::Move (const char* name_src, const char* name_dst, Int16& err)
{
	err = ERR_NOT_IMPLEMENTED;
}


/*
 *	Cherche le bon niveau pour crer un dossier. Utilise cette
 *	fonction de manire rcursive...
 */

static void
create_directory (const char* name, FileNode* root, Int16& err)
{
	char buffer[16];
	
	extract_name (name, buffer);
	name = skip_name (name);
	
	if (name == 0) {
		
		FileNode* node = FileNode::Find (root, buffer);
		
		if (node) {
			err = ERR_FILE_EXISTS;
			return;
		}
		
		node = new FileNode (buffer, root);
		err  = (node) ? ERR_OK : ERR_NO_MEM;
		return;
	}
	
	create_directory (name, FileNode::Find (root, buffer), err);
}

/*
 *	Cre un dossier.
 */

void
EFS::CDir (const char* name, Int16& err)
{
	create_directory (name, this->node, err);
}


