/*
 *	efslist.cc
 *
 *	Gre des oprations diverses sur les fichiers.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "efs.h"
#include "node.h"
#include "misc.h"
#include "errors.h"
#include "smakyargs.h"


/*
 *	Ouvre une liste pour extraire des noms de fichiers. Compte
 *	le nombre de fichier contenus.
 */

void
EFS::ListOpen (const char* dir, const char* crit, Card32 mode,
               Card32& ch, Card32& num, Card32& id, Int16& err)
{
	if (dir == 0) dir = "";
	if (crit == 0) crit = "";
	
	ch  = 0;
	num = 0;
	id  = 0;
	
	FileNode* parent = FileNode::Find (this->node, dir);
	
	if (parent == 0) {
		err = ERR_INVALID_PATH;
		return;
	}
	
	FileNode* node = parent->Children ();
	ListInfo* list = new ListInfo;
	
	if (list == 0) {
		err = ERR_NO_MEM;
		return;
	}
	
	ch  = (Card32)(list);
	id  = (Card32)(parent);
	err = ERR_OK;
	
	list->current   = node;
	list->b_dossier = (mode & LIST_DIR) ? TRUE : FALSE;
	
	while (node) {
		num += 1;
		node = node->Next ();
	}
}


/*
 *	Liste un ou plusieurs lments...
 */

void
EFS::ListBuf (Card32 ch, Card32& len, Card8* p_args, Int16& err)
{
	SmakyNameArgs* args = (SmakyNameArgs*)(p_args);
	Card32         num  = len / 64;
	Card32         size = 0;
	SmakyDate      date = { 0x01, 0x01, 0x80, 0x12, 0x00, 0x00 };
	ListInfo*      list = (ListInfo*)(ch);
	FileNode*      node = list->current;
	
	while (node && num--) {
		
		list->current = node->Next ();
		size         += 64;
		
		strcpy (args->name, node->Name ());
		args->d_create   = date;
		args->d_modif    = date;
		args->d_use      = date;
		args->type       = 0;
		args->open       = 0;
		args->attr       = ATTR_DEFAULT | (node->IsDir () ? ATTR_DIR : 0)
										| (node->IsHidden () ? 0 : ATTR_LIST)
										| (node->IsDelOk () ? ATTR_DELETE : 0);
		args->length     = node->FileLength ();
		args->block_num  = (args->length+255) / 256;
		args->block_last = args->length - args->block_num * 256;
		args->code       = 0;
		args->rank       = num ? (Card32)(args + 1) : 0;
		
		if ( (node->IsDir ())
		  && (list->b_dossier == FALSE) ) {
			
			//	Remplace le nom "TOTO:" par "TOTO.DIR" comme cela a t demand
			//	par l'appelant.
			
			char* name = args->name;
			while ((name[0]) && (name[0] != ':')) name++;
			
			name[0] = '.'; name[1] = 'D'; name[2] = 'I'; name[3] = 'R';
			name[4] = 0;
		}
		
		node = node->Next ();
		args++;
	}
	
	err = ERR_OK;
	len = size;
}


/*
 *	Termine une opration de listage.
 */

void
EFS::ListClose (Card32 ch, Int16& err)
{
	delete (ListInfo*)(ch);
	err = ERR_OK;
}



