/*
 *	efsmisc.cc
 *
 *	Gre des oprations diverses sur les fichiers.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "efs.h"
#include "node.h"
#include "errors.h"
#include "smakyargs.h"


/*
 *	Change les attributs du fichier. Ceci est accept mais ne fait pas
 *	grand chose...
 */

void
EFS::Chatr (const char* name, Card32 attr, Int16& err)
{
	FileNode* file = FileNode::Find (this->node, name);
	
	if (file == 0) {
		err = ERR_FILE_NOT_FOUND;
		return;
	}
	
	file->SetDelOk ((attr & ATTR_DELETE) ? TRUE : FALSE);
	file->SetHidden ((attr & ATTR_LIST) ? FALSE : TRUE);
	
	err = ERR_OK;
}


/*
 *	Regarde si un fichier est actuellement ouvert.
 */

void
EFS::IfOpen (const char* name, Int16& err)
{
	FileNode* file = FileNode::Find (this->node, name);
	
	if (file == 0) {
		err = ERR_FILE_NOT_FOUND;
		return;
	}
	
	if (file->ChannelCount ()) {
		err = ERR_FILE_IN_USE;
		return;
	}

	err = ERR_OK;
}


/*
 *	Retourne les arguments du fichier en cours. Ceci est du
 *	bricolage "maison".
 */

void
EFS::Args (const char* name, Card16 mode, Card8* p_args,
		   Card16& count, Int16& err)
{
	FileNode*  file = FileNode::Find (this->node, name);
	SmakyArgs* args = (SmakyArgs*)(p_args);
	SmakyDate  date = { 0x01, 0x01, 0x80, 0x12, 0x00, 0x00 };
	
	if (file == 0) {
		err = ERR_FILE_NOT_FOUND;
		return;
	}
	
	err   = ERR_OK;
	count = file->ChannelCount ();
	
	args->d_create   = date;
	args->d_modif    = args->d_create;
	args->d_use      = args->d_create;
	args->type       = 0;
	args->open       = count;
	
	args->attr       = ATTR_DEFAULT | (node->IsDir () ? ATTR_DIR : 0)
									| (node->IsHidden () ? 0 : ATTR_LIST)
									| (node->IsDelOk () ? ATTR_DELETE : 0);
	
	args->length     = file->FileLength ();
	args->block_num  = (args->length+255) / 256;
	args->block_last = args->length - args->block_num * 256;
	args->code       = 0;
}


/*
 *	Ferme tous les canaux ouverts. Ceci n'est pas accept
 *	et c'est pour cela que l'on retourne une erreur si le
 *	fichier est encore utilis.
 */

void
EFS::Clear (const char* name, Int16& err)
{
	this->IfOpen (name, err);
}


/*
 *	Retourne des informations fantaisistes au sujet de la
 *	taille du File System.
 */

void
EFS::Disk (const char* name, Card32& free, Card32& used, Int16& err)
{
	free = 1000;		//	soi-disant 256 * 1000 bytes libres
	used = 1000;		//	soi-disant 256 * 1000 bytes occups
	err  = ERR_OK;
}

