/*
 *	misc.cc
 *
 *	Utilitaires...
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "misc.h"

Card8
make_bcd (Card8 bin)
{
	Card8 bcd = (bin / 10) * 16 + (bin % 10);
	return bcd;
}


/*
 *	Extrait le premier nom (fichier, dossier) et copie le dans
 *	le buffer pass en entre. Le nom sera termin par un 0.
 */

void
extract_name (const char* name, char* buffer)
{
	if (name == 0) {
		buffer[0] = 0;
		return;
	}
	
	char* start = buffer;
	Bool is_dir = FALSE;
	int  count  = 15;
	int  numc   = 0;
	char code   = 0;
	
	while (count--) {
		code    = *name++;
		is_dir  = (code == ':') ? TRUE : FALSE;
		
		if ( (code == 0) || (code == ' ') || (code == '/') || (code == '|')
		  || (code == '\t') || (code == '\r') || (code == '\n') || (code == ':') ) {
			break;
		}
		
		*buffer++ = code;
		numc++;
	}
	
	if (numc > 3) {
		if ( (buffer[-1] == 'R')
		  && (buffer[-2] == 'I')
		  && (buffer[-3] == 'D')
		  && (buffer[-4] == '.') ) {
			is_dir = TRUE;
			buffer -= 4;
		}
	}
	
	if (is_dir) {
		*buffer++ = ':';
	}
	
	*buffer = 0;
}



/*
 *	Avance le pointeur sur la suite du nom (dossier ou fichier)
 *	ou retourne un pointeur nul si la fin est atteinte.
 */

const char*
skip_name (const char* name)
{
	Bool is_dir = FALSE;
	char code   = 0;
	
	for (;;) {
		code    = *name;
		
		if ( (code == 0) || (code == ' ') || (code == '/') || (code == '|')
		  || (code == '\t') || (code == '\r') || (code == '\n') ) {
			return 0;
		}
		
		if (is_dir) {
			break;
		}
		
		is_dir  = (code == ':') ? TRUE : FALSE;
		name++;
	}
	
	return name;
}


/*
 *	Avance le pointeur sur le dbut du nom du fichier en
 *	sautant tout ce qui est dossier.
 */

const char*
skip_dir (const char* name)
{
	const char* dir = name;
	
	while (name) {
		name = skip_name (name);
		if (name == 0) break;
		dir = name;
	}
	
	if (dir) {
		char buffer[16];
		extract_name (dir, buffer);
		
		//	Vrifie que le dernier lment trouv n'est pas lui
		//	aussi un dossier...
		
		if (is_dir_name (buffer)) return 0;
	}
	
	return dir;
}


/*
 *	Avance le pointeur sur le dbut du nom du dernier fichier
 *	ou dossier.
 */

const char*
skip_to_last (const char* name)
{
	const char* dir = name;
	
	while (name) {
		name = skip_name (name);
		if (name == 0) break;
		dir = name;
	}
	
	return dir;
}


/*
 *	Retourne TRUE si le nom (termin par un 0) est un nom de
 *	dossier.
 */

Bool
is_dir_name (const char* name)
{
	if (name[0]) {
		while (name[1]) name++;
	}
	
	return (name[0] == ':') ? TRUE : FALSE;
}


