/*
 *	nif.h
 *
 *	Interface avec les noeuds des fichiers. Ceci peut tre utile pour grer
 *	des fichiers particuliers depuis le monde extrieur.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */


#ifndef _NIF_H_
#define _NIF_H_

#include <c++/portable.h>

#define	NIF_SPY		0x00000001
#define	NIF_MIR		0x00000002
#define	NIF_SYNC	0x00000003

#define	SPY_OPEN	0x00000001
#define	SPY_CLOSE	0x00000002
#define	SPY_READ	0x00000003
#define	SPY_WRITE	0x00000004
#define	SPY_CREATE	0x00000005
#define	SPY_DELETE	0x00000006


/*
 *	Lorsqu'un vnement  espionner survient, la structure suivante
 *	est transmise par l'intermdiaire d'une bote aux lettres :
 */

struct SpyRecord
{
	Card32			event;						//	type de l'vnement SPY_..
	Card32			reserved;					//	rserve (0)
	Card32			id;							//	identificateur de l'espion (spy_id)
	const char*		name;						//	nom de l'espion (spy_name)
	Card32			arg_1;						//	argument 1
	Card32			arg_2;						//	argument 2
};

/*	Les arguments sont les suivants :													*
 *																						*
 *	SPY_OPEN ()						-													*
 *	SPY_CLOSE ()					-													*
 *	SPY_READ (pos, len)				la position de dpart et la taille de la lecture	*
 *	SPY_WRITE (pos, len)			la position de dpart et la taille de l'criture	*
 *	SPY_CREATE (name)				le nom du fichier/dossier cr						*
 *	SPY_DELETE (name)				le nom du fichier/dossier dtruit					*/


/*
 *	Base des commandes...
 */

struct NifCmdBase
{
	Card32			nif_id;						//	identificateur de commande
	const char*		name;						//	nom du fichier auquel la commande s'applique
};


/*
 *	Espionne un dossier ou un fichier dj existant.
 */

struct NifCmdSpy : NifCmdBase
{
	Card32			spy_id;						//	identificateur pour l'espionnage
	void*			spy_bal;					//	BAL rserve pour l'espion
	void*			spy_sync;					//	smaphore de synchro
	char			spy_name[32];				//	nom du noeud pour l'espionnage
	
	Bool			do_spy_open_close;			//	TRUE => signale ouvertures/fermetures
	Bool			do_spy_read;				//	TRUE => signale les lectures
	Bool			do_spy_write;				//	TRUE => signale les critures
	Bool			do_spy_cre_del;				//	TRUE => signale create/delete
};


/*
 *	Cre un fichier qui reflte un fichier mirroir.
 *
 *	Le champ `name' dcrit le nom du dossier dans lequel le fichier
 *	sera reflt sous le nom `new_file'.
 */

struct NifCmdMir : NifCmdBase
{
	const char*		mirror;						//	nom du fichier mirroir (qui sera accd)
	const char*		new_file;					//	nom du nouveau fichier (accdant au mirroir)
	
	Bool			do_auto_create;				//	TRUE => cre le fichier si ncessaire
	Bool			do_silent_create;			//	TRUE => ne dit rien si le fichier existe dj
	Bool			do_real_delete;				//	TRUE => dtruit vraiment le fichier au DELETE
	Bool			reserved;
};


/*
 *	Cre un fichier de communication synchrone, ce qui permet de
 *	raliser un PIPE ou une BAL  bon compte,  partir d'un fichier
 *	dj existant.
 */

struct NifCmdSync : NifCmdBase
{
	Card32			cycle_len;					//	taille de la partie cyclique
	
	Bool			do_sync;					//	TRUE => fichier synchrone
	Bool			do_cycle;					//	TRUE => fichier cyclique
	Bool			do_dummy_cre_del;			//	TRUE => fichier avec CREATE/DELETE bidon
};

#endif


