/*
 *	node.cc
 *
 *	Gestion d'un file system parallle  celui du FOS bas sur des
 *	enregistrements du type FileNode.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#pragma implementation "node.h"

#include <string.h>
#include <c++/ntrel.h>

#include "node.h"
#include "misc.h"
#include "nif.h"
#include "channel.h"


/*
 *	Cre un noeud vide. Connecte au pre et insre dans la liste
 *	des fils si besoin est.
 */

FileNode::FileNode (const char* name, FileNode* parent)
{
	this->next              = 0;
	this->prev              = 0;
	
	extract_name (name, this->name);
	this->name_len          = strlen (this->name);
	
	this->parent            = parent;
	this->children          = 0;
	
	this->data              = 0;
	this->file_length       = 0;
	
	this->channel_count     = 0;
	SETEACH (this->channel) = 0;
	
	this->is_dir            = is_dir_name (this->name);
	this->is_del_ok         = FALSE;
	this->is_hidden         = FALSE;
	this->is_alive          = TRUE;
	this->is_mirror         = FALSE;
	this->is_sync           = FALSE;
	this->is_cycle          = FALSE;
	this->is_dummy_cre_del  = FALSE;
	
	this->cycle_len         = 0;
	this->cycle_buffer      = 0;
	
	this->spy_id            = 0;
	this->spy_name[0]       = 0;
	this->spy_bal           = 0;
	
	this->do_spy_open_close = FALSE;
	this->do_spy_read       = FALSE;
	this->do_spy_write      = FALSE;
	this->do_spy_cre_del    = FALSE;
	
	//	Insre dans la liste du pre (si elle existe), on ne se fait
	//	aucun souci au sujet de la position de l'insertion : toujours
	//	en tte, a ne fait rien...
	
	if (parent) {
		
		this->next       = parent->children;
		parent->children = this;
		
		if (this->next) this->next->prev = this;
		if (this->parent->do_spy_cre_del) this->parent->SpyReport (SPY_CREATE, (Card32)(this->name));
	}
}


/*
 *	Supprime un noeud de la hirarchie. Supprime aussi tous les sous-
 *	noeuds.
 */

FileNode::~FileNode ()
{
	if (this->parent) {
		if (this->next) this->next->prev = this->prev;
		if (this->prev) this->prev->next = this->next;
		if (this->parent->children == this) this->parent->children = this->next;
		if (this->parent->do_spy_cre_del) this->parent->SpyReport (SPY_DELETE, (Card32)(this->name));
	}
	
	while (this->children) {
		delete this->children;
	}
	
	FOREACH (this->channel, index) {
		if (this->channel[index]) {
			delete this->channel[index];
		}
	}
	
	while (this->data) {
		FileData* iter = this->data;
		this->data     = iter->next;
		delete iter;
	}
}


/*
 *	Modifie le nom du noeud. C'est simple...
 */

void
FileNode::SetName (const char* name)
{
	extract_name (name, this->name);
	this->name_len = strlen (this->name);
}


/*
 *	Dfinit l'tat de l'espion.
 */

void
FileNode::SetupSpy (Card32 id, const char* name, void* bal, void* sync)
{
	this->spy_id   = id;
	this->spy_bal  = new NtrBAL (bal);
	this->spy_sync = (sync == 0) ? (NtrSync*)(0) : new NtrSync (sync);
	
	strcpy (this->spy_name, name);
}


/*
 *	Dfinit la taille du buffer cyclique.
 */

void
FileNode::SetCycleLen (Card32 len)
{
	if ( (this->cycle_len == len)
	  && (this->cycle_buffer) ) {
		return;
	}
	
	if (this->cycle_buffer) {
		delete this->cycle_buffer;
		this->cycle_buffer = 0;
	}
	
	this->cycle_buffer = new Card8[len];
	this->cycle_len    = len;
}



/*
 *	Initialise une hirarchie de noeuds. Retourne le pointeur  la
 *	racine.
 */

FileNode*
FileNode::Init (const char* name)
{
	FileNode* root = new FileNode (":");
	FileNode* node = new FileNode (name, root);

	root->SetDelOk (FALSE);
	node->SetDelOk (FALSE);
	
	return root;
}


/*
 *	Dtruit une hirarchie de noeuds depuis la racine.
 */

void
FileNode::Kill (FileNode* node)
{
	delete node;
}


/*
 *	Trouve un noeud et retourne le pointeur qui le dcrit.
 *	Retourne 0 si l'on ne trouve pas le noeud.
 */

FileNode*
FileNode::Find (FileNode* root, const char* name, Bool is_dir)
{
	char buffer[16];
	int  len;
	
	extract_name (name, buffer);
	
	name = skip_name (name);
	len  = strlen (buffer);
	
	//	La recherche se termine si l'on cherche un dossier et que l'on
	//	a spcifi un nom de fichier ou si le nom spcifi est vide.
	
	if ( ((is_dir) && (is_dir_name (buffer) == FALSE))
	  || (buffer[0] == 0) ) {
		return root;
	}
	
	root = root->children;
	
	while (root) {
				
		if ( (root->name_len == len)
		  && (strcmp (root->name, buffer) == 0) ) {
			
			//	Trouv le noeud qui mne  notre fichier tant dsir.
			
			if (name) {
				
				//	Si le nom a t puis, cela signifie que ce n'est plus
				//	ncessaire de chercher plus loin. Sinon, continue dans
				//	les sous-dossiers.
				
				root = FileNode::Find (root, name, is_dir);
			}
			
			break;
		}
		
		root = root->next;
	}
	
	return root;
}


