/*
 *	nodecmd.cc
 *
 *	Noeud particulier permettant de grer des commandes.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */

#include "nif.h"
#include "errors.h"
#include "nodecmd.h"
#include "nodemirror.h"


FileNodeCommand::FileNodeCommand (const char* name, FileNode* parent)
	: FileNode (name, parent)
{
	this->tree = 0;
}

FileNodeCommand::~FileNodeCommand ()
{
}

#if 0
	static inline void AfX8 (Card32 x) {
		asm (	"movel	%0,d4\n\t"
				".word	0xa032\n\t"
			: : "g" (x) : "d4", "d7" );
	}
	static inline void AfText (const char *text) {
		asm (	"movel	%0,a3\n\t"
			".word	0xa040\n\t"
			: 
			: "g" (text) : "a3", "d7" );
	}
#endif

/*
 *	Excute une commande. Ceci permet de mettre en place un systme
 *	d'espionnage pour un fichier.
 */

void
FileNodeCommand::WriteData (Card32& pos, Card32& len, const Card8* data, Int16& err)
{
	err = ERR_OK;
	
	if (this->tree) {
		
		const NifCmdBase* nif  = (const NifCmdBase*)(data);
		const NifCmdSpy*  spy  = (const NifCmdSpy*)(data);
		const NifCmdMir*  mir  = (const NifCmdMir*)(data);
		const NifCmdSync* sync = (const NifCmdSync*)(data);
		const char*       name = nif->name;
		FileNode*         root = FileNode::Find (this->tree, name);
		FileNodeMirror*   nmir = 0;
		
//		AfText ("Command name="); AfText (name); AfText (", root="); AfX8 ((Card32)(root)); AfText ("\r");
		
		if (root) {
			switch (nif->nif_id) {
				
				case NIF_SPY:
					root->SetupSpy (spy->spy_id, spy->spy_name, spy->spy_bal, spy->spy_sync);
					root->DoSpyOpenClose (spy->do_spy_open_close);
					root->DoSpyRead (spy->do_spy_read);
					root->DoSpyWrite (spy->do_spy_write);
					root->DoSpyCreateDelete (spy->do_spy_cre_del);
					break;
				
				case NIF_MIR:
					nmir = new FileNodeMirror (mir->new_file, root);
					nmir->SetMirror (mir->mirror);
					nmir->SetAutoCreate (mir->do_auto_create);
					nmir->SetSilentCreate (mir->do_silent_create);
					nmir->SetRealDelete (mir->do_real_delete);
					break;
				
				case NIF_SYNC:
					root->SetSync (sync->do_sync);
					root->SetCycle (sync->do_cycle);
					root->SetDummyCreDel (sync->do_dummy_cre_del);
					root->SetCycleLen (sync->cycle_len);
					break;
				
				default:
					break;
			}
			
			return;
		}
		
		return;
	}
	
	err = ERR_NOT_OK;
	len = 0;
}


