/*
 *	nodemirror.h
 *
 *	Noeud particulier permettant de grer des fichiers mirroirs.
 *
 *	(C) Copyright 1995, Pierre Arnaud, OPaC bright ideas, CH-1437 SUSCEVAZ
 */


#ifndef _NODEMIRROR_H_
#define _NODEMIRROR_H_

#include "node.h"

/*
 *	Noeud particulier permettant de grer des fichiers mirroirs.
 */

class FileNodeMirror : public FileNode
{
	
private:
	char			mirror[200];				//	nom du fichier rel
	Card16			channel;					//	canal associ (si le fichier est ouvert)
	Card16			error;						//	erreur  la dernire ouverture
	
	Bool			is_read_ok;					//	TRUE => lecture ok
	Bool			is_write_ok;				//	TRUE => criture ok
	Bool			is_unit;					//	TRUE => c'est une unit de mmoire de masse
	Bool			is_large_unit;				//	TRUE => c'est une unit avec 32 blocs de dcalage
	
protected:
	Bool			do_auto_create;				//	TRUE => cre le fichier si ncessaire
	Bool			do_silent_create;			//	TRUE => ne dit rien si le fichier existe dj
	Bool			do_real_delete;				//	TRUE => dtruit vraiment le fichier au DELETE
	
protected:
	void OpenIfNeeded ();
	void CloseIfNeeded ();
	
public:
	FileNodeMirror (const char* name = "", FileNode* parent = 0);
	virtual ~ FileNodeMirror ();
	
	void SetMirror (const char* name);
	
	void SetAutoCreate (Bool t)         { this->do_auto_create   = t; }
	void SetSilentCreate (Bool t)       { this->do_silent_create = t; }
	void SetRealDelete (Bool t)         { this->do_real_delete   = t; }
	
	virtual Int16 ShadowCreate ();
	virtual Int16 ShadowDelete ();
	
	virtual void ReadData (Card32& pos, Card32& len, Card8* data, Int16& err);
	virtual void WriteData (Card32& pos, Card32& len, const Card8* data, Int16& err);
	virtual void Resize (Card32& pos, Int16& err);
	
	virtual void RegisterChannel (int index, FileChannel* channel);
};

#endif

