	.TITLE	ZWIN32.ASD

	.PROC	M68020
	.BASE	10		; base 10 par defaut

	.REF	SMAKY		; reference generale
	.REF	MON
	.REF	BIOSDRIV

MajRev		= 2		; revision majeure
MinRev		= 1		; revision mineure


	.REV	MajRev,MinRev
	.REF	LTIASYNC
	.REF	COMMREQ


;	Dfinitions pour la communication avec le serveur
;	-------------------------------------------------

PORT_NT_REQUEST	= 50

CMD_NEW_PORT	= 1
CMD_KILL_PORT	= 2

CMD_RELEASE	= 10
CMD_CREATE	= 11
CMD_CONNECT	= 12
CMD_DISCONNECT	= 13
CMD_OPEN	= 14
CMD_CLOSE	= 15
CMD_READ	= 16
CMD_WRITE	= 17

;	Structure pour les commandes
;	----------------------------

		.LOC	0

OcmdCMD:	.BLK.16	1		; commande (CMD_xxx)
OcmdRES1:	.BLK.16	1		; rserve (0)
OcmdRES2:	.BLK.32	1		; rserve (0)
OcmdID:		.BLK.32	1		; identificateur ventuel (CMD_KILL_PORT)
OcmdLENGTH:	.BLK.32	1		; longueur des donnes
OcmdBUFFER:	.BLK.32	1		; ^donnes
OcmdNAME:	.BLK.8	200		; nom ventuel
LGCMD:

;	Structure pour les statuts
;	--------------------------

		.LOC	0

OstsERROR:	.BLK.16	1		; erreur en retour
OstsRES1:	.BLK.16	1		; rserve (0)
OstsRES2:	.BLK.32	1		; rserve (0)
OstsID:		.BLK.32	1		; identificateur ventuel (CMD_NEW_PORT)
OstsLENGTH:	.BLK.32	1		; longueur des donnes retournes/lues
LGSTATUS:


		.LOC	0

OBARID:		.BLK.32	1
OSEMID:		.BLK.32	1

OREQUEST:	.BLK.8	RQ_LEN		; requtes
OCOMMAND:	.BLK.8	LGCMD
OSTATUS:	.BLK.8	LGSTATUS

OPORTWR:	.BLK.32	1
OPORTRD:	.BLK.32	1

LGVARMEM:

;***************************
;* *********************** *
;* *   Debut du DRIVER   * *
;* *********************** *
;***************************

	.LOC	0

START:
	.16	10'0,S0BASE	; Pilote 0
	.16	10'1,S1BASE	; Pilote 1
	.16	2**7		; fin 1ere indirection



; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=
;			DRIVER $ZWIN32_0	No H'5A
; =+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=

S0ID:				; Adresse routines
	.16	S0OPEN-S0BASE
	.16	S0COMMAND-S0BASE
	.16	S0STATUS-S0BASE
	.16	S0READ-S0BASE
	.16	S0WRITE-S0BASE
	.16	S0CLOSE-S0BASE
	.16	-1			; STOPTR
	.16	-1			; STARTR
	.16	-1			; AVORTTR
	.16	-1
	.16	-1			; S0AUX2-S0BASE
	.16	S0RESET-S0BASE
	.16	S0KILL-S0BASE
	.16	-1			; S0STRT-S0BASE
	.16	-1			; S0TSTRT-S0BASE
	.16	-1			; S0START-S0BASE

S0NAB:	.ASCII	"ZWIN32_0"		; Nom driver
S0NAF:	.FILL.8 LGDNAM-(S0NAF-S0NAB),0

	.8	16'5A			; Numero driver
	.8	TYPIO			; Type: Streamer

	.8	MAJREV,MINREV		; Revision - version -
	.16	0			; - Variante

	.8	0
	.8	2**BDWROK.OR.2**BDRDOK.OR.2**BDNORT

	.FILL.8 LGDDESC-(APC-S0ID), 0	; Le reste.
S0BASE:

;***************************************************************************************
;--------\
; S0RESET >
;========/
;***************************************************************************************

; Appel lors de l'INSTALL 

; In	A2.32	^ligne de parametres d'installation
; Out	A6.32	^variables globales du pilote
; Mod	rien

S0RESET:
	PUSHM.32 D4|A3|A4|A5

	MOVE.32	#R16^START,A4
	MOVE.32	#LGVARMEM,D4
	FOS	?GETCOMMEM
	MOVE.32	A4,A6

	MOVE.32	#R16^NMCOMMBAR,A3
	MOVE.32	#2**BCBOPEN,D4
	NTREL	?CREBAR			; ouvre la BAR pour la couche de communication
	JUMP,NE	ERR$

	MOVE.32	A5,{A6}+OBARID

	MOVE.32	#0,D4
	NTREL	?CRESEM			; smaphore de synchro pour attente de rponses
	JUMP,NE	ERR$

	MOVE.32	A5,{A6}+OSEMID


	CALL	OpenREQ			; A4 <-- ^requte vide

	MOVE.8	#PRI_SYSTEM,{A4}+RQ_PRI
	MOVE.16	#PORT_NT_REQUEST,{A4}+RQ_PORTNO
	MOVE.16	#CMD_NEW_PORT,{A0}+OcmdCMD
	MOVE.32	{A6}+OSEMID,{A4}+RQ_REPLYSEM
	CALL	Transaction		; cre le nouveau port...

	MOVE.32	#-1,D4
	NTREL	?SETTIM
	MOVE.32	{A6}+OSEMID,A5
	NTREL	?WAITEV

	MOVE.32	{A1}+OstsID,{A6}+O

	POPM.32	D4|A3|A4|A5
	RET


;***************************************************************************************
;-------\
; S0KILL >
;=======/
;***************************************************************************************

; Appel lors du DEINSTALL 

; In	A6.32	^variables globales du pilote
; Out
; Mod	

S0KILL:
	CLR.16	D7
	RET



;***************************************************************************************
;----------\
; S0COMMAND >
;==========/
;***************************************************************************************

; Appel lors de l'appel COMMAND

; In	A6.32	^variables globales du pilote
;	A4.32	^table de commande
; Out
; Mod	D7

S0COMMAND:
	CLR.16	D7
	RET



;***************************************************************************************
;---------\
; S0STATUS >
;=========/
;***************************************************************************************
;
; Donne les status du driver 
;
; In	A6.32	^variables globales du pilote
;	A4.32	^buffer ou rendre les status
;	D4.16	longueur buffer ou mettre les status
; Out	D7	erreur
; Mod

S0STATUS:
	CLR.16	D7
	RET



;***************************************************************************************
;-------\
; S0OPEN >
;=======/
;***************************************************************************************
;
; In	A6.32	^variables globales du pilote
; Out	D7.16	Erreur
; Mod

S0OPEN:
	CLR.16	D7
	RET


;***************************************************************************************
;--------\
; S0CLOSE >
;========/
;***************************************************************************************
;
; Ferme le driver et supprime la liste des requetes en attente
;
; In	A6.32	^variables globales du pilote
; Out	D7.16	Erreur
; Mod

S0CLOSE:
	CLR.16	D7
	RET



;***************************************************************************************
;-------\
; S0READ >
;=======/
;***************************************************************************************
;
; 
;
; In	A6.32	^variables globales du pilote
;	A4.32	^descripteur des donnees PCB
;	D5.32	longueur descripteur ( ignore )
; Out	A4	PCB mis a jour
;	D7.16	Erreur
; Mod
;

S0READ:
	PUSHM.32 D0|D1|A0|A1|A2|A5

	CLR.16	{A4}+OPB_RES			; rsultat de l'opration
	MOVE.16	#1,D7

	COMP.16	#1,{A4}+OPB_BUF_NB		; n'accepte qu'un seul fragment
	JUMP,NE	ERR$				; pas le cas => erreur

; Buffer  lire dcrit par {A4}+OPB_BUF_TAB+OBUF_P_LEN/OBUF_L_LEN/OBUF_PTR



FIN$:	CLR.16	D7

ERR$:	POPM.32	D0|D1|A0|A1|A2|A5
	TEST.16	D7
	RET


;***************************************************************************************
;--------\
; S0WRITE >
;========/
;***************************************************************************************
;
; Une seule commande d'emission est fournie a la fois (pas de chainage de transmission) au niveau
; du SONIC. Mais par contre les requetes sont chainees et traitees a la suite de facon asynchrone
; La taille de tous les fragments doit tre plus petite que 1500 octets !!
;
; Les paquets sont chans pour tre transmis plus efficacement (RB)
;
; In	A6.32	^variables globales du pilote
;	A4.32	^descripteur des donnees PCB
;	D5.32	longueur descripteur ( ignore )
; Out	D7.32	erreur
;
; Mod	
;

S0WRITE:
	PUSHM.32 D0|D1|A0|A1|A5

	CLR.16	{A4}+OPB_RES			; rsultat de l'opration
	MOVE.16	#1,D7

	COMP.16	#1,{A4}+OPB_BUF_NB		; n'accepte qu'un seul fragment
	JUMP,NE	ERR$				; pas le cas => erreur


; Buffer  crire dcrit par {A4}+OPB_BUF_TAB+OBUF_P_LEN/OBUF_L_LEN/OBUF_PTR



ERR$:	POPM.32	D0|D1|A0|A1|A5
	RET



; Initialise les champs commande/statut de la requte et efface les
; buffers de commande et statut.

; in	A0.32	^commande
;	A1.32	^statuts
;	A4.32	^requte
; out	-
; mod	F

InitCmdStatus:
	PUSHM.32 D4|D7|A3|A4

	MOVE.32	A4,A3

	MOVE.32	#LGCMD,D4
	MOVE.32	A0,A4
	GESMEM	?CLEARMEM

	MOVE.32	A4,{A3}+RQ_SDATAPTR
	MOVE.32	D4,{A3}+RQ_SDATALEN

	MOVE.32	#LGSTATUS,D4
	MOVE.32	A1,A4
	GESMEM	?CLEARMEM

	MOVE.32	A4,{A3}+RQ_RDATAPTR
	MOVE.32	D4,{A3}+RQ_RDATALEN

	POPM.32	D4|D7|A3|A4
	RET






; OpenReq

; in	-
; out	A4.32	^requte libre
;	A0.32	^commande
;	A1.32	^statuts
; mod	A4.32, D7.16

OpenReq:
	MOVE.32	#{A6}+OREQUEST,A4
	MOVE.32	#{A6}+OCOMMAND,A0
	MOVE.32	#{A6}+OSTATUS,A1
	JUMP	InitCmdStatus



; Transaction avec le serveur

; in	A4.32	^requte
; out	D7.16	ok/erreur
; mod	D7.16

Transaction:
	PUSHM.32 D4|A4|A5

	MOVE.32	#-1,D4
	NTREL	?MODTIM

	MOVE.32	{A6}+OBARID,A5
	NTREL	?OFFERBAR			; met la requte
	NTREL	?ENDOFFERBAR

	POPM.32	D4|A4|A5
	RET




NMCOMMBAR:	.ASCIZ	"#:PCCOMMBAR"


	.END

