	.TITLE	BLOC.ASL

;	--------------------------------------
;		(C) 1991 - Daniel Roux
;	--------------------------------------

;	Source de la librairie SMA_BLOC.LIB


	.PROC	M68000 			; mnmonics CALM
	.BASE	10'10			; base 10 par dfaut
;	.LAYOUT	HEX			; listing en hexadcimal

	.REF	SMAKY
	.REF	MODULES


; Date		Rev	Amliorations
; -------------------------------------------------------------------------------------------
; 29.01.97	0.8	LOCK en fonction du processus appelant
;			fonction d'espionnage pour l'mulateur/Smaky 400
; 08.05.91	0.7	VISU: raccourci clavier (SHOW-espace) en bas  droite
;			"page" --> "feuille"
; 07.05.91	0.6	VISU: type "AUDI" affich "AUDIO"
;			VISU: type "FICH" affich "FICHE"
; 03.04.91	0.5	RDLIST: ne rend plus "IMAGE,IMAGE" !
; 27.03.91	0.4	RDINFO: nouvel appel
;			REGEN:  nouvel appel
; 22.02.91	0.3	OPEN: dtruit "no_XX.BLOC" la premire fois
; 01.02.91	0.2	VISU: affiche correctement les TABs
; 24.01.91	0.1	premire version




BLOCREV	 = 0
BLOCVERS = 8

	.REV	BLOCREV,BLOCVERS
	.IDENT	"(C)  Daniel ROUX et EPSITEC SA"




; Constantes
; ----------

PCVAR	=	1
PCCODE	=	2

KEYDBOX	=	16'7E00			; "touche" pour dbox

IDENT	=	16'AABB			; identificateur

MEMLGB	=	1000			; longueur d'un bloc mmoire
DISKLGB	=	256*8			; longueur d'un bloc disque

LBUFF	=	4*10			; buffer pour les types



; Descripteur d'une liste en mmoire
; ----------------------------------

	.APC	PCVAR
	.LOC	0
OLINEXT:.BLK.8	4			; ^bloc suivant
OLILUSE:.BLK.8	4			; longueur utilise dans bloc mmoire
OLITYPE:.BLK.8	4			; type du data
LLI:
	.APC	PCCODE


; Descripteur d'une en-tte sur disque
; ------------------------------------

	.APC	PCVAR
	.LOC	0
ODHID:	.BLK.8	2			; identificateur
	.BLK.8	2			; rserve
ODHNAME:.BLK.8	16			; nom du logiciel
ODHTYPI:.BLK.8	4			; type initiateur
	.BLK.8	8			; rserve
LDH:
	.APC	PCCODE


; Descripteur d'un bloc sur disque
; --------------------------------

	.APC	PCVAR
	.LOC	0
ODILUSE:.BLK.8	4			; longueur utilise
ODITYPE:.BLK.8	4			; type du data
LDI:
	.APC	PCCODE




; Variables globales
; ------------------

	.APC	PCVAR
	.LOC	0
ONBUSE:	.BLK.8	2			; nb d'utilisations
OCTMEM:	.BLK.8	4			; compte mmoire

ONSEM:	.BLK.16	1			; nb de LOCK/UNLOCK imbriqus
OISEM:	.BLK.16	1			; ID du processus sur le smaphore
OPSEM:	.BLK.32	1			; ^smaphore d'exclusion

OREGEN:	.BLK.32	1			; numro de rgnration

OHEAD:	.BLK.8	LDH			; en-tte

OTYPE:	.BLK.8	4			; type du data
OSHIFT:	.BLK.8	2			; touche super-shift
OWRERR:	.BLK.8	2			; ok/erreur  l'criture

OBNMOD:	.BLK.8	2			; <>0 => bloc-notes modifi
ONAME:	.BLK.8	16			; nom du logiciel
OTYPI:	.BLK.8	4			; type initiateur
OPLIST:	.BLK.8	4			; ^liste
OWLIST:	.BLK.8	4			; ^pour crite (dernier bloc)
ORLIST:	.BLK.8	4			; ^pour lire (bloc courant)
OLLIST:	.BLK.8	4			; lg restante  lire
OSLIST:	.BLK.8	4			; position o lire

OFILE:	.BLK.8	20			; nom du fichier
OFILE2:	.BLK.8	20			; nom du fichier
OIOCH:	.BLK.8	2			; canal pour entre/sortie
OIOBU:	.BLK.8	10			; buffer tampon
OIOPR:	.BLK.8	4			; ^tranche lue
OIOLG:	.BLK.8	4			; lg restante dans la tranche lue
OIOPO:	.BLK.8	4			; position o lire
OIONF:	.BLK.8	1			; 1 => fichier n'existe pas
	.EVEN

OVNBUSE:.BLK.8	2			; visu: nb d'utilisations
OVBNPOS:.BLK.8	4			; visu: bloc-notes: position
OVBNDIM:.BLK.8	4			; visu: bloc-notes: dimensions
OVCLPOS:.BLK.8	4			; visu: classeur: position
OVCLDIM:.BLK.8	4			; visu: classeur: dimensions

OSCVAR:	.BLK.8	LSCVAR			; variables pour l'ascenseur

OPCBFUN:.BLK.32	1			; espion: ^fonction call-back
OPCBVAR:.BLK.32	1			; espion: ^variables

OBUFF:	.BLK.8	LBUFF			; buffer

LGVGLOB:





; En-tte du module LIB
; ---------------------

	.APC	PCCODE
	.LOC	0
DEBUT:
	.16	BLOC_FIRST		; code du premier appel
	.16	BLOC_LAST		; code du dernier appel
	.8	0			; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	BLOCREV,BLOCVERS	; rvision.version
	.16	0,END_BLOC		; longueur
	.32	PATHLIB			; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"BLOC"			; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_BLOC_OPEN
	.16	_BLOC_CLOSE
	.16	_BLOC_WROPEN
	.16	_BLOC_WRDATA
	.16	_BLOC_WRCLOSE
	.16	_BLOC_RDOPEN
	.16	_BLOC_RDDATA
	.16	_BLOC_RDCLOSE
	.16	_BLOC_RDTEST
	.16	_BLOC_RDLIST
	.16	_BLOC_VISU
	.16	_BLOC_CAR87
	.16	_BLOC_RDINFO
	.16	_BLOC_REGEN
	.16	_BLOC_SETSPY



; Codes des appels
; ----------------




;-----------\\
; _BLOC_OPEN >
;===========/

; Ouverture gnrale. Doit tre fait aprs le LIB_OPEN par
; chaque logiciel utilisant le module BLOC.

; in	-
; out	D7.W	erreur
; mod	D7.W

_BLOC_OPEN:
	PUSHM.32 D1|D4|A1..A3|A5|A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	R8^EXIT$

	TEST.16	{A6}+ONBUSE		; premire utilisation ?
	JUMP,NE	R8^USE$			; non => USE$
					; oui =>
	MOVE.32	#R16^NMACC$,A3
	MOVE.32	#MTYPSYS,D1
	GESMEM	?CREMCPT		; A2 <-- cre un compte mmoire
	JUMP,NE	R8^EXIT$
	MOVE.32	A2,{A6}+OCTMEM

	MOVE.32	#1,D4
	NTREL	?CRESEM			; cre le smaphore d'exclusion
	JUMP,NE	R8^EXIT$
	MOVE.32	A5,{A6}+OPSEM

	MOVE.16	#-1,{A6}+OSCVAR+OSCHTV	; nb de pages inconnu
	CALL	DISKFLUSH		; dtruit le fichier si ncessaire
USE$:
	INC.16	{A6}+ONBUSE		; une utilisation de plus
EXIT$:
	POPM.32	D1|D4|A1..A3|A5|A6
	TEST.16	D7			; retour EQ/NE
	RET

NMACC$:	.ASCIZ	"BLOC_GLOBAL"
	.EVEN


;------------\\
; _BLOC_CLOSE >
;============/

; Fermeture gnrale, avant le LIB_CLOSE.
; ATTENTION:	Si une erreur est rendue, il ne faut pas
;		librer la librairie (LIB_CLOSE) !

; in	-
; out	D7.W	erreur
; mod	D7.W

_BLOC_CLOSE:
	PUSHM.32 D1|A1|A2|A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	R8^EXIT$

	MOVE.16	#1,D7
	COMP.16	#1,{A6}+ONBUSE		; premire utilisation ?
	JUMP,LS	R8^EXIT$		; oui =>  EXIT$

	DEC.16	{A6}+ONBUSE		; une utilisation de moins
	CLR.16	D7			; D7 <-- ok
EXIT$:
	POPM.32	D1|A1|A2|A6
	TEST.16	D7			; retour EQ/NE
	RET



;-------------\\
; _BLOC_WROPEN >
;=============/

; Dbut d'une criture dans le bloc-notes. Le contenu du
; bloc-notes est effac par cet appel.
; En cas d'erreur au WROPEN, ne pas faire le WRCLOSE !
; Le nom du logiciel ne doit pas tre termin par .CODE.
; Le type initiateur indique, parmi tous les types utiliss,
; celui le plus important. Par exemple, lorsque PAGE met des
; objets graphiques dans le bloc-notes, deux formats sont
; utiliss: "PAGE" et "IMAG". Le type initiateur est "PAGE".
; Les donnes seront crites en mmoire s'il en reste assez,
; et sur disque dans le cas contraire. La mmoire libre doit
; tre au minimum gale  D4+30'000.

; in	A3.32	^nom du logiciel
;	D3.32	type initiateur
;	D4.32	lg totale (approximative)
; out	D7.16	erreur
; mod	D7.16

_BLOC_WROPEN:
	PUSHM.32 D2..D5|A2|A3|A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	QUIT$
	CALL	SEMLOCK			; dbut de zone critique

	INC.32	{A6}+OREGEN		; augmente le numro de rgnration

	MOVE.32	D3,{A6}+OTYPI		; OTYPI <-- type initiateur

	MOVE.32	#0,D3
	LIB	?GETSHIFT		; D3 <-- touches super-shift
	MOVE.16	D3,{A6}+OSHIFT		; OSHIFT <-- touches super-shift
	CLR.16	{A6}+OWRERR

	MOVE.32	#{A6}+ONAME,A2
XFNAME$:
	MOVE.8	{A3+},{A2+}		; ONAME <-- nom du logiciel
	JUMP,NE	XFNAME$

	CALL	MEMFLUSH		; vide la liste
	CALL	DISKFLUSH		; vide le fichier

	MOVE.32	D4,D2			; D2 <-- lg approximative
IFMEM$:
	GESMEM	?ARGMEM			; D4/D5 <-- total/plus grand trou
	ADD.32	#30000,D2		; D2 <-- rserve d'environ 30 KB !
	COMP.32	D4,D2			; reste assez de mmoire ?
	JUMP,HS	R8^DISK$		; non => DISK$
MEM$:
	CALL	MEMCREATE		; ouvre la liste
	JUMP,NE	R8^EXIT$
	JUMP	R8^OK$

IFDISK$:
	MOVE.32	#R16^NAME$,A3
	FOS	?DISK			; D3/D4 <-- blocs restants/utiliss
	JUMP,NE	R8^DISK$

	SR.32	#8,D2			; D2 <-- lg approximative en blocs
	ADD.32	#1+2,D2			; D2 <-- rserve 2 blocs
	COMP.32	D3,D2			; reste assez de place ?
	JUMP,HS	R8^MEM$			; non => MEM$
DISK$:
	CALL	WAITMOUSE		; souris: met le sablier
	CALL	DISKCREATE		; ouvre le fichier
	JUMP,NE	R8^EXIT$
OK$:
	INC.16	{A6}+OBNMOD		; OBNMOD <-- bloc-notes modifi
	CLR.16	D7			; D7 <-- ok
	JUMP	R8^QUIT$
EXIT$:
	CALL	SEMUNLOCK		; fin de zone critique
QUIT$:
	POPM.32	D2..D5|A2|A3|A6
	TEST.16	D7			; retour EQ/NE
	RET

NAME$:	.ASCIZ	""
	.EVEN

;-------------\\
; _BLOC_WRDATA >
;=============/

; Ecrit une partie des donnes dans le bloc-notes. Il est possible
; d'crire successivement les donnes avec plusieurs types diff-
; rents. Pour des donnes courtes, il est possible de les crire
; byte aprs byte (D4.L=1), mais si elles sont longues, il est
; prfrable d'crire des tranches plus grandes.

; Squence typique :
;
;	BLOC_WROPEN	ouverture
;	BLOC_WRDATA	type="PAGE"
;	BLOC_WRDATA	type="PAGE"
;	BLOC_WRDATA	type="PAGE"
;	BLOC_WRDATA	type="IMAG"
;	BLOC_WRDATA	type="IMAG"
;	BLOC_WRDATA	type="TEXT"
;	...
;	BLOC_WRCLOSE	fermeture

; in	A4.32	^data
;	D4.32	lg data
;	D3.32	type data
; out	D7.16	erreur
; mod	D7.16

_BLOC_WRDATA:
	PUSHM.32 D2..D4|A4|A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	QUIT$

	MOVE.32	D3,D2			; D2 <-- type data

	TEST.32	{A6}+OPLIST		; liste existe ?
	JUMP,NE	R8^MEM$
	TEST.16	{A6}+OIOCH		; fichier existe ?
	JUMP,NE	R8^DISK$

	MOVE.16	#1,D7			; D7 <-- erreur
	JUMP	R8^EXIT$

MEM$:
	DEC.32	D4
	JUMP,NS	R8^OK$
	MOVE.8	{A4+},D3

	CALL	MEMWRONE		; liste <-- un byte
	JUMP,NE	R8^EXIT$
	JUMP	MEM$

DISK$:
	DEC.32	D4
	JUMP,NS	R8^OK$
	MOVE.8	{A4+},D3

	CALL	DISKWRONE		; fichier <-- un byte
	JUMP,NE	R8^EXIT$
	JUMP	DISK$

OK$:
	CLR.16	D7			; D7 <-- ok
EXIT$:
	ADD.16	D7,{A6}+OWRERR		; OWRERR <-- ok/erreur  l'criture
QUIT$:
	POPM.32	D2..D4|A4|A6
	TEST.16	D7			; retour EQ/NE
	RET


;--------------\\
; _BLOC_WRCLOSE >
;==============/

; Termine l'criture du data dans le bloc-notes.

; in	-
; out	D7.16	erreur
; mod	D7.16

_BLOC_WRCLOSE:
	PUSHM.32 D3|A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	EXIT$

	TEST.32	{A6}+OPLIST		; liste existe ?
	JUMP,NE	R8^MEM$
	TEST.16	{A6}+OIOCH		; fichier existe ?
	JUMP,NE	R8^DISK$

	MOVE.16	#1,D7			; D7 <-- erreur
	JUMP	R8^EXIT$

MEM$:	JUMP	R8^ADD$

DISK$:	CALL	DISKWREND		; crit la fin
	PUSH.16	D7
	CALL	DISKCLOSE		; ferme le fichier
	POP.16	D7
	JUMP,NE	R8^EXIT$

ADD$:	TEST.16	{A6}+OWRERR		; ok  l'criture ?
	JUMP,NE	R8^OK$			; non => OK

	MOVE.16	{A6}+OSHIFT,D3		; D3 <-- touches super-shift
	TEST.32	D3:#BPROGRA		; touche (PROGRA) enfonce ?
	JUMP,BC	R8^OK$			; non => OK$

	CALL	DISKCOUNT		; mj OSCHTV si ncessaire

	MOVE.16	#EROUTF,D7
	MOVE.16	{A6}+OSCVAR+OSCHTV,D3
	COMP.16	#99-1,D3
	JUMP,HS	R8^EXIT$

	CALL	XFERWRITE		; bloc-notes --> fichier
	JUMP,NE	R8^EXIT$
	INC.16	{A6}+OSCVAR+OSCHTV

OK$:	CLR.16	D7			; D7 <-- ok

EXIT$:	CALL	SEMUNLOCK		; fin de zone critique
	TEST.16	D7
	JUMP,NE	R8^RET$

	MOVE.32	{A6}+OPCBFUN,D3		; fonction de call-back existe ?
	JUMP,F	R8^RET$			; non => ne fait rien

	PUSHM.32 D0|D1|A0|A1
	MOVE.32	D3,A0
	MOVE.32	A6,A1
	MOVE.32	{A1}+OPCBVAR,A6		; ^variables
	PUSH.32	A6			; sur la pile: ^variables
	CALL	{A0}			; appelle la routine C/assembleur
	ADD.A16	#4,SP			; nettoie la pile aprs
	POPM.32	D0|D1|A0|A1

RET$:	POPM.32	D3|A6
	TEST.16	D7			; retour EQ/NE
	RET



;-------------\\
; _BLOC_RDLIST >
;=============/

; Donne tous les types prsents dans le bloc-notes.

; in	A4.32	^buffer
;	D4.32	lg buffer (multiple de 4)
; out	(A4)++	liste de tous les types (.32 termins par zro)
;	D3.32	type initiateur
;	A3.32	^nom du logiciel
;	D7.16	erreur
; mod	D7.16

_BLOC_RDLIST:
	PUSHM.32 D3|A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	R8^EXIT$

	MOVE.32	#-3,D3			; D3 <-- bloc-notes
	CALL	RDLIST
EXIT$:
	POPM.32	D3|A6
	TEST.16	D7			; retour EQ/NE
	RET

;-------\\
; RDLIST >
;=======/

; Donne tous les types prsents dans le bloc-notes.

; in	A4.32	^buffer
;	D4.32	lg buffer (multiple de 4)
;	D3.16	page (-3,-2,-1,0..n)
;		 -3	bloc-notes existant
;		 -2	bloc-notes en mmoire
;		 -1	bloc-notes sur disque
;		 0..n	classeur
; out	(A4)++	liste de tous les types (.L termins par zro)
;	D3.32	type initiateur
;	A3.32	^nom du logiciel
;	D7.16	erreur
; mod	D7.16

RDLIST:
	PUSHM.32 D1|D2|D4|D6|A2|A4

	CALL	SEMLOCK			; dbut de zone critique

	MOVE.16	#EROUTF,D7		; D7 <-- rien trouv
	MOVE.32	A4,A2			; A2 <-- ^buffer
	MOVE.32	D4,D2			; D2 <-- lg buffer
	SR.32	#2,D2			; D2 <-- lg/4
	JUMP,EQ	EXIT$
	DEC.32	D2			; D2 <-- place pour terminateur
	JUMP,EQ	EXIT$

	COMP.16	#-3,D3
	JUMP,NE	R8^CHOIX$
	MOVE.16	#-1,D3			; D3 <-- bloc-notes sur disque (-1)
	TEST.32	{A6}+OPLIST		; liste existe ?
	JUMP,EQ	R8^CHOIX$		; non => CHOIX$
	DEC.16	D3			; D3 <-- bloc-notes en mmoire (-2)
CHOIX$:
	COMP.16	#-2,D3
	JUMP,NE	R8^DISK$		; non => DISK$

	TEST.32	{A6}+OPLIST		; liste existe ?
	JUMP,EQ	R8^DISK$		; non => DISK$
MEM$:
	MOVE.32	{A6}+OPLIST,A4
	CLR.32	D3			; D3 <-- dernier type trouv
MLOOP$:
	COMP.32	{A4}+OLITYPE,D3		; type dj trouv ?
	JUMP,EQ	R8^MNEXT$		; oui => MNEXT$

	MOVE.32	{A4}+OLITYPE,D3		; D3 <-- nouveau type
	MOVE.32	D3,{A2+}		; buffer <-- type
	DEC.32	D2
	JUMP,EQ	R8^MEND$
MNEXT$:
	MOVE.32	{A4}+OLINEXT,D4		; D4 <-- ^bloc suivant
	JUMP,EQ	R8^MEND$
	MOVE.32	D4,A4			; A4 <-- ^bloc suivant
	JUMP	MLOOP$

MEND$:
	CLR.32	{A2}			; buffer <-- terminateur

	MOVE.32	{A6}+OTYPI,D3		; D3 <-- type initiateur
	MOVE.32	#{A6}+ONAME,A3		; A3 <-- ^nom du logiciel
	JUMP	OK$

DISK$:
	CALL	DISKCLOSE		; ferme le fichier (si pas dj fait)

	MOVE.32	#{A6}+OFILE,A3		; A3 <-- ^buffer pour le nom
	CALL	DISKNAME		; A3 <-- ^nom du fichier
	MOVE.16	#2**BOPRD,D3
	FOS	?OPEN			; ouvre le fichier
	JUMP,NE	R8^EXIT$

	MOVE.32	#{A6}+OHEAD,A4
	MOVE.32	#LDH,D4
	FOS	?RDBYTE			; lit l'en-tte
	JUMP,NE	R8^DCLOSE$
	COMP.16	#IDENT,{A4}+ODHID
	JUMP,NE	R8^DCLOSE$

	CLR.32	D1			; D1 <-- dernier type trouv
DLOOP$:
	MOVE.32	#{A6}+OIOBU,A4
	MOVE.32	#LDI,D4
	FOS	?RDBYTE			; lit lg/type
	JUMP,NE	R8^DCLOSE$

	COMP.32	{A4}+ODITYPE,D1		; type dj trouv ?
	JUMP,EQ	R8^DNEXT$		; oui => DNEXT$

	MOVE.32	{A4}+ODITYPE,D1		; D1 <-- nouveau type
	MOVE.32	D1,{A2+}		; buffer <-- type
	DEC.32	D2
	JUMP,EQ	R8^DCLOSE$
DNEXT$:
	FOS	?GPOS
	ADD.32	{A4}+ODILUSE,D4
	FOS	?SPOS			; saute le data
	JUMP,EQ	DLOOP$
DCLOSE$:
	FOS	?CLOSE			; ferme le fichier
	CLR.32	{A2}			; buffer <-- terminateur

	MOVE.32	{A6}+OHEAD+ODHTYPI,D3	; D3 <-- type initiateur
	MOVE.32	#{A6}+OHEAD+ODHNAME,A3	; A3 <-- ^nom du logiciel
OK$:
	CLR.16	D7			; D7 <-- ok
EXIT$:
	CALL	SEMUNLOCK		; fin de zone critique

	POPM.32	D1|D2|D4|D6|A2|A4
	TEST.16	D7			; retour EQ/NE
	RET


;-------------\\
; _BLOC_DRTEST >
;=============/

; Vrifie si un type de data existe dans le bloc-notes,
; sans ouvrir.

; in	D3.32	type du data
; out	D3.32	type initiateur
;	A3.32	^nom du logiciel
;	D7.16	erreur
; mod	D3.32, D7.16, A3.32

_BLOC_RDTEST:
	PUSHM.32 D4|A4|A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	QUIT$
	CALL	SEMLOCK			; dbut de zone critique

	MOVE.32	D3,{A6}+OTYPE

	TEST.32	{A6}+OPLIST		; liste existe ?
	JUMP,EQ	R8^DISK$		; non => DISK$
MEM$:
	MOVE.32	{A6}+OPLIST,A4
	MOVE.16	#EROUTF,D7		; D7 <-- data pas trouv
MLOOP$:
	COMP.32	{A4}+OLITYPE,D3		; est-ce le bon type ?
	JUMP,EQ	R8^MEND$		; oui => MEND$

	MOVE.32	{A4}+OLINEXT,D4		; D4 <-- ^bloc suivant
	JUMP,EQ	R8^EXIT$
	MOVE.32	D4,A4			; A4 <-- ^bloc suivant
	JUMP	MLOOP$

MEND$:
	MOVE.32	{A6}+OTYPI,D3		; D3 <-- type initiateur
	MOVE.32	#{A6}+ONAME,A3		; A3 <-- ^nom du logiciel
	JUMP	R8^OK$

DISK$:
	MOVE.16	#-1,D3			; D3 <-- bloc-notes sur disque
	CALL	DISKOPEN		; ouvre et cherche le premire tranche
	JUMP,NE	R8^EXIT$
	CALL	DISKCLOSE		; ferme le fichier

	MOVE.32	{A6}+OHEAD+ODHTYPI,D3	; D3 <-- type initiateur
	MOVE.32	#{A6}+OHEAD+ODHNAME,A3	; A3 <-- ^nom du logiciel
OK$:
	CLR.16	D7			; D7 <-- ok
EXIT$:
	CALL	SEMUNLOCK		; fin de zone critique
QUIT$:
	POPM.32	D4|A4|A6
	TEST.16	D7			; retour EQ/NE
	RET


;-------------\\
; _BLOC_RDINFO >
;=============/

; Donne quelques informations sur le contenu du bloc-notes.

; in	D3.32	type du data
; out	D4.32	longueur du type donn
;	D5.32	longueur totale
;	D7.16	erreur
; mod	D4.32, D5.32, D7.16

_BLOC_RDINFO:
	PUSHM.32 D1..D3|D6|A3|A4|A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	QUIT$
	CALL	SEMLOCK			; dbut de zone critique

	MOVE.32	D3,{A6}+OTYPE

	TEST.32	{A6}+OPLIST		; liste existe ?
	JUMP,EQ	R8^DISK$		; non => DISK$
MEM$:
	MOVE.32	{A6}+OPLIST,A4
	MOVE.16	#EROUTF,D7		; D7 <-- data pas trouv
	CLR.32	D4			; D4 <-- lg type
	CLR.32	D5			; D5 <-- lg totale
MLOOP$:
	COMP.32	{A4}+OLITYPE,D3		; est-ce le bon type ?
	JUMP,NE	R8^MNEXT$		; non => MNEXT$

	ADD.32	{A4}+OLILUSE,D4		; D4 <-- somme des longueurs
MNEXT$:
	ADD.32	{A4}+OLILUSE,D5		; D5 <-- somme des longueurs

	MOVE.32	{A4}+OLINEXT,D2		; D2 <-- ^bloc suivant
	JUMP,EQ	OK$
	MOVE.32	D2,A4			; A4 <-- ^bloc suivant
	JUMP	MLOOP$

DISK$:
	MOVE.32	D3,D1			; D1 <-- type cherch
	CLR.32	D2			; D2 <-- lg type
	CLR.32	D5			; D5 <-- lg totale

	CALL	DISKCLOSE		; ferme le fichier (si pas dj fait)

	MOVE.32	#{A6}+OFILE,A3		; A3 <-- ^buffer pour le nom
	MOVE.32	#-1,D3			; D3 <-- bloc-notes sur disque
	CALL	DISKNAME		; A3 <-- ^nom du fichier
	MOVE.32	#2**BOPRD,D3
	FOS	?OPEN			; ouvre le fichier
	JUMP,NE	R8^EXIT$

	MOVE.32	#{A6}+OHEAD,A4
	MOVE.32	#LDH,D4
	FOS	?RDBYTE			; lit l'en-tte
	JUMP,NE	R8^DCLOSE$
	COMP.16	#IDENT,{A4}+ODHID
	JUMP,NE	R8^DCLOSE$
DLOOP$:
	MOVE.32	#{A6}+OIOBU,A4
	MOVE.32	#LDI,D4
	FOS	?RDBYTE			; lit lg/type
	JUMP,NE	R8^DCLOSE$

	COMP.32	{A4}+ODITYPE,D1		; est-ce le bon type ?
	JUMP,NE	R8^DNEXT$		; non => DNEXT$

	ADD.32	{A4}+ODILUSE,D2		; D2 <-- somme des longueurs
DNEXT$:
	ADD.32	{A4}+ODILUSE,D5		; D5 <-- somme des longueurs

	FOS	?GPOS
	ADD.32	{A4}+ODILUSE,D4
	FOS	?SPOS			; saute le data
	JUMP,EQ	DLOOP$
DCLOSE$:
	FOS	?CLOSE			; ferme le fichier

	MOVE.32	D2,D4			; D4 <-- lg trouve
OK$:
	CLR.16	D7			; D7 <-- ok
EXIT$:
	CALL	SEMUNLOCK		; fin de zone critique
QUIT$:
	POPM.32	D1..D3|D6|A3|A4|A6
	TEST.16	D7			; retour EQ/NE
	RET


;------------\\
; _BLOC_REGEN >
;============/

; Donne le numro de rgnration du bloc-notes.
; Cet appel est le seul qui ne fait jamais d'accs disque !

; in	-
; out	D3.32	no de rgnration unique
;	D7.16	erreur
; mod	D3.32, D7.16

_BLOC_REGEN:
	PUSHM.32 A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	R8^QUIT$

	MOVE.32	{A6}+OREGEN,D3		; D3 <-- no de rgnration
QUIT$:
	POPM.32	A6
	TEST.16	D7			; retour EQ/NE
	RET


;-------------\\
; _BLOC_RDOPEN >
;=============/

; Dbut de la lecture des donnes d'un seul type dans le bloc-notes.
; En cas d'erreur, ne pas faire le RDCLOSE !

; in	D3.L	type du data
; out	D3.L	type initiateur
;	A3.32	^nom du logiciel
;	D7.16	erreur
; mod	D3.L, D7.W, A3.L

_BLOC_RDOPEN:
	PUSHM.32 D4|A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	R8^EXIT$

	MOVE.16	#-3,D4			; D4 <-- bloc-notes
	CALL	RDOPEN			; dbut de la lecture
EXIT$:
	POPM.32	D4|A6
	TEST.16	D7			; retour EQ/NE
	RET

;-------\\
; RDOPEN >
;=======/

; Dbut de la lecture dans le bloc-notes.

; in	D3.L	type du data
;	D4.16	page (-3,-2,-1,0..n)
;		 -3	bloc-notes existant
;		 -2	bloc-notes en mmoire
;		 -1	bloc-notes sur disque
;		 0..n	classeur
; out	D3.L	type initiateur
;	A3.32	^nom du logiciel
;	D7.16	erreur
; mod	D3.L, D7.W, A3.L

RDOPEN:
	PUSHM.32 D4|A4

	CALL	SEMLOCK			; dbut de zone critique

	MOVE.32	D3,{A6}+OTYPE

	COMP.16	#-3,D4
	JUMP,NE	R8^CHOIX$
	MOVE.16	#-1,D4			; D4 <-- bloc-notes sur disque (-1)
	TEST.32	{A6}+OPLIST		; liste existe ?
	JUMP,EQ	R8^CHOIX$		; non => CHOIX$
	DEC.16	D4			; D4 <-- bloc-notes en mmoire (-2)
CHOIX$:
	COMP.16	#-2,D4
	JUMP,NE	R8^DISK$		; non => DISK$
MEM$:
	MOVE.32	{A6}+OPLIST,A4
	MOVE.16	#EROUTF,D7		; D7 <-- data pas trouv
MLOOP$:
	COMP.32	{A4}+OLITYPE,D3		; est-ce le bon type ?
	JUMP,EQ	R8^MEND$		; oui => MEND$

	MOVE.32	{A4}+OLINEXT,D4		; D4 <-- ^bloc suivant
	JUMP,EQ	R8^EXIT$
	MOVE.32	D4,A4			; A4 <-- ^bloc suivant
	JUMP	MLOOP$

MEND$:
	MOVE.32	A4,{A6}+ORLIST		; ORLIST <-- ^premier bloc avec le bon type
	MOVE.32	{A4}+OLILUSE,{A6}+OLLIST
	CLR.32	{A6}+OSLIST

	MOVE.32	{A6}+OTYPI,D3		; D3 <-- type initiateur
	MOVE.32	#{A6}+ONAME,A3		; A3 <-- ^nom du logiciel
	JUMP	R8^OK$

DISK$:
	CALL	WAITMOUSE		; souris: met le sablier

	MOVE.16	D4,D3			; D3 <-- page (-1,0..n)
	CALL	DISKOPEN		; ouvre et cherche le premire tranche
	JUMP,NE	R8^EXIT$

	MOVE.32	{A6}+OHEAD+ODHTYPI,D3	; D3 <-- type initiateur
	MOVE.32	#{A6}+OHEAD+ODHNAME,A3	; A3 <-- ^nom du logiciel
OK$:
	CLR.16	D7			; D7 <-- ok
	JUMP	R8^QUIT$
EXIT$:
	CALL	SEMUNLOCK		; fin de zone critique
QUIT$:
	POPM.32	D4|A4
	TEST.16	D7			; retour EQ/NE
	RET


;-------------\\
; _BLOC_RDDATA >
;=============/

; Lecture d'une partie des donnes du bloc-notes.
; Pour des donnes courtes, il est possible de les lire byte
; aprs byte (D4.L=1), mais si elles sont longues, il est
; prfrable de lire des tranches plus grandes.

; Squence typique :
;
;	BLOC_RDOPEN	ouverture, type="TEXT"
;	BLOC_RDDATA	
;	BLOC_RDDATA	
;	BLOC_RDDATA	
;	...
;	BLOC_RDCLOSE	fermeture

; in	A4.L	^buffer
;	D4.32	lg demande
; out	(A4)++	data lu
;	D4.32	lg lue
;	D7.16	erreur
; mod	D4.L, D7.W

_BLOC_RDDATA:
	PUSHM.32 D3|D5|A4|A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	EXIT$

	MOVE.32	D4,D5			; D5 <-- lg  lire
	CLR.32	D4			; D4 <-- lg lue

	TEST.32	D5			; qq chose  lire ?
	JUMP,EQ	OK$			; non => OK$

	TEST.16	{A6}+OIOCH		; fichier existe ?
	JUMP,NE	R8^DISK$
	TEST.32	{A6}+OPLIST		; liste existe ?
	JUMP,NE	R8^MEM$

	MOVE.16	#EROUTF,D7		; D7 <-- erreur
	JUMP	R8^EXIT$

MEM$:
	CALL	MEMRDONE		; D3 <-- un byte
	JUMP,NE	R8^EXIT$
	MOVE.8	D3,{A4+}		; buffer <-- un byte
	INC.32	D4			; D4 <-- un byte de plus lu
	DEC.32	D5			; encore un byte  lire ?
	JUMP,NE	MEM$			; oui => MEM$
	JUMP	R8^OK$

DISK$:
	CALL	DISKRDONE		; D3 <-- un byte
	JUMP,NE	R8^EXIT$
	MOVE.8	D3,{A4+}		; buffer <-- un byte
	INC.32	D4			; D4 <-- un byte de plus lu
	DEC.32	D5			; encore un byte  lire ?
	JUMP,NE	DISK$			; oui => DISK$
;	JUMP	R8^OK$

OK$:
	CLR.16	D7			; D7 <-- ok
EXIT$:
	POPM.32	D3|D5|A4|A6
	TEST.16	D7			; retour EQ/NE
	RET


;--------------\\
; _BLOC_RDCLOSE >
;==============/

; Fin de la lecture dans le bloc-notes.

; in	-
; out	D7.W	erreur
; mod	D7.W

_BLOC_RDCLOSE:
	PUSH.32	A6

	CALL	OPENVAR			; A6 <-- ^variables globales
	JUMP,NE	R8^EXIT$

	TEST.16	{A6}+OIOCH		; fichier existe ?
	JUMP,NE	R8^DISK$
	TEST.32	{A6}+OPLIST		; liste existe ?
	JUMP,NE	R8^MEM$

	MOVE.16	#1,D7			; D7 <-- erreur
	JUMP	R8^EXIT$

MEM$:
	JUMP	R8^OK$

DISK$:
	CALL	DISKCLOSE		; ferme le fichier
;	JUMP	R8^OK$

OK$:
	CLR.16	D7			; D7 <-- ok
EXIT$:
	CALL	SEMUNLOCK		; fin de zone critique

	POP.32	A6
	TEST.16	D7			; retour EQ/NE
	RET



;------------\\
; _BLOC_CAR87 >
;============/

; Conversion d'un caractre 8 bits (0..255) en un caractre
; 7 bits (0..127). Par exemple, les majuscules accentues sont
; converties en majuscules simples.

; in	D3.B	caractre
; out	D3.B	caractre < 128
; mod	D3.B

_BLOC_CAR87:
	COMP.8	#16'80,D3
	JUMP,HS	R8^SUPPL$
	RET

SUPPL$:
	PUSH.16	D0
	SUB.8	#16'80,D3
	CLR.16	D0
	MOVE.8	D3,D0
	MOVE.8	R8^TCAR2$+A16^{D0},D3	; D3 <-- lettre majuscule
	POP.16	D0
	RET

TCAR2$:
	.8	" ","A","A","A","A","A","A","C","E","E","E","E","I","I","I","I"
	.8	" ","N","O","O","O","O","O","O","U","U","U","U","Y","A","O","B"
	.8	" ","a","c","c","s","a","a","z","C","C","S","Z","I","I"," "," "
	.8	"i","n","o","o"," "," ","o","o","u"," "," "," ","y","a","o"," "
	.8	"?","!",".","""","""","'","'","%"," "," "," "," "," "," ","-","-"
	.8	"*","'","`","^","""","~"," "," "," "," "," "," "," "," "," "," "
	.8	"+","<",">","=","/"," ","0","1","2","3","4","5","6","7","8","9"
	.8	"c","L","Y","/","/"," "," "," "," "," "," "," "," "," "," "," "
	.EVEN






;----------\\
; MEMCREATE >
;==========/

; Ouvre une nouvelle liste.

; in	-
; out	D7.W	erreur
; mod	D7.W

MEMCREATE:
	PUSHM.32 D1|D4|A1|A4

	CALL	MEMFLUSH		; dtruit l'ancienne liste (si ncessaire)

	MOVE.32	#MEMLGB+LLI,D4
	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OCTMEM,A1
	GESMEM	?GETMEM			; demande un premier bloc
	JUMP,NE	R8^EXIT$

	MOVE.32	A4,{A6}+OPLIST
	MOVE.32	A4,{A6}+OWLIST

	CLR.32	{A4}+OLILUSE
	CLR.32	{A4}+OLITYPE
	CLR.32	{A4}+OLINEXT
EXIT$:
	POPM.32	D1|D4|A1|A4
	TEST.16	D7			; retour EQ/NE
	RET

;---------\\
; MEMWRONE >
;=========/

; Ecrit un byte dans la liste.

; in	D2.L	type du byte
;	D3.8	byte  crire
; out	D7.W	erreur
; mod	D7.W

MEMWRONE:
	PUSHM.32 D4|A4

	MOVE.32	{A6}+OWLIST,A4		; A4 <-- ^dernier bloc
	MOVE.32	{A4}+OLILUSE,D4		; D4 <-- position o crire dans le bloc

	COMP.32	{A4}+OLITYPE,D2		; toujours le mme type ?
	JUMP,NE	R8^NEW$			; non => NEW$

	COMP.16	#MEMLGB,D4		; bloc plein ?
	JUMP,LO	R8^BYTE$		; non => BYTE$
NEW$:
	TEST.16	D4			; est-ce le tout premier byte crit ?
	JUMP,EQ	R8^TYPE$		; oui => TYPE$

	PUSHM.32 D1|A1|A3
	MOVE.32	A4,A3
	MOVE.32	#MEMLGB+LLI,D4
	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OCTMEM,A1
	GESMEM	?GETMEM			; demande un nouveau bloc
	JUMP,NE	R8^ERR$
	CLR.32	{A4}+OLILUSE
	CLR.32	{A4}+OLINEXT
	MOVE.32	A4,{A3}+OLINEXT
	MOVE.32	A4,{A6}+OWLIST
ERR$:
	POPM.32	D1|A1|A3
	TEST.16	D7
	JUMP,NE	R8^EXIT$

	CLR.16	D4
TYPE$:
	MOVE.32	D2,{A4}+OLITYPE
BYTE$:
	MOVE.8	D3,{A4}+A16^{D4}+LLI	; bloc <-- byte
	INC.32	{A4}+OLILUSE

	CLR.16	D7			; D7 <-- ok
EXIT$:
	POPM.32	D4|A4
	TEST.16	D7			; retour EQ/NE
	RET

;---------\\
; MEMRDONE >
;=========/

; Lit un byte dans la liste en mmoire.

; in	-
; out	D3.B	byte lu
;	D7.16	erreur
; mod	D3.L, D7.W

MEMRDONE:
	PUSH.32	A4

	MOVE.16	#EROUTF,D7		; D7 <-- y'a plus rien

	TEST.32	{A6}+ORLIST
	JUMP,EQ	R8^EXIT$
	MOVE.32	{A6}+ORLIST,A4		; A4 <-- ^tranche
	TEST.32	{A6}+OLLIST		; reste qq chose  lire ?
	JUMP,NE	R8^ONE$			; oui => ONE$

	MOVE.32	{A4}+OLINEXT,D3
	JUMP,EQ	R8^EXIT$
	MOVE.32	D3,A4			; A4 <-- ^tranche suivante

	MOVE.32	{A6}+OTYPE,D3
	COMP.32	{A4}+OLITYPE,D3		; est-ce le bon type ?
	JUMP,NE	R8^EXIT$		; non => EXIT$

	MOVE.32	A4,{A6}+ORLIST
	MOVE.32	{A4}+OLILUSE,{A6}+OLLIST
	CLR.32	{A6}+OSLIST
ONE$:
	MOVE.32	{A6}+OSLIST,D3
	MOVE.8	{A4}+32^{D3}+LLI,D3	; D3 <-- lit un byte

	INC.32	{A6}+OSLIST
	DEC.32	{A6}+OLLIST

	CLR.16	D7			; D7 <-- ok
EXIT$:
	POP.32	A4
	TEST.16	D7			; retour EQ/NE
	RET


;---------\\
; MEMFLUSH >
;=========/

; Libre la liste en mmoire.

; in	-
; out	-
; mod	D7.W

MEMFLUSH:
	PUSHM.32 D1|D4|A1|A4

	TEST.32	{A6}+OPLIST		; liste existe ?
	JUMP,EQ	R8^EXIT$		; non => EXIT$

	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OCTMEM,A1

	MOVE.32	{A6}+OPLIST,A4
LOOP$:
	MOVE.32	{A4}+OLINEXT,D4		; D4 <-- ^bloc suivant

	GESMEM	?GIVMEM			; libre un bloc

	TEST.32	D4
	JUMP,EQ	R8^END$
	MOVE.32	D4,A4			; A4 <-- ^bloc suivant
	JUMP	LOOP$

END$:
	CLR.32	{A6}+OPLIST
EXIT$:
	POPM.32	D1|D4|A1|A4
	TEST.16	D7			; retour EQ/NE
	RET




;-----------\\
; DISKCREATE >
;===========/

; Cre le fichier bloc-notes.

; in	-
; out	D7.W	erreur
; mod	D7.W

DISKCREATE:
	PUSHM.32 D1|D3|D4|D6|A1|A3|A4

	CALL	DISKFLUSH		; dtruit le fichier si ncessaire

	MOVE.32	#{A6}+OFILE,A3		; A3 <-- ^buffer pour le nom
	MOVE.16	#-1,D3
	CALL	DISKNAME		; A3 <-- ^nom du fichier

	MOVE.32	#DEFATT-(2**BATTL),D3
	MOVE.16	#TYPRAND,D4
	FOS	?CREATE			; cre le fichier
	JUMP,NE	R8^EXIT$
	CLR.8	{A6}+OIONF		; fichier existe

	MOVE.16	#2**BOPWR.OR.2**BOPEXCL,D3
	FOS	?OPEN			; ouvre le fichier
	JUMP,NE	R8^EXIT$
	MOVE.16	D6,{A6}+OIOCH

	MOVE.32	#DISKLGB+LDI,D4
	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OCTMEM,A1
	GESMEM	?GETMEM			; demande mmoire pour data
	JUMP,NE	R8^CLOSE$

	MOVE.32	A4,{A6}+OIOPR
	CLR.32	{A6}+OIOPO
	CLR.32	{A4}+ODITYPE		; type inconnu

	MOVE.32	#{A6}+OHEAD,A4
	MOVE.16	#IDENT,{A4}+ODHID
	MOVE.32	#LDH,D4
	FOS	?WRBYTE			; crit l'en-tte
	JUMP,EQ	R8^EXIT$
CLOSE$:
	PUSH.16	D7
	CALL	DISKCLOSE		; ferme le fichier
	POP.16	D7
EXIT$:
	POPM.32	D1|D3|D4|D6|A1|A3|A4
	TEST.16	D7			; retour EQ/NE
	RET

;----------\\
; DISKWRONE >
;==========/

; Ecrit une tranche de data.

; in	D3.B	byte  crire
;	D2.32	type data
; out	D7.W	erreur
; mod	D7.W

DISKWRONE:
	PUSHM.32 D4|A4

	MOVE.32	{A6}+OIOPR,A4		; A4 <-- ^buffer
	MOVE.32	{A6}+OIOPO,D4		; D4 <-- position o crire dans le bloc

	COMP.32	{A4}+ODITYPE,D2		; toujours le mme type ?
	JUMP,NE	R8^WRITE$		; non => WRITE$

	COMP.16	#DISKLGB,D4		; bloc plein ?
	JUMP,LO	R8^BYTE$		; non => BYTE$
WRITE$:
	TEST.16	D4			; est-ce le tout premier byte crit ?
	JUMP,EQ	R8^TYPE$		; oui => TYPE$

	PUSH.32	D6
	MOVE.32	{A6}+OIOPO,D4
	MOVE.32	D4,{A4}+OLILUSE		; buffer <-- lg
	ADD.32	#LDI,D4
	MOVE.16	{A6}+OIOCH,D6
	FOS	?WRBYTE			; crit lg/type puis data
	POPM.32	D6
	JUMP,NE	R8^EXIT$

	CLR.32	D4
	MOVE.32	D4,{A6}+OIOPO
TYPE$:
	MOVE.32	D2,{A4}+ODITYPE		; buffer <-- type
BYTE$:
	MOVE.8	D3,{A4}+32^{D4}+LDI	; buffer <-- byte
	INC.32	{A6}+OIOPO

	CLR.16	D7			; D7 <-- ok
EXIT$:
	POPM.32	D4|A4
	TEST.16	D7			; retour EQ/NE
	RET

;----------\\
; DISKWREND >
;==========/

; Ecrit la fin du data.

; in	-
; out	D7.W	erreur
; mod	D7.W

DISKWREND:
	PUSHM.32 D4|D6|A4

	CLR.16	D7			; D7 <-- ok

	MOVE.32	{A6}+OIOPR,A4		; A4 <-- ^buffer
	MOVE.32	{A6}+OIOPO,D4		; D4 <-- longueur utilise dans le bloc
	JUMP,EQ	R8^EXIT$

	MOVE.32	D4,{A4}+ODILUSE		; buffer <-- lg
	ADD.32	#LDI,D4
	MOVE.16	{A6}+OIOCH,D6
	FOS	?WRBYTE			; crit lg/type puis data
EXIT$:
	POPM.32	D4|D6|A4
	TEST.16	D7			; retour EQ/NE
	RET

;---------\\
; DISKOPEN >
;=========/

; Ouvre le fichier bloc-notes en lecture, et cherche la premire
; tranche ayant le bon type.

; in	D3.W	page (-1,0..n)
; out	D7.W	erreur
; mod	D7.W

DISKOPEN:
	PUSHM.32 D3|D4|D6|A3|A4

	CALL	DISKCLOSE		; ferme le fichier (si pas dj fait)

	MOVE.32	#{A6}+OFILE,A3		; A3 <-- ^buffer pour le nom
	CALL	DISKNAME		; A3 <-- ^nom du fichier
	MOVE.16	#2**BOPRD,D3
	FOS	?OPEN			; ouvre le fichier
	JUMP,NE	R8^EXIT$
	MOVE.16	D6,{A6}+OIOCH

	MOVE.32	#{A6}+OHEAD,A4
	MOVE.32	#LDH,D4
	FOS	?RDBYTE			; lit l'en-tte
	JUMP,NE	R8^CLOSE$
	MOVE.16	#EROUTF,D7
	COMP.16	#IDENT,{A4}+ODHID
	JUMP,NE	R8^CLOSE$
LOOP$:
	MOVE.32	#{A6}+OIOBU,A4
	MOVE.32	#LDI,D4
	FOS	?RDBYTE			; lit lg/type
	JUMP,NE	R8^CLOSE$

	MOVE.32	{A6}+OTYPE,D3
	COMP.32	{A4}+ODITYPE,D3		; est-ce le bon type ?
	JUMP,EQ	R8^END$

	FOS	?GPOS
	ADD.32	{A4}+ODILUSE,D4
	FOS	?SPOS			; saute le data
	JUMP	LOOP$

END$:
	FOS	?GPOS
	SUB.32	#LDI,D4
	FOS	?SPOS			; revient sur lg/type
	JUMP,EQ	R8^EXIT$
CLOSE$:
	PUSH.16	D7
	CALL	DISKCLOSE		; ferme le fichier
	POP.16	D7
EXIT$:
	POPM.32	D3|D4|D6|A3|A4
	TEST.16	D7			; retour EQ/NE
	RET

;----------\\
; DISKRDONE >
;==========/

; Lit un byte de data.

; in	-
; out	D3.B	byte lu
;	D7.16	erreur
; mod	D3.L, D7.W

DISKRDONE:
	PUSH.32	A4
ONE$:
	TEST.32	{A6}+OIOPR		; y a-t-il une tranche mmoire ?
	JUMP,EQ	R8^NEXT$		; non => NEXT$

	TEST.32	{A6}+OIOLG		; reste qq chose  lire ?
	JUMP,EQ	R8^NEXT$		; non => NEXT$

	MOVE.32	{A6}+OIOPR,A4		; A4 <-- ^tranche lue
	MOVE.32	{A6}+OIOPO,D3		; D3 <-- position o lire

	MOVE.8	{A4}+32^{D3},D3		; D3 <-- lit un byte

	INC.32	{A6}+OIOPO
	DEC.32	{A6}+OIOLG
	CLR.16	D7			; D7 <-- ok
	JUMP	R8^EXIT$

NEXT$:
	PUSHM.32 D1|D4|D6|A1

	CALL	DISKCLOBU		; libre le buffer prcdent

	MOVE.16	{A6}+OIOCH,D6
	MOVE.32	#{A6}+OIOBU,A4
	MOVE.32	#LDI,D4
	FOS	?RDBYTE			; lit lg/type
	JUMP,NE	R8^END$

	MOVE.16	#EROUTF,D7		; D7 <--  y'a plus rien
	MOVE.32	{A6}+OTYPE,D3
	COMP.32	{A4}+ODITYPE,D3		; est-ce le bon type ?
	JUMP,NE	R8^END$			; non => END$

	MOVE.32	{A4}+ODILUSE,D4		; D4 <-- lg
	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OCTMEM,A1
	GESMEM	?GETMEM			; demande mmoire pour data
	JUMP,NE	R8^END$
	MOVE.32	A4,{A6}+OIOPR
	MOVE.32	D4,{A6}+OIOLG
	CLR.32	{A6}+OIOPO

	FOS	?RDBYTE			; lit la tranche
END$:
	POPM.32	D1|D4|D6|A1
	TEST.16	D7
	JUMP,EQ	ONE$
EXIT$:
	POP.32	A4
	TEST.16	D7			; retour EQ/NE
	RET

;----------\\
; DISKCLOSE >
;==========/

; Ferme le fichier bloc-notes.

; in	-
; out	-
; mod	D7.W	erreur

DISKCLOSE:
	PUSH.16	D6

	CALL	DISKCLOBU		; ferme le buffer

	MOVE.16	{A6}+OIOCH,D6
	JUMP,EQ	R8^EXIT$
	FOS	?CLOSE			; ferme le fichier
	CLR.16	{A6}+OIOCH
EXIT$:
	POP.16	D6
	RET

;----------\\
; DISKCLOBU >
;==========/

; Ferme le buffer de lecture.

; in	-
; out	-
; mod	D7.W

DISKCLOBU:
	PUSHM.32 D1|A1|A4

	TEST.32	{A6}+OIOPR
	JUMP,EQ	R8^EXIT$
	MOVE.32	{A6}+OIOPR,A4
	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OCTMEM,A1
	GESMEM	?GIVMEM			; libre le buffer
	CLR.32	{A6}+OIOPR
EXIT$:
	POPM.32	D1|A1|A4
	RET

;----------\\
; DISKFLUSH >
;==========/

; Supprime le fichier bloc-notes.

; in	-
; out	-
; mod	D7.W

DISKFLUSH:
	PUSHM.32 D3|A3

	TEST.8	{A6}+OIONF		; fichier n'existe pas ?
	JUMP,T	R8^EXIT$		; oui => EXIT$

	MOVE.32	#{A6}+OFILE,A3		; A3 <-- ^buffer pour le nom
	MOVE.16	#-1,D3
	CALL	DISKNAME		; A3 <-- ^nom du fichier
	FOS	?DELETE			; dtruit le fichier

	SET.8	{A6}+OIONF		; fichier n'existe pas
EXIT$:
	POPM.32	D3|A3
	RET





;--------\\
; OPENVAR >
;--------/

; Ouvre les variables globales.

; in	-
; out	A6.L	^variables globales
;	D7.16	erreur
; mod	D7.W, A6.L

OPENVAR:
	PUSHM.32 D4|A4

	MOVE.32	#R16^DEBUT,A4
	MOVE.32	#LGVGLOB,D4
	FOS	?GETCOMMEM		; demande variables globales
	JUMP,NE	R8^EXIT$
	MOVE.32	A4,A6			; A6 <-- ^variables globales
EXIT$:
	POPM.32	D4|A4
	TEST.16	D7			; retour EQ/NE
	RET


;--------------\\
; _BLOC_SETSPY  >
;==============/

; Dfinit l'espion  appeler en cas de WRCLOSE.

; in	A4.32	^fonction  appeler (en C ou assembleur)
;	A6.32	^variables
; out	A4.32	^ancienne fonction
;	A6.32	^anciennes variables
;	D7.16	ok
; mod	A4.32, A6.32, D7.16

_BLOC_SETSPY:
	PUSHM.32 A0|A1|A5

	MOVE.32	A6,A5

	CALL	OPENVAR

	MOVE.32	{A6}+OPCBFUN,A0
	MOVE.32	{A6}+OPCBVAR,A1

	MOVE.32	A4,{A6}+OPCBFUN
	MOVE.32	A5,{A6}+OPCBVAR

	MOVE.32	A0,A4
	MOVE.32	A1,A6

	POPM.32	A0|A1|A5
	CLR.16	D7
	RET





	.INS	BLOCVISU.ASI
	.INS	BLOCNUM.ASI
	.INS	BLOCXFER.ASI
	.INS	BLOCMISC.ASI





END_BLOC:


	.END

