
	.TITLE	BUILDGC.ASL

;	----------------------------------------
;		(C) 1991 - Pierre Arnaud
;	----------------------------------------

;	Source du module de librairie de construction de
;	gnrateurs de caractres  partir de rasters.

;	Date	 Rv	Commentaire
;	----------------------------------------------------------------
;	05/08/92 0.5	Utilise un compte global pour les canaux BGC.
;	09/09/91 0.4	BGC_MMENUS modifiait D3.32 avant l'appel LIB !
;	10/04/91 0.3	Version amliore (plus courte et relue)
;	01/04/91 0.2	Nouvel appel BGC_GETGENC
;	30/03/91 0.1a	Premire version ralise suite  une discussion
;			avec Pierre-Olivier Vallat.

	.PROC	M68000
	.REF	SMAKY
	.REF	MODULES
	.REF	DOLIB
	.REF	BUILDGC

REVMAJ	= 0
REVMIN	= 5
REVPRO	= " "

PCCODE	= 0
PCVAR	= 1

	.REV	REVMAJ, REVMIN
	.CODE	800,11,2'000111,600,2000,300,2000,2,"N","E","F",11
	.IDENT	"(C)  Pierre ARNAUD et EPSITEC-system SA"
	.START	-1


		.APC	PCVAR


;	Constantes
;	----------

MAXBGC		= 32				; au maximum 32 gencar construits


;	Dfinition d'un lment de la table (canal)
;	-------------------------------------------

		.LOC	0

OBGCLOGINAME:	.BLK.8	16			; nom du logiciel
OBGCGENCNAME:	.BLK.8	16			; nom du gencar
OBGCPGENC:	.BLK.32	1			; ^gencar en mmoire
OBGCMODE:	.BLK.32	1			; mode donn lors du CREATE
OBGCNB:		.BLK.16	1			; compteur d'utilisations
OBGCFIRST:	.BLK.8	1			; premier car.
OBGCLAST:	.BLK.8	1			; dernier car.
OBGCMAXSIZE:	.BLK.32	1			; taille maximale
OBGCSBYTE:	.BLK.16	1			; taille totale en bytes
OBGCLBYTE:	.BLK.8	1			; largeur en bytes
		.EVEN
OBGCOP:		.BLK.8	1			; opration
OBGCFONTE:	.BLK.8	1			; fonte "X"
OBGCSTYLE:	.BLK.8	1			; style "I"
OBGCTAILLE:	.BLK.8	1			; taille 1..MAXBGC
		.EVEN
LBGC:

;	Dfinition de la table gnrale
;	-------------------------------

		.LOC	0

OGLOBTABLE:	.BLK.8	LBGC*MAXBGC		; table globale
OGLOBCPT:	.BLK.32	1			; descripteur mmoire commune
OGLOBCOUNT:	.BLK.32	1			; compteur d'utilisations
LGLOB:

		.APC	PCCODE


;	En-tte du module de librairie
;	------------------------------

	.LOC	0

BASE:	.16	BGC_FIRST
	.16	BGC_LAST
	.8	0
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN
	.32	END_MODULE
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0
NAME:	.ASCII	"BUILDGC"
	.FILL.8	(LGHLIB-APC),0
	.16	_BGC_CREATE			; cr
	.16	_BGC_KILL			; dtruit
	.16	_BGC_PUT			; place une matrice dans le gencar
	.16	_BGC_BEGINUSE			; dbut de l'utilisation du gencar
	.16	_BGC_ENDUSE			; fin de l'utilisation du gencar
	.16	_BGC_MMENUS			; appel LIB?MMENUS spcial
	.16	_BGC_GETGENC			; rend le nom compact du gnrateur de car.


TXTGENC:	.ASCIZ	"SMA_XIPii.GENC"
		.EVEN


;--------------\\
;  _BGC_CREATE  >
;==============/

; Dfinit un gnrateur XIPii en mmoire en fonction de la taille
; maximale d'un caractre, de l'intervalle  utiliser et du nom
; du logiciel utilisateur.
;
; Chaque logiciel effectuant le CREATE se voit attribu un nom de
; gnrateur de caractres. Il est possible d'utiliser le mme
; gencar pour toutes les excutions d'un logiciel en mettant le
; bit BBGCGLOBAL lors de la cration.

; in	A3.32	^nom du gencar du logiciel (en gnral nom du logiciel) d'au
;		maximum 15 caractres et termin par <CR>, <0> ou <SPACE>
;	D1.8	premier caractre ASCII (0..127)
;	D2.8	dernier caractre ASCII (0..127)
;	D3.32	mode
;		  2**BBGCGLOBAL, utilise le mme gencar pour toutes les
;		  excutions
;	D4.32	[dy;dx] maximal (au plus [255;255] !)
;	D5.32	[0..15] hauteur de la ligne de base (HB)
;		[16..31] reference gauche (RG)
; out	A2.32	canal
;	D7.16	erreur
; mod	A2.32, D7.16

_BGC_CREATE:
	PUSHM.32 D0..D6|A1|A3..A6

	MOVE.16	#ERBGCILCAR,D7
	COMP.8	D2,D1				; premier > dernier ?
	JUMP,GT	ERR$				; oui => erreur "caractre illgal"
	MOVE.16	#ERBGCILSIZE,D7
	COMP.16	#255,D4				; [dx] > 255 ?
	JUMP,GT	ERR$				; oui => erreur "taille illgale"
	SWAP.32	D4
	COMP.16	#255,D4				; [dy] > 255 ?
	JUMP,GT	ERR$				; oui => erreur "taille illgale"
	SWAP.32	D4

	CALL	GETCOMMEM
	JUMP,NE	ERR$

	TEST.32	D3:#BBGCGLOBAL			; mode global ?
	JUMP,BC	NEW$				; non => cre un neuf

	MOVE.32	A6,A2
	MOVE.32	#MAXBGC-1,D0

SEEK$:	MOVE.32	#{A2}+OBGCLOGINAME,A4
	CALL	CPSTRING			; compare le nom des logiciels
	JUMP,NE	SEEKNEXT$

	TEST.8	{A2}+OBGCMODE+3:#BBGCGLOBAL	; logiciel aussi en mode global ?
	JUMP,BC	SEEKNEXT$

	INC.16	{A2}+OBGCNB			; une utilisation de plus
	JUMP	EXIT$				; termin !

SEEKNEXT$:
	ADD.A16	#LBGC,A2
	DJ.16,NMO D0,SEEK$			; passe au suivant

; Cre un nouveau canal...

NEW$:	MOVE.32	A6,A2
	MOVE.32	#0,D0				; recherche le premier canal encore libre

FREE$:	TEST.8	{A2}
	JUMP,EQ	OK$
	ADD.A16	#LBGC,A2
	INC.32	D0
	COMP.32	#MAXBGC,D0			; atteint le maximum ?
	JUMP,LT	FREE$				; non => passe au suivant

	MOVE.16	#ERBGCFULL,D7			; rend l'erreur "plein"
	JUMP	EXIT$

; Initialise le nouveau canal..

OK$:	MOVE.16	#1,{A2}+OBGCNB			; une utilisation
	MOVE.32	#{A2}+OBGCLOGINAME,A4
	MOVE.32	D3,{A2}+OBGCMODE
	MOVE.32	#15-1,D6			; au maximum 15 car  copier

COPY$:	MOVE.8	{A3+},D3			; copie le nom du logiciel
	CALL	TERMINATEUR
	JUMP,EQ	R8^ENDCOPY$
	MOVE.8	D3,{A4+}
	DJ.16,NMO D6,COPY$

ENDCOPY$:
	CLR.8	{A4}				; terminateur universel <0>
	MOVE.8	D1,{A2}+OBGCFIRST
	MOVE.8	D2,{A2}+OBGCLAST
	MOVE.32	D4,{A2}+OBGCMAXSIZE

	MOVE.32	#R16^TXTGENC,A3
	MOVE.32	#{A2}+OBGCGENCNAME,A4

COPYGENC$:
	MOVE.8	{A3+},{A4+}
	JUMP,NE	COPYGENC$			; copie le nom du gencar "SMA_XIPii.GENC<0>"

	INC.32	D0
	MOVE.32	#2**BAFDALL,D2
	MOVE.32	#2,D3
	MOVE.32	D0,D4				; D4 <-- numro du gencar 1..MAXBGC
	MOVE.32	#{A2}+OBGCGENCNAME+7,A4		; A4 <-- juste aprs le SMA_XIP
	LIB	?PUTDEC
	MOVE.8	#".",{A4}
	MOVE.8	D0,{A2}+OBGCTAILLE
	MOVE.8	#"X",{A2}+OBGCFONTE

	CLR.32	D0
	MOVE.8	{A2}+OBGCLAST,D0
	SUB.8	{A2}+OBGCFIRST,D0
	INC.32	D0				; D0 <-- nombre de caractres

	CLR.32	D4
	MOVE.16	{A2}+OBGCMAXSIZE+2,D4
	ADD.16	#7,D4
	SR.16	#3,D4				; D4 <-- [dx] en bytes
	MOVE.8	D4,{A2}+OBGCLBYTE
	MUL.16	{A2}+OBGCMAXSIZE+0,D4		; D4 <-- nombre de bytes par caractre
	MOVE.16	D4,{A2}+OBGCSBYTE
	ADD.32	#3,D4				;        plus les 3 tables (chasse/h1/h2)
	MUL.16	D0,D4				; D4 <-- place prise par tous les caractres
	ADD.32	#lgBXR+OGCWID,D4		;        ajoute l'en-tte rduit + l'en-tte gencar

	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OGLOBCPT,A1
	GESMEM	?GETMEM				; alloue la mmoire ncessaire
	JUMP,NE	CLR0$

	GESMEM	?CLEARMEM
	MOVE.32	A4,{A2}+OBGCPGENC		; mmorise le pointeur  la tranche mmoire
	MOVE.8	#2**BBXREL+2**BBXHRR,{A4}+OBXTYP ; en-tte courte
	SUB.32	#lgBXR,D4
	MOVE.32	D4,{A4}+OBXLG			; longueur du binaire en bytes

TRYAGAINMCACHE$:
	MOVE.32	#{A2}+OBGCGENCNAME,A3		; A3 <-- ^nom du gencar
;	MOVE.32	A4,A4				; A4 <-- ^en-tte binaire
	MOVE.16	#erATTX,D3			; D3 <-- fichier non excutable
	FOS	?MCACHE				; MCACHE le fichier..
	JUMP,EQ	OKMCACHE$

	INC.8	{A3}+5				; tente avec un autre caractre
	COMP.8	#"Z"+1,{A3}+5			; atteint la fin de l'alphabet ?
	JUMP,NE	TRYAGAINMCACHE$			; essaie de MCACHER avec ce nouveau nom

	JUMP	CLR1$

; Le gencar a t m-cach, il n'y a plus qu' l'initialiser..

OKMCACHE$:
	MOVE.8	{A3}+5,{A2}+OBGCSTYLE		; garde le style (pas forcment "I")
	MOVE.32	#{A4}+lgBXR,A4			; A4 <-- ^en-tte du gencar
	MOVE.16	{A2}+OBGCSBYTE,{A4}+OGCMSB	; taille d'une matrice en bytes
	MOVE.16	{A2}+OBGCMAXSIZE+0,{A4}+OGCMHD	; taille [dy] d'une matrice
	MOVE.8	{A2}+OBGCLBYTE,{A4}+OGCMWB	; largeur en bytes
	MOVE.8	{A2}+OBGCFIRST,{A4}+OGCFCA	; premier car.
	MOVE.8	{A2}+OBGCLAST,{A4}+OGCLCA	; dernier car.
	MOVE.32	D5,{A4}+OGCLMA			; rfrence  gauche et ligne de base
	MOVE.16	{A4}+OGCMHD,D1
	SUB.16	{A4}+OGCBLI,D1
	MOVE.16	D1,{A4}+OGCMH1			; [h1] maximal
	MOVE.16	{A4}+OGCBLI,{A4}+OGCMH2		; [h2] maximal
	MOVE.16	{A4}+OGCMHD,{A4}+OGCISP		; interligne
	MOVE.8	#1,{A4}+OGCVSP			; chasse variable
	MOVE.16	{A2}+OBGCMAXSIZE+2,{A4}+OGCMWI	; largeur maximale
	MOVE.16	#0,{A4}+OGCPWI			; offset table de chasse
	MOVE.16	D0,{A4}+OGCPH1			; offset hauteurs en-dessus de la ligne de base
	MOVE.16	D0,{A4}+OGCPH2
	ADD.16	D0,{A4}+OGCPH2			; offset hauteurs en-dessous de la ligne de base
	MOVE.16	{A4}+OGCPH2,{A4}+OGCPMX
	ADD.16	D0,{A4}+OGCPMX			; offset premire matrice de points
	CLR.16	D7
	JUMP	EXIT$

CLR1$:	PUSH.16	D7
	MOVE.32	{A2}+OBGCPGENC,A4
	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OGLOBCPT,A1
	GESMEM	?GIVMEM
	POP.16	D7

CLR0$:	CLR.8	{A2}+OBGCLOGINAME		; libre le canal

EXIT$:	PUSH.16	D7
	NTREL	?UNLOCK
	POP.16	D7

ERR$:	POPM.32	D0..D6|A1|A3..A6
	TEST.16	D7
	RET



;------------\\
;  _BGC_KILL  >
;============/

; Dtruit un gnrateur de caractres.

; in	A2.32	canal
; out	D7.16	erreur
; mod	D7.16

_BGC_KILL:
	PUSHM.32 D1|D3|A1|A3..A6

	CALL	GETCOMMEM
	JUMP,NE	ERR$

	DEC.16	{A2}+OBGCNB			; une utilisation de moins
	JUMP,NE	EXIT$				; encore utilis => termine

	CLR.8	{A2}+OBGCLOGINAME
	MOVE.8	#KILLGC,{A2}+OBGCOP
	MOVE.32	#{A2}+OBGCOP,A3
	MOVE.32	#4,D3
	LIB	?RSTGC
	LIB	?STRING				; libre le gnrateur

	MOVE.32	#{A2}+OBGCGENCNAME,A3
	FOS	?DECACHE			; dcache

	MOVE.32	{A2}+OBGCPGENC,A4
	MOVE.32	#MTYPUSER,D1
	MOVE.32	{A6}+OGLOBCPT,A1
	GESMEM	?GIVMEM				; rend la mmoire

EXIT$:	PUSH.16	D7
	NTREL	?UNLOCK
	POP.16	D7

ERR$:	POPM.32	D1|D3|A1|A3..A6
	TEST.16	D7
	RET



;-----------\\
;  _BGC_PUT  >
;===========/

; Place une matrice dans le gencar au rang du caractre
; donn en entre. La matrice doit avoir une taille
; infrieure ou gale  la matrice du caractre dans le
; gencar.

; in	A4.32	^matrice (comme pour DRAWMATRIX)
;	A2.32	canal
;	D3.8	caractre
; out	D7.16	erreur
; mod	D7.16

_BGC_PUT:
	PUSHM.32 D0|D2|D3|D4|A1|A3|A4

	MOVE.32	{A2}+OBGCPGENC,A3		; A3 <-- ^binaire .GENC
	ADD.A16	#lgBXR,A3			; A3 <-- ^gencar

	MOVE.16	#ERBGCILCAR,D7
	COMP.8	{A3}+OGCLCA,D3
	JUMP,GT	EXIT$				; pas correct
	SUB.8	{A3}+OGCFCA,D3			; par rapport au premier car.
	JUMP,LT	EXIT$

	CLR.32	D2
	MOVE.8	{A3}+OGCLCA,D2
	SUB.8	{A3}+OGCFCA,D2
	INC.32	D2				; D2 <-- nombre de caractres

	AND.16	#16'00FF,D3			; D3 <-- caractre

	MOVE.32	A3,A1
	ADD.A16	#OGCWID,A1
	ADD.A16	D3,A1				; A1 <-- ^chasses
	MOVE.8	{A4},{A1}			; mmorise la chasse du caractre
	ADD.32	D2,A1
	MOVE.8	{A3}+OGCMH1+1,{A1}		; mmorise la hauteur au-dessus de la ligne de base
	ADD.32	D2,A1
	MOVE.8	{A3}+OGCMH2+1,{A1}		; mmorise la hauteur au-dessous de la ligne de base

	MOVE.32	A3,A1				; A1 <-- ^gencar des icnes
	ADD.A16	#OGCWID,A1
	MUL.16	{A3}+OGCMSB,D3
	ADD.A16	D3,A1
	ADD.A16	{A3}+OGCPMX,A1			; A1 <-- ^bonne matrice

	CLR.32	D4
	MOVE.16	{A3}+OGCMSB,D4
	EX.32	A1,A4
	GESMEM	?CLEARMEM			; efface la matrice
	EX.32	A1,A4

	MOVE.8	{A4+},D3			; D3 <-- largeur
	ADD.8	#8-1,D3
	SR.8	#3,D3				; D3 <-- largeur en bytes

	MOVE.8	{A4+},D4			; D4 <-- hauteur
	CLR.32	D0
	MOVE.8	{A3}+OGCMWB,D0			; D0 <-- largeur en bytes

LOOPY$:	PUSHM.32 D3|A1

LOOPX$:	MOVE.8	{A4+},{A1+}			; gencar <-- une ligne
	DEC.8	D3
	JUMP,NE	LOOPX$

	POPM.32	D3|A1

	ADD.32	D0,A1				; A1 <-- ^ligne suivante
	DEC.8	D4
	JUMP,NE	LOOPY$

	CLR.16	D7

EXIT$:	POPM.32	D0|D2|D3|D4|A1|A3|A4
	TEST.16	D7
	RET



;----------------\\
;  _BGC_BEGINUSE  >
;================/

; Dbute l'utilisation du gnrateur de caractre. Cet appel remplace
; l'envoi de LOADGC et USEGC au pilote cran.

; in	A2.32	canal
; out	D7.16	erreur
; mod	D7.16

_BGC_BEGINUSE:
	PUSHM.32 D4|D6|A4

	LIB	?GCHDIS				; D6 <-- canal de l'cran
	SUB.A16	#8,SP
	MOVE.32	SP,A4
	MOVE.32	#8,D4
	MOVE.32	{A2}+OBGCOP,{A4}+0
	MOVE.32	{A2}+OBGCOP,{A4}+4
	MOVE.8	#LOADGC,{A4}+0
	MOVE.8	#USEGC,{A4}+4
	FOS	?WRBYTE				; envoie le LOADGC et le USEGC au pilote
	ADD.A16	#8,SP

ERR$:	POPM.32	D4|D6|A4
	TEST.16	D7
	RET



;--------------\\
;  _BGC_ENDUSE  >
;==============/

; Termine l'utilisation du gnrateur de caractres. Cet appel reprend
; le gnrateur normal et correspond  KILLGC - sauf qu'il ne dcharge
; pas le gnrateur de la mmoire centrale.

; in	A2.32	canal
; out	D7.16	erreur
; mod	D7.16

_BGC_ENDUSE:
	PUSHM.32 D4|D6|A4

	LIB	?RSTGC				; reprend les caractres par dfaut
	LIB	?GCHDIS				; D6 <-- canal de l'cran
	MOVE.32	#{A2}+OBGCOP,A4
	MOVE.8	#KILLGC,{A4}+0
	MOVE.32	#4,D4
	FOS	?WRBYTE				; envoie le KILLGC au pilote

ERR$:	POPM.32	D4|D6|A4
	TEST.16	D7
	RET



;--------------\\
;  _BGC_MMENUS  >
;==============/

; Fait l'appel LIB ?MMENUS en utilisant les icnes dfinies par ce
; canal. Les icnes dfinies dans le menu doivent tre dfinies
; par :
;
;	.8	USEGC,"X","I",0
;
; Chaque occurence de ce gencar sera remplace par le gencar cr
;  l'aide de CREATE + PUT.

; in	A2.32	canal
;	D0.32	LIB?MMENU ou LIB?MMENUS
;	+ selon appel LIB
; out	D7.16	erreur
;	+ selon appel LIB
; mod	D7.16

_BGC_MMENUS:
	PUSHM.32 A3

	CALL	TRADMMENU
	JUMP,NE	EXIT$

	COMP.32	#LIB?MMENU,D0
	JUMP,EQ	MMENU$
	COMP.32	#LIB?MMENUS,D0
	JUMP,NE	EXIT$

	LIB	?MMENUS

	CALL	FREEMMENU
	JUMP	EXIT$

MMENU$:	LIB	?MMENU
	CALL	FREEMMENU

EXIT$:	POPM.32	A3
	TEST.16	D7
	RET



;---------------\\
;  _BGC_GETGENC  >
;===============/

; Rend le nom court (<0>fst) du gnrateur de caractres
; gnr.

; in	A2.32	canal
; out	D3.32	[0;f;s;t] fonte, style, taille
;	D7.16	erreur (?)
; mod	D3.32, D7.16

_BGC_GETGENC:
	MOVE.32	{A2}+OBGCOP,D3
	SL.32	#8,D3
	SR.32	#8,D3				; D3 <-- [0;f;s;t]
	CLR.16	D7
	RET



; --------------------------------------------------------------------------


;------------\\
;  TRADMMENU  >
;============/

; Traduit une description de menu souris et rend une copie

; in	A2.32	canal
;	A3.32	^mmenu (v. hirarchique)
; out	A3.32	^copie traduite du mmenu
;	D7.16	erreur
; mod	A3.32, D7.16

TRADMMENU:
	PUSHM.32 D1|D3|D4|A4|A5

	MOVE.32	A3,D4
	CALL	SIZEMMENU			; D4 <-- extrmit mmoire oppose (fin)

	SUB.32	A3,D4				; D4 <-- taille mmoire requise

	MOVE.32	#MTYPCP,D1
	GESMEM	?GETMEM				; demande la mmoire pour la copie
	JUMP,NE	ERR$

	MOVE.32	A3,A5
	MOVE.32	A4,A3

	DEC.32	D4

DO$:	MOVE.8	{A5+},D3			; copie et remplace les <LOADGC>"XI"
	COMP.8	#USEGC,D3			; par des <LOADGC>"X(I..)"<n>
	JUMP,NE	R8^COPIE$
	MOVE.8	D3,{A4+}
	DEC.32	D4
	MOVE.8	{A5+},D3
	COMP.8	#"X",D3
	JUMP,NE	R8^COPIE$
	MOVE.8	D3,{A4+}			; <LOADGC>"X"..
	DEC.32	D4
	MOVE.8	{A5+},D3
	COMP.8	#"I",D3
	JUMP,NE	R8^COPIE$
	INC.32	A5
	MOVE.8	{A2}+OBGCSTYLE,{A4+}		; <LOADGC>"XI"
	DEC.32	D4
	MOVE.8	{A2}+OBGCTAILLE,D3		; copie encore le <n>

COPIE$:	MOVE.8	D3,{A4+}
	DJ.16,NMO D4,DO$			; copie le mmenu

ERR$:	POPM.32	D1|D3|D4|A4|A5
	TEST.16	D7
	RET


;------------\\
;  SIZEMMENU  >
;============/

; Dtermine la taille du mmenu. Met  jour la position de la fin
; en explorant le mmenu de ce niveau et les autres recursivement.

; in	A3.32	^mmenu
;	D4.32	dernier octet trouv
; out	D4.32	dernier octet trouv (si plus loin)
; mod	D4.32

SIZEMMENU:
	PUSHM.32 D3|A4

	MOVE.32	A3,A4

REDO$:	MOVE.8	{A4+},D3
	JUMP,EQ	R8^ZERO$
	COMP.8	#-2,D3				; sous-menu ?
	JUMP,NE	REDO$				; non => explore la suite

	PUSH.32 A3
	MOVE.8	{A4+},D3
	SWAP.16	D3
	MOVE.8	{A4+},D3			; D3 <-- offset au sous-menu
	MOVE.32	#{A3}+A16^{D3},A3		; A3 <-- ^sous-menu
	CALL	SIZEMMENU			; explore le sous-menu
	POP.32	A3
	JUMP	REDO$

ZERO$:	TEST.8	{A4}				; fini ?
	JUMP,NE	REDO$				; non => explore la suite

	INC.32	A4
	COMP.32	A4,D4				; dpass la fin prcdente ?
	JUMP,GE	R8^ERR$				; non => rien  faire
	MOVE.32	A4,D4				; oui => met  jour

ERR$:	POPM.32	D3|A4
	TEST.16	D7
	RET



;------------\\
;  FREEMMENU  >
;============/

; Libre la mmoire de la copie.

; in	A3.32	^copie
; out	-
; mod	-

FREEMMENU:
	PUSHM.32 D1|D7|A4

	MOVE.32	A3,A4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GIVMEM

ERR$:	POPM.32	D1|D7|A4
	TEST.16	D7
	RET



;------------\\
;  GETCOMMEM  >
;============/

; Demande la tranche de mmoire commune.

; in	-
; out	A6.32	^mmoire commune
;	A5.32	smaphore d'exclusion pour UNLOCK final
;	D7.16	erreur
; mod	A5.32, A6.32, D7.16

GETCOMMEM:
	PUSHM.32 D1|D3|D4|A2|A3|A4

	MOVE.32	#R16^BASE,A4
	MOVE.32	#LGLOB+2**31,D4
	FOS	?GETCOMMEM
	JUMP,NE	ERR$

	MOVE.32	A4,A6
	NTREL	?LOCK

	TEST.32	{A6}+OGLOBCPT
	JUMP,NE	R8^ERR$

	MOVE.32	#R16^BASE,A4
	FOS	?IDENT			; cherche notre nom
	MOVE.32	#2**BEXNHEAD,D3
	FOS	?CLOAD			; vite qu'il soit dcharg

	MOVE.32	#R16^NAME,A3
	MOVE.32	#MTYPSYS,D1
	GESMEM	?CREMCPT		; cre le compte (une seule fois) !

	MOVE.32	A2,{A6}+OGLOBCPT

ERR$:	POPM.32	D1|D3|D4|A2|A3|A4
	TEST.16	D7
	RET



;-----------\\
;  CPSTRING  >
;===========/

; Compare la chane donne avec la rfrence. Ne tient pas
; compte des diffrences majuscules/minuscules. Au maximum
; 15 caractres..

; in	A3.32	^rfrence
;	A4.32	^chane  comparer
; out	EQ/NE
; mod	-

CPSTRING:
	PUSHM.32 D2|D3|A3|A4

SEEK$:	MOVE.8	{A4+},D3		; caractre  comparer
	CALL	TERMINATEUR		; est-ce un terminateur ?
	JUMP,EQ	R8^OK?$

	LIB	?MINMAJ
	MOVE.8	D3,D2			; met en majuscules
	MOVE.8	{A3+},D3		; second caractre
	LIB	?MINMAJ			; majuscules les deux
	COMP.8	D2,D3
	JUMP,EQ	R8^SEEK$		; gaux -> suite
					; ingaux -> erreur !
	JUMP	R8^RET$			; pour JUMP,NE (erreur)

OK?$:	MOVE.8	{A3+},D3		; second caractre
	CALL	TERMINATEUR		; est-ce un terminateur
					; pour JUMP,EQ (identiques)

RET$:	POPM.32	D2|D3|A3|A4		; EQ/NE prts..
	RET



;--------------\\
;  TERMINATEUR  >
;==============/

; Vrifie si le caractre est un terminateur

; in	D3.8	caractre  tester
; out	EQ/NE
; mod	-

TERMINATEUR:
	TEST.8	D3
	JUMP,EQ	R8^OK$			; <0> -> terminateur, termine
	COMP.8	#CR,D3
	JUMP,EQ	R8^OK$			; est-ce un CR
	COMP.8	#SPACE,D3
;;	JUMP,EQ	R8^OK$			; ou un espace

OK$:	RET

END_MODULE:

	.END

