	.TITLE	DBOX.ASL

	.PROC	M68000
	.BASE	10'10

	.PROCSET MACINSTR

	.REF	SMAKY
	.REF	MODULES
	.REF	COLORS
	.REF	TCOLOR
	.REF	MON

	.INS	..:..:RS:ICON.ASSR
	.INS	..:..:RS:DBOX.ASSR


DBOXREV		= 6			; rvision
DBOXVERS	= 3			; version


; DBOX	Date		Amliorations
; ------------------------------------------------------------------------------------------------
; 6.3	25.01.98   PA	les choix PREND/SAUVE tendu d'office sont rpercuts correctement.
; 6.2	23.09.97   PA	ne ferme plus un canal pas ouvert en cas d'erreur dans IFFLOPPY.
; 6.1	16.09.97   PA	ne bombarde plus dans ONEICONE, ni dans IOEDITSLSEARCH.
; 6.0	29.08.97   PA	ne bombarde plus si ?LISTOPEN retourne une erreur.
; ------------------------------------------------------------------------------------------------
; 5.20	26.08.97   PA	ODBCLINE inverse le texte avant la premire frappe (LIB ?EDIT modifi).
; 5.19	05.08.97   PA	DBOX_REFCOLOR ne bombarde plus en noir & blanc.
; 5.18	06.06.97   PA	refait silencieusement l'appel FOS dans ERCALL si ERMREAD (pour SyQuest).
; 5.17	04.04.97   PA	ne modifie plus A3 en sortie dans paDRAWTRAME.
; 5.16	21.03.97   PA	les noms sont limits  50 caractres  l'affichage (pour DBOX_DETRUIT).
; 5.15	15.02.97   PA	petite correction (traits de sparation dans les listes).
; 5.14	18.01.97   PA	n'affiche plus "(courant)" dans le chemin d'accs (dialogues tendus).
; 5.13	08.12.96   PA	petites modifications d'effets dsagrables lis  la localisation (grrr).
; 5.12	02.12.96   PA	localisation marche aussi si fosparam @xxx:
; 5.11	30.11.96   PA	prsente toutes les options dans la liste des fichiers PREND/SAUVE.
; 5.10	21.11.96   PA	messages d'erreur un peu plus subtils (reconnat $FILE/$PART).
; 5.9	16.11.96   PA	suppression automatique des dossiers configurable.
; 5.8	13.11.96   PA	acclr l'affichage avec n > 4 bpp (on conserve la table de conversion).
; 5.7	25.10.96   PA	nouveau BDBGCDRAW pour redessiner un objet.
; 5.6	14.10.96   PA	vrifie mieux la syntaxe du nom de fichier  coller (multi-ligne).
; 5.5	30.08.96   PA	vrifie largeur du SMA_DBOX.COLOR, nouveau SMA_DBOY.COLOR.
;			nouveau DBOX_REFCOLOR pour mettre  jour les couleurs (matching des gris).
; 5.4	27.08.96   PA	corrig problme avec prend utilisant "$xxx:"
; 5.3	04.08.96   PA	gnralis dessin du cadre  n >= 4 bpp.
; 5.2	02.08.96   PA	acclr dessin du cadre avec nouveau GRA2_TRAME.
; 5.1	01.08.96   PA	support > 16 couleurs.
; 5.0	21.06.96   PA	ajout des onglets aux dialogues.
;			si un grand dialogue PREND/SAUVE n'a pas la place, essaie un plus petit.
;			release automatique au fur et  mesure des recherches.
; ------------------------------------------------------------------------------------------------
; 4.21	31.05.96   PA	correction d'une petite erreur
; 4.20	28.05.96   PA	reprend la taille des dialogues au dmarrage
; 4.19  24.05.96   PA	la "maison" montre tous les chemins du dossier courant.
; 4.18	03.11.95   PA	petite correction.
; 4.17	30.10.95   PA	ne charge plus le SMA_DBOX.COLOR d'office.
; 4.16	25.10.95   PA	gestion particulire des units assignes sur @_PWD_:
; 4.15	01.06.95   PA	redessine toujours les boutons ronds  l'ancien look.
; 4.14	23.05.95   PA	gestion correcte des icones ICON (appel DRDBICON).
;			ajout le mode BDBGLAD pour les dialogues TERROR.
; 4.13	22.05.95   PA	fichiers cachs "x_xxx" par erreur (depuis 4.11).
; 4.12  19.05.95   PA	correction pour gestion des boutons griss.
;			mode "OM" pour le look : ancien en mono, nouveau 3D en couleur.
; 4.11	02.05.95   PA	cache les units "@_xxx:" et "#_xxx:".
; 4.10	20.04.95   PA	look mmoris dans le fichier d'infos.
; 4.9	10.04.95   PA	vite de passer "par dessus" les messages d'erreur.
; 4.8	07.04.95   PA	l'arbre ne fait plus d'enter "manuel".
; 4.7	10.03.95   PA	DBOX_GETCO permet de dsactiver un objet sans le griser.
; 4.6	07.03.95   PA	accepte CURSOR-SPACE dans les dialogues prend/sauve/etc.
; 4.5	17.02.95   PA	encore de petits dtails pour DEF_xxx
;			ext. prise en compte lors de l'dition de noms
; 4.4	10.02.95   PA	petites corrections d'anciens bugs
; 4.3	08.02.95   PA	amlior color matching (utilise les gris systme)
;			mmorise "A=a" dans les recherches
;			recherches conservent jusqu' 200 caractres par nom !
; 4.2	30.01.95   PA	quelques corrections, gestion du look nostalgique...
;			DBOX_DRDBICON, dessine une icone (couleur/monochrome)
;			ODBTITLE, plus joli si look 3D enclench
;			ODBTRAME, plus utilis si look 3D enclench
; 4.1	27.01.95   PA	petites modifications, adaptations au Smaky 300.
; 4.0	24.01.95   PA	encore un nouveau look, mais en 3D vrai si on a la couleur !
; ------------------------------------------------------------------------------------------------
; 3.7	23.01.95   PA	traduction en CALM, traitill quand on dplace la DBOX
;			rduit la taille (qques MOVE.32 #A8^... ~ 100 bytes)
; 3.6	29.11.94	correction pour PZ (bis)
; 3.5	24.11.94	correction pour PZ
; 3.4	16.11.94	DBOX_OPEN: nouveau bit BDBNMV (no move)
; 3.3	11.11.94	dplacements ok
; 3.2	02.11.94	+ priorit lors du dessin
; 3.1	26.09.94	dplacement ok
;			ODBCIRCLE: si gris + change d'tat -> redessin en gris
;			DBOX_MLFADD: transforme une cl "abc`t.text" en "x`t.text"
; 3.0	25.07.94	new look !
;			possibilit de dplacer toutes les dbox
;			DBOX_ICO*: n'utilise plus ODFPSK
;			DBOX_GET/MODLOOK: nouveux appels
;			DBOX_IFEXIST: nouvel appel
;			DBOX_CHGDESC: nouvel appel
; ------------------------------------------------------------------------------------------------
; 2.38	02.07.93	DBOX_PREND: mode BDBIONCLE pour TOTO_E.CODE
; 2.37	21.05.93	DBOX_PREND: liste classe par extensions
;			DBOX_ARBRE: icne pour choisir si voir les dossiers cachs
;			DBOX_ARBRE: si pre cach -> cache aussi les dossiers fils
;			DBOX_CHERCHE: cherche aussi les *.CODE si critre le demande
;			DBOX_CHERCHE: si "#MM0: REP:*ABC*" (espace !) -> ne plante plus
; 2.36	25.02.93	DBOX_PREND: cherche des icnes systme 9.0 ou 8.0 !
; 2.35	18.02.93	DBOX_SAUVE: localise le dossier seul, sans chercher le nom dj existant
;			DBOX_SAUVE: icne "oeil" toujours grise
;			DBXO_PREND: icnes: effet rapide apparat/disparat supprim
;			DBOX_PREND: recherche nom dans scroll-liste ok si cl frappe
;			DBOX_PREND: si fichier verrouill -> icne petite cl dans liste
;			DBOX_ARBRE: cherche le nom tap au clavier
; 2.34	01.02.93	DBOX_CHERCHE: cherche selon un contenu ventuel
;			DBOX_PREND: nouvelles icnes "cache", "ouvre", "ferme", etc.
;			DBOX_PREND: n'affiche plus "#IMPRIMERIE" dans les listes
; 2.33	11.01.93	DBOX_PREND: nouvelle icne "colle"
;			DBOX_ARBRE: accepte le mode BDBIOACT
;			DBOX_MLFADD/SUB: nouveaux appels
; 2.32	24.12.92	DBOX_MAJ/EFFACE: si numro dans D3 avec !2^15 -> caractre ASCII
;			DBOX_PREND: exploration -> affiche <termine>/<stoppe> en inverse
; 2.31	13.11.92	DBOX_ERCALL: n'essaye pas tous les formats si disquette protge
; 2.30	12.11.92	DBOX_PREND: accs en petit, correction pour SMAKY100
; 2.29	07.10.92	DBOX_PREND: affiche en petit l'accs si dialogue ferm
; 2.28	24.09.92	DBOX_ZOOM: selon "ouvertures/fermetures rapides"
;			DBOX_PREND: si pas d'accs aux serveurs -> aussi dans liste gauche
; 2.27	03.08.92	DBOX_PREND: correction petite erreur de localisation !
; 2.26	07.07.92	DBOX_PREND: localise mieux option si DIR avec ","
;			DBOX_PREND: triple-clic -> prend/ajoute
; 2.25	29.06.92	DBOX_ERCALL: essaye tous les formats d'une disquette (DISK_RETRY) ...
;			DBOX_PREND: utilise DBOX_ERCALL
;			DBOX_PREND: icnes grises selon OINFIL (avec DEF_SMAKY.CODE)
;			DBOX_PREND/SAUVE: modes ouvert/ferm spars
; 2.24	25.06.92	DBOX_PREND: localise option correctement si DIR avec ","
; 2.23	13.05.92	DBOX_PREND: curseur d'dition positionn selon la souris
;			DBOX_PREND: ne rend pas le dossier si gal au dossier courant
; 2.22	30.03.92	DBOX_EXTRAIT: affiche SAUVE au lieu de PREND
; 2.21	20.03.92	DBOX_PREND: BDBIOACT permet de remplacer PREND par RAMENE
;			DBOX_ARBRE: nouvel appel
;			DBOX_CHERCHE: nouvel appel
;			DBOX_VISU: nouvel appel
; 2.20	12.03.92	DBOX_PREND: "DANIEL" --> "MM1 = DANIEL"
; 2.19	14.02.92	DBOX_PREND: petites amliorations
;			DBOX_PREND: utilise les ressources
;			DBOX_POSDIM: nouvel appel
;			DBOX_ZOOM: nouvel appel
; 2.18	10.02.92	DBOX_PREND: refonte complte avec 8 icnes dans la partie rduite
; 2.17	09.12.91	DBOX_EDIT: dtection rectangles plus prcise
;			DBOX_PREND: case ">>" pour choix chemin/unit ...
; 2.16	17.10.91	DBOX_KHELP: clear BNODES !
; 2.15	21.06.91	DBOX_PREND: correction "de la image" -> "de l'image"
;			DBOX_PREND: LISTE utilise l'extension dite
; 2.14	04.06.91	?
; 2.13	23.05.91	DBOX_ERCALL: utilise le module SMA_DISK.LIB
; 2.12	08.05.91	ODBKHELP: nouvel objet pour raccourcis clavier
;			DBOX_KHELP: nouvel appel pour raccourcis clavier
;			DBOX_ERCALL: utilise FOS,?ARGSOPEN pour formater
;			DBOX_PREND: [M,F]mot = singulier et [m,f]mot = pluriel
; 2.11	06.07.89	DBOX_ERCALL: ne force plus le terminateur
; 2.10	04.07.89	DBOX_PREND: accepte un nom du type "#PP" ou "#PP:"
;			DBOX_ERCALL: FOS,?XERROR avec BERUNAM
; 2.9	28.06.89	DBOX_ERCALL: FOS,?ERRNAME remplac par FOS,?XERROR
;			DBOX_ERCALL: BIOS,?DREAD et ?DWRITE supprims
; 2.8	28.04.89	DBOX_ERCALL: utilise FOS,?FOS
; 2.7	11.04.89	DBOX_ERCALL: plus de code excut sur le stack (cache du 68020 !)
; 2.6	25.01.89	DBOX_SAUVE: jamais (SAUVE) et (MET A JOUR) griss les deux
; 2.5	19.12.88	DBOX_SAUVE: ok si ni BDBIOEXT1 ni BDBIOEXTM
; 2.4	05.10.88	DBOX_PREND: si LISTE et extension "?" => prend celle en dition
;			DBOX_PREND: si lg extension > 7 => ODBXFILE plus large
;			ODBCR2: nouvel objet = 0.5 x ODBCR
;			ODBTAB[X,Y]N: nouveaux objets de positionnement en points
; 2.3	05.09.88	DBOX_PREND: accepte extensions "!"
;			DBOX_PREND: si annule => ne change pas le nom
;			DBOX_PREND: BDBIOFULL!BDBIOEXTM possible (pour PLUME)
; 2.2	12.07.88	DBOX_AJOUTE: si BDBIOEXTM et *.TABLE => AJOUTE jamais gris
; 2.1	05.07.88	DBOX_MERROR: ok si position dans D3.L
; 2.0	13.04.88	et vive la couleur !
; ------------------------------------------------------------------------------------------------
; 1.30	17.02.88	ODBCIRCLE/ODBSQUARE: position en X modulo 2
;			DBOX_SAUVE: plus gris si fanions changs
; 1.29	19.01.88	DBOX_PREND, etc. avec D5=position si D2:#BDBPOS
; 1.28	25.11.87	DBOX_ERROR: fond blanc seulement si ncessaire
;			DBOX_ICOxx selon ODFPSK.L
; 1.27	20.11.87	DBOX_ERCALL: si protect => refait toujours l'enter
; 1.26	17.11.87	DBOX_ERCALL: si formate => message plus court
; 1.25	12.11.87	DBOX_ERCALL utilise LIB,?PUSHMENU/LIB,?POPMENU
; 1.24	27.10.87	DBOX_PREND,AJOUTE,SAUVE,EXTRAIT avec nom + extension
;			DBOX_ERROR avec joli "blup" !
; 1.23	15.10.87	DBOX_PREND,AJOUTE,SAUVE,MAJ,QUITTE,DETRUIT,EFFACE
;			ODBXLINE,ODBXFILE
;			DBOX_GETCO avec BDBGCGREY/BDBGCFULL
; 1.22	25.09.87	DBOX_MERROR utilise FOS,?XERROR
; 1.21	11.09.87	DBOX_TERROR avec BDBDET pour la case (DETAILS)
; 1.20	31.08.87	DBOX_EXTEND pour rajouter 2^16 appels  DBOX
;			DBOX_ERCALL essaye de rsoudre qq problmes
;			DBOX_OPWAIT et DBOX_CLWAIT
; 1.19	04.08.87	ODBLCIRCLE avec petit cercle autour
;			OFADESS pour dessiner les fanions + rapidement
; 1.18	29.07.87	DBOX_TERROR s'adapte selon le texte (en X et Y)
;			DBOX_ERROR utilise DBOX_TERROR (donc + joli)
;			ODBLABEL nouvel objet pour DBOX_GETCO
; 1.17	27.05.87	ODBSQUARE aligns avec les ODBCIRCLE
; 1.16	12.01.87	DBOX_OPEN avec BDBMAX => plus de marges
; 1.15	19.12.86	DBOX_AFFILE utilise LIB,?AFXFILE (cache la clef)
; 1.14			DBOX_OPEN fait un LIB,?CLREDIT
; ------------------------------------------------------------------------------------------------




	.REV	DBOXREV,DBOXVERS
	.IDENT	"(C)  Daniel ROUX et EPSITEC SA"



; Constantes
; ----------

TDBEDIT		= 4			; ODBBOX ditable
BDBGLAD		= 14

MARGGD		= 2			; marge gauche/droite
MARGSI		= 2			; marge suprieure/infrieure

MTERRX		= 4			; marge en X pour DBOX_TERROR
MTERRY		= 6			; marge en Y pour DBOX_TERROR

KEYDBOX		= 16'7E00		; "touche" spciale pour DBOX

GCKRF		= "K"			; fonte des touches KRP07
GCKRS		= "R"			; style/chasse des touches
GCKRT		=  7			; taille des touches

GCTPF		= "N"			; fonte des petits caractres NRF07
GCTPS		= "R".OR.2**7		; style/chasse des petits caractres
GCTPT		= 7			; taille des petits caractres



; Table pour les fichiers/lignes ditables
; ----------------------------------------

MAXFILE		=	20

		.LOC	0
OFITYP:		.BLK.8	1		; type 0=fichier/1=ligne
		.EVEN
OFIPOS:		.BLK.32	1		; position dbut pour dition
OFILG:		.BLK.32	1		; longueur et flags
LGFI:


; Fanions pour OINSTA
; -------------------

BINFK10		= 0			; dbox info:  l'enfoncement
BINFK11		= 1			; dbox info: 
BINFK12		= 2			; dbox info: 
BINFK13		= 3			; dbox info: 
BINFK20		= 4			; dbox info: par la suite
BINFK21		= 5			; dbox info: 
BINFK22		= 6			; dbox info: 
BINFK23		= 7			; dbox info: 
BINFS0		= 8			; dbox info: sleep jamais
BINFS5		= 9			; dbox info: sleep 5'
BINFS15		= 10			; dbox info: sleep 15'
BINFS60		= 11			; dbox info: sleep 60'
BINFMD0		= 16			; dbox info: dplacement souris
BINFMD1		= 17			; dbox info: 
BINFMD2		= 18			; dbox info: 
BINFMA0		= 19			; dbox info: acclration souris
BINFMA1		= 20			; dbox info: 
BINFMA2		= 21			; dbox info: 
BINFLOOKHILITE	= 23			; dbox info: hilite plutt que press
BINFDIA		= 24			; dbox info: diapos
BINFLRD		= 25			; dbox info: liste rduite dans les dossiers (voir LIST)
BINFBSA		= 26			; dbox info: beep selon 300_SYNT.AUDIO
BINFRAP		= 27			; dbox info: rapide
BINFLOOKOLD	= 28			; dbox info: look ancien
BINFLOOK3D	= 29			; dbox info: look 3D
BINFLOOKNOS	= 30			; dbox info: look nostalgique
BINFLOOKOM	= 31			; dbox info: look OM


; Fanions pour OINFIL
; -------------------

BINFFOPEN	= 0			; fichiers: dialogue tendu
BINFFUNIT	= 1			; fichiers: menu des units
BINFFPATH	= 2			; fichiers: menu des chemins
BINFFHOME	= 3			; fichiers: menu de la maison
BINFFFILE	= 4			; fichiers: menu des derniers fichiers
BINFFTREE	= 5			; fichiers: arbre
BINFFSEARCH	= 6			; fichiers: recherches
BINFFSHOW	= 7			; fichiers: visualisation
BINFFOPDIR	= 8			; fichiers: OUVRE
BINFFCLDIR	= 9			; fichiers: FERME
BINFFSERV	= 10			; fichiers: accs aux autres serveurs
BINFFMPATH	= 11			; fichiers: ajoute/modifie chemins
BINFFDRACC	= 12			; fichiers: affiche l'accs en petit
BINFFPAST	= 13			; fichiers: colle un nom
BINFFCACHE	= 14			; fichiers: montre les fichiers cachs
BINFFRELIST	= 15			; fichiers: refait la liste
BINFFPUT	= 16			; fichiers: met ->

BINFFGENC	= 24			; fichiers: undefine DEF_GENC
BINFFHELPP	= 25			; fichiers: PREND avec aide (grand)
BINFFHELPS	= 26			; fichiers: SAUVE avec aide (grand)
BINFFAUTODIRP	= 27			; fichiers: PREND supprime DIR automatiquement
BINFFAUTODIRS	= 28			; fichiers: SAUVE supprime DIR automatiquement
BINFFLISTALL	= 29			; fichiers: liste toutes les options




; Variables pour les recherches
; -----------------------------

SRLGNM		= 200			; lg max d'un nom
SRLGNMAFF	= 70			; lg max pour afficher un nom

		.LOC	0
OSRMAX:		.BLK.16	1		; nb max de noms
OSRUSE:		.BLK.16	1		; nb de noms contenus
OSRDATA:				; data ...


; Variables pour IO
; -----------------

ICEOPCL		= 0			; ouvre/ferme dialogue
ICEUNIT		= 1			; change d'unit
ICEPATH		= 2			; menu des chemins
ICEHOME		= 3			; menu de la maison
ICEMLF		= 4			; menu des derniers noms
ICEPAST		= 5			; colle un nom
ICETREE		= 6			; montre l'arbre
ICESRC		= 7			; recherche le document
ICESHOW		= 16			; visualise le document
ICECACHE	= 17			; (d-)cache
ICEOPEN		= 18			; ouvre dossier
ICECLOSE	= 19			; ferme dossier
ICERELIST	= 20			; refait la liste
ICEPUT		= 21			; met le nom
ICEPATHUSE	= 100			; utilise un chemin
ICEDIR		= 101			; set-directory
ICESLMAJ	= 102			; refait la liste
ICETAKE		= 103			; prend/ajoute

PIOSCL		= 28			; position pour scroll-liste

LIONAM		= 200			; lg max pour nom
LIOEXT		= 20			; lg max pour extension

		.LOC	0
OIOAPP:		.BLK.16	1		; code du sous-appel
OIOFLG:		.BLK.32	1		; flags
OIOFLS:		.BLK.32	1		; flags supplmentaires
OIOFAN:		.BLK.32	1		; fanions
OIOMOD:		.BLK.16	1		; mode d'ouverture
OIOPOS:		.BLK.32	1		; position
OIODBP:		.BLK.32	1		; ancienne position
OIODBD:		.BLK.32	1		; ancienne dimensions
OIODBC:		.BLK.32	1		; canal de la DBOX
OIOPDI:		.BLK.32	1		; ^descripteur de la fentre
OIOPNA:		.BLK.32	1		; ^buffer pour nom
OIOPT0:		.BLK.32	1		; ^texte A0
OIOPT1:		.BLK.32	1		; ^texte A1
OIOPT2:		.BLK.32	1		; ^texte A2
OIOPT3:		.BLK.32	1		; ^texte A3
OIOPEX:		.BLK.32	1		; ^extension(s)
OIOPLI:		.BLK.32	1		; ^liste des dossiers
OIOPTH:		.BLK.32	1		; ^chemins
OIOPTR:		.BLK.32	1		; ^arbre
OIOPSR:		.BLK.32	1		; ^recherche
OIOSRNAME:	.BLK.8	SRLGNM		;  nom d'une recherche (temporaire)
OIORUN:		.BLK.16	1		; rang undo
OIOTMP1:	.BLK.8	LIONAM		; buffer temporaire
OIOTMP2:	.BLK.8	LIONAM		; buffer temporaire
OIOOLD:		.BLK.8	LIONAM		; nom initial tel quel
OIOINI:		.BLK.8	LIONAM		; nom initial complet
OIODIR:		.BLK.8	LIONAM		; dossiers en dition
OIOLDI:		.BLK.8	LIONAM		; derniers dossiers
OIOSDI:		.BLK.8	LGNAME		; dossier supprim
OIOCRI:		.BLK.8	LIONAM		; critre pour la liste
OIONAM:		.BLK.8	LIONAM		; nom en dition
OIOEXT:		.BLK.8	LIOEXT		; extension en dition
OIOLEX:		.BLK.8	LIOEXT		; dernire extension
OIOCLE:		.BLK.8	LGNAME		; cl en entre
OIOTRN:		.BLK.8	16		; nom du dossier cherch dans l'arbre
OIOTXT:		.BLK.8	5000		; texte construit
OIOAOPEN:	.BLK.8	LIONAM		; temporaire pour ARGSOPEN
OIOTAB:		.BLK.8	500		; table de description de la dbox
OIOBST:		.BLK.8	LGMAM0		; buffer pour les status
OIOSLI:		.BLK.8	LSLVAR		; variables scroll-liste des units/fichiers
OIOSLT:		.BLK.8	LSLVAR		; variables scroll-liste de l'arbre
OIOFIL:		.BLK.32	1		; copie de info.OINFIL
OIOICG:		.BLK.32	1		; icnes grises
OIOHLP:		.BLK.8	1		; 1 => mode AIDE
OIOALL:		.BLK.8	1		; 1 => liste tous les fichiers
OIOIFS:		.BLK.8	1		; 1 => utilise OIOSDI
		.EVEN
LGVARIO:


; Variables pour les listes
; -------------------------

		.LOC	0
OLINAM:		.BLK.8	LGNAME		; nom
OLIRS1:		.BLK.16	1		; ressource principale (ICON_*)
OLIRS2:		.BLK.16	1		; ressource secondaire (ICON_*)
OLIOTHER:	.BLK.8	1		; TRUE => provient d'un autre dossier
OLISEP:		.BLK.8	1		; TRUE => sparation principale
		.EVEN
LLI:


; Variables pour les dernires positions
; --------------------------------------

MAXLP		= 20			; nb max de positions mmorises

		.LOC	0
OLPCHK:		.BLK.32	1		; check dbox
OLPPOS:		.BLK.32	1		; position (y;x)
OLPUSE:		.BLK.16	1		; numro d'utilisation
LLP:


; Variables pour les chemins
; --------------------------

LGMLF		= 400			; lg max menu des derniers fichiers
MAXPATH		= 1000			; lg max pour les chemins

		.LOC	0
OGCRIC:		.BLK.32	1		; canal ressources ICON
OGCRDB:		.BLK.32	1		; canal ressources DBOX

OgPMCPT:	.BLK.32	1		; ^compte mmoire DBOX
OgIMHEAD:	.BLK.8	LGHIMA		;  en-tte image
OgIMPCLUT:	.BLK.32	1		; ^CLUT associe
OgIMPPIX:	.BLK.32	1		; ^pixels de l'image

OPHUSE:		.BLK.8	1		; 1 => variables dj utilises
OPHHLPP:	.BLK.8	1		; 1 => mode aide avec PREND/AJOUTE
OPHHLPS:	.BLK.8	1		; 1 => mode aide avec SAUVE/EXTRAIT
OPHALL:		.BLK.8	1		; 1 => liste tous les fichiers
OGLOOK:		.BLK.8	1		; 0 => old, 1 => new, 2 => nostalgique
OGLOOKY:	.BLK.8	1		; T => utilise SMA_DBOY.COLOR
OGAEQa:		.BLK.8	1		; T => "A=a" dans les recherches
OGSRCALL:	.BLK.8	1		; T => "tous" dans les recherches
		.EVEN
OPHMLFS:	.BLK.32	1		; menu ^smaphore
		.BLK.32	1		; menu place pour 1re case vide
OPHMLF:		.BLK.8	LGMLF		; menu des derniers fichiers
OLPCNT:		.BLK.16	1		; compteur pour les utilisations
OLP:		.BLK.8	LLP*MAXLP	; table des dernires positions
LPH:

; Variables pour les onglets
; --------------------------

MAXTAB		= 10			; au plus 10 onglets (et encore !)

		.LOC	0

OTIKEY:		.BLK.16	1		; touche  gnrer
OTIPOS:		.BLK.16	2		; position sup/gauche
OTIDIM:		.BLK.16	2		; dimensions
LGTABINF:


; Variables pour ERCALL
; ---------------------

		.LOC	0
OECPPM:		.BLK.32	1		; canal LIB,?PUSHMENU/?POPMENU
OECTIM:		.BLK.16	1		; timeout
OECWDO:		.BLK.16	1		; numro swdo
OECCDB:		.BLK.32	1		; canal dbox
OECNAM:		.BLK.8	50		; nom du fichier
OECTXT:		.BLK.8	50		; texte quelconque
OECSTA:		.BLK.8	LGMAM0		; status
LGVAREC:



; Variables
; ---------

		.LOC	0
OFLAGS:		.BLK.8	1		; flags divers
 BNODES		= 0			;  pas de dessin
 BFADES		= 1			;  dessine les fanions
 BTITLE		= 2			;  titre dans swdo
 BCHECK		= 3			;  check
OSVMOD:		.BLK.8	1		; sauvetage de ODFMOD
OSVFLG:		.BLK.8	1		; sauvetage de ODFFLG
OnoPAST:	.BLK.8	1		; n'accepte pas de coller (CURSOR-SPACE)
OACTTAB:	.BLK.8	1		; onglet actif
		.EVEN
OSVWDO:		.BLK.16	1		; no swdo initiale
OSVOPM:		.BLK.16	1		; mode d'ouverture

OPTABLE:	.BLK.32	1		; ^table
OPTABS:		.BLK.32	1		; ^onglets
OOTABS:		.BLK.16	2		; origine des onglets (pour DRAWTABS)
ONTABS:		.BLK.16	1		; nombre max d'onglets trouvs
OTABINF:	.BLK.8	LGTABINF*MAXTAB	; infos sur les onglets
OMODE:		.BLK.16	1		; mode d'ouverture
ONOWDO:		.BLK.16	1		; numro de la swdo
ODIMWDO:	.BLK.32	1		; dimensions de la swdo

OPOSEXT:	.BLK.32	1		; position swdo extrieure
ODIMEXT:	.BLK.32	1		; dimensions swdo extrieure

OPOSSAV:	.BLK.32	1		; pos. pour SAVWDO/GETWDO
ODIMSAV:	.BLK.32	1		; dim. pour SAVWDO/GETWDO
OBPPSAV:	.BLK.16	1		; bpp de la fentre sauve

OMARGTOP:	.BLK.16	1		; marge suprieur additionnelle (onglets)
OMARGY:		.BLK.16	1		; marges sup/inf
OMARGX:		.BLK.16	1		; marges gauche/droite

OWDPOS:		.BLK.32	1		; wdo: position
OWDDIM:		.BLK.32	1		; wdo: dimensions

ONBFILE:	.BLK.16	1		; nb max de fichiers/lignes
ONOFILE:	.BLK.16	1		; no du fichier/ligne
OUSFILE:	.BLK.16	1		; fichier/ligne utilis
OTAFILE:	.BLK.8	MAXFILE*LGFI	; table des fichiers/lignes ditables

OFANION:	.BLK.32	1		; tats des fanions
OFACIRC:	.BLK.32	1		; fanions pour les cercles
OFADESS:	.BLK.32	1		; fanions dessins  l'cran

OPDDIS:		.BLK.32	1		; ^description relle de la fentre
OSVGC:		.BLK.32	1		; sauvetage FST initial

OCX:		.BLK.16	1		; copie de ODFCX
OCY:		.BLK.16	1		; copie de ODFCY
OC1Y:		.BLK.16	1		; copie de ODFC1Y
OC2Y:		.BLK.16	1		; copie de ODFC2Y

OlPIMA:		.BLK.32	1		; ^image convertie (fin de ce buffer)
OlPGLO:		.BLK.32	1		; ^variables globales
OlCFOND:	.BLK.32	1		;  couleur de fond

OlL3DOK:	.BLK.8	1		; TRUE -> look 3D ok
OlICEinv:	.BLK.8	1		; TRUE -> icone inverse
OlTIMAok:	.BLK.8	1		; TRUE -> image COLOR traduite
OLOOK:		.BLK.8	1		; TRUE -> new look
OBIG:		.BLK.8	1		; TRUE -> grande taille (NRF09, NEF11, etc.)
ONOSTALGIE:	.BLK.8	1		; TRUE -> nouveau look, ancienne mode
OTOTOGLAD:	.BLK.8	1		; TRUE -> TOTO heureux
ORGBCONVOK:	.BLK.8	1		; TRUE -> conversion RGB vers couleurs palette ok
		.EVEN

ORGBCONVTABLE:	.BLK.32	16		; table des couleurs RGB converties

OMAPGR:		.BLK.8	256/8		; map des objets griss
		.EVEN

LGVAR:



; En-tte du module LIB
; ---------------------

	.LOC	0
DEBUT:
	DBOX_	FIRST			; code du premier appel
	DBOX_	LAST			; code du dernier appel
	.8	0			; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	DBOXREV,DBOXVERS	; rvision.version
	.16	0,END_DBOX		; longueur
	.16	(PATHLIB.AND.16'FFFF0000)/16'10000; pattern de dbut
	.16	PATHLIB.AND.16'FFFF	; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"DBOX"			; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_DBOX_OPEN
	.16	_DBOX_EDIT
	.16	_DBOX_CLOSE
	.16	_DBOX_CADRE
	.16	_DBOX_GETCO
	.16	_DBOX_CALLC
	.16	_DBOX_ERROR
	.16	_DBOX_MEDIT
	.16	_DBOX_TERROR
	.16	_DBOX_MERROR
	.16	_DBOX_AFFILE
	.16	__DBOX_ICOCADRE
	.16	__DBOX_ICOAFF
	.16	__DBOX_ICODET
	.16	__DBOX_ICOINV
	.16	__DBOX_ICOPOS




; Codes des appels
; ----------------


;-------------\\
; _DBOX_TERROR >
;=============/

; Affiche une erreur sous forme d'un texte dans une dbox.
; Le texte peut contenir plusieurs lignes de longueurs diffrentes
; (la DBOX s'adapte automatiquement). Par exemple:
;	.ASCII	"L'espace disque est insuffisant<CR>"
;	.ASCIZ	"pour cette opration !"
; Le texte est affich en vido-inverse, sauf s'il commence par
; un AFDIR. Par exemple:
;	.ASCIZ	"<AFDIR>Fin du transfert"
; Il faudra redessiner les soft-keys (LIB?AFMENU).
; Il faut faire LIB?BEEP avec D3=BIPERR avant cet appel.

; in	A3.32	^texte de l'erreur (.ASCIZ avec CRs admis)
;	D2.16	mode d'ouverture (BDBDET si case DETAILS)
;	D3.32	position centre (si BDBPOS)
; out	D3.16	dernire touche (F1/DEFINE) si BDBDET
;	D7.16	erreur
; mod	D3.32, D7.16

_DBOX_TERROR:
	PUSHM.32 D1|D2|D4|D5|A1..A4
	PUSH.32	D3

	SUB.A16	#100,SP			; rserve 100 bytes sur le stack (PUSH)
	MOVE.32	SP,A2			; A2 <-- ^buffer sur le stack

; Calcule le nombre de lignes/colonnes dans le texte donn en entre.

	CLR.32	D1			; D1 <-- (dy;dx)
	MOVE.32	A3,A4			; A4 <-- ^texte
CNTY$:
	ADD.32	#16'10000,D1		; D1 <-- une ligne de plus (+dy)
	CLR.16	D5
CNTX$:
	MOVE.8	{A4+},D4
	JUMP,NS	CNTX$			; ignore les AFINV, AFDIR, etc.
	JUMP,EQ	R8^CNT3$
	INC.16	D5			; D5 <-- une colonne de plus (+dx)
	COMP.8	#CR,D4
	JUMP,NE	CNTX$
	DEC.16	D5
CNT3$:
	COMP.16	D5,D1
	JUMP,HS	R8^CNT4$
	MOVE.16	D5,D1			; D1 <-- ligne la plus large (>dx)
CNT4$:
	TEST.8	D4
	JUMP,NE	CNTY$
	ADD.16	#2,D1			; D1 <-- espaces  gauche et  droite

; Construit dynamiquement la table pour la DBOX.

	MOVE.32	A2,A1			; A1 <-- ^buffer (sur le stack)
	MOVE.16	#4*2,{A1+}		; buffer <-- .W  DESC_TERROR-TABLE_TERROR
	CLR.16	{A1+}			; buffer <-- .W  MENU_ERROR-TABLE_TERROR
	CLR.32	{A1+}			; buffer <-- .W  0  (2x)

	MOVE.32	#R16^TDBOX_TERR0,A4
	MOVE.16	#LDBOX_TERR0-1,D4
ERR0$:
	MOVE.8	{A4+},{A1+}		; buffer <-- dbut de la table
	DJ.16,NMO D4,ERR0$

	MOVE.32	D1,D4			; D4 <-- dimensions (dy;dx)
	SWAP.32	D4
	DEC.16	D4
	JUMP,EQ	R8^PUTYT$
PUTY$:
	MOVE.8	#ODBCR,{A1+}		; buffer <-- .B  ODBCRs (selon dy)
	DEC.16	D4
	JUMP,NE	PUTY$
PUTYT$:
	MOVE.8	#ODBTABX,{A1+}
	SWAP.32	D4
	ADD.16	#10,D4
	MOVE.8	D4,{A1+}		; buffer <-- .B  ODBTABX,dx

	MOVE.32	#R16^TDBOX_TERR1,A4
	MOVE.16	#LDBOX_TERR1-1,D4
ERR1$:
	MOVE.8	{A4+},{A1+}		; buffer <-- reste de la table
	DJ.16,NMO D4,ERR1$

	TEST.32	D2:#BDBDET		; case dtails ?
	JUMP,BC	R8^MENU$

	DEC.32	A1
	MOVE.32	#R16^TDBOX_TERR2,A4
	MOVE.16	#LDBOX_TERR2-1,D4
ERR2$:
	MOVE.8	{A4+},{A1+}		; buffer <-- case (DETAILS)
	DJ.16,NMO D4,ERR2$
MENU$:
	MOVE.32	A1,D4
	SUB.32	A2,D4
	MOVE.16	D4,{A2}+2		; buffer <-- .W  MENU_ERROR-TABLE_TERROR

	MOVE.32	#R16^TDBOX_TERR3,A4
	MOVE.16	#LDBOX_TERR3-1,D4
ERR3$:
	MOVE.8	{A4+},{A1+}		; buffer <-- menu pour les soft-keys
	DJ.16,NMO D4,ERR3$

	TEST.32	D2:#BDBDET		; case dtails ?
	JUMP,BC	R8^OPEN$

	DEC.32	A1
	MOVE.32	#R16^TDBOX_TERR4,A4
	MOVE.16	#LDBOX_TERR4-1,D4
ERR4$:
	MOVE.8	{A4+},{A1+}		; buffer <-- dtails
	DJ.16,NMO D4,ERR4$

; Ouvre la DBOX construite dynamiquement.

OPEN$:
	DBOX_	OPEN			; ouvre la swdo
	JUMP,NE	EXIT$

	PUSH.32	A6
	MOVE.32	D5,A6
	TEST.32	D2:#BDBGLAD
	SET.8,T	{A6}+OTOTOGLAD		; rend Toto/Blupi heureux si demand
	POP.32	A6

; Affiche le texte (message d'erreur) dans la DBOX.

	CALL	GETPSW			; A1 <-- ^descripteur de la fentre

	MOVE.32	#COLOR_DBERROR,D3
	LIB	?COLORSR		; met la couleur des erreurs

	PUSH.32	D2
	MOVE.16	#1.OR.2**BDBGCLABEL,D2
	DBOX_	GETCO			; D3 <-- dbut 1er texte
	MOVE.32	D3,D4			; D4 <-- position
	ADD.16	{A1}+ODFCX,D4
	POP.32	D2

	MOVE.32	A3,A2			; A2 <-- ^dbut du texte
	COMP.8	#AFDIR,{A2}		; faut-il ne pas inverser le texte ?
	JUMP,NE	R8^AFFY$		; non => AFFY$
	INC.32	A3			; A3 <-- saute le AFDIR
AFFY$:
	MOVE.32	A3,A4
	MOVE.16	#-1,D3
AFFX$:
	INC.16	D3			; D3 <-- compte le nb de caractres
	TEST.8	{A4+}
	JUMP,EQ	R8^AFF3$
	COMP.8	#CR,{A4}-1
	JUMP,NE	AFFX$
AFF3$:
	PUSH.32	D3
	MOVE.32	D4,D3			; D3 <-- position
	LIB	?SETCURS
	POP.32	D3
	LIB	?STRING			; affiche une ligne

	TEST.8	{A4}-1			; fin des lignes ?
	JUMP,EQ	R8^CADRE$		; oui => CADRE$
				; non =>
	MOVE.32	A4,A3			; A3 <-- ^ligne suivante
	SWAP.32	D4
	ADD.16	{A1}+ODFCY,D4		; D4 <-- position ligne suivante
	SWAP.32	D4
	JUMP	AFFY$

; Inverse tout le texte affich.

CADRE$:
	MOVE.8	#AFDIR,D3
	LIB	?AFCAR			; on n'sait jamais !

	CLR.16	D1			; D1 <-- mode
	COMP.8	#AFDIR,{A2}		; faut-il ne pas inverser le texte ?
	JUMP,EQ	R8^NORM$		; oui => NORM$
	TSET.32	D1:#0			; D1 <-- inverse le texte
NORM$:
	CALL	CADRE			; dessine le cadre
	CALL	DRBLUP			; dessine l'icne du "blup"
	CALL	INVWDO			; inverse toute la dbox

; Attend tranquillement que l'on clique sur (VU).

LOOP$:
	DBOX_	EDIT			; attend touche/souris ...
	MOVE.32	#R16^TKEY_ERROR,A1
	MOVE.16	#2**BDBCCMM.OR.2**BDBCCFF,D1
	DBOX_	CALLC			; touche admise ?
	COMP.16	#KEYMGR,D3
	JUMP,EQ	LOOP$
	COMP.16	#F1,D3
	JUMP,EQ	R8^QUIT$
	COMP.16	#DEFINE,D3
	JUMP,EQ	R8^QUIT$
	MOVE.32	#BIPLIT,D3		; non =>
	LIB	?BEEP			; p'tit bruit
	JUMP	LOOP$
QUIT$:
	DBOX_	CLOSE			; ferme la swdo
EXIT$:
	ADD.A16	#100,SP			; reprend le buffer sur le stack (POP)

	POP.32	D4
	TEST.32	D2:#BDBDET		; case dtails ?
	JUMP,BS	R8^OUT$
	MOVE.32	D4,D3			; D3 <-- restitue la valeur initiale
OUT$:
	POPM.32	D1|D2|D4|D5|A1..A4
	TEST.16	D7			; retour EQ/NE
	RET

;--------\\
; DRBLUP  >
;--------/

; Dessine l'icne "blup" dans une dbox.

; in	D3.32	position rectangle (y;x)
;	D4.32	dimensions rectangle (dy;dx)
;	D5.32	canal dbox
; out	-
; mod	D7.16

DRBLUP:
	PUSHM.32 D0..D4|D6|A3|A4

	MOVE.32	D3,D1
	ADD.16	#8,D1
	SWAP.32	D4
	MOVE.16	D4,D0
	SWAP.32	D1
	ADD.16	D4,D1
	SUB.16	#2,D1
	SWAP.32	D1			; D1 <-- P1 droite

	SUB.A16	#12,SP			; rserve 12 bytes sur le stack (PUSH)
	MOVE.32	#{SP}+1,A3		; A3 <-- ^buffer sur le stack

	MOVE.8	#DRAWMATRIX,{A3}+0

	MOVE.16	#10.OR.2**BDBGCLABEL,D2
	DBOX_	GETCO
	ADD.16	#4,D3
	SWAP.32	D3
	ADD.16	#-15,D3
	ADD.16	D0,D3

	MOVE.32	D3,{A3}+1		; <xx> et <yy>
	ADD.16	#27,D3
	SWAP.32	D3
	ADD.16	#48,D3
	MOVE.32	D3,D0			; D0 <-- P2 droite

; D3.32	[y;x] pour BLUPI... On tente de dessiner en 3D...

	PUSHM.32 D3|D4|A6

	MOVE.32	D5,A6			; A6 <-- ^variables locales DBOX
	MOVE.32	#ICON_TOTO,D6		; D6 <-- icone par dfaut (triste)
	TEST.8	{A6}+OTOTOGLAD		; Toto est-il heureux ?
	JUMP,F	R8^SAD$			; non => triste
	MOVE.32	#ICON_TOTOGLAD,D6	; oui => joyeux

SAD$:	MOVE.32	{A3}+1,D4
	SWAP.32	D4			; D4 <-- origine sup/gauche
	MOVE.32	D6,D3			; D3 <-- icone
	CALL	_paDRAWICON
	POPM.32	D3|D4|A6
	JUMP,EQ	ERR$

	PUSHM.32 D0|D1
	MOVE.32	#RtypRASTER,D0
	MOVE.32	D6,D1
	CALL	RESGETDBOX		; A4 <-- ^dx,dy,matrice
	POPM.32	D0|D1
	JUMP,NE	R8^ERR$
	MOVE.32	A4,{A3}+5		; <pppp>

	MOVE.8	#INVDOT,{A3}+9		; <m>

	MOVE.32	#10,D3
	LIB	?STRING

ERR$:	ADD.A16	#12,SP			; reprend le buffer sur le stack (POP)

	LIB	?BUCAR

	MOVE.32	D0,D3
	MOVE.32	D1,D4

	MOVE.16	#17,D1
	MOVE.32	#SETDOT,D2
	CALL	DRTRIANGLE
	INC.16	D3
	CALL	DRTRIANGLE
	INC.16	D3
	CALL	DRTRIANGLE
	INC.16	D3
	CALL	DRTRIANGLE

	MOVE.32	#CLRDOT,D2

	DEC.16	D3
	SWAP.32	D3
	DEC.16	D3
	SWAP.32	D3
	INC.16	D4
	SWAP.32	D4
	INC.16	D4
	SWAP.32	D4

	PUSHM.32 D3|D4
	SUB.16	D3,D4
	SWAP.32	D3
	SWAP.32	D4
	SUB.16	D3,D4
	SWAP.32	D3
	SWAP.32	D4
	LIB	?DRSEG			; dessine droite de liaison pour la bulle
	CLR.32	D4
	MOVE.16	#-3,D4
	LIB	?DRSEG
	POPM.32	D3|D4

	ADD.16	#12,D4

	PUSHM.32 D3|D4
	SUB.16	D3,D4
	SWAP.32	D3
	SWAP.32	D4
	SUB.16	D3,D4
	SWAP.32	D3
	SWAP.32	D4
	LIB	?DRSEG			; dessine droite de liaison pour la bulle
	MOVE.32	#+3,D4
	LIB	?DRSEG
	POPM.32	D3|D4

	LIB	?NOBUCAR

	POPM.32	D0..D4|D6|A3|A4
	RET

;-----------\\
; DRTRIANGLE >
;-----------/

; Dessine un triangle plein.

; in	D3.L	bas
;	D4.32	haut
;	D1.16	largeur au sommet
;	D2.16	mode
; out	-
; mod	D7.W

DRTRIANGLE:
	PUSHM.32 D1|D3|D4
LOOP$:
	PUSHM.32 D3|D4
	SUB.16	D3,D4
	SWAP.32	D3
	SWAP.32	D4
	SUB.16	D3,D4
	SWAP.32	D3
	SWAP.32	D4
	LIB	?DRSEG			; dessine droite de liaison pour la bulle
	POPM.32	D3|D4

	INC.16	D4
	DEC.16	D1
	JUMP,NE	LOOP$

	POPM.32	D1|D3|D4
	RET



TDBOX_TERR0:
	.8	ODBLABEL,10		; label pour le signe BLUP
	.8	ODBTEXT,0
	.8	ODBTABX,10
	.8	ODBLABEL,1
	.8	ODBLABEL,20
	.8	ODBTEXT,0
LDBOX_TERR0	= APC-TDBOX_TERR0

TDBOX_TERR1:
	.8	ODBLABEL,21
	.8	ODBTEXT
	.ASCIZ	" "
	.8	ODBCR
	.8	ODBCR,ODBCR
	.8	ODBTABX,10
	.8	ODBBOX,0,F1,TDBMEV
	.ASCIZ	"   VU   "
	.8	0
LDBOX_TERR1	= APC-TDBOX_TERR1

TDBOX_TERR2:
	.8	ODBTEXT
	.ASCIZ	"    "
	.8	ODBBOX,0,DEFINE,TDBNORM
	.ASCIZ	" DETAILS "
	.8	0
LDBOX_TERR2	= APC-TDBOX_TERR2

TDBOX_TERR3:
	.ASCIZ	""
	.ASCIZ	""
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	"Vu"
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	""
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	""
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	""
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	""
LDBOX_TERR3	= APC-TDBOX_TERR3

TDBOX_TERR4:
	.ASCIZ	"Dtails"
LDBOX_TERR4	= APC-TDBOX_TERR4

	.EVEN


TKEY_ERROR:
	.16	KEYMGP,KEYMMP,KEYMDP
	.16	F0,F1,F2,F3,CR,END,SPACE,0,DOKF1-TKEY_ERROR
	.16	F13,F14,F15,DEFINE,0,DOKDEF-TKEY_ERROR
	.16	KEYMGR,KEYMMR,KEYMDR,0,DOKMGR-TKEY_ERROR
	.16	0



;------------\\
; _DBOX_ERROR >
;============/

; Affiche une erreur.
; Il faudra redessiner les soft-keys (LIB ?AFMENU).

; in	D7.16	code de l'erreur
;	A3.32	^nom du fichier
; out	-
; mod	-

_DBOX_ERROR:
	PUSHM.32 D1|D2|D7

	MOVE.16	D7,D1			; D1 <-- erreur

	MOVE.32	#2**BDBSAV,D2
	CALL	_DBOX_MERROR		; affiche en sauvant dessous
	JUMP,EQ	R8^EXIT$
	COMP.16	#ERNEMEM,D7
	JUMP,NE	R8^EXIT$

	MOVE.16	D1,D7
	CLR.16	D2
	CALL	_DBOX_MERROR		; affiche sans sauver dessous
EXIT$:
	POPM.32	D1|D2|D7
	RET



;-------------\\
; _DBOX_MERROR >
;=============/

; Affiche une erreur.
; Il faudra redessiner les soft-keys (LIB ?AFMENU).

; in	D7.16	code de l'erreur
;	A3.32	^nom du fichier
;	D2.16	mode d'ouverture
;	D3.32	position centre (si BDBPOS)
; out	D7.16	erreur
; mod	D7.16

_DBOX_MERROR:
	PUSHM.32 D1..D4|A3|A4

	MOVE.16	D7,D1			; D1 <-- erreur
	CLR.16	D7			; D7 <-- ok

	TEST.16	D1
	JUMP,EQ	EXIT$
	COMP.16	#ERKYES,D1
	JUMP,EQ	EXIT$
	COMP.16	#ERKNO,D1
	JUMP,EQ	EXIT$
	COMP.16	#ERKSTO,D1
	JUMP,EQ	EXIT$
	COMP.16	#ERKWHA,D1
	JUMP,EQ	EXIT$
	COMP.16	#ERKOTH,D1
	JUMP,EQ	EXIT$

	SUB.A16	#50,SP			; rserve 50 bytes sur le stack (PUSH)
	MOVE.32	SP,A4			; A4 <-- ^buffer sur le stack

	PUSHM.32 D2|D3|A2|A3|A4
	MOVE.32	#2**BERUNAM+2**BERNOTXT,D2
	MOVE.32	#50-2,D3
	MOVE.32	#1,D4
	MOVE.16	D1,D7
	FOS	?XERROR			; buffer <-- nom de l'unit fautive
	MOVE.32	#R16^TERM$,A2
	MOVE.32	#R16^NPWD$,A3
	LIB	?CPSTRING		; est-ce @_PWD_ ?
	POPM.32	D2|D3|A2|A3|A4
	JUMP,NS	R8^NORMAL$

	MOVE.32	#R16^MSG$,A3
	JUMP	R8^TERR$

NORMAL$:
	PUSHM.32 D2|D3
	MOVE.16	#2**BERSNAM,D2		; D2 <-- mode "nom court"
	MOVE.32	#50-2,D3		; D3 <-- nb cars/ligne
	MOVE.32	#1,D4			; D4 <-- nb lignes
	MOVE.16	D1,D7			; D7 <-- numro de l'erreur
	FOS	?XERROR			; buffer <-- message d'erreur
	POPM.32	D2|D3

	MOVE.32	A4,A3			; A3 <-- ^texte de l'erreur
	TSET.32	D2:#BDBDET		; D2 <-- affiche la case (DETAILS)

TERR$:	CALL	_DBOX_TERROR		; affiche la dbox ...
	ADD.A16	#50,SP			; reprend le buffer sur le stack (POP)
	TEST.16	D7
	JUMP,NE	R8^EXIT$

	COMP.16	#DEFINE,D3		; choix de (DETAILS) ?
	JUMP,NE	R8^EXIT$		; non => EXIT$
					; oui =>
	MOVE.16	D1,D7			; D7 <-- numro de l'erreur
	CALL	DBOXDETAILS		; affiche les dtails ...
	CLR.16	D7			; D7 <-- ok
EXIT$:
	POPM.32	D1..D4|A3|A4
	TEST.16	D7			; retour EQ/NE
	RET


TERM$:	.8	" ","/",":",CR,TAB,0,-1,2**7
NPWD$:	.ASCIZ	"@_PWD_*"
MSG$:	.ASCII	"Il est impossible d'ouvrir cette unit,<CR>"
	.ASCIZ	"car elle est verrouille !"
	.EVEN


;------------\\
; DBOXDETAILS >
;============/

; Affiche une erreur de faon dtaille.

; in	D7.W	code de l'erreur
;	D2.16	mode d'ouverture
;	D3.32	position centre (si BDBPOS)
; out	D7.W	erreur
; mod	D7.W

DBOXDETAILS:
	PUSHM.32 D1..D5|A1..A4

	MOVE.16	D7,D1			; D1 <-- code de l'erreur

	MOVE.32	#R16^TDBOX_DETAILS,A2
	DBOX_	OPEN			; ouvre la swdo
	JUMP,NE	EXIT$

	SUB.A16	#50,SP			; rserve 50 bytes sur le stack (PUSH)
	MOVE.32	SP,A4			; A4 <-- ^buffer sur le stack

	MOVE.16	#1.OR.2**15,D2
	DBOX_	GETCO
	LIB	?SETCURS
	MOVE.8	#AFINV,D3
	LIB	?AFCAR
	MOVE.16	#2**BERSNAM,D2
	MOVE.32	#50-2,D3		; D3 <-- nb cars/ligne
	MOVE.32	#1,D4			; D4 <-- nb lignes
	MOVE.16	D1,D7			; D7 <-- numro de l'erreur
	FOS	?XERROR			; buffer <-- message d'erreur
	MOVE.32	A4,A3
	LIB	?AFTEXT			; affiche le message
	MOVE.8	#AFDIR,D3
	LIB	?AFCAR

	MOVE.16	#2.OR.2**15,D2
	DBOX_	GETCO
	LIB	?SETCURS
	MOVE.16	D1,D3
	SR.16	#8,D3
	MOVE.32	#R16^TABLE$,A3
TLOOP$:
	TEST.8	{A3}
	JUMP,EQ	R8^TERR$
	COMP.8	{A3+},D3
	JUMP,EQ	R8^TAFF$
TNEXT$:
	TEST.8	{A3+}
	JUMP,NE	TNEXT$
	JUMP	TLOOP$
TAFF$:
	LIB	?AFTEXT			; affiche la provenance
	JUMP	R8^NUM$
TERR$:
	LIB	?AFTIM
	.ASCIZ	"?"
	.EVEN
NUM$:
	MOVE.16	#3.OR.2**15,D2
	DBOX_	GETCO
	LIB	?SETCURS
	MOVE.16	D1,D4
	LIB	?AFX4			; affiche le numro

	MOVE.16	#4.OR.2**15,D2
	DBOX_	GETCO
	LIB	?SETCURS
	MOVE.16	D1,D3
	AND.16	#16'FF00,D3
	COMP.16	#ERFOS,D3
	JUMP,NE	R8^NERR$
	MOVE.16	#2**BERLNAM.OR.2**BERLOGIQ.OR.2**BERNOTXT,D2
	MOVE.16	#50-2,D3		; D3 <-- nb cars/ligne
	MOVE.16	#1,D4			; D4 <-- nb lignes
	MOVE.16	D1,D7			; D7 <-- numro de l'erreur
	FOS	?XERROR			; buffer <-- nom du fichier
	MOVE.32	A4,A3
	LIB	?AFTEXT			; affiche le nom du fichier
	JUMP	R8^POP$
NERR$:
	LIB	?AFTIM
	.ASCIZ	"---"
	.EVEN
POP$:
	ADD.A16	#50,SP			; reprend le buffer sur le stack (POP)
LOOP$:
	DBOX_	EDIT			; attend touche/souris ...
	MOVE.32	#R16^TKEY_DETAILS,A1
	MOVE.16	#2**BDBCCMM.OR.2**BDBCCFF,D1
	DBOX_	CALLC			; touche admise ?
	COMP.16	#KEYMGR,D3
	JUMP,EQ	LOOP$
	COMP.16	#F1,D3
	JUMP,EQ	R8^CLOSE$
BIP$:
	MOVE.8	#BIPLIT,D3
	LIB	?BEEP			; p'tit bruit
	JUMP	LOOP$

CLOSE$:
	DBOX_	CLOSE			; ferme la swdo
EXIT$:
	POPM.32	D1..D5|A1..A4
	TEST.16	D7			; retour EQ/NE
	RET

TABLE$:
	.ASCIZ	"<H'04>$DIS (cran)"	; $DIS
	.ASCIZ	"<H'05>#PRINTER (imprimante)"; $OKI ...
	.ASCIZ	"<H'81>NTREL (noyau temps rel)"; NTREL
	.ASCIZ	"<H'82>BIOS (priphrique)"; BIOS
	.ASCIZ	"<H'83>GESMEM (mmoire)"; GESMEM
	.ASCIZ	"<H'85>FOS (gestionnaire de fichiers)"; FOS
	.ASCIZ	"<H'86>LIB (librairie)"	; LIB
	.ASCIZ	"<H'88>MM (disque)"	; MM
	.ASCIZ	"<H'89>@NETWORK (rseau)"; $NANET ...
	.8	0
	.EVEN


TDBOX_DETAILS:
	.16	L10$-TDBOX_DETAILS
	.16	L20$-TDBOX_DETAILS
	.16	0,0

L10$:
	.8	ODBTEXT
	.ASCIZ	"Message :    "
	.8	ODBLABEL,1
	.8	ODBTEXT
	.ASCIZ	"                                        "
	.8	ODBCR,ODBCR
	.8	ODBTEXT
	.ASCIZ	"Provenance : "
	.8	ODBLABEL,2
	.8	ODBTEXT
	.ASCIZ	""
	.8	ODBCR
	.8	ODBTEXT
	.ASCIZ	"Numro :     "
	.8	ODBLABEL,3
	.8	ODBTEXT
	.ASCIZ	""
	.8	ODBCR,ODBCR
	.8	ODBTEXT
	.ASCIZ	"Fichier :    "
	.8	ODBLABEL,4
	.8	ODBTEXT
	.ASCIZ	""
	.8	ODBCR,ODBCR,ODBCR
	.8	ODBBOX,0,F1,TDBMEV
	.ASCIZ	"   VU   "
	.8	0

L20$:
	.ASCIZ	""
	.ASCIZ	""
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	"Vu"
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	""
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	""
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	""
		;     ;     ;     ;
	.ASCIZ	""
	.ASCIZ	""
	.EVEN

TKEY_DETAILS:
	.16	F0,F1,F2,F3,CR,END,SPACE,0,DOKF1-TKEY_DETAILS
	.16	KEYMGR,KEYMMR,KEYMDR,0,DOKMGR-TKEY_DETAILS
	.16	0




;-------------\\
; _DBOX_AFFILE >
;=============/

; Affiche un nom de fichier, quel que soit son terminateur,
; en minuscules et entre guillemets.

; in	A3.32	^nom du fichier
; out	-
; mod	D7.16

_DBOX_AFFILE:
	PUSHM.32 D2|D3

	MOVE.32	#"""",D3
	LIB	?AFCAR

	MOVE.32	#2**BAFXMI,D2		; D2 <-- affiche en minuscule
	MOVE.32	#-1,D3			; D3 <-- pas de lg max
	LIB	?AFXFILE		; affiche le nom du fichier

	MOVE.32	#"""",D3
	LIB	?AFCAR

	POPM.32	D2|D3
	RET



;-----------\\
; _DBOX_OPEN >
;===========/

; Affiche une bote de dialogue.

; in	A2.32	^table de description
;	D2.16	mode d'ouverture
;	D2.32	[23..16] => onglet actif (si BDBTAB)
;	D3.32	position centre (si BDBPOS)
;	D4.32	tats des fanions
;	A3.32	^textes des onglets (si BDBTAB)
; out	D5.32	canal
;	D7.16	erreur
; mod	D5.32, D7.16

_DBOX_OPEN:
	TEST.32	D2:#BDBEXTEND
	JUMP,BS	_DBOX_EXTEND
	COMP.A16 #0,A2
	JUMP,EQ	_DBOX_EXTEND

	PUSHM.32 D0..D4|A0..A6

	CALL	OPEVAR			; A6 <-- ^variables
	JUMP,NE	R8^QUIT$

	MOVE.32	A2,{A6}+OPTABLE		; mm ^table
	MOVE.16	D2,{A6}+OMODE		; mm. mode
	SWAP.32	D2
	MOVE.8	D2,{A6}+OACTTAB
	SWAP.32	D2
	MOVE.32	A3,{A6}+OPTABS

	LIB	?CLREDIT		; clear pour LIB,?EDIT

	CALL	RSTWDO			; lit le ^description de la fentre
	JUMP,NE	R8^EXIT$

	MOVE.32	{A6}+OPDDIS,A0		; A0 <-- ^description de la fentre

	MOVE.A16 {A2}+0,A4		; A4 <-- ^relatif table
	ADD.32	A2,A4			; A4 <-- ^table

	MOVE.32	D4,{A6}+OFANION		; mm. les fanions
	NOT.32	D4
	MOVE.32	D4,{A6}+OFADESS		; redessine tous les boutons !

OLD$:	CALL	DIMALL			; D4 <-- dimensions maximales
	CALL	CREWDO			; cre la swdo
	JUMP,NE	R8^EXIT$

	TCLR.8	{A6}+OFLAGS:#BNODES
	CALL	DESALL			; dessine selon la table

	TEST.16	{A2}+2			; table menu existe ?
	JUMP,EQ	R8^ICO$			; non => ICO$

	MOVE.A16 {A2}+2,A3		; A3 <-- ^relatif table menu
	ADD.32	A2,A3			; A3 <-- ^table menu
	LIB	?AFMENU			; affiche les soft-keys

ICO$:	TEST.16	{A2}+4			; table icnes existe ?
	JUMP,EQ	R8^EXIT$		; non => EXIT$
	MOVE.A16 {A2}+4,A3		; A3 <-- ^relatif table icnes
	ADD.32	A2,A3			; A3 <-- ^table icnes horizontaux
	SUB.32	A4,A4			; A4 <-- ^nil (icnes verticaux)
	CALL	__DBOX_ICOAFF		; affiche les icnes

EXIT$:	TEST.16	D7			; ok ?
	JUMP,EQ	R8^QUIT$		; oui => QUIT$
	CALL	CLOVAR			; non => rend les variables

QUIT$:	MOVE.32	A6,D5			; D5 <-- "canal"

	POPM.32	D0..D4|A0..A6
	TEST.16	D7			; retour EQ/NE
	RET


;------------\\
; _DBOX_MEDIT >
;============/

; Modifie le fichier/ligne ditable dans une bote de dialogue.

; in	D3.16	rang fichier/ligne ditable (0..n)
;		-1 => rien d'ditable
;	D5.32	canal
; out	-
; mod	D7.16

_DBOX_MEDIT:
	PUSHM.32 D3|A6

	MOVE.32	D5,A6			; A6 <-- ^variables

	COMP.16	#-1,D3
	JUMP,EQ	R8^MAJ$

	COMP.16	{A6}+ONBFILE,D3
	JUMP,LO	R8^MAJ$

	MOVE.16	{A6}+ONBFILE,D3
	JUMP,EQ	R8^MAJ$
	DEC.16	D3

MAJ$:	MOVE.16	D3,{A6}+OUSFILE

	POPM.32	D3|A6
	CLR.16	D7			; retour EQ
	RET


;-----------\\
; _DBOX_EDIT >
;===========/

; Edite une bote de dialogue.

; in	A3.32	^dbut ligne  diter
;	A4.32	^dans la ligne
;	D4.32	tat des fanions
;	D5.32	canal
; out	D3.16	dernire touche frappe
;	D4.32	tat des fanions
;	A4.32	^dans la ligne
; mod	D3.32, D4.32, D7.16, A4.32

_DBOX_EDIT:
	PUSHM.32 D0..D2|D5|A0..A3|A5|A6

	MOVE.32	D5,A6			; A6 <-- ^variables
	MOVE.32	{A6}+OPTABLE,A2		; A2 <-- ^table
	MOVE.32	{A6}+OPDDIS,A0		; A0 <-- ^description de la fentre
	MOVE.32	{A6}+OlCFOND,{A0}+ODFCCF

	MOVE.16	{A6}+ONOWDO,D5
	LIB	?USEWDO			; utilise la bonne swdo

	COMP.32	{A6}+OFANION,D4		; fanions changs ?
	JUMP,EQ	R8^FAN$			; non => FAN$
					; oui =>
	MOVE.32	D4,{A6}+OFANION		; mm. les nouveaux fanions
	PUSH.32	A4
	MOVE.A16 {A2}+0,A4		; A4 <-- ^relatif table
	ADD.32	A2,A4			; A4 <-- ^table
	TSET.8	{A6}+OFLAGS:#BNODES
	CALL	DESALL			; redessine tous les fanions
	POP.32	A4

FAN$:	MOVE.32	A4,A1			; A1 <-- ^dans la ligne  diter

LOOP$:	TEST.16	{A6}+ONBFILE		; un/qq fichiers/lignes ditables ?
	JUMP,EQ	NOEDIT$			; non => NOEDIT$
					; oui =>
	MOVE.32	#{A6}+OTAFILE,A5
	MOVE.16	{A6}+OUSFILE,D3
	COMP.16	#-1,D3			; rien d'ditable ?
	JUMP,EQ	NOEDIT$			; oui => NOEDIT$
	MUL.16	#LGFI,D3
	ADD.32	D3,A5			; A5 <-- ^dans OTAFILE
	MOVE.32	{A5}+OFIPOS,D3		; D3 <-- position
	LIB	?SETCURS		; positionne au dbut

	MOVE.32	{A5}+OFILG,D3		; D3 <-- lg buffer
	TEST.8	{A5}+OFITYP
	JUMP,NE	R8^EDIT$

	TEST.8	{A6}+OnoPAST		; accepte CURSOR-SPACE ?
	JUMP,F	R8^OKPAST$		; oui => tout bon

	PUSH.32	D4
	MOVE.16	#16'AAAA,D4
	LIB	?GETREVL		; D4 <-- rvision de LIB
	COMP.16	#16'0909,D4		; LIB suffisamment rcent ?
	POPM.32	D4
	JUMP,LT	R8^OKPAST$		; non => tant pis

	TSET.32	D3:#12			; signale  LIB ?GETFILE

OKPAST$:
	MOVE.32	A1,A4			; A4 <-- ^dans buffer
	SUB.32	A5,A5			; A5 <-- pas de table pour soft-keys
	LIB	?GETFILE		; attend fichier/souris ...
	MOVE.32	A4,A1			; A1 <-- ^dans buffer
	JUMP	R8^NOCURS$

EDIT$:	MOVE.32	A1,A4			; A4 <-- ^dans buffer
	MOVE.32	A2,A5
	MOVE.32	#R16^TABLE$,A2		; A2 <-- table des touches de sortie
	LIB	?EDIT			; attend fichier/souris ...
	MOVE.32	A5,A2
	MOVE.32	A4,A1			; A1 <-- ^dans buffer
	JUMP	R8^NOCURS$

NOEDIT$:
	LIB	?GETCAR			; attend touche/souris ...

NOCURS$:
	LIB	?AFTIM
	.8	NOCURS,0		; plus de curseur
	.EVEN

	PUSH.32	A3
	MOVE.32	{A6}+OPTABLE,A4
	TEST.16	{A4}+4			; table icnes existe ?
	JUMP,EQ	R8^TEND$		; non => TEND$
	MOVE.A16 {A4}+4,A3		; A3 <-- ^relatif table icnes
	ADD.32	A4,A3			; A3 <-- ^table icnes horizontaux
	SUB.32	A4,A4			; A4 <-- ^nil (icnes verticaux)
	CALL	R32^_DBOX_ICODET	; dtecte si on est dans une icne ?
	JUMP,NE	R8^TEND$		; non => TEND$
	COMP.16	#-1,D2
	JUMP,EQ	R8^TEND$
	ADD.16	#F0,D2
	MOVE.16	D2,D3			; D3 <-- nouvelle touche (F0)..(F15)

TEND$:	POP.32	A3

	COMP.16	#KEYMGP,D3
	JUMP,EQ	R8^PRESS$
	COMP.16	#KEYMMP,D3		; bouton press ?
	JUMP,EQ	R8^PRESS$		; oui => PRESS$
	COMP.16	#KEYMDP,D3
	JUMP,NE	EXIT$

PRESS$:	PUSH.16	D3
	LIB	?IFMOUSE		; D4 <-- position de la souris
	POP.16	D3
	TEST.16	D7
	JUMP,NE	BIP$

	CALL	DETCADRE		; souris dans le cadre de la dbox ?
	JUMP,EQ	CMOVE$			; oui => CMOVE$

	CALL	DETECTTAB		; souris dans un onglet ?
	JUMP,EQ	EXIT$			; oui => retourne code correspondant

	MOVE.A16 {A2}+0,A4		; A4 <-- ^relatif table
	ADD.32	A2,A4			; A4 <-- ^table
	CALL	DETALL			; dtecte o est la souris
	JUMP,NE	EXIT$
	MOVE.32	#SETDOT,D2
	CALL	PRESOBJET		; presse l'objet slectionn
	MOVE.32	A4,A5			; A5 <-- ^objet slectionn
	MOVE.32	D4,D5			; D5 <-- position

MLOOP$:	LIB	?GETKEY			; attend touche/souris ...

	COMP.16	#KEYMPO,D3		; souris dplace ?
	JUMP,EQ	R8^MMOVE$		; oui => MMOVE$

	COMP.16	#KEYMGR,D3
	JUMP,EQ	R8^REL$
	COMP.16	#KEYMMR,D3		; bouton relach ?
	JUMP,EQ	R8^REL$			; oui => REL$
	COMP.16	#KEYMDR,D3
	JUMP,EQ	R8^REL$
	JUMP	MLOOP$

MMOVE$:					; souris dplace =>
	PUSH.16	D3
	LIB	?IFMOUSE		; D4 <-- position de la souris
	POP.16	D3
	TEST.16	D7
	JUMP,NE	MLOOP$

	MOVE.A16 {A2}+0,A4		; A4 <-- ^relatif table
	ADD.32	A2,A4			; A4 <-- ^table
	CALL	DETALL			; dtecte o est la souris
	COMP.32	A5,A4			; mme objet slectionn ?
	JUMP,EQ	MLOOP$			; oui => MLOOP$
					; non =>
	EX.32	A5,A4
	EX.32	D5,D4
	MOVE.32	#CLRDOT,D2
	CALL	PRESOBJET		; relache l'ancien objet
	MOVE.32	A5,A4
	MOVE.32	D5,D4
	MOVE.32	#SETDOT,D2
	CALL	PRESOBJET		; presse le nouvel objet
	JUMP	MLOOP$

REL$:	TEST.32	D4			; un objet slectionn ?
	JUMP,EQ	LOOP$			; non => LOOP$
					; oui =>
	CALL	INVOBJET		; inverse l'objet slectionn
	MOVE.32	#CLRDOT,D2
	CALL	PRESOBJET		; relache l'objet slectionn

	PUSH.32	A4
	MOVE.A16 {A2}+0,A4		; A4 <-- ^relatif table
	ADD.32	A2,A4			; A4 <-- ^table
	TSET.8	{A6}+OFLAGS:#BNODES
	CALL	DESALL			; redessine tous les fanions
	POP.32	A4

	COMP.8	#ODBXFILE,{A4}		; "clic" dans un fichier ditable ?
	JUMP,EQ	R8^M3$			; oui => M3$
	COMP.8	#ODBXLINE,{A4}		; "clic" dans une ligne ditable ?
	JUMP,EQ	R8^M3$			; oui => M3$
	COMP.8	#ODBFILE,{A4}		; "clic" dans un fichier ditable ?
	JUMP,EQ	R8^M1$			; oui => M1$
	COMP.8	#ODBLINE,{A4}		; "clic" dans une ligne ditable ?
	JUMP,EQ	R8^M1$			; oui => M1$
	COMP.8	#ODBCLINE,{A4}		; "clic" dans une ligne ditable ?
	JUMP,EQ	R8^M1$			; oui => M1$
	COMP.8	#ODBBOX,{A4}		; "clic" dans une bote ?
	JUMP,EQ	R8^MGO$			; oui => MGO$
	COMP.8	#ODBCIRCLE,{A4}		; "clic" dans un cercle ?
	JUMP,EQ	R8^M1$			; oui => M1$
	COMP.8	#ODBLCIRCLE,{A4}	; "clic" dans un petit cercle ?
	JUMP,EQ	R8^M1$			; oui => M1$
	COMP.8	#ODBSQUARE,{A4}		; "clic" dans un carr ?
	JUMP,NE	LOOP$			; non => LOOP$

M1$:	TEST.8	{A4}+1:#7		; <bit> spcial ?
	JUMP,BC	LOOP$			; non => LOOP$
	INC.32	A4
	JUMP	R8^MGO$

M3$:	ADD.A16	#3,A4

MGO$:	CLR.32	D3
	MOVE.8	{A4}+1,D3		; D3 <-- <fonc>
	SL.16	#8,D3
	MOVE.8	{A4}+2,D3		; D3 <-- <touche>
	JUMP	EXIT$

; Dplace toute la dbox, tant que la souris est dplace.

CMOVE$:	LIB	?COLORPUSH
	MOVE.32	#COLOR_DBCLEAR,D3
	LIB	?COLORCR		; met la couleur du fond
	MOVE.32	#COLOR_DBCADRE,D3
	LIB	?COLORSR		; met la couleur du cadre

	CALL	CADINIT

	MOVE.32	D4,D2
	SUB.16	{A0}+ODFFX,D2
	SWAP.32	D2
	SUB.16	{A0}+ODFFY,D2		; D2 <-- offset pour coin sup/gauche
	SWAP.32	D2

	SUB.16	{A6}+OWDPOS+2,D4
	SWAP.32	D4
	SUB.16	{A6}+OWDPOS+0,D4
	SWAP.32	D4

	CALL	CADINV			; allume le premier cadre
	MOVE.32	D4,D5

CLOOP$:	LIB	?GETKEY			; attend touche/souris ...
	COMP.16	#KEYMPO,D3		; souris dplace ?
	JUMP,NE	R8^CEND$		; non => CEND$

	LIB	?IFMOUSE		; D4 <-- position de la souris
	JUMP,EQ	R8^CPOS$

	MOVE.32	D5,D4

CPOS$:	CALL	CADPOS			; D4 <-- position correcte
	COMP.32	D5,D4			; position change ?
	JUMP,EQ	CLOOP$			; non => CLOOP$
	CALL	CADINV			; allume le nouveau cadre
	EX.32	D5,D4
	CALL	CADINV			; teint l'ancien cadre
	MOVE.32	D5,D4
	JUMP	CLOOP$

CEND$:	CALL	CADINV			; teint le dernier cadre
	LIB	?COLORPOP

	CALL	CADMOVE			; dplace la dbox
	JUMP	LOOP$

BIP$:	MOVE.32	#BIPLIT,D3
	LIB	?BEEP			; p'tit bruit
	JUMP	LOOP$

EXIT$:	MOVE.32	{A6}+OFANION,D4		; D4 <-- tats des fanions
	MOVE.32	A1,A4			; A4 <-- ^dans la ligne
	CLR.16	D7			; D7 <-- ok

	POPM.32	D0..D2|D5|A0..A3|A5|A6
	TEST.16	D7			; retour EQ/NE
	RET

TABLE$:					; table pour LIB ?EDIT
	.8	0,UNDO
	.8	0,TAB
	.8	2**7
	.EVEN


;------------\\
; _DBOX_CLOSE >
;============/

; Ferme une bote de dialogue.

; in	D5.32	canal
; out	-
; mod	D7.16

_DBOX_CLOSE:
	PUSHM.32 D5|A0|A6

	MOVE.32	D5,A6			; A6 <-- ^variables
	MOVE.32	{A6}+OPDDIS,A0		; A0 <-- ^description de la fentre

	MOVE.16	{A6}+ONOWDO,D5
	LIB	?USEWDO			; utilise la bonne swdo

	CALL	CLOWDO			; ferme la swdo
	CALL	CLOVAR			; rend les variables

	POPM.32	D5|A0|A6
	TEST.16	D7
	RET


;------------\\
; _DBOX_CADRE >
;============/

; Ouvre une sous-fentre et dessine juste son cadre.

; in	D2.16	mode d'ouverture
;	D3.32	centre (Y;X) si BDBPOS
;	D4.32	dimensions (dY,dX)
; out	D5.32	canal
;	D7.16	erreur
; mod	D5.32, D7.16

_DBOX_CADRE:
	PUSHM.32 A0|A6

	CALL	OPEVAR			; A6 <-- ^variables
	JUMP,NE	R8^EXIT$

	CALL	RSTWDO			; lit le ^description de la fentre
	JUMP,NE	R8^EXIT$
	MOVE.32	{A6}+OPDDIS,A0		; A0 <-- ^description de la fentre

	CALL	CREWDO			; cre la swdo
	JUMP,EQ	R8^EXIT$
	CALL	CLOVAR			; rend les variables

EXIT$:	MOVE.32	A6,D5			; D5 <-- "canal"

	POPM.32	A0|A6
	TEST.16	D7			; retour EQ/NE
	RET



;------------\\
; _DBOX_GETCO >
;============/

; Donne les coordonnes d'un objet quelconque.
; Lorsque D2:#BDBGCLABEL = 0, compte les objets depuis le premier
; (les objets ODBCR*, ODBTAB*, ODBTRAME et ODBLABEL ne sont pas compts).
; Lorsque D2:#BDBGCLABEL = 1, cherche l'objet plac juste aprs le ODBLABEL.

; in	D2.16	si BDBGCLABEL=0  -->  rang de l'objet (0..n)
;		si BDBGCLABEL=1  -->  label recherch
;		si BDBGCGREY=1   -->  "grise" l'objet
;		si BDBGCFULL=1   -->  "dgrise" l'objet
;		si BDBGCGREY=1 et BDBGCFULL=1, dsactive sans griser
;	D5.16	canal
; out	D3.32	coordonne dbut
;	D4.32	coordonne fin
;	D7.16	erreur
; mod	D3.32, D4.32, D7.16

_DBOX_GETCO:
	PUSHM.32 D0..D2|A0..A6

	MOVE.32	D5,A6			; A6 <-- ^variables
	MOVE.32	{A6}+OPTABLE,A2		; A2 <-- ^table
	MOVE.32	{A6}+OPDDIS,A0		; A0 <-- ^description de la fentre
	MOVE.32	{A6}+OlCFOND,{A0}+ODFCCF

	MOVE.A16 {A2}+0,A4		; A4 <-- ^relative table
	ADD.32	A2,A4			; A4 <-- ^table

	MOVE.32	{A6}+OMARGY,D4

	CLR.16	{A6}+ONOFILE
	TSET.8	{A6}+OFLAGS:#BNODES
	TCLR.8	{A6}+OFLAGS:#BFADES
	CLR.16	D1			; D1 <-- rang

	TEST.32	D2:#BDBGCLABEL		; recherche d'un label ?
	JUMP,BC	R8^RANG$		; non => RANG$

; Cherche un objet d'aprs son label.

LLOOP$:
	MOVE.16	#ERDIOUT,D7
	TEST.8	{A4}			; encore un objet ?
	JUMP,EQ	EXIT$			; non => EXIT$

	MOVE.32	A4,A3			; A3 <-- ^l'objet
	PUSH.32	D4
	CALL	DESOBJET		; D4 <-- position fin
	POP.32	D3			; D3 <-- position dbut
	INC.16	D1			; D1 <-- rang suivant

	COMP.8	#ODBLABEL,{A3}		; objet LABEL trouv ?
	JUMP,NE	LLOOP$			; non => LLOOP$
	COMP.8	{A3}+1,D2		; est-ce le bon label ?
	JUMP,NE	LLOOP$			; non => LLOOP$
				; oui =>
	CLR.8	D2			; D2 <-- cherche le prochain objet

; Cherche un objet d'aprs son rang.

RANG$:
	INC.8	D2			; D2 <-- rang 1..n
RLOOP$:
	MOVE.16	#ERDIOUT,D7
	TEST.8	{A4}			; encore un objet ?
	JUMP,EQ	EXIT$			; non => EXIT$

	MOVE.32	A4,A3			; A3 <-- ^l'objet
	PUSH.32	D4
	CALL	DESOBJET		; D4 <-- position fin
	POP.32	D3			; D3 <-- position dbut
	INC.16	D1			; D1 <-- rang suivant

	COMP.8	#ODBCR,{A3}		; ignore les CR
	JUMP,EQ	RLOOP$
	COMP.8	#ODBCR2,{A3}		; ignore les CR
	JUMP,EQ	RLOOP$
	COMP.8	#ODBTABX,{A3}		; ignore les TABX
	JUMP,EQ	RLOOP$
	COMP.8	#ODBTABXN,{A3}		; ignore les TABXN
	JUMP,EQ	RLOOP$
	COMP.8	#ODBTABYN,{A3}		; ignore les TABYN
	JUMP,EQ	RLOOP$
	COMP.8	#ODBTRAME,{A3}		; ignore les TRAMEs
	JUMP,EQ	RLOOP$
	COMP.8	#ODBLABEL,{A3}		; ignore les LABELs
	JUMP,EQ	RLOOP$

	DEC.8	D2			; objet trouv ?
	JUMP,NE	RLOOP$			; non => RLOOP$

	TEST.32	D2:#BDBGCGREY
	JUMP,BS	GREY$
	TEST.32	D2:#BDBGCFULL
	JUMP,BS	FULL$
	TEST.32	D2:#BDBGCDRAW
	JUMP,BS	REDRAW$

; Prend les coordonnes de l'objet trouv.

	COMP.8	#ODBBOX,{A3}		; bote rectangulaire ?
	JUMP,EQ	R8^COOR$		; oui => COOR$
	COMP.8	#ODBFILE,{A3}
	JUMP,EQ	R8^COOR$
	COMP.8	#ODBLINE,{A3}
	JUMP,EQ	R8^COOR$
	COMP.8	#ODBCLINE,{A3}
	JUMP,EQ	R8^COOR$
	COMP.8	#ODBXLINE,{A3}
	JUMP,EQ	R8^COOR$
	COMP.8	#ODBXFILE,{A3}
	JUMP,NE	OK$
COOR$:
	MOVE.16	{A6}+OCX,D2
	ADD.16	D2,D3
	SUB.16	D2,D4
	SUB.16	D2,D4
	JUMP	OK$

; Redessine l'objet

REDRAW$:
	PUSHM.32 D0|A0
	CALL	GETMAP			; A0/D0 <-- ^map/bit
	TEST.8	{A0}:D0
	POPM.32	D0|A0
	JUMP,T	REDRAWgrey$
	JUMP	REDRAWfull$

OKmore$:
	TEST.32	D2:#BDBGCDRAW		; faut-il quand-mme redessiner ?
	JUMP,T	REDRAW$			; oui => ok... dessine
	JUMP	OK$

; Grise un objet quelconque.

GREY$:
	PUSHM.32 D0|A0
	CALL	GETMAP			; A0/D0 <-- ^map/bit
	TSET.8	{A0}:D0
	POPM.32	D0|A0
	JUMP,BS	OKmore$

	TEST.32	D2:#BDBGCFULL		; grise sans griser ?
	JUMP,BS	R8^OK$			; oui => c'est ok

REDRAWgrey$:
	MOVE.32	A3,A4
	CALL	GREYOBJET		; grise l'objet
	JUMP	R8^OK$

; Dgrise un objet quelconque.

FULL$:	PUSHM.32 D0|A0
	CALL	GETMAP			; A0/D0 <-- ^map/bit
	TCLR.8	{A0}:D0
	POPM.32	D0|A0
	JUMP,BC	OKmore$

REDRAWfull$:
	MOVE.32	A3,A4
	MOVE.32	D3,D4

	COMP.8	#ODBCIRCLE,{A4}
	JUMP,EQ	R8^FBUTT$
	COMP.8	#ODBLCIRCLE,{A4}
	JUMP,EQ	R8^FBUTT$
	COMP.8	#ODBSQUARE,{A4}
	JUMP,NE	R8^FDRAW$

FBUTT$:	MOVE.32	{A6}+OFADESS,D3
	MOVE.8	{A4}+1,D2
	TCLR.32	D3:D2			; il faudra redessiner l'intrieur !
	MOVE.32	D3,{A6}+OFADESS

	MOVE.32	{A6}+OFANION,D3
	TEST.32	D3:D2
	JUMP,BS	R8^FDRAW$
	MOVE.32	{A6}+OFADESS,D3
	TSET.32	D3:D2			; il faudra redessiner l'intrieur teint !
	MOVE.32	D3,{A6}+OFADESS

FDRAW$:	TCLR.8	{A6}+OFLAGS:#BNODES
	TSET.8	{A6}+OFLAGS:#BFADES
	CALL	DESOBJET		; redessine l'objet normalement

OK$:	CLR.16	D7			; D7 <-- ok

EXIT$:	POPM.32	D0..D2|A0..A6
	TEST.16	D7			; retour EQ/NE
	RET


;----------\\
; GREYOBJET >
;==========/

; Grise un objet quelconque (au niveau de son dessin).

; in	A4.32	^objet
;	D3.32	position dbut (y;x)
;	D4.32	position fin   (y;x)
;	D1.16	rang
; out	-
; mod	D7.16

GREYOBJET:
	PUSHM.32 D2..D4

	PUSHM.32 D3|D4
	MOVE.32	#16'55AA55AA,D3
	MOVE.32	D3,D4
	LIB	?DRMDEF			; dfini une trame grise
	POPM.32	D3|D4

	SWAP.32	D3
	SWAP.32	D4
	SUB.16	{A0}+ODFC1Y,D3
	ADD.16	{A0}+ODFC2Y,D4

	MOVE.16	{A0}+ODFC2Y,D2
	ADD.16	#5,D2
	COMP.8	#ODBBOX,{A3}		; bote rectangulaire ?
	JUMP,EQ	R8^GTOP$		; oui => GTOP$
	COMP.8	#ODBFILE,{A3}
	JUMP,EQ	R8^GTOP$
	COMP.8	#ODBLINE,{A3}
	JUMP,EQ	R8^GTOP$
	COMP.8	#ODBCLINE,{A3}
	JUMP,EQ	R8^GTOP$
	COMP.8	#ODBXLINE,{A3}
	JUMP,EQ	R8^GTOP$
	COMP.8	#ODBXFILE,{A3}
	JUMP,EQ	R8^GTOP$
	MOVE.16	#1,D2

GTOP$:	SUB.16	D2,D3
	DEC.16	D2
	ADD.16	D2,D4

	SUB.16	D3,D4

	MOVE.16	{A0}+ODFFDY,D2
	SUB.16	D3,D2
	COMP.16	D2,D4			; dpasse le bas de la swdo ?
	JUMP,LO	R8^GBOT$		; non => GBOT$
	MOVE.16	D2,D4

GBOT$:	SWAP.32	D4
	SWAP.32	D3
	SUB.16	D3,D4

	MOVE.32	#CLRDOT,D2
	LIB	?DRTRAME		; grise toute la surface (carrment)

	POPM.32	D2..D4
	RET



;------------\\
; _DBOX_CALLC >
;============/

; Appel une routine selon une touche presse.

; in	A1.32	^table .W t1,t2,t3,0,adr termine par .W 0
;	D1.16	mode de convertion
;	D3.16	touche presse
; out	NE	pas trouv
; mod	D7.16

_DBOX_CALLC:
	PUSHM.32 D0|A0

	MOVE.16	D3,D0
	CLR.8	D0
	COMP.16	#KEYMPO,D0		; bouton de la souris ?
	JUMP,NE	R8^KEY$			; non => KEY$
	MOVE.16	D3,D0			; oui =>
	JUMP	R8^GO$

KEY$:	MOVE.16	D3,D0			; D0 <-- touche presse

	TEST.32	D1:#BDBCCMM
	JUMP,BC	R8^NOMAJ$
	EX.32	D0,D3
	LIB	?MINMAJ			; (min) --> MAJ
	EX.32	D3,D0

NOMAJ$:	TEST.32	D1:#BDBCCFF
	JUMP,BC	R8^GO$
	COMP.8	#SHIFT+F0,D0
	JUMP,LO	R8^GO$
	COMP.8	#SHIFT+F15,D0
	JUMP,HI	R8^GO$
	SUB.8	#SHIFT,D0		; (SHIFT-Fn) --> (Fn)

GO$:	MOVE.16	#1,D7			; D7 <-- pas trouv
	MOVE.32	A1,A0			; A0 <-- ^table clavier

LOOP$:	TEST.16	{A0}			; fin table clavier ?
	JUMP,EQ	R8^EXIT$		; oui => EXIT$

NEXT$:	TEST.16	{A0}			; fin liste de touches ?
	JUMP,EQ	R8^SKIP$		; oui => SKIP$
	COMP.16	{A0+},D0		; touche trouve ?
	JUMP,NE	NEXT$			; non => NEXT$
	JUMP	R8^FOUND$		; oui => FOUND$

SKIP$:	ADD.A16	#4,A0			; A0 <-- saute <<0>> <<adresse>>
	JUMP	LOOP$

FOUND$:	TEST.16	{A0+}			; A0 <-- saute jusqu'au <<0>>
	JUMP,NE	FOUND$

	MOVE.A16 {A0},A0		; A0 <-- adresse relative
	ADD.32	A1,A0			; A0 <-- adresse absolue
	CALL	{A0}			; appel routine utilisateur

	CLR.16	D7			; D7 <-- routine appele

EXIT$:	POPM.32	D0|A0
	TEST.16	D7			; retour EQ/NE
	RET




;---------\\
; CHECKALL >
;=========/

; Calcule une valeur unique propre  la dbox.

; in	A4.32	^table
; out	D4.32	check de la dbox
; mod	D4.32, D7.16

CHECKALL:
	PUSHM.32 D2|D3|A3|A4

	MOVE.32	A4,A3			; A3 <-- ^dbut table
	CLR.16	{A6}+ONOFILE
	TSET.8	{A6}+OFLAGS:#BNODES
	TCLR.8	{A6}+OFLAGS:#BFADES
	TSET.8	{A6}+OFLAGS:#BCHECK

OLOOP$:	TEST.8	{A4}
	JUMP,EQ	R8^OEND$
	CALL	DESOBJET		; A4 <-- ^objet suivant
	JUMP	OLOOP$

OEND$:	CLR.32	D4			; D4 <-- check initial
	CLR.16	D3

CLOOP$:	COMP.32	A4,A3			; est-on  la fin ?
	JUMP,EQ	R8^EXIT$		; oui => EXIT$

	CLR.32	D2
	MOVE.8	{A3+},D2
	RL.32	D3,D2
	ADD.32	D2,D4

	INC.16	D3
	AND.16	#2'1111,D3		; D3 <-- 0..15
	JUMP	CLOOP$

EXIT$:	TCLR.8	{A6}+OFLAGS:#BCHECK

	POPM.32	D2|D3|A3|A4
	RET


;--------\\
; DIMALL  >
;========/

; Calcul les dimensions pour la fentre.

; in	A4.32	^table
;	D2.16	mode d'ouverture
; out	D4.32	dimensions
; mod	D4.32

DIMALL:
	PUSHM.32 D0|D1|D3|A4

	CLR.16	{A6}+OMARGTOP

	TEST.32	D2:#BDBTAB		; onglets ?
	JUMP,BC	R8^NOTAB$		; non => pas de marge en plus...

	MOVE.16	#24,{A6}+OMARGTOP	; prend note de la place prise par les onglets

NOTAB$:	CLR.16	{A6}+OMARGX
	MOVE.16	#10,{A6}+OMARGY
	TEST.32	D2:#BDBMAX		; pas de marges ?
	JUMP,BS	R8^MARG$		; oui => MARG$
	MOVE.16	{A6}+OCX,D4
	MUL.16	#MARGGD,D4
	MOVE.16	D4,{A6}+OMARGX

	MOVE.16	{A6}+OCY,D4
	MUL.16	#MARGSI,D4
	MOVE.16	D4,{A6}+OMARGY
MARG$:
	CLR.16	D0			; D0 <-- largeur
	CLR.16	D1			; D1 <-- hauteur
	MOVE.32	{A6}+OMARGY,D4

	CLR.16	{A6}+ONOFILE
	TSET.8	{A6}+OFLAGS:#BNODES
	TCLR.8	{A6}+OFLAGS:#BFADES
LOOP$:
	TEST.8	{A4}
	JUMP,EQ	R8^END$
	CALL	DESOBJET

	COMP.16	D0,D4			; plus large que prcdent ?
	JUMP,LS	R8^MAXX$		; non => MAXX$
	MOVE.16	D4,D0			; oui => mm. le maximum
MAXX$:
	SWAP.32	D4
	COMP.16	D1,D4			; plus haut que prcdent ?
	JUMP,LS	R8^MAXY$		; non => MAXY$
	MOVE.16	D4,D1			; oui => mm. le maximum
MAXY$:
	SWAP.32	D4
	JUMP	LOOP$

END$:
	MOVE.16	{A6}+ONOFILE,{A6}+ONBFILE

	MOVE.16	D1,D4			; D4 <-- hauteur maximale
	ADD.16	{A6}+OMARGY,D4
	INC.16	D4
	AND.16	#16'FFFE,D4		; D4 <-- modulo 2
	MOVE.16	D4,{A6}+ODIMWDO+0
	ADD.16	#16,D4			; D4 <-- ajoute marges swdo
	SWAP.32	D4

	MOVE.16	D0,D4			; D4 <-- largeur maximale
	ADD.16	{A6}+OMARGX,D4
	SUB.16	{A6}+OCX,D4
	ADD.16	#8-1,D4
	AND.16	#16'FFF8,D4		; D4 <-- modulo 8
	MOVE.16	D4,{A6}+ODIMWDO+2
	ADD.16	#16,D4			; D4 <-- ajoute marges swdo

	POPM.32	D0|D1|D3|A4
	RET


;--------\\
; DETALL  >
;========/

; Dtecte o est la souris.

; in	A4.32	^table
;	D4.32	position de la souris
; out	A4.32	^objet trouv
;	D4.32	coordonne dbut
;	D7.16	erreur
; mod	D4.32, D7.16, A4.32

DETALL:
	PUSHM.32 D0|D1|D2|D3|D5|D6|A3

	MOVE.16	D4,D0			; D0 <-- position X souris
	SUB.16	{A0}+ODFFX,D0
	JUMP,LO	EXIT$
	MOVE.32	D4,D6
	SWAP.32	D6			; D6 <-- position Y souris
	SUB.16	{A0}+ODFFY,D6
	JUMP,LO	EXIT$

	MOVE.32	{A6}+OMARGY,D4

	CLR.16	{A6}+ONOFILE
	TSET.8	{A6}+OFLAGS:#BNODES
	TCLR.8	{A6}+OFLAGS:#BFADES
	CLR.16	D1			; D1 <-- rang

LOOP$:	TEST.8	{A4}
	JUMP,EQ	EXIT$
	MOVE.32	A4,A3			; A3 <-- ^objet
	MOVE.32	D4,D2			; D2 <-- position dbut
	CALL	DESOBJET		; D4 <-- position fin
	MOVE.32	D4,D5			; D5 <-- position fin
	INC.16	D1			; D1 <-- rang suivant

	MOVE.16	D2,D3
	COMP.8	#ODBFILE,{A3}
	JUMP,EQ	R8^RECT$
	COMP.8	#ODBLINE,{A3}
	JUMP,EQ	R8^RECT$
	COMP.8	#ODBCLINE,{A3}
	JUMP,EQ	R8^RECT$
	COMP.8	#ODBXLINE,{A3}
	JUMP,EQ	R8^RECT$
	COMP.8	#ODBXFILE,{A3}
	JUMP,EQ	R8^RECT$
	COMP.8	#ODBCIRCLE,{A3}
	JUMP,EQ	R8^BUTT$
	COMP.8	#ODBLCIRCLE,{A3}
	JUMP,EQ	R8^BUTT$
	COMP.8	#ODBSQUARE,{A3}
	JUMP,EQ	R8^BUTT$
	COMP.8	#ODBBOX,{A3}
	JUMP,NE	LOOP$

	SUB.16	{A6}+OCX,D5

RECT$:	MOVE.16	{A6}+OCX,D3
	SR.16	#1,D3
	SUB.16	D3,D5
	ADD.16	D2,D3

BUTT$:	SWAP.32	D5
	SUB.16	{A6}+OC1Y,D5
	SUB.16	{A6}+OC2Y,D5
;;?	SUB.W	D5,#2
	COMP.16	D5,D6			; souris plus haute ?
	JUMP,LO	LOOP$
	ADD.16	{A6}+OC2Y,D5
	ADD.16	{A6}+OC1Y,D5
	ADD.16	{A6}+OC2Y,D5
;;?	ADD.W	D5,#2+2
	COMP.16	D5,D6			; souris plus basse ?
	JUMP,HI	LOOP$
	SWAP.32	D5

	COMP.16	D3,D0			; souris plus  doite ?
	JUMP,LO	LOOP$
	COMP.16	D5,D0			; souris plus  gauche ?
	JUMP,HI	LOOP$

	PUSHM.32 D0|A0
	CALL	GETMAP			; A0/D0 <-- ^map/bit
	TEST.8	{A0}:D0			; objet gris ?
	POPM.32	D0|A0
	JUMP,BS	LOOP$			; oui => LOOP$

	MOVE.32	D2,D4			; D4 <-- position dbut
	MOVE.32	A3,A4			; A4 <-- ^objet
	CLR.16	D7			; D7 <-- trouv
	JUMP	R8^QUIT$

EXIT$:	CLR.32	D4			; D4 <-- position "nil"
	MOVE.32	D4,A4			; A4 <-- ^nil
	MOVE.16	#1,D7			; D7 <-- pas trouv

QUIT$:	POPM.32	D0|D1|D2|D3|D5|D6|A3
	TEST.16	D7			; retour EQ/NE
	RET


;---------\\
; DETCADRE >
;=========/

; Dtecte si la souris est dans le cadre de la dbox.

; in	D4.L	position de la souris
; out	D7.W	erreur
; mod	D7.W

DETCADRE:
	PUSHM.32 D2..D4

	MOVE.16	#1,D7			; D7 <-- pas trouv

	MOVE.16	{A6}+OSVOPM,D3		; D3 <-- mode d'ouverture
	TEST.32	D3:#BDBSAV		; sauve sous la swdo ?
	JUMP,BC	R8^EXIT$		; non => EXIT$

; Pas de cadre, pas dplaable ou onglets => ne dtecte pas sur le cadre !

	AND.16	#2**BDBNOC+2**BDBNMV+2**BDBTAB,D3
	JUMP,NE	R8^EXIT$

	MOVE.32	D4,D3
	MOVE.16	{A6}+OPOSEXT+2,D2
	COMP.16	D2,D4
	JUMP,LO	R8^EXIT$
	ADD.16	{A6}+ODIMEXT+2,D2
	COMP.16	D2,D4
	JUMP,HI	R8^EXIT$
	SWAP.32	D4
	MOVE.16	{A6}+OPOSEXT+0,D2
	COMP.16	D2,D4
	JUMP,LO	R8^EXIT$
	ADD.16	{A6}+ODIMEXT+0,D2
	COMP.16	D2,D4
	JUMP,HI	R8^EXIT$

	MOVE.32	D3,D4
	MOVE.16	{A6}+OPOSEXT+2,D2
	ADD.16	#8,D2
	COMP.16	D2,D4
	JUMP,LO	R8^OK$
	ADD.16	{A6}+ODIMEXT+2,D2
	SUB.16	#8+8,D2
	COMP.16	D2,D4
	JUMP,HI	R8^OK$
	SWAP.32	D4
	MOVE.16	{A6}+OPOSEXT+0,D2
	ADD.16	#8,D2
	COMP.16	D2,D4
	JUMP,LO	R8^OK$
	ADD.16	{A6}+ODIMEXT+0,D2
	SUB.16	#8+8,D2
	COMP.16	D2,D4
	JUMP,LO	R8^EXIT$
OK$:
	CLR.16	D7			; D7 <-- ok
EXIT$:
	POPM.32	D2..D4
	TEST.16	D7			; retour EQ/NE
	RET

;--------\\
; CADINIT >
;========/

; Initialise les dimensions de la fentre mre.

; in	-
; out	-
; mod	D7.16

CADINIT:
	PUSHM.32 D2..D5

	LIB	?GETWDO			; D3/D4/D5 <-- pos/dim/no swdo actuelle
	MOVE.16	D5,D2
	CLR.16	D5
	LIB	?USEWDO			; utilise tout l'cran

	MOVE.32	{A0}+ODFFY,{A6}+OWDPOS
	MOVE.32	{A0}+ODFFDY,{A6}+OWDDIM

	MOVE.16	D2,D5
	LIB	?USEWDO			; utilse la swdo initiale

	POPM.32	D2..D5
	RET

;--------\\
; CADINV  >
;========/

; Inverse rapidement le cadre de la dbox.

; in	D2.32	offset pour coin sup/gauche (dy;dx)
;	D4.32	position de la souris
; out	-
; mod	D7.16

CADINV:
	PUSHM.32 D0..D5

	SUB.16	D2,D4
	SWAP.32	D2
	SWAP.32	D4
	SUB.16	D2,D4
;	SWAP.32	D2
	SWAP.32	D4
	MOVE.32	D4,D0			; D0 <-- coin sup/gauche
	MOVE.32	{A0}+ODFFDY,D1		; D1 <-- dimensions (intrieures)

	LIB	?GETWDO			; D3/D4/D5 <-- pos/dim/no swdo actuelle
	PUSH.16	D5
	CLR.16	D5
	LIB	?USEWDO			; utilise tout l'cran

.IF 0
	MOVE.32	#16'55AA55AA,D3
	MOVE.32	D3,D4
	LIB	?DRMDEF

	MOVE.32	#INVDOT,D2
	MOVE.32	D0,D3
	MOVE.32	D1,D4
	SUB.16	#8,D3
	ADD.16	#8+8,D4
	SWAP.32	D3
	SWAP.32	D4
	SUB.16	#8,D3
	MOVE.16	#8,D4
	SWAP.32	D3
	SWAP.32	D4
	LIB	?DRTRAME		; inverse la partie suprieure

	MOVE.32	D0,D3
	MOVE.32	D1,D4
	SUB.16	#8,D3
	ADD.16	#8+8,D4
	SWAP.32	D3
	SWAP.32	D4
	ADD.16	D4,D3
	MOVE.16	#8,D4
	SWAP.32	D3
	SWAP.32	D4
	LIB	?DRTRAME		; inverse la partie infrieure

	MOVE.32	D0,D3
	MOVE.32	D1,D4
	SUB.16	#8,D3
	MOVE.16	#8,D4
	LIB	?DRTRAME		; inverse la partie gauche

	MOVE.32	D0,D3
	MOVE.32	D1,D4
	ADD.16	D4,D3
	MOVE.16	#8,D4
	LIB	?DRTRAME		; inverse la partie droite
.ELSE
	LIB	?AFTIM
	.8	MAPTT
	.8	2'01010101		; map
	.8	1			; chelle
	.8	0
	.EVEN

	SUB.16	#8,D0
	SWAP.32	D0
	SUB.16	#8,D0
	SWAP.32	D0

	ADD.16	#8+7,D1
	SWAP.32	D1
	ADD.16	#8+7,D1
	SWAP.32	D1

	MOVE.32	#INVDOT.OR.TTTDOT,D2
	MOVE.32	D0,D3
	MOVE.32	D1,D4
	LIB	?DRRECT
.ENDIF

	POP.16	D5
	LIB	?USEWDO			; utilse la swdo initiale

	POPM.32	D0..D5
	RET

;--------\\
; CADPOS  >
;========/

; Calcule la nouvelle position correcte.

; in	D2.L	offset pour coin sup/gauche (dy;dx)
;	D4.32	position de la souris
; out	D4.L	position correcte
; mod	D4.L, D7.W

CADPOS:
	PUSHM.32 D2|D3

	SUB.16	D2,D4
	SUB.16	#8,D4
	AND.8	#2'11111000,D4

	SUB.16	{A6}+OWDPOS+2,D4
	JUMP,NC	R8^MINX$
	CLR.16	D4
MINX$:
	MOVE.16	{A6}+OWDDIM+2,D3
	SUB.16	{A6}+ODIMEXT+2,D3
	COMP.16	D3,D4
	JUMP,LS	R8^MAXX$
	MOVE.16	D3,D4
MAXX$:
	ADD.16	#8,D4
	ADD.16	D2,D4

	SWAP.32	D2
	SWAP.32	D4

	SUB.16	D2,D4
	SUB.16	#8,D4
	AND.8	#2'11111110,D4

	SUB.16	{A6}+OWDPOS+0,D4
	JUMP,NC	R8^MINY$
	CLR.16	D4
MINY$:
	MOVE.16	{A6}+OWDDIM+0,D3
	SUB.16	{A6}+ODIMEXT+0,D3
	COMP.16	D3,D4
	JUMP,LS	R8^MAXY$
	MOVE.16	D3,D4
MAXY$:
	ADD.16	#8,D4
	ADD.16	D2,D4

;	SWAP.32	D2
	SWAP.32	D4

	POPM.32	D2|D3
	RET

;--------\\
; CADMOVE >
;========/

; Dplace la dbox l o est arrive la souris.

; in	D2.L	offset pour coin sup/gauche (dy;dx)
;	D4.32	position de la souris
; out	-
; mod	D7.W

CADMOVE:
	PUSHM.32 D0..D6|A3..A5

	ADD.16	{A6}+OWDPOS+2,D4
	SUB.16	D2,D4
	SUB.16	#8,D4
	AND.8	#2'11111000,D4
	SWAP.32	D2
	SWAP.32	D4
	ADD.16	{A6}+OWDPOS+0,D4
	SUB.16	D2,D4
	SUB.16	#8,D4
;	SWAP.32	D2
	SWAP.32	D4
	MOVE.32	D4,D0			; D0 <-- coin sup/gauche

; Mmorise la nouvelle position dans la table globale.

	MOVE.32	A6,A5
	CALL	GETCOMMEM		; A6 <-- ^variables globales
	EX.32	A6,A5			; A5 <-- ^variables globales
	JUMP,NE	BUFF$

	TEST.32	{A6}+OPTABLE
	JUMP,EQ	BUFF$
	MOVE.32	{A6}+OPTABLE,A3
	MOVE.A16 {A3}+0,A4		; A4 <-- ^relatif table
	ADD.32	A3,A4			; A4 <-- ^table
	CALL	CHECKALL		; D4 <-- check de la dbox

	MOVE.32	#{A5}+OLP,A4		; A4 <-- ^table des dernires positions
	MOVE.16	#MAXLP-1,D1
LLOOP$:
	TEST.16	{A4}+OLPUSE		; lment utilis ?
	JUMP,EQ	R8^LNEXT$		; non => LNEXT$
	COMP.32	{A4}+OLPCHK,D4		; mme check ?
	JUMP,NE	R8^LNEXT$
MEM$:
	INC.16	{A5}+OLPCNT
	MOVE.16	{A5}+OLPCNT,{A4}+OLPUSE
	MOVE.32	D4,{A4}+OLPCHK
	MOVE.32	D0,{A4}+OLPPOS		; mmorise la dernire position utilise
	JUMP	R8^BUFF$

LNEXT$:
	ADD.A16	#LLP,A4			; A4 <-- ^lment suivant
	DJ.16,NMO D1,LLOOP$

	MOVE.32	#{A5}+OLP,A4		; A4 <-- ^table des dernires positions
	MOVE.16	#MAXLP-1,D1
	MOVE.16	#-1,D3
	SUB.32	A3,A3
MLOOP$:
	TEST.16	{A4}+OLPUSE		; lment utilis ?
	JUMP,EQ	MEM$			; non => MEM$
	COMP.16	{A4}+OLPUSE,D3
	JUMP,LO	R8^MNEXT$
	MOVE.16	{A4}+OLPUSE,D3
	MOVE.32	A4,A3			; A3 <-- ^lment le plus vieux
MNEXT$:
	ADD.A16	#LLP,A4			; A4 <-- ^lment suivant
	DJ.16,NMO D1,MLOOP$

	MOVE.32	A3,A4
	COMP.A16 #0,A4
	JUMP,NE	MEM$

; Rserve le buffer de sauvegarde.

BUFF$:
	MOVE.16	{A6}+ODIMEXT+2,D4
	ADD.16	#8-1,D4
	SR.16	#3,D4

	MOVE.32	#0,D3
	MOVE.8	{A0}+ODFCNP,D3
	LIB	?POW2DEPTH		; profondeur puissance de 2 suprieure
	MOVE.16	D3,{A6}+OBPPSAV		; prend note
	MUL.16	D3,D4
	MUL.16	{A6}+ODIMEXT+0,D4
	MOVE.32	#MTYPCP,D1
	GESMEM	?GETMEM			; A4 <-- ^buffer pour copie dbox
	JUMP,NE	EXIT$

; Ferme la swdo de la dbox actuelle, aprs avoir sauv son contenu.

	CLR.16	D5
	LIB	?USEWDO			; utilise swdo principale

	CALL	CADWDOSAV		; sauve le contenu actuel

	MOVE.8	#GETWDO,D3
	LIB	?AFCAR			; restitue contenu sous-fentre

	MOVE.16	{A6}+ONOWDO,D5
	LIB	?KILWDO			; dtruit swdo menu

; Cre la swdo pour la dbox  la nouvelle position.

	MOVE.32	D0,{A6}+OPOSEXT
	MOVE.32	D0,D3
	MOVE.32	{A6}+ODIMEXT,D4
	LIB	?CREWDO			; cre swdo extrieure
	MOVE.16	D5,D6			; D6 <-- numro swdo
	LIB	?USEWDO

	MOVE.8	#SAVWDO,D3
	LIB	?AFCAR			; sauve le contenu actuel

	CALL	CADWDOGET		; remet le contenu initial

	CLR.16	D5
	LIB	?USEWDO			; utilise swdo principale
	MOVE.16	D6,D5
	LIB	?KILWDO			; dtruit swdo extrieure

	MOVE.32	{A6}+OPOSEXT,D3
	ADD.16	#8,D3
	SWAP.32	D3
	ADD.16	#8,D3
	SWAP.32	D3
	MOVE.32	{A6}+ODIMEXT,D4
	SUB.16	#8+8,D4
	SWAP.32	D4
	SUB.16	#8+8,D4
	SWAP.32	D4
	LIB	?CREWDO			; cre swdo incluse
	LIB	?USEWDO			; utilise swdo incluse
	MOVE.16	D5,{A6}+ONOWDO		; mm. numro swdo

	MOVE.32	#MTYPCP,D1
	GESMEM	?GIVMEM			; libre le buffer pour copie dbox
EXIT$:
	POPM.32	D0..D6|A3..A5
	RET

;----------\\
; CADWDOSAV >
;----------/

; Sauve le contenu de la dbox dans le buffer de sauvegarde.

; in	A4.L	^buffer de sauvegarde
; out	-
; mod	D7.W

CADWDOSAV:
	PUSHM.32 D0..D6|A2|A3

	MOVE.8	#AFCCMO,D3
	LIB	?AFCAR

	SUB.32	A3,A3			; A3 <-- (0) cran
	MOVE.32	{A6}+OPOSEXT,D3		; D3 <-- [y;x] source
	SUB.16	{A6}+OWDPOS+2,D3
	SWAP.32	D3
	SUB.16	{A6}+OWDPOS+0,D3
	SWAP.32	D3

	CLR.32	D4
	MOVE.16	{A6}+ODIMEXT+2,D6
	ADD.16	#8-1,D6
	SR.16	#3,D6

	MOVE.32	{A6}+ODIMEXT,D2
	MOVE.32	A0,A2

	MOVE.16	{A6}+OBPPSAV,D0
	COMP.16	#1,D0
	JUMP,HI	R8^COLOR$

BW$:	MOVE.32	#LOADDOT,D1
	GRA_	RASTER
	JUMP	R8^EXIT$

COLOR$:	MUL.16	D0,D6
	MOVE.16	#LOADDOT.OR.2**BSRCCOUL.OR.2**BDSTCOUL,D1
	GRA_	CRASTER

EXIT$:	POPM.32	D0..D6|A2|A3
	RET

;----------\\
; CADWDOGET >
;----------/

; Remet le contenu du buffer de sauvegarde dans l'cran.

; in	A4.L	^buffer de sauvegarde
; out	-
; mod	D7.W

CADWDOGET:
	PUSHM.32 D0..D6|A2..A4

	MOVE.32	A4,A3
	CLR.32	D3
	MOVE.16	{A6}+ODIMEXT+2,D5
	ADD.16	#8-1,D5
	SR.16	#3,D5

	MOVE.32	#0,D4			; D4 <-- [y;x] dest.
	MOVE.32	D4,A4			; A4 <-- 0 (cran)

	MOVE.32	{A6}+ODIMEXT,D2
	MOVE.32	A0,A2

	CLR.16	D0
	MOVE.16	{A6}+OBPPSAV,D0
	COMP.16	#1,D0
	JUMP,HI	R8^COLOR$

BW$:	MOVE.32	#LOADDOT,D1
	GRA_	RASTER
	JUMP	R8^END$

COLOR$:	MUL.16	D0,D5
	MOVE.16	#LOADDOT.OR.2**BSRCCOUL.OR.2**BDSTCOUL,D1
	GRA_	CRASTER

END$:	MOVE.8	#AFSCMO,D3
	LIB	?AFCAR

	POPM.32	D0..D6|A2..A4
	RET


;--------\\
; GETMAP  >
;--------/

; Donne le pointeur et le numro du bit dans le map.

; in	D1.W	rang
; out	A0/D0	^map/bit
; mod	D0.L, A0.L

GETMAP:
	PUSH.16	D1

	COMP.16	#256,D1
	JUMP,LO	R8^MAX$
	MOVE.16	#256-1,D1
MAX$:
	MOVE.32	#{A6}+OMAPGR,A0
	MOVE.8	D1,D0
	AND.8	#2'111,D0		; D0 <-- rang du bit
	SR.16	#3,D1
	ADD.A16	D1,A0			; A0 <-- ^byte dans map

	POP.16	D1
	RET


;--------\\
; DESALL  >
;========/

; Dessine tous les objets.

; in	A4.32	^table
; out	-
; mod	-

DESALL:
	PUSHM.32 D1..D4|A3|A4

	NTREL	?GETPRIO
	MOVE.16	D4,D2
	MOVE.32	#7,D4
	NTREL	?SETPRIO		; met priorit plus forte

	LIB	?BUCAR

	MOVE.32	#-1,{A6}+OFACIRC

	MOVE.32	{A6}+OMARGY,D4

	CLR.16	{A6}+ONOFILE
	TSET.8	{A6}+OFLAGS:#BFADES
	TCLR.8	{A6}+OFLAGS:#BTITLE
	CLR.16	D1

LOOP$:	INC.16	D1			; D1 <-- rang suivant
	TEST.8	{A4}
	JUMP,EQ	R8^END$
	MOVE.32	A4,A3			; A3 <-- ^objet
	CALL	DESOBJET		; dessine un objet
	JUMP	LOOP$

END$:	LIB	?NOBUCAR

	MOVE.16	D2,D4
	NTREL	?SETPRIO		; remet priorit initiale

	POPM.32	D1..D4|A3|A4
	RET


;----------\\
; PRESOBJET >
;==========/

; Presse/relache un objet quelconque.

; in	A4.L	^dans table
;	D4.32	position
;	D2.16	mode de dessin (SETDOT/CLRDOT)
; out	-
; mod	-

PRESOBJET:
	TEST.32	D4			; objet existe ?
	JUMP,EQ	R8^EXIT$		; non => EXIT$
	COMP.8	#ODBFILE,{A4}
	JUMP,EQ	PRESFILE
	COMP.8	#ODBLINE,{A4}
	JUMP,EQ	PRESFILE
	COMP.8	#ODBCLINE,{A4}
	JUMP,EQ	PRESFILE
	COMP.8	#ODBXLINE,{A4}
	JUMP,EQ	PRESFILE
	COMP.8	#ODBXFILE,{A4}
	JUMP,EQ	PRESFILE
	COMP.8	#ODBBOX,{A4}
	JUMP,EQ	PRESBOX
	COMP.8	#ODBCIRCLE,{A4}
	JUMP,EQ	PRESCIRCLE
	COMP.8	#ODBLCIRCLE,{A4}
	JUMP,EQ	PRESLCIRCLE
	COMP.8	#ODBSQUARE,{A4}
	JUMP,EQ	PRESSQUARE
EXIT$:
	RET

;---------\\
; INVOBJET >
;=========/

; Inverse un objet quelconque.

; in	A4.32	^dans table
;	D4.32	position
; out	-
; mod	-

INVOBJET:
	PUSHM.32 D1|D2|D3|D4|A4

	MOVE.8	{A4+},D3		; D3 <-- objet
	COMP.8	#ODBSQUARE,D3
	JUMP,EQ	R8^INV$
	COMP.8	#ODBCIRCLE,D3
	JUMP,EQ	R8^MASK$
	COMP.8	#ODBLCIRCLE,D3
	JUMP,NE	R8^EXIT$
MASK$:
	MOVE.8	{A4},D3			; D3 <-- no du fanion
	TEST.32	D3:#6			; relche les autres boutons ?
	JUMP,BS	R8^INV$			; non => INV$ (c'est fait manuellement)
	MOVE.32	{A6}+OFANION,D1
	AND.32	{A6}+OFACIRC,D1		; teint tous les fanions
	MOVE.32	D1,{A6}+OFANION
INV$:
	MOVE.8	{A4},D3			; D3 <-- no du fanion
	MOVE.32	{A6}+OFANION,D1		; D1 <-- tats des fanions
	TNOT.32	D1:D3			; inverse le fanion
	MOVE.32	D1,{A6}+OFANION
EXIT$:
	POPM.32	D1|D2|D3|D4|A4
	RET


;---------\\
; DESOBJET >
;=========/

; Dessine un objet quelconque.

; in	A4.32	^dans table
;	D4.32	position
;	D1.16	rang (si dessin)
; out	A4.32	^plus loin
;	D4.32	position suivante
; mod	D3.8, D4.32, A4.32

DESOBJET:
	MOVE.8	{A4+},D3		; D3 <-- objet
	COMP.8	#ODBTITLE,D3
	JUMP,EQ	DESTITLE
	COMP.8	#ODBTEXT,D3
	JUMP,EQ	DESTEXT
	COMP.8	#ODBFILE,D3
	JUMP,EQ	DESFILE
	COMP.8	#ODBLINE,D3
	JUMP,EQ	DESLINE
	COMP.8	#ODBCLINE,D3
	JUMP,EQ	DESCLINE
	COMP.8	#ODBXLINE,D3
	JUMP,EQ	DESXLINE
	COMP.8	#ODBXFILE,D3
	JUMP,EQ	DESXFILE
	COMP.8	#ODBBOX,D3
	JUMP,EQ	DESBOX
	COMP.8	#ODBCIRCLE,D3
	JUMP,EQ	DESCIRCLE
	COMP.8	#ODBLCIRCLE,D3
	JUMP,EQ	DESCIRCLE
	COMP.8	#ODBSQUARE,D3
	JUMP,EQ	DESSQUARE
	COMP.8	#ODBCR,D3
	JUMP,EQ	DESCR
	COMP.8	#ODBCR2,D3
	JUMP,EQ	DESCR2
	COMP.8	#ODBTABX,D3
	JUMP,EQ	DESTABX
	COMP.8	#ODBTABXN,D3
	JUMP,EQ	DESTABXN
	COMP.8	#ODBTABYN,D3
	JUMP,EQ	DESTABYN
	COMP.8	#ODBTRAME,D3
	JUMP,EQ	DESTRAME
	COMP.8	#ODBLABEL,D3
	JUMP,EQ	DESLABEL
	COMP.8	#ODBKHELP,D3
	JUMP,EQ	DESKHELP
	RET

;---------\\
; DESTITLE >
;=========/

; Dessine l'objet titre.

; in	A4.32	^dans table
;	D4.32	position
; out	A4.32	^plus loin
;	D4.32	position suivante
; mod	D4.32, A4.32

DESTITLE:
	PUSHM.32 D1|D2|D3|A3

	TSET.8	{A6}+OFLAGS:#BTITLE	; prend note qu'il y a un titre !

	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	NODES$

	MOVE.32	D4,D1

	MOVE.32	#-1,D3
	MOVE.32	D3,D4
	LIB	?DRMDEF			; trame pleine (pour la suite)

	MOVE.16	{A6}+OC1Y,D3
	ADD.16	{A6}+OC2Y,D3
	SWAP.32	D3
	CLR.16	D3
	CLR.32	D4
	MOVE.16	{A6}+ODIMWDO+2,D4
	MOVE.32	#SETDOT,D2
	LIB	?DRSEG			; ligne horizontale

	TEST.8	{A6}+OlL3DOK		; look 3D ok ?
	JUMP,F	R8^No3D$		; non => suite

	MOVE.32	#0,D3
	MOVE.16	{A6}+OC1Y,D4
	ADD.16	{A6}+OC2Y,D4
	SWAP.32	D4
	MOVE.16	{A6}+ODIMWDO+2,D4
	LIB	?DRTRAME		; remplit le rectangle en noir !!!

No3D$:	MOVE.32	D1,D4
	MOVE.16	{A6}+OC1Y,D4
	SWAP.32	D4
	CLR.16	D4

	MOVE.32	A4,A3			; A3 <-- ^.ASCIZ
	MOVE.16	#-1,D3
NB$:
	INC.16	D3			; D3 <-- nb de caractres
	TEST.8	{A3+}
	JUMP,NE	NB$
	ADD.16	#1+1,D3
	MUL.16	{A6}+OCX,D3
	SUB.16	{A6}+ODIMWDO+2,D3
	NEG.16	D3
	SR.16	#1,D3			; D3 <-- lg pour une trame

	TEST.8	{A6}+OlL3DOK		; look 3D ok ?
	JUMP,F	R8^No3D2$		; non => suite

	ADD.16	D3,D4
	ADD.16	{A6}+OCX,D4

	MOVE.32	#COLOR_DBCLEAR,D3
	LIB	?COLORSR
	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORCR

	CALL	DESASCIZ		; titre au centre

	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR
	MOVE.32	#COLOR_DBCLEAR,D3
	LIB	?COLORCR

	MOVE.32	D1,D4
	JUMP	R8^CR$

No3D2$:	CALL	DESTITRAME		; trame
	ADD.16	{A6}+OCX,D4		; espace
	CALL	DESASCIZ		; titre au centre
	ADD.16	{A6}+OCX,D4		; espace
	CALL	DESTITRAME		; trame

	MOVE.32	D1,D4
	JUMP	R8^CR$

NODES$:
	CALL	DESASCIZ		; A4 <-- saute .ASCIZ
	MOVE.16	{A6}+OCX,D3
	MUL.16	#2+2,D3			; au moins 2 car gauche/droite
	ADD.16	D3,D4
CR$:
	CALL	DESCR			; passe  la ligne

	POPM.32	D1|D2|D3|A3
	RET

;--------\\
; DESTEXT >
;========/

; Dessine l'objet texte.

; in	A4.L	^dans table
;	D4.32	position
; out	A4.L	^plus loin
;	D4.32	position suivante
; mod	D4.L, A4.L

DESTEXT:
;;?	CALL	DESBASCIZ	; efface autour
	JUMP	DESASCIZ		; dessine le texte

;--------\\
; DESFILE >
;========/

; Dessine l'objet nom de fichier.

; in	A4.L	^dans table
;	D4.32	position
; out	A4.L	^plus loin
;	D4.32	position suivante
; mod	D4.L, A4.L

DESFILE:
	PUSHM.32 D1..D3|A3

	MOVE.32	#{A6}+OTAFILE,A3
	MOVE.16	{A6}+ONOFILE,D3
	MUL.16	#LGFI,D3
	ADD.32	D3,A3			; A3 <-- ^dans OTAFILE
	CLR.8	{A3}+OFITYP		; table <-- type "fichier"
DESFILI:
	MOVE.32	D4,D2			; D2 <-- position de dpart

	MOVE.8	#TDBNORM,D1		; D1 <-- type normal

	MOVE.32	#0,D3
	MOVE.8	{A4},D3			; D3 <-- lg cran = lg buffer
	TCLR.32	D3:#7
	MUL.16	{A6}+OCX,D3
	SWAP.32	D3
	MOVE.8	{A4+},D3		; D3 <-- nb caractres
	JUMP,NC	R8^L30$
	TCLR.32	D3:#7			; D3 <-- idem, mais positif
	ADD.A16	#2,A4			; A4 <-- saute <fonc> <touche>
	MOVE.8	{A4+},D1		; D1 <- <type>

L30$:	COMP.8	#2,{A3}+OFITYP		; type "clear-ligne" ?
	JUMP,NE	R8^L40$
	MOVE.8	#1,{A3}+OFITYP		; table <-- type "ligne"
	TSET.32	D3:#15			; D3 <-- met le mode "clear-ligne"

L40$:	TSET.32	D3:#14			; D3 <-- signal largeur dans D3 <31..16>
	MOVE.32	D3,{A3}+OFILG		; table <-- longueur
	AND.16	#16'0FFF,D3
	MUL.16	{A6}+OCX,D3

DESYFILI:
	COMP.8	#TDBSCAD,D1		; objet sans cadre ?
	JUMP,EQ	R8^L40$			; oui => 40$
	TEST.8	{A6}+OlL3DOK		; look 3D ?
	JUMP,T	R8^ED$			; oui => toujours le mme aspect
	COMP.8	#TDBNORM,D1
	JUMP,NE	R8^L30$

ED$:	MOVE.8	#TDBEDIT,D1

L30$:	CALL	DESRECT			; dessine rectangle englobant
	JUMP	R8^L50$

L40$:	PUSH.8	{A6}+OFLAGS
	TSET.8	{A6}+OFLAGS:#BNODES
	CALL	DESRECT			; "saute" rectangle englobant
	POP.8	{A6}+OFLAGS

L50$:	TEST.8	{A6}+OFLAGS:#BCHECK
	JUMP,BS	R8^L60$

	ADD.16	{A6}+OCX,D2
	MOVE.32	D2,{A3}+OFIPOS		; table <-- position pour ligne

L60$:	INC.16	{A6}+ONOFILE		; un fichier ditable de plus

	POPM.32	D1..D3|A3
	RET

;--------\\
; DESLINE >
;========/

; Dessine l'objet ligne de texte.

; in	A4.L	^dans table
;	D4.32	position
; out	A4.L	^plus loin
;	D4.32	position suivante
; mod	D4.L, A4.L

DESLINE:
	PUSHM.32 D1..D3|A3

	MOVE.32	#{A6}+OTAFILE,A3
	MOVE.16	{A6}+ONOFILE,D3
	MUL.16	#LGFI,D3
	ADD.32	D3,A3			; A3 <-- ^dans OTAFILE
	MOVE.8	#1,{A3}+OFITYP		; table <-- type "ligne"
	JUMP	DESFILI

;---------\\
; DESCLINE >
;=========/

; Dessine l'objet ligne de texte.

; in	A4.L	^dans table
;	D4.32	position
; out	A4.L	^plus loin
;	D4.32	position suivante
; mod	D4.L, A4.L

DESCLINE:
	PUSHM.32 D1..D3|A3

	MOVE.32	#{A6}+OTAFILE,A3
	MOVE.16	{A6}+ONOFILE,D3
	MUL.16	#LGFI,D3
	ADD.32	D3,A3			; A3 <-- ^dans OTAFILE
	MOVE.8	#2,{A3}+OFITYP		; table <-- type "clear-ligne"
	JUMP	DESFILI

;---------\\
; DESXFILE >
;=========/

; Dessine l'objet nom de fichier.

; in	A4.L	^dans table
;	D4.32	position
; out	A4.L	^plus loin
;	D4.32	position suivante
; mod	D4.L, A4.L

DESXFILE:
	PUSHM.32 D1..D3|A3

	MOVE.32	#{A6}+OTAFILE,A3
	MOVE.16	{A6}+ONOFILE,D3
	MUL.16	#LGFI,D3
	ADD.32	D3,A3			; A3 <-- ^dans OTAFILE
	CLR.8	{A3}+OFITYP		; table <-- type "fichier"
DESXFILI:
	MOVE.32	D4,D2			; D2 <-- position de dpart

	CLR.16	D3
	MOVE.8	{A4+},D3		; D3 <-- lg cran
	MUL.16	{A6}+OCX,D3
	SWAP.32	D3
	MOVE.8	{A4+},D3		; D3 <-- lg buffer
	RR.16	#8,D3
	MOVE.8	{A4+},D3		; D3 <-- flags
	RR.16	#8,D3
	TSET.32	D3:#14			; D3 <-- signal largeur dans D3 <31..16>
	MOVE.32	D3,{A3}+OFILG		; table <-- longueur
	SWAP.32	D3

	ADD.A16	#2,A4			; A4 <-- saute <fonc> <touche>
	MOVE.8	{A4+},D1		; D1 <- <type>
	JUMP	DESYFILI

;---------\\
; DESXLINE >
;=========/

; Dessine l'objet nom de fichier.

; in	A4.L	^dans table
;	D4.32	position
; out	A4.L	^plus loin
;	D4.32	position suivante
; mod	D4.L, A4.L

DESXLINE:
	PUSHM.32 D1..D3|A3

	MOVE.32	#{A6}+OTAFILE,A3
	MOVE.16	{A6}+ONOFILE,D3
	MUL.16	#LGFI,D3
	ADD.32	D3,A3			; A3 <-- ^dans OTAFILE
	MOVE.8	#1,{A3}+OFITYP		; table <-- type "ligne"
	JUMP	DESXFILI


;--------\\
; DESBOX  >
;========/

; Dessine l'objet bote.

; in	A4.32	^dans table
;	D4.32	position
; out	A4.32	^plus loin
;	D4.32	position suivante
; mod	D4.32, A4.32

DESBOX:
	PUSHM.32 D1|D2|D3

	MOVE.32	D4,D2			; D2 <-- position de dpart

	ADD.A16	#3,A4			; A4 <-- saute <fonc><touche><type>
	PUSH.32	A4
	CALL	LGASCIZ			; D3 <-- longueur en points
	POP.32	A4

	MOVE.8	{A4}-1,D1		; D1 <-- type de mise en vidence ?
	COMP.8	#TDBSCAD,D1		; BOX sans cadre ?
	JUMP,EQ	R8^SCAD$		; oui => SCAD$
	CALL	DESRECT			; dessine rectangle englobant
	JUMP	R8^TEXT$
SCAD$:
	PUSH.8	{A6}+OFLAGS
	TSET.8	{A6}+OFLAGS:#BNODES
	CALL	DESRECT			; "saute" rectangle englobant
	POP.8	{A6}+OFLAGS
TEXT$:
	EX.32	D4,D2

	ADD.16	{A6}+OCX,D4
	CALL	DESASCIZ		; met le texte  l'intrieur

	MOVE.32	D2,D4			; D4 <-- position aprs rectangle
	ADD.16	{A6}+OCX,D4

	POPM.32	D1|D2|D3
	RET

;----------\\
; DESCIRCLE >
;==========/

; Dessine l'objet cercle.

; in	A4.L	^dans table
;	D4.32	position
;	D3.8	objet (ODBCIRCLE ou ODBLCIRCLE)
;	D1.16	rang (si dessin)
; out	A4.L	^plus loin
;	D4.32	position suivante
; mod	D4.L, A4.L

DESCIRCLE:
	PUSHM.32 D0|D1|D2|D3|D5|D6|A3

	MOVE.32	A4,A3			; A3 <-- ^objet
	MOVE.8	D3,D0			; D0 <-- objet
	MOVE.32	D4,D5			; D5 <-- position dbut
	MOVE.16	D1,D6			; D6 <-- rang

	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	R8^FAN$
	COMP.8	#ODBLCIRCLE,D0		; petit cercle ?
	JUMP,EQ	R8^FAN$			; oui => FAN$

	MOVE.32	D4,D1
	CLR.32	D3
	CLR.32	D4
	LIB	?DRMDEF			; dfini une trame vide
	MOVE.32	D1,D3
	SWAP.32	D3
	SUB.16	{A6}+OC1Y,D3
	SUB.16	#2+3,D3			; D3 <-- coin sup/gauche Y
	SWAP.32	D3
	SUB.16	#3,D3			; D3 <-- coin sup/gauche X
	MOVE.16	{A6}+OC1Y,D4
	ADD.16	#(2+3)*2,D4		; D4 <-- dY
	MOVE.16	D4,D2
	SWAP.32	D4
	MOVE.16	D2,D4			; D4 <-- dX
	MOVE.32	#CLRDOT,D2
	LIB	?DRTRAME		; efface autour du cercle
	MOVE.32	D1,D4

FAN$:	MOVE.8	{A4+},D3		; D3 <-- no du fanion
	JUMP,NC	R8^FSKIP$

	ADD.A16	#2,A4			; A4 <-- saute <fonc> <touche>

FSKIP$:	TEST.8	{A6}+OFLAGS:#BFADES
	JUMP,BC	EXT$

	MOVE.32	{A6}+OFACIRC,D1		; D1 <-- fanions des cercles
	TCLR.32	D1:D3			; un fanion cercle de plus
	MOVE.32	D1,{A6}+OFACIRC		; mj.

	TEST.8	{A6}+OBIG		; new look ?
	JUMP,T	LOOK$			; oui => LOOK$

	MOVE.32	{A6}+OFANION,D1		; D1 <-- fanions
	TEST.32	D1:D3			; fanion allum ?
	JUMP,BS	R8^SET$			; oui => SET$
					; non =>
CLR$:	MOVE.32	{A6}+OFADESS,D1
	TCLR.32	D1:D3
;;	JUMP,BC	R8^EXT$
	MOVE.32	D1,{A6}+OFADESS

	MOVE.32	#CLRDOT,D2
	CALL	INVCIRCLE		; teint le fanion
	JUMP	R8^EXT$

SET$:	MOVE.32	{A6}+OFADESS,D1
	TSET.32	D1:D3
	JUMP,BS	R8^EXT$
	MOVE.32	D1,{A6}+OFADESS

	MOVE.32	#SETDOT,D2
	CALL	INVCIRCLE		; allume le fanion

EXT$:	MOVE.32	D4,D1
	MOVE.32	D4,D3
	MOVE.16	{A6}+OC1Y,D2
	SR.16	#1,D2
	SWAP.32	D3
	SUB.16	D2,D3
	SWAP.32	D3
	ADD.16	#2,D2
	ADD.16	D2,D3
	MOVE.16	D2,D4			; D4 <-- rayon

	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	AVX$
	MOVE.32	#SETDOT,D2
	LIB	?DRCERCLE
	JUMP	AVX$

; Noveau look... utilise les ressources.

LOOK$:	MOVE.32	D4,D1
	TCLR.32	D0:#16			; D0 <-- rien dessin

	MOVE.32	{A6}+OFANION,D2		; D1 <-- fanions
	TEST.32	D2:D3			; fanion allum ?
	JUMP,BS	R8^LSET$		; oui => LSET$
					; non =>
LCLR$:	MOVE.32	{A6}+OFADESS,D2
	TCLR.32	D2:D3
	JUMP,BC	R8^LEND$
	MOVE.32	D2,{A6}+OFADESS

	MOVE.32	#LOADDOT,D2
	MOVE.16	#ICON_CIR_0N,D3
	SWAP.32	D4
	SUB.16	#14-2,D4
	SWAP.32	D4
	CALL	DRAWICON		; dessine le bouton teint
	MOVE.32	D1,D4
	TSET.32	D0:#16			; D0 <-- on a dessin
	JUMP	R8^LEND$

LSET$:	MOVE.32	{A6}+OFADESS,D2
	TSET.32	D2:D3
	JUMP,BS	R8^LEND$
	MOVE.32	D2,{A6}+OFADESS

	MOVE.32	#LOADDOT,D2
	MOVE.16	#ICON_CIR_1N,D3
	SWAP.32	D4
	SUB.16	#14-2,D4
	SWAP.32	D4
	CALL	DRAWICON		; dessine le bouton allum
	MOVE.32	D1,D4
	TSET.32	D0:#16			; D0 <-- on a dessin

LEND$:	MOVE.16	{A6}+OC1Y,D4
	SR.16	#1,D4
	ADD.16	#2,D4			; D4 <-- rayon

AVX$:	ADD.16	D4,D1
	ADD.16	D4,D1
	INC.16	D1
	MOVE.32	D1,D4			; D4 <-- position d'arrive

	COMP.8	#ODBLCIRCLE,D0		; petit cercle ?
	JUMP,EQ	R8^TEXT$		; oui => TEXT$
	CALL	DESBASCIZ		; non => efface autour

TEXT$:	CALL	DESASCIZ		; dessine le texte aprs

	TEST.8	{A6}+OBIG		; new look ?
	JUMP,F	R8^EXIT$		; non => EXIT$

	TEST.32	D0:#16			; a-t-on dessin ?
	JUMP,BC	R8^EXIT$		; non => EXIT$

	PUSHM.32 D0|D1|A0
	MOVE.16	D6,D1			; D1 <-- rang
	CALL	GETMAP			; A0/D0 <-- ^map/bit
	TEST.8	{A0}:D0			; objet gris ?
	POPM.32	D0|D1|A0
	JUMP,BC	R8^EXIT$		; non => EXIT$

	PUSH.32	A4
	MOVE.32	D5,D3			; D3 <-- position dbut
	MOVE.32	A3,A4			; A4 <-- ^objet
	CALL	GREYOBJET		; grise l'objet
	POP.32	A4

EXIT$:	POPM.32	D0|D1|D2|D3|D5|D6|A3
	RET


;----------\\
; DESSQUARE >
;==========/

; Dessine l'objet carr.

; in	A4.32	^dans table
;	D4.32	position
;	D1.16	rang (si dessin)
; out	A4.32	^plus loin
;	D4.32	position suivante
; mod	D4.32, A4.32

DESSQUARE:
	PUSHM.32 D0|D1|D2|D3|D6|A3

	MOVE.32	A4,A3			; A3 <-- ^objet
	TCLR.32	D4:#0
	MOVE.32	D4,D0			; D0 <-- position dpart
	MOVE.16	D1,D6			; D6 <-- rang

	MOVE.8	{A4+},D1		; D1 <-- no du fanion
	JUMP,NC	R8^SKIP$
	ADD.A16	#2,A4			; A4 <-- saute <fonc> <touche>

SKIP$:	TEST.8	{A6}+OFLAGS:#BFADES
	JUMP,BC	TEXT$

	TEST.8	{A6}+OBIG		; new look ?
	JUMP,T	LOOK$			; oui => LOOK$

	MOVE.32	{A6}+OFANION,D3		; D3 <-- fanions
	MOVE.32	{A6}+OFADESS,D2		; D2 <-- fanions  dessiner
	XOR.32	D2,D3			; D3 <-- fanions qui ont chang
	TEST.32	D3:D1			; fanion  redessiner ?
	JUMP,F	TEXT$			; non => c'est tout

	MOVE.32	D4,D3
	MOVE.16	{A6}+OC1Y,D2
	MOVE.16	D2,D4			; D4 <-- dY
	SWAP.32	D4
	MOVE.16	D2,D4			; D4 <-- dX
	ADD.16	#2,D3
	SWAP.32	D3
	SUB.16	D2,D3
	SWAP.32	D3
	MOVE.32	#SETDOT,D2
	LIB	?DRRECT			; dessine le carr vide

	MOVE.32	{A6}+OFANION,D3		; D3 <-- fanions
	TEST.32	D3:D1			; fanion allum ?
	JUMP,BS	R8^SET$			; oui => SET$

CLR$:	MOVE.32	{A6}+OFADESS,D3
	TCLR.32	D3:D1
	JUMP,BC	TEXT$
	MOVE.32	D3,{A6}+OFADESS

	MOVE.32	#CLRDOT,D2
	MOVE.32	D0,D4
	CALL	INVSQUARE		; teint le fanion
	JUMP	TEXT$

SET$:	MOVE.32	{A6}+OFADESS,D3
	TSET.32	D3:D1
	JUMP,BS	TEXT$
	MOVE.32	D3,{A6}+OFADESS

	MOVE.32	#SETDOT,D2
	MOVE.32	D0,D4
	CALL	INVSQUARE		; allume le fanion
	JUMP	TEXT$

LOOK$:	TCLR.32	D1:#16			; D1 <-- rien dessin

	MOVE.32	{A6}+OFANION,D3		; D3 <-- fanions
	TEST.32	D3:D1			; fanion allum ?
	JUMP,BS	R8^LSET$		; oui => LSET$
LCLR$:					; non =>
	MOVE.32	{A6}+OFADESS,D3
	TCLR.32	D3:D1
	JUMP,BC	R8^TEXT$
	MOVE.32	D3,{A6}+OFADESS

	MOVE.32	#LOADDOT,D2
	MOVE.16	#ICON_SQR_0N,D3
	SWAP.32	D4
	SUB.16	#14-2,D4
	SWAP.32	D4
	CALL	DRAWICON		; dessine le bouton teint
	TSET.32	D1:#16			; D1 <-- on a dessin
	JUMP	R8^TEXT$

LSET$:
	MOVE.32	{A6}+OFADESS,D3
	TSET.32	D3:D1
	JUMP,BS	R8^TEXT$
	MOVE.32	D3,{A6}+OFADESS

	MOVE.32	#LOADDOT,D2
	MOVE.16	#ICON_SQR_1N,D3
	SWAP.32	D4
	SUB.16	#14-2,D4
	SWAP.32	D4
	CALL	DRAWICON		; dessine le bouton allum
	TSET.32	D1:#16			; D1 <-- on a dessin
TEXT$:
	MOVE.32	D0,D4			; D4 <-- position dpart
	MOVE.16	{A6}+OC1Y,D1
	SR.16	#1,D1
	ADD.16	D1,D4
	ADD.16	D1,D4
	ADD.16	#4+1,D4			; D4 <-- position arrive

;;?	CALL	DESBASCIZ		; efface autour			@@@
	CALL	DESASCIZ		; dessine le texte aprs

	TEST.8	{A6}+OBIG		; new look ?
	JUMP,F	R8^EXIT$		; non => EXIT$

	TEST.32	D1:#16			; a-t-on dessin ?
	JUMP,BC	R8^EXIT$		; non => EXIT$

	PUSHM.32 D0|D1|A0
	MOVE.16	D6,D1			; D1 <-- rang
	CALL	GETMAP			; A0/D0 <-- ^map/bit
	TEST.8	{A0}:D0			; objet gris ?
	POPM.32	D0|D1|A0
	JUMP,BC	R8^EXIT$		; non => EXIT$

	PUSH.32	A4
	MOVE.32	D0,D3			; D3 <-- position dbut
	MOVE.32	A3,A4			; A4 <-- ^objet
	CALL	GREYOBJET		; grise l'objet
	POP.32	A4
EXIT$:
	POPM.32	D0|D1|D2|D3|D6|A3
	RET

;--------\\
; DESCR   >
;========/

; Dessine l'objet passe  la ligne.

; in	D4.L	position
; out	D4.L	position suivante
; mod	D4.L

DESCR:
	MOVE.16	{A6}+OMARGX,D4
	SWAP.32	D4
	ADD.16	{A6}+OCY,D4
	SWAP.32	D4
	RET

;--------\\
; DESCR2  >
;========/

; Dessine l'objet passe  la demi-ligne.

; in	D4.L	position
; out	D4.L	position suivante
; mod	D4.L

DESCR2:
	PUSH.16	D3

	MOVE.16	{A6}+OMARGX,D4
	SWAP.32	D4
	MOVE.16	{A6}+OCY,D3
	SR.16	#1,D3
	ADD.16	D3,D4
	SWAP.32	D4

	POP.16	D3
	RET

;--------\\
; DESTABX >
;========/

; Dessine l'objet tabulateur horizontal.

; in	A4.L	^dans table
;	D4.32	position
; out	A4.L	^plus loin
;	D4.32	position suivante
; mod	D4.L, A4.L

DESTABX:
	PUSH.32	D3

	CLR.16	D3
	MOVE.8	{A4+},D3		; D3 <-- position tabulateur
	MUL.16	{A6}+OCX,D3
	ADD.16	{A6}+OMARGX,D3		; D3 <-- ajoute marge gauche
	MOVE.16	D3,D4

	POP.32	D3
	RET

;---------\\
; DESTABXN >
;=========/

; Dessine l'objet tabulateur horizontal en points.

; in	A4.L	^dans table
;	D4.32	position
; out	A4.L	^plus loin
;	D4.32	position suivante
; mod	D4.L, A4.L

DESTABXN:
	MOVE.8	{A4+},D4
	SL.16	#8,D4
	MOVE.8	{A4+},D4		; D4 <-- position tabulateur
	ADD.16	{A6}+OMARGX,D4		; D4 <-- ajoute marge gauche
	RET

;---------\\
; DESTABYN >
;=========/

; Dessine l'objet tabulateur vertical en points.

; in	A4.L	^dans table
;	D4.32	position
; out	A4.L	^plus loin
;	D4.32	position suivante
; mod	D4.L, A4.L

DESTABYN:
	SWAP.32	D4
	MOVE.8	{A4+},D4
	SL.16	#8,D4
	MOVE.8	{A4+},D4		; D4 <-- position tabulateur
	ADD.16	{A6}+OMARGY,D4		; D4 <-- ajoute marge suprieure
	SWAP.32	D4
	RET

;---------\\
; DESTRAME >
;=========/

; Dessine une trame dans toute la bote.

; in	A4.32	^dans table
; out	A4.32	^plus loin
; mod	A4.32

DESTRAME:
	PUSHM.32 D2|D3|D4|A3

	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	END$
	TEST.8	{A6}+OlL3DOK		; look 3D ?
	JUMP,T	END$			; oui => ne dessine rien

	MOVE.32	#COLOR_DBTRAME,D3
	LIB	?COLORSR		; met la couleur de la trame

	CLR.32	D2			; D2 <-- cran entrelac
	NTREL	?GETMACHINE
	RL.32	#8,D4			; D4 <-- type de machine
	COMP.8	#1,D4			; Smaky 8 ?
	JUMP,EQ	R8^TRAME$		; oui => TRAME$
	INC.16	D2			; D2 <-- cran non-entrelac
TRAME$:
	MOVE.32	A4,A3			; A3 <-- ^<trame> 8x
	MOVE.8	{A3},D3
	ADD.32	D2,A3
	SL.32	#8,D3
	MOVE.8	{A3+},D3
	SL.32	#8,D3
	MOVE.8	{A3},D3
	ADD.32	D2,A3
	SL.32	#8,D3
	MOVE.8	{A3+},D3

	MOVE.8	{A3},D4
	ADD.32	D2,A3
	SL.32	#8,D4
	MOVE.8	{A3+},D4
	SL.32	#8,D4
	MOVE.8	{A3},D4
	ADD.32	D2,A3
	SL.32	#8,D4
	MOVE.8	{A3+},D4

	LIB	?DRMDEF			; dfini la trame

	CLR.32	D3			; D3 <-- origine
	MOVE.32	{A6}+ODIMWDO,D4		; D4 <-- dimensions

	TEST.8	{A6}+OFLAGS:#BTITLE
	JUMP,BC	R8^DRAW$
	SWAP.32	D3
	ADD.16	{A6}+OCY,D3
	SWAP.32	D3
	SWAP.32	D4
	SUB.16	{A6}+OCY,D4
	SWAP.32	D4
DRAW$:
	MOVE.16	#SETDOT,D2		; D2 <-- mode
	LIB	?DRTRAME		; dessine la trame

	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; remet la couleur pour dessiner
END$:
	ADD.A16	#8,A4			; A4 <-- saute <trame> 8x

	POPM.32	D2|D3|D4|A3
	RET


;---------\\
; DESLABEL >
;=========/

; Dessine un label !

; in	A4.L	^dans table
; out	A4.L	^plus loin
; mod	A4.L

DESLABEL:
	INC.32	A4			; A4 <-- saute le no du label
	RET


;---------\\
; DESKHELP >
;=========/

; Affiche un raccourci clavier.

; Affiche le raccourci clavier pour atteindre une dbox,
; dans le coin en bas  droite.
; Le texte doit tre termin par zro. Les caractres suivants
; sont spciaux :
;	"("	dbut d'une touche
;	"-"	sparation entre deux touches
;	")"	fin d'une touche
;	"_"	tiret
;	"<1>"	espace d'un point
;	"<2>"	espace de trois points

; in	A4.L	^texte
; out	A4.L	^plus loin
; mod	D7.W, A4.L

DESKHELP:
	PUSHM.32 D2..D4|A0|A3

	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	SKIP$

	MOVE.32	#COLOR_DBKHELP,D3
	LIB	?COLORSR		; met la couleur des raccourcis

	MOVE.32	{A6}+OPDDIS,A0		; A0 <-- ^description de la fentre

	MOVE.8	{A0}+ODFGCF,{A6}+OSVGC+1
	MOVE.8	{A0}+ODFGCS,{A6}+OSVGC+2; sauve le gencar actuel
	MOVE.8	{A0}+ODFGCT,{A6}+OSVGC+3

	LIB	?AFTIM
	.8	LOADGC,GCKRF,GCKRS,GCKRT
	.8	USEGC,GCKRF,GCKRS,GCKRT
	.8	0
	.EVEN
	LIB	?FLUSH			;  cause du LIB,?BUCAR !
	JUMP,EQ	R8^DRAW$

	LIB	?AFTIM
	.8	LOADGC,GCTPF,GCTPS,GCTPT
	.8	USEGC,GCTPF,GCTPS,GCTPT
	.8	0
	.EVEN
	LIB	?FLUSH			;  cause du LIB,?BUCAR !
DRAW$:
	MOVE.32	A4,A3			; A3 <-- ^texte
	CLR.16	D2
LG$:
	MOVE.8	{A4+},D3
	JUMP,EQ	R8^AFF$

	LIB	?LGXCAR			; D4 <-- largeur du caractre
	ADD.16	D4,D2			; D2 <-- largeur totale
	JUMP	LG$

AFF$:
	MOVE.16	{A0}+ODFFDY,D3
	SUB.16	{A0}+ODFC2Y,D3
	SUB.16	#2,D3
	SWAP.32	D3
	MOVE.16	{A0}+ODFFDX,D3
	SUB.16	D2,D3
	SUB.16	#4,D3
	LIB	?SETCURS

	MOVE.8	#AFTOUT,D3
	LIB	?AFCAR			; affiche tout
	LIB	?AFTEXT			; affiche le raccourci clavier
	MOVE.8	#AFNORM,D3
	LIB	?AFCAR			; affiche normalement
END$:
	MOVE.32	#{A6}+OSVGC,A3
	MOVE.8	#USEGC,{A3}
	MOVE.16	#4,D3
	LIB	?STRING			; remet le gencar initial

	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; remet la couleur pour dessiner
	JUMP	R8^EXIT$

SKIP$:
	TEST.8	{A4+}			; A4 <-- saute le .ASCIZ
	JUMP,NE	SKIP$
EXIT$:
	POPM.32	D2..D4|A0|A3
	RET


;---------\\
; DESASCIZ >
;---------/

; Affiche un .ASCIZ

; in	D4.L	position
;	A4.32	^texte
; out	D4.L	position suivante
;	A4.32	^plus loin
; mod	D4.L, A4.L

DESASCIZ:
	PUSHM.32 D2|D3|A3

	COMP.8	#-1,{A4}		; caractres graphiques ?
	JUMP,EQ	R8^GRA$			; oui => GRA$

	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	R8^SKIP$

	MOVE.32	D4,D3
	LIB	?SETCURS		; positionne curseur au dbut
	MOVE.8	#AFTOUT,D3
	LIB	?AFCAR			; affiche tout
	MOVE.32	A4,A3			; A3 <-- ^texte
	LIB	?AFTEXT			; affiche le texte
	MOVE.8	#AFNORM,D3
	LIB	?AFCAR			; affiche normalement
SKIP$:
	CALL	LGASCIZ			; D3 <-- longueur en points
	ADD.16	D3,D4			; D4 <-- position suivante
	JUMP	R8^EXIT$

GRA$:
	INC.32	A4			; A4 <-- saute <-1>
	CLR.32	D3
	MOVE.8	{A4+},D3		; D3 <-- nb bytes
	CLR.16	D2
	MOVE.8	{A4+},D2		; D2 <-- longueur (en points)
	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	R8^GSKIP$
	MOVE.32	A4,A3			; A3 <-- ^bytes
	LIB	?STRING			; affiche qq bytes
GSKIP$:
	ADD.32	D3,A4			; A4 <-- saute qq bytes
	ADD.16	D2,D4			; D4 <-- position suivante
EXIT$:
	POPM.32	D2|D3|A3
	RET

;----------\\
; DESBASCIZ >
;==========/

; Efface autour d'un .ASCIZ

; in	D4.L	position
;	A4.32	^texte
; out	-
; mod	-

DESBASCIZ:
	PUSHM.32 D1|D2|D3|D4|A4

	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	EXIT$

	MOVE.32	D4,D1
	CLR.32	D3
	CLR.32	D4
	LIB	?DRMDEF			; dfini une trame vide

	CALL	LGASCIZ			; D3 <-- longueur en points
	MOVE.16	D3,D4
	SWAP.32	D4
	MOVE.16	{A6}+OC1Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	{A6}+OC2Y,D4
	SWAP.32	D4

	MOVE.32	D1,D3
	SWAP.32	D3
	SUB.16	{A6}+OC1Y,D3
	SUB.16	{A6}+OC2Y,D3
	SWAP.32	D3

	MOVE.32	#CLRDOT,D2
	LIB	?DRTRAME		; efface tout autour
EXIT$:
	POPM.32	D1|D2|D3|D4|A4
	RET

;--------\\
; LGASCIZ >
;--------/

; Calcul la longueur d'un .ASCIZ

; in	A4.L	^texte<0>
; out	A4.L	^plus loin
;	D3.16	longueur (en points)
; mod	D3.L, A4.L

LGASCIZ:
	PUSH.32	D4

	COMP.8	#-1,{A4}		; caractres graphiques ?
	JUMP,EQ	R8^GRA$			; oui => GRA$

	MOVE.16	#-1,D3
LOOP$:
	INC.16	D3			; D3 <-- nb de caractres
	TEST.8	{A4+}			; A4 <-- saute le .ASCIZ
	JUMP,NE	LOOP$
	MUL.16	{A6}+OCX,D3
	JUMP	R8^EXIT$

GRA$:
	INC.32	A4			; A4 <-- saute <-1>
	CLR.32	D4
	MOVE.8	{A4+},D4		; D4 <-- nb bytes
	CLR.16	D3
	MOVE.8	{A4+},D3		; D3 <-- longueur
	ADD.32	D4,A4			; A4 <-- saute bytes
EXIT$:
	POP.32	D4
	RET


;--------\\
; DESRECT >
;--------/

; Dessine un rectangle de longueur quelconque.

; in	D4.32	position
;	D3.16	longueur du rectangle
;	D1.8	type de mise en vidence
; out	D4.32	position suivante
; mod	D4.32

DESRECT:
	PUSHM.32 D0..D3

	CALL	DESBIG			; dessine mise en vidence selon D1
	MOVE.8	D1,D0			; D0 <-- type de mise en vidence

	MOVE.16	{A6}+OCX,D2

	MOVE.32	D4,D1			; D1 <-- position origine
	ADD.16	D3,D1			; D1 <-- position suivante
	ADD.16	D2,D1
	ADD.16	D2,D1

	EX.32	D4,D3

	ADD.16	D2,D4
	SR.16	#1,D2			; D2 <-- largeur 1/2 caractre
	ADD.16	D2,D3

	SWAP.32	D3
	SUB.16	{A6}+OC1Y,D3
	SUB.16	{A6}+OC2Y,D3
	SUB.16	#2,D3
	SWAP.32	D3

	SWAP.32	D4
	MOVE.16	{A6}+OC1Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	#2+2,D4
	SWAP.32	D4

	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	END$

	PUSHM.32 D3|D4
	CLR.32	D3
	CLR.32	D4
	LIB	?DRMDEF			; dfini une trame vide
	POPM.32	D3|D4

	TEST.8	{A6}+OlL3DOK		; look 3D ok ?
	JUMP,F	R8^No3D$		; non => suite

	PUSH.32 D3
	ADD.16	#1,D3
	SWAP.32	D3
	ADD.16	#1,D3
	SWAP.32	D3

	MOVE.32	#CLRDOT,D2
	LIB	?DRTRAME		; efface tout le rectangle
	POP.32	D3
	JUMP	R8^Ok3D$

No3D$:	MOVE.32	#CLRDOT,D2
	LIB	?DRTRAME		; efface tout le rectangle

Ok3D$:	MOVE.32	#SETDOT,D2

	TEST.8	{A6}+ONOSTALGIE		; en monochrome et nostalgique ?
	JUMP,T	R8^NOSTALGIE$		; oui => comme anciennement
	TEST.8	{A6}+OBIG		; new look ?
	JUMP,T	R8^LOOK$		; oui => LOOK$

NOSTALGIE$:
	LIB	?DRRECT
	JUMP	END$

LOOK$:	CALL	paDRAWBOX		; dessine une bote en relief
	JUMP,EQ	END$			; russi => termin

	COMP.8	#TDBMEV,D0
	JUMP,EQ	R8^LMEV$
	COMP.8	#TDBOMBRE,D0
	JUMP,EQ	R8^LOMB$
	COMP.8	#TDBEDIT,D0
	JUMP,EQ	R8^LEDIT$
LNORM$:
	DEC.16	D4
	SWAP.32	D4
	DEC.16	D4
	SWAP.32	D4
	CALL	DESRECTB
	JUMP	R8^END$

LMEV$:
	DEC.16	D4
	SWAP.32	D4
	DEC.16	D4
	SWAP.32	D4
	CALL	DESRECTT

	SUB.16	#3,D3
	SWAP.32	D3
	SUB.16	#3,D3
	SWAP.32	D3
	ADD.16	#3+3,D4
	SWAP.32	D4
	ADD.16	#3+3,D4
	SWAP.32	D4
	CALL	DESRECTB
	JUMP	R8^END$

LOMB$:
	INC.16	D3
	SWAP.32	D3
	INC.16	D3
	SWAP.32	D3
	SUB.16	#2,D4
	SWAP.32	D4
	SUB.16	#2,D4
	SWAP.32	D4
	CALL	DESRECTB

	SUB.16	#2,D3
	SWAP.32	D3
	SUB.16	#2,D3
	SWAP.32	D3
	ADD.16	#2+2,D4
	SWAP.32	D4
	ADD.16	#2+2,D4
	SWAP.32	D4
	CALL	DESRECTA
	JUMP	R8^END$

LEDIT$:
	CALL	DESRECTA

	ADD.16	#2,D3
	SWAP.32	D3
	ADD.16	#2,D3
	SWAP.32	D3
	SUB.16	#2+2,D4
	SWAP.32	D4
	SUB.16	#2+2,D4
	SWAP.32	D4
	CALL	DESRECTA
;	JUMP	R8^END$

END$:
	MOVE.32	D1,D4			; D4 <-- position suivante

	POPM.32	D0..D3
	RET

;--------\\
; DESBIG  >
;--------/

; Dessine un rectangle de mise en vidence.

; in	D4.32	position
;	D3.16	longueur du rectangle
;	D1.8	type de mise en vidence
; out	-
; mod	-

DESBIG:
	PUSHM.32 D1|D2|D3|D4

	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	EXIT$
	TEST.8	{A6}+ONOSTALGIE		; en monochrome et nostalgique ?
	JUMP,T	R8^NOSTALGIE$		; oui => comme anciennement
	TEST.8	{A6}+OBIG		; new look ?
	JUMP,T	EXIT$			; oui => EXIT$

NOSTALGIE$:
	EX.32	D4,D3

	COMP.8	#TDBMEV,D1
	JUMP,EQ	MEV$			; mise en vidence => MEV$
	COMP.8	#TDBOMBRE,D1
	JUMP,NE	EXIT$
SHADOW$:				; ombre =>
	MOVE.16	{A6}+OCX,D2
	ADD.16	D2,D4
	SR.16	#1,D2			; D2 <-- largeur 1/2 caractre
	ADD.16	D2,D3
	ADD.16	#2,D3

	SWAP.32	D3
	ADD.16	{A6}+OC2Y,D3
	ADD.16	#2+1,D3
	SWAP.32	D3

	DEC.16	D4
	AND.32	#16'0000FFFF,D4

	MOVE.32	#SETDOT,D2
	PUSH.32	D3
	LIB	?DRSEG			; 1re ligne horizontale
	POP.32	D3
	SWAP.32	D3
	INC.16	D3
	SWAP.32	D3
	PUSH.32	D3
	LIB	?DRSEG			; 2me ligne horizontale
	POP.32	D3

	ADD.16	D4,D3

	MOVE.16	{A6}+OC1Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	#2+2,D4
	NEG.16	D4
	SWAP.32	D4
	CLR.16	D4

	MOVE.32	#SETDOT,D2
	PUSH.32	D3
	LIB	?DRSEG			; 1re ligne verticale
	POP.32	D3
	INC.16	D3
	LIB	?DRSEG			; 2me ligne verticale
	JUMP	EXIT$

MEV$:
	MOVE.16	{A6}+OCX,D2
	ADD.16	D2,D4
	ADD.16	#1+1,D4
	SR.16	#1,D2			; D2 <-- largeur 1/2 caractre
	ADD.16	D2,D3
	DEC.16	D3

	SWAP.32	D3
	SUB.16	{A6}+OC1Y,D3
	SUB.16	{A6}+OC2Y,D3
	SUB.16	#2+1,D3
	SWAP.32	D3

	SWAP.32	D4
	MOVE.16	{A6}+OC1Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	#3+3,D4
	SWAP.32	D4

	TEST.8	{A6}+OFLAGS:#BNODES
	JUMP,BS	EXIT$

	MOVE.32	#CLRDOT,D2
	LIB	?DRRECT

	MOVE.16	#2,D1			; D1 <-- paisseur
MLOOP$:
	DEC.16	D3
	SWAP.32	D3
	DEC.16	D3
	SWAP.32	D3
	ADD.16	#2,D4
	SWAP.32	D4
	ADD.16	#2,D4
	SWAP.32	D4
	MOVE.32	#SETDOT,D2
	LIB	?DRRECT
	DEC.16	D1
	JUMP,NE	MLOOP$
EXIT$:
	POPM.32	D1|D2|D3|D4
	RET

;---------\\
; DESRECTB >
;---------/

; Dessine un rectangle en bosse, c'est--dire avec une ombre
;  droite et en bas.

; in	D2.W	mode de dessin
;	D3.32	coin sup/gauche (y;x)
;	D4.32	dimensions (dy;dx)
; out	-
; mod	D7.W

DESRECTB:
	PUSHM.32 D0|D1|D3|D4

	CALL	DESRECTA

	MOVE.32	D3,D0
	MOVE.32	D4,D1

;	MOVE.32	D0,D3
;	MOVE.32	D1,D4
	ADD.16	#2,D3
	DEC.16	D4
	SWAP.32	D3
	SWAP.32	D4
	ADD.16	D4,D3
	INC.16	D3
	CLR.16	D4
	SWAP.32	D3
	SWAP.32	D4
	LIB	?DRSEG			; dessine l'ombre en bas

	MOVE.32	D0,D3
	MOVE.32	D1,D4
	ADD.16	D4,D3
	INC.16	D3
	CLR.16	D4
	SWAP.32	D3
	SWAP.32	D4
	ADD.16	#2,D3
	DEC.16	D4
	SWAP.32	D3
	SWAP.32	D4
	LIB	?DRSEG			; dessine l'ombre  droite

	POPM.32	D0|D1|D3|D4
	RET

;---------\\
; DESRECTT >
;---------/

; Dessine un rectangle en trou, c'est--dire avec une ombre
;  gauche et en haut.

; in	D2.W	mode de dessin
;	D3.32	coin sup/gauche (y;x)
;	D4.32	dimensions (dy;dx)
; out	-
; mod	D7.W

DESRECTT:
	PUSHM.32 D0|D1|D3|D4

	CALL	DESRECTA

	MOVE.32	D3,D0
	MOVE.32	D4,D1

;	MOVE.32	D0,D3
	INC.16	D3
	SWAP.32	D3
	INC.16	D3
	SWAP.32	D3
	CLR.32	D4
	MOVE.16	D1,D4
	DEC.16	D4
	LIB	?DRSEG			; dessine l'ombre en haut

	MOVE.32	D0,D3
	INC.16	D3
	SWAP.32	D3
	INC.16	D3
	SWAP.32	D3
	MOVE.32	D1,D4
	SWAP.32	D4
	DEC.16	D4
	SWAP.32	D4
	CLR.16	D4
	LIB	?DRSEG			; dessine l'ombre  gauche

	POPM.32	D0|D1|D3|D4
	RET

;---------\\
; DESRECTA >
;---------/

; Dessine un rectangle lgrement arrondi (sans les points des coins).

; in	D2.W	mode de dessin
;	D3.32	coin sup/gauche (y;x)
;	D4.32	dimensions (dy;dx)
; out	-
; mod	D7.W

DESRECTA:
	PUSHM.32 D0|D1|D3|D4

	MOVE.32	D4,D1

	INC.16	D3
	CLR.32	D4
	MOVE.16	D1,D4
	DEC.16	D4
	LIB	?DRSEG			; dessine le trait suprieur

	SWAP.32	D3
	INC.16	D3
	SWAP.32	D3
	MOVE.32	D1,D4
	SWAP.32	D4
	DEC.16	D4
	SWAP.32	D4
	CLR.16	D4
	LIB	?DRSEG			; dessine le trait droite

	DEC.16	D3
	CLR.32	D4
	MOVE.16	D1,D4
	DEC.16	D4
	NEG.16	D4
	LIB	?DRSEG			; dessine le trait infrieur

	SWAP.32	D3
	DEC.16	D3
	SWAP.32	D3
	MOVE.32	D1,D4
	SWAP.32	D4
	DEC.16	D4
	NEG.16	D4
	SWAP.32	D4
	CLR.16	D4
	LIB	?DRSEG			; dessine le trait gauche

	POPM.32	D0|D1|D3|D4
	RET

;-----------\\
; DESTITRAME >
;-----------/

; Dessine une trame pour le titre.

; in	D4.32	position
;	D3.16	longueur pour la trame
; out	D4.32	position suivante
; mod	D4.32

DESTITRAME:
	PUSHM.32 D1|D2|D3|A3

	PUSHM.32 D3|D4
	MOVE.32	#COLOR_DBTITLE,D3
	LIB	?COLORSR		; met la couleur du titre

	MOVE.32	#16'00110044,D3
	MOVE.32	D3,D4			; D4 <-- suite trame
	LIB	?DRMDEF			; dfini la trame
	POPM.32	D3|D4

	MOVE.32	D4,D1			; D1 <-- position origine
	ADD.16	D3,D1			; D1 <-- position suivante

	EX.32	D4,D3

	SWAP.32	D3
	SUB.16	{A6}+OC1Y,D3
	SWAP.32	D3

	SWAP.32	D4
	MOVE.16	{A6}+OC1Y,D4
	ADD.16	{A6}+OC2Y,D4
	SWAP.32	D4

	MOVE.32	#SETDOT,D2
	LIB	?DRTRAME

	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; remet la couleur pour dessiner

	MOVE.32	D1,D4			; D4 <-- position suivante

	POPM.32	D1|D2|D3|A3
	RET



;----------\\
; INVCIRCLE >
;==========/

; Inverse un objet cercle.

; in	D4.L	position
;	D2.16	mode de dessin
; out	-
; mod	-

INVCIRCLE:
	PUSHM.32 D1|D2|D3|D4

	MOVE.32	#COLOR_DBSEL,D3
	LIB	?COLORSR		; met la couleur pour slectionner

	MOVE.32	D4,D3
	MOVE.16	{A6}+OC1Y,D1
	SR.16	#1,D1
	SWAP.32	D3
	SUB.16	D1,D3
	SWAP.32	D3
	ADD.16	#2,D1
	ADD.16	D1,D3
	MOVE.16	D1,D4			; D4 <-- rayon

	SUB.16	#3,D4
	JUMP,HI	R8^DLOOP$
	MOVE.16	#3,D4

DLOOP$:	LIB	?DRCERCLE		; fait qq cercles
	DEC.16	D4
	JUMP,NE	DLOOP$

	PUSHM.32 D3|D4
	CLR.32	D3
	CLR.32	D4
	COMP.8	#CLRDOT,D2
	JUMP,EQ	R8^MDEF$
	NOT.32	D3
	NOT.32	D4
MDEF$:
	LIB	?DRMDEF
	POPM.32	D3|D4

	SR.16	#2,D1			; D1 <-- ~ (R*sin(45))/2
	SUB.16	D1,D3
	SWAP.32	D3
	SUB.16	D1,D3
	SWAP.32	D3
	SL.16	#1,D1
	MOVE.16	D1,D4
	SWAP.32	D4
	MOVE.16	D1,D4
	LIB	?DRTRAME		; amliore les cercles

	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; remet la couleur pour dessiner

	POPM.32	D1|D2|D3|D4
	RET

;----------\\
; INVSQUARE >
;==========/

; Inverse un objet carr.

; in	A4.L	^objet
;	D4.32	position
;	D2.16	mode de dessin
; out	-
; mod	-

INVSQUARE:
	PUSHM.32 D1|D2|D3|D4

	MOVE.32	#COLOR_DBSEL,D3
	LIB	?COLORSR		; met la couleur pour slectionner

	MOVE.32	D4,D3
	ADD.16	#2+1,D3
	SWAP.32	D3
	SUB.16	{A6}+OC1Y,D3
	INC.16	D3
	SWAP.32	D3

	MOVE.16	{A6}+OC1Y,D1
	DEC.16	D1
	MOVE.16	D1,D4
	SWAP.32	D4
	MOVE.16	D1,D4

	PUSH.32	D3
	LIB	?DRSEG			; fait une diagonale
	POP.32	D3

	ADD.16	D4,D3
	DEC.16	D3
	NEG.16	D4
	LIB	?DRSEG			; fait l'autre diagonale

	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; remet la couleur pour dessiner

	POPM.32	D1|D2|D3|D4
	RET


;---------\\
; PRESFILE >
;=========/

; Presse un objet fichier/ligne.

; in	A4.L	^objet
;	D4.32	position
;	D2.16	mode de dessin
; out	-
; mod	-

PRESFILE:
	PUSHM.32 D1|D2|D3|D4

	MOVE.32	#COLOR_PPHILI,D3
	LIB	?COLORSR		; met la couleur pour mettre en vidence

	MOVE.32	D4,D1
	MOVE.32	#-1,D3
	MOVE.32	D3,D4
	LIB	?DRMDEF			; dfini une trame pleine
	MOVE.32	D1,D3

	MOVE.16	{A6}+OCX,D2
	SR.16	#1,D2
	ADD.16	D2,D3
	INC.16	D3			; D3 <-- origine en X
	SWAP.32	D3
	SUB.16	{A6}+OC1Y,D3
	SUB.16	{A6}+OC2Y,D3
	DEC.16	D3			; D3 <-- origine en Y
	SWAP.32	D3

	MOVE.16	{A6}+OC1Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	#1+2,D4			; D4 <-- hauteur
	SWAP.32	D4

	MOVE.8	{A4}+1,D2		; D2 <-- nb caractres
	AND.16	#16'7F,D2
	MUL.16	{A6}+OCX,D2
	MOVE.16	D2,D4
	ADD.16	{A6}+OCX,D4
	DEC.16	D4			; D4 <-- largeur

	TEST.8	{A6}+ONOSTALGIE		; en monochrome et nostalgique ?
	JUMP,T	R8^INV$			; oui => comme anciennement
	TEST.8	{A6}+OBIG		; new look ?
	JUMP,F	R8^INV$			; non => INV$
	ADD.16	#2,D3
	SWAP.32	D3
	ADD.16	#2,D3
	SWAP.32	D3
	SUB.16	#2+2,D4
	SWAP.32	D4
	SUB.16	#2+2,D4
	SWAP.32	D4
INV$:
	MOVE.32	#INVDOT,D2
	LIB	?DRTRAME		; inverse la bote

	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; remet la couleur pour dessiner

	POPM.32	D1|D2|D3|D4
	RET

;--------\\
; PRESBOX >
;========/

; Presse un objet bote.

; in	A4.32	^objet
;	D4.32	position
;	D2.16	mode de dessin
; out	-
; mod	-

PRESBOX:
	PUSHM.32 D0|D1|D2|D3|D4|A4

	MOVE.16	D2,D0			; prend note du mode (SET/CLRDOT)

	MOVE.32	#COLOR_PPHILI,D3
	LIB	?COLORSR		; met la couleur pour mettre en vidence

	MOVE.32	D4,D1
	MOVE.32	#-1,D3
	MOVE.32	D3,D4
	LIB	?DRMDEF			; dfini une trame pleine
	MOVE.32	D1,D3

	MOVE.16	{A6}+OCX,D2
	SR.16	#1,D2
	ADD.16	D2,D3
	INC.16	D3			; D3 <-- origine en X
	SWAP.32	D3
	SUB.16	{A6}+OC1Y,D3
	SUB.16	{A6}+OC2Y,D3
	DEC.16	D3			; D3 <-- origine en Y
	SWAP.32	D3

	MOVE.16	{A6}+OC1Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	{A6}+OC2Y,D4
	ADD.16	#1+2,D4			; D4 <-- hauteur
	SWAP.32	D4

	ADD.A16	#4,A4			; A4 <-- saute <ODBBOX><fonc><touche><type>
	PUSHM.32 D3|A4
	CALL	LGASCIZ			; D3 <-- longueur
	MOVE.16	D3,D4
	POPM.32	D3|A4
	ADD.16	{A6}+OCX,D4
	DEC.16	D4			; D4 <-- largeur

	TEST.8	{A6}+ONOSTALGIE		; en monochrome et nostalgique ?
	JUMP,T	R8^INV$			; oui => comme anciennement
	TEST.8	{A6}+OBIG		; new look ?
	JUMP,F	R8^INV$			; non => INV$

	CALL	paPRESBOX		; tente de presser via enfoncement
	JUMP,EQ	EXIT$			; ok => termin

	ADD.16	#2,D3
	SWAP.32	D3
	ADD.16	#2,D3
	SWAP.32	D3
	SUB.16	#2+2,D4
	SWAP.32	D4
	SUB.16	#2+2,D4
	SWAP.32	D4

	COMP.8	#TDBNORM,{A4}-1
	JUMP,NE	R8^INV$

	DEC.16	D3
	SWAP.32	D3
	DEC.16	D3
	SWAP.32	D3
	INC.16	D4
	SWAP.32	D4
	INC.16	D4
	SWAP.32	D4
INV$:
	MOVE.32	#INVDOT,D2
	LIB	?DRTRAME		; inverse la bote

EXIT$:	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; remet la couleur pour dessiner

	POPM.32	D0|D1|D2|D3|D4|A4
	RET

;-----------\\
; PRESCIRCLE >
;===========/

; Presse un objet cercle.

; in	A4.32	^objet
;	D4.32	position
;	D2.16	mode de dessin
; out	-
; mod	-

PRESCIRCLE:
	PUSHM.32 D1|D2|D3|D4

	TEST.8	{A6}+OBIG		; new look ?
	JUMP,T	R8^LOOK$		; oui => LOOK$

	MOVE.32	#COLOR_PPHILI,D3
	LIB	?COLORSR		; met la couleur pour mettre en vidence

	MOVE.32	D4,D3
	MOVE.16	{A6}+OC1Y,D1
	SR.16	#1,D1
	SWAP.32	D3
	SUB.16	D1,D3
	SWAP.32	D3
	ADD.16	#2,D1
	ADD.16	D1,D3
	MOVE.16	D1,D4			; D4 <-- rayon

	MOVE.8	#2,D1
LOOP$:
	INC.16	D4
	LIB	?DRCERCLE		; fait qq cercles
	DEC.8	D1
	JUMP,NE	LOOP$

	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; remet la couleur pour dessiner
	JUMP	R8^EXIT$

LOOK$:
	COMP.16	#SETDOT,D2
	JUMP,NE	R8^LDRAWx$

	MOVE.16	#ICON_CIR_0P,D3		; D3 <-- bouton teint
	MOVE.8	{A4}+1,D1		; D1 <-- no du fanion
	MOVE.32	{A6}+OFANION,D2		; D2 <-- fanions
	TEST.32	D2:D1			; fanion allum ?
	JUMP,BC	R8^LDRAW$		; non => DRAW$
	MOVE.16	#ICON_CIR_1P,D3		; D3 <-- bouton allum
	JUMP	R8^LDRAW$

LDRAWx$:
	MOVE.16	#ICON_CIR_0N,D3		; D3 <-- bouton teint
	MOVE.8	{A4}+1,D1		; D1 <-- no du fanion
	MOVE.32	{A6}+OFANION,D2		; D2 <-- fanions
	TEST.32	D2:D1			; fanion allum ?
	JUMP,BC	R8^LDRAW$		; non => DRAW$
	MOVE.16	#ICON_CIR_1N,D3		; D3 <-- bouton allum

LDRAW$:	MOVE.32	#LOADDOT,D2
	SWAP.32	D4
	SUB.16	#14-2,D4
	SWAP.32	D4
	CALL	DRAWICON		; dessine le bouton
EXIT$:
	POPM.32	D1|D2|D3|D4
	RET

;------------\\
; PRESLCIRCLE >
;============/

; Presse un objet petit cercle.

; in	A4.L	^objet
;	D4.32	position
;	D2.16	mode de dessin
; out	-
; mod	-

PRESLCIRCLE:
	PUSHM.32 D1|D2|D3|D4

	TEST.8	{A6}+OBIG		; new look ?
	JUMP,T	R8^LOOK$		; oui => LOOK$

	MOVE.32	#COLOR_PPHILI,D3
	LIB	?COLORSR		; met la couleur pour mettre en vidence

	MOVE.32	D4,D3
	MOVE.16	{A6}+OC1Y,D1
	SR.16	#1,D1
	SWAP.32	D3
	SUB.16	D1,D3
	SWAP.32	D3
	ADD.16	#2,D1
	ADD.16	D1,D3
	MOVE.16	D1,D4			; D4 <-- rayon

	INC.16	D4
	LIB	?DRCERCLE		; fait juste un cercle

	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; remet la couleur pour dessiner
	JUMP	R8^EXIT$

LOOK$:
	CALL	PRESCIRCLE
EXIT$:
	POPM.32	D1|D2|D3|D4
	RET

;-----------\\
; PRESSQUARE >
;===========/

; Presse un objet carr.

; in	A4.32	^objet
;	D4.32	position
;	D2.16	mode de dessin
; out	-
; mod	-

PRESSQUARE:
	PUSHM.32 D1|D2|D3|D4

	TCLR.32	D4:#0

	TEST.8	{A6}+OBIG		; new look ?
	JUMP,T	R8^LOOK$		; oui => LOOK$

	MOVE.32	#COLOR_PPHILI,D3
	LIB	?COLORSR		; met la couleur pour mettre en vidence

	MOVE.32	D4,D3
	ADD.16	#2,D3
	MOVE.16	{A6}+OC1Y,D1
	MOVE.16	D1,D4			; D4 <-- dY
	SWAP.32	D4
	MOVE.16	D1,D4			; D4 <-- dX
	SWAP.32	D3
	SUB.16	D1,D3
	SWAP.32	D3

	MOVE.8	#2,D1
LOOP$:
	DEC.16	D3
	SWAP.32	D3
	DEC.16	D3
	SWAP.32	D3
	ADD.16	#2,D4
	SWAP.32	D4
	ADD.16	#2,D4
	SWAP.32	D4
	LIB	?DRRECT
	DEC.8	D1
	JUMP,NE	LOOP$

	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; remet la couleur pour dessiner
	JUMP	R8^EXIT$

; Nouveau look : presse le bouton carr...

LOOK$:
	COMP.16	#SETDOT,D2		; pas en train de presser ?
	JUMP,NE	R8^LDRAWx$		; non => on quitte le dessin

	MOVE.16	#ICON_SQR_0P,D3		; D3 <-- bouton press (teint)
	MOVE.8	{A4}+1,D1		; D1 <-- no du fanion
	MOVE.32	{A6}+OFANION,D2		; D2 <-- fanions
	TEST.32	D2:D1			; fanion allum ?
	JUMP,BC	R8^LDRAW$		; non => DRAW$
	MOVE.16	#ICON_SQR_1P,D3		; D3 <-- bouton press (allum)
	JUMP	R8^LDRAW$

LDRAWx$:
	MOVE.16	#ICON_SQR_0N,D3		; D3 <-- bouton teint
	MOVE.8	{A4}+1,D1		; D1 <-- no du fanion
	MOVE.32	{A6}+OFANION,D2		; D2 <-- fanions
	TEST.32	D2:D1			; fanion allum ?
	JUMP,BC	R8^LDRAW$		; non => DRAW$
	MOVE.16	#ICON_SQR_1N,D3		; D3 <-- bouton allum
LDRAW$:
	MOVE.32	#LOADDOT,D2
	SWAP.32	D4
	SUB.16	#14-2,D4
	SWAP.32	D4
	CALL	DRAWICON		; dessine le bouton press
EXIT$:
	POPM.32	D1|D2|D3|D4
	RET





;--------\\
; CREWDO  >
;========/

; Cre une sous-fentre (swdo).

; in	D2.16	mode d'ouverture
;	D3.32	position centre (si BDBPOS)
;	D4.32	dimensions
; out	D7.W	erreur
; mod	D7.W

CREWDO:
	PUSHM.32 D3|D4

	CALL	CALCWDO			; D3/D4 <-- position/dimensions
	JUMP,NE	R8^EXIT$

	CALL	OPEWDO			; ouvre la swdo
EXIT$:
	POPM.32	D3|D4
	TEST.16	D7			; retour EQ/NE
	RET

;--------\\
; CALCWDO >
;========/

; Calcule la position de la sous-fentre (swdo).

; in	D2.16	mode d'ouverture
;	D3.32	position centre (si BDBPOS)
;	D4.32	dimensions
; out	D3.32	coin sup/gauche (y;x)
;	D4.32	dimensions (dy;dx)
;	D7.16	erreur
; mod	D3.32, D4.32, D7.16

CALCWDO:
	PUSHM.32 D0..D2|A3..A5

; Regarde si la table des dernires positions contient dj une position
; pour le dialogue en cours d'ouverture.

	TEST.32	{A6}+OPTABLE		; est-on en train d'ouvrir un dialogue ?
	JUMP,EQ	R8^NORM$		; non => NORM$

	MOVE.32	A6,A5
	CALL	GETCOMMEM		; A6 <-- ^variables globales
	EX.32	A6,A5
	JUMP,NE	EXIT$

	MOVE.32	{A6}+OPTABLE,A3
	MOVE.A16 {A3}+0,A4		; A4 <-- ^relatif table
	ADD.32	A3,A4			; A4 <-- ^table
	MOVE.32	D4,D0
	CALL	CHECKALL		; D4 <-- check de la dbox
	EX.32	D4,D0

	MOVE.32	#{A5}+OLP,A4		; A4 <-- ^table des dernires positions
	MOVE.16	#MAXLP-1,D1

LLOOP$:	TEST.16	{A4}+OLPUSE		; lment utilis ?
	JUMP,EQ	R8^LNEXT$		; non => LNEXT$
	COMP.32	{A4}+OLPCHK,D0		; mme check ?
	JUMP,NE	R8^LNEXT$

	INC.16	{A5}+OLPCNT
	MOVE.16	{A5}+OLPCNT,{A4}+OLPUSE

	MOVE.32	{A4}+OLPPOS,D3		; D3 <-- dernire position utilise

	MOVE.16	{A0}+ODFDX,D2
	SUB.16	D4,D2
	COMP.16	D2,D3			; dpasse le bord droite ?
	JUMP,LS	R8^POSX$
	MOVE.16	D2,D3

POSX$:	SWAP.32	D3
	SWAP.32	D4

	MOVE.16	{A0}+ODFDY,D2
	SUB.16	D4,D2
	COMP.16	D2,D3			; dpasse le bord infrieur ?
	JUMP,LS	R8^POSY$
	MOVE.16	D2,D3

POSY$:	SWAP.32	D3
	SWAP.32	D4
	JUMP	OK$

LNEXT$:	ADD.A16	#LLP,A4			; A4 <-- ^lment suivant
	DJ.16,NMO D1,LLOOP$

; Voil... calcule maintenant la position du centre de la DBOX

NORM$:	MOVE.32	D4,D1			; D1 <-- dimensions

	TEST.32	D2:#BDBPOS		; position selon D3 ?
	JUMP,BS	R8^POS$			; oui => POS$

	MOVE.16	{A0}+ODFDY,D3
	SR.16	#1,D3			; D3 <-- milieu selon Y
	SWAP.32	D3
	MOVE.16	{A0}+ODFDX,D3
	SR.16	#1,D3			; D3 <-- milieu selon X

	TEST.32	D2:#BDBMOU		; position selon la souris ?
	JUMP,BC	R8^POS$			; non => POS$
					; oui =>
	LIB	?IFMOUSE
	JUMP,NE	EXIT$

	MOVE.32	D4,D3			; D3 <-- position souris

POS$:	MOVE.32	D1,D4			; D4 <-- dimensions
;	MOVE.16	D4,D1			; D1 <-- largeur
	SR.16	#1,D1			; D1 <-- 1/2 largeur
	SUB.16	D1,D3			; D3 <-- recule l'origine en X
	JUMP,HS	R8^DEBX$

	CLR.16	D3			; recale si trop  gauche

DEBX$:	SWAP.32	D3
	SWAP.32	D4
	MOVE.16	D4,D1			; D1 <-- hauteur
	SR.16	#1,D1			; D1 <-- 1/2 hauteur
	ADD.16	{A6}+OMARGTOP,D3	; D3 <-- descend de la hauteur des onglets
	SUB.16	D1,D3			; D3 <-- remonte l'origine en Y
	JUMP,HS	R8^DEBY$

	CLR.16	D3			; recale si trop haut

DEBY$:	SWAP.32	D4
	SWAP.32	D3

	MOVE.16	#ERDIOUT,D7
	COMP.16	{A0}+ODFDX,D4		; swdo trop large ?
	JUMP,HS	R8^EXIT$

	MOVE.16	D3,D1
	ADD.16	D4,D1
	COMP.16	{A0}+ODFDX,D1		; swdo trop  droite ?
	JUMP,LS	R8^MINX$

	MOVE.16	{A0}+ODFDX,D3
	SUB.16	D4,D3

MINX$:	SWAP.32	D3
	SWAP.32	D4
	MOVE.16	#ERDIOUT,D7
	COMP.16	{A0}+ODFDY,D4		; swdo trop haute ?
	JUMP,HS	R8^EXIT$

	MOVE.16	D3,D1
	ADD.16	D4,D1
	COMP.16	{A0}+ODFDY,D1		; swdo trop basse ?
	JUMP,LS	R8^MINY$

	MOVE.16	{A0}+ODFDY,D3
	SUB.16	D4,D3

MINY$:	SWAP.32	D4
	SWAP.32	D3

	AND.32	#16'FFFEFFF8,D3
	AND.32	#16'FFFEFFF8,D4

OK$:	CLR.16	D7			; D7 <-- ok

EXIT$:	POPM.32	D0..D2|A3..A5
	TEST.16	D7			; retour EQ/NE
	RET

;-------\\
; OPEWDO >
;=======/

; Ouvre une sous-fentre (swdo) et dessine son cadre.

; in	D2.16	mode d'ouverture
;	D3.32	origine (Y;X)
;	D4.32	dimensions (dY,dX)
; out	D7.16	erreur
; mod	D7.16

OPEWDO:
	PUSHM.32 D0|D1|D2|D3|D4|D5|D6|A4

	LIB	?COLORPUSH		; sauve les couleurs

	MOVE.16	D2,{A6}+OSVOPM
	MOVE.16	D2,D1			; D1 <-- mode d'ouverture

	PUSHM.32 D3|D4
	LIB	?GETWDO			; D5 <-- no swdo actuelle
	POPM.32	D3|D4
	MOVE.16	D5,{A6}+OSVWDO

	MOVE.8	{A0}+ODFMOD,{A6}+OSVMOD
	MOVE.8	{A0}+ODFFLG,{A6}+OSVFLG
	LIB	?AFTIM
	.8	AFDIR			; met vido normale
	.8	PCURS			; met petit curseur "_"
	.8	NOCURS			; pas de curseur
	.8	TRUNC			; tronque les lignes trop longues
	.8	0
	.EVEN

	MOVE.32	D3,{A6}+OPOSEXT
	MOVE.32	D4,{A6}+ODIMEXT
	LIB	?CREWDO			; cre swdo "extrieure"
	JUMP,NE	EXIT$
	MOVE.16	D5,D6			; D6 <-- numro swdo
	LIB	?USEWDO
	JUMP,NE	CLOWDO$
	MOVE.32	D3,D0			; D0 <-- origine swdo

	TEST.32	D1:#BDBSAV		; sauve sous la swdo ?
	JUMP,BC	R8^NOSAV$		; non => NOSAV$

	CALL	mySAVWDO		; sauve le contenu actuel
	JUMP,NE	CLOWDO$

NOSAV$:
	MOVE.32	#COLOR_DBCLEAR,D3
	LIB	?COLORCR		; met la couleur du fond
	MOVE.32	#COLOR_DBCADRE,D3
	LIB	?COLORSR		; met la couleur du cadre

	MOVE.32	{A0}+ODFCCF,{A6}+OlCFOND; couleur de fond existe ?
	JUMP,EQ	R8^NoTRAD$		; non => pas de traduction d'image

	COMP.8	#4,{A0}+ODFCNP		; est-ce du 4-bit/pixel ?
	JUMP,EQ	R8^TRAD$		; oui => on sait traduire !
	COMP.8	#2,{A0}+ODFCNP		; moins que 16 couleurs ?
	JUMP,LS	R8^NoTRAD$		; oui => comme du noir & blanc

TRAD$:	CALL	paTRADIMAGE		; traduit l'image (si ncessaire)

	TEST.8	{A6}+OlL3DOK		; look 3D ok ?
	JUMP,F	R8^NoTRAD$		; non => ne touche pas au fond

	CLR.8	{A6}+ONOSTALGIE		; si 3D, pas nostalgique du tout !
	MOVE.32	{A6}+OlCFOND,{A0}+ODFCCF; prend le "gris" pour le fond

NoTRAD$:
	CLR.8	D5			; D5 <-- "bitmap" des cadres (ext..int)
	TEST.32	D1:#BDBNOC		; pas de cadre du tout ?
	JUMP,BS	R8^RECT$		; oui => RECT$
	MOVE.8	#2'00110000,D5		; D5 <-- "bitmap" des cadres (ext..int)
	TEST.32	D1:#BDBCAS		; un seul cadre ?
	JUMP,BS	R8^RECT$		; oui => RECT$
	MOVE.8	#2'00100110,D5		; D5 <-- "bitmap" des cadres (ext..int)
	TEST.8	{A6}+OLOOK		; new look ?
	JUMP,T	R8^RLOOK$		; oui => RLOOK$

RECT$:	MOVE.8	#EOP,D3
	LIB	?AFCAR			; efface tout

	CLR.32	D3			; D3 <-- Y;X origine
	DEC.16	D4			; D4 <-- dX-1 pour tre dedans
	SWAP.32	D4
	DEC.16	D4			; D4 <-- dY-1 pour tre dedans
	SWAP.32	D4
	MOVE.32	#SETDOT,D2		; D2 <-- mode
RLOOP$:
	SL.8	#1,D5			; C <-- cadre ou pas
	JUMP,CC	R8^RNEXT$
	LIB	?DRRECT			; dessine un rectangle
RNEXT$:
	INC.16	D3			; X <-- X+1
	SWAP.32	D3
	INC.16	D3			; Y <-- Y+1
	SWAP.32	D3
	SUB.16	#2,D4			; dX <-- dX-2
	SWAP.32	D4
	SUB.16	#2,D4			; dY <-- dY-2
	SWAP.32	D4
	COMP.16	#8,D3			; encore un ?
	JUMP,LO	RLOOP$			; oui => RLOOP$
	JUMP	R8^REND$

RLOOK$:
	TEST.8	{A6}+OlL3DOK		; look 3D ok ?
	JUMP,F	RECT$			; non => rectangle simple

	MOVE.16	#ICON_CAD_UL,D3
	CALL	DRAWCADRE		; dessine un joli cadre
	JUMP,NE	RECT$			; rectangle simple si ressources inacessibles !
	SUB.16	#2*8+1,D4
	SWAP.32	D4
	SUB.16	#2*8+1,D4
	SWAP.32	D4

REND$:	MOVE.32	#COLOR_DBSET,D3
	LIB	?COLORSR		; met la couleur pour dessiner

	MOVE.32	D0,D3			; D3 <-- origine swdo

	TEST.32	D1:#BDBTAB
	JUMP,BC	R8^NOTAB$

	CALL	DRAWTABS		; dessine les onglets

NOTAB$:	ADD.16	#8,D3
	SWAP.32	D3
	ADD.16	#8,D3
	SWAP.32	D3
	INC.16	D4			; D4 <-- dimensions intrieures
	SWAP.32	D4
	INC.16	D4
	SWAP.32	D4

	CLR.16	D5
	LIB	?USEWDO
	MOVE.16	D6,D5
	LIB	?KILWDO

	LIB	?CREWDO			; cre swdo incluse
	LIB	?USEWDO			; utilise swdo incluse
	MOVE.16	D5,{A6}+ONOWDO		; mm. numro swdo
	JUMP	R8^EXIT$

CLOWDO$:
	PUSH.16	D7
	CLR.16	D5
	LIB	?USEWDO			; utilise swdo principale
	MOVE.16	D6,D5
	LIB	?KILWDO			; dtruit swdo cre
	POP.16	D7

EXIT$:	TEST.16	D7			; ok ?
	JUMP,EQ	R8^QUIT$		; oui => QUIT$
					; erreur =>
	PUSH.16	D7
	LIB	?COLORPOP		; restitue les couleurs
	POP.16	D7
QUIT$:
	POPM.32	D0|D1|D2|D3|D4|D5|D6|A4
	TEST.16	D7			; retour EQ/NE
	RET


mySAVWDO:
	PUSHM.32 D3|D4|D5
	LIB	?GETWDO
	PUSHM.32 D3|D4
	TEST.32	D1:#BDBTAB
	JUMP,BC	R8^NOTAB$
	SWAP.32	D3
	SWAP.32	D4
	ADD.16	#24,D4
	SUB.16	#24,D3			; prend compte des onglets
	SWAP.32	D3
	SWAP.32	D4
NOTAB$:	LIB	?MODWDO
	LIB	?USEWDO
	MOVE.32	D3,{A6}+OPOSSAV
	MOVE.32	D4,{A6}+ODIMSAV
	MOVE.8	#SAVWDO,D3		; oui =>
	LIB	?AFCAR			; sauve le contenu actuel
	POPM.32	D3|D4
	PUSH.16	D7
	LIB	?MODWDO
	LIB	?USEWDO
	POP.16	D7
	POPM.32	D3|D4|D5
	RET

myGETWDO:
	PUSHM.32 D3|D4|D5
	LIB	?GETWDO
	PUSHM.32 D3|D4
	MOVE.32	{A6}+OPOSSAV,D3
	MOVE.32	{A6}+ODIMSAV,D4
	LIB	?MODWDO
	LIB	?USEWDO
	MOVE.8	#GETWDO,D3
	LIB	?AFCAR			; restitue contenu sous-fentre
	POPM.32	D3|D4
	PUSH.16	D7
	LIB	?MODWDO
	LIB	?USEWDO
	POP.16	D7
	POPM.32	D3|D4|D5
	RET


;-----------\\
;  DRAWTABS  >
;-----------/

; Dessine tous les onglets.

; in	D3.32	origine de la fentre
; out	-
; mod	D7.16

DRAWTABS:
	PUSHM.32 D0|D1|D2|D3|D4|D5|D6|A3|A4

	CLR.16	D5
	LIB	?USEWDO			; D5 <-- numro actuel de fentre
	LIB	?COLORPUSH

	CLR.16	{A6}+ONTABS		; aucun onglet (pour l'instant)
	MOVE.32	D3,{A6}+OOTABS		; origine
	MOVE.32	{A6}+OPTABS,A3		; A3 <-- ^touches/textes
	MOVE.32	#{A6}+OTABINF,A4	; A4 <-- ^table des onglets
	MOVE.32	D3,D4

	SWAP.32	D4
	SUB.16	#22,D4
	SWAP.32	D4
	ADD.16	#8,D4			; origine
	MOVE.32	#0,D3			; pas actif (par dfaut)
	MOVE.32	#0,D2			; numro de l'onglet  activer
	MOVE.32	#16'FFFFFFFE,D0		; masque

LOOP$:	TEST.16	{A3}			; y a-t-il une touche ?
	JUMP,EQ	R8^END$			; non => fin de table

	MOVE.16	{A3+},{A4}+OTIKEY
	MOVE.32	D4,{A4}+OTIPOS
	ADD.16	#4,{A4}+OTIPOS+2	; ajuste horizontalement
	ADD.16	#2,{A4}+OTIPOS+0	; ajuste verticalement

	COMP.8	{A6}+OACTTAB,D2
	SET.8,EQ D3

	CALL	DRAWONETAB

	MOVE.32	D4,{A4}+OTIDIM		; prend note de la fin
	SUB.16	#4,{A4}+OTIDIM+2	; ajuste horizontalement
	ADD.16	#22,{A4}+OTIDIM+0	; ajuste verticalement
	INC.16	{A6}+ONTABS		; un onglet de plus
	ADD.A16	#LGTABINF,A4

	INC.32	D2
	COMP.32	#MAXTAB,D2		; trop d'onglets ?
	JUMP,HS	R8^END$			; oui => arrte l

	MOVE.32	A3,D1
	ADD.32	#1,D1
	AND.32	D0,D1
	MOVE.32	D1,A3			; aligne  une adresse paire

	JUMP	LOOP$

END$:	LIB	?COLORPOP
	LIB	?USEWDO

	POPM.32	D0|D1|D2|D3|D4|D5|D6|A3|A4
	RET


	.INS	DBOXTABS.ASI

;----------\\
; DRAWCADRE >
;==========/

; Dessine un cadre autour de la sous-fentre actuelle, en utilisant
; les ressources.

; in	D3.16	premire ressource (+0..7)
;	D4.32	dimensions (dy;dx)
; out	D7.16	erreur
; mod	D7.16

DRAWCADRE:
	PUSHM.32 D0..D5

	PUSH.8	{A0}+ODFMGR		; stack <-- mode de clipping
	LIB	?AFTIM
	.8	MODGRA,GRACLIP2
	.8	0
	.EVEN

	MOVE.16	D3,D0			; D0 <-- ressource
	MOVE.32	D4,D1			; D1 <-- dimensions
	MOVE.32	#LOADDOT,D2

	PUSHM.32 D3|D4
	MOVE.32	#-1,D3
	MOVE.32	#-1,D4
	LIB	?DRMDEF
	MOVE.32	#COLOR_DBCLEAR,D3
	LIB	?COLORSR
	MOVE.32	#16'00080008,D3
	MOVE.32	D1,D4
	SWAP.32	D4
	SUB.16	#16,D4
	SWAP.32	D4
	SUB.16	#16,D4
	LIB	?DRTRAME
	POPM.32	D3|D4

	MOVE.16	D0,D3
	ADD.16	#1,D3			; D3 <-- ICON_CAD_U
	CLR.32	D4
	MOVE.16	#8,D4
	MOVE.16	D1,D5
	SUB.16	#8+8,D5
	CALL	DRAWHLINE		; dessine la ligne suprieure
	JUMP,NE	END$

	MOVE.16	D0,D3
	ADD.16	#3,D3			; D3 <-- ICON_CAD_R
	MOVE.16	#8,D4
	SWAP.32	D4
	MOVE.16	D1,D4
	SUB.16	#8,D4
	MOVE.32	D1,D5
	SWAP.32	D5
	SUB.16	#8+8,D5
	CALL	DRAWVLINE		; dessine la ligne droite
	JUMP,NE	END$

	MOVE.16	D0,D3
	ADD.16	#5,D3			; D3 <-- ICON_CAD_D
	MOVE.32	D1,D4
	SWAP.32	D4
	SUB.16	#8,D4
	SWAP.32	D4
	MOVE.16	#8,D4
	MOVE.16	D1,D5
	SUB.16	#8+8,D5
	CALL	DRAWHLINE		; dessine la ligne infrieure
	JUMP,NE	END$

	MOVE.16	D0,D3
	ADD.16	#7,D3			; D3 <-- ICON_CAD_L
	MOVE.16	#8,D4
	SWAP.32	D4
	CLR.16	D4
	MOVE.32	D1,D5
	SWAP.32	D5
	SUB.16	#8+8,D5
	CALL	DRAWVLINE		; dessine la ligne gauche
	JUMP,NE	END$

	MOVE.32	#CLRDOT,D2
	MOVE.16	D0,D3
	ADD.16	#8,D3			; D3 <-- ICON_CAM_UL
	CLR.32	D4
	CALL	DRAWICON		; efface le coin sup/gauche
	MOVE.32	#SETDOT,D2
	MOVE.16	D0,D3
;	ADD.16	#0,D3			; D3 <-- ICON_CAD_UL
	CALL	DRAWICON		; dessine le coin sup/gauche

	MOVE.32	#CLRDOT,D2
	MOVE.16	D0,D3
	ADD.16	#9,D3			; D3 <-- ICON_CAM_UR
	CLR.32	D4
	MOVE.16	D1,D4
	SUB.16	#8,D4
	CALL	DRAWICON		; efface le coin sup/droite
	MOVE.32	#SETDOT,D2
	MOVE.16	D0,D3
	ADD.16	#2,D3			; D3 <-- ICON_CAD_UR
	CALL	DRAWICON		; dessine le coin sup/droite

	MOVE.32	#CLRDOT,D2
	MOVE.16	D0,D3
	ADD.16	#10,D3			; D3 <-- ICON_CAM_DR
	MOVE.32	D1,D4
	SUB.16	#8,D4
	SWAP.32	D4
	SUB.16	#8,D4
	SWAP.32	D4
	CALL	DRAWICON		; efface le coin inf/droite
	MOVE.32	#SETDOT,D2
	MOVE.16	D0,D3
	ADD.16	#4,D3			; D3 <-- ICON_CAD_DR
	CALL	DRAWICON		; dessine le coin inf/droite

	MOVE.32	#CLRDOT,D2
	MOVE.16	D0,D3
	ADD.16	#11,D3			; D3 <-- ICON_CAM_DL
	MOVE.32	D1,D4
	CLR.16	D4
	SWAP.32	D4
	SUB.16	#8,D4
	SWAP.32	D4
	CALL	DRAWICON		; efface le coin inf/gauche
	MOVE.32	#SETDOT,D2
	MOVE.16	D0,D3
	ADD.16	#6,D3			; D3 <-- ICON_CAD_DL
	CALL	DRAWICON		; dessine le coin inf/gauche

	CLR.32	D3
	CLR.32	D4
	LIB	?DRMDEF
	MOVE.32	#CLRDOT,D2
	MOVE.32	#16'10000*8+8,D3
	MOVE.32	D1,D4
	SUB.16	#8+8,D4
	SWAP.32	D4
	SUB.16	#8+8,D4
	SWAP.32	D4
	LIB	?DRTRAME		; efface l'intrieur

	CLR.16	D7			; D7 <-- ok
END$:
	MOVE.16	D7,D0
	MOVE.8	#MODGRA,D3
	LIB	?AFCAR
	POP.8	D3
	LIB	?AFCAR			; remet le mode de clipping initial
	MOVE.16	D0,D7

	POPM.32	D0..D5
	TEST.16	D7			; retour EQ/NE
	RET


; in	-
; out	T => GRA2_TRAME couleur support

HasNewGRA2_TRAME:
	PUSHM.32 D3|D4|D7
	MOVE.32	#0,D4
	MOVE.16	#GRA2_FIRST,D3
	LIB_	GETREV			; D4 <-- rvision de GRA2 (ou 0)
	COMP.16	#16'0806,D4		; au moins celle de juillet 96 ?
	SET.8,GE D3			; si oui => met le flag
	TEST.8	D3			; peut-on utilise GRA2_TRAME ?
	POPM.32	D3|D4|D7
	RET



;----------\\
; DRAWHLINE >
;----------/

; Dessine une ligne horizontale avec une ressource.

; in	D2.16	mode de dessin
;	D3.16	ressource
;	D4.32	position dbut (y;x)
;	D5.16	longueur
; out	-
; mod	D7.16

DRAWHLINE:
	PUSHM.32 D0|D1|D4|D5|A4

	MOVE.32	#RtypRASTER,D0
	CLR.32	D1
	MOVE.16	D3,D1
	CALL	RESGETDBOX		; A4 <-- ^dx,dy,matrice
	JUMP,NE	R8^EXIT$

	TEST.16	D5			; longueur nulle ?
	JUMP,LE	R8^EXIT$		; oui => EXIT$

	CALL	HasNewGRA2_TRAME
	JUMP,F	R8^LOOP$		; non => boucle simple

	SWAP.32	D5
	CLR.16	D5
	MOVE.8	{A4}+1,D5
	SWAP.32	D5			; D5 <-- [dy;dx]

	CALL	paDRAWTRAME
	JUMP,EQ	R8^EXIT$

LOOP$:	COMP.16	#32,D5
	JUMP,HS	R8^DRAW$
	ADD.16	D5,D4
	SUB.16	#32,D4

DRAW$:	CALL	xDRAWICONP		; dessine rapidement l'icne

	ADD.16	#32,D4
	SUB.16	#32,D5
	JUMP,GT	LOOP$

	CLR.16	D7			; D7 <-- ok

EXIT$:	POPM.32	D0|D1|D4|D5|A4
	TEST.16	D7			; retour EQ/NE
	RET

;----------\\
; DRAWVLINE >
;----------/

; Dessine une ligne verticale avec une ressource.

; in	D2.16	mode de dessin
;	D3.16	ressource
;	D4.32	position dbut (y;x)
;	D5.16	hauteur
; out	-
; mod	D7.16

DRAWVLINE:
	PUSHM.32 D0|D1|D4|D5|A4

	MOVE.32	#RtypRASTER,D0
	CLR.32	D1
	MOVE.16	D3,D1
	CALL	RESGETDBOX		; A4 <-- ^dx,dy,matrice
	JUMP,NE	R8^EXIT$

	TEST.16	D5			; hauteur nulle ?
	JUMP,LE	R8^EXIT$		; oui => EXIT$

	CALL	HasNewGRA2_TRAME
	JUMP,F	R8^LOOP$		; non => boucle simple

	SWAP.32	D5
	MOVE.16	#8,D5

	CALL	paDRAWTRAME
	JUMP,EQ	R8^EXIT$

	SWAP.32	D5

LOOP$:	COMP.16	#32,D5
	JUMP,HS	R8^DRAW$
	SWAP.32	D4
	ADD.16	D5,D4
	SUB.16	#32,D4
	SWAP.32	D4

DRAW$:	CALL	xDRAWICONP		; dessine rapidement l'icne

	SWAP.32	D4
	ADD.16	#32,D4
	SWAP.32	D4
	SUB.16	#32,D5
	JUMP,GT	LOOP$

	CLR.16	D7			; D7 <-- ok

EXIT$:	POPM.32	D0|D1|D4|D5|A4
	TEST.16	D7			; retour EQ/NE
	RET



;-------\\
; CLOWDO >
;=======/

; Ferme une sous-fentre et restitue son contenu.

; in	-
; out	D7.W	erreur
; mod	D7.W

CLOWDO:
	PUSHM.32 D3|D4|D5

	LIB	?COLORPOP		; restitue les couleurs

	MOVE.16	{A6}+OSVOPM,D3		; D3 <-- mode d'ouverture
	TEST.32	D3:#BDBSAV		; sauve sous la swdo ?
	JUMP,BC	R8^NOSAV$		; non => NOSAV$
					; oui =>
	CALL	myGETWDO

	MOVE.16	{A6}+OSVWDO,D5
	LIB	?USEWDO			; utilise swdo initiale
	MOVE.16	{A6}+ONOWDO,D5
	LIB	?KILWDO			; dtruit swdo menu
	JUMP	R8^RESTORE$

NOSAV$:
	MOVE.16	{A6}+OSVWDO,D5
	LIB	?USEWDO			; utilise swdo initiale
	MOVE.16	{A6}+ONOWDO,D5
	LIB	?KILWDO			; dtruit swdo menu

	MOVE.32	{A6}+OPOSEXT,D3
	MOVE.32	{A6}+ODIMEXT,D4
	LIB	?CREWDO			; re-cre swdo extrieure
	LIB	?USEWDO
	MOVE.8	#EOP,D3
	LIB	?AFCAR			; efface la sous-fentre
	PUSH.16	D5
	MOVE.16	{A6}+OSVWDO,D5
	LIB	?USEWDO			; utilise swdo initiale
	POP.16	D5
	LIB	?KILWDO			; dtruit swdo extrieure
RESTORE$:
	MOVE.8	#AFDIR,D3
	TEST.8	{A6}+OSVFLG:#BFVIDI
	JUMP,BC	R8^VIDEO$
	MOVE.8	#AFINV,D3
VIDEO$:
	LIB	?AFCAR			; remet vido normale/inverse

	MOVE.8	#GCURS,D3
	TEST.8	{A6}+OSVMOD:#BFPCUR
	JUMP,BC	R8^PCURS$
	MOVE.8	#PCURS,D3
PCURS$:
	LIB	?AFCAR			; remet gros/petit curseur

	MOVE.8	#CURS,D3
	TEST.8	{A6}+OSVMOD:#BFNOCU
	JUMP,BC	R8^CURS$
	MOVE.8	#NOCURS,D3
CURS$:
	LIB	?AFCAR			; remet/enlve le curseur

	POPM.32	D3|D4|D5
	TEST.16	D7			; retour EQ/NE
	RET


;--------\\
; RSTWDO  >
;========/

; Lit le status de la swdo actuelle.

; in	-
; out	D7.16	erreur
; mod	D7.16

RSTWDO:
	PUSHM.32 A4|A5

	LIB	?GETPDIS		; A4 <-- ^description de la fentre
	JUMP,NE	R8^EXIT$
	MOVE.32	A4,{A6}+OPDDIS

	MOVE.16	{A4}+ODFCX,{A6}+OCX
	MOVE.16	{A4}+ODFCY,{A6}+OCY
	MOVE.16	{A4}+ODFC1Y,{A6}+OC1Y
	MOVE.16	{A4}+ODFC2Y,{A6}+OC2Y

	MOVE.32	A6,A5
	CALL	GETCOMMEM		; A6 <-- ^variables globales
	EX.32	A6,A5
	JUMP,NE	R8^EXIT$

	COMP.8	#2,{A5}+OGLOOK		; nouveau look si 3D, mais nostalgique ?
	JUMP,EQ	R8^NOST$
	COMP.8	#3,{A5}+OGLOOK		; look 3D, sauf si monochrome ?
	JUMP,NE	R8^NONO$		; non => suite

	TEST.8	{A4}+ODFCMD		; couleur ?
	JUMP,T	R8^LOOK$		; oui => super joli
	JUMP	R8^EXIT$		; non => trs, trs, trs vieux (mais joli)

NONO$:	COMP.8	#1,{A5}+OGLOOK		; nouveau look "Daniel" ou "3D" ?
	JUMP,NE	R8^EXIT$		; non => ancien look...

	JUMP	R8^LOOK$

NOST$:	SET.8	{A6}+ONOSTALGIE		; ancien "BOX/LINE"
LOOK$:	SET.8	{A6}+OLOOK		; new look !

	COMP.16	#8,{A6}+OCX
	JUMP,LO	R8^EXIT$
	COMP.16	#10,{A6}+OC1Y
	JUMP,LO	R8^EXIT$
	COMP.16	#3,{A6}+OC2Y
	JUMP,LO	R8^EXIT$

	SET.8	{A6}+OBIG		; new look !

EXIT$:	POPM.32	A4|A5
	TEST.16	D7			; retour EQ/NE
	RET



;--------\\
; OPEVAR  >
;========/

; Demande de la mmoire pour les variables.

; in	-
; out	A6.32	^zone mmoire
;	D7.16	erreur
; mod	D7.16, A6.32

OPEVAR:
	PUSHM.32 D1|D4|A4

	CALL	GETCOMMEM		; A6 <-- ^variables globales

	MOVE.32	#LGVAR,D4		; D4 <-- longueur
	ADD.32	{A6}+OgIMHEAD+OIMNBB,D4	; D4 <-- longueur avec buffer image
	MOVE.32	#MTYPCP,D1		; D1 <-- type compte mmoire
	GESMEM	?GETMEM			; demande mmoire
	JUMP,NE	R8^ERROR$

	GESMEM	?CLEARMEM		; met toutes les variables  zro
	MOVE.32	A6,{A4}+OlPGLO		;    <-- ^variables globales
	MOVE.32	A4,A6			; A6 <-- ^zone
	MOVE.32	#{A4}+LGVAR,A4
	MOVE.32	A4,{A6}+OlPIMA		;    <-- ^buffer pour image traduite
	JUMP	R8^EXIT$

ERROR$:	SUB.32	A6,A6			; A6 <-- ^nil (!)

EXIT$:	POPM.32	D1|D4|A4
	TEST.16	D7			; retour EQ/NE
	RET

;--------\\
; CLOVAR  >
;========/

; Rend la mmoire pour les variables.

; in	A6.32	^zone mmoire
; out	-
; mod	-

CLOVAR:
	PUSHM.32 D1|D7|A4

	MOVE.32	A6,A4			; A4 <-- ^zone
	MOVE.32	#MTYPCP,D1		; D1 <-- type compte mmoire
	GESMEM	?GIVMEM			; rend la mmoire

	POPM.32	D1|D7|A4
	RET





;---------\\
; DRAWICON >
;=========/

; Dessine une icne provenant d'une ressource systme DBOX.

; in	D2.8	mode de dessin
;	D3.16	ressource de l'icne
;	D4.32	coin sup/gauche (y;x)
;	A6.32	^variables locales de la DBOX
; out	D7.16	erreur
; mod	D7.16

DRAWICON:
	PUSHM.32 D0..D3|A4

	CALL	paDRAWICON		; tente de dessiner jolie icone
	JUMP,EQ	R8^EXIT$

	MOVE.32	#RSKEYDBOXLIB,D0
	MOVE.16	D3,D1
	AND.16	#16'7F00,D1
	COMP.16	#16'1100,D1
	JUMP,NE	R8^OK$

	SUB.16	#16'1100,D3		; cas particulier: icnes rduites des units
	MOVE.32	#RSKEYICON,D0

OK$:	TCLR.32	D1:#15			; inverse ?
	JUMP,F	R8^DO$			; non => ok

	OR.8	#CPLDOT,D2		; inverse...

DO$:	CLR.32	D1
	MOVE.16	D3,D1			; D1 <-- numro de la ressource
	MOVE.32	D0,D3			; D3 <-- clef  utiliser
	MOVE.32	#RtypRASTER,D0		; D0 <-- type de la ressource
	CALL	RESGETKEY		; A4 <-- ^dx,dy,matrice
	JUMP,NE	R8^EXIT$

DRAW$:	CALL	R8^DRAWICONP
	CLR.16	D7			; D7 <-- ok

EXIT$:	POPM.32	D0..D3|A4
	TEST.16	D7			; retour EQ/NE
	RET


; in	D1.16	numro de la ressource
;	+ comme DRAWICONP

xDRAWICONP:
	PUSH.32	D3
	MOVE.16	D1,D3
	CALL	paDRAWICON		; tente de dessiner jolie icone
	POP.32	D3
	TEST.16	D7
	JUMP,NE	R8^DRAWICONP
	RET


;----------\\
; DRAWICONP >
;==========/

; Dessine une icne provenant d'une ressource systme DBOX.

; in	D2.8	mode de dessin
;	D4.32	coin sup/gauche (y;x)
;	A4.32	^ressource (dx,dy,matrice)
; out	-
; mod	D7.16

DRAWICONP:
	PUSHM.32 D2..D4|A3

	SUB.A16	#12,SP			; rserve 12 bytes sur le stack (PUSH)
	MOVE.32	#{SP}+1,A3		; A3 <-- ^buffer sur le stack

	MOVE.8	#DRAWMATRIX,{A3}+0

	SWAP.32	D4
	MOVE.32	D4,{A3}+1		; <xx> et <yy>
	MOVE.32	A4,{A3}+5		; <pppp>

	OR.8	#NTSDOT.OR.PENDOT,D2
	MOVE.8	D2,{A3}+9		; <m>

	MOVE.32	#10,D3
	LIB	?STRING

	ADD.A16	#12,SP			; reprend le buffer sur le stack (POP)

	POPM.32	D2..D4|A3
	RET


;-----------\\
; RESGETICON >
;===========/

; Cherche une ressource systme ICON.

; in	D0.32	type (Rtyp*)
;	D1.32	numro de la ressource
; out	A4.32	^ressource
;	D7.16	erreur
; mod	D7.16, A4.32

RESGETICON:
	PUSHM.32 D2..D4|A2

	CALL	RESCHICON		; A2 <-- canal ressources
	JUMP,NE	R8^EXIT$

	MOVE.32	#2**BRSGETPOINTER.OR.2**BRSGETnoHAND.OR.2**BRSGETSUBRES,D2
	MOVE.32	#RSKEYICON,D3
	RES_	GET			; A4 <-- ^ressource
EXIT$:
	POPM.32	D2..D4|A2
	TEST.16	D7			; retour EQ/NE
	RET

;----------\\
; RESCHICON >
;==========/

; Cherche le canal d'une ressource systme ICON.

; in	-
; out	A2.32	canal ressource
;	D7.16	erreur
; mod	D7.16, A2.32

RESCHICON:
	PUSHM.32 D2..D4|A6

	CALL	GETCOMMEM		; A6 <-- ^variables globales
	JUMP,NE	R8^EXIT$

	TEST.32	{A6}+OGCRIC		; ressources dj ouvertes ?
	JUMP,NE	R8^GET$			; oui => GET$

	MOVE.32	#2**BRSOPSYSTEM,D2
	MOVE.32	#RSKEYICON,D3
	MOVE.32	#16'10000*SYSREV+SYSVERS,D4
	RES_	OPEN			; ouvre les ressources systme 9.0
	JUMP,EQ	R8^MEM$

;	MOVE.32	#2**BRSOPSYSTEM,D2
;	MOVE.32	#RSKEYICON,D3
	MOVE.32	#16'10000*(SYSREV-1)+SYSVERS,D4
	RES_	OPEN			; ouvre les ressources systme 8.0
	JUMP,NE	R8^EXIT$

MEM$:	MOVE.32	A2,{A6}+OGCRIC

GET$:	MOVE.32	{A6}+OGCRIC,A2		; A2 <-- canal ressources

EXIT$:	POPM.32	D2..D4|A6
	TEST.16	D7			; retour EQ/NE
	RET


;-----------\\
; RESGETDBOX >
;===========/

; Cherche une ressource systme DBOX.

; in	D0.32	type (Rtyp*)
;	D1.32	numro de la ressource
; out	A4.32	^ressource
;	D7.16	erreur
; mod	D7.16, A4.32

RESGETDBOX:
	PUSHM.32 D2..D4|A2

	CALL	RESCHDBOX		; A2 <-- canal ressources
	JUMP,NE	R8^EXIT$

	MOVE.32	#2**BRSGETPOINTER.OR.2**BRSGETnoHAND.OR.2**BRSGETSUBRES,D2
	MOVE.32	#RSKEYDBOXLIB,D3
	RES_	GET			; A4 <-- ^ressource

EXIT$:	POPM.32	D2..D4|A2
	TEST.16	D7			; retour EQ/NE
	RET


;----------\\
; RESGETKEY >
;==========/

; Cherche une ressource systme avec une clef.

; in	D0.32	type (Rtyp*)
;	D1.32	numro de la ressource
;	D3.32	clef
; out	A4.32	^ressource
;	D7.16	erreur
; mod	D7.16, A4.32

RESGETKEY:
	PUSHM.32 D2..D4|A2

	CALL	RESCHDBOX		; A2 <-- canal ressources
	JUMP,NE	R8^EXIT$

	MOVE.32	#2**BRSGETPOINTER.OR.2**BRSGETnoHAND.OR.2**BRSGETSUBRES,D2
	RES_	GET			; A4 <-- ^ressource

EXIT$:	POPM.32	D2..D4|A2
	TEST.16	D7			; retour EQ/NE
	RET

;----------\\
; RESCHDBOX >
;==========/

; Cherche le canal d'une ressource systme DBOX.

; in	-
; out	A2.L	canal ressource
;	D7.16	erreur
; mod	D7.W, A2.L

RESCHDBOX:
	PUSHM.32 D2..D4|A6

	CALL	GETCOMMEM		; A6 <-- ^variables globales
	JUMP,NE	R8^EXIT$

	TEST.32	{A6}+OGCRDB		; ressources dj ouvertes ?
	JUMP,NE	R8^GET$			; oui => GET$

	MOVE.32	#2**BRSOPSYSTEM,D2
	MOVE.32	#RSKEYDBOXLIB,D3
	MOVE.32	#16'10000*SYSREV+SYSVERS,D4
	RES_	OPEN		; ouvre les ressources systme 9.0	;%error
	JUMP,EQ	R8^MEM$

	MOVE.32	#2**BRSOPSYSTEM,D2
	MOVE.32	#RSKEYDBOXLIB,D3
	MOVE.32	#16'10000*(SYSREV-1)+SYSVERS,D4
	RES_	OPEN		; ouvre les ressources systme 8.0	;%error
	JUMP,NE	R8^EXIT$
MEM$:
	MOVE.32	A2,{A6}+OGCRDB
GET$:
	MOVE.32	{A6}+OGCRDB,A2		; A2 <-- canal ressources
EXIT$:
	POPM.32	D2..D4|A6
	TEST.16	D7			; retour EQ/NE
	RET



;----------\\
; GETCOMMEM >
;==========/

; Donne les variables globales au module dbox.

; in	-
; out	A6.32	^variables globales
;	D7.16	erreur
; mod	D7.16, A6.32

GETCOMMEM:
	PUSHM.32 D4|A4

	MOVE.32	#R16^DEBUT,A4
	MOVE.32	#LPH+MAXPATH,D4
	FOS	?GETCOMMEM		; A4 <-- ^variables globales
	MOVE.32	A4,A6

	TEST.32	{A6}+OgPMCPT		; compte DBOX existe-t-il ?
	JUMP,F	R8^INIT$		; non => initialise

	TEST.32	{A6}+OgIMPPIX		; image dj en mmoire ?
	JUMP,T	R8^END$			; oui => ok...
	CALL	paINITgCOLOR		; non => charge si ncessaire
	JUMP	R8^END$

INIT$:	PUSHM.32 D3|D4|A4
	FOS	?OPINFO

	MOVE.32	{A4}+OINFIL,D4		; dfinitions pour PREND/SAUVE

	TEST.32	D4:#BINFFHELPP
	SET.8,F	{A6}+OPHHLPP
	TEST.32	D4:#BINFFHELPS
	SET.8,F	{A6}+OPHHLPS

	MOVE.32	{A4}+OINSTA,D4
	MOVE.32	#0,D3
	TEST.32	D4:#binfLOOKOLD		; look ancien ?
	JUMP,BS	R8^LOOK$
	MOVE.32	#2,D3
	TEST.32	D4:#binfLOOKNOS		; look nostalgique ?
	JUMP,BS	R8^LOOK$
	MOVE.32	#3,D3
	TEST.32	D4:#binfLOOKOM		; look OM ?
	JUMP,BS	R8^LOOK$
	MOVE.32	#1,D3
LOOK$:	MOVE.8	D3,{A6}+OGLOOK

	TEST.32	D4:#BinfLOOKHILITE	; met en vidence plutt que d'enfoncer
	SET.8,T	{A6}+OGLOOKY

	CLR.16	D4
	FOS	?CLINFO
	POPM.32	D3|D4|A4

	PUSHM.32 D1|A2|A3

	MOVE.32	#MTYPSYS,D1		; D1 <-- type pre est systme
	MOVE.32	#R16^NMCPT$,A3		; A3 <-- ^nom du compte mmoire global
	GESMEM	?CREMCPT		; A2 <-- nouveau compte mmoire
	JUMP,NE	R8^FAT$

	MOVE.32	A2,{A6}+OgPMCPT
	CALL	paINITgCOLOR		; charge le .COLOR de DBOX !
	JUMP,EQ	R8^FAT$			; succs => c'est fini
	CLR.8	{A6}+OGLOOK		; erreur => force l'ancien look...
	CLR.16	D7

FAT$:	POPM.32	D1|A2|A3

END$:	POPM.32	D4|A4
	TEST.16	D7			; retour EQ/NE
	RET

NMCPT$:	.ASCIZ	"MemDBOX"
	.EVEN




; Routines pour les touches actives par DBOX_CALLC
; -------------------------------------------------

; ATTENTION:	L'offset ne doit pas dpasser 2^15 ( l'intrieur
;		du code de SMA_DBOX.LIB), sinon l'appel	DBOX_CALLC
;		considre qu'il s'agit d'une adresse ngative !
;		L'assembleur ne gnre pas d'erreur ...

DOKF0:
	MOVE.16	#F0,D3
	RET

DOKF1:
	MOVE.16	#F1,D3
	RET

DOKF4:
	MOVE.16	#F4,D3
	RET

DOKF7:
	MOVE.16	#F7,D3
	RET

DOKF9:
	MOVE.16	#F9,D3
	RET

DOKF10:
	MOVE.16	#F10,D3
	RET

DOKF11:
	MOVE.16	#F11,D3
	RET

DOKF12:
	MOVE.16	#F12,D3
	RET

DOKDEF:
	MOVE.16	#DEFINE,D3
	RET

DOKMGR:
	MOVE.16	#KEYMGR,D3
	RET

DOKMGP:
	MOVE.16	#KEYMGP,D3
	RET





; Mme remarque que pour les routines DOK* juste en-dessus !

__DBOX_ICOCADRE:JUMP	_DBOX_ICOCADRE
__DBOX_ICOAFF:JUMP	_DBOX_ICOAFF
__DBOX_ICODET:JUMP	_DBOX_ICODET
__DBOX_ICOINV:JUMP	_DBOX_ICOINV
__DBOX_ICOPOS:JUMP	_DBOX_ICOPOS
_paDRAWICON:JUMP	paDRAWICON


	.INS	DBOXEXTEND.ASI
	.INS	DBOXIO.ASI
	.INS	DBOXIOEDIT.ASI
	.INS	DBOXIOPATH.ASI
	.INS	DBOXIOnTREE.ASI
	.INS	DBOXIOSRC.ASI
	.INS	DBOXICO.ASI
	.INS	DBOXCOLOR.ASI


END_DBOX:


	.END

