	.TITLE	DGENC.ASL

	.PROC	M68000
	.BASE	10'10		; base 10 par dfaut
	.LAYOUT HEX		; listing en hexadcimal

	.REF	SMAKY
	.REF	MODULES
	.REF	COLORS


REVMAJ	= 3
REVMIN	= 3

; Date		Rev	Amliorations
; ---------------------------------------------------------------------------------
; 05.07.95  PA	3.3	Petite correction pour les fontes avec en-tte court.
; 13.06.95  PA	3.2	Agrandi buffer des noms de fichiers (200 au lieu de 50).
; 07.03.95  PA	3.1	Petite adaptation pour la couleur.
; 21.02.95  PA	3.0	Supporte gnrateurs depuis "#:(GENC:,)".
;			Traduction en CALM.
;			N'affiche plus du "chenit" quand un gnrateur n'est pas
;			lisible.
; 23.09.92	2.29	DGENC_MODIF: (AUTRES) gris si .UNDEFINE "DEF_GENC"
; 04.03.92	2.28	DGENC_MODIF: (REFAIT) -> (AUTRES) excute DEF_GENC.CODE
; 22.01.92	2.27	DGENC_LIST: accepte "DAP" si pas d'imprimante !
;			DGENC_MODIF: listes 1, 2 et 3 selon DEF_GENC.CODE
; 04.05.90	2.26	DGENC_MODIF: propose des noms de fonctions par dfaut
; 30.03.90	2.25	DGENC_MODIF: propose un nom de fonction si oubli
;			DGENC_MODIF: affichage "Abc" ok mais si FCA=32 et LCA=63 !
; 11.07.89	2.24	DGENC_MODIF: affiche les car. construits selon la taille
; 04.07.89	2.23	DGENC_MODIF: (ANNULE) et (REFAIT) permuts
; 29.06.89	2.22	DGENC_MODIF: (SAUVE) cre un fichier avec #:*.GENC
; 23.06.89	2.21	DGENC_MODIF: (SAUVE) cre un fichier "nom!DGENC"
;			DGENC_MODIF: affiche aussi les gencars "soft"
;			DGENC_LIST: ne liste plus que les gencars SMA_
; 15.06.89	2.20	DGENC_MODIF: utilise XCAR_SHOW pour "Abc"
; 14.06.89	2.19	DGENC_MODIF: ne met plus ".." si taille nulle
; 06.06.89	2.18	DGENC_MODIF: fait LIB,?FLUSHNGC si (REFAIT)
; 18.04.89	2.17	ok selon SMA_GENC.INFO
;			choix de la taille pour les gencars "analytiques"
; 28.11.88	2.16	DGENC_MODIF: n'affiche plus le gencar en clair !
; 19.10.88	2.15	DGENC_MODIF: n'affiche plus 2x le mme gencar
; 17.10.88	2.14	DGENC_MODIF: ne tient plus compte des assignations
; 05.07.88	2.13	PREND/SAUVE fichiers .DGENC
;			DGENC_MODIF: nouvelle case REFAIT
; 25.05.88	2.12	utilise les scroll-liste
; 03.12.87	2.11	utilise LIB,?TEXTGC pour le noms de gencars
; 25.11.87	2.10	POP32 = "Polka"
; 21.10.87	2.9	utilise DBOX_GETCO avec BDBGCGREY/FULL
; 30.07.87	2.8	message d'erreurs adapts  DBOX_TERROR
; 26.06.87	2.7	DGENC_MODIF: liste toutes les options (FOS)
;			DGENC_MODIF: pages dans l'ascenseur
;			DGENC_MODIF: si fonte D/Q => interdit ombr, etc.
;			DGENC_MODIF: option "affiche" dclenche par dfaut
;			DGENC_MODIF: affiche les fontes "Palatino", etc.
;			DGENC_MODIF: gras, italique, etc. en plein/gris
;			OGCVAR false si DRF ou QRF (true si DRP ou QRP)
; 26.02.87	2.6	(SUPPRIME) en gris si invalide
; 26.01.87	2.5	Abc: ouvre le fichier (SMA,100)_NRF09.GENC
;			Abc: affichage ok mme si trs grand
;		2.4	affiche mme si pas style roman
;			affiche "Univers   URP16"
;		2.3	jamais 2x le mme gencar dans la liste
;			affiche toujours les gencars LQ_, OKI_, etc.
; 		2.2	case "Laser" force les noms sans ( )
;			affiche aussi les fichiers SMA_*.GENC
;			n'affiche plus les fichiers sans attribut "L"
;			ok avec caractres ayant une rf gauche non nulle




	.REV	REVMAJ,REVMIN
	.IDENT	"(C)  Daniel ROUX et EPSITEC SA"




; Constantes
; ----------

KEYDBOX	=	16'7E00		; "touche" spciale


; Dfinition de l'entte d'un gnrateur de caractres
; ----------------------------------------------------

OGCDATA	=	16'180		; dbut data matrices

.IF FALSE

; Dfinitions des INFO
; --------------------

	.LOC	OINSLP+7
OINSTI:	.BLK.8	4		; mode d'affichage de START
OINCHK:	.BLK.8	2		; check (doit valoir VALINCHK)
OINFIL:	.BLK.8	4		; mode pour les fichiers (prend/sauve)
OINST1:	.BLK.8	4		; rserve pour START
OINST2:	.BLK.8	4		; rserve pour START
OINST3:	.BLK.8	4		; rserve pour START
OINST4:	.BLK.8	4		; rserve pour START

.ENDIF


; Fanions pour OINFIL
; -------------------

BINFFGENC=	24		; fichiers: undefine DEF_GENC



; Variables
; ---------

LBUFILE	= 200

	.LOC	0
OMDMOD:	.BLK.8	2		; mode d'ouverture
OMDPOS:	.BLK.8	4		; position centre si BDBPOS dans mode

OMDPDD:	.BLK.8	4		; ^descripteur de la fentre
OMDDIS:	.BLK.8	30		; buffer pour write-display

OMDPLN:	.BLK.8	4		; ^nom de l'imprimante
OMDPLF:	.BLK.8	4		; ^flag (-1 si vide, autre si plein)
OMDPLV:	.BLK.8	4		; ^qq variables permamantes
OMDPLI:	.BLK.8	4		; ^liste des gencars
OMDPLX:	.BLK.8	4		; ^liste des gencars extraits
OMDLLI:	.BLK.8	2		; lg liste des gencars
OMDNBP:	.BLK.8	2		; nb de gencars privs

OMDPGC:	.BLK.8	4		; ^buffer des gencars
OMDNOK:	.BLK.8	4		; gencar  ne jamais dtruire
OMDPGM:	.BLK.8	4		; ^gencar  modifier
OMDGEN:	.BLK.8	4		; -fst choisit
OMDNGC:	.BLK.8	LGTGC		; nom du gencar
OMDNTA:	.BLK.8	6		; nom de la taille

OMDPOZ:	.BLK.8	4		; coin sup/gauche zone
OMDDIZ:	.BLK.8	4		; dimensions zone

OMDASL:	.BLK.8	LSLVAR		; variables de la scroll-liste

OMDLGR:	.BLK.8	2		; rang du dernier gencar rduit
OMDLGT:	.BLK.8	2		; taille du dernier gencar rduit
OMDPGR:	.BLK.8	4		; ^gencar rduit

OMDFIL:	.BLK.8	LBUFILE		; nom du fichier .DGENC
LGMD:


; Variables dans la liste
; -----------------------

LGMN	=	10		; lg pour nom de l'imprimante

	.LOC	0
OMVPFI:	.BLK.8	4		; ^contenu du fichier .DGENC
OMVNOG:	.BLK.8	1		; rang du gencar  mettre  jour
OMVFAN:	.BLK.8	1		; fanions
LGMV:				; lg pour qq variables permanantes





; En-tte du module LIB
; ---------------------

	.LOC	0
	DGENC_	FIRST		; code du premier appel
	DGENC_	LAST		; code du dernier appel
	.8	0		; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	REVMAJ,REVMIN	; rvision.version
	.32	END_DGENC	; longueur
	.32	PATHLIB		; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"DGENC"		; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_DGENC_MODIF
	.16	_DGENC_LIST
	.16	_DGENC_NIL
	.16	_DGENC_DISGC
	.16	_DGENC_ENAGC
	.16	_DGENC_SEARCH
	.16	_DGENC_FREE
	.16	_DGENC_NEW
	.16	_DGENC_KILL
	.16	_DGENC_PUT
	.16	_DGENC_GET
	.16	_DGENC_MENU



_DGENC_NIL:
	CLR.16	D7		; retour EQ
	RET



	.INS	DGENCMOD.ASI
	.INS	DGENCIO.ASI
	.INS	DGENCONE.ASI
	.INS	DGENCABC.ASI





;--------\\
; GETANUM >
;--------/

; Donne un nombre dcimal.

; in	A4.L	^dans buffer
; out	A4.L	^plus loin
;	D4.32	nombre
; mod	D4.L, A4.L

GETANUM:
	PUSHM.32 D2|D3

	CLR.32	D4		; D4 <-- futur nombre
L10$:
	CLR.32	D3
	MOVE.8	{A4+},D3
	COMP.8	#"0",D3
	JUMP,LO	 R8^L50$
	COMP.8	#"9",D3
	JUMP,HI	 R8^L50$
	SUB.8	#"0",D3		; D3 <-- 0..9

	SL.32	#1,D4
	MOVE.32	D4,D2
	SL.32	#2,D4
	ADD.32	D2,D4		; D4 <-- pousse d'un digit (*10)

	ADD.32	D3,D4		; D4 <-- ajoute nouveau digit
	JUMP	L10$

L50$:
	DEC.32	A4		; D4 <-- ^terminateur

	POPM.32	D2|D3
	RET


;--------\
; MINMAJ  >
;========/

; N'utilise pas LIB,?MINMAJ pour tre plus rapide !

; in	D3.B	caractre
; out	D3.B	caractre majuscule
; mod	D3.W

MINMAJ:
	TEST.32	D3:#7		; code "supplmentaire" ?
	JUMP,NE	 R8^L20$	; oui => 20$
	COMP.8	#SPACE-2,D3	; lettre accentue ?
	JUMP,LO	 R8^L50$	; oui => 50$
	COMP.8	#"a",D3
	JUMP,LO	 R8^L20$
	COMP.8	#"z",D3		; minuscule non accentue ?
	JUMP,HI	 R8^L20$	; non => 20$
	SUB.8	#"a"-"A",D3	; oui => transforme
L20$:
	RET

L50$:
	COMP.8	#"",D3
	JUMP,LO L20$

	SUB.8	#"",D3
	AND.16	#16'FF,D3
	MOVE.8	R8^L70$+A16^{D3},D3; D3 <-- lettre majuscule
	RET

L70$:
	.8	"U","A","A","E","E","E","E","I","I","O","U","U","A","O","C"
	.EVEN


;--------\\
; MAJMIN  >
;========/

; Effectue une conversion MAJUSCULE --> minuscule.

; in	D3.B	caractre
; out	D3.B	caractre
; mod	D3.B

MAJMIN:
	COMP.8	#"A",D3
	JUMP,LO	 R8^L90$
	COMP.8	#"Z",D3
	JUMP,HI	 R8^L90$
	ADD.8	#"a"-"A",D3
L90$:
	RET



DOF1:
	MOVE.16	#F1,D3
	RET

DOF4:
	MOVE.16	#F4,D3
	RET

DOOK:
	MOVE.16	#CR,D3
	RET

DOAN:
	MOVE.16	#END,D3
	RET

DOMP:
	MOVE.16	#KEYMGP,D3
	RET

DOMR:
	MOVE.16	#KEYMGR,D3
	RET




; Textes
; ------

TERGNN:	.ASCII	"Vous devez encore indiquer<CR>"
	.ASCIZ	"la fonction du caractre !"
TERGNE:	.ASCIZ	"Cette fonction existe dj !"
TERGFN:	.ASCIZ	"Ce caractre n'existe pas !"


NAMDBOX:.ASCIZ	"DBOX"

TGCSMA:	.ASCIZ	"SMA"		; prfixe gnral
NMGENC:	.ASCIZ	"GENCAR"	; nom du module GENCAR
	.EVEN



END_DGENC:

	.END

