	.TITLE	DISK.ASL

;	--------------------------------------
;		(C) 1991 - Daniel Roux
;	--------------------------------------

;	Source du module SMA_DISK.LIB


;	Date		Amliorations
; ---------------------------------------------------------------------------------------------
; 1.16	15.12.95   PA	CALCPOURCENT ne fait plus de division par zro
; 1.15	02.06.95   PA	DISK_JUSTNAME: comme DISK_NAME, pas d'accs au dossier systme.
; 1.14  23.05.95   PA	DISK_COPY:   disque non PSOS, "no modif" du bloc 0, on peut d'ailleurs
;			             forcer ce mode en assignant "#DISK_NOMOD:".
; 1.13	02.05.95   PA	DISK_INFO:   petite modification
; 1.12	18.04.95   PA	DISK_INFO:   adaptation au pilote @XDRI-n:
;			DISK_FORMAT: ne cre plus le dossier DOSSIER: (plus ncessaire).
; 1.11	21.02.95   PA	Traduction en CALM. Quelques modifications.
; 1.10	01.12.93	DISK_FORMAT: clrfifo avant dbox_edit
; 1.9	27.08.93	DISK_GETFORM/PUTFORM: nouveaux appels
; 1.8	18.02.93	DISK_FORMAT: open - choix format - command F - close
;			DISK_RETRY:  n'utilise plus ERCALL (y'avait rcursion infinie)
; 1.7	15.02.93	DISK_FORMAT: met les deux croix (physique + logique) par dfaut
; 1.6	04.02.93	DISK_FORMAT: grise (INITIALISE) si autre format
;			DISK_TYPE:   grise (INITIALISE) si autre format
; 1.5	16.01.93	DISK_FORMAT: cache le format "720 Koctets (systme 6)"
;			DISK_FORMQ:  supprim (fait comme DISK_FORMAT)
; 1.4	09.10.92	DISK_COPY:   (PROGRA-T) donne tous les formats
;			DISK_FORMAT: (PROGRA-T) donne tous les formats
; 1.3	06.10.92	DISK_TYPE:   (PROGRA-T) donne tous les formats
;			DISK_TYPE:   affiche la taille (Koctets) si os!=smaky
; 1.2	25.09.92	DISK_FORMAT: ajoute ":" entre nom physique et DOSSIER: si ncessaire
; 1.1	10.07.92	DISK_COPY:   erreur si aucun format possible
;			DISK_FORMAT: vide le fifo du clavier  la fin (pour le SMAKY130) !
; 1.0	29.06.92	DISK_TYPE:   option (INITIALISE) pour formater ...
;			DISK_FORMQ:  formatage sans choisir le format
;			DISK_RETRY:  re-essaye un appel FOS avec d'autres formats
;			DISK_COPY:   copies disque  disque ...
; 0.7	04.03.92	DISK_TYPE:   format "systme 7 et 8"
; 0.6	31.01.92	DISK_TYPE:   accepte double-clic
;			DISK_FORMAT: pas de petites croix (scurit)
; 0.5	16.07.91	"ancien/nouveau" -> "systme 6/systme 7" (ide de DB)
;			DISK_INFO: affiche le format du disque
; 0.4	03.07.91	formate/type: si autre format => dernire case +1 slectionne
; 0.3	21.06.91	formate: ne propose plus les formats avec BMFMTNOFORM
; 0.2	04.06.91	affiche "Format 720 koctets (ancien/nouveau)"
;			plus de "formatage logique" si pas PSOS
; 0.1	23.05.90	dbut des travaux ...


	.PROC	M68000
	.BASE	10'10		; base 10 par dfaut
	.LAYOUT HEX		; listing en hexadcimal

	.REF	SMAKY
	.REF	MODULES
	.REF	DISK


MAJREV	=	1
MINREV	=	16

	.REV	MAJREV,MINREV
	.IDENT	"(C)  Daniel ROUX et EPSITEC SA"




; Constantes
; ----------

HACHE		= 31		; valeur "h" standard
MAXFMT		= 20		; nb max de formats diffrents
LBUDIS		= 100		; lg max pour OBUDIS
LBUNAM		= 100		; lg max d'un nom de disque
KEYDBOX		= 16'7E00	; "touche" pour dbox

BINFFSERV	= 10		; fichiers: accs aux autres serveurs


; Oprations
; ----------

OPNORM	=	0		; normal
OPFORM	=	1		; formatage
OPSIZE	=	2		; choix d'une taille



; Rstatus d'un pilote disque
; --------------------------

		.LOC	0
;OMFMTFLAG:	.BLKB	1	; flags dcrivant le mdia
 BMFMTDISKIN	= 0		;  1 => un disque de ce format insr
 BMFMTCURMODE	= 1		;  1 => le pilote est dans ce mode
 BMFMTNOFORM	= 2		;  1 => formatage impossible
;OMFMTOS:	.BLKB	1	; code de l'operating system (DISKOS*)
;OMFMTFACE:	.BLKB	2	; nombre de faces
;OMFMTCYL:	.BLKB	2	; nombre de cylindres
;OMFMTSECT:	.BLKB	2	; nombre de secteurs par piste
;OMFMTLGSECT:	.BLKB	2	; nombre de bytes par secteur
;OMFMTMODECMD:	.BLKB	4	; commande  envoyer  l'unit pour la mettre dans ce mode
;OMFMTNAMERS:	.BLKB	4	; no de la ressource de type "Format Floppy"
		.BLK.8	14	; rserve
;LGMFMTREC:




; Variables globales
; ------------------

	.LOC	0
OSAVD0:	.BLK.8	4		; sauvetage de D0
OSAVD1:	.BLK.8	4		; sauvetage de D1
OSAVD2:	.BLK.8	4		; sauvetage de D2
OSAVD3:	.BLK.8	4		; sauvetage de D3
OSAVD4:	.BLK.8	4		; sauvetage de D4
OSAVD5:	.BLK.8	4		; sauvetage de D5
OSAVD6:	.BLK.8	4		; sauvetage de D6
OSAVD7:	.BLK.8	4		; sauvetage de D7
OSAVA1:	.BLK.8	4		; sauvetage de A1
OSAVA2:	.BLK.8	4		; sauvetage de A2
OSAVA3:	.BLK.8	4		; sauvetage de A3
OSAVA4:	.BLK.8	4		; sauvetage de A4
OSAVA5:	.BLK.8	4		; sauvetage de A5

ODBKCH:	.BLK.8	4		; canal des soft-keys
ODBWCH:	.BLK.8	4		; canal dbox d'attente

OBUDIS:	.BLK.8	LBUDIS		; buffer pour write-display

OOS:	.BLK.8	2		; operating system (DISKOS*)
OOP:	.BLK.8	2		; opration (OP*)
OMEC:	.BLK.8	2		; mode pour ERCALL
OSIZE:	.BLK.8	4		; capacit
OBUNAM:	.BLK.8	LBUNAM		; nom du disque donn en entre
OBUNLO:	.BLK.8	LBUNAM		; nom du disque logique
OBUHEAD:.BLK.8	256		; en-tte binaire
OBUSTA:	.BLK.8	LGMAM3+(LGMFMTREC*MAXFMT)

OSLVAR:	.BLK.8	LSLVAR		; variables pour scroll-liste

OCPCDB:	.BLK.8	4		; copie: canal dbox wait
OCPCHR:	.BLK.8	2		; copie: canal driver source (read)
OCPCHW:	.BLK.8	2		; copie: canal driver destination (write)
OCPCMR:	.BLK.8	4		; copie: commande source (read)
OCPCMW:	.BLK.8	4		; copie: commande destination (write)
OCPERR:	.BLK.8	2		; copie: ok/erreur lors d'ouverture
OCPASC:	.BLK.8	LSCVAR		; copie: ascenseur
OCNMOD:	.BLK.8	1		; copie: pas de modification particulire
	.EVEN
LGVAR:




; En-tte du module LIB
; ---------------------

	.LOC	0
DEBUT:
	DISK_	FIRST		; code du premier appel	;%error
	DISK_	LAST		; code du dernier appel	;%error
	.8	0		; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	MAJREV,MINREV	; rvision.version
	.16	0,END_DISK	; longueur
	.32	PATHLIB		; pattern de dbut
	.FILL.8	(OHLNAM-APC),0
	.ASCII	"DISK"		; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_DISK_INFO
	.16	_DISK_NAME
	.16	_DISK_TYPE
	.16	_DISK_FORMAT
	.16	_DISK_FORMQ
	.16	_DISK_RETRY
	.16	_DISK_COPY
	.16	_DISK_GETFORM
	.16	_DISK_PUTFORM
	.16	_DISK_JUSTNAME




; Codes des appels
; ----------------




	.INS	DISKINFO.ASI
	.INS	DISKNAME.ASI
	.INS	DISKJNAME.ASI
	.INS	DISKTYPE.ASI
	.INS	DISKFORMAT.ASI
	.INS	DISKCOPY.ASI
	.INS	DISKRETRY.ASI
	.INS	DISKIO.ASI
	.INS	DISKMISC.ASI




END_DISK:


	.END

