 	.TITLE	EPRO

	.PROC	M68000
	.BASE	10'10

	.REF	SMAKY
	.REF	EPRO
	.REF	SCROLL
	.REF	DOLIB
	.REF	GRA
	.REF	COLORS
	.REF	BLOC
	.REF	DBOX
	.REF	RES
	.REF	MON
	.REF	SYSTEM

	.INS	EPRO.ASSR


SYS8	=	TRUE


; Date	     Rv  Quid
; --------------------------------------------------------------------------------
; 19/05/99   2.7   PA	Version avec support amlior pour le Smaky 400.
; 19/05/99   2.6   PA	Comme la version 2.5 a t gare, il faut refaire ce qui
;			manque par rapport  la version 2.4 (de MW)
; --------------------------------------------------------------------------------

EPROREV	=	2
EPROVERS=	7

	.REV	EPROREV,EPROVERS
	.IDENT	"(C) Daniel Roux, Michael Walz, Pierre Arnaud et EPSITEC SA"



; Touches fonction
; ----------------

CURSOR	=	2**BCURSOR
COPY	=	2**BCOPY
KILL	=	2**BKILL
PROGRA	=	2**BPROGRA
SHOW	=	2**BSHOW
SEARCH	=	2**BSEARCH
CHANGE	=	2**BCHANGE


; Touches spciales
; -----------------
KCIRCON	=	""		; touche circonflxe
KTREMA	=	""		; touche trma


; Caractres spciaux
; -------------------
CODCUR	=	3		; code pour triangle curseur
ENDLINE	=	4		; indique fin ligne tronque
BEGLINE	=	5		; indique dbut ligne tronqu
EDEOT	=	7		; fin du texte
EDEOL	=	10		; pseudo-fin de ligne
EOL	=	13		; fin de ligne
CIRCON	=	"^"		; caractre circonflxe
TREMA	=	""""		; caractre trma


; Divers
; ------

NLINFO	=	1		; nb lignes pour informations
NBMYLI	=	4		; nb lignes (CURSOR-X), etc.
MSKTAB	=	16'7		; masque pour les TABs

DELAY1	=	24
DELAY2	=	DELAY1/2


BCHEAV	= 0
BCHEARR	= 1
BCHEMAJ	= 2
BCHGE	= 3

LGLCHERCHE = 80

KEYDBOX	= 16'7E

HTTROUVE = 120
HTCHANGE = 150


; Types de modifications
; ----------------------
MODCUR	=	1		; curseur dplac
MODLIN	=	2		; ligne modifie
MODALL	=	3		; tout modifi


; Pointeurs pour un buffer tendu
; -------------------------------
	.LOC	0
OPDB:	.BLK.8	4		; ^dbut du buffer
OPDT:	.BLK.8	4		; ^dbut du trou
OPFT:	.BLK.8	4		; ^fin du trou
OPFB:	.BLK.8	4		; ^fin du buffer
OPDA:	.BLK.8	4		; ^dbut fentre pour affichage
ONOL:	.BLK.8	2		; numro ligne du curseur
OCURS:	.BLK.8	4		; position du curseur
OMODIF:	.BLK.8	1		; type de modification
OSTATUS:.BLK.8	1		; status du buffer
 BFILMOD=  0			;  texte sur disque pas  jour
OFLAFF:	.BLK.8	1		; flags pour l'affichage
 BAFEOT	=  0			;  fin du texte affiche
 BAFCUR	=  1			;  curseur affich
ORECUP:	.BLK.8	1		; flags rcupration
 BRECK	=  0			;  destruction
 BRECD	=  1			;  dplacement
	.EVEN 
ORECP1:	.BLK.8	4		; ^rcupration
ORECP2:	.BLK.8	4		; ^rcupration
LGBUFF:				; longueur de tout a


; Variables en (A6)
; -----------------
LBUCAR	=	100			; lg buffer de caractres

		.LOC	0

OSTART:		.BLK.8	4		; ^absolu dbut du code
OSTACK:		.BLK.8	4		; ^dbut du stack
OTERM:		.BLK.32	1		; ^touches terminatrices
ONOWDI:		.BLK.8	2		; no swdo informations
ONOWDT:		.BLK.8	2		; no swdo texte
ONOWDA:		.BLK.16	1		; no swdo ascenseur
OFLAGS:		.BLK.8	1		; flags divers
 BACC	=  0				;  frappe accent en cours
 BBLOC	=  1				;  module BLOC charg
		.EVEN
OMODE:		.BLK.32	1		; mode d'utilisation
OKEY:		.BLK.8	2		; touche presse
ONBL:		.BLK.8	2		; nombre de lignes texte
ONBL1:		.BLK.16	1		; nombre de lignes pour 1 page (ascenseur)
ONBI:		.BLK.8	2		; nombre de lignes info
OCX:		.BLK.8	2		; distance entre 2 caractres
OC1X:		.BLK.8	2		; largeur  gauche
OC2X:		.BLK.8	2		; largeur  droite
OCY:		.BLK.8	2		; distance entre 2 lignes
OC1Y:		.BLK.8	2		; hauteur dessus
OC2Y:		.BLK.8	2		; hauteur dessous
OPTCL1:		.BLK.8	4		; ^classe 1
OLGCL1:		.BLK.8	2		; lg classe 1
OPTCL2:		.BLK.8	4		; ^classe 2
OLGCL2:		.BLK.8	2		; lg classe 2
OPTCL3:		.BLK.8	4		; ^classe 3
OLGCL3:		.BLK.8	2		; lg classe 3
OPNEDIT:	.BLK.32	1		; ^nom de l'editeur
OTEXT1:		.BLK.32	1		; ^texte 1
OTEXT2:		.BLK.32	1		; ^texte 2
OFACTDIV:	.BLK.16	1		; facteur de div. pour SCROLL
OSCROLLFL:	.BLK.8	1
		.EVEN
OOFFSET:	.BLK.16	1		; offset <->
OASCENS:	.BLK.8	LSCVAR		; ascenseur
OBUFF:		.BLK.8	LGBUFF		; ^s buffer
OBUCAR:		.BLK.8	LBUCAR		; buffer d'affichage
OBUSTD:		.BLK.8	LGDIS2		; status fentre
OPDIS:		.BLK.32	1		; ^desc fen.
;OCLICORIG:	.BLK.32	1		; origine du clic avec le bouton de droite
;OCLICLAST:	.BLK.32	1		; dernier clic avec le bouton de droite


OX1:		.BLK.16	1
OY1:		.BLK.16	1
OCLICX1:	.BLK.16	1
OCLICY1:	.BLK.16	1
OCLICX2:	.BLK.16	1
OCLICY2:	.BLK.16	1

OCOORX1:	.BLK.16	1
OCOORY1:	.BLK.16	1
OCOORX2:	.BLK.16	1
OCOORY2:	.BLK.16	1
OLGCARX:	.BLK.16	1
OLGCARY:	.BLK.16	1
OHORIZ:		.BLK.8	1
OCLICDEHORS:	.BLK.8	1
OMOUSEB:	.BLK.8	1
OCLICFIRST:	.BLK.8	1
		.EVEN
OPLMAP:		.BLK.32	1
OMAXMY:		.BLK.16	1
OCHOIXMENU:	.BLK.16	1
OBUFFER:	.BLK.32	1		; buffer BLOC
OCHBLOC:	.BLK.16	1

ONOICO:		.BLK.8	1
ONONEF:		.BLK.8	1
OBUGC:		.BLK.8	4
		.EVEN

		.ALIGN	4
ORESCAN:	.BLK.32	1		; canal de RES_OPEN

ORESDBOX:	.BLK.32	1		; handle "Dbox"
ORESMMENUS:	.BLK.32	1		; handle "Mmenus"
ORESSTR:	.BLK.32	1		; handle "String"
ORESSKEY:	.BLK.32	1		; handle "SoftKeys"
ORESRAST:	.BLK.32	1		; handle "Raster"		
ORESWLIST:	.BLK.32	1		; handle "WordList"	

OBUFMMENUS:	.BLK.8	LMM*2		; buffer pour ?MMENUS

OLINECH:	.BLK.8	LGLCHERCHE
OLINEREMP:	.BLK.8	LGLCHERCHE
OOLINECH:	.BLK.8	LGLCHERCHE
OOLINEREMP:	.BLK.8	LGLCHERCHE
OCHMODE:	.BLK.32	1


LGVAR:


; En-tte du module LIB
; ---------------------

	.LOC	0

DEBCODE:
	.16	EPRO_FIRST	; code du premier appel
	.16	EPRO_LAST	; code du dernier appel
	.8	0		; nombre d'installations
	.FILL.8	(OHLREV-APC),0
	.8	1,4		; rvision.version
	.32	END_EPRO	; longueur
	.32	PATHLIB
	.FILL.8	(OHLNAM-APC),0

NOMPROG:
	.ASCII	"EPRO"		; nom du module
	.FILL.8	(LGHLIB-APC),0

	.16	_EPRO_OPEN
	.16	_EPRO_MAIN
	.16	_EPRO_CLOSE
	.16	_EPRO_NVISU
	.16	_EPRO_PVISU
	.16	_EPRO_VAFIN
	.16	_EPRO_VADEBUT
	.16	_EPRO_AVANCE
	.16	_EPRO_RECULE
	.16	_EPRO_INSERT
	.16	_EPRO_DAVANCE
	.16	_EPRO_DRECULE
	.16	_EPRO_FLUSH
	.16	_EPRO_GETPTC
	.16	_EPRO_IFEOL
	.16	_EPRO_EXTEND


; Codes des appels
; ----------------


;------------\\
; EPRO_EXTEND >
;============/
;
; in	D1.16	no. de l'appel
; out	selon l'appel
; mod	selon l'appel

_EPRO_EXTEND:
	CLR.16	D7
	COMP.16	#EPRO_GETPDBUFF,D1
	JUMP,EQ	_EPRO_GETPDBUF
	COMP.16	#EPRO_VERS,D1
	JUMP,EQ	_EPRO_VERS

	PUSHM.32 A5|A6
	MOVE.32	D6,A6
	MOVE.32	#{A6}+OBUFF,A5

	COMP.16	#EPRO_AFFBUF,D1
	JUMP,EQ	_EPRO_AFFBUF
	COMP.16	#EPRO_VAPOSN,D1
	JUMP,EQ	_EPRO_VAPOSN
	COMP.16	#EPRO_AFFINFO,D1
	JUMP,EQ	_EPRO_AFFINFO
	COMP.16	#EPRO_SETMODE,D1
	JUMP,EQ	_EPRO_SETMODE

	COMP.16	#EPRO_UPDATE,D1
	JUMP,EQ	_EPRO_UPDATE
	COMP.16	#EPRO_AFFSCROLL,D1
	JUMP,EQ	_EPRO_AFFSCROLL
	COMP.16	#EPRO_UNDO,D1
	JUMP,EQ	_EPRO_UNDO

	COMP.16	#EPRO_DETRMEV,D1
	JUMP,EQ	_EPRO_DETRMEV
	COMP.16	#EPRO_COPIEMEV,D1
	JUMP,EQ	_EPRO_COPIEMEV
	COMP.16	#EPRO_COUPEMEV,D1
	JUMP,EQ	_EPRO_COUPEMEV
	COMP.16	#EPRO_COLLE,D1
	JUMP,EQ	_EPRO_COLLE
	COMP.16	#EPRO_CLASSEUR,D1
	JUMP,EQ	_EPRO_CLASSEUR
	COMP.16	#EPRO_UNDOMEV,D1
	JUMP,EQ	_EPRO_UNDOMEV
	COMP.16	#EPRO_GETMEV,D1
	JUMP,EQ	_EPRO_GETMEV
	COMP.16	#EPRO_TSTUNDO,D1
	JUMP,EQ	_EPRO_TSTUNDO
	COMP.16	#EPRO_CHERCHE,D1
	JUMP,EQ	_EPRO_CHERCHE
	COMP.16	#EPRO_CHAV,D1
	JUMP,EQ	_EPRO_CHAV
	COMP.16	#EPRO_CHAR,D1
	JUMP,EQ	_EPRO_CHAR
	COMP.16	#EPRO_DEFCHERCHE,D1
	JUMP,EQ	_EPRO_DEFCHERCHE
	COMP.16	#EPRO_NOUNDO,D1
	JUMP,EQ	_EPRO_NOUNDO

	MOVE.16	#-1,D7

FINEXTEND:
	POPM.32	A5|A6
	RET


;-------------\
; EPRO_NOUNDO  >
;=============/

; signale que l'opration "annule" n'est plus possible.

; in	-
; out	-
; mod	-

_EPRO_NOUNDO:
	CALL	EXOTHER
	JUMP	FINEXTEND



;----------\
; EPRO_CHAV >
;==========/

; cherche en avant

; in	D1.16	#EPRO_CHAV
; out	EQ	trouv
;	NE	pas trouv
; mod	-

_EPRO_CHAV:
	CALL	CHAV
	JUMP	FINEXTEND
	



;----------\
; EPRO_CHAR >
;==========/

; cherche en arrire

; in	D1.16	#EPRO_CHAR
; out	EQ	trouv
;	NE	pas trouv
; mod	-

_EPRO_CHAR:
	CALL	CHAR
	JUMP	FINEXTEND
	


;-----------------\
; EPRO_DEFCHERCHE  >
;=================/

; dfinit les chanes de recherche

; in	D1.16	#EPRO_DEFCHERCHE
;	A3.32	^chane de recherche termin par <0>
;	A4.32	^chane de remplacement termin par <0>
; out	-
; mod	-

_EPRO_DEFCHERCHE:
	PUSHM.32 A0|A1|A3|A4
	MOVE.32	A3,A0
	MOVE.32	A4,A1
	CALL	SAVEOLD

	MOVE.32	#{A6}+OLINECH,A3
	
C1$:	MOVE.8	{A0+},{A3+}
	JUMP,NE	C1$

	MOVE.32	#{A6}+OLINEREMP,A4
	
C2$:	MOVE.8	{A1+},{A4+}
	JUMP,NE	C2$

	POPM.32	A0|A1|A3|A4
	JUMP	FINEXTEND




;-------------\
; EPRO_CHERCHE >
;=============/

; recherches et subsitutions

; in	-
; out	-
; mod	-

_EPRO_CHERCHE:
	PUSHM.32 D0..D6|A0..A4
	CALL	CHERCHE	
	POPM.32 D0..D6|A0..A4
	JUMP	FINEXTEND


;-----------\
; EPRO_VERS  >
;===========/

; donne la version d'EPRO

; in	-
; out	D4.16	REV*H'100+VERS
; mod	-

_EPRO_VERS:
	MOVE.16	#16'100*EPROREV+EPROVERS,D4
	RET


;-------------\\
; EPRO_EXTEND  >
;=============/

; teste si l'opration d'annulation est possible (pour griser
; ventuellement la case " annule " du mousemenu du bouton du milieu

; in	D1.16	#EPRO_TSTUNDO
;	D6.32	canal
; out	EQ	=> UNDO possible
;	NE	=> UNDO impossible (pour griser la case "annule"
; mod	-

_EPRO_TSTUNDO:
	TEST.8	{A5}+ORECUP
	NOTZ
	JUMP	FINEXTEND


;-------------\
; EPRO_DETRMEV >
;=============/

; Dtruit la mise en vidence

; in	-
; out	-
; mod	-

_EPRO_DETRMEV:
	CALL	GETPTA3A4
	JUMP	BOUSIL1


;--------------\
; EPRO_COPIEMEV >
;==============/

; copie la mise en vidence

; in	-
; out	-
; mod	-

_EPRO_COPIEMEV:
	CALL	GETPTA3A4
	CALL	COPIE
	MOVE.32	#1,D6
	CALL	CLRZCOUL
	JUMP	BOUSIL2


;--------------\
; EPRO_COUPEMEV >
;==============/

; coupe la mise en vidence

; in	-
; out	-
; mod	-

_EPRO_COUPEMEV:
	CALL	GETPTA3A4
	CALL	COPIE
BOUSIL1:
	CALL	BOUSILLE

	MOVE.8	#MODALL,{A5}+OMODIF
	CALL	AFFBUF
BOUSIL2:
	CALL	GIVPLMAP
	JUMP	FINEXTEND


;-------------\
; EPRO_UNDOMEV >
;=============/

; annule la mise en vidence

; in	-
; out	-
; mod	-

_EPRO_UNDOMEV:
	MOVE.32	#1,D6
	CALL	CLRZCOUL
	JUMP	BOUSIL2


CLRZCOUL:
	LIB	?COLORPUSH
	MOVE.32	#COLOR_PPHILI,D3
	LIB	?COLORSR

	CALL	CLRZONE
	LIB	?COLORPOP
	RET


;------------\
; EPRO_GETMEV >
;============/

; donne le pointeur et la longueur de la mise en vidence

; in	-
; out	A4.32	^1er caractre
;	D4.32	longueur
; mod	-

_EPRO_GETMEV:
	PUSHM.32 D0|A3
	CALL	GETPTA3A4
	CALL	GETLGHOLE

	SUB.32	A4,A3
	MOVE.32	A3,D4
	TEST.32	D4
	JUMP,EQ	BOM$
	SUB.32	D0,D4
	JUMP,MI	BOM$

FIN$:	POPM.32	D0|A3
	JUMP	FINEXTEND

BOM$:	CLR.32	D4
	JUMP	FIN$




;-----------\
; EPRO_COLLE >
;===========/

; colle le contenu du bloc-notes dans EPRO

; in	-
; out	-
; mod	-

_EPRO_COLLE:
	CALL	INSCOLLE
	JUMP	FINEXTEND


;--------------\
; EPRO_CLASSEUR >
;==============/

; affiche le classeur

; in	-
; out	-
; mod	-

_EPRO_CLASSEUR:
	CALL	CLASSEUR
	JUMP	FINEXTEND



;-------------\\
; EPRO_VAPOSN  >
;=============/

; Positionne le curseur sur le nime caractre du texte.

; in	D4.32	position du curseur
;	D6.32	canal
; out	D7.16	erreur
; mod	D7.16

_EPRO_VAPOSN:
	CALL	VAPOSN
	JUMP	FINEXTEND


;-------------\\
; EPRO_AFFBUF  >
;=============/

; Refait compltement l'cran. Ceci est utile si l'cran a t effac pour
; une raison ou une autre.

; in	D6.32	canal
; out	-
; mod	D7.16


_EPRO_AFFBUF:
	MOVE.8	#MODALL,{A5}+OMODIF
	CALL	AFFBUF
	JUMP	FINEXTEND


;-------------\\
; EPRO_AFFINFO >
;=============/

; Reaffiche la ligne d'information.

; in	D6.32	canal
; out	-
; mod	D7.16

_EPRO_AFFINFO:
	CALL	AFFINFO
	JUMP	FINEXTEND


; ne marche pas !?

_EPRO_UNDO:
	CALL	EXRECUP
	JUMP	FINEXTEND


;-------------\\
; EPRO_SETMODE >
;=============/

; Change le mode d'affichage pour les line-feed, retours de chariot et tabulateurs.

; in	D4.16	bits de mode
;	 2**BEPROAFCR	affiche les retours de chariot
;	 2**BEPROAFLF	affiche les line-feed
;	 2**BEPROAFTAB	affiche les tabulateurs
;	D6.32	canal
; out	-
; mod	-

_EPRO_SETMODE:
	PUSH.32	D4
	AND.32	#2**BEPROAFCR+2**BEPROAFLF+2**BEPROAFTAB,D4
	TCLR.8	{A6}+OMODE+3:#BEPROAFCR
	TCLR.8	{A6}+OMODE+2:#BEPROAFLF
	TCLR.8	{A6}+OMODE+2:#BEPROAFTAB
	OR.32	D4,{A6}+OMODE
	POP.32	D4
	JUMP	FINEXTEND


;-------------\\
; EPRO_UPDATE  >
;=============/

; Reaffiche le text en affichant le minimum 

; in	D6.32	canal
;	D4.8	degr de modification
;	 #0           automatique
;	 #EPROMODCUR  curseur dplac
;	 #EPROMODLIN  ligne modifie
;	 #EPROMODALL  tout modifi
; out	-
; mod	-

_EPRO_UPDATE:
	CALL	MODIF
	CALL	AFFBUF
	JUMP	FINEXTEND


;---------------\\
; EPRO_AFFSCROLL >
;===============/

; Reaffiche l'ascenseur

; in	D6.32	canal
; out	-
; mod	-

_EPRO_AFFSCROLL:
	CALL	AFSCROLL
	JUMP	FINEXTEND


;--------------\\
; EPRO_GETPDBUF  >
;===============/
; 
; in	D1.16	#EPRO_GETPDBUF
;	D6.32	canal
; out	A5.32	^descripteur du buffer
; mod	-

_EPRO_GETPDBUF:
	MOVE.32	D6,A5		; A5 <-- ^variables
	ADD.32	#OBUFF,A5	; A5 <-- ^descripteur buffer
	RET


;-----------\\
; EPRO_OPEN  >
;===========/
;
; Dbut d'dition du texte.
; Creuse le buffer de texte et affiche une premire fois
; le texte et les informations.
; in	A3.L	^dbut du texte (termin par zro)
;	A4.L	^position du curseur
;	D3.L	longueur max du buffer
;	D4.W	mode (2^BEPRONI!2^BEPROCL!2^BEPRONEOT) 
;	A5.L	si 2^BEPROCL=1
;		^<SPACE>classe1<0><CR>classe2<0><EOP>classe3<0>
;	A1.32	^nom de l'diteur ou 0 si 2**BEPROTXT
;	A0.32	^texte 1 ou 0 si 2**BEPROTXT
;	A2.32	^texte 2 ou 0 si 2**BEPROTXT
; out	D6.L	canal
;	D7.W	erreur
; mod	D6.L, D7.W

_EPRO_OPEN:
	PUSHM.32 D0..D5|A2..A6

	MOVE.32	A4,D0		; D0 <-- ^position curseur
	MOVE.32	D4,D2		; D2 <-- mode

; Demande la mmoire pour les variables et met-les toutes
;  zro pour conomiser des tonnes de CLR.W (A6)+machin.

	MOVE.32	#LGVAR,D4	; D4 <-- longueur ncessaire
	MOVE.32	#MTYPCP,D1	; D1 <-- pour processus courant
	GESMEM	?GETMEM	; demande mmoire pour var
	JUMP,NE	L90$		; plein => 90$
	MOVE.32	A4,A6		; A6 <-- ^variables (TOUJOURS)
	GESMEM	?CLEARMEM

; Initialise les ressources

	CALL	INITRES

; Initialises les variables les plus importantes.

	MOVE.32	#R16^DEBCODE,A4
	MOVE.32	A4,{A6}+OSTART	; mm. adr. de dbut du code
	TEST.32	D2:#BEPROEXTEND
	JUMP,BS	NOMSK$
	AND.32	#16'FFFF,D2

NOMSK$:	MOVE.32	D2,{A6}+OMODE	; init le mode

	MOVE.32	#2**BCHEAV+2**BCHEMAJ,{A6}+OCHMODE
				; mode de recherche par dfaut

	MOVE.32	#R16^TDEFNEDIT,A4 ; ^"EPRO rev 1.3" -> A4
	MOVE.32	A4,{A6}+OPNEDIT	; sauve
	MOVE.32	#R16^TESPACES,A4
	MOVE.32	A4,{A6}+OTEXT1
	MOVE.32	A4,{A6}+OTEXT2
	TEST.32	D2:#BEPROTXT	; mode TXT ?
	JUMP,BC	NOTXT$		; non => NOTXT$
	COMP.32	#0,A1		; zero ?
	JUMP,EQ	A1ZERO$		; garde EPRO
	MOVE.32	A1,{A6}+OPNEDIT
A1ZERO$:
	COMP.32	#0,A0		; zero ?
	JUMP,EQ	A0ZERO$		; 
	MOVE.32	A0,{A6}+OTEXT1
A0ZERO$:
	COMP.32	#0,A2		; zero ?
	JUMP,EQ	A2ZERO$		; 
	MOVE.32	A2,{A6}+OTEXT2
A2ZERO$:

NOTXT$:
	MOVE.32	D0,A2

; Initialise les variables pour les dlimiteurs de classes.

	TEST.32	D2:#BEPROCL	; classe ^par A5 ?
	JUMP,BS	L20$		; oui => 20$
	MOVE.32	#R16^DEFCLASS,A5; non => prend classes par dfaut

L20$:	MOVE.32	#{A6}+OPTCL1,A4
	MOVE.16	#3,D4		; D4 <-- nb de classes
L22$:	MOVE.32	A5,{A4+}	; (A6)+OPTCLn <-- ^classe
	CLR.16	D5
L24$:	INC.16	D5		; D5 <-- lg classe
	TEST.8	{A5+}		; A5 <-- ^classe suivante
	JUMP,NE	L24$
	MOVE.16	D5,{A4+}	; (A6)+OLGCLn <-- lg classe
	DEC.16	D4
	JUMP,NE	L22$
	MOVE.16	{A6}+OLGCL3,D4
	ADD.16	D4,{A6}+OLGCL2
	MOVE.16	{A6}+OLGCL2,D4
	ADD.16	D4,{A6}+OLGCL1

; Initialise tous les paramtres possibles concernant le buffer
; de texte, mais sans le trouer pour l'instant.

	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^description buffer
	MOVE.32	A3,{A5}+OPDB
	MOVE.32	A2,{A5}+OPDT
	ADD.32	D3,A3
	MOVE.32	A3,{A5}+OPFB

; Initialise la fentre dans le bon mode.
	LIB	?AFTIM
	.8	NOROLL		; pas de roll dans la fentre
	.8	TRUNC		; tronque lignes trop longues
	.8	NOEFLI		; efface pas la fin des lignes
	.8	GCURS		; grand curseur si questions
	.8	NOCURS		; pas de curseur normalement
	.8	MODGRA,GRACLIP
	.8	AFFULL,AFDIR
	.8	0
	.EVEN 

; Initialise les variables en fonctions des dimensions de la
; fentre et des caractres.

	LIB	?GETPDIS
	MOVE.32	A4,{A6}+OPDIS

	LIB	?GCHDIS	; D6 <-- canal cran
	MOVE.16	#TYPWDO,D3	; D3 <-- type fentre cran
	MOVE.16	#LGDIS2,D4	; D4 <-- longueur demande
	MOVE.32	#{A6}+OBUCAR,A4	; A4 <-- ^buffer
	FOS	?RSTATUS
	JUMP,NE	L80$

	MOVE.16	{A4}+ODFCX,{A6}+OCX

	MOVE.16	{A4}+ODFCY,D4
	TEST.8	{A6}+OMODE+3:#BEPROILMIN	; interligne minimal ?
	JUMP,BC	NOILMIN$			; non => NOILMIN$
	MOVE.16	{A4}+ODFC1Y,D4
	ADD.16	{A4}+ODFC2Y,D4
	INC.16	D4
	AND.16	#16'FFFE,D4			; toujours interligne pair
NOILMIN$:
	MOVE.16	D4,{A6}+OCY

	CLR.32	D3
	MOVE.16	{A4}+ODFFDX,D3
	DIV.16	{A6}+OCX,D3
	MOVE.16	D3,{A6}+OLGCARX

	CLR.32	D3
	MOVE.16	{A4}+ODFFDY,D3
	DIV.16	{A6}+OCY,D3
	MOVE.16	D3,{A6}+OLGCARY

	MOVE.16	{A4}+ODFC1X,{A6}+OC1X
	MOVE.16	{A4}+ODFC2X,{A6}+OC2X

	MOVE.16	{A4}+ODFC1Y,{A6}+OC1Y
	MOVE.16	{A4}+ODFC2Y,{A6}+OC2Y


; Cre les sous-fentres pour les informations et pour le texte.

	CLR.16	{A6}+ONBI
	TEST.8	{A6}+OMODE+3:#BEPRONI ; affiche les infos ?
	JUMP,BS	L30$		; non => 30$
				; oui =>
	MOVE.16	#NLINFO,{A6}+ONBI
	MOVE.32	{A4}+ODFFY,D3	; D3 <-- y,x
	MOVE.16	{A6}+OCY,D4
	MUL.16	{A6}+ONBI,D4	; D4 <-- dy
	SWAP.32	D4
	MOVE.16	{A4}+ODFFDX,D4	; D4 <-- dx
	LIB	?CREWDO	; cre swdo informations
	MOVE.16	D5,{A6}+ONOWDI
L30$:
	MOVE.16	{A6}+OCY,D3
	MUL.16	{A6}+ONBI,D3
	CLR.32	D4
	MOVE.16	{A4}+ODFFDY,D4
	SUB.16	D3,D4		; D4 <-- dy
	MOVE.16	D4,D0
	SWAP.32	D0

	DIV.16	{A6}+OCY,D4	; arrondit
	MUL.16	{A6}+OCY,D4

	ADD.16	{A4}+ODFFY,D3	; D3 <-- y
	SWAP.32	D3
	SWAP.32	D4
	MOVE.16	{A4}+ODFFX,D3	; D3 <-- x
	MOVE.16	{A4}+ODFFDX,D4	; D4 <-- dx

	TEST.8	{A6}+OMODE+3:#BEPROMOUSE	; ascenseur ?
	JUMP,BC	NOASC$		; non => NOASC$

	PUSHM.32 D3|D4

	MOVE.32	#R16^NBLOC,A3
	MOVE.16	#BLOC_FIRST,D3
	LIB_	OPEN
	JUMP,NE	NOBLOC$
	MOVE.16	D1,{A6}+OCHBLOC
	BLOC_	OPEN
	TSET.8	{A6}+OFLAGS:#BBLOC

NOBLOC$:
	POPM.32	D3|D4


	PUSHM.32 D3|D4
	SWAP.32	D3
	CLR.16	D3

	TEST.8	{A6}+OMODE+3:#BEPRONI	; informations ?
	JUMP,BS	L31$			; oui => 31$

	MOVE.16	{A4}+ODFC1Y,D3
	ADD.16	{A4}+ODFC2Y,D3

L31$:
	ADD.16	{A4}+ODFFY,D3
	SWAP.32	D3
	MOVE.32	D0,D4
	MOVE.16	#LGSCROLL,D4
	LIB	?CREWDO
	MOVE.16	D5,{A6}+ONOWDA
	LIB	?GETWDO
	PUSH.16	D5
	MOVE.16	{A6}+ONOWDA,D5
	LIB	?USEWDO		; utilise la fentre de l'ascenseur

	PUSH.32	A5
	MOVE.32	#{A6}+OASCENS,A5
	MOVE.8	#1,{A5}+OSCPAGE
	CLR.32	{A5}+OSCDEB

	LIB	?GETWDO
	SWAP.32	D4
	MOVE.16	D4,{A5}+OSCHTR
	MOVE.16	#10,{A5}+OSCHTV
	MOVE.16	#1,{A5}+OSCPOSV
	MOVE.16	#1,{A5}+OSCINC
	SCROLL_	DRAW
	POP.32	A5
	POP.16	D5
	LIB	?USEWDO
	POPM.32	D3|D4

	ADD.16	#16,D3
	SUB.16	#16,D4

NOASC$:
	LIB	?CREWDO	; cre swdo texte
	MOVE.16	D5,{A6}+ONOWDT

; Calcul le nombre de lignes dans la sous-fentre de texte.
	CLR.32	D4
	MOVE.16	{A4}+ODFFDY,D4
	DIV.16	{A6}+OCY,D4
	SUB.16	{A6}+ONBI,D4
	MOVE.16	D4,{A6}+ONBL
	MUL.16	#3,D4
	DIV.16	#4,D4
	MOVE.16	D4,{A6}+ONBL1	; ONBL1 := ONBL*3/4 (pages avec ascenseur)
; Creuse le trou dans le buffer de texte.
	MOVE.32	{A5}+OPDT,A3
	CLR.32	D3
L40$:	INC.32	D3		; D3 <--  nb car +1
	TEST.8	{A3+}		; zro terminateur trouv ?
	JUMP,NE	L40$		; non => 40$
	DEC.32	A3
	MOVE.32	{A5}+OPFB,A4
L50$:	DEC.32	D3
	JUMP,EQ	L60$
	MOVE.8	{-A3},{-A4}	; creuse le trou
	JUMP	L50$
L60$:	MOVE.32	A4,{A5}+OPFT
; Donne une bonne allure  la fentre.
	MOVE.8	#MODALL,D4	; MOD. FJ.
	CALL	MODIF		; signal tout modifi
	CALL	AFFINFO		; affiche les informations
	CALL	AFFBUF		; affiche tout l'cran

	CALL	AFSCROLL

	MOVE.32	A6,D6		; D6 <-- "canal"
	CLR.16	D7		; D7 <-- ok
	JUMP	L90$

L80$:	PUSH.16	D7
	MOVE.32	A6,A4		; A4 <-- ^zone mmoire
	MOVE.32	#MTYPCP,D1	; D1 <-- type
	GESMEM	?GIVMEM	; rend la mmoire
	POP.16	D7		; D7 <-- erreur

L90$:	POPM.32	D0..D5|A2..A6
	TEST.16	D7		; retour EQ/NE
	RET


NBLOC:	.ASCIZE	"BLOC"


;-----------\\
; EPRO_MAIN  >
;===========/

; Edite le texte jusqu' ce qu'une touche invalide soit
; lue du clavier.

; in	D6.L	canal
;	A4.L	^touches terminatrices (.BB f,c puis .W 0)
; out	D7.W	zro => ok
;	 D3.W	 dernire touche presse
;	D7.W	ERPDP => buffer plein
; mod	D3.L, D7.W

_EPRO_MAIN:
	PUSHM.32 D0..D2|D4..D6|A0..A6

	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	MOVE.32	SP,{A6}+OSTACK	; mm. valeur initiale du stack
	MOVE.32	A4,{A6}+OTERM

MAIN:	MOVE.32	{A6}+OSTACK,SP
	PUSH.32	#R16^XMAIN

	MOVE.8	{A6}+OSCROLLFL,D3 ; on scrolle avec la souris ?
	JUMP,EQ	NOSCR$		  ; non => NOSCR$
	COMP.8	#SCROLLFUP,D3
	JUMP,EQ	SCRUP$
	COMP.8	#SCROLLFDOWN,D3
	JUMP,EQ	SCRDOWN$
	COMP.8	#SCROLLPUP,D3
	JUMP,EQ	PGUP$
	COMP.8	#SCROLLPDOWN,D3
	JUMP,EQ	PGDOWN$
	RET

; scrolle en haut par pages
PGUP$:
	MOVE.16	{A6}+ONBL1,D0
PGUL$:	CALL	DEBLIGNE
	CALL	RECULE
	CALL	DEBLIGNE
	DEC.16	D0
	JUMP,NE	PGUL$
	CALL	AFFBUF
	LIB	?IFMOUSE
	TEST.32	D3:#BMOLEFT
	JUMP,BS	PGUP$
	CALL	CLRFL
	RET

; scrolle en bas par pages
PGDOWN$:
	MOVE.16	{A6}+ONBL1,D0
PGDL$:	CLR.16	D4
	CALL	AVANCE
	JUMP,NE	PGF$
	CALL	IFEOL
	JUMP,NE	PGDL$
	DEC.16	D0
	JUMP,NE	PGDL$
PGF$:	CALL	AFFBUF
	LIB	?IFMOUSE
	TEST.32	D3:#BMOLEFT
	JUMP,BS	PGDOWN$
	CALL	CLRFL
	RET

; scrolle en haut par lignes
SCRUP$:
	CLR.16	D4
	CALL	DEBLIGNE
	CALL	RECULE
	CALL	DEBLIGNE
	CALL	AFFBUF
	LIB	?IFMOUSE
	TEST.32	D3:#BMOLEFT
	JUMP,BS	SCRUP$
	CALL	CLRFL
	RET

; scrolle en bas par lignes
SCRDOWN$:
	CLR.16	D4
	CALL	FINLIGNE
	CALL	AVANCE
	CALL	AFFBUF
	LIB	?IFMOUSE
	TEST.32	D3:#BMOLEFT
	JUMP,BS	SCRDOWN$
	CALL	CLRFL
	RET

; pas de scroll avec la souris
NOSCR$:
	LIB	?IFCAR		; une touche presse ?
	JUMP,EQ	L20$		; oui => 20$
	CALL	AFFBUF		; non => affiche le buffer de texte
	LIB	?IFCAR		; une touche presse ?
	JUMP,EQ	L20$		; oui => 20$
	CALL	AFFINFO		; non => affiche les informations
	CALL	AFSCROLL
L10$:	MOVE.16	#DELAY1,D4
	NTREL	?SETTIM
	LIB	?GETCAR		; une touche presse ?
	JUMP,EQ	L18$		; oui => 18$
	CALL	INKCURS		; non => efface le curseur
	MOVE.16	#DELAY2,D4
	NTREL	?SETTIM
	LIB	?GETCAR		; une touche presse ?
	JUMP,EQ	L16$		; oui => 16$
	CALL	INKCURS		; non => remet le curseur
	JUMP	L10$
L16$:	CALL	INKCURS		; remet le curseur
L18$:	MOVE.16	#-1,D4
	NTREL	?SETTIM		; remet timeout infini
L20$:	COMP.16	#KEYMGR,D3
	JUMP,EQ	MAIN
	COMP.16	#KEYMDR,D3
	JUMP,EQ	MAIN
	COMP.16	#KEYMMR,D3
	JUMP,EQ	MAIN
	CALL	IFTERM		; touche terminatrice ?
	JUMP,EQ	NMAIN		; oui => NMAIN

	CALL	AUTOC		; CURSOR automatique
	MOVE.16	D3,{A6}+OKEY	; mm touche presse
	COMP.16	#16'100,D3	; touche fonction presse ?
	JUMP,LO	L40$		; non => 40$
	CALL	EXNOACCENT	; annule si frappe accent en cours
	TEST.8	{A6}+OMODE+2:#BEPRONOMOD
	JUMP,BC	L21$
	CALL	EXFONC
	.16.16	CURSOR,OCURSOR
	.16.16	0,L25$
L21$:
	CALL	EXFONC		; cherche routine ...
	.16.16	CURSOR,OCURSOR
	.16.16	CURSOR.OR.KILL,OKILLCURS
	.16.16	SHOW,OSHOW
	.16.16	KILL,OKILL
	.16.16	0,L25$
L25$:
	TEST.8	{A6}+OMODE+3:#BEPROMOUSE
	JUMP,BC	NMAIN

	TEST.8	{A6}+OMODE+2:#BEPRONOMOD ; pas de modifs permises ?
	JUMP,BC	EXSEA$			; NON => EXSEA$

	CALL	EXFONC
	.16.16	SEARCH,OSEARCH
	.16.16	0,NOSEA$

EXSEA$:
	CALL	EXFONC
	.16.16	SEARCH,OSEARCH
	.16.16	CHANGE,OCHANGE
	.16.16	0,NOSEA$

NOSEA$:
	COMP.16	#KEYMGP,D3	; bouton de gauche press ?
	JUMP,EQ	SOURIS
	TEST.8	{A6}+OMODE+2:#BEPRONOMOD ; pas de modifs permises ?
	JUMP,BS	NOMARQUE$	
	COMP.16	#KEYMDP,D3	; bouton de droite press ?
	JUMP,EQ	MARQUE		; oui => marque
NOMARQUE$:	

NODR$:	TEST.8	{A6}+OMODE+1:#BEPRONBMIL
	JUMP,BS	NOMI$
	COMP.16	#KEYMMP,D3
	JUMP,EQ	BMILIEU
NOMI$:
;;	CALL	EXOTHER		; ici touche super-shift (PROGRA,SEARCH etc.)
	CLR.16	D7
	JUMP	NMAIN
L40$:
	TEST.8	{A6}+OMODE+3:#BEPROMOUSE
	JUMP,BC	NODEF$
	COMP.16	#DEFINE,D3
	JUMP,EQ	CHERCHE
NODEF$:
	TEST.8	{A6}+OMODE+2:#BEPRONOMOD ; pas de modifs permises ?
	JUMP,BS	L50$			; oui => 50$
	TEST.8	{A6}+OFLAGS:#BACC ; frappe accent en cours ?
	JUMP,BC	L50$		; non => 50$
	CALL	ACCENT		; traite les cas ^e, "i, etc.
	JUMP,NE	L50$		; autre cas => 50$
	CALL	EXOTHER		; action non rcuprable
	JUMP	XMAIN

L50$:	TEST.8	{A6}+OMODE+2:#BEPRONOMOD ; pas de modifs permises ?
	JUMP,BC	L51$			; non => 51$
	CALL	EXKEY
	.16	UNDO,EXRECUP
	.16	0,L65$

L51$:	CALL	EXKEY
	.16.16	DELETE,KBCARAC
	.16.16	DEL,KBCARAC
	.16.16	BS,KCARAC
	.16.16	UNDO,EXRECUP
	.16.16	TRIZERO,EXTRIZERO
	.16.16	POINT,EXPOINT
	.16.16	ENTER,EXENTER
	.16.16	0,L60$

L60$:
;;	CALL	EXOTHER		; action non rcuprable
				; touche  insrer touche FONCTION
	TEST.8	{A6}+OMODE+2:#BEPRONOMOD
	JUMP,BS	L65$
	CALL	EXKEY
	.16.16	KCIRCON,XCIRCON
	.16.16	KTREMA,XTREMA
	.16.16	0,L65$

L65$:
	CLR.16	D7		; D7 <-- ok
	TEST.32	D3:#7
	JUMP,BS	NMAIN
	TEST.8	{A6}+OMODE+2:#BEPRONOMOD
	JUMP,BS	NMAIN
	CALL	INSERT		; insre le caractre
	JUMP,NE	NMAIN

XMAIN:	TEST.8	{A6}+OMODE+3:#BEPROQUITTE
	JUMP,BC	MAIN

NMAIN:	MOVE.32	{A6}+OSTACK,SP

NMAIN1$:
	POPM.32	D0..D2|D4..D6|A0..A6
	TEST.16	D7		; retour EQ/NE
	RET

EXENTER:
	MOVE.8	#CR,D3
EXINSERT:
	CALL	INSERT
	RET

EXPOINT:
	MOVE.8	#".",D3
	JUMP	EXINSERT

EXTRIZERO:
	MOVE.8	#"0",D3
	CALL	INSERT
	CALL	INSERT
	JUMP	EXINSERT



; fin du scrolling avec la souris

CLRFL:
	PUSHM.32 D3|D4|D5|A5
	LIB	?GETWDO
	PUSH.16	D5
	MOVE.16	{A6}+ONOWDA,D5
	LIB	?USEWDO
	MOVE.32	#{A6}+OASCENS,A5
	MOVE.8	{A6}+OSCROLLFL,D4
	AND.16	#16'F,D4
	SCROLL_	PRESS
	POP.16	D5
	LIB	?USEWDO
	CLR.8	{A6}+OSCROLLFL
	POPM.32	D3|D4|D5|A5
	RET



;-------\
; AUTOC  >
;=======/

; in	D3.32	touche
; out	D3.32	touche transforme
; mod	D3.32

; transforme les touches pour le mode BEPROAUTOC

AUTOC:
	PUSH.32	D4
	TEST.8	{A6}+OMODE+2:#BEPROAUTOC
	JUMP,BC	FIN$
	COMP.8	#16'80,D3
	JUMP,HS	FIN$
	MOVE.32	D3,D4

	AND.16	#16'FF00,D3
	TEST.16	D3
	JUMP,NE	FIN1$
	MOVE.16	#16'100*CURSOR,D3
	MOVE.8	D4,D3
	JUMP	FIN$

FIN1$:	MOVE.32	D4,D3

FIN$:	POP.32	D4
	RET



	.INS	EPRORES.ASI

	.INS	EPROMARQUE.ASI



; bouton de gauche press 
; -----------------------

SOURIS:
	PUSHM.32 D3|D4|D5|A1|A4|A5

	MOVE.32	A5,A1			; ^buffer -> A1

	LIB	?GETWDO			; no. fentre actuelle -> D5
	PUSH.16	D5			; sauve sur stack
	MOVE.16	{A6}+ONOWDA,D5
	LIB	?USEWDO			; utilise la fen. de l'ascenseur
	LIB	?GETWDO			; origine fentre ascenseur -> D3
	MOVE.32	D3,D5
	LIB	?IFMOUSE		; position souris -> D4
	SUB.16	D5,D4
	SWAP.32	D5
	SWAP.32	D4
	SUB.16	D5,D4
	SWAP.32	D4			; ajuste position de la souris

	MOVE.32	#{A6}+OASCENS,A5	; ^ascenseur -> A5
	SCROLL_	MOVE			; MOVE
	JUMP,NE	ACOTE$			; clic  ct => ACOTE$
	COMP.8	#SCROLLFUP,D4
	JUMP,EQ	SCROLLFL$
	COMP.8	#SCROLLFDOWN,D4
	JUMP,EQ	SCROLLFL$
	COMP.8	#SCROLLPUP,D4
	JUMP,EQ	SCROLLFL$
	COMP.8	#SCROLLPDOWN,D4
	JUMP,EQ	SCROLLFL$
	MOVE.16	{A5}+OSCPOSV,D4		; pos. virtuelle -> D4
	MUL.16	{A6}+OFACTDIV,D4	; mult. par le facteur de division
	MOVE.32	A1,A5			; ^buffer -> A5
	CALL	EXDEPL
	CALL	VAPOSN			; positionne le curseur

	CALL	DEBLIGNE		; met le curseur en debut de ligne
	CLR.16	D3

FIN$:	POP.16	D5
	LIB	?USEWDO			; rutilise l'ancienne fentre
	POPM.32	D3|D4|D5|A1|A4|A5
	JUMP	XMAIN

HORS$:	POP.16	D5
	LIB	?USEWDO			; rutilise l'ancienne fentre
	POPM.32	D3|D4|D5|A1|A4|A5
	MOVE.16	#KEYMGP,D3
	TEST.8	{A6}+OMODE+1:#BEPROQCLIC
	JUMP,BC	XMAIN
	JUMP	NMAIN

; clic dans le texte ou ailleurs

ACOTE$:
	MOVE.16	{A6}+ONOWDT,D5
	LIB	?USEWDO
	CALL	IFMOUSEC
	JUMP,NE	HORS$

	MOVE.32	#{A6}+OBUFF,A5
	CALL	EXDEPL
	CLR.32	D5
	MOVE.16	{A5}+OCURS,D5
	DIV.16	{A6}+OCY,D5
	SUB.16	D5,D4		; dy -> D4

	MOVE.16	D3,D0
	MOVE.16	D4,D1

	CLR.8	D5
	TEST.16	D1
	JUMP,PL	VERT0$
	NEG.16	D1
	INC.32	D5

VERT0$:	CALL	DEBLIGNE
	TEST.16	D1
	JUMP,EQ	VERT$
	CLR.16	{A6}+OOFFSET

VERT$:	DEC.16	D1
	JUMP,MI	FVERT0$
	TEST.8	D5
	JUMP,EQ	DOWN$

UP$:	CALL	RECULE
	COMP.16	#ERBOB,D7
	JUMP,EQ	FVERT0$
	CALL	IFEOL
	JUMP,EQ	VERT$
	JUMP	UP$

DOWN$:
	CALL	AVANCE
	COMP.16	#EREOB,D7
	JUMP,EQ	FVERT0$
	CALL	IFEOL
	JUMP,EQ	VERT$
	JUMP	DOWN$

FVERT0$:
	CALL	DEBLIGNE
	ADD.16	{A6}+OOFFSET,D0
	AND.16	#16'FFF,D0	; BEURK !!! OOFFSET contient parfois des valeurs trs grandes ?!
	CLR.16	D1		; largeur d'cran max avec ce systme = 4095
	MOVE.16	D0,D5
	DEC.16	D5

FVERT$:
	DEC.16	D0
	JUMP,MI	FHOR$
	COMP.16	D5,D1
	JUMP,HI	FHOR$
	CALL	AVANCE
	COMP.8	#TAB,D3
	JUMP,NE	NOTAB$
	ADD.16	#8,D1
	AND.16	#16'FFF8,D1
	COMP.16	D5,D1
	JUMP,LS	FVERT$
	JUMP	FHOR$

NOTAB$:	INC.16	D1
	CALL	IFEOL
	JUMP,EQ	VERT2$
	JUMP	FVERT$

VERT2$:
	CALL	RECULE
FHOR$:
	JUMP	FIN$

SCROLLFL$:
	SCROLL_	PRESS
	MOVE.8	D4,{A6}+OSCROLLFL
	JUMP	FIN$



;----------\
; IFMOUSEC  >
;==========/

; comme IFMOUSE, mais rend les coordonnes en caractres

; in	-
; out	D3.16	x
;	D4.16	y
;	EQ => dans la fentre de texte
;	NE => hors de la fentre de texte
; mod	D3.16, D4.16

IFMOUSEC:
	PUSHM.32 D1|D2|D5
	LIB	?GETWDO
	MOVE.32	D4,D2
	PUSH.32	D3
	LIB	?IFMOUSE
	POP.32	D3
	MOVE.16	{A6}+OCX,D1
	SR.16	#1,D1
	SUB.16	D1,D3
	SUB.16	D3,D4
	COMP.16	D2,D4
	JUMP,HI	HORS$	; hors du texte
	SWAP.32	D3
	SWAP.32	D4
	SUB.16	D3,D4
	SWAP.32	D2
	COMP.16	D2,D4
	JUMP,HI	HORS$	; hors du texte
	SWAP.32	D4

	MOVE.32	D4,D3
	AND.32	#16'FFFF,D3
	DIV.16	{A6}+OCX,D3
	DEC.16	D3
	JUMP,PL	POSIT$
	CLR.16	D3

POSIT$:
	SWAP.32	D4
	AND.32	#16'FFFF,D4
	DIV.16	{A6}+OCY,D4
	SETZ

FIN$:	POPM.32	D1|D2|D5
	RET

HORS$:
	CLRZ
	JUMP	FIN$



;--------\
; VAPOSN  >
;========/

; in	D4.32	no. du caractre o il faut aller
; out	D7.16	erreur
; mod	-

VAPOSN:
	PUSHM.32 D3|D4|D5|A4

	MOVE.32	{A5}+OPDT,D3
	SUB.32	{A5}+OPDB,D3
	MOVE.32	{A5}+OPFB,D5
	SUB.32	{A5}+OPFT,D5
	ADD.32	D3,D5
	JUMP,EQ	FIN$

	COMP.16	D3,D4
	JUMP,LO	DEPL$

	MOVE.32	{A5}+OPFT,D3
	SUB.32	{A5}+OPDT,D3
	ADD.32	D3,D4

DEPL$:	MOVE.32	D4,A4
	ADD.32	{A5}+OPDB,A4
	CALL	VAQQPART

FIN$:	POPM.32	D3|D4|D5|A4
	RET



; va au debut de la ligne

DEBLIGNE:
	PUSHM.32 D4|A4
	MOVE.32	{A5}+OPDT,A4

	CALL	PVISU
	CALL	IFEOL
	JUMP,EQ	FIN$

LOOP$:	CALL	RECULE
	CALL	IFEOL
	JUMP,EQ	FIN1$
	COMP.16	#ERBOB,D7
	JUMP,NE	LOOP$

FIN$:	POPM.32	D4|A4
	RET

FIN1$:	CALL	AVANCE
	JUMP	FIN$


; va  la fin de la ligne

FINLIGNE:
	PUSHM.32 D4|A4
	MOVE.32	{A5}+OPDT,A4

	CALL	NVISU
	CALL	IFEOL
	JUMP,EQ	FIN$

LOOP$:	CALL	AVANCE
	CALL	IFEOL
	JUMP,EQ	FIN1$

	COMP.16	#EREOB,D7
	JUMP,NE	LOOP$

FIN$:	POPM.32	D4|A4
	RET

FIN1$:	CALL	RECULE
	JUMP	FIN$


;-----------\\
; EPRO_CLOSE >
;===========/

; Termine l'dition d'un texte.
; Bouche le buffer et ferme tout.

; in	D6.L	canal
; out	A3.L	^dbut du texte (termin par zro)
;	A4.L	^position du curseur
;	D3.L	longueur max du buffer
; mod	D3.L, D7.W, A3.L, A4.L

_EPRO_CLOSE:
	PUSHM.32 D1|D5|A2|A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	INKCURS		; MOD. FJ. efface le curseur

; Dtruit les sous-fentres.

	TEST.8	{A6}+OMODE+3:#BEPRONI ; affiche les infos ?
	JUMP,BS	L30$		; non => 30$
	MOVE.16	{A6}+ONOWDI,D5	; oui =>
	LIB	?KILWDO		; dtruit swdo informations
L30$:	MOVE.16	{A6}+ONOWDT,D5
	LIB	?KILWDO		; dtruit swdo texte
	TEST.8	{A6}+OMODE+3:#BEPROMOUSE
	JUMP,BC	L35$
	MOVE.16	{A6}+ONOWDA,D5
	LIB	?KILWDO		; dtruit swdo texte

L35$:
; Bouche le trou et termine le texte par un zro.
	MOVE.32	{A5}+OPDT,A3
	MOVE.32	{A5}+OPFT,A4
L40$:	COMP.32	{A5}+OPFB,A4
	JUMP,EQ	L50$
	MOVE.8	{A4+},{A3+}	; bouche le trou
	JUMP	L40$
L50$:	CLR.8	{A3}		; termine texte par zro

	BLOC_	CLOSE
	JUMP,NE	NOCL$
	MOVE.16	{A6}+OCHBLOC,D1
	LIB_	CLOSE
NOCL$:

; Rend les mmes paramtres que ceux donns lors du EPRO_OPEN.

	MOVE.32	{A5}+OPDB,A3	; A3 <-- ^dbut du buffer
	MOVE.32	{A5}+OPDT,A2	; A2 <-- ^position curseur
	MOVE.32	{A5}+OPFB,D3
	SUB.32	A3,D3		; D3 <-- lg max du buffer

; Rend la mmoire des variables.

	MOVE.32	A6,A4		; A4 <-- ^zone de variables
	MOVE.32	#MTYPCP,D1	; D1 <-- type
	GESMEM	?GIVMEM	; rend la mmoire
	MOVE.32	A2,A4		; A4 <-- ^position curseur
	POPM.32	D1|D5|A2|A5|A6
	RET


;------------\\
; EPRO_NVISU  >
;============/

; Observe le caractre suivant.

; in	D6.L	canal
;	A4.L	^dans un buffer
; out	D7.W	zro =>
;	 D3.B	 caractre
;	 A4.L	 ^plus loin
;	D7.W	ERHOL => trou rencontr (et saut)
;	 A4.L	 ^plus loin
;	D7.W	EREOB => on ne peut plus avancer
; mod	D3.W, D7.W, A4.L

_EPRO_NVISU:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	NVISU
	POPM.32	A5|A6
	RET


;------------\\
; EPRO_PVISU  >
;============/

; Observe le caractre prcdent.

; in	D6.L	canal
;	A4.L	^dans un buffer
; out	D7.W	zro =>
;	 D3.B	 caractre
;	 A4.L	 ^moins loin
;	D7.W	ERHOL => trou rencontr (et saut)
;	 A4.L	 ^moins loin
;	D7.W	ERBOB => on ne peut plus reculer
; mod	D3.W, D7.W, A4.L

_EPRO_PVISU:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	PVISU
	POPM.32	A5|A6
	RET


;------------\\
; EPRO_VAFIN  >
;============/

; Avance jusqu' la fin.

; in	D6.L	canal
; out	-
; mod	D7.W

_EPRO_VAFIN:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	VAFIN
	POPM.32	A5|A6
	RET


;-------------\\
; EPRO_VADEBUT >
;=============/

; Recule jusqu'au dbut.

; in	D6.L	canal
; out	-
; mod	D7.W

_EPRO_VADEBUT:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	VADEBUT
	POPM.32	A5|A6
	RET


;------------\\
; EPRO_AVANCE >
;============/

; Avance d'un caractre.

; in	D6.L	canal
; out	D7.W	zro =>
;	 D3.B	 caractre avanc
;	D7.W	EREOB => fin du buffer
; mod	D3.W, D7.W

_EPRO_AVANCE:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	AVANCE
	POPM.32	A5|A6
	RET


;------------\\
; EPRO_RECULE >
;============/

; Recule d'un caractre.
; in	D6.L	canal
; out	D7.W	zro =>
;	 D3.B	 caractre recul
;	D7.W	ERBOB => dbut du buffer
; mod	D3.W, D7.W

_EPRO_RECULE:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	RECULE
	POPM.32	A5|A6
	RET


;------------\\
; EPRO_INSERT >
;============/

; Insre un caractre.
; in	D6.L	canal
;	D3.B	caractre  insrer
; out	D7.W	zro => ok
;	D7.W	ERPDP => buffer plein
; mod	D7.W

_EPRO_INSERT:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	INSERT
	POPM.32	A5|A6
	RET


;-------------\\
; EPRO_DAVANCE >
;=============/

; Dtruit un caractre en avant.
; in	D6.L	canal
; out	D7.W	zro =>
;	 D3.B	 caractre dtruit
;	D7.W	EREOB => fin du buffer
; mod	D3.W, D7.W

_EPRO_DAVANCE:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	DAVANCE
	POPM.32	A5|A6
	RET



;-------------\\
; EPRO_DRECULE >
;=============/

; Dtruit un caractre en arrire.

; in	D6.L	canal
; out	D7.W	zro =>
;	 D3.B	 caractre dtruit
;	D7.W	ERBOB => dbut du buffer
; mod	D3.W, D7.W

_EPRO_DRECULE:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	DRECULE
	POPM.32	A5|A6
	RET


;------------\\
; EPRO_FLUSH  >
;============/

; Vide compltement le texte.

; in	D6.L	canal
; out	-
; mod	D7.W

_EPRO_FLUSH:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	FLUSH
	POPM.32	A5|A6
	RET


;------------\\
; EPRO_GETPTC >
;============/

; Donne le caractre sous le curseur et le pointeur
; pour NVISU et PVISU.

; in	D6.L	canal
; out	A4.L	^pour NVISU et PVISU
;	D7.W	zro => ok
;	 D3.B	 caractre
;	D7.W	EREOB => fin du buffer
; mod	D3.W, D7.W, A4.L

_EPRO_GETPTC:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	GETPTC
	MOVE.32	{A5}+OPFT,A4	; A4 <-- ^FT
	POPM.32	A5|A6
	RET


;------------\\
; EPRO_IFEOL  >
;============/

; Test si un caractre est une fin de ligne.
; in	D6.L	canal
; in	D3.B	caractre
; out	EQ	fin de ligne
;	NE	autre chose
; mod	-

_EPRO_IFEOL:
	PUSHM.32 A5|A6
	MOVE.32	D6,A6		; A6 <-- ^variables
	MOVE.32	#{A6}+OBUFF,A5	; A5 <-- ^descripteur buffer
	CALL	IFEOL
	POPM.32	A5|A6
	RET



; Gestion des accents
; -------------------

XCIRCON:MOVE.16	#CIRCON,D4	; met un circonflxe
	JUMP	R8^XACCENT
XTREMA:	MOVE.16	#TREMA,D4	; met qq chose comme un trma
;	JUMP	XACCENT
XACCENT:CALL	EXOTHER		; action non rcuprable
	CALL	GETPTC		; D3 <-- car "sous" le curseur
	JUMP,NE	L50$		; rien => 50$
	CALL	GETACCENT	; calcul lettre accentue
	JUMP,NE	L50$		; n'existe pas => 50$
				; existe =>
	TEST.8	D3
	JUMP,EQ	L50$
	PUSH.16	D3
	CALL	DAVANCE		; dtruit lettre non accentue
	POP.16	D3
	CALL	INSERT		; remplace par lettre accentue
	JUMP	R8^L90$
L50$:	MOVE.16	D4,D3		; D3 <-- accent
	CALL	INSERT		; insert un accent tout seul
	CALL	RECULE		; puis recule "dessus"
	TSET.8	{A6}+OFLAGS:#BACC
L90$:	RET


;--------\\
; ACCENT  >
;========/

; Caractre aprs un accent flottant frapp.

; in	D3.B	caractre aprs accent
; out	D7.W	erreur
; mod	D7.W

ACCENT:	PUSHM.32 D3|D4
	TCLR.8	{A6}+OFLAGS:#BACC ; clear flag des accents
	MOVE.16	D3,D4
	CALL	GETPTC		; D3 <-- cherche car prcdent tap
	EX.32	D4,D3		; D4 <-- accent, D3 <-- car qui ira "sous"
	CALL	GETACCENT	; accent existe ?
	JUMP,NE	L40$		; non => 40$
				; oui =>
	TEST.8	D3		; laisse l'accent seul ?
	JUMP,EQ	L40$		; oui => 40$
				; non =>
	PUSH.16	D3
	CALL	DAVANCE		; dtruit l'accent seul
	POP.16	D3
	CALL	INSERT		; remplace par lettre accentue
	JUMP	R8^L90$
L40$:	PUSH.16	D7
	CALL	AVANCE		; saute '^' ou '"'
	POP.16	D7
L90$:	POPM.32	D3|D4
	TEST.16	D7		; retour EQ/NE
	RET


;----------\\
; GETACCENT >
;==========/

; Calcul le code correspondant  une lettre (a,e,i,o,u) et 
; un accent (^,").

; in	D4.B	accent (^,")
;	D3.B	caractre
; out	D7.W	zro => ok (lettre accentue existe)
;	 D3.B	 lettre accentue
;	D7.W	ERNOT => lettre accentue n'existe pas
;	 D3.B	 caractre qui devait aller sous l'accent
; mod	D3.B, D7.W

GETACCENT:
	PUSH.32	A3
	MOVE.32	#R16^TABACCENT-3,A3
L10$:	ADD.32	#3,A3		; A3 <-- ^suivant dans table
	TEST.8	{A3}		; fin de la table ?
	JUMP,EQ	L50$		; oui => 50$
	COMP.8	{A3},D3		; lettre trouve dans table ?
	JUMP,NE	L10$		; non => 10$
				; oui =>
	COMP.8	#CIRCON,D4
	JUMP,EQ	L30$
	COMP.8	#TREMA,D4
	JUMP,NE	L50$
	MOVE.8	{A3}+2,D3	; D3 <-- lettre accentue (")
	CLR.16	D7		; D7 <-- ok
	JUMP	R8^L90$
L30$:	MOVE.8	{A3}+1,D3	; D3 <-- lettre accentue (^)
	CLR.16	D7		; D7 <-- ok
	JUMP	R8^L90$
L50$:	MOVE.16	#ERNOT,D7	; D7 <-- erreur
L90$:	POP.32	A3
	TEST.16	D7		; retour EQ/NE
	RET


TABACCENT:
	.8	"a","",""
	.8	"e","",""
	.8	"i","",""
	.8	"o","",""
	.8	"u","",""
	.8	SPACE,0,0
	.8	KCIRCON,"^","^"
	.8	KTREMA,"""",""""
	.8	0
	.EVEN 


;-----------\\
; EXNOACCENT >
;===========/

; Annule l'effet d'un ventuel accent flottant tap, alors
; que la lettre devant aller "desous" n'a pas encore t
; tape.

EXNOACCENT:
	TCLR.8	{A6}+OFLAGS:#BACC
	JUMP,BC	L90$
	PUSH.16	D3
	CALL	AVANCE		; saute l'accent flottant
	POP.16	D3
L90$:	RET



; touche (CURSOR)
; ---------------

OCURSOR:
	CALL	EXKEY
	.16.16	"F",DCARAC		; +1 caractre
	.16.16	"G",DCHAMP		; +1 mot
	.16.16	"C",DLIGNE		; +1 ligne
	.16.16	  3,DLIGNE		; +1 ligne
	.16.16	"X",D4LIGNE		; +4 lignes
	.16.16	"Y",DPAGE		; +1 page
	.16.16	"V",DBUFFER		; fin du texte
	.16.16	"D",DBCARAC		; -1 caractre
	.16.16	"S",DBCHAMP		; -1 mot
	.16.16	"R",DBLIGNE		; -1 ligne
	.16.16	 18,DBLIGNE		; -1 ligne
	.16.16	"E",DB4LIGNE		; -4 lignes
	.16.16	"W",DBPAGE		; -1 page
	.16.16	"T",DBBUFFER		; dbut du texte
	.16.16	SPACE,INSCOLLE

	.16.16	0,NMAIN

DBUFFER:CALL	EXDEPL		; signal dplacement
	JUMP	VAFIN
D4LIGNE:CALL	EXDEPL		; signal dplacement
	MOVE.8	#2,D4		; classe 2 (saut de lignes)
	MOVE.8	#NBMYLI,D0	; 4 fois
L10$:	CALL	BORNAV
	DEC.8	D0
	JUMP,NE	L10$
	RET
DPAGE:	INC.8	D4		; classe 3
DLIGNE:	INC.8	D4		; classe 2
DCHAMP:	INC.8	D4		; classe 1
DCARAC:	CALL	EXDEPL		; signal dplacement
	JUMP	BORNAV
DBBUFFER:
	CALL	EXDEPL		; signal dplacement
	JUMP	VADEBUT
DB4LIGNE:
	CALL	EXDEPL		; signal dplacement
	MOVE.8	#2,D4		; classe 2 (saut de lignes)
	MOVE.8	#NBMYLI,D0	; 4 fois
L10$:	CALL	BORNAR
	DEC.8	D0
	JUMP,NE	L10$
	RET
DBPAGE:	INC.8	D4		; classe 3
DBLIGNE:INC.8	D4		; classe 2
DBCHAMP:INC.8	D4		; classe 1
DBCARAC:CALL	EXDEPL		; signal dplacement
	JUMP	BORNAR



; touche (SHOW)
; ---------------
OSHOW:	CALL	EXKEY
	.16.16	SPACE,CLASSEUR
	.16.16	CR,SHOWCR
	.16.16	LF,SHOWLF
	.16.16	TAB,SHOWTAB
	.16.16	0,NMAIN


SHOWCR:	TSET.8	{A6}+OMODE+3:#BEPROAFCR
	MOVE.8	#MODALL,{A6}+OBUFF+OMODIF
	RET

SHOWTAB:TSET.8	{A6}+OMODE+2:#BEPROAFTAB
	MOVE.8	#MODALL,{A6}+OBUFF+OMODIF
	RET

SHOWLF:	TSET.8	{A6}+OMODE+2:#BEPROAFLF
	MOVE.8	#MODALL,{A6}+OBUFF+OMODIF
	RET


; touche (KILL)
; ---------------
OKILL:	CALL	EXKEY
	.16.16	CR,KILLCR
	.16.16	LF,KILLLF
	.16.16	TAB,KILLTAB
	.16.16	0,NMAIN


KILLCR:	TCLR.8	{A6}+OMODE+3:#BEPROAFCR
	MOVE.8	#MODALL,{A6}+OBUFF+OMODIF
	RET

KILLTAB:TCLR.8	{A6}+OMODE+2:#BEPROAFTAB
	MOVE.8	#MODALL,{A6}+OBUFF+OMODIF
	RET

KILLLF:	TCLR.8	{A6}+OMODE+2:#BEPROAFLF
	MOVE.8	#MODALL,{A6}+OBUFF+OMODIF
	RET





; touches (KILL-CURSOR)
; ---------------------
OKILLCURS:
	CALL	EXKEY
	.16.16	"F",KCARAC		; +1 caractre
	.16.16	"G",KCHAMP		; +1 mot
	.16.16	"C",KLIGNE		; +1 ligne
	.16.16	"X",K4LIGNE		; +4 lignes
	.16.16	"Y",KPAGE		; +1 page
	.16.16	"V",KTOUT		; fin du texte
	.16.16	"D",KBCARAC		; -1 caractre
	.16.16	"S",KBCHAMP		; -1 mot
	.16.16	"R",KBLIGNE		; -1 ligne
	.16.16	"E",KB4LIGNE		; -4 lignes
	.16.16	"W",KBPAGE		; -1 page
	.16.16	"T",KBTOUT		; dbut du texte
	.16.16	0,NMAIN
K4LIGNE:CALL	EXKILL		; signal destruction
	MOVE.8	#2,D4		; classe 2 (saut de lignes)
	MOVE.8	#NBMYLI,D0	; 4 fois
L10$:	CALL	BORNAV
	DEC.8	D0
	JUMP,NE	L10$
	RET
KTOUT:	INC.8	D4		; classe 4
KPAGE:	INC.8	D4		; classe 3
KLIGNE:	INC.8	D4		; classe 2
KCHAMP:	INC.8	D4		; classe 1
KCARAC:	CALL	EXKILL		; signal destruction
	JUMP	BORNAV
KB4LIGNE:
	CALL	EXKILL		; signal destruction
	MOVE.8	#2,D4		; classe 2 (saut de lignes)
	MOVE.8	#NBMYLI,D0	; 4 fois
L10$:	CALL	BORNAR
	DEC.8	D0
	JUMP,NE	L10$
	RET
KBTOUT:	INC.8	D4		; classe 4
KBPAGE:	INC.8	D4		; classe 3
KBLIGNE:INC.8	D4		; classe 2
KBCHAMP:INC.8	D4		; classe 1
KBCARAC:CALL	EXKILL		; signal destruction
	JUMP	BORNAR



; touche SEARCH
; -------------

OSEARCH:
	TEST.8	{A6}+OLINECH
	JUMP,EQ	FIN$
	CALL	EXKEY
	.16.16	"F",SEAV
	.16.16	"D",SEAR
	.16.16	0,NMAIN

FIN$:	RET

SEAV:	CALL	CHAV1
	RET

SEAR:	CALL	CHAR1
	RET


; touche CHANGE
; -------------

OCHANGE:
	TEST.8	{A6}+OLINECH
	JUMP,EQ	FIN$
	CALL	EXKEY
	.16.16	"F",CHGAV
	.16.16	"D",CHGAR
	.16.16	0,NMAIN

FIN$:	RET

CHGAV:	CALL	RECULE
	MOVE.16	D7,D0
	CALL	CHAV1
	JUMP,EQ	REMP
	COMP.16	#ERBOB,D0
	JUMP,EQ	RETCHG
	CALL	AVANCE
	RET

CHGAR:	CALL	CHAR1
	JUMP,NE	RETCHG
REMP:	CALL	REMPLACE
FCHG:	MOVE.32	#EPROMODALL,D4
	CALL	MODIF
RETCHG:	RET


;---------\
; REMPLACE >
;=========/

; remplace la chane trouve par la chane de substitution

; in	-
; out	-
; mod	-

REMPLACE:
	MOVE.32	#{A6}+OLINECH,A3

	CALL	EXOTHER

DEL$:	TEST.8	{A3+}
	JUMP,EQ	FIN$
	CALL	DAVANCE
	JUMP	DEL$
FIN$:
	MOVE.32	#{A6}+OLINEREMP,A3

INS$:	MOVE.8	{A3+},D3
	JUMP,EQ	RET$
	CALL	INSERT
	JUMP	INS$

RET$:
	MOVE.8	#EPROMODLIN,D4
	CALL	MODIF
	RET




; Rcupration
; ------------

;--------\\
; EXKILL  >
;========/

; Signal qu'une destruction va tre faite.

; in	-
; out	-
; mod	-

EXKILL:	COMP.8	#2**BRECK,{A5}+ORECUP
	JUMP,EQ	L90$
	MOVE.8	#2**BRECK,{A5}+ORECUP
	MOVE.32	{A5}+OPDT,{A5}+ORECP1
	MOVE.32	{A5}+OPFT,{A5}+ORECP2
L90$:	RET


;--------\\
; EXDEPL  >
;========/

; Signal qu'un dplacement va tre fait.

; in	-
; out	-
; mod	-

EXDEPL:	COMP.8	#2**BRECD,{A5}+ORECUP
	JUMP,EQ	L90$
	MOVE.8	#2**BRECD,{A5}+ORECUP
	MOVE.32	{A5}+OPDT,{A5}+ORECP1
	MOVE.32	{A5}+OPFT,{A5}+ORECP2
L90$:	RET


;--------\\
; EXOTHER >
;========/

; Signal qu'une chose non rcuprable va tre faire.

; in	-
; out	-
; mod	-

EXOTHER:CLR.8	{A5}+ORECUP
	RET


;--------\\
; EXRECUP >
;========/

; Rcupre une destruction ou un dplacement.

; in	-
; out	-
; mod	D7.W

EXRECUP:PUSHM.32 D3|D4|A4
	COMP.8	#2**BRECK,{A5}+ORECUP
	JUMP,EQ	L40$
	COMP.8	#2**BRECD,{A5}+ORECUP
	JUMP,EQ	L20$
	MOVE.32	#BIPLIT,D3
	LIB	?BEEP	; p'tit bruit
	JUMP	R8^L90$
L20$:				; DEPLACEMENT =>
	MOVE.32	{A5}+ORECP1,A4
	COMP.32	{A5}+OPDT,A4
	JUMP,LO	L30$
	MOVE.32	{A5}+ORECP2,A4
L30$:	CALL	VAQQPART	; revient position initiale
	JUMP	R8^L80$
L40$:				; DESTRUCTION =>
	MOVE.32	{A5}+ORECP1,{A5}+OPDT
	MOVE.32	{A5}+ORECP2,{A5}+OPFT
	MOVE.8	#MODALL,D4
	CALL	MODIF		; signal type de modification
L80$:	CALL	EXOTHER		; une seule rcupration
L90$:	POPM.32	D3|D4|A4
	RET


; Routines gnrales de "dplacement"
; -----------------------------------

;-------\\
; BORNAV >
;=======/

; Cherche en avant dans un buffer un caractre selon la classe.
; Traite les cas :
;	(CURSOR)		dplacement
;	(CURSOR-KILL)		dplacement avec destruction
; in	D4.B	classe
; out	-
; mod	-

BORNAV:	PUSHM.32 D1|D2|D3|D4|A2|A3|A4
	CALL	INITCLASS	; A2/D2 <-- dlimiteurs
	MOVE.32	#1,D1		; D1 <-- amplitude d'un
	TEST.8	D4		; dplacement d'un caractre ?
	JUMP,NE	L30$		; oui => 30$
				; non =>
	MOVE.32	{A5}+OPFT,A4	; A4 <-- ^dans texte
	CLR.32	D1		; D1 <-- amplitude
	COMP.8	#CR,{A2}	; classe 2 (ligne) ?
	JUMP,EQ	L15$		; oui => 15$
L10$:	CALL	NVISU		; saute n sparateurs
	JUMP,NE	L30$
	INC.32	D1		; D1 <-- augmente amplituce
	CALL	TSTCLASS	; dlimiteur ?
	JUMP,EQ	L10$		; oui => 10$
	JUMP	R8^L20$
L15$:	CALL	NVISU
	JUMP,NE	L30$
	INC.32	D1		; D1 <-- augmente amplituce
L20$:	CALL	NVISU		; avance sur le 1er sp.
	JUMP,NE	L30$
	INC.32	D1		; D1 <-- augmente amplituce
	CALL	TSTCLASS	; dlimiteur ?
	JUMP,NE	L20$		; non => 20$
	DEC.32	D1
L30$:	COMP.8	#2**BRECD,{A5}+ORECUP
	JUMP,EQ	L40$
	COMP.8	#2**BRECK,{A5}+ORECUP
	JUMP,EQ	L50$
	JUMP	R8^L90$
L40$:				; <--- (CURSOR)
	TEST.32	D1
	JUMP,EQ	L90$
	DEC.32	D1
	CALL	AVANCE		; avance D1 fois
	JUMP	L40$
L50$:				; <--- (CURSUR-KILL)
	TEST.32	D1
	JUMP,EQ	L90$
	DEC.32	D1
	CALL	DAVANCE		; dtruit D1 caractres
	JUMP	L50$
L90$:	POPM.32	D1|D2|D3|D4|A2|A3|A4
	RET


;-------\\
; BORNAR >
;=======/

; Cherche en avant dans un buffer un caractre selon la classe.
; Traite les cas :
;	(CURSOR)		dplacement
;	(CURSOR-KILL)		dplacement avec destruction
; in	D4.B	classe
; out	-
; mod	-

BORNAR:	PUSHM.32 D1|D2|D3|D4|A2|A3|A4
	CALL	INITCLASS	; A2/D2 <-- dlimiteurs
	MOVE.32	#1,D1		; D1 <-- amplitude d'un
	TEST.8	D4		; dplacement d'un caractre ?
	JUMP,NE	L30$		; oui => 30$
				; non =>
	MOVE.32	{A5}+OPDT,A4	; A2 <-- ^dans texte
	CLR.32	D1		; D1 <-- amplitude
	COMP.8	#CR,{A2}	; classe 2 (ligne) ?
	JUMP,EQ	L15$		; oui => 15$
L10$:	CALL	PVISU		; recule n sparateurs
	JUMP,NE	L30$
	INC.32	D1		; D1 <-- augmente amplitude
	CALL	TSTCLASS	; dlimiteur ?
	JUMP,EQ	L10$		; oui => 10$
	JUMP	R8^L20$
L15$:	CALL	PVISU
	JUMP,NE	L30$
	INC.32	D1		; D1 <-- augmente amplitude
L20$:	CALL	PVISU		; recule au dernier non dlim.
	JUMP,NE	L30$
	INC.32	D1		; D1 <-- augmente amplitude
	CALL	TSTCLASS	; dlimiteur ?
	JUMP,NE	L20$		; non => 20$
	DEC.32	D1
L30$:	COMP.8	#2**BRECD,{A5}+ORECUP
	JUMP,EQ	L40$
	COMP.8	#2**BRECK,{A5}+ORECUP
	JUMP,EQ	L50$
	JUMP	R8^L90$
L40$:				; <-- (CURSOR)
	TEST.32	D1
	JUMP,EQ	L90$
	DEC.32	D1
	CALL	RECULE		; recule D1 fois
	JUMP	L40$
L50$:				; <--- (CURSOR-KILL)
	TEST.32	D1
	JUMP,EQ	L90$
	DEC.32	D1
	CALL	DRECULE		; dtruit D1 caractres
	JUMP	L50$
L90$:	POPM.32	D1|D2|D3|D4|A2|A3|A4
	RET


; Test des dlimiteurs
; --------------------

;----------\\
; INITCLASS >
;==========/

; Initialise le pointeur aux caractres terminateurs d'une
; classe ainsi le nombre de ces caractres.
; classe 1 :	mots
; classe 2 :	lignes
; classe 3 :	pages
; classe 4 :	buffer

; in	D4.B	classe
; out	A2.L	^aux caractres terminateurs
;	D2.W	nombre de caractres terminateurs
;	D4.B	diff de zro => dplacement d'un seul caractre
; mod	D4.B, D2.W, A2.L

INITCLASS:
	MOVE.32	{A6}+OPTCL1,A2	; A2 <-- ^fin de mots
	MOVE.16	{A6}+OLGCL1,D2
	DEC.8	D4
	JUMP,EQ	L90$		; si classe 1 => 90$
	MOVE.32	{A6}+OPTCL2,A2	; A2 <-- ^fin de lignes
	MOVE.16	{A6}+OLGCL2,D2
	DEC.8	D4
	JUMP,EQ	L90$		; si classe 2 => 90$
	MOVE.32	{A6}+OPTCL3,A2	; A2 <-- ^fin de pages
	MOVE.16	{A6}+OLGCL3,D2
	DEC.8	D4
	JUMP,EQ	L90$		; si classe 3 => 90$
	CLR.16	D2
	DEC.8	D4
L90$:	RET


;---------\\
; TSTCLASS >
;=========/

; Test si un caractre fait partie de la classe initialise.

; in	D3.B	caractre
;	A2.L	^aux caractres de la classe
;	D2.W	nombre de caractres de la classe
; out	D7.W	zro =>	le caractre est un dlimiteur
; mod	D7.W

TSTCLASS:
	PUSHM.32 D2|A2
	TEST.16	D2		; classe 4 ?
	JUMP,EQ	L80$		; oui => 80$
	CLR.16	D7		; D7 <-- trouv
	DEC.16	D2		; -1  cause du "DECJ.W,NMO"
L10$:	COMP.8	{A2+},D3	; dlimiteur ?
	JUMP,EQ	L90$		; oui => 90$
	DJ.16,NMO   D2,L10$
L80$:	MOVE.16	#ERNOT,D7	; D7 <-- erreur (pas trouv)
L90$:	POPM.32	D2|A2
	RET


;  ATTENTION:	La table pour la classe 1 doit commencer par
;  ---------	SPACE et celle pour la classe 2 doit commencer
;		par CR !
DEFCLASS:
	.8	SPACE,TAB	; classe 1
	.8	",",".",";",":","!","?"
	.8	"+","-","*","/"
	.8	0
	.8	CR		; classe 2
	.8	0
	.8	EOP		; classe 3
	.8	0
	.EVEN


; Gestion de l'affichage
; ----------------------


;--------\\
; AFFINFO >
;========/

; Met  jour l'affichage des informations en fonction
; du buffer de texte.

; in	A5.L	^description buffer
; out	-
; mod	D7.W

AFFINFO:PUSHM.32 D1|D2|D3|D4|D5|A3|A4
	TEST.8	{A6}+OMODE+3:#BEPRONI ; affiche les infos ?
	JUMP,BS	L90$		; non => 90$
				; oui =>

	MOVE.32	{A6}+OPDIS,A3
	MOVE.8	{A3}+ODFMGR,D0

	MOVE.16	{A6}+ONOWDI,D5
	LIB	?USEWDO	; utilise swdo des infos
	CLR.32	D3
	LIB	?SETCURS
	LIB	?BUCAR
	LIB	?AFTIM
	.8	NOCURS		; pas de curseur
	.8	AFINV		; vido inverse
	.8	MODGRA,GRACLIP2
	.8	0
	.EVEN

	MOVE.32	{A6}+OPNEDIT,A3
	LIB	?AFTEXT

	MOVE.32	{A6}+OTEXT1,A3
	LIB	?AFTEXT

	MOVE.16	#8,D3		; D3 <-- nb digits
	MOVE.16	#2**BAFDCM.OR.2**BAFDSP,D2; D2 <-- mode


	MOVE.32	#rUtilise,D1
	CALL	RESAFTEXT

	TEST.8	{A6}+OMODE+2:#BEPRONOUT
	JUMP,BS	NOUT$
	MOVE.32	{A5}+OPDT,D4
	SUB.32	{A5}+OPDB,D4
	MOVE.32	{A5}+OPFB,D5
	SUB.32	{A5}+OPFT,D5
	ADD.32	D5,D4
	LIB	?AFDEC	; affiche nb utiliss

	TEST.8	{A6}+OMODE+2:#BEPRONORE
	JUMP,BS	NOREST$
	MOVE.8	#"/",D3
	LIB	?AFCAR
	PUSH.32	D4
	MOVE.32	{A5}+OPFT,D4
	SUB.32	{A5}+OPDT,D4
	DEC.32	D4		; doit rester au moins un byte !
	LIB	?AFDEC	; affiche nb restants
	POP.32	D4

NOREST$:
	TEST.8	{A6}+OMODE+2:#BEPROPCENT
	JUMP,BC	NOUT$
	MOVE.32	{A5}+OPFB,D5
	SUB.32	{A5}+OPDB,D5
	CLR.32	D1
	COMP.32	#10000,D5
	JUMP,LO	AFP$
	MOVE.16	#3,D1
	COMP.32	#100000,D5
	JUMP,LO	AFP$
	MOVE.16	#6,D1
	COMP.32	#1000000,D5
	JUMP,LO	AFP$
	MOVE.16	#9,D1
AFP$:
	SR.32	D1,D4
	SR.32	D1,D5
	MUL.16	#100,D4
	DIV.16	D5,D4
	MOVE.16	#2,D3
	LIB	?AFSPACE
	AND.32	#16'FF,D4
	JUMP,EQ	NOUT$
	LIB	?AFDEC
	MOVE.8	#"%",D3
	LIB	?AFCAR
NOUT$:
	MOVE.32	{A6}+OTEXT2,A3
	LIB	?AFTEXT
	LIB	?GETCURS		; pos. curseur -> D3
	MOVE.32	{A6}+OPDIS,A4

	MOVE.32	#rTmouse,D1
	CALL	RESGETSTRING

	PUSH.32	A3
	MOVE.32	#-1,D1
CNT$:	INC.32	D1
	TEST.8	{A3+}
	JUMP,NE	CNT$
	POP.32	A3

	MUL.16	{A6}+OCX,D1		; longeur text souris -> D1
	CLR.32	D2
	MOVE.16	{A4}+ODFFDX,D2		; largeur fentre -> D2
	SUB.16	D1,D2			; position texte souris -> D2
	COMP.16	D3,D2			; inferieur  la pos. actuelle
	JUMP,LO	NOM$			; oui => NOM$
	SUB.16	D3,D2			; 
	DIV.16	{A6}+OCX,D2
	MOVE.8	#MSPACE,D3
	LIB	?AFCAR
	MOVE.8	D2,D3
	LIB	?AFCAR

	LIB	?AFTEXT

	MOVE.32	#rTmouse,D1
	CALL	RESGIVSTRING

NOM$:
	LIB	?AFTIM
	.8	MSPACE,200	; efface fin de la ligne
	.8	AFDIR		; vido normale
	.8	0
	.EVEN 

	MOVE.8	#MODGRA,D3
	LIB	?AFCAR
	MOVE.8	D0,D3
	LIB	?AFCAR
	LIB	?NOBUCAR	; remet mode normal
	CLR.16	D5
	LIB	?USEWDO	; utilise swdo principale
L90$:	POPM.32	D1|D2|D3|D4|D5|A3|A4
	RET


.if	0
TMOUSE:	.ASCIZ	"|position|divers|modifie|"
ETMOUSE:
.endif

TDEFNEDIT:
	.ASCII	" EPRO "
	.8	EPROREV+"0","."
	.8	EPROVERS+"0"
	.8	0
	.EVEN

TESPACES:
	.ASCIZE	"    "


;--------\\
; AFFBUF  >
;========/

; Met  jour l'affichage en fonction du buffer de texte
; en dessinant le minimum de choses.

; in	A5.L	^description du buffer  afficher
; out	-
; mod	D7.W

AFFBUF:	PUSHM.32 D3|D4|D5|D6|A2|A3|A4
	MOVE.16	{A6}+ONOWDT,D5
	LIB	?USEWDO	; utilise swdo du texte

	LIB	?GCHDIS	; D6 <-- canal cran
	MOVE.16	#TYPWDO,D3	; D3 <-- type fentre cran
	MOVE.16	#LGDIS2,D4	; D4 <-- longueur demande
	MOVE.32	#{A6}+OBUSTD,A4	; A4 <-- ^buffer
	FOS	?RSTATUS	; demande le status

	MOVE.32	{A4}+ODFPGC,A2	; A2 <-- ^dbut GENCAR
	MOVE.32	#{A2}+16'100,A2	; A2 <-- ^table des largeurs
	MOVE.16	{A6}+ONBL,D4	; D4 <-- nb lignes  afficher
	TCLR.8	{A5}+OFLAFF:#BAFEOT ; EOT pas encore affiche
	MOVE.32	#{A6}+OBUCAR,A3	; A3 <-- ^dbut buffer
	MOVE.8	#NOCURS,D3
	CALL	AFFBYTE		; plus de curseur
	MOVE.32	{A5}+OCURS,D3	; D3 <-- position du curseur
	CALL	INVCURS		; enlve le curseur
	MOVE.8	{A5}+OMODIF,D3	; D3 <-- type de modification
	JUMP,EQ	L80$
	COMP.8	#MODALL,D3
	JUMP,EQ	L50$
	COMP.8	#MODLIN,D3
	JUMP,EQ	L40$
	COMP.8	#MODCUR,D3
	JUMP,NE	L50$
				; CURSEUR DEPLACE =>
	CALL	SRCBAF		; A4 <-- ^dbut de l'affichage
	COMP.32	{A5}+OPDA,A4	; idem au dernier ?
	JUMP,EQ	L30$		; oui => 30$
				; non =>
	CALL	CALNUP		; reste qq chose  monter ?
	JUMP,NE	L20$		; non => 20$
	CALL	AFFDOWN		; monte et refait le bas
	JUMP	R8^L30$
L20$:	CALL	CALNDOWN	; reste qq chose  descendre ?
	JUMP,NE	L25$		; non => 25$
	CALL	AFFUP		; descend et refait le haut
	JUMP	R8^L30$
L25$:	CALL	AFFALL		; refait toutes les lignes
	JUMP	R8^L80$
L30$:	TCLR.8	{A5}+OFLAFF:#BAFEOT ; EOT pas encore affiche
	CALL	SRCLCU		; D3 <-- ligne o est le curseur
	CALL	AFFLINE		; refait juste cette ligne
	JUMP	R8^L80$
L40$:				; LIGNE MODIFIEE =>
	CALL	SRCBLI		; A4 <-- ^dbut ligne
	MOVE.16	{A5}+ONOL,D3	; D3 <-- no ligne
	CALL	AFFLINE		; affiche juste la bonne ligne
	JUMP	R8^L80$
L50$:				; TOUT MODIFIE =>
	CALL	SRCBAF		; A4 <-- ^dbut de l'affichage
	CALL	AFFALL		; refait toutes les lignes
L80$:	MOVE.32	{A5}+OCURS,D3	; D3 <-- position du curseur
	CALL	INVCURS		; remet le curseur
	CALL	AFFFLUSH	; vide reste du uffer
	CLR.8	{A5}+OMODIF	; affichage  jour
	CLR.16	D5
	LIB	?USEWDO	; utilise swdo principale
	POPM.32	D3|D4|D5|D6|A2|A3|A4
	RET


;--------\\
; AFFALL  >
;========/

; Affiche toutes les lignes de la fentre.

; in	A4.L	^dbut de l'affichage
;	A3.L	^dans buffer
;	A2.L	^table des largeurs des caractres
;	D4.W	nombre de lignes total
; out	A3.L	^dans buffer
; mod	D7.W, A3.L

AFFALL:	PUSHM.32 D2|D3|D4|A4
	MOVE.32	A4,{A5}+OPDA	; mm ^dbut affichage
	CLR.16	D3		; D3 <-- no ligne
L50$:	CALL	AFFLINE		; affiche une ligne
	INC.16	D3		; D3 <-- no ligne suivante
	DEC.16	D4
	JUMP,NE	L50$
	POPM.32	D2|D3|D4|A4
	RET


;--------\\
; AFFUP   >
;========/

; Affiche qq lignes en haut de la fentre.

; in	A4.L	^dbut de l'affichage
;	A3.L	^dans buffer
;	A2.L	^table des largeurs des caractres
;	D4.W	nombre de lignes total
;	D2.W	nombre de lignes  dessiner
; out	A3.L	^dans buffer
; mod	D7.W, A3.L

AFFUP:	PUSHM.32 D2|D3|D4|A4
	MOVE.8	#ROLLDOWN,D3
	CALL	AFFBYTE		; <rolldown>
	MOVE.16	D2,D3
	MUL.16	{A6}+OCY,D3	; D3 <-- nn
	EX.32	D3,D4
	CALL	AFFWORD		; <nn>
	EX.32	D4,D3
	MOVE.32	A4,{A5}+OPDA	; mm ^dbut affichage
	CLR.16	D3		; D3 <-- no ligne
L50$:	CALL	AFFLINE		; affiche une ligne
	INC.16	D3		; D3 <-- no ligne suivante
	DEC.16	D2
	JUMP,NE	L50$
	POPM.32	D2|D3|D4|A4
	RET


;--------\\
; AFFDOWN >
;========/

; Affiche qq lignes en bas de la fentre.

; in	A4.L	^dbut de l'affichage
;	A3.L	^dans buffer
;	A2.L	^table des largeurs des caractres
;	D4.W	nombre de lignes total
;	D2.W	nombre de lignes  dessiner
; out	A3.L	^dans buffer
; mod	D7.W, A3.L

AFFDOWN:PUSHM.32 D2|D3|D4|A4
	MOVE.8	#ROLLUP,D3
	CALL	AFFBYTE		; <rollup>
	MOVE.16	D2,D3
	MUL.16	{A6}+OCY,D3	; D3 <-- nn
	EX.32	D3,D4
	CALL	AFFWORD		; <nn>
	EX.32	D4,D3
	MOVE.32	A4,{A5}+OPDA	; mm ^dbut affichage
	SUB.16	D2,D4		; D4 <-- nb lignes ok
	CLR.16	D3		; D3 <-- no ligne
L10$:	CALL	SRCDOWN		; saute les lignes ok
	INC.16	D3		; D3 <-- no ligne suivante
	DEC.16	D4
	JUMP,NE	L10$
L50$:	CALL	AFFLINE		; affiche une ligne
	INC.16	D3		; D3 <-- no ligne suivante
	DEC.16	D2
	JUMP,NE	L50$
	POPM.32	D2|D3|D4|A4
	RET


;--------\\
; SRCLCU  >
;========/

; Cherche dans quelle ligne est le curseur.

; in	A5.L	^description buffer
; out	A4.L	^dbut ligne
;	D3.W	ligne o est le curseur
; mod	D3.W, D7.W, A4.L

SRCLCU:	PUSH.32	D4
	MOVE.32	{A5}+OPDA,A4	; A4 <-- ^dbut affichage
	CLR.16	D4
L10$:	CALL	NVISU		; D3 <-- caractre suivant
	JUMP,NE	L80$		; trou rencontr => 80$
	CALL	IFEOL		; fin de ligne ?
	JUMP,NE	L10$		; non => 10$
				; oui =>
	INC.16	D4		; D4 <-- no ligne suivante
	JUMP	L10$
L80$:	MOVE.16	D4,D3		; D3 <-- no ligne
	CALL	SRCBLI		; A4 <-- ^dbut ligne
	POP.32	D4
	RET


;--------\\
; CALNUP  >
;========/

; Calcul le nombre de lignes  dcaler contre le haut.
; in	A4.L	^dbut de l'affichage
;	D4.W	nombre de lignes
; out	D2.W	nombre de lignes  dcaler
;	D7.W	erreur
; mod	D2.W, D7.W

CALNUP:	PUSHM.32 D4|A4
	CLR.16	D2		; D2 <-- nb lignes  dcaler
L10$:	CLR.16	D7		; D7 <-- ok
	COMP.32	{A5}+OPDA,A4	; dbut affichage rejoint ?
	JUMP,EQ	L90$		; oui => 90$
	CALL	SRCUP		; A4 <-- ^ligne plus haute
	JUMP,NE	L90$
	INC.16	D2
	DEC.16	D4		; encore une ligne ?
	JUMP,NE	L10$		; oui => 10$
				; non =>
	MOVE.16	#ERBOB,D7
L90$:	POPM.32	D4|A4
	TEST.16	D7		; retour EQ/NE
	RET


;---------\\
; CALNDOWN >
;=========/

; Calcul le nombre de lignes  dcaler contre le bas.

; in	A4.L	^dbut de l'affichage
;	D4.W	nombre de lignes
; out	D2.W	nombre de lignes  dcaler
;	D7.W	erreur
; mod	D2.W, D7.W

CALNDOWN:
	PUSHM.32 D4|A4
	CLR.16	D2		; D2 <-- nb lignes  dcaler
L10$:	CLR.16	D7		; D7 <-- ok
	COMP.32	{A5}+OPDA,A4	; dbut affichage rejoint ?
	JUMP,EQ	L90$		; oui => 90$
	CALL	SRCDOWN		; A4 <-- ^ligne plus basse
	JUMP,NE	L90$
	INC.16	D2
	DEC.16	D4		; encore une ligne ?
	JUMP,NE	L10$		; oui => 10$
				; non =>
	MOVE.16	#EREOB,D7
L90$:	POPM.32	D4|A4
	TEST.16	D7		; retour EQ/NE
	RET


;--------\\
; SRCUP   >
;========/

; Cherche le dbut de la ligne prcdente (contre en haut).

; in	A4.L	^dans buffer
; out	A4.L	^une ligne plus haut
;	D7.W	erreur
; mod	D7.W, A4.L

SRCUP:	PUSH.16	D3
L05$:	CALL	PVISU		; recule un car. de toute faon
	JUMP,EQ	L10$		; ok => 10$
	COMP.16	#ERHOL,D7	; trou rencontr ?
	JUMP,EQ	L05$		; oui => 05$
	JUMP	R8^L90$		; non => 90$ (EOB)
L10$:	CALL	PVISU		; A4 <-- recule d'un caractre
	JUMP,EQ	L20$		; ok => 20$
	COMP.16	#ERHOL,D7	; trou rencontr ?
	JUMP,EQ	L10$		; oui => 10$
	CLR.16	D7		; non (EOB) => dbut ligne
	JUMP	R8^L90$
L20$:	CALL	IFEOL		; fin de ligne ?
	JUMP,NE	L10$		; non => 10$
				; oui =>
	CALL	NVISU		; A4 <-- ^dbut ligne
L90$:	POP.16	D3
	TEST.16	D7		; retour EQ/NE
	RET


;--------\\
; SRCDOWN >
;========/

; Cherche le dbut de la ligne suivante (contre en bas).
; in	A4.L	^dans buffer
; out	A4.L	^une ligne plus bas
;	D7.W	erreur
; mod	D7.W, A4.L

SRCDOWN:PUSH.16	D3
L10$:	CALL	NVISU		; A4 <-- avance d'un caractre
	JUMP,EQ	L20$		; ok => 20$
	COMP.16	#ERHOL,D7	; trou rencontr ?
	JUMP,EQ	L10$		; oui => 10$
	JUMP	R8^L90$
L20$:	CALL	IFEOL		; fin de ligne ?
	JUMP,NE	L10$		; non => 10$
L90$:	POP.16	D3
	TEST.16	D7		; retour EQ/NE
	RET


;--------\\
; SRCBAF  >
;========/

; Cherche le premier caractre  afficher dans le buffer de
; texte. Utilise l'algorithme suivant :
;  1) avance (contre en bas) de nb_lignes /2
;  2) remonte (contre en haut) de nb_lignes

; in	A5.L	^description du buffer
;	D4.W	nombre de lignes
; out	A4.L	^dbut d'une ligne dans buffer texte
; mod	D7.W, A4.L

SRCBAF:	PUSHM.32 D3|D4|D5
	MOVE.16	D4,D5		; D4 <-- nb lignes
	SR.16	D5		; D5 <-- nb lignes /2
; Descend de nb lignes sur deux.
	MOVE.32	{A5}+OPFT,A4
L10$:	CALL	NVISU		; descend ...
	JUMP,NE	L20$		; fin du buffer => 20$
	CALL	IFEOL		; fin de ligne ?
	JUMP,NE	L10$		; non => 10$
				; oui =>
	DEC.16	D5		; faut-il encore descendre ?
	JUMP,NE	L10$		; oui => 10$
; Remonte de nb lignes.
L20$:	CALL	PVISU		; remonte ...
	JUMP,EQ	L25$		; ok => 25$
	COMP.16	#ERHOL,D7	; trou rencontr ?
	JUMP,EQ	L20$		; oui => 20$
	JUMP	R8^L90$
L25$:	CALL	IFEOL		; fin de ligne ?
	JUMP,NE	L20$		; non => 20$
				; oui =>
	DEC.16	D4		; faut-il encore monter ?
	JUMP,NE	L20$		; oui => 20$
	CALL	NVISU		; A4 <-- ^dbut ligne
L90$:	POPM.32	D3|D4|D5
	RET


;--------\\
; SRCBLI  >
;========/

; Cherche le dbut de la ligne courante.

; in	A5.L	^description du buffer
; out	A4.L	^dbut ligne
; mod	D7.W, A4.L

SRCBLI:	PUSH.16	D3
	MOVE.32	{A5}+OPDT,A4	; A4 <-- ^DT
L10$:	CALL	PVISU		; recule ...
	JUMP,NE	L90$		; dbut du buffer => 90$
	CALL	IFEOL		; fin ligne prcdente ?
	JUMP,NE	L10$		; non => 10$
				; oui =>
	CALL	NVISU		; saute CR ou EOL
L90$:	POP.16	D3
	RET


;--------\\
; AFFLINE >
;========/

; Affiche une ligne sur l'cran.

; in	A5.L	^description du buffer
;	A4.L	^dans le buffer (dbut ligne)
;	A3.L	^dans buffer
;	D3.W	numro de la ligne
; out	A4.L	^dans le buffer (ligne suivante)
;	A3.L	^dans buffer
; mod	D7.W, A3.L, A4.L

AFFLINE:PUSHM.32 D1|D2|D3|D4
	CALL	AFFPLI		; positionne au dbut ligne
	MOVE.16	D3,D4		; D4 <-- no ligne
	CALL	CALOFFSET	; dcalage de la ligne ?
	TEST.16	D2		; dcalage nul ?
	JUMP,EQ	L05$		; oui => 05$
	CALL	AFFBLI		; non => affiche flche
L05$:	MOVE.16	{A6}+OBUSTD+ODFFDX,D1 ; D1 <-- largeur d'une ligne
	SUB.16	{A6}+OCX,D1	; D1 <-- laisse un car  droite (curseur)
	ADD.16	D2,D1		; D1 <-- position  ne pas dpasser
L10$:	CALL	NVISU		; D3 <-- caractre suivant
	JUMP,EQ	L20$		; ok => 20$
	COMP.16	#ERHOL,D7	; trou rencontr ?
	JUMP,NE	L60$		; non (EOB) => 60$
	CALL	AFFFLUSH	; vide contenu du buffer
	LIB	?GETCURS	; D3 <-- position du curseur
	MOVE.32	D3,{A5}+OCURS	; mm position du curseur
	MOVE.16	D4,{A5}+ONOL	; mm no ligne
	JUMP	L10$
L20$:	CALL	IFEOL		; fin de la ligne ?
	JUMP,NE	L21$
	CALL	AFFEOL
	JUMP	L80$
				; oui => 80$
L21$:	CALL	AFFTYPO		; affiche le caractre
	CALL	CALLGC		; D2 <-- compte la largeur
	COMP.16	D1,D2		; largeur dpasse ?
	JUMP,LO	L10$		; non => 10$
	CALL	AFFELI		; oui => affiche flche
	CALL	SRCDOWN		; A4 <-- ^dbut ligne suivante
	JUMP	L90$
L60$:	TSET.8	{A5}+OFLAFF:#BAFEOT
	JUMP,BS	L80$
	TEST.8	{A6}+OMODE+3:#BEPRONEOT	; MOD. FJ.
	JUMP,BS	L80$		; MOD. FJ.
	MOVE.8	#EDEOT,D3
	CALL	AFFCAR		; affiche la fin du texte
L80$:	MOVE.8	#EFLI,D3
	CALL	AFFBYTE		; efface la fin de la ligne
L90$:	POPM.32	D1|D2|D3|D4
	RET


;----------\\
; CALOFFSET >
;==========/

; Calcul un ventuel offset au dbut de la ligne si elle
; est trop longue pour simuler un "shift" horizontal.

; in	A4.L	^dbut ligne
;	A2.L	^table des largeurs des caractres
; out	A4.L	^dbut pour affichage
;	D2.W	offset (0..n)
; mod	D2.L, D7.W, A4.L

CALOFFSET:
	PUSHM.32 D1|D3|D4|D6|A2|A3
	MOVE.32	A4,A3		; A3 <-- ^dbut ligne
	CLR.16	D1		; D1 <-- lg avant trou
	CLR.16	D2		; D2 <-- lg totale
	MOVE.32	A3,A4		; A4 <-- ^dbut ligne
L10$:	CALL	NVISU		; D3 <-- caractre suivant
	JUMP,EQ	L20$		; ok => 20$
	COMP.16	#ERHOL,D7	; trou rencontr ?
	JUMP,NE	L30$		; non (EOB) => 30$
				; oui =>
	MOVE.16	D2,D1		; D1 <-- lg avant trou
	JUMP	L10$		; saute le trou (hop)
L20$:	CALL	IFEOL		; fin de la ligne ?
	JUMP,EQ	L30$		; oui => 30$
	CALL	CALLGC		; D3 <-- largeur du caractre
	JUMP	L10$
L30$:
	ADD.16	{A6}+OCX,D2	; D2 <-- compte place du curseur
	ADD.16	{A6}+OCX,D2	; D2 <-- compte place du curseur
	MOVE.32	A3,A4		; A4 <-- ^dbut ligne
	TEST.16	D1		; curseur dans la ligne ?
	JUMP,EQ	L80$		; non => 80$
	MOVE.16	{A6}+OBUSTD+ODFFDX,D4 ; D4 <-- largeur pour ligne
	COMP.16	D4,D2		; place pour toute la ligne ?
	JUMP,LS	L80$		; oui => 80$
				; non =>
	MOVE.16	D4,D3
	SR.16	#1,D3		; D3 <-- moiti de la place
	ADD.16	D3,D1		; avance de 1/2 lg_place
	COMP.16	D2,D1		; trop  droite ?
	JUMP,LS	L50$		; non => 50$
	MOVE.16	D2,D1		; D1 <-- maximum possible
L50$:	SUB.16	D4,D1		; recule de lg_place
	JUMP,LS	L80$		; trop  gauche => 80$
	CLR.16	D2		; D2 <-- position dans ligne
L60$:	CALL	NVISU		; D3 <-- caractre suivant
	JUMP,NE	L70$		; si trou rencontr => 70$
	CALL	CALLGC		; D3 <-- largeur du caractre
	COMP.16	D1,D2		; offset dpass ?
	JUMP,LO	L60$		; non => 60$
	JUMP,EQ	L75$
L70$:	COMP.8	#TAB,D3
	JUMP,NE	L75$
	CALL	PVISU		; recule avant le tabulateur
L75$:	MOVE.16	D1,D2		; D2 <-- offset
	JUMP	L90$
L80$:	CLR.16	D2		; D2 <-- rend un offset nul
L90$:
	MOVE.16	D2,D1
	DIV.16	{A6}+OCX,D1

	MOVE.16	D1,{A6}+OOFFSET	; sauve l'offset
	POPM.32	D1|D3|D4|D6|A2|A3
	RET


;--------\\
; CALLGC  >
;========/

; Calcul la largeur d'un caractre.

; in	D3.B	caractre
;	D2.W	position dans ligne
;	A2.L	^table des largeurs des caractres
; out	D2.W	nouvelle position
; mod	D2.W

CALLGC:	PUSHM.32 D1|D3
	COMP.8	#TAB,D3		; tabulateur ?
	JUMP,EQ	L50$		; oui => 50$
				; non =>
	AND.16	#16'FF,D3
	MOVE.8	{A2}+A16^{D3},D3; D3 <-- largeur du caractre
	ADD.16	D3,D2		; D2 <-- position dans ligne
	JUMP	R8^L90$
L50$:	CLR.16	D3
	MOVE.8	{A2}+SPACE,D3	; D3 <-- largeur d'un espace
	CLR.32	D1
	MOVE.16	D2,D1
	DIV.16	{A6}+OCX,D1	; D1 <-- position en caractres
L60$:	ADD.16	D3,D2		; D2 <-- avance d'un espace
	INC.16	D1
	AND.16	#MSKTAB,D1
	JUMP,NE	L60$
L90$:	POPM.32	D1|D3
	RET


;--------\\
; INKCURS >
;========/

; Inverse le dernier curseur dessin dans l'cran.

; in	-
; out	-
; mod	D7.W

INKCURS:PUSHM.32 D3|D5|A3
	MOVE.16	{A6}+ONOWDT,D5
	LIB	?USEWDO		; utilise swdo du texte
	MOVE.32	#{A6}+OBUCAR,A3	; A3 <-- ^dbut buffer
	MOVE.32	{A5}+OCURS,D3	; D3 <-- position du curseur
	CALL	INVCURS		; enlve le curseur
	CALL	AFFFLUSH	; vide reste du uffer
	CLR.16	D5
	LIB	?USEWDO		; utilise swdo principale
	POPM.32	D3|D5|A3
	RET


;--------\\
; INVCURS >
;========/

; Inverse le curseur sur l'cran.

; in	D3.L	coordonne d'un caractre
;	A3.L	^dans buffer
; out	A3.L	^dans buffer
; mod	D7.W, A3.L

INVCURS:PUSHM.32 D2|D3|D4

	TEST.8	{A6}+OMODE+2:#BEPROEXTEND ; mode etendu ?
	JUMP,BC	NOEXTEND$		  ; non => NOEXTEND$

	TEST.8	{A6}+OMODE+1:#BEPROCURSTR ; curseur trait
	JUMP,BS	TRAIT$
	TEST.8	{A6}+OMODE+1:#BEPROCURSBL ; curseur bloc
	JUMP,BS	BLOC$

NOEXTEND$:
	TSET.8	{A5}+OFLAFF:#BAFCUR ; curseur dj affich ?
	JUMP,BC	L90$		; non => 90$
				; oui =>
TRIANGLE$:
	MOVE.32	D3,D4
	MOVE.8	#TYPOAX,D3	; <typoax>
	CALL	AFFBYTE
	MOVE.16	{A6}+OCX,D3	; D3 <-- largeur du triangle
	SR.16	#1,D3		; D3 <-- demi largeur
	SUB.16	D3,D4		; D4 <-- recule 1/2 caractre
	JUMP,HS	L10$
	CLR.16	D4
L10$:	CALL	AFFWORD		; <xx>
	MOVE.8	#TYPOAY,D3	; <typoay>
	CALL	AFFBYTE
	SWAP.32	D4
	ADD.16	{A6}+OC2Y,D4	; D4 <-- sous ligne de base
	CALL	AFFWORD		; <yy>
	MOVE.8	#MODCAR,D3
	CALL	AFFBYTE
	MOVE.8	#INVDOT,D3	; mode "inverse"
	CALL	AFFBYTE
	MOVE.8	#CODCUR,D3	; affiche le triangle
	CALL	AFFCAR
	MOVE.8	#MODCAR,D3
	CALL	AFFBYTE
	MOVE.8	#SETDOT,D3	; mode "load"
	CALL	AFFBYTE

L90$:	POPM.32	D2|D3|D4
	RET


TRAIT$:
	CALL	AFFFLUSH
	SWAP.32	D3
	SUB.16	{A6}+OC1Y,D3
	SWAP.32	D3
	SUB.16	{A6}+OC1X,D3
	CLR.32	D4
	MOVE.16	{A6}+OC1Y,D4
	ADD.16	{A6}+OC2Y,D4
	SWAP.32	D4
	MOVE.16	#INVDOT,D2
	LIB	?DRSEG
	JUMP	L90$


BLOC$:
	CALL	AFFFLUSH

	PUSHM.32 D3|D4
	MOVE.32	#16'FFFFFFFF,D3
	MOVE.32	D3,D4
	LIB	?DRMDEF
	POPM.32	D3|D4

	SWAP.32	D3
	SUB.16	{A6}+OC1Y,D3
	SWAP.32	D3
	SUB.16	{A6}+OC1X,D3
	CLR.32	D4
	MOVE.16	{A6}+OC1Y,D4
	ADD.16	{A6}+OC2Y,D4
	SWAP.32	D4
	MOVE.16	{A6}+OC1X,D4
	ADD.16	{A6}+OC2X,D4
	MOVE.16	#INVDOT,D2
	LIB	?DRTRAME
	JUMP	L90$


;--------\\
; AFFPLI  >
;========/

; Positionne le curseur au dbut d'une ligne.

; in	D3.W	no de la ligne
;	A3.L	^dans buffer
; out	A3.L	^dans buffer
; mod	D7.W, A3.L

AFFPLI:	PUSHM.32 D3|D4
	MOVE.16	D3,D4		; D4 <-- no ligne
	MOVE.8	#TYPOAY,D3
	CALL	AFFBYTE		; <typoay>
	MUL.16	{A6}+OCY,D4
	ADD.16	{A6}+OC1Y,D4
	CALL	AFFWORD		; <yy>
	MOVE.8	#TYPOAX,D3
	CALL	AFFBYTE		; <typoax>
	MOVE.16	{A6}+OC1X,D4
	CALL	AFFWORD		; <xx>
	MOVE.8	#SPACE,D3
	CALL	AFFCAR		; efface 1er car de la ligne
	POPM.32	D3|D4
	RET


;--------\\
; AFFBLI  >
;========/

; Affiche la flche de dbut de ligne.
; in	-
; out	-
; mod	D7.W

AFFBLI:	PUSHM.32 D3|D4
	MOVE.8	#TYPOAX,D3
	CALL	AFFBYTE		; <typoax>
	CLR.16	D4		; D4 <-- position minimale
	CALL	AFFWORD		; <xx>
	MOVE.8	#AFINV,D3
	CALL	AFFBYTE		; <afinv>
	MOVE.8	#BEGLINE,D3
	CALL	AFFCAR		; <aftout> <begline> <afnorm>
	MOVE.8	#AFDIR,D3
	CALL	AFFBYTE		; <afdir>
	POPM.32	D3|D4
	RET


;--------\\
; AFFEOL  >
;========/

; Affiche le caractre de fin de ligne
; in	-
; out	-
; mod	D7.W

AFFEOL:
	COMP.8	#LF,D3
	JUMP,EQ	AFLF$
	TEST.8	{A6}+OMODE+3:#BEPROAFCR
	JUMP,BS	AFFCAR
	JUMP	AFSP$
AFLF$:	TEST.8	{A6}+OMODE+2:#BEPROAFLF
	JUMP,BS	AFFCAR
AFSP$:	RET


;--------\\
; AFFELI  >
;========/

; Affiche la flche de fin de ligne.
; in	A2.L	^table des largeurs de caractres
; out	-
; mod	D7.W

AFFELI:	PUSHM.32 D3|D4
	MOVE.8	#TYPOAX,D3
	CALL	AFFBYTE		; <typoax>
	MOVE.16	#-1,D4		; D4 <-- position maximale
	CALL	AFFWORD		; <xx>
	MOVE.8	#TYPORX,D3
	CALL	AFFBYTE		; <typorx>
	MOVE.8	#-1,D3		; D3 <-- recule d'un point
	CALL	AFFBYTE		; <x>
	MOVE.8	#AFINV,D3
	CALL	AFFBYTE		; <afinv>
	MOVE.8	#ENDLINE,D3
	CALL	AFFCAR		; <aftout> <endline> <afnorm>
	MOVE.8	#AFDIR,D3
	CALL	AFFBYTE		; <afdir>
	POPM.32	D3|D4
	RET


;--------\\
; AFFTYPO >
;========/

; Affiche un caractre typographique.
; in	D3.B	caractre
;	D2.W	position dans la ligne
;	A3.L	^dans buffer
;	A2.L	^table des largeurs des caractres
; out	A3.L	^plus loin
; mod	D7.W, A3.L

AFFTYPO:COMP.8	#TAB,D3		; tabulateur ?
	JUMP,NE	AFFCAR		; non => affiche le caractre
				; oui =>
	PUSHM.32 D2|D3
	AND.32	#16'FFFF,D2
	DIV.16	{A6}+OCX,D2	; D2 <-- position en caractres

L30$:
	AND.8	#MSKTAB,D2
	COMP.8	#MSKTAB,D2
	JUMP,EQ	L50$

L40$:	CLR.8	D3
	TEST.8	{A6}+OMODE+2:#BEPROAFTAB
	JUMP,BS	L45$
	MOVE.8	#SPACE,D3
L45$:
	CALL	AFFCAR1		; affiche un espace
	INC.8	D2
	AND.8	#MSKTAB,D2	; position modulo 8 ?
	COMP.8	#MSKTAB,D2
	JUMP,NE	L40$
L50$:	MOVE.8	#TAB,D3
	TEST.8	{A6}+OMODE+2:#BEPROAFTAB
	JUMP,BS	L55$
	MOVE.8	#SPACE,D3
L55$:
	CALL	AFFCAR1

FIN$:	POPM.32	D2|D3
	RET


;--------\\
; AFFCAR  >
;========/

; Affiche un caractre.
; in	D3.B	caractre
;	A3.L	^dans buffer
; out	A3.L	^plus loin
; mod	D7.W, A3.L

AFFCAR:	COMP.8	#"",D3		; code spcial ?
	JUMP,HS	AFFBYTE		; non => AFFBYTE
				; oui =>
	COMP.8	#TAB,D3
	JUMP,EQ	AFFBYTE

AFFCAR1:
	PUSH.16	D3
	MOVE.8	#AFTOUT,D3
	CALL	AFFBYTE		; <aftout>
	POP.16	D3
	CALL	AFFBYTE		; <code>
	PUSH.16	D3
	MOVE.8	#AFNORM,D3
	CALL	AFFBYTE		; <afnorm>
	POP.16	D3
	RET


;--------\\
; AFFWORD >
;========/

; Ecrit un word dans l'cran.
; in	D4.W	valeur
;	A3.L	^dans buffer
; out	A3.L	^dans buffer
; mod	D7.W, A3.L

AFFWORD:
	PUSH.16	D3
	MOVE.16	D4,D3
	SR.16	#8,D3
	CALL	AFFBYTE		; <valeur-high>
	MOVE.8	D4,D3
	CALL	AFFBYTE		; <valeur-low>
	POP.16	D3
	RET


;--------\\
; AFFBYTE >
;========/

; Affiche un byte.
; in	D3.B	byte
;	A3.L	^dans buffer
; out	A3.L	^plus loin
; mod	D7.W, A3.L

AFFBYTE:PUSH.32	A4
	MOVE.8	D3,{A3+}	; buffer <-- caractre
	MOVE.32	#{A6}+OBUCAR+LBUCAR,A4
	COMP.32	A4,A3		; buffer plein ?
	JUMP,NE	L90$		; non => 90$
				; oui =>
	CALL	AFFFLUSH	; vide le buffer
L90$:	POP.32	A4
	RET


;---------\\
; AFFFLUSH >
;=========/

; Vide le contenu du buffer.
; in	A3.L	^dans buffer
; out	A3.L	^nouveau
; mod	D7.W, A3.L

AFFFLUSH:
	PUSH.32	D3
	MOVE.32	A3,D3		; D3 <-- ^fin du buffer
	MOVE.32	#{A6}+OBUCAR,A3	; A3 <-- ^dbut du buffer
	SUB.32	A3,D3		; D3 <-- lg dans buffer
	JUMP,EQ	L90$
	LIB	?STRING
L90$:	POP.32	D3
	RET




; Gestion du buffer de texte
; --------------------------
; Utilisation des 4 pointeurs principaux dans un buffer de
; texte non compactifi:
;
;	OPDB	       OPDT		   OPFT		OPFB
;	 !		!		    !		 !
;	!--------------!-------------------!------------!
;	!ABCDEFGHIJKLMN!     t r o u       !OPQRSTUVWXYZ!
;	!--------------!-------------------!------------!
;					   (*)
;	premire partie			   deuxime partie
;	du texte			   du texte
;
;  (*)	Correspond au caractre "sous" le curseur.
; Observation dans un buffer
; --------------------------


;--------\\
; NVISU   >
;========/

; Observation dans un buffer en avanant, mais sans dplacer
; le trou.

; in	A5.L	^description d'un buffer trou
;	A4.L	^dans un buffer
; out	D7.W	zro =>
;	 D3.B	 caractre
;	 A4.L	 ^plus loin
;	D7.W	ERHOL => trou rencontr (et saut)
;	 A4.L	 ^plus loin
;	D7.W	EREOB => on ne peut plus avancer
; mod	D3.W, D7.W, A4.L

NVISU:	COMP.32	{A5}+OPDT,A4	; trou rencontr ?
	JUMP,NE	L10$		; non => 10$
				; oui =>
	MOVE.32	{A5}+OPFT,A4	; saute-le (hop) ...
	MOVE.16	#ERHOL,D7	; D7 <-- erreur "trou"
	RET
L10$:	COMP.32	{A5}+OPFB,A4	; fin du buffer ?
	JUMP,NE	L20$		; non => 20$
				; oui =>
	MOVE.16	#EREOB,D7	; D7 <-- erreur "eob"
	RET
L20$:	MOVE.8	{A4+},D3	; D3 <-- un caractre
	CLR.16	D7		; D7 <-- ok
	RET


;--------\\
; PVISU   >
;========/

; Observation dans un buffer en reculant, mais sans dplacer
; le trou.

; in	A5.L	^description d'un buffer trou
;	A4.L	^dans un buffer
; out	D7.W	zro =>
;	 D3.B	 caractre
;	 A4.L	 ^plus loin
;	D7.W	ERHOL => trou rencontr (et saut)
;	 A4.L	 ^plus loin
;	D7.W	ERBOB => on ne peut plus reculer
; mod	D3.W, D7.W, A4.L

PVISU:	COMP.32	{A5}+OPFT,A4	; trou rencontr ?
	JUMP,NE	L10$		; non => 10$
				; oui =>
	MOVE.32	{A5}+OPDT,A4	; saute-le (hop) ...
	MOVE.16	#ERHOL,D7	; D7 <-- erreur "trou"
	RET
L10$:	COMP.32	{A5}+OPDB,A4	; dbut du buffer ?
	JUMP,NE	L20$		; non => 20$
				; oui =>
	MOVE.16	#ERBOB,D7	; D7 <-- erreur "bob"
	RET
L20$:	MOVE.8	{-A4},D3	; D3 <-- un caractre
	CLR.16	D7		; D7 <-- ok
	RET


; Dplacements dans un buffer
; ---------------------------

;--------\\
; VAFIN   >
;========/

; Avance le curseur tout  la fin d'un buffer trou.

; in	A5.L	^description du buffer trou
; out	-
; mod	-

VAFIN:	PUSH.32	A4
	MOVE.32	{A5}+OPFB,A4
	CALL	VAQQPART	; avance  la fin
	POP.32	A4
	RET


;--------\\
; VADEBUT >
;========/

; Recule le curseur tout au dbut d'un buffer trou.

; in	A5.L	^description du buffer trou
; out	-
; mod	-

VADEBUT:PUSH.32	A4
	MOVE.32	{A5}+OPDB,A4
	CALL	VAQQPART	; recule au dbut
	POP.32	A4
	RET


;---------\\
; VAQQPART >
;=========/

; Avance ou recule n'importe o dans un buffer trou.
; ATTENTION: A4 ne doit pas pointer  l'intrieur du trou !

; in	A5.L	^description du buffer trou
;	A4.L	^o aller
; out	-
; mod	-

VAQQPART:
	PUSHM.32 D4|A3|A4
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	COMP.32	{A5}+OPDB,A4				;;
	JUMP,LO	FATQQP					;;
	COMP.32	{A5}+OPDT,A4				;;
	JUMP,LS	L10$					;;
	COMP.32	{A5}+OPFT,A4				;;
	JUMP,LO	FATQQP					;;
	COMP.32	{A5}+OPFB,A4				;;
	JUMP,HI	FATQQP					;;
L10$:							;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	COMP.32	{A5}+OPFT,A4
	JUMP,EQ	L90$		; si on y est dj => 90$
	JUMP,HI	L50$		; si avance => 50$
				; si recule =>
	MOVE.32	{A5}+OPDT,D4
	SUB.32	A4,D4		; D4 <-- lg  reculer
	JUMP,EQ	L90$
	MOVE.32	{A5}+OPFT,A4
	MOVE.32	{A5}+OPDT,A3
L30$:	MOVE.8	{-A3},{-A4}	; recule le trou ...
	DEC.32	D4
	JUMP,NE	L30$
	JUMP	R8^L80$
L50$:	SUB.32	{A5}+OPFT,A4
	MOVE.32	A4,D4		; D4 <-- lg  avancer
	MOVE.32	{A5}+OPFT,A4
	MOVE.32	{A5}+OPDT,A3
L60$:	MOVE.8	{A4+},{A3+}	; avance le trou ...
	DEC.32	D4
	JUMP,NE	L60$
L80$:	MOVE.32	A4,{A5}+OPFT
	MOVE.32	A3,{A5}+OPDT
L90$:	MOVE.8	#MODCUR,D4	; D4 <-- curseur dplac
	CALL	MODIF		; signal type de modification
	POPM.32	D4|A3|A4
	RET

FATQQP:	.16	16'A042
	.ASCIZE	"<CR>Erreur fatale dans VAQQPART<CR>"
	TRAP	#0


;--------\\
; AVANCE  >
;========/

; Avance d'un caractre dans un buffer trou.

; in	A5.L	^description du buffer trou
; out	D7.W	zro =>
;	 D3.B	 caractre avanc
;	D7.W	EREOB (end of buffer)
; mod	D3.W, D7.W

AVANCE:	PUSHM.32 D4|A4
	MOVE.32	{A5}+OPFT,A4
	COMP.32	{A5}+OPFB,A4	; est-on  la fin ?
	JUMP,NE	L50$		; non => 50$
				; oui =>
	MOVE.16	#EREOB,D7	; D7 <-- erreur
	JUMP	R8^L90$
L50$:	MOVE.8	{A4+},D3	; D3 <-- caractre
	MOVE.32	A4,{A5}+OPFT
	MOVE.32	{A5}+OPDT,A4
	MOVE.8	D3,{A4+}	; remet le caractre de l'autre
	MOVE.32	A4,{A5}+OPDT	; ct du trou.
	MOVE.8	#MODCUR,D4	; D4 <-- curseur dplac
	CALL	MODIF		; signal type de modification
	CLR.16	D7		; D7 <-- ok
L90$:	POPM.32	D4|A4
	RET


;--------\\
; RECULE  >
;========/

; Recule d'un caractre dans un buffer trou.
; in	A5.L	^description du buffer
; out	D7.W	zro =>
;	 D3.B	 caractre avanc
;	D7.W	ERBOB (begin of buffer)
; mod	D3.W, D7.W

RECULE:	PUSHM.32 D4|A4
	MOVE.32	{A5}+OPDT,A4
	COMP.32	{A5}+OPDB,A4	; est-on au dbut ?
	JUMP,NE	L50$		; non => 50$
				; oui =>
	MOVE.16	#ERBOB,D7	; D7 <-- erreur
	JUMP	R8^L90$
L50$:	MOVE.8	{-A4},D3	; D3 <-- caractre
	MOVE.32	A4,{A5}+OPDT
	MOVE.32	{A5}+OPFT,A4
	MOVE.8	D3,{-A4}	; remet le caractre de l'autre
	MOVE.32	A4,{A5}+OPFT	; ct du trou.
	MOVE.8	#MODCUR,D4	; D4 <-- curseur dplac
	CALL	MODIF		; signal type de modification
	CLR.16	D7		; D7 <-- ok
L90$:	POPM.32	D4|A4
	RET


; Insertions et destructions dans un buffer
; -----------------------------------------

;--------\\
; INSERT  >
;========/

; Insre un caractre dans un buffer trou.

; in	A5.L	^description du buffer trou
;	D3.B	caractre  insrer
; out	D7.W	zro => ok
;	D7.W	ERPDP => buffer plein
; mod	D7.W

INSERT:	PUSHM.32 D4|A4
	MOVE.32	{A5}+OPDT,A4
	INC.32	A4		; doit rester au moins un !
	COMP.32	{A5}+OPFT,A4	; reste de la place ?
	JUMP,LO	L50$		; oui => 50$
				; non =>
	MOVE.16	#ERPDP,D7	; D7 <-- erreur
	JUMP	R8^L90$
L50$:	CALL	EXOTHER
	MOVE.8	D3,{A4}-1	; buffer <-- caractre
	MOVE.32	A4,{A5}+OPDT
	MOVE.8	#MODALL,D4	; D4 <-- tout modifi
	CALL	IFEOL		; fin de ligne ?
	JUMP,EQ	L70$		; oui => 70$
	MOVE.8	#MODLIN,D4	; D4 <-- ligne modifie
L70$:	CALL	MODIF		; signal type de modification
	TSET.8	{A5}+OSTATUS:#BFILMOD ; fichier pas  jour
	CLR.16	D7		; D7 <-- ok
L90$:	POPM.32	D4|A4
	RET


;--------\\
; DAVANCE >
;========/

; Dtruit un caractre en avant dans un buffer trou.
; Action quivalente  (DEL), c'est--dire dtruit le caractre
; situ sous le curseur.

; in	A5.L	^description du buffer
; out	D7.W	zro =>
;	 D3.B	 caractre dtruit
;	D7.W	EREOB (end of buffer)
; mod	D3.W, D7.W

DAVANCE:PUSHM.32 D4|A4
	MOVE.32	{A5}+OPFT,A4
	COMP.32	{A5}+OPFB,A4	; est-on  la fin ?
	JUMP,NE	L10$		; non => 10$
				; oui =>
	MOVE.16	#EREOB,D7	; D7 <-- erreur
	JUMP	R8^L90$
L10$:	MOVE.8	{A4+},D3	; D3 <-- caractre dtruit
	MOVE.32	A4,{A5}+OPFT
	MOVE.8	#MODALL,D4	; D4 <-- tout modifi
	CALL	IFEOL		; fin de ligne ?
	JUMP,EQ	L70$		; oui => 70$
	MOVE.8	#MODLIN,D4	; D4 <-- ligne modifie
L70$:	CALL	MODIF		; signal type de modification
	TSET.8	{A5}+OSTATUS:#BFILMOD ; fichier pas  jour
	CLR.16	D7		; D7 <-- ok
L90$:	POPM.32	D4|A4
	RET


;--------\\
; DRECULE >
;========/

; Dtruit un caractre en arrire dans un buffer trou.
; Action quivalente  (BS), c'est--dire dtruit le caractre
; situ  gauche du curseur.

; in	A5.L	^description du buffer
; out	D7.W	zro =>
;	 D3.B	 caractre dtruit
;	D7.W	ERBOB (begin of buffer)
; mod	D3.W, D7.W

DRECULE:PUSHM.32 D4|A4
	MOVE.32	{A5}+OPDT,A4
	COMP.32	{A5}+OPDB,A4	; est-on au dbut ?
	JUMP,NE	L10$		; non => 10$
				; oui =>
	MOVE.16	#ERBOB,D7	; D7 <-- erreur
	JUMP	R8^L90$
L10$:	MOVE.8	{-A4},D3	; D3 <-- caractre dtruit
	MOVE.32	A4,{A5}+OPDT
	MOVE.8	#MODALL,D4	; D4 <-- tout modifi
	CALL	IFEOL		; fin de ligne ?
	JUMP,EQ	L70$		; oui => 70$
	MOVE.8	#MODLIN,D4	; D4 <-- ligne modifie
L70$:	CALL	MODIF		; signal type de modification
	TSET.8	{A5}+OSTATUS:#BFILMOD ; fichier pas  jour
	CLR.16	D7		; D7 <-- ok
L90$:	POPM.32	D4|A4
	RET


;--------\\
; FLUSH   >
;========/

; Vide compltement un buffer.
; in	A5.L	^description du buffer
; out	-
; mod	D7.W

FLUSH:	PUSH.32	D4
	CALL	EXOTHER		; pas rcuprable !
	MOVE.32	{A5}+OPDB,{A5}+OPDT
	MOVE.32	{A5}+OPFB,{A5}+OPFT
	TCLR.8	{A5}+OSTATUS:#BFILMOD
	MOVE.8	#MODALL,D4	; D4 <-- tout modifi
	CALL	MODIF		; signal type de modification
	POP.32	D4
	RET


;--------\\
; GETPTC  >
;========/

; Donne le caractre sous le pointeur.
; in	A5.L	^description d'un buffer trou
; out	D7.W	zro => ok
;	 D3.B	 caractre
;	D7.W	EREOB => fin du buffer
; mod	D3.W, D7.W

GETPTC:	PUSH.32	A4
	MOVE.32	{A5}+OPFT,A4
	COMP.32	{A5}+OPFB,A4	; fin du buffer ?
	JUMP,NE	L10$		; non => 10$
				; oui =>
	MOVE.16	#EREOB,D7	; D7 <-- erreur
	JUMP	R8^L90$
L10$:	MOVE.8	{A4},D3		; D3 <-- caractre
	CLR.16	D7		; D7 <-- ok
L90$:	POP.32	A4
	RET


;--------\\
; MODIF   >
;========/

; Mmorise le type de modification effectue dans le texte
; pour n'afficher que le minimum.

; in	D4.B	type de modification
; out	-
; mod	-

MODIF:	COMP.8	{A5}+OMODIF,D4	; modification plus importante ?
	JUMP,LS	L90$		; non => 90$
	MOVE.8	D4,{A5}+OMODIF	; oui => mmorise-la
L90$:	RET


;--------\\
; IFEOL   >
;========/

; Test si le caractre dans D3.B est une fin de ligne.
; in	D3.B	caractre
; out	EQ	fin de ligne
;	NE	autre chose
; mod	-

IFEOL:	COMP.8	#EOL,D3
	JUMP,EQ	L90$
	COMP.8	#EDEOL,D3
L90$:	RET



; Routines diverses
; -----------------


;--------\\
; IFTERM  >
;========/

; Test s'il s'agit d'une touche terminatrice.

; in	-
;	D3.W	touche presse
; out	D7.W	zro => terminatrice
; mod	D7.W

IFTERM:
	PUSHM.32 D4|A4
	MOVE.32	{A6}+OTERM,A4
	MOVE.16	#ERNOT,D7	; D7 <-- retour NE
	MOVE.32	A4,D4		; A4 = ^nil ?
	JUMP,EQ	L90$		; oui => 90$
L10$:	TEST.16	{A4}		; fin de la table ?
	JUMP,EQ	L90$		; oui => 90$
	COMP.16	{A4+},D3	; touche terminatrice ?
	JUMP,NE	L10$		; non => 10$
	CLR.16	D7		; oui => retour EQ
L90$:	POPM.32	D4|A4
	TEST.16	D7		; retour EQ/NE
	RET


;--------\\
; EXKEY   >
;========/

; in	D3.B	touche presse
; out	D4.W	zro (pour les classes)
;	D7.W	zro (utile si sortie)
; mod	D4.W, D7.W, A0.L

EXKEY:	POP.32	A0		; A0 <-- ^table des .WW
	PUSH.16	D3
	COMP.8	#"a",D3		; minuscule ?
	JUMP,LO	L10$		; non => 10$
	COMP.8	#"z",D3
	JUMP,HI	L10$
	SUB.8	#"a"-"A",D3	; oui => transforme
L10$:	SUB.32	#4,A0		; A0 <-- recule .WW
L20$:	ADD.32	#4,A0		; A0 <-- saute .WW
	TEST.16	{A0}		; table termine ?
	JUMP,EQ	L50$		; oui => 50$
				; non =>
	COMP.8	{A0}+1,D3	; code touche trouve ?
	JUMP,NE	L20$		; non => 20$
L50$:	CLR.32	D3
	MOVE.16	{A0}+2,D3
	MOVE.32	D3,A0		; A0 <-- adresse relative
	ADD.32	{A6}+OSTART,A0	; A0 <-- adresse absolue
	POP.16	D3
	CLR.16	D4		; D4 <-- zro (pour les classes)
	CLR.16	D7		; D7 <-- ok
	JUMP	{A0}		; excute ...


;--------\\
; EXFONC  >
;========/

; in	D3.W	touche fonction (dans high)
; out	-
; mod	A0.L

EXFONC:	POP.32	A0		; A0 <-- ^table des .WW
	PUSH.16	D3
	SR.16	#8,D3		; D3 <-- touche fonction
	SUB.32	#4,A0		; A0 <-- recule .WW
L20$:	ADD.32	#4,A0		; A0 <-- saute .WW
	TEST.16	{A0}		; table termine ?
	JUMP,EQ	L50$		; oui => 50$
				; non =>
	COMP.8	{A0}+1,D3	; code touche fonction trouv ?
	JUMP,NE	L20$		; non => 20$
L50$:	CLR.32	D3
	MOVE.16	{A0}+2,D3
	MOVE.32	D3,A0		; A0 <-- adresse relative
	ADD.32	{A6}+OSTART,A0	; A0 <-- adresse absolue
	POP.16	D3
	JUMP	{A0}		; excute ...


;---------\\
; AFSCROLL >
;=========/

; reaffiche l'ascenseur

AFSCROLL:
	TEST.8	{A6}+OMODE+3:#BEPROMOUSE
	JUMP,BC	FIN$

	PUSHM.32 D2..D5|A1|A5

	LIB	?GETWDO
	MOVE.16	D5,D2

	MOVE.16	{A6}+ONOWDA,D5
	LIB	?USEWDO

	MOVE.32	A5,A1
	MOVE.32	#{A6}+OASCENS,A5

	MOVE.32	{A1}+OPDT,D4
	SUB.32	{A1}+OPDB,D4
	MOVE.32	{A1}+OPFB,D5
	SUB.32	{A1}+OPFT,D5
	ADD.32	D5,D4
	MOVE.32	D4,D5
	DIV.16	#2**16-1,D5
	INC.16	D5
	MOVE.16	D5,{A6}+OFACTDIV
	DIV.16	D5,D4
	MOVE.16	D4,{A5}+OSCHTV

	MOVE.32	{A1}+OPDT,D4
	SUB.32	{A1}+OPDB,D4
	DIV.16	D5,D4
	MOVE.16	D4,{A5}+OSCPOSV

	SCROLL_	UPDATE

	MOVE.16	D2,D5
	LIB	?USEWDO

	POPM.32	D2..D5|A1|A5

FIN$:	RET

END_EPRO:
	.END

